/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.order.impl.exit.CommonExitImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.service.third.MqPushService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SubChannelCarOrderExitServiceImpl
extends CommonExitImpl {
    private static final Logger log = LoggerFactory.getLogger(SubChannelCarOrderExitServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MqPushService pushService;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OrderService orderService;

    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        Long regionId = paramHolder.getParkChannel().getRegionId();
        this.subChannelExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);
        this.saveTrack(exitRequest, paramHolder.getParkChannel().getRegionId(), oddStatus);
        if (exitRequest.getType().equals(PlateTypeEnum.\u6708\u5361\u8f66.getType())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.monthCarService.innerAreaExitAbMonthDeal(parkId, exitRequest.getPlateNum(), exitRequest.getExitTime(), regionId)));
        }
        this.asyncHandler(exitRequest, parkId, orderNum, orderInfo, null, oddStatus);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }

    private void subChannelExit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus, Long parkId, String orderNum, OrderInfo orderInfo, Long regionId) {
        OrderSonCarInfo sonCarInfo;
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
        AssertTools.notNull((Object)parkRegion, (String)"400", (String)CodeConstants.getName((String)"400"));
        if (!Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) && regionId.equals(orderInfo.getRegionId())) {
            OrderSonInfo orderSonInfo = new OrderSonInfo();
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setRegionId(regionId);
            orderSonInfo.setParkId(parkId);
            orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
            ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
            if (orderSonInfo == null) {
                orderSonInfo = new OrderSonInfo();
                BeanUtils.copyProperties((Object)orderInfo, (Object)orderSonInfo);
                orderSonInfo.setServiceStatus(status);
                orderSonInfo.setOddStatus(oddStatus);
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                this.setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);
                this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
                freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
                OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
                OrderSonCarInfo sonCarInfoSub = new OrderSonCarInfo();
                BeanUtils.copyProperties((Object)carInfo, (Object)sonCarInfoSub);
                sonCarInfoSub.setOrderSonId(orderSonInfo.getId());
                sonCarInfoSub.setExitChannelId(exitRequest.getInandoutCode());
                sonCarInfoSub.setExitNo(exitRequest.getInandoutName());
                sonCarInfoSub.setExitImage(exitRequest.getMaxImage());
                sonCarInfoSub.setSmallExitImage(exitRequest.getSmallImage());
                sonCarInfoSub.setExitWay(exitRequest.getExitWay());
                sonCarInfoSub.setExitTerminal(exitRequest.getExitTerminal());
                sonCarInfoSub.setExitOperAccount(exitRequest.getOperAccount());
                sonCarInfoSub.setExitRemark(exitRequest.getExitRemark());
                this.orderSonCarInfoDao.insert((Object)sonCarInfoSub);
                log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
                orderSonInfo = new OrderSonInfo();
                BeanUtils.copyProperties((Object)exitRequest, (Object)orderSonInfo);
                orderSonInfo.setExitTime(null);
                orderSonInfo.setEnterTime(exitRequest.getExitTime());
                orderSonInfo.setOrderNum(orderNum);
                ParkRegion parkRegion1 = this.parkRegionDao.selectOutByParkid(parkId);
                if (parkRegion1 == null) {
                    throw new ResponseBodyException("400", "parkId[" + parkId + "]\u6ca1\u6709\u5916\u533a\u57df");
                }
                ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, exitRequest.getPlateNum(), parkRegion1.getId());
                PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
                orderSonInfo.setType(plateTypeDto.getPlateTypeEnum().getType());
                orderSonInfo.setRegionId(parkRegion1.getId());
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                orderSonInfo.setServiceStatus(Integer.valueOf(1));
                this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
                log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865\u5916\u533a-\u5b50\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
                freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(-1).build());
                this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
                OrderSonCarInfo sonCarInfo2 = new OrderSonCarInfo();
                BeanUtils.copyProperties((Object)exitRequest, (Object)sonCarInfo2);
                sonCarInfo2.setEnterChannelId(exitRequest.getInandoutCode());
                sonCarInfo2.setEnterNo(exitRequest.getInandoutName());
                sonCarInfo2.setEnterImage(exitRequest.getMaxImage());
                sonCarInfo2.setSmallEnterImage(exitRequest.getSmallImage());
                sonCarInfo2.setEnterOperAccount(exitRequest.getOperAccount());
                sonCarInfo2.setEnterReliability(exitRequest.getReliability());
                sonCarInfo2.setOrderSonId(orderSonInfo.getId());
                this.orderSonCarInfoDao.insert((Object)sonCarInfo2);
                log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865\u5916\u533a-\u5b50\u8ba2\u5355\u8f66\u8f86\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
                orderInfo.setHasSon(Integer.valueOf(1));
                orderInfo.setOperAccount(exitRequest.getOperAccount());
                this.orderInfoDao.updateByOrderNum(orderInfo);
                log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u4e3b\u8ba2\u5355\u66f4\u65b0\u4e3ahasSon\u5b57\u6bb5\u4e3a1\uff1a{}", (Object)exitRequest.getPlateNum());
            } else {
                orderSonInfo.setBalancePrice(orderInfo.getBalancePrice());
                orderSonInfo.setServiceStatus(status);
                orderSonInfo.setOddStatus(oddStatus);
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                this.setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);
                this.orderSonInfoDao.updateById((Object)orderSonInfo);
                this.updateRegionFreeSpace(paramHolder, RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
                this.pushService.pushOrderSonExit(orderSonInfo);
            }
            if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)("sub:" + orderSonInfo.getOrderNum())))) {
                this.redisTemplate.delete((Object)("sub:" + orderSonInfo.getOrderNum()));
                log.info("[\u7aef\u4e91-\u5c0f\u573a\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderSonInfo.getOrderNum());
            }
            return;
        }
        OrderSonInfo orderSonInfo = null;
        OrderSonInfo mainOrderSonInfo = null;
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderNum);
        orderSonInfoParam.setParkId(parkId);
        List orderSonInfos = this.orderSonInfoDao.selectList((Object)orderSonInfoParam);
        if (CollectionUtils.isNotEmpty((Collection)orderSonInfos)) {
            Optional<OrderSonInfo> first2;
            Optional<OrderSonInfo> first1 = orderSonInfos.stream().filter(osi -> parkRegion.getFatherRelationId().equals(osi.getRegionId())).findFirst();
            if (first1.isPresent()) {
                mainOrderSonInfo = first1.get();
            }
            if ((first2 = orderSonInfos.stream().filter(osi -> regionId.equals(osi.getRegionId())).findFirst()).isPresent()) {
                orderSonInfo = first2.get();
            }
        }
        ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties((Object)exitRequest, (Object)orderSonInfo);
            ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, exitRequest.getPlateNum(), regionId);
            PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
            orderSonInfo.setType(plateTypeDto.getPlateTypeEnum().getType());
            if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(plateTypeDto.getPlateTypeEnum().getType()) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(plateTypeDto.getPlateTypeEnum().getType())) {
                orderSonInfo.setEnterTime(orderInfo.getEnterTime());
            } else {
                orderSonInfo.setEnterTime(exitRequest.getExitTime());
            }
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setRegionId(regionId);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
            sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties((Object)exitRequest, (Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u8f66\u8f86\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
            orderInfo.setHasSon(Integer.valueOf(1));
            orderInfo.setOperAccount(exitRequest.getOperAccount());
            this.orderInfoDao.updateByOrderNum(orderInfo);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u4e3b\u8ba2\u5355\u66f4\u65b0\u4e3ahasSon\u5b57\u6bb5\u4e3a1\uff1a{}", (Object)exitRequest.getPlateNum());
        } else {
            sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId().longValue());
        }
        if (mainOrderSonInfo == null) {
            this.saveMainOrderSonInfo(orderNum, orderInfo, parkRegion.getFatherRelationId());
        } else {
            this.orderSonInfoDao.setInPark(mainOrderSonInfo.getId().longValue());
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(mainOrderSonInfo.getRegionId()).type(mainOrderSonInfo.getType()).num(-1).build());
        }
        orderSonInfo.setBalancePrice(orderInfo.getBalancePrice());
        orderSonInfo.setServiceStatus(status);
        orderSonInfo.setExitTime(exitRequest.getExitTime());
        orderSonInfo.setOddStatus(oddStatus);
        orderSonInfo.setOperAccount(exitRequest.getOperAccount());
        sonCarInfo.setExitImage(exitRequest.getMaxImage());
        sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
        sonCarInfo.setExitNo(exitRequest.getInandoutName());
        sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
        sonCarInfo.setExitReliability(exitRequest.getReliability());
        sonCarInfo.setExitWay(exitRequest.getExitWay());
        sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
        sonCarInfo.setExitRemark(exitRequest.getExitRemark());
        sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());
        this.setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);
        if (orderSonInfo.getId() == null) {
            orderSonInfo.setNoneEnterFlag(Integer.valueOf(1));
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            sonCarInfo.setOrderSonId(orderSonInfo.getId());
            this.orderSonCarInfoDao.insert((Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u53ca\u8f66\u8f86\u4fe1\u606f\u65b0\u589e\u5b8c\u6210: {} - {}", (Object)orderSonInfo.getId(), (Object)sonCarInfo.getId());
        } else {
            this.orderSonInfoDao.updateById((Object)orderSonInfo);
            this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u4fee\u6539\u5b50\u8ba2\u5355\u53ca\u8f66\u8f86\u4fe1\u606f\u5b8c\u6210: {} - {}", (Object)orderSonInfo.getId(), (Object)sonCarInfo.getId());
            this.pushService.pushOrderSonExit(orderSonInfo);
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }
        this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)("sub:" + orderSonInfo.getOrderNum())))) {
            this.redisTemplate.delete((Object)("sub:" + orderSonInfo.getOrderNum()));
            log.info("[\u7aef\u4e91-\u5c0f\u573a\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderSonInfo.getOrderNum());
        }
    }

    private void setOrderSonPrice(CarExitRequest exitRequest, Integer status, Long parkId, String orderNum, OrderSonInfo orderSonInfo) {
        if (2 == status) {
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(parkId);
            orderPay.setOrderNum(orderNum);
            OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null) {
                orderSonInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                orderSonInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                orderSonInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
            } else {
                orderSonInfo.setTotalPrice("0.00");
                orderSonInfo.setPaidPrice("0.00");
                orderSonInfo.setDiscountPrice("0.00");
            }
        } else {
            orderSonInfo.setTotalPrice(StringUtils.isBlank((CharSequence)exitRequest.getTotalAmount()) ? "0.00" : exitRequest.getTotalAmount());
            orderSonInfo.setPaidPrice(StringUtils.isBlank((CharSequence)exitRequest.getPaidAmount()) ? "0.00" : exitRequest.getPaidAmount());
            orderSonInfo.setDiscountPrice(StringUtils.isBlank((CharSequence)exitRequest.getDiscountAmount()) ? "0.00" : exitRequest.getDiscountAmount());
        }
    }

    private OrderSonInfo saveMainOrderSonInfo(String orderNum, OrderInfo orderInfo, Long regionId) {
        OrderSonInfo orderSonInfoMain = new OrderSonInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)orderSonInfoMain);
        orderSonInfoMain.setRegionId(regionId);
        orderSonInfoMain.setServiceStatus(Integer.valueOf(1));
        orderSonInfoMain.setCreateTime(null);
        this.orderSonInfoDao.insertWithPlateNum2(orderSonInfoMain);
        log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u8868\u7684\u4e3b\u8ba2\u5355\u4fe1\u606f[{}]", (Object)orderSonInfoMain);
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        OrderSonCarInfo sonCarInfoMain = new OrderSonCarInfo();
        BeanUtils.copyProperties((Object)carInfo, (Object)sonCarInfoMain);
        sonCarInfoMain.setOrderSonId(orderSonInfoMain.getId());
        this.orderSonCarInfoDao.insert((Object)sonCarInfoMain);
        log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u4e3b\u79bb\u573a\u8bb0\u5f55\u63d2\u5165\u5b50\u51fa\u5165\u573a\u8bb0\u5f55\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        return orderSonInfoMain;
    }
}

