/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.order.OrderSimpleExitService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.SimpleExitRequest;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.service.order.impl.OrderPayServiceImpl;
import com.icetech.park.service.other.impl.AutopayServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderSimpleExitService")
public class OrderSimpleExitServiceImpl
implements OrderSimpleExitService {
    private static final Logger log = LoggerFactory.getLogger(OrderSimpleExitServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private AutopayServiceImpl autopayService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private OrderPayServiceImpl orderPayService;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Transactional
    public ObjectResponse exit(SimpleExitRequest exitRequest, String parkCode) {
        if (exitRequest.getIsExceptionExit() != null && exitRequest.getIsExceptionExit() == 1) {
            return this.exit(exitRequest, parkCode, 4);
        }
        return this.exit(exitRequest, parkCode, 2);
    }

    public ObjectResponse exit(SimpleExitRequest exitRequest, String parkCode, Integer status) {
        Long parkId = exitRequest.getParkId();
        String orderId = exitRequest.getOrderId();
        String orderNum = exitRequest.getOrderNum();
        if (StringUtils.isBlank((CharSequence)orderId) && StringUtils.isBlank((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"402", (String)"orderId\u4e0d\u5b58\u5728");
        }
        String channelCode = exitRequest.getChannelId();
        ParkInoutdevice parkChannel = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
        if (parkChannel == null) {
            log.info("[\u8f66\u8f86\u79bb\u573a\u670d\u52a1-\u7b80\u5355\u7248] \u901a\u9053\u7f16\u53f7\u65e0\u6548\uff1a{}", (Object)channelCode);
            return ObjectResponse.failed((String)"402", (String)"channelId\u672a\u88ab\u6ce8\u518c");
        }
        String imgFileName = exitRequest.getExitImage();
        if (imgFileName != null && !imgFileName.contains("/image/")) {
            String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
            String[] ymd = date.split("-");
            imgFileName = parkCode + "/image/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/" + exitRequest.getExitImage();
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(orderId);
        orderInfo.setParkId(parkId);
        OrderInfo orderInfoResult = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoResult == null) {
            OrderInfo orderInfoQuery = new OrderInfo();
            orderInfoQuery.setOrderNum(orderNum);
            orderInfoQuery.setParkId(parkId);
            orderInfoResult = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        }
        if (orderInfoResult == null) {
            log.info("[\u79bb\u573a\u670d\u52a1-\u7b80\u5355\u7248] \u672a\u67e5\u8be2\u5230\u5728\u573a\u8ba2\u5355\uff0c\u53c2\u6570\uff1a[{},{}]", (Object)parkId, (Object)orderId);
            return ObjectResponse.success();
        }
        int serviceStatus = orderInfoResult.getServiceStatus();
        if (serviceStatus == 2) {
            log.info("[\u79bb\u573a\u670d\u52a1-\u7b80\u5355\u7248] \u91cd\u590d\u79bb\u573a\uff0c\u91cd\u590d\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)exitRequest);
            return new ObjectResponse("405", CodeConstants.getName((String)"405"));
        }
        orderInfoResult.setServiceStatus(status);
        orderInfoResult.setExitTime(exitRequest.getExitTime());
        orderInfoResult.setTotalPrice(exitRequest.getTotalAmount());
        orderInfoResult.setPaidPrice(exitRequest.getPaidAmount());
        orderInfoResult.setDiscountPrice(exitRequest.getDiscountAmount());
        orderInfoResult.setOddStatus(exitRequest.getExceptionReason());
        if (exitRequest.getType() != null) {
            orderInfoResult.setType(exitRequest.getType());
        }
        if (exitRequest.getCarType() != null) {
            orderInfoResult.setCarType(exitRequest.getCarType());
        }
        orderInfoResult.setExitChannelId(exitRequest.getChannelId());
        this.orderService.updateOrderWithPush(orderInfoResult);
        log.info("[\u79bb\u573a\u670d\u52a1-\u7b80\u5355\u7248] \u4fee\u6539\u8ba2\u5355\u4e3b\u4fe1\u606f\u5b8c\u6210\uff0corderId\uff1a{}", (Object)orderId);
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderInfoResult.getOrderNum());
        OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
        float totalPrice = orderSumFeeDto == null ? 0.0f : orderSumFeeDto.getTotalPrice();
        float discountPrice = orderSumFeeDto == null ? 0.0f : orderSumFeeDto.getDiscountPrice();
        float totalAmount = Float.parseFloat(exitRequest.getTotalAmount());
        float paidAmount = Float.parseFloat(exitRequest.getPaidAmount());
        float discountAmount = Float.parseFloat(exitRequest.getDiscountAmount());
        if (totalPrice < totalAmount && paidAmount + discountAmount == totalAmount) {
            log.info("\u8f66\u724c\u53f7\uff1a{} \u5728\u5e73\u53f0\u8bb0\u5f55\u7684\u603b\u8d39\u7528\u4e3a\uff1a{}\uff0c\u672c\u5730\u4e0a\u62a5\u7684\u603b\u8d39\u7528\u4e3a\uff1a{}", new Object[]{exitRequest.getPlateNum(), Float.valueOf(totalPrice), Float.valueOf(totalAmount)});
            float totalPriceNew = totalAmount - totalPrice;
            float discountPriceNew = discountAmount - discountPrice;
            Long lastPayTime = orderSumFeeDto == null ? null : orderSumFeeDto.getLastPayTime();
            this.saveOrderPay(exitRequest, parkChannel, orderPay, totalPriceNew, discountPriceNew, lastPayTime);
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfoResult.getOrderNum());
        AssertTools.notNull((Object)carInfo, (String)"500", (String)"\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u4e0d\u5b8c\u6574");
        carInfo.setExitImage(imgFileName);
        carInfo.setExitChannelId(exitRequest.getChannelId());
        carInfo.setExitNo(parkChannel.getInandoutName());
        carInfo.setExitReliability(exitRequest.getReliability());
        this.orderCarInfoDao.updateById((Object)carInfo);
        log.info("[\u79bb\u573a\u670d\u52a1-\u7b80\u5355\u7248] \u66f4\u65b0\u8ba2\u5355\u51fa\u5165\u8868\u5b8c\u6210\uff0corderId\uff1a{}", (Object)orderId);
        OrderInfo finalOrderInfoResult = orderInfoResult;
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            this.autopayService.exitNotify(finalOrderInfoResult, parkCode);
            this.sendWebsocketMessage(exitRequest, parkCode, carInfo, finalOrderInfoResult);
            if (exitRequest.getChannelId() != null) {
                ChannelAlarm channelAlarm = new ChannelAlarm();
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(exitRequest.getChannelId());
                channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
                this.channelAlarmDao.update(channelAlarm);
            }
        }));
        return ObjectResponse.success();
    }

    private void saveOrderPay(SimpleExitRequest exitRequest, ParkInoutdevice parkInoutdevice, OrderPay orderPay, float totalPriceNew, float discountPriceNew, Long lastPayTime) {
        List orderDiscounts;
        String tradeNo = CodeTools.GenerateTradeNo();
        orderPay.setTradeNo(tradeNo);
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setIsSync(Integer.valueOf(0));
        orderPay.setTotalPrice(String.valueOf(totalPriceNew));
        orderPay.setPaidPrice(String.valueOf(totalPriceNew - discountPriceNew));
        orderPay.setDiscountPrice(String.valueOf(discountPriceNew));
        orderPay.setPayTime(exitRequest.getExitTime());
        orderPay.setOrderTime(exitRequest.getExitTime());
        orderPay.setLastPayTime(lastPayTime);
        orderPay.setPayDate(new Date(exitRequest.getExitTime() * 1000L));
        orderPay.setPayWay(Integer.valueOf(exitRequest.getPayWay() == null ? 1 : exitRequest.getPayWay()));
        orderPay.setPayChannel(Integer.valueOf(1));
        orderPay.setPayTerminal(parkInoutdevice.getInandoutName());
        this.orderPayService.addOrderPay(orderPay);
        if (discountPriceNew > 0.0f && (orderDiscounts = this.orderDiscountDao.selectByOrderNum(orderPay.getOrderNum(), Integer.valueOf(0))) != null && orderDiscounts.size() > 0) {
            OrderDiscount discount_result = (OrderDiscount)orderDiscounts.get(0);
            this.orderPayService.useDiscount(Double.valueOf(discountPriceNew), exitRequest.getParkId(), tradeNo, exitRequest.getExitTime(), orderPay.getOrderNum(), discount_result);
        }
    }

    private void sendWebsocketMessage(SimpleExitRequest exitRequest, String parkCode, OrderCarInfo carInfo, OrderInfo orderInfo) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(2));
        websocketPushData.setEnterTime(Integer.valueOf(orderInfo.getEnterTime().intValue()));
        websocketPushData.setExitTime(Integer.valueOf(exitRequest.getExitTime().intValue()));
        websocketPushData.setType(exitRequest.getType());
        websocketPushData.setCarType(exitRequest.getCarType());
        websocketPushData.setChannelId(exitRequest.getChannelId());
        websocketPushData.setEnterNo(carInfo.getEnterNo());
        websocketPushData.setExitNo(carInfo.getExitNo());
        websocketPushData.setParkCode(parkCode);
        websocketPushData.setPlateNum(exitRequest.getPlateNum());
        websocketPushData.setPlateColor(carInfo.getPlateColor());
        websocketPushData.setTotalPrice(exitRequest.getTotalAmount());
        websocketPushData.setPaidPrice(exitRequest.getPaidAmount());
        websocketPushData.setDiscountPrice(exitRequest.getDiscountAmount());
        websocketPushData.setPayStatus(String.valueOf(orderInfo.getServiceStatus()));
        websocketPushData.setOrderNum(orderInfo.getOrderNum());
        log.info("sendWebsocketMessage  >> {}", (Object)parkCode);
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)JsonUtils.toString((Object)websocketPushData));
    }
}

