/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.request.ExitRequest;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.order.impl.ExitPayDealServiceImpl;
import com.icetech.park.service.other.impl.AutopayServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderExitService")
public class OrderExitServiceImpl
implements OrderExitService {
    private static final Logger log = LoggerFactory.getLogger(OrderExitServiceImpl.class);
    @Resource
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ExitPayDealServiceImpl exitPayDealService;
    @Autowired
    private AutopayServiceImpl autopayService;
    @Autowired
    private ParkVisitDao parkVisitDao;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected OrderNotpayService orderNotpayService;
    @Autowired
    protected OrderCarInfoService orderCarInfoService;
    private static final ExecutorService FIXED_THREAD_POOL = Executors.newFixedThreadPool(1);

    @Transactional
    public ObjectResponse exit(ExitRequest exitRequest, String parkCode) {
        if (exitRequest.getIsExceptionExit() != null && exitRequest.getIsExceptionExit() == 1) {
            return this.exit(exitRequest, parkCode, 4);
        }
        return this.exit(exitRequest, parkCode, 2);
    }

    public ObjectResponse exit(ExitRequest exitRequest, String parkCode, Integer status) {
        String channelCode = exitRequest.getChannelId();
        if (channelCode == null) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice parkChannel = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
        if (parkChannel == null) {
            return ObjectResponse.failed((String)"402", (String)"channelId\u672a\u88ab\u6ce8\u518c");
        }
        ParkRegion parkRegion = StringUtils.isBlank((CharSequence)exitRequest.getRegionCode()) ? (parkChannel.getRegionId() == null ? null : (ParkRegion)this.parkRegionDao.selectById((Serializable)parkChannel.getRegionId())) : this.parkRegionDao.getRegionByCode(exitRequest.getParkId(), exitRequest.getRegionCode());
        long fatherRelationId = 0L;
        OrderInfo existsOrder = this.orderService.getByLocalOrderNumWithHistory(exitRequest.getParkId(), exitRequest.getOrderId());
        if (parkRegion == null || (fatherRelationId = NumberUtils.toPrimitive((Long)parkRegion.getFatherRelationId())) == 0L || NumberUtils.toPrimitive((Integer)parkChannel.getIsMaster()) == 1) {
            this.saveMasterOrder(parkChannel, exitRequest, parkCode, parkRegion, existsOrder, status);
        } else {
            ParkRegion parentRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)Long.valueOf(fatherRelationId));
            if (parentRegion == null) {
                return ObjectResponse.failed((String)"402", (String)"\u533a\u57df\u6240\u5c5e\u4e3b\u533a\u57df\u4e0d\u5b58\u5728");
            }
            ParkRegion originRegion = null;
            ParkRegion destRegion = null;
            if (parkChannel.getInandoutType() == 1) {
                originRegion = parentRegion;
                destRegion = parkRegion;
            } else {
                originRegion = parkRegion;
                destRegion = parentRegion;
            }
            existsOrder = this.saveSonOrder(exitRequest, parkCode, originRegion, destRegion, parkChannel, existsOrder, status);
        }
        if (existsOrder == null) {
            return ObjectResponse.success();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderId", existsOrder.getLocalOrderNum());
        map.put("orderNum", existsOrder.getOrderNum());
        return ObjectResponse.success(map);
    }

    private void saveMasterOrder(ParkInoutdevice parkChannel, ExitRequest exitRequest, String parkCode, ParkRegion parkRegion, OrderInfo existsOrder, Integer status) {
        String version;
        ObjectResponse parkResp;
        List paidInfo;
        AssertTools.notNull((Object)existsOrder, (String)"200", (String)"\u672a\u627e\u5230\u5165\u573a\u8bb0\u5f55");
        int serviceStatus = existsOrder.getServiceStatus();
        if (serviceStatus == 2 && exitRequest.getExitTime().equals(existsOrder.getExitTime())) {
            log.info("[\u79bb\u573a\u670d\u52a1] \u91cd\u590d\u79bb\u573a\uff0c\u91cd\u590d\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)exitRequest);
            return;
        }
        existsOrder.setServiceStatus(status);
        existsOrder.setExitTime(exitRequest.getExitTime());
        existsOrder.setOperAccount(StringUtils.isNotBlank((CharSequence)exitRequest.getOperAccount()) ? exitRequest.getOperAccount() : exitRequest.getUserAccount());
        existsOrder.setOddStatus(exitRequest.getExceptionReason());
        existsOrder.setType(exitRequest.getType());
        existsOrder.setCarType(exitRequest.getCarType());
        this.fillAmount(exitRequest, existsOrder);
        OrderCarInfo carInfo = this.orderCarInfoService.getByOrderNumWithHistory(existsOrder.getOrderNum());
        AssertTools.notNull((Object)carInfo, (String)"500", (String)"\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u4e0d\u5b8c\u6574");
        OrderCarInfo updateCarInfo = new OrderCarInfo();
        updateCarInfo.setId(carInfo.getId());
        String imgFileName = this.fillImage(exitRequest.getExitImage(), parkCode);
        updateCarInfo.setExitImage(imgFileName);
        updateCarInfo.setSmallExitImage(exitRequest.getSmallImage());
        updateCarInfo.setExitNo(parkChannel.getInandoutName());
        updateCarInfo.setExitChannelId(exitRequest.getChannelId());
        updateCarInfo.setExitWay(exitRequest.getInoutEvent());
        updateCarInfo.setExitTerminal(exitRequest.getExTerminal());
        updateCarInfo.setExitOperAccount(exitRequest.getOperAccount());
        updateCarInfo.setExitRemark(exitRequest.getRemark());
        if (StringUtils.isNotEmpty((CharSequence)exitRequest.getPlateColor())) {
            updateCarInfo.setPlateColor(exitRequest.getPlateColor());
        }
        List orderSonInfos = null;
        if (NumberUtils.toPrimitive((Integer)existsOrder.getHasSon()) == 1) {
            orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)exitRequest.getParkId())).eq(OrderInfo::getOrderNum, (Object)existsOrder.getOrderNum())).in(OrderInfo::getServiceStatus, new Object[]{1, 2, 4}));
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = BigDecimal.ZERO;
            BigDecimal balancePrice = BigDecimal.ZERO;
            for (OrderSonInfo orderSonInfo : orderSonInfos) {
                if (orderSonInfo.getServiceStatus() == 1 || orderSonInfo.getRegionId().equals(parkRegion.getId())) {
                    this.handleOrderSon(parkCode, exitRequest, parkRegion, parkChannel, existsOrder, new OrderCarInfoWrapper(updateCarInfo), orderSonInfo, status);
                }
                log.debug("\u7aef\u7f51\u4e91\u5b50\u8ba2\u5355\u79bb\u573a\u5904\u7406|{}|{}", (Object)existsOrder.getOrderNum(), (Object)orderSonInfo);
                totalAmount = NumberUtils.decimalAdd((Object)totalAmount, (Object[])new Object[]{orderSonInfo.getTotalPrice()});
                paidAmount = NumberUtils.decimalAdd((Object)paidAmount, (Object[])new Object[]{orderSonInfo.getPaidPrice()});
                discountAmount = NumberUtils.decimalAdd((Object)discountAmount, (Object[])new Object[]{orderSonInfo.getDiscountPrice()});
                balancePrice = NumberUtils.decimalAdd((Object)balancePrice, (Object[])new Object[]{orderSonInfo.getBalancePrice()});
            }
            existsOrder.setTotalPrice(totalAmount.toString()).setPaidPrice(paidAmount.toString()).setDiscountPrice(discountAmount.toString()).setBalancePrice(balancePrice);
        }
        if ((paidInfo = exitRequest.getPaidInfo()) != null) {
            this.exitPayDealService.exitPayDeal((ExitCommonRequest)exitRequest, existsOrder, orderSonInfos);
        }
        existsOrder.setExitChannelId(exitRequest.getChannelId());
        this.orderService.updateOrderWithPush(existsOrder);
        log.info("[\u79bb\u573a\u670d\u52a1] \u4fee\u6539\u8ba2\u5355\u4e3b\u4fe1\u606f\u5b8c\u6210\uff0corderId\uff1a{}", (Object)exitRequest.getOrderId());
        this.orderCarInfoService.updateByIdWithHistory(updateCarInfo);
        if (CollectionUtils.isNotEmpty(orderSonInfos)) {
            this.orderSonInfoService.updateBatchById(orderSonInfos);
        }
        this.exitPayDealService.handleNotPayOrder((ExitCommonRequest)exitRequest, existsOrder, parkChannel, parkCode);
        if (orderSonInfos == null && ObjectResponse.isSuccess((Response)(parkResp = this.parkService.findByParkId(existsOrder.getParkId()))) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(existsOrder.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex()) {
            OrderTrack orderTrack = new OrderTrack().setRecordType(Integer.valueOf(2)).setParkId(existsOrder.getParkId()).setRegionId(existsOrder.getRegionId()).setChannelName(updateCarInfo.getExitNo()).setOrderNum(existsOrder.getOrderNum()).setEnexTime(Long.valueOf(exitRequest.getExitTime() == null ? 0L : exitRequest.getExitTime())).setPlateNum(exitRequest.getPlateNum()).setType(existsOrder.getType()).setImage(updateCarInfo.getExitImage()).setInoutEvent(Integer.valueOf(0));
            this.orderTrackService.save((Object)orderTrack);
        }
        this.asyncHandler(exitRequest, parkCode, exitRequest.getParkId(), exitRequest.getOrderId(), existsOrder, carInfo);
    }

    private OrderInfo saveSonOrder(ExitRequest exitRequest, String parkCode, ParkRegion originRegion, ParkRegion destRegion, ParkInoutdevice parkChannel, OrderInfo mainOrder, int status) {
        List orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)exitRequest.getParkId())).eq(OrderInfo::getLocalOrderNum, (Object)exitRequest.getOrderId()));
        Map orderSonInfoMap = orderSonInfos.stream().collect(Collectors.toMap(OrderInfo::getRegionId, Function.identity(), (older, newer) -> newer, HashMap::new));
        OrderSonInfo originOrderSon = (OrderSonInfo)orderSonInfoMap.get(originRegion.getId());
        OrderSonInfo destOrderSon = (OrderSonInfo)orderSonInfoMap.get(destRegion.getId());
        OrderCarInfo mainCarInfo = null;
        if (mainOrder == null) {
            mainOrder = new OrderInfo();
            BeanUtils.copyProperties((Object)exitRequest, (Object)mainOrder);
            mainOrder.setOrderNum(CodeTools.GenerateOrderNum()).setLocalOrderNum(exitRequest.getOrderId()).setEnterTime(exitRequest.getExitTime()).setExitTime(null).setServiceStatus(Integer.valueOf(1)).setHasSon(Integer.valueOf(1)).setNoneEnterFlag(Integer.valueOf(1));
            String regionName = null;
            if (NumberUtils.toPrimitive((Long)originRegion.getFatherRelationId()) == 0L) {
                mainOrder.setRegionId(originRegion.getId());
                regionName = originRegion.getRegionName();
            } else if (NumberUtils.toPrimitive((Long)destRegion.getFatherRelationId()) == 0L) {
                mainOrder.setRegionId(destRegion.getId());
                regionName = destRegion.getRegionName();
            } else {
                throw new ResponseBodyException("402", "\u4e24\u4e2a\u5b50\u533a\u57df\u65e0\u6cd5\u5207\u6362");
            }
            this.orderInfoDao.insert((Object)mainOrder);
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u8865\u5145\u4e3b\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210\uff0corderNum\uff1a{}\uff0c\u533a\u57df\u540d\u79f0\uff1a{}", (Object)mainOrder.getOrderNum(), (Object)regionName);
            mainCarInfo = this.buildCarInfo(parkCode, exitRequest, mainOrder, parkChannel);
            this.orderCarInfoDao.insert((Object)mainCarInfo);
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u8865\u5145\u4e3b\u8ba2\u5355\u8f66\u8f86\u4fe1\u606f\u5b8c\u6210\uff0corderNum\uff1a{}\uff0c\u533a\u57df\u540d\u79f0\uff1a{}", (Object)mainOrder.getOrderNum(), (Object)regionName);
        } else if (NumberUtils.toPrimitive((Integer)mainOrder.getHasSon()) == 0) {
            mainOrder.setHasSon(Integer.valueOf(1));
            OrderInfo updateMain = new OrderInfo().setId(mainOrder.getId()).setHasSon(Integer.valueOf(1));
            this.orderInfoDao.updateById((Object)updateMain);
        }
        OrderCarInfoWrapper mainCarInfoWrapper = new OrderCarInfoWrapper(mainCarInfo);
        originOrderSon = this.handleOrderSon(parkCode, exitRequest, originRegion, parkChannel, mainOrder, mainCarInfoWrapper, originOrderSon, status);
        destOrderSon = this.handleOrderSon(parkCode, exitRequest, destRegion, parkChannel, mainOrder, mainCarInfoWrapper, destOrderSon, 1);
        List paidInfo = exitRequest.getPaidInfo();
        if (paidInfo != null) {
            this.exitPayDealService.exitPayDeal((ExitCommonRequest)exitRequest, (OrderInfo)originOrderSon, null);
        }
        this.exitPayDealService.handleNotPayOrder((ExitCommonRequest)exitRequest, (OrderInfo)originOrderSon, parkChannel, parkCode);
        ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(exitRequest.getParkId(), mainOrder.getPlateNum(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (parkVisit != null) {
            parkVisit.setVisitStatus(Integer.valueOf(3));
            parkVisit.setOrderNum(mainOrder.getOrderNum());
            parkVisit.setExitTime(Integer.valueOf(Math.toIntExact(exitRequest.getExitTime())));
            this.parkVisitDao.updateVisit(parkVisit);
            log.info("[\u79bb\u573a\u670d\u52a1-\u5b50\u533a\u57df] \u66f4\u65b0\u8bbf\u5ba2\u9884\u7ea6\u8868\u5b8c\u6210\uff0corderId\uff1a{}", (Object)exitRequest.getOrderId());
        }
        OrderSonInfo notifyOrder = originOrderSon;
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.autopayService.exitNotify((OrderInfo)notifyOrder, parkCode)));
        return originOrderSon;
    }

    private OrderSonInfo handleOrderSon(String parkCode, ExitRequest request, ParkRegion parkRegion, ParkInoutdevice parkChannel, OrderInfo mainOrder, OrderCarInfoWrapper mainCarInfoWrapper, OrderSonInfo orderSonInfo, int targetStatus) {
        String version;
        ObjectResponse parkResp;
        Long exitTime;
        Long l = exitTime = targetStatus != 1 && (mainOrder.getServiceStatus() != 1 || !mainOrder.getRegionId().equals(parkRegion.getId())) ? request.getExitTime() : null;
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            OrderSonCarInfo orderSonCarInfo = null;
            if (mainOrder.getRegionId().equals(parkChannel.getRegionId())) {
                BeanUtils.copyProperties((Object)mainOrder, (Object)orderSonInfo);
                orderSonCarInfo = new OrderSonCarInfo();
                if (mainCarInfoWrapper.orderCarInfo == null) {
                    mainCarInfoWrapper.orderCarInfo = this.orderCarInfoDao.selectByOrderNum(mainOrder.getOrderNum());
                }
                BeanUtils.copyProperties((Object)mainCarInfoWrapper.orderCarInfo, (Object)orderSonCarInfo);
            } else {
                BeanUtils.copyProperties((Object)request, (Object)orderSonInfo);
                orderSonInfo.setRegionId(parkChannel.getRegionId()).setOrderNum(mainOrder.getOrderNum()).setLocalOrderNum(request.getOrderId()).setEnterTime(request.getExitTime()).setExitTime(exitTime).setNoneEnterFlag(Integer.valueOf(targetStatus == 1 ? 0 : 1));
            }
            orderSonInfo.setServiceStatus(Integer.valueOf(targetStatus));
            if (orderSonInfo.getRegionId().equals(parkRegion.getId())) {
                this.fillAmount(request, (OrderInfo)orderSonInfo);
            }
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            if (orderSonCarInfo == null) {
                orderSonCarInfo = (OrderSonCarInfo)this.buildCarInfo(parkCode, request, (OrderInfo)orderSonInfo, parkChannel);
            }
            orderSonCarInfo.setOrderSonId(orderSonInfo.getId());
            if (StringUtils.isNotEmpty((CharSequence)request.getPlateColor())) {
                orderSonCarInfo.setPlateColor(request.getPlateColor());
            }
            this.orderSonCarInfoDao.insert((Object)orderSonCarInfo);
        } else if (targetStatus == 1) {
            this.orderSonInfoDao.setInPark(orderSonInfo.getId().longValue());
        } else {
            OrderSonInfo updateOrderSon = new OrderSonInfo();
            if (!orderSonInfo.getRegionId().equals(mainOrder.getRegionId()) && !orderSonInfo.getRegionId().equals(parkChannel.getRegionId()) && orderSonInfo.getExitTime() == null) {
                exitTime = PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderSonInfo.getType()) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(orderSonInfo.getType()) ? request.getExitTime() : orderSonInfo.getEnterTime();
                log.debug("====> {}, {}, {}", new Object[]{orderSonInfo, mainOrder, parkChannel});
                updateOrderSon.setNoneExitFlag(Integer.valueOf(1));
                orderSonInfo.setNoneExitFlag(Integer.valueOf(1));
            }
            orderSonInfo.setServiceStatus(Integer.valueOf(targetStatus)).setExitTime(exitTime);
            updateOrderSon.setId(orderSonInfo.getId()).setServiceStatus(Integer.valueOf(targetStatus)).setExitTime(exitTime);
            if (orderSonInfo.getRegionId().equals(parkRegion.getId())) {
                this.fillAmount(request, (OrderInfo)orderSonInfo);
                this.fillAmount(request, (OrderInfo)updateOrderSon);
            }
            this.orderSonInfoDao.updateById((Object)updateOrderSon);
            if (parkChannel.getRegionId().equals(parkRegion.getId())) {
                OrderSonCarInfo updateOrderSonCarInfo = new OrderSonCarInfo();
                updateOrderSonCarInfo.setOrderSonId(orderSonInfo.getId()).setExitNo(parkChannel.getInandoutName()).setExitChannelId(parkChannel.getInandoutCode()).setExitImage(this.fillImage(request.getExitImage(), parkCode)).setSmallExitImage(request.getSmallImage()).setExitWay(request.getInoutEvent()).setExitTerminal(request.getExTerminal()).setExitRemark(request.getRemark()).setExitOperAccount(request.getOperAccount());
                if (StringUtils.isNotEmpty((CharSequence)request.getPlateColor())) {
                    updateOrderSonCarInfo.setPlateColor(request.getPlateColor());
                }
                this.orderSonCarInfoDao.updateByOrderSonId(updateOrderSonCarInfo);
            }
        }
        if (targetStatus != 1 && orderSonInfo.getRegionId().equals(parkChannel.getRegionId()) && ObjectResponse.isSuccess((Response)(parkResp = this.parkService.findByParkId(request.getParkId()))) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkChannel.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex()) {
            OrderTrack orderTrack = new OrderTrack().setRecordType(Integer.valueOf(2)).setParkId(parkChannel.getParkId()).setOrderNum(orderSonInfo.getOrderNum()).setRegionId(parkChannel.getRegionId()).setChannelName(parkChannel.getInandoutName()).setEnexTime(Long.valueOf(request.getExitTime() == null ? 0L : request.getExitTime())).setPlateNum(request.getPlateNum()).setImage(this.fillImage(request.getExitImage(), parkCode)).setType(orderSonInfo.getType()).setInoutEvent(Integer.valueOf(0));
            this.orderTrackService.save((Object)orderTrack);
        }
        return orderSonInfo;
    }

    private OrderCarInfo buildCarInfo(String parkCode, ExitRequest request, OrderInfo orderInfo, ParkInoutdevice parkChannel) {
        Object orderCarInfo = null;
        orderCarInfo = orderInfo instanceof OrderSonInfo ? new OrderSonCarInfo() : new OrderCarInfo();
        BeanUtils.copyProperties((Object)request, (Object)orderCarInfo);
        orderCarInfo.setOrderNum(orderInfo.getOrderNum());
        String imgFileName = this.fillImage(request.getExitImage(), parkCode);
        if (orderInfo.getServiceStatus() != 1) {
            orderCarInfo.setExitNo(parkChannel.getInandoutName());
            orderCarInfo.setExitChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setExitImage(imgFileName);
            orderCarInfo.setSmallExitImage(request.getSmallImage());
        }
        orderCarInfo.setExitWay(request.getInoutEvent());
        orderCarInfo.setExitOperAccount(request.getOperAccount());
        orderCarInfo.setExitTerminal(request.getExTerminal());
        orderCarInfo.setExitRemark(request.getRemark());
        if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
            orderCarInfo.setEnterNo(parkChannel.getInandoutName());
            orderCarInfo.setEnterChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setEnterImage(imgFileName);
            orderCarInfo.setSmallEnterImage(request.getSmallImage());
        }
        return orderCarInfo;
    }

    private String fillImage(String image, String parkCode) {
        if (StringUtils.isNotBlank((CharSequence)image) && !image.contains("/image/")) {
            String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
            String[] ymd = date.split("-");
            image = parkCode + "/image/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/" + image;
        }
        return image;
    }

    private void fillAmount(ExitRequest request, OrderInfo orderInfo) {
        orderInfo.setTotalPrice(NumberUtils.parseDecimal((Object)request.getTotalAmount()).toString());
        orderInfo.setPaidPrice(NumberUtils.parseDecimal((Object)request.getPaidAmount()).toString());
        orderInfo.setDiscountPrice(NumberUtils.parseDecimal((Object)request.getDiscountAmount()).toString());
        orderInfo.setBalancePrice(NumberUtils.parseDecimal((Object)request.getBalancePrice()));
    }

    private void asyncHandler(ExitRequest exitRequest, String parkCode, Long parkId, String orderId, OrderInfo orderInfo, OrderCarInfo carInfo) {
        FIXED_THREAD_POOL.execute(() -> {
            ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(parkId, orderInfo.getPlateNum(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            if (parkVisit != null) {
                parkVisit.setVisitStatus(Integer.valueOf(3));
                parkVisit.setOrderNum(orderInfo.getOrderNum());
                parkVisit.setExitTime(Integer.valueOf(Math.toIntExact(exitRequest.getExitTime())));
                this.parkVisitDao.updateVisit(parkVisit);
                log.info("[\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u8bbf\u5ba2\u9884\u7ea6\u8868\u5b8c\u6210\uff0corderId\uff1a{}", (Object)orderId);
            }
            orderInfo.setExitTime(exitRequest.getExitTime());
            this.autopayService.exitNotify(orderInfo, parkCode);
            this.sendWebsocketMessage(exitRequest, parkCode, carInfo, orderInfo);
            if (exitRequest.getChannelId() != null) {
                ChannelAlarm channelAlarm = new ChannelAlarm();
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(exitRequest.getChannelId());
                channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
                this.channelAlarmDao.update(channelAlarm);
            }
        });
    }

    private void sendWebsocketMessage(ExitRequest exitRequest, String parkCode, OrderCarInfo carInfo, OrderInfo orderInfo) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(2));
        if (orderInfo == null || orderInfo.getEnterTime() == null) {
            return;
        }
        websocketPushData.setEnterTime(Integer.valueOf(orderInfo.getEnterTime().intValue()));
        websocketPushData.setExitTime(Integer.valueOf(exitRequest.getExitTime().intValue()));
        websocketPushData.setType(exitRequest.getType());
        websocketPushData.setCarType(exitRequest.getCarType());
        websocketPushData.setChannelId(exitRequest.getChannelId());
        websocketPushData.setEnterNo(carInfo.getEnterNo());
        websocketPushData.setExitNo(carInfo.getExitNo());
        websocketPushData.setParkCode(parkCode);
        websocketPushData.setPlateNum(exitRequest.getPlateNum());
        websocketPushData.setPlateColor(carInfo.getPlateColor());
        websocketPushData.setTotalPrice(exitRequest.getTotalAmount());
        websocketPushData.setPaidPrice(exitRequest.getPaidAmount());
        websocketPushData.setDiscountPrice(exitRequest.getDiscountAmount());
        websocketPushData.setPayStatus(String.valueOf(orderInfo.getServiceStatus()));
        websocketPushData.setOrderNum(orderInfo.getOrderNum());
        log.info("sendWebsocketMessage  >> {}", (Object)parkCode);
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)JsonUtils.toString((Object)websocketPushData));
    }

    private static class OrderCarInfoWrapper {
        OrderCarInfo orderCarInfo;

        public OrderCarInfoWrapper(OrderCarInfo orderCarInfo) {
            this.orderCarInfo = orderCarInfo;
        }
    }
}

