/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.order.impl.exit.CommonExitImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterChannelCarOrderExitServiceImpl
extends CommonExitImpl {
    private static final Logger log = LoggerFactory.getLogger(MasterChannelCarOrderExitServiceImpl.class);
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OrderInfoDao orderInfoDao;

    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        this.dealExit(exitRequest, status, oddStatus, orderInfo, paramHolder);
        this.saveTrack(exitRequest, paramHolder.getParkChannel().getRegionId(), oddStatus);
        if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(exitRequest.getType())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                log.info("[\u573a\u4e2d\u573a\u6708\u5361\u8f66\u51fa\u573a] \u51c6\u5907\u5904\u7406plateNum[{}]", (Object)exitRequest.getPlateNum());
                this.monthCarService.masterAreaExitAbMonthDeal(parkId, exitRequest.getPlateNum(), exitRequest.getExitTime(), paramHolder.getParkChannel().getRegionId());
            }));
        }
        ParkConfig parkConfig = paramHolder.getParkConfig();
        this.asyncHandler(exitRequest, parkId, orderNum, orderInfo, parkConfig, oddStatus);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }

    private boolean isAnyRegionMonthCard(ReportParamHolder paramHolder) {
        List<OrderSonInfo> orderSonInfos = paramHolder.getOrderSonInfos();
        if (CollectionUtils.isEmpty(orderSonInfos)) {
            MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();
            return MonthDetailDto.MonthType.\u6708\u5361\u8f66.equals((Object)otherRegionMonthDetail.getMonthType()) || MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66.equals((Object)otherRegionMonthDetail.getMonthType());
        }
        return orderSonInfos.stream().anyMatch(orderSonInfo -> PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderSonInfo.getType()));
    }

    private void dealExit(CarExitRequest exitRequest, Integer status, Integer oddStatus, OrderInfo orderInfo, ReportParamHolder paramHolder) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        Long regionId = parkInoutdevice.getRegionId();
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
        AssertTools.notNull((Object)parkRegion, (String)"400", (String)CodeConstants.getName((String)"400"));
        this.commonExitFlow(exitRequest, status, oddStatus, parkId, orderNum, orderInfo);
        if (Integer.valueOf(0).equals(orderInfo.getHasSon())) {
            this.updateRegionFreeSpace(paramHolder, RegionFreeSpaceUpdateVo.builder().regionId(orderInfo.getRegionId()).type(orderInfo.getType()).num(1).build());
            log.info("[\u4e3b\u901a\u9053\u79bb\u573a] \u6ca1\u6709\u5b50\u8ba2\u5355\uff0corderNum[{}]", (Object)orderNum);
            return;
        }
        if (paramHolder.getRegionType() == 2) {
            if (Integer.valueOf(2).equals(exitRequest.getProperty()) && CollectionUtils.isNotEmpty((Collection)exitRequest.getOtherRegionFee())) {
                this.offlineHalfNestHandle(exitRequest, paramHolder, orderInfo, parkId, orderNum, regionId);
                return;
            }
            this.halfNestExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);
        } else {
            if (Integer.valueOf(2).equals(exitRequest.getProperty()) && CollectionUtils.isNotEmpty((Collection)exitRequest.getOtherRegionFee())) {
                this.offlineFullNestHandle(exitRequest, paramHolder, orderInfo, parkId, orderNum, parkInoutdevice);
                return;
            }
            ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
            Long enterRegion = orderInfo.getRegionId();
            if (!enterRegion.equals(regionId)) {
                this.halfNestExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);
            } else {
                boolean noPay;
                OrderSonInfo orderSonInfo = null;
                OrderSonInfo orderSonInfoMain = null;
                OrderSonInfo orderSonInfoParam = new OrderSonInfo();
                orderSonInfoParam.setOrderNum(orderNum);
                orderSonInfoParam.setParkId(parkId);
                List orderSonInfos = this.orderSonInfoDao.selectList((Object)orderSonInfoParam);
                paramHolder.setOrderSonInfos(orderSonInfos);
                if (CollectionUtils.isNotEmpty((Collection)orderSonInfos)) {
                    Optional<OrderSonInfo> first2;
                    Optional<OrderSonInfo> first1 = orderSonInfos.stream().filter(osi -> !regionId.equals(osi.getRegionId())).findFirst();
                    if (first1.isPresent()) {
                        orderSonInfo = first1.get();
                    }
                    if ((first2 = orderSonInfos.stream().filter(osi -> regionId.equals(osi.getRegionId())).findFirst()).isPresent()) {
                        orderSonInfoMain = first2.get();
                    }
                }
                if (orderSonInfo == null) {
                    log.info("\u5185\u533a\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728, orderNum[{}]", (Object)orderNum);
                    return;
                }
                if (orderSonInfoMain == null) {
                    log.info("\u5916\u533a\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728, orderNum[{}]", (Object)orderNum);
                    return;
                }
                if (orderSonInfo.getExitTime() == null) {
                    orderSonInfo.setNoneExitFlag(Integer.valueOf(1));
                }
                if (1 == orderSonInfo.getServiceStatus()) {
                    orderSonInfo.setServiceStatus(Integer.valueOf(2));
                    if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderSonInfo.getType()) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(orderSonInfo.getType())) {
                        log.info("\u6708\u5361/vip\u8f66\u5185\u573a\u51fa\u53e3\u672a\u8bc6\u522b, \u8865\u51fa\u573a\u65f6\u95f4\u4e3a\u5916\u533a\u51fa\u573a\u65f6\u95f4, plateNum[{}]", (Object)orderSonInfo.getPlateNum());
                        orderSonInfo.setExitTime(exitRequest.getExitTime());
                    } else {
                        orderSonInfo.setExitTime(orderSonInfo.getEnterTime());
                    }
                    orderSonInfo.setTotalPrice("0.00");
                    orderSonInfo.setPaidPrice("0.00");
                    orderSonInfo.setDiscountPrice("0.00");
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    log.info("\u51fa\u5927\u573a-\u5c0f\u573a\u51fa\u672a\u8bc6\u522b\uff0c\u66f4\u65b0\u5b50\u8ba2\u5355\u8868\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)orderSonInfo);
                    freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
                }
                BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getPaidPrice()));
                BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getDiscountPrice()));
                BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getTotalPrice()));
                BigDecimal nowBalancePrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getBalancePrice()));
                QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)this.redisUtils.get("sub:" + orderInfo.getOrderNum(), QueryOrderFeeResponse.class);
                log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)queryOrderFeeResponse);
                boolean bl = noPay = NumberUtils.parseFloat((Object)orderInfo.getTotalPrice()) == 0.0f;
                if (queryOrderFeeResponse == null) {
                    orderSonInfoMain.setTotalPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getTotalPrice()).subtract(nowTotalPrice).toString());
                    orderSonInfoMain.setPaidPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getPaidPrice()).subtract(nowPaidPrice).toString());
                    orderSonInfoMain.setDiscountPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getDiscountPrice()).subtract(nowDiscountPrice).toString());
                    if (orderInfo.getBalancePrice() != null) {
                        orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(nowBalancePrice));
                    }
                    orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                    orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
                    if (noPay) {
                        orderSonInfo.setTotalPrice("0.00");
                        orderSonInfo.setPaidPrice("0.00");
                        orderSonInfo.setDiscountPrice("0.00");
                    }
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                } else if (noPay) {
                    orderSonInfo.setTotalPrice("0.00");
                    orderSonInfo.setPaidPrice("0.00");
                    orderSonInfo.setDiscountPrice("0.00");
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    orderSonInfoMain.setTotalPrice("0.00");
                    orderSonInfoMain.setPaidPrice("0.00");
                    orderSonInfoMain.setDiscountPrice("0.00");
                    orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                    orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
                    this.redisTemplate.delete((Object)("sub:" + orderInfo.getOrderNum()));
                    log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderInfo.getOrderNum());
                } else {
                    orderSonInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
                    orderSonInfo.setPaidPrice(NumberUtils.parseFloat((Object)orderInfo.getPaidPrice()) == 0.0f ? "0.00" : new BigDecimal(queryOrderFeeResponse.getPaidAmount()).add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice())).setScale(2, RoundingMode.HALF_UP).toString());
                    orderSonInfo.setDiscountPrice(new BigDecimal(queryOrderFeeResponse.getDiscountAmount()).add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice())).toString());
                    if (OrderOddStatusEnum.\u514d\u8d39\u653e\u884c.getVal().equals(oddStatus)) {
                        orderSonInfo.setPaidPrice(nowPaidPrice.toString());
                        orderSonInfo.setDiscountPrice(new BigDecimal(orderSonInfo.getTotalPrice()).subtract(nowPaidPrice).toString());
                    }
                    orderSonInfo.setOddStatus(oddStatus);
                    if (NumberUtils.parseFloat((Object)orderInfo.getBalancePrice()) > 0.0f) {
                        orderSonInfo.setPaidPrice("0.00");
                        orderSonInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
                    }
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    log.debug("orderSonInfo {}", (Object)orderSonInfo);
                    BigDecimal sonInfoMainTotalPrice = new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderSonInfo.getTotalPrice()));
                    orderSonInfoMain.setTotalPrice(sonInfoMainTotalPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainTotalPrice.toString() : "0.00");
                    BigDecimal sonInfoMainPaidPrice = new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal(orderSonInfo.getPaidPrice()));
                    orderSonInfoMain.setPaidPrice(sonInfoMainPaidPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainPaidPrice.toString() : "0.00");
                    BigDecimal sonInfoMainDiscountPrice = new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal(orderSonInfo.getDiscountPrice()));
                    orderSonInfoMain.setDiscountPrice(sonInfoMainDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainDiscountPrice.toString() : "0.00");
                    if (NumberUtils.parseFloat((Object)orderInfo.getBalancePrice()) > 0.0f && orderSonInfo.getBalancePrice() != null) {
                        orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(orderSonInfo.getBalancePrice()));
                    }
                    orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                    orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
                    this.redisTemplate.delete((Object)("sub:" + orderInfo.getOrderNum()));
                    log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderInfo.getOrderNum());
                }
                orderSonInfoMain.setServiceStatus(orderInfo.getServiceStatus());
                orderSonInfoMain.setOddStatus(orderInfo.getOddStatus());
                orderSonInfoMain.setExitTime(orderInfo.getExitTime());
                this.orderSonInfoService.updateBatchById(Arrays.asList(orderSonInfoMain, orderSonInfo));
                freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfoMain.getRegionId()).type(orderSonInfoMain.getType()).num(1).build());
                this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
                OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
                OrderSonCarInfo sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId().longValue());
                sonCarInfo.setExitChannelId(carInfo.getExitChannelId());
                sonCarInfo.setExitNo(carInfo.getExitNo());
                sonCarInfo.setExitImage(carInfo.getExitImage());
                sonCarInfo.setExitReliability(carInfo.getExitReliability());
                sonCarInfo.setSmallExitImage(carInfo.getSmallExitImage());
                sonCarInfo.setExitWay(carInfo.getExitWay());
                sonCarInfo.setExitTerminal(carInfo.getExitTerminal());
                sonCarInfo.setExitOperAccount(carInfo.getExitOperAccount());
                sonCarInfo.setExitRemark(carInfo.getExitRemark());
                this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
                log.info("[\u79bb\u573a\u670d\u52a1] \u4e3b\u79bb\u573a\u8bb0\u5f55\u66f4\u65b0\u5b50\u8bb0\u5f55\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
            }
        }
    }

    private void offlineFullNestHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, OrderInfo orderInfo, Long parkId, String orderNum, ParkInoutdevice parkInoutdevice) {
        List otherRegionFee = exitRequest.getOtherRegionFee();
        int otherRegionTotalPriceSum = 0;
        int otherRegionDiscountPriceSum = 0;
        int otherRegionPaidPriceSum = 0;
        ArrayList<OrderSonInfo> orderSonInfos = new ArrayList<OrderSonInfo>();
        ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
        for (CarExitRequest.OtherRegionFee regionFee : otherRegionFee) {
            otherRegionTotalPriceSum += regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen();
            otherRegionDiscountPriceSum += regionFee.getDiscountAmountFen().intValue();
            otherRegionPaidPriceSum += regionFee.getPaidAmountFen().intValue();
            OrderSonInfo orderSonInfo = new OrderSonInfo();
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setParkId(parkId);
            orderSonInfo.setRegionId(regionFee.getRegionId());
            orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
            if (orderSonInfo == null) {
                log.warn("[\u7aef\u4e91\u8131\u673a\u79bb\u573a-\u5c0f\u573a\u5206\u8d26] \u5b50\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728, regionId[" + regionFee.getRegionId() + "]");
                continue;
            }
            BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getPaidPrice()));
            BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getDiscountPrice()));
            BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getTotalPrice()));
            orderSonInfo.setServiceStatus(Integer.valueOf(2));
            orderSonInfo.setTotalPrice(nowTotalPrice.add(BigDecimal.valueOf((double)(regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen()) / 100.0)).toString());
            orderSonInfo.setPaidPrice(nowPaidPrice.add(BigDecimal.valueOf((double)regionFee.getPaidAmountFen().intValue() / 100.0)).toString());
            orderSonInfo.setDiscountPrice(nowDiscountPrice.add(BigDecimal.valueOf((double)regionFee.getDiscountAmountFen().intValue() / 100.0)).toString());
            this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
            orderSonInfos.add(orderSonInfo);
            log.info("[\u7aef\u4e91\u8131\u673a\u79bb\u573a-\u5c0f\u573a\u5206\u8d26] \u66f4\u65b0\u5b50\u8ba2\u5355\u4fe1\u606f[{}]", (Object)orderSonInfo);
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }
        OrderSonInfo orderSonInfo = new OrderSonInfo();
        orderSonInfo.setOrderNum(orderNum);
        orderSonInfo.setParkId(parkId);
        orderSonInfo.setRegionId(parkInoutdevice.getRegionId());
        OrderSonInfo orderSonInfoMain = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
        orderSonInfoMain.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal((double)otherRegionTotalPriceSum / 100.0)).toString());
        orderSonInfoMain.setPaidPrice(new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal((double)otherRegionPaidPriceSum / 100.0)).toString());
        orderSonInfoMain.setDiscountPrice(new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal((double)otherRegionDiscountPriceSum / 100.0)).toString());
        orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
        this.orderSonInfoDao.updateById((Object)orderSonInfoMain);
        orderSonInfos.add(orderSonInfoMain);
        paramHolder.setOrderSonInfos(orderSonInfos);
        this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        log.info("[\u7aef\u4e91\u8131\u673a\u79bb\u573a-\u5c0f\u573a\u5206\u8d26] \u63d2\u5165\u5b50\u8ba2\u5355\u8868\u7684\u4e3b\u8ba2\u5355\u4fe1\u606f[{}]", (Object)orderSonInfoMain);
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        OrderSonCarInfo sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId().longValue());
        sonCarInfo.setExitChannelId(carInfo.getExitChannelId());
        sonCarInfo.setExitNo(carInfo.getExitNo());
        sonCarInfo.setExitImage(carInfo.getExitImage());
        sonCarInfo.setExitReliability(carInfo.getExitReliability());
        sonCarInfo.setSmallExitImage(carInfo.getSmallExitImage());
        sonCarInfo.setExitWay(carInfo.getExitWay());
        sonCarInfo.setExitTerminal(carInfo.getExitTerminal());
        sonCarInfo.setExitOperAccount(carInfo.getExitOperAccount());
        sonCarInfo.setExitRemark(carInfo.getExitRemark());
        this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
        log.info("[\u79bb\u573a\u670d\u52a1] \u4e3b\u79bb\u573a\u8bb0\u5f55\u66f4\u65b0\u5b50\u8bb0\u5f55\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
    }

    private void offlineHalfNestHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, OrderInfo orderInfo, Long parkId, String orderNum, Long regionId) {
        OrderSonCarInfo sonCarInfo;
        int otherRegionTotalPriceSum = 0;
        int otherRegionDiscountPriceSum = 0;
        int otherRegionPaidPriceSum = 0;
        List otherRegionFee = exitRequest.getOtherRegionFee();
        for (CarExitRequest.OtherRegionFee regionFee : otherRegionFee) {
            otherRegionTotalPriceSum += regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen();
            otherRegionDiscountPriceSum += regionFee.getDiscountAmountFen().intValue();
            otherRegionPaidPriceSum += regionFee.getPaidAmountFen().intValue();
        }
        ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
        OrderSonInfo orderSonInfo = new OrderSonInfo();
        orderSonInfo.setOrderNum(orderNum);
        orderSonInfo.setParkId(parkId);
        orderSonInfo.setRegionId(regionId);
        orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties((Object)exitRequest, (Object)orderSonInfo);
            orderSonInfo.setEnterTime(exitRequest.getExitTime());
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setRegionId(regionId);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
            sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties((Object)exitRequest, (Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u8f66\u8f86\u6570\u636e\uff1a{}", (Object)exitRequest.getPlateNum());
            orderInfo.setHasSon(Integer.valueOf(1));
            orderInfo.setOperAccount(exitRequest.getOperAccount());
            this.orderInfoDao.updateByOrderNum(orderInfo);
            log.info("[\u7aef\u4e91-\u5b50\u901a\u9053\u79bb\u573a\u670d\u52a1] \u8865-\u4e3b\u8ba2\u5355\u66f4\u65b0\u4e3ahasSon\u5b57\u6bb5\u4e3a1\uff1a{}", (Object)exitRequest.getPlateNum());
            log.warn("\u672a\u67e5\u8be2\u5230\u5b50\u8ba2\u5355, orderNum[{}], regionId[{}]", (Object)orderNum, (Object)regionId);
        } else {
            sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId().longValue());
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }
        BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getPaidPrice()));
        BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getDiscountPrice()));
        BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getTotalPrice()));
        orderSonInfo.setServiceStatus(Integer.valueOf(2));
        orderSonInfo.setTotalPrice(nowTotalPrice.add(new BigDecimal(orderInfo.getTotalPrice()).subtract(BigDecimal.valueOf((double)otherRegionTotalPriceSum / 100.0))).toString());
        orderSonInfo.setPaidPrice(nowPaidPrice.add(new BigDecimal(orderInfo.getPaidPrice()).subtract(BigDecimal.valueOf((double)otherRegionPaidPriceSum / 100.0))).toString());
        orderSonInfo.setDiscountPrice(nowDiscountPrice.add(new BigDecimal(orderInfo.getPaidPrice()).subtract(BigDecimal.valueOf((double)otherRegionDiscountPriceSum / 100.0))).toString());
        sonCarInfo.setExitImage(exitRequest.getMaxImage());
        sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
        sonCarInfo.setExitNo(exitRequest.getInandoutName());
        sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
        sonCarInfo.setExitReliability(exitRequest.getReliability());
        sonCarInfo.setExitWay(exitRequest.getExitWay());
        sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
        sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());
        sonCarInfo.setExitRemark(exitRequest.getExitRemark());
        if (orderSonInfo.getId() == null) {
            orderSonInfo.setNoneEnterFlag(Integer.valueOf(1));
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            sonCarInfo.setOrderSonId(orderSonInfo.getId());
            this.orderSonCarInfoDao.insert((Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u8865-\u5b50\u8ba2\u5355\u53ca\u8f66\u8f86\u4fe1\u606f\u65b0\u589e\u5b8c\u6210: {} - {}", (Object)orderSonInfo.getId(), (Object)sonCarInfo.getId());
        } else {
            this.orderSonInfoDao.updateById((Object)orderSonInfo);
            this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u4fee\u6539\u5b50\u8ba2\u5355\u53ca\u8f66\u8f86\u4fe1\u606f\u5b8c\u6210: {} - {}", (Object)orderSonInfo.getId(), (Object)sonCarInfo.getId());
        }
        this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)("sub:" + orderSonInfo.getOrderNum())))) {
            this.redisTemplate.delete((Object)("sub:" + orderSonInfo.getOrderNum()));
            log.info("[\u7aef\u4e91-\u5c0f\u573a\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderSonInfo.getOrderNum());
        }
    }

    private void halfNestExit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus, Long parkId, String orderNum, OrderInfo orderInfo, Long regionId) {
        OrderSonCarInfo sonCarInfo;
        boolean noPay;
        OrderSonInfo orderSonInfoMain = null;
        OrderSonInfo orderSonInfo = null;
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderNum);
        orderSonInfoParam.setParkId(parkId);
        List orderSonInfos = this.orderSonInfoDao.selectList((Object)orderSonInfoParam);
        paramHolder.setOrderSonInfos(orderSonInfos);
        if (CollectionUtils.isNotEmpty((Collection)orderSonInfos)) {
            Optional<OrderSonInfo> first2;
            Optional<OrderSonInfo> first1 = orderSonInfos.stream().filter(osi -> orderInfo.getRegionId().equals(osi.getRegionId())).findFirst();
            if (first1.isPresent()) {
                orderSonInfoMain = first1.get();
            }
            if ((first2 = orderSonInfos.stream().filter(osi -> !orderInfo.getRegionId().equals(osi.getRegionId())).findFirst()).isPresent()) {
                orderSonInfo = first2.get();
            }
        }
        if (orderSonInfoMain == null) {
            log.info("\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728, orderNum[{}], regionId[{}]", (Object)orderNum, (Object)regionId);
            return;
        }
        if (orderSonInfo == null) {
            log.info("\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728, orderNum[{}], regionId[{}]", (Object)orderNum, (Object)regionId);
            return;
        }
        orderSonInfo.setExitTime(exitRequest.getExitTime());
        if (regionId.equals(orderSonInfoMain.getRegionId()) && 1 == orderSonInfo.getServiceStatus()) {
            orderSonInfo.setExitTime(orderSonInfo.getEnterTime());
            log.info("\u51fa\u5927\u573a-\u5c0f\u573a\u51fa\u672a\u8bc6\u522b\uff0c\u4f7f\u7528\u5165\u573a\u65f6\u95f4\u4f5c\u4e3a\u51fa\u573a\u65f6\u95f4\uff1a{}", (Object)orderSonInfo);
        }
        orderSonInfo.setServiceStatus(status);
        orderSonInfo.setOddStatus(oddStatus);
        BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getPaidPrice()));
        BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getDiscountPrice()));
        BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getTotalPrice()));
        BigDecimal nowBalancePrice = BigDecimal.valueOf(NumberUtils.parseFloat((Object)orderSonInfo.getBalancePrice()));
        QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)this.redisUtils.get("sub:" + orderInfo.getOrderNum(), QueryOrderFeeResponse.class);
        log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)queryOrderFeeResponse);
        orderSonInfoMain.setServiceStatus(status);
        orderSonInfoMain.setOddStatus(oddStatus);
        orderSonInfoMain.setExitTime(exitRequest.getExitTime());
        ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
        freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().num(1).regionId(regionId).type((Integer)orderSonInfos.stream().filter(osi -> regionId.equals(osi.getRegionId())).findFirst().map(OrderInfo::getType).orElse(null)).build());
        boolean bl = noPay = NumberUtils.parseFloat((Object)orderInfo.getTotalPrice()) == 0.0f;
        if (queryOrderFeeResponse == null) {
            orderSonInfoMain.setTotalPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getTotalPrice()).subtract(nowTotalPrice).toString());
            orderSonInfoMain.setPaidPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getPaidPrice()).subtract(nowPaidPrice).toString());
            orderSonInfoMain.setDiscountPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getDiscountPrice()).subtract(nowDiscountPrice).toString());
            if (orderInfo.getBalancePrice() != null) {
                orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(nowBalancePrice));
            }
            orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
            this.orderSonInfoDao.updateById((Object)orderSonInfoMain);
            if (!orderSonInfoMain.getId().equals(orderSonInfo.getId())) {
                orderSonInfo.setTotalPrice(noPay ? "0.00" : nowTotalPrice.toString());
                orderSonInfo.setPaidPrice(noPay ? "0.00" : nowPaidPrice.toString());
                orderSonInfo.setDiscountPrice(noPay ? "0.00" : nowDiscountPrice.toString());
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                this.orderSonInfoDao.updateById((Object)orderSonInfo);
                log.info("\u66f4\u65b0\u5b50\u8ba2\u5355\u8868\uff0c\u5b50\u8ba2\u5355id\uff1a{}", (Object)orderSonInfo.getId());
            }
        } else if (noPay) {
            orderSonInfo.setTotalPrice("0.00");
            orderSonInfo.setPaidPrice("0.00");
            orderSonInfo.setDiscountPrice("0.00");
            orderSonInfo.setOperAccount(exitRequest.getOperAccount());
            this.orderSonInfoDao.updateById((Object)orderSonInfo);
            orderSonInfoMain.setTotalPrice("0.00");
            orderSonInfoMain.setPaidPrice("0.00");
            orderSonInfoMain.setDiscountPrice("0.00");
            orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
            this.orderSonInfoDao.updateById((Object)orderSonInfoMain);
            this.redisTemplate.delete((Object)("sub:" + orderInfo.getOrderNum()));
            log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderInfo.getOrderNum());
        } else {
            orderSonInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
            orderSonInfo.setPaidPrice(NumberUtils.parseFloat((Object)orderInfo.getPaidPrice()) == 0.0f ? "0.00" : new BigDecimal(queryOrderFeeResponse.getPaidAmount()).add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice())).setScale(2, RoundingMode.HALF_UP).toString());
            orderSonInfo.setDiscountPrice(new BigDecimal(queryOrderFeeResponse.getDiscountAmount()).add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice())).setScale(2, RoundingMode.HALF_UP).toString());
            if (OrderOddStatusEnum.\u514d\u8d39\u653e\u884c.getVal().equals(oddStatus)) {
                orderSonInfo.setPaidPrice(nowPaidPrice.toString());
                orderSonInfo.setDiscountPrice(new BigDecimal(orderSonInfo.getTotalPrice()).subtract(nowPaidPrice).toString());
            }
            orderSonInfo.setOddStatus(oddStatus);
            if (NumberUtils.parseFloat((Object)orderInfo.getBalancePrice()) > 0.0f) {
                orderSonInfo.setPaidPrice("0.00");
                orderSonInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            }
            orderSonInfo.setOperAccount(exitRequest.getOperAccount());
            this.orderSonInfoDao.updateById((Object)orderSonInfo);
            BigDecimal sonInfoMainTotalPrice = new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderSonInfo.getTotalPrice()));
            orderSonInfoMain.setTotalPrice(sonInfoMainTotalPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainTotalPrice.toString() : "0.00");
            BigDecimal sonInfoMainPaidPrice = new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal(orderSonInfo.getPaidPrice()));
            orderSonInfoMain.setPaidPrice(sonInfoMainPaidPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainPaidPrice.toString() : "0.00");
            BigDecimal sonInfoMainDiscountPrice = new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal(orderSonInfo.getDiscountPrice()));
            orderSonInfoMain.setDiscountPrice(sonInfoMainDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainDiscountPrice.toString() : "0.00");
            if (NumberUtils.parseFloat((Object)orderInfo.getBalancePrice()) > 0.0f && orderSonInfo.getBalancePrice() != null) {
                orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(orderSonInfo.getBalancePrice()));
            }
            orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
            this.orderSonInfoDao.updateById((Object)orderSonInfoMain);
            this.redisTemplate.delete((Object)("sub:" + orderInfo.getOrderNum()));
            log.info("[\u7aef\u4e91-\u8f66\u8f86\u79bb\u573a\u670d\u52a1] \u4f7f\u7528\u5b8c\u6bd5\uff0c\u6e05\u9664redis\u5c0f\u573a\u8ba1\u8d39\u7ed3\u679c\uff1a{}", (Object)orderInfo.getOrderNum());
        }
        this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        OrderSonCarInfo sonCarInfoMain = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId().longValue());
        if (sonCarInfoMain != null) {
            sonCarInfoMain.setExitChannelId(exitRequest.getInandoutCode());
            sonCarInfoMain.setExitNo(exitRequest.getInandoutName());
            sonCarInfoMain.setExitImage(exitRequest.getMaxImage());
            sonCarInfoMain.setSmallExitImage(exitRequest.getSmallImage());
            sonCarInfoMain.setExitWay(exitRequest.getExitWay());
            sonCarInfoMain.setExitTerminal(exitRequest.getExitTerminal());
            sonCarInfoMain.setExitOperAccount(exitRequest.getOperAccount());
            sonCarInfoMain.setExitRemark(exitRequest.getExitRemark());
            this.orderSonCarInfoDao.updateById((Object)sonCarInfoMain);
            log.info("[\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u5b50\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0csonCarInfo\uff1a{}", (Object)sonCarInfoMain);
        }
        if ((sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId().longValue())) != null) {
            sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
            sonCarInfo.setExitNo(exitRequest.getInandoutName());
            sonCarInfo.setExitImage(exitRequest.getMaxImage());
            sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
            sonCarInfo.setExitWay(exitRequest.getExitWay());
            sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
            sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());
            sonCarInfo.setExitRemark(exitRequest.getExitRemark());
            this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
            log.info("[\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u5b50\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0csonCarInfo2\uff1a{}", (Object)sonCarInfo);
        }
        exitRequest.setType(orderSonInfo.getType());
    }
}

