/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.service.third.MqPushService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;

@RefreshScope
public class CommonExitImpl
implements CarOrderExitService {
    private static final Logger log = LoggerFactory.getLogger(CommonExitImpl.class);
    @Resource
    protected OrderService orderService;
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected StringRedisTemplate redisTemplate;
    @Autowired
    protected OrderPayDao orderPayDao;
    @Autowired
    protected ParkVisitDao parkVisitDao;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected ThreadPoolExecutor asyncExecutor;
    @Autowired
    protected OrderTrackMapper orderTrackMapper;
    @Autowired
    protected MqPushService mqPushService;
    @Autowired
    protected ParkRegionDao parkRegionDao;
    @Autowired
    protected OrderNotpayService orderNotpayService;
    @Autowired
    protected ParkService parkService;
    @Resource
    private MorCacheHandle morCacheHandle;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private RabbitSender rabbitSender;
    @Value(value="${aisle.applyCarVideo.time:30}")
    private Integer aisleApplyCarVideoTime;
    @Value(value="${notpay.tag.days:7}")
    private Integer notPayTagDaysConfig = 7;

    protected void commonExitFlow(CarExitRequest exitRequest, Integer status, Integer oddStatus, Long parkId, String orderNum, OrderInfo orderInfo) {
        OrderPay orderPay;
        orderInfo.setServiceStatus(status);
        orderInfo.setExitTime(exitRequest.getExitTime());
        orderInfo.setOddStatus(oddStatus);
        orderInfo.setType(exitRequest.getType());
        orderInfo.setOperAccount(exitRequest.getOperAccount());
        orderInfo.setCarType(exitRequest.getCarType());
        if (2 == status) {
            if (exitRequest.getIsAfterPay() != null && exitRequest.getIsAfterPay() == 1) {
                orderInfo.setTotalPrice(StringUtils.isBlank((CharSequence)exitRequest.getTotalAmount()) ? "0.00" : exitRequest.getTotalAmount());
                orderInfo.setPaidPrice(StringUtils.isBlank((CharSequence)exitRequest.getPaidAmount()) ? "0.00" : exitRequest.getPaidAmount());
                orderInfo.setDiscountPrice(StringUtils.isBlank((CharSequence)exitRequest.getDiscountAmount()) ? "0.00" : exitRequest.getDiscountAmount());
                orderInfo.setCityAutopay(Integer.valueOf(1));
                orderInfo.setNeedPrice(StringUtils.isBlank((CharSequence)exitRequest.getUnpayPrice()) ? "0.00" : exitRequest.getUnpayPrice());
            } else {
                orderPay = new OrderPay();
                orderPay.setParkId(parkId);
                orderPay.setOrderNum(orderNum);
                OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
                if (orderSumFeeDto != null) {
                    orderInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    orderInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    orderInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                } else if (Integer.valueOf(2).equals(exitRequest.getProperty()) && NumberUtils.toPrimitive((Integer)exitRequest.getPaidAmountFen()) > 0) {
                    OrderPay orderPay1 = new OrderPay();
                    orderPay1.setOrderNum(orderNum);
                    orderPay1.setTradeNo(CodeTools.GenerateTradeNo());
                    orderPay1.setPayStatus(Integer.valueOf(2));
                    orderPay1.setParkId(parkId);
                    orderPay1.setPayChannel(Integer.valueOf(10));
                    orderPay1.setPayTerminal(exitRequest.getInandoutName());
                    orderPay1.setPayWay(Integer.valueOf(1));
                    orderPay1.setChannelId(exitRequest.getInandoutCode());
                    orderPay1.setBalancePrice(new BigDecimal("0.00"));
                    orderPay1.setOrderTime(exitRequest.getExitTime());
                    orderPay1.setPayTime(exitRequest.getExitTime());
                    orderPay1.setPaidPrice(NumberUtils.parseString((Object)((double)exitRequest.getPaidAmountFen().intValue() / 100.0), (String)"#.00"));
                    orderPay1.setTotalPrice(NumberUtils.parseString((Object)((double)(exitRequest.getPaidAmountFen() + NumberUtils.toPrimitive((Integer)exitRequest.getDiscountAmountFen())) / 100.0), (String)"#.00"));
                    orderPay1.setDiscountPrice("0.00");
                    orderPay1.setIsSync(Integer.valueOf(0));
                    this.orderPayDao.insert((Object)orderPay1);
                    orderInfo.setPaidPrice(orderPay1.getPaidPrice());
                    orderInfo.setDiscountPrice(orderPay1.getDiscountPrice());
                    orderInfo.setTotalPrice(orderPay1.getTotalPrice());
                } else {
                    orderInfo.setTotalPrice("0.00");
                    orderInfo.setPaidPrice("0.00");
                    orderInfo.setDiscountPrice("0.00");
                }
            }
        } else {
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u5f02\u5e38\u79bb\u573a\u4fee\u6539\u8d39\u7528\uff0corderNum\uff1a{}, totalAmount\uff1a{}", (Object)orderNum, (Object)exitRequest.getTotalAmount());
            if (StringUtils.isBlank((CharSequence)exitRequest.getTotalAmount())) {
                orderPay = new OrderPay();
                orderPay.setParkId(parkId);
                orderPay.setOrderNum(orderNum);
                OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
                if (orderSumFeeDto != null) {
                    orderInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    orderInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    orderInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                } else {
                    orderInfo.setTotalPrice("0.00");
                    orderInfo.setPaidPrice("0.00");
                    orderInfo.setDiscountPrice("0.00");
                }
            } else {
                orderInfo.setTotalPrice(exitRequest.getTotalAmount());
                orderInfo.setPaidPrice(exitRequest.getPaidAmount());
                orderInfo.setDiscountPrice(exitRequest.getDiscountAmount());
            }
        }
        orderInfo.setExitChannelId(exitRequest.getInandoutCode());
        this.orderService.updateOrderWithPush(orderInfo);
        log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u4fee\u6539\u8ba2\u5355\u4e3b\u4fe1\u606f\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        exitRequest.setPaidAmount(orderInfo.getPaidPrice());
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        AssertTools.notNull((Object)carInfo, (String)"500", (String)"\u5e73\u53f0\u8ba2\u5355\u6570\u636e\u4e0d\u5b8c\u6574");
        BeanUtils.copyProperties((Object)exitRequest, (Object)carInfo);
        carInfo.setExitChannelId(exitRequest.getInandoutCode());
        carInfo.setExitNo(exitRequest.getInandoutName());
        carInfo.setExitImage(exitRequest.getMaxImage());
        carInfo.setSmallExitImage(exitRequest.getSmallImage());
        carInfo.setExitReliability(exitRequest.getReliability());
        carInfo.setExitOperAccount(exitRequest.getOperAccount());
        carInfo.setExitRemark(exitRequest.getExitRemark());
        this.orderCarInfoDao.updateById((Object)carInfo);
        log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u8ba2\u5355\u8f66\u8f86\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
    }

    protected void asyncHandler(CarExitRequest exitRequest, Long parkId, String orderNum, OrderInfo orderInfo, ParkConfig parkConfig, Integer oddStatus) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            this.notPayHandle(exitRequest, parkId, orderNum, orderInfo, oddStatus, parkConfig);
            log.info("sendWebsocketMessage > {} {}", (Object)orderInfo, (Object)exitRequest.getPaidAmount());
            exitRequest.setOpenFlag(Integer.valueOf(1));
            exitRequest.setUnpayPrice(orderInfo.getPaidPrice());
            exitRequest.setPaidAmount(orderInfo.getPaidPrice());
            this.sendWebsocketMessage(exitRequest, null != orderInfo.getPaidPrice() && !"0.00".equals(orderInfo.getPaidPrice()) ? "5" : "2", 1, null != orderInfo.getPaidPrice() && !"0.00".equals(orderInfo.getPaidPrice()) ? 0 : 1);
            ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(parkId, orderInfo.getPlateNum(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            if (parkVisit != null && exitRequest.getType().equals(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType())) {
                parkVisit.setVisitStatus(Integer.valueOf(3));
                parkVisit.setOrderNum(orderNum);
                parkVisit.setExitTime(Integer.valueOf(Math.toIntExact(exitRequest.getExitTime())));
                this.parkVisitDao.updateVisit(parkVisit);
                log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u8bbf\u5ba2\u9884\u7ea6\u8868\u5b8c\u6210\uff0corderId\uff1a{}", (Object)orderInfo.getId());
            }
            if (exitRequest.getInandoutCode() != null) {
                ChannelAlarm channelAlarm = new ChannelAlarm();
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(exitRequest.getInandoutCode());
                channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
                this.channelAlarmDao.update(channelAlarm);
            }
        }));
    }

    private void notPayHandle(CarExitRequest exitRequest, Long parkId, String orderNum, OrderInfo orderInfo, Integer oddStatus, ParkConfig parkConfig) {
        if (Boolean.TRUE.equals(exitRequest.getFuzzyOrder())) {
            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u6a21\u7cca\u5339\u914d\u8ba2\u5355\u4e0d\u7b97\u6b20\u8d39[{}]", (Object)exitRequest);
            return;
        }
        if (Integer.valueOf(0).equals(orderInfo.getCityAutopay())) {
            BigDecimal totalPrice = NumberUtils.parseDecimal((Object)orderInfo.getTotalPrice());
            BigDecimal paidPrice = NumberUtils.parseDecimal((Object)orderInfo.getPaidPrice());
            BigDecimal discountPrice = NumberUtils.parseDecimal((Object)orderInfo.getDiscountPrice());
            BigDecimal balancePrice = NumberUtils.parseDecimal((Object)orderInfo.getBalancePrice());
            int[] excludeExitWays = new int[]{2, 4};
            int notPayTagDays = NumberUtils.toPrimitive((Integer)parkConfig.getNotpayTagDays(), (int)this.notPayTagDaysConfig);
            if (!ArrayUtils.contains((int[])excludeExitWays, (int)exitRequest.getExitWay()) && OrderOddStatusEnum.\u975e\u6b63\u5e38\u51fa\u573a.getVal().equals(oddStatus) && totalPrice.compareTo(paidPrice.add(discountPrice).add(balancePrice)) > 0 && exitRequest.getExitTime() - orderInfo.getEnterTime() <= (long)notPayTagDays * 3600L * 24L) {
                ObjectResponse inoutDeviceByCode;
                log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u5f53\u524d\u4e3a\u6b20\u8d39\u8ba2\u5355[{}]", (Object)exitRequest);
                String videoId = CodeTools.getCharAndNumr((int)16);
                Long channelId = null;
                if (exitRequest.getInandoutCode() != null && ObjectResponse.isSuccess((Response)(inoutDeviceByCode = this.parkService.getInoutDeviceByCode(exitRequest.getInandoutCode())))) {
                    channelId = ((ParkInoutdevice)inoutDeviceByCode.getData()).getId();
                }
                BigDecimal notPayPrice = totalPrice.subtract(paidPrice).subtract(discountPrice).subtract(balancePrice);
                String serialNumber = this.morCacheHandle.getSerialNumber(exitRequest.getParkCode(), exitRequest.getInandoutCode());
                if (serialNumber == null) {
                    OrderNotpay orderNotpay = (OrderNotpay)this.orderNotpayService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(OrderNotpay::getOrderNum, (Object)orderNum)).eq(OrderNotpay::getStatus, (Object)1));
                    if (orderNotpay != null) {
                        if (exitRequest.getExitTime().equals(orderNotpay.getExitTime())) {
                            log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u5df2\u5904\u7406\u8fc7\u6b20\u8d39[{}]", (Object)orderNotpay);
                            return;
                        }
                        log.info("[\u7aef\u4e91-\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u6b20\u8d39\u8ba2\u5355, \u8ba2\u5355[{}], \u539f\u6b20\u8d39\u91d1\u989d[{}], \u6700\u65b0\u6b20\u8d39[{}]", new Object[]{orderNum, orderNotpay.getPaidPrice(), notPayPrice});
                        OrderNotpay orderNotPayUpdate = new OrderNotpay();
                        orderNotPayUpdate.setId(orderNotpay.getId());
                        orderNotPayUpdate.setTotalPrice(notPayPrice);
                        orderNotPayUpdate.setPaidPrice(BigDecimal.ZERO);
                        orderNotPayUpdate.setLastPayTime(exitRequest.getLastPayTime());
                        orderNotPayUpdate.setExitTime(exitRequest.getExitTime());
                        orderNotPayUpdate.setChannelId(channelId);
                        orderNotpay.setChannelId(channelId);
                        orderNotPayUpdate.setVideoId(videoId);
                        orderNotpay.setVideoId(videoId);
                        this.orderNotpayService.largeOrder(orderNotPayUpdate);
                        this.orderNotpayService.updateById((Object)orderNotPayUpdate);
                    } else {
                        orderNotpay = new OrderNotpay();
                        BeanUtils.copyProperties((Object)exitRequest, (Object)orderNotpay);
                        orderNotpay.setTotalPrice(notPayPrice);
                        orderNotpay.setPaidPrice(BigDecimal.ZERO);
                        orderNotpay.setDiscountPrice(BigDecimal.ZERO);
                        orderNotpay.setEnterTime(NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0 ? orderInfo.getEnterTime() : null);
                        orderNotpay.setLastPayTime(exitRequest.getLastPayTime());
                        orderNotpay.setChannelId(channelId);
                        orderNotpay.setVideoId(videoId);
                        this.orderNotpayService.largeOrder(orderNotpay);
                        this.orderNotpayService.addOrderNotpay(orderNotpay);
                    }
                } else {
                    ApplyCarVideoVo vo = new ApplyCarVideoVo();
                    vo.setVideoType(Integer.valueOf(1));
                    vo.setSn(serialNumber);
                    vo.setChannelId(channelId);
                    vo.setOrderNum(orderNum);
                    vo.setParkId(parkId);
                    vo.setPlateNum(orderInfo.getPlateNum());
                    vo.setVideoId(videoId);
                    vo.setRecTime(exitRequest.getExitTime());
                    vo.setNotPayPrice(notPayPrice);
                    vo.setLastPayTime(exitRequest.getLastPayTime());
                    vo.setType(exitRequest.getType());
                    vo.setCarType(exitRequest.getCarType());
                    this.rabbitSender.sendMessage("aisle.delayed.exchange", "apply.car.video.routing", (Object)vo, Long.valueOf((long)this.aisleApplyCarVideoTime.intValue() * 1000L));
                    log.info("[\u7aef\u4e91-\u51fa\u53e3] \u8bf7\u6c42\u89c6\u9891\u5ef6\u8fdf\u6d88\u606f\u53d1\u9001, [{}]", (Object)vo);
                }
            }
        }
    }

    public void sendWebsocketMessage(CarExitRequest exitRequest, String payStatus, Integer allow, Integer needPay) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(2));
        websocketPushData.setExitTime(Integer.valueOf(null != exitRequest.getExitTime() ? exitRequest.getExitTime().intValue() : (int)System.currentTimeMillis() / 1000));
        websocketPushData.setType(exitRequest.getType());
        websocketPushData.setCarType(exitRequest.getCarType());
        websocketPushData.setChannelId(exitRequest.getInandoutCode());
        websocketPushData.setExitNo(exitRequest.getInandoutName());
        websocketPushData.setParkCode(exitRequest.getParkCode());
        websocketPushData.setPlateNum(exitRequest.getPlateNum());
        websocketPushData.setPlateColor(exitRequest.getPlateColor());
        websocketPushData.setTotalPrice(TextUtils.isEmpty((CharSequence)exitRequest.getUnpayPrice()) ? "0" : exitRequest.getUnpayPrice());
        websocketPushData.setPaidPrice(TextUtils.isEmpty((CharSequence)exitRequest.getPaidAmount()) ? "0" : exitRequest.getPaidAmount());
        websocketPushData.setDiscountPrice(TextUtils.isEmpty((CharSequence)exitRequest.getDiscountAmount()) ? "0" : exitRequest.getDiscountAmount());
        websocketPushData.setPayStatus(payStatus);
        websocketPushData.setOrderNum(exitRequest.getOrderNum());
        websocketPushData.setOpened(exitRequest.getOpenFlag());
        websocketPushData.setAllow(allow);
        websocketPushData.setNeedPay(needPay);
        String data = JsonUtils.toString((Object)websocketPushData);
        log.info("sendWebsocketMessage  >> {}", (Object)data);
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)data);
    }

    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, RegionFreeSpaceUpdateVo vo) {
        this.updateRegionFreeSpace(paramHolder, Collections.singletonList(vo));
    }

    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, Collection<RegionFreeSpaceUpdateVo> vos) {
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        List typeList = vos.stream().map(RegionFreeSpaceUpdateVo::getType).distinct().collect(Collectors.toList());
        if (!typeList.contains(PlateTypeEnum.\u6708\u5361\u8f66.getType()) || NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) == 1) {
            Collection regionIds = vos.stream().map(RegionFreeSpaceUpdateVo::getRegionId).collect(Collectors.toSet());
            if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                for (RegionFreeSpaceUpdateVo vo : vos) {
                    this.parkRegionDao.addFreeSpaceByPark(vo.getRegionId().longValue(), vo.getNum());
                }
            } else {
                this.parkRegionDao.updateFreeParkByIds(regionIds);
            }
            this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
            if (paramHolder.getRegionType() == 2) {
                for (Long regionId : regionIds) {
                    this.mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), regionId);
                }
            } else {
                this.mqPushService.pushParkFreeSpace(paramHolder.getParkId());
            }
        } else {
            for (RegionFreeSpaceUpdateVo vo : vos) {
                if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(vo.getType()) && NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) != 1) continue;
                if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                    this.parkRegionDao.addFreeSpaceByPark(vo.getRegionId().longValue(), vo.getNum());
                } else {
                    this.parkRegionDao.updateFreeParkByIds(Collections.singleton(vo.getRegionId()));
                }
                this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
                if (paramHolder.getRegionType() == 2) {
                    this.mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), vo.getRegionId());
                    continue;
                }
                this.mqPushService.pushParkFreeSpace(paramHolder.getParkId());
            }
        }
    }

    protected void saveTrack(CarExitRequest exitRequest, Long regionId, Integer exceptionReason) {
        OrderTrack one = (OrderTrack)this.orderTrackMapper.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTrack.class).eq(OrderTrack::getOrderNum, (Object)exitRequest.getOrderNum())).eq(OrderTrack::getRecordType, (Object)2)).eq(OrderTrack::getRegionId, (Object)regionId)).eq(OrderTrack::getEnexTime, (Object)exitRequest.getExitTime()));
        if (one != null) {
            OrderTrack orderTrack = new OrderTrack();
            orderTrack.setInoutEvent(this.getInoutEvent(exitRequest));
            orderTrack.setOpenReason(exceptionReason);
            orderTrack.setOperAccount(exitRequest.getOperAccount());
            orderTrack.setExTerminal(exitRequest.getExitTerminal());
            this.orderTrackMapper.update((Object)orderTrack, (Wrapper)Wrappers.lambdaQuery(OrderTrack.class).eq(OrderTrack::getId, (Object)one.getId()));
            return;
        }
        OrderTrack orderTrack = new OrderTrack();
        BeanUtils.copyProperties((Object)exitRequest, (Object)orderTrack);
        orderTrack.setInoutEvent(this.getInoutEvent(exitRequest));
        orderTrack.setChannelName(exitRequest.getInandoutName());
        orderTrack.setRegionId(regionId);
        orderTrack.setRecordType(Integer.valueOf(2));
        orderTrack.setEnexTime(exitRequest.getExitTime());
        orderTrack.setImage(exitRequest.getMaxImage());
        orderTrack.setExTerminal(exitRequest.getExitTerminal());
        orderTrack.setOpenReason(exceptionReason);
        this.orderTrackMapper.insert((Object)orderTrack);
    }

    private Integer getInoutEvent(CarExitRequest exitRequest) {
        if (exitRequest.getExitWay() != null) {
            return exitRequest.getExitWay();
        }
        if (exitRequest.getPlateNum().startsWith("\u4e34") && exitRequest.getOperAccount() == null) {
            return 3;
        }
        if (exitRequest.getOperAccount() != null) {
            return 4;
        }
        return 1;
    }
}

