/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.freespace.UpdateParkFreeSpaceServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.order.impl.exit.CommonExitImpl;
import com.icetech.park.service.order.impl.exit.MasterChannelCarOrderExitServiceImpl;
import com.icetech.park.service.order.impl.exit.SubChannelCarOrderExitServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="carOrderExitService")
public class CarOrderExitServiceImpl
extends CommonExitImpl {
    private static final Logger log = LoggerFactory.getLogger(CarOrderExitServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private UpdateParkFreeSpaceServiceImpl updateParkFreeSpaceService;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MasterChannelCarOrderExitServiceImpl masterChannelCarOrderExitService;
    @Autowired
    private SubChannelCarOrderExitServiceImpl subChannelCarOrderExitService;

    @Transactional
    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest) {
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(), exitRequest.getInandoutCode(), null, null, exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        return this.exit(exitRequest, paramHolder, 2, null);
    }

    @Transactional
    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        return this.exit(exitRequest, paramHolder, 2, null);
    }

    @Transactional
    public ObjectResponse<Map<String, Object>> exceptionExit(CarExitRequest exitRequest, Integer oddStatus) {
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(), exitRequest.getInandoutCode(), null, null, exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        return this.exit(exitRequest, paramHolder, 4, oddStatus);
    }

    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus) {
        ObjectResponse<VipType> validVipCar;
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        if (!PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(exitRequest.getType()) && ObjectResponse.isSuccess(validVipCar = paramHolder.getVipTypeResp())) {
            exitRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
        }
        if (StringUtils.isBlank((CharSequence)orderNum) || parkId == null) {
            return ObjectResponse.failed((String)"400");
        }
        OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (Objects.isNull(orderInfo)) {
            log.warn("[\u8ba2\u5355\u4e0d\u5b58\u5728]|\u8ba2\u5355\u7f16\u53f7[{}]", (Object)orderNum);
            return ObjectResponse.failed((String)"404");
        }
        if (orderInfo.getServiceStatus() == 2 && NumberUtils.toPrimitive((Integer)oddStatus) == 4) {
            return ObjectResponse.failed((String)"405", (String)"\u5f53\u524d\u8ba2\u5355\u5df2\u7ecf\u79bb\u573a");
        }
        if (exitRequest.getType() == null) {
            exitRequest.setType(orderInfo.getType());
        }
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        Park park = paramHolder.getParkInfo();
        if (park.getIsInterior() == null || park.getIsInterior() == 0 || orderInfo.getRegionId() == null) {
            return this.orderHandle(exitRequest, paramHolder, status, oddStatus, orderInfo);
        }
        if (parkInoutdevice.getIsMaster() == 1) {
            return this.masterChannelCarOrderExitService.exit(exitRequest, paramHolder, status, oddStatus, orderInfo);
        }
        return this.subChannelCarOrderExitService.exit(exitRequest, paramHolder, status, oddStatus, orderInfo);
    }

    private ObjectResponse<Map<String, Object>> orderHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        this.commonExitFlow(exitRequest, status, oddStatus, parkId, orderNum, orderInfo);
        if (orderInfo.getType().equals(PlateTypeEnum.\u6708\u5361\u8f66.getType())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                log.info("[\u6708\u5361\u8f66\u51fa\u573a] \u51c6\u5907\u5904\u7406plateNum[{}]", (Object)exitRequest.getPlateNum());
                this.monthCarService.exitAbMonthDeal(parkId, exitRequest.getPlateNum(), exitRequest.getExitTime());
            }));
        }
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (!exitRequest.getType().equals(PlateTypeEnum.\u6708\u5361\u8f66.getType()) || NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) == 1) {
            if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                this.updateParkFreeSpaceService.addFreeSpace(parkId, null, 1);
            } else {
                this.updateParkFreeSpaceService.syncFreeSpace(parkId, null);
            }
            this.mqPushService.pushParkFreeSpace(parkId);
        }
        this.asyncHandler(exitRequest, parkId, orderNum, orderInfo, parkConfig, oddStatus);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }
}

