/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.enter;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.order.impl.enter.CommonEnterImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.service.third.MqPushService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class SubChannelCarOrderEnterServiceImpl
extends CommonEnterImpl {
    private static final Logger log = LoggerFactory.getLogger(SubChannelCarOrderEnterServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private ParkRegionDao regionDao;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MqPushService pushService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private MqPushService mqPushService;

    @Transactional
    public ObjectResponse<CarEnterResult> enter(final CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        Long parkId = enterRequest.getParkId();
        this.validateCarInfo(enterRequest, enterRequest.getPlateNum(), enterRequest.getParkId());
        boolean isUpdateFreeSpace = this.orderHandle(enterRequest, paramHolder);
        this.saveTrack(enterRequest, paramHolder.getParkChannel().getRegionId());
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                SubChannelCarOrderEnterServiceImpl.this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> SubChannelCarOrderEnterServiceImpl.this.asyncHandle(enterRequest)));
            }
        });
        CarEnterResult result = new CarEnterResult();
        result.setOrderNum(enterRequest.getOrderNum());
        return ObjectResponse.success((Object)result);
    }

    private boolean orderHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        String orderNum;
        Long parkId = enterRequest.getParkId();
        ParkInoutdevice parkChannel = paramHolder.getParkChannel();
        Long regionId = parkChannel.getRegionId();
        String channelCode = enterRequest.getInandoutCode();
        ArrayList<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<RegionFreeSpaceUpdateVo>();
        ObjectResponse<OrderInfo> infoObjectResponse = this.orderService.findInParkId(enterRequest.getPlateNum(), enterRequest.getParkId());
        OrderInfo orderInfo = (OrderInfo)infoObjectResponse.getData();
        boolean hasMainOrderEnter = true;
        if (orderInfo != null) {
            orderNum = orderInfo.getOrderNum();
            orderInfo.setHasSon(Integer.valueOf(1));
            enterRequest.setOrderNum(orderInfo.getOrderNum());
            this.orderInfoDao.updateByOrderNum(orderInfo);
        } else {
            ObjectResponse<OrderInfo> orderInfoObjectResponse = this.orderService.fuzzyPlate(enterRequest.getParkId(), channelCode, enterRequest.getPlateNum());
            if (ObjectResponse.isSuccess(orderInfoObjectResponse)) {
                orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
                orderNum = orderInfo.getOrderNum();
                enterRequest.setPlateNum(orderInfo.getPlateNum());
                enterRequest.setOrderNum(orderInfo.getPlateNum());
                orderInfo.setHasSon(Integer.valueOf(1));
                this.orderInfoDao.updateByOrderNum(orderInfo);
                log.info("[\u7aef\u4e91-\u5b50\u533a\u57df\u901a\u9053\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u6a21\u7cca\u5339\u914d\u5230\u8ba2\u5355\uff1a{}", (Object)orderInfo);
            } else {
                hasMainOrderEnter = false;
                orderNum = enterRequest.getOrderNum();
                orderInfo = new OrderInfo();
                BeanUtils.copyProperties((Object)enterRequest, (Object)orderInfo);
                orderInfo.setOrderNum(orderNum);
                orderInfo.setHasSon(Integer.valueOf(1));
                ParkRegion parkRegion = this.regionDao.selectOutByParkid(enterRequest.getParkId());
                if (parkRegion == null) {
                    log.warn("[\u7aef\u4e91-\u8865\u4e3b\u8ba2\u5355\u4fe1\u606f] \u65e0\u5916\u533a\u57df\u6570\u636e\uff0c\u53c2\u6570\uff1a{}", (Object)enterRequest);
                    throw new ResponseBodyException("400", "\u8f66\u573a\u7f3a\u5c11\u5916\u533a\u57df");
                }
                orderInfo.setRegionId(parkRegion.getId());
                CarEnterRequest bigParkEnterRequest = new CarEnterRequest();
                bigParkEnterRequest.setType(orderInfo.getType());
                this.validateType(bigParkEnterRequest, orderInfo.getPlateNum(), orderInfo.getParkId(), parkRegion.getId());
                orderInfo.setType(bigParkEnterRequest.getType());
                orderInfo.setCarDesc(bigParkEnterRequest.getCarDesc());
                orderInfo.setServiceStatus(Integer.valueOf(1));
                if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
                    orderInfo.setEnterChannelId(parkChannel.getInandoutCode());
                }
                try {
                    this.orderService.addOrderInfo(orderInfo);
                }
                catch (DuplicateKeyException e) {
                    orderNum = CodeTools.GenerateOrderNum();
                    orderInfo.setOrderNum(orderNum);
                    enterRequest.setOrderNum(orderNum);
                    this.orderService.addOrderInfo(orderInfo);
                }
                OrderCarInfo carInfo = new OrderCarInfo();
                BeanUtils.copyProperties((Object)enterRequest, (Object)carInfo);
                carInfo.setEnterOperAccount(enterRequest.getOperaUser());
                carInfo.setOrderNum(orderNum);
                this.orderCarInfoDao.insert((Object)carInfo);
            }
        }
        if (enterRequest.isReplenishOrder()) {
            paramHolder.setReplenishOrder(orderInfo);
        }
        enterRequest.setOrderNum(orderNum);
        if (hasMainOrderEnter) {
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(orderInfo.getRegionId()).type(orderInfo.getType()).num(1).build());
        } else {
            ParkConfig parkConfig = paramHolder.getParkConfig();
            if (!orderInfo.getType().equals(PlateTypeEnum.\u6708\u5361\u8f66.getType()) || NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) == 1) {
                if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                    this.updateRegionFreeSpaceService.addFreeSpace(parkId, regionId, -1);
                } else {
                    this.updateRegionFreeSpaceService.syncFreeSpace(parkId, regionId);
                }
                this.mqPushService.pushParkFreeSpace(parkId);
            }
        }
        OrderSonInfo innerOrderSonInfo = null;
        OrderSonInfo outOrderSonInfo = null;
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderNum);
        orderSonInfoParam.setParkId(parkId);
        List orderSonInfos = this.orderSonInfoDao.selectList((Object)orderSonInfoParam);
        if (CollectionUtils.isNotEmpty((Collection)orderSonInfos)) {
            Optional<OrderSonInfo> first2;
            Optional<OrderSonInfo> first1 = orderSonInfos.stream().filter(osi -> !regionId.equals(osi.getRegionId())).findFirst();
            if (first1.isPresent()) {
                outOrderSonInfo = first1.get();
            }
            if ((first2 = orderSonInfos.stream().filter(osi -> regionId.equals(osi.getRegionId())).findFirst()).isPresent()) {
                innerOrderSonInfo = first2.get();
            }
        }
        ParkRegion parkRegion = (ParkRegion)this.regionDao.selectById((Serializable)regionId);
        if (innerOrderSonInfo != null) {
            if (innerOrderSonInfo.getServiceStatus() == 1) {
                freeSpaceUpdateVos.clear();
            }
            innerOrderSonInfo.setExitTime(null);
            innerOrderSonInfo.setServiceStatus(Integer.valueOf(1));
            this.orderSonInfoDao.updateById((Object)innerOrderSonInfo);
            log.info("[\u5b50\u901a\u9053\u5165\u573a] \u91cd\u590d\u9a76\u5165\u5185\u573a[{}]", (Object)innerOrderSonInfo);
        } else {
            innerOrderSonInfo = new OrderSonInfo();
            if (regionId.equals(orderInfo.getRegionId())) {
                BeanUtils.copyProperties((Object)orderInfo, (Object)innerOrderSonInfo);
                this.setOrderSonPrice(orderInfo.getParkId(), orderNum, innerOrderSonInfo);
                innerOrderSonInfo.setRegionId(regionId);
                innerOrderSonInfo.setServiceStatus(Integer.valueOf(1));
                if (!hasMainOrderEnter) {
                    innerOrderSonInfo.setNoneEnterFlag(Integer.valueOf(1));
                }
                this.orderSonInfoDao.insertWithPlateNum2(innerOrderSonInfo);
                log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u8868\u7684\u5185\u533a\u57df\u8bb0\u5f55[{}]", (Object)innerOrderSonInfo);
                OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
                OrderSonCarInfo sonCarInfoMain = new OrderSonCarInfo();
                BeanUtils.copyProperties((Object)carInfo, (Object)sonCarInfoMain);
                sonCarInfoMain.setEnterOperAccount(enterRequest.getOperaUser());
                sonCarInfoMain.setOrderSonId(innerOrderSonInfo.getId());
                if (!hasMainOrderEnter) {
                    sonCarInfoMain.setEnterWay(null);
                    sonCarInfoMain.setEnterChannelId(null);
                    sonCarInfoMain.setEnterNo(null);
                    sonCarInfoMain.setEnterImage(null);
                }
                this.orderSonCarInfoDao.insert((Object)sonCarInfoMain);
                log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u8be6\u60c5\u8868\u5b8c\u6210\uff0csonCarInfoMain\uff1a{}", (Object)sonCarInfoMain);
            } else {
                BeanUtils.copyProperties((Object)enterRequest, (Object)innerOrderSonInfo);
                innerOrderSonInfo.setOrderNum(orderNum);
                innerOrderSonInfo.setRegionId(regionId);
                if (enterRequest.getNoneEnterFlag()) {
                    innerOrderSonInfo.setNoneEnterFlag(Integer.valueOf(1));
                }
                this.orderSonInfoDao.insertWithPlateNum2(innerOrderSonInfo);
                OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
                BeanUtils.copyProperties((Object)enterRequest, (Object)sonCarInfo);
                sonCarInfo.setOrderSonId(innerOrderSonInfo.getId());
                sonCarInfo.setOrderNum(orderNum);
                if (!enterRequest.getNoneEnterFlag()) {
                    sonCarInfo.setEnterChannelId(enterRequest.getInandoutCode());
                    sonCarInfo.setEnterNo(enterRequest.getInandoutName());
                    sonCarInfo.setEnterImage(enterRequest.getMaxImage());
                    sonCarInfo.setSmallEnterImage(enterRequest.getSmallImage());
                    sonCarInfo.setEnterReliability(enterRequest.getReliability());
                    sonCarInfo.setEnterOperAccount(enterRequest.getOperaUser());
                }
                this.delTags(enterRequest, orderNum, regionId, (OrderCarInfo)sonCarInfo);
                this.orderSonCarInfoDao.insert((Object)sonCarInfo);
                this.pushService.pushOrderSonEnter(innerOrderSonInfo);
            }
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().regionId(regionId).type(innerOrderSonInfo.getType()).num(-1).build());
        }
        if (outOrderSonInfo != null) {
            outOrderSonInfo.setServiceStatus(Integer.valueOf(2));
            outOrderSonInfo.setExitTime(enterRequest.getEnterTime());
            outOrderSonInfo.setOperAccount(enterRequest.getOperaUser());
            this.orderSonInfoDao.updateById((Object)outOrderSonInfo);
            log.info("\u66f4\u65b0\u5b50\u8ba2\u5355\u8868\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)outOrderSonInfo);
            this.dealAbMonth(parkId, outOrderSonInfo, enterRequest.getEnterTime());
        } else {
            outOrderSonInfo = this.saveOutOrderSonInfo(orderNum, orderInfo, parkRegion.getFatherRelationId(), hasMainOrderEnter, enterRequest.getEnterTime(), enterRequest);
        }
        this.updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        return true;
    }

    private void dealAbMonth(Long parkId, OrderSonInfo orderSonInfo, Long enterTime) {
        if (orderSonInfo.getType().equals(PlateTypeEnum.\u6708\u5361\u8f66.getType())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.monthCarService.innerAreaExitAbMonthDeal(parkId, orderSonInfo.getPlateNum(), enterTime, orderSonInfo.getRegionId())));
        }
    }

    private OrderSonInfo saveOutOrderSonInfo(String orderNum, OrderInfo orderInfo, Long regionId, boolean hasMainOrderEnter, Long enterTime, CarEnterRequest enterRequest) {
        OrderSonInfo orderSonInfoMain = new OrderSonInfo();
        if (orderInfo.getRegionId() != null && orderInfo.getRegionId().equals(regionId)) {
            BeanUtils.copyProperties((Object)orderInfo, (Object)orderSonInfoMain);
            this.setOrderSonPrice(orderInfo.getParkId(), orderNum, orderSonInfoMain);
            orderSonInfoMain.setRegionId(regionId);
            orderSonInfoMain.setServiceStatus(Integer.valueOf(2));
            orderSonInfoMain.setOperAccount(enterRequest.getOperaUser());
            if (!hasMainOrderEnter) {
                orderSonInfoMain.setNoneEnterFlag(Integer.valueOf(1));
            }
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfoMain);
            log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u8868\u7684\u4e3b\u8ba2\u5355\u4fe1\u606f[{}]", (Object)orderSonInfoMain);
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
            OrderSonCarInfo sonCarInfoMain = new OrderSonCarInfo();
            BeanUtils.copyProperties((Object)carInfo, (Object)sonCarInfoMain);
            sonCarInfoMain.setEnterOperAccount(enterRequest.getOperaUser());
            sonCarInfoMain.setOrderSonId(orderSonInfoMain.getId());
            if (!hasMainOrderEnter) {
                sonCarInfoMain.setEnterWay(null);
                sonCarInfoMain.setEnterNo(null);
                sonCarInfoMain.setEnterChannelId(null);
                sonCarInfoMain.setEnterImage(null);
            }
            this.orderSonCarInfoDao.insert((Object)sonCarInfoMain);
            log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u4fe1\u606f\u8868\u5916\u533a\u57df\u4fe1\u606f\u5b8c\u6210\uff0csonCarInfoMain\uff1a{}", (Object)sonCarInfoMain);
            this.dealAbMonth(orderSonInfoMain.getParkId(), orderSonInfoMain, enterTime);
        } else {
            BeanUtils.copyProperties((Object)enterRequest, (Object)orderSonInfoMain);
            orderSonInfoMain.setOrderNum(orderNum);
            orderSonInfoMain.setRegionId(regionId);
            orderSonInfoMain.setExitTime(enterRequest.getEnterTime());
            orderSonInfoMain.setServiceStatus(Integer.valueOf(2));
            orderSonInfoMain.setNoneEnterFlag(Integer.valueOf(1));
            CarEnterRequest bigParkEnterRequest = new CarEnterRequest();
            bigParkEnterRequest.setType(orderInfo.getType());
            this.validateType(bigParkEnterRequest, orderSonInfoMain.getPlateNum(), orderSonInfoMain.getParkId(), regionId);
            orderSonInfoMain.setType(bigParkEnterRequest.getType());
            orderSonInfoMain.setOperAccount(enterRequest.getOperaUser());
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfoMain);
            log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u8868\u7684\u5916\u533a\u5b50\u8ba2\u5355[{}]", (Object)orderSonInfoMain);
            OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties((Object)enterRequest, (Object)sonCarInfo);
            sonCarInfo.setOrderSonId(orderSonInfoMain.getId());
            sonCarInfo.setOrderNum(orderNum);
            sonCarInfo.setExitChannelId(enterRequest.getInandoutCode());
            sonCarInfo.setExitNo(enterRequest.getInandoutName());
            sonCarInfo.setExitImage(enterRequest.getMaxImage());
            sonCarInfo.setSmallExitImage(enterRequest.getSmallImage());
            sonCarInfo.setExitReliability(enterRequest.getReliability());
            this.orderSonCarInfoDao.insert((Object)sonCarInfo);
            log.info("[\u5165\u573a\u670d\u52a1-\u5b50\u901a\u9053] \u63d2\u5165\u5b50\u8ba2\u5355\u4fe1\u606f\u8868\u5916\u533a\u57df\u4fe1\u606f\u5b8c\u6210\uff0csonCarInfo\uff1a{}", (Object)sonCarInfo);
            this.dealAbMonth(orderSonInfoMain.getParkId(), orderSonInfoMain, enterTime);
        }
        return orderSonInfoMain;
    }

    @Override
    protected int checkSamePlate(String plateNum, Long parkId, Long currEnterTime, Integer enterWay, Integer property, boolean replenishOrder, Integer type) {
        if (plateNum.equals("\u672a\u8bc6\u522b")) {
            return 0;
        }
        String part = plateNum.substring(1);
        OrderSonInfo orderInfoRes = this.orderSonInfoDao.fuzzyInParkPlate(parkId, part);
        if (orderInfoRes != null) {
            if (orderInfoRes.getEnterTime() > currEnterTime && orderInfoRes.getEnterTime() < DateTools.unixTimestamp() + OFFSET) {
                log.warn("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u540e\u4e0a\u62a5\u7684\u5165\u573a\u65f6\u95f4\u6bd4\u524d\u6b21\u5c0f[{}]\u79d2\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)(orderInfoRes.getEnterTime() - currEnterTime), (Object)plateNum);
                throw new ResponseBodyException("405", "\u540e\u4e0a\u62a5\u7684\u5165\u573a\u65f6\u95f4\u6bd4\u524d\u6b21\u5c0f");
            }
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u91cd\u590d\u5165\u573a\uff0c\u5f53\u524d\u8f66\u724c\u53f7\uff1a{}\uff0c\u5728\u573a\u8f66\u724c\u53f7{}", (Object)plateNum, (Object)orderInfoRes.getPlateNum());
            OrderSonInfo existsParam = new OrderSonInfo();
            existsParam.setServiceStatus(Integer.valueOf(1));
            existsParam.setPlateNum(plateNum);
            existsParam.setParkId(parkId);
            List existsOrders = this.orderSonInfoService.list((Object)existsParam);
            if (CollectionUtils.isEmpty((Collection)existsOrders)) {
                return 0;
            }
            ArrayList<OrderSonInfo> updateOrders = new ArrayList<OrderSonInfo>(existsOrders.size());
            for (OrderSonInfo existsOrder : existsOrders) {
                OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(existsOrder.getOrderNum());
                if (orderCarInfo != null && orderCarInfo.getEnterWay() != null && !orderCarInfo.getEnterWay().equals(enterWay) && Arrays.asList(orderCarInfo.getEnterWay(), enterWay).contains(5)) continue;
                OrderSonInfo updateOrder = new OrderSonInfo();
                updateOrder.setId(existsOrder.getId());
                updateOrder.setServiceStatus(Integer.valueOf(4));
                updateOrder.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                updateOrder.setExitTime(orderInfoRes.getEnterTime());
                updateOrders.add(updateOrder);
            }
            this.orderSonInfoService.updateBatchById(updateOrders);
            return updateOrders.size();
        }
        return 0;
    }

    private void setOrderSonPrice(Long parkId, String orderNum, OrderSonInfo orderSonInfo) {
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
        if (orderSumFeeDto != null) {
            orderSonInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
            orderSonInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
            orderSonInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
        } else {
            orderSonInfo.setTotalPrice("0.00");
            orderSonInfo.setPaidPrice("0.00");
            orderSonInfo.setDiscountPrice("0.00");
        }
    }
}

