/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.enter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.domain.entity.ReenterRecord;
import com.icetech.order.service.ReenterRecordService;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.other.impl.AutopayServiceImpl;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderEnterService")
public class OrderEnterServiceImpl
implements OrderEnterService {
    private static final Logger log = LoggerFactory.getLogger(OrderEnterServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private AutopayServiceImpl autopayService;
    @Autowired
    private ParkVisitDao parkVisitDao;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected MqPushService pushService;
    @Autowired
    protected ReenterRecordService reenterRecordService;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    protected BlacklistService blacklistService;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private MerchantUserService merchantUserService;

    @Transactional
    public ObjectResponse<Map<String, Object>> enter(EnterRequest enterRequest, String parkCode) {
        String channelCode = enterRequest.getChannelId();
        if (channelCode == null) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice parkChannel = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(channelCode).getData();
        if (parkChannel == null) {
            return ObjectResponse.failed((String)"402", (String)"channelId\u672a\u88ab\u6ce8\u518c");
        }
        ParkRegion parkRegion = parkChannel.getRegionId() == null ? null : (ParkRegion)this.parkRegionDao.selectById((Serializable)parkChannel.getRegionId());
        long fatherRelationId = 0L;
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(enterRequest.getOrderId());
        orderInfo.setParkId(enterRequest.getParkId());
        OrderInfo existsOrder = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (parkRegion == null || (fatherRelationId = NumberUtils.toPrimitive((Long)parkRegion.getFatherRelationId())) == 0L || NumberUtils.toPrimitive((Integer)parkChannel.getIsMaster()) == 1) {
            existsOrder = this.saveMasterOrder(enterRequest, parkCode, parkRegion, parkChannel, existsOrder);
        } else {
            ParkRegion parentRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)Long.valueOf(fatherRelationId));
            if (parentRegion == null) {
                return ObjectResponse.failed((String)"402", (String)"\u533a\u57df\u6240\u5c5e\u4e3b\u533a\u57df\u4e0d\u5b58\u5728");
            }
            ParkRegion originRegion = null;
            ParkRegion destRegion = null;
            if (parkChannel.getInandoutType() == 1) {
                originRegion = parentRegion;
                destRegion = parkRegion;
            } else {
                originRegion = parkRegion;
                destRegion = parentRegion;
            }
            existsOrder = this.saveSonOrder(enterRequest, parkCode, originRegion, destRegion, parkChannel, existsOrder);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderId", existsOrder.getLocalOrderNum());
        map.put("orderNum", existsOrder.getOrderNum());
        return ObjectResponse.success(map);
    }

    private OrderInfo saveMasterOrder(EnterRequest enterRequest, String parkCode, ParkRegion parkRegion, ParkInoutdevice parkChannel, OrderInfo existsOrder) {
        String version;
        String orderNum;
        String plateNum = enterRequest.getPlateNum();
        Long parkId = enterRequest.getParkId();
        String orderId = enterRequest.getOrderId();
        if (existsOrder != null) {
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] orderId\u91cd\u590d\uff0c\u53c2\u6570\uff1a[{},{}]", (Object)parkId, (Object)orderId);
            return existsOrder;
        }
        OrderSonInfo orderSonInfoSearch = new OrderSonInfo();
        orderSonInfoSearch.setLocalOrderNum(orderId);
        orderSonInfoSearch.setParkId(parkId);
        OrderSonInfo orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfoSearch);
        this.checkSamePlate(plateNum, parkCode, parkId, enterRequest);
        OrderInfo orderInfo = existsOrder == null ? new OrderInfo() : existsOrder;
        BeanUtils.copyProperties((Object)enterRequest, (Object)orderInfo);
        String string = orderNum = orderInfo.getId() == null ? CodeTools.GenerateOrderNum() : orderInfo.getOrderNum();
        if (parkRegion != null && StringUtils.isNotBlank((CharSequence)parkRegion.getOrderNum())) {
            orderNum = parkRegion.getOrderNum();
            orderInfo.setHasSon(Integer.valueOf(1));
        }
        if (!Objects.isNull(orderSonInfo)) {
            orderNum = orderSonInfo.getOrderNum();
            orderInfo.setHasSon(Integer.valueOf(1));
        }
        orderInfo.setOrderNum(orderNum);
        orderInfo.setLocalOrderNum(orderId);
        if (!Objects.isNull(parkRegion)) {
            orderInfo.setRegionId(parkRegion.getId());
        }
        if (enterRequest.getNoneEnterFlag()) {
            orderInfo.setNoneEnterFlag(Integer.valueOf(1));
        } else {
            orderInfo.setEnterChannelId(parkChannel.getInandoutCode());
        }
        orderInfo.setServiceStatus(Integer.valueOf(1));
        try {
            this.orderService.addOrderInfo(orderInfo);
        }
        catch (DuplicateKeyException e) {
            orderNum = CodeTools.GenerateOrderNum();
            orderInfo.setOrderNum(orderNum);
            this.orderService.addOrderInfo(orderInfo);
        }
        log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u63d2\u5165\u4e3b\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        OrderCarInfo carInfo = this.buildCarInfo(parkCode, enterRequest, orderInfo, parkChannel);
        this.orderCarInfoDao.insert((Object)carInfo);
        log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u8fdb\u51fa\u573a\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        ObjectResponse parkResp = this.parkService.findByParkId(orderInfo.getParkId());
        if (ObjectResponse.isSuccess((Response)parkResp) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(orderInfo.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex()) {
            OrderTrack orderTrack = new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(orderInfo.getParkId()).setRegionId(orderInfo.getRegionId()).setChannelName(carInfo.getEnterNo()).setOrderNum(orderInfo.getOrderNum()).setEnexTime(enterRequest.getEnterTime()).setPlateNum(enterRequest.getPlateNum()).setType(orderInfo.getType()).setImage(carInfo.getEnterImage()).setInoutEvent(Integer.valueOf(0));
            this.orderTrackService.save((Object)orderTrack);
        }
        this.saveOrderAfter(parkId, orderNum, parkCode, plateNum, enterRequest, carInfo);
        return orderInfo;
    }

    private OrderInfo saveSonOrder(EnterRequest enterRequest, String parkCode, ParkRegion originRegion, ParkRegion destRegion, ParkInoutdevice parkChannel, OrderInfo mainOrder) {
        List orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)enterRequest.getParkId())).eq(OrderInfo::getLocalOrderNum, (Object)enterRequest.getOrderId())).in(OrderInfo::getServiceStatus, new Object[]{1, 2}));
        Map orderSonInfoMap = orderSonInfos.stream().collect(Collectors.toMap(OrderInfo::getRegionId, Function.identity(), (older, newer) -> newer, HashMap::new));
        OrderSonInfo originOrderSon = (OrderSonInfo)orderSonInfoMap.get(originRegion.getId());
        OrderSonInfo destOrderSon = (OrderSonInfo)orderSonInfoMap.get(destRegion.getId());
        OrderCarInfo mainCarInfo = null;
        if (mainOrder == null) {
            mainOrder = new OrderInfo();
            BeanUtils.copyProperties((Object)enterRequest, (Object)mainOrder);
            mainOrder.setOrderNum(CodeTools.GenerateOrderNum()).setLocalOrderNum(enterRequest.getOrderId()).setServiceStatus(Integer.valueOf(1)).setHasSon(Integer.valueOf(1)).setNoneEnterFlag(Integer.valueOf(1));
            String regionName = null;
            if (NumberUtils.toPrimitive((Long)originRegion.getFatherRelationId()) == 0L) {
                mainOrder.setRegionId(originRegion.getId());
                regionName = originRegion.getRegionName();
            } else if (NumberUtils.toPrimitive((Long)destRegion.getFatherRelationId()) == 0L) {
                mainOrder.setRegionId(destRegion.getId());
                regionName = destRegion.getRegionName();
            } else {
                throw new ResponseBodyException("402", "\u4e24\u4e2a\u5b50\u533a\u57df\u65e0\u6cd5\u5207\u6362");
            }
            if (NumberUtils.toPrimitive((Integer)mainOrder.getNoneEnterFlag()) == 0) {
                mainOrder.setEnterChannelId(parkChannel.getInandoutCode());
            }
            this.orderService.addOrderInfo(mainOrder);
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u8865\u5145\u4e3b\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210\uff0corderNum\uff1a{}\uff0c\u533a\u57df\u540d\u79f0\uff1a{}", (Object)mainOrder.getOrderNum(), (Object)regionName);
            mainCarInfo = this.buildCarInfo(parkCode, enterRequest, mainOrder, parkChannel);
            this.orderCarInfoDao.insert((Object)mainCarInfo);
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u8865\u5145\u4e3b\u8ba2\u5355\u8f66\u8f86\u4fe1\u606f\u5b8c\u6210\uff0corderNum\uff1a{}\uff0c\u533a\u57df\u540d\u79f0\uff1a{}", (Object)mainOrder.getOrderNum(), (Object)regionName);
            this.saveOrderAfter(enterRequest.getParkId(), mainOrder.getOrderNum(), parkCode, enterRequest.getPlateNum(), enterRequest, mainCarInfo);
        } else if (NumberUtils.toPrimitive((Integer)mainOrder.getHasSon()) == 0) {
            mainOrder.setHasSon(Integer.valueOf(1));
            OrderInfo updateMain = new OrderInfo().setId(mainOrder.getId()).setHasSon(Integer.valueOf(1));
            this.orderInfoDao.updateById((Object)updateMain);
        }
        OrderCarInfoWrapper mainCarInfoWrapper = new OrderCarInfoWrapper();
        mainCarInfoWrapper.orderCarInfo = mainCarInfo;
        originOrderSon = this.handleOrderSon(parkCode, enterRequest, originRegion, parkChannel, mainOrder, mainCarInfoWrapper, originOrderSon, 2);
        destOrderSon = this.handleOrderSon(parkCode, enterRequest, destRegion, parkChannel, mainOrder, mainCarInfoWrapper, destOrderSon, 1);
        return destOrderSon;
    }

    private OrderSonInfo handleOrderSon(String parkCode, EnterRequest request, ParkRegion parkRegion, ParkInoutdevice parkChannel, OrderInfo mainOrder, OrderCarInfoWrapper mainCarInfoWrapper, OrderSonInfo orderSonInfo, int targetStatus) {
        String version;
        ObjectResponse parkResp;
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            OrderSonCarInfo orderSonCarInfo = null;
            if (mainOrder.getRegionId().equals(parkRegion.getId())) {
                BeanUtils.copyProperties((Object)mainOrder, (Object)orderSonInfo);
                orderSonCarInfo = new OrderSonCarInfo();
                if (mainCarInfoWrapper.orderCarInfo == null) {
                    mainCarInfoWrapper.orderCarInfo = this.orderCarInfoDao.selectByOrderNum(mainOrder.getOrderNum());
                }
                BeanUtils.copyProperties((Object)mainCarInfoWrapper.orderCarInfo, (Object)orderSonCarInfo);
            } else {
                BeanUtils.copyProperties((Object)request, (Object)orderSonInfo);
                orderSonInfo.setRegionId(parkRegion.getId()).setOrderNum(mainOrder.getOrderNum()).setLocalOrderNum(request.getOrderId());
            }
            orderSonInfo.setServiceStatus(Integer.valueOf(targetStatus));
            if (targetStatus == 1) {
                orderSonInfo.setEnterTime(request.getEnterTime());
            } else if (!mainOrder.getRegionId().equals(orderSonInfo.getRegionId())) {
                orderSonInfo.setExitTime(request.getEnterTime());
            }
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            if (orderSonCarInfo == null) {
                orderSonCarInfo = (OrderSonCarInfo)this.buildCarInfo(parkCode, request, (OrderInfo)orderSonInfo, parkChannel);
            }
            orderSonCarInfo.setOrderSonId(orderSonInfo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getPlateColor())) {
                orderSonCarInfo.setPlateColor(request.getPlateColor());
            }
            this.orderSonCarInfoDao.insert((Object)orderSonCarInfo);
        } else if (targetStatus == 1) {
            this.orderSonInfoDao.setInPark(orderSonInfo.getId().longValue());
        } else {
            OrderSonInfo updateOrderSon = new OrderSonInfo();
            updateOrderSon.setId(orderSonInfo.getId()).setServiceStatus(Integer.valueOf(targetStatus));
            if (!mainOrder.getRegionId().equals(orderSonInfo.getRegionId())) {
                updateOrderSon.setExitTime(request.getEnterTime());
            }
            OrderSonCarInfo updateOrderSonCarInfo = new OrderSonCarInfo();
            updateOrderSonCarInfo.setOrderSonId(orderSonInfo.getId()).setExitNo(parkChannel.getInandoutName()).setExitChannelId(parkChannel.getInandoutCode()).setExitImage(this.fillImage(request.getEnterImage(), parkCode)).setSmallExitImage(request.getSmallImage()).setExitReliability(request.getReliability());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getPlateColor())) {
                updateOrderSonCarInfo.setPlateColor(request.getPlateColor());
            }
            this.orderSonInfoDao.updateById((Object)updateOrderSon);
            this.orderSonCarInfoDao.updateByOrderSonId(updateOrderSonCarInfo);
        }
        if (targetStatus == 1 && ObjectResponse.isSuccess((Response)(parkResp = this.parkService.findByParkId(request.getParkId()))) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0 && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkRegion.getParkId()), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex()) {
            OrderTrack orderTrack = new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(parkRegion.getParkId()).setOrderNum(orderSonInfo.getOrderNum()).setRegionId(parkRegion.getId()).setType(orderSonInfo.getType()).setChannelName(parkChannel.getInandoutName()).setEnexTime(request.getEnterTime()).setPlateNum(request.getPlateNum()).setImage(this.fillImage(request.getEnterImage(), parkCode)).setInoutEvent(Integer.valueOf(0));
            this.orderTrackService.save((Object)orderTrack);
        }
        return orderSonInfo;
    }

    private OrderCarInfo buildCarInfo(String parkCode, EnterRequest request, OrderInfo orderInfo, ParkInoutdevice parkChannel) {
        Object orderCarInfo = null;
        orderCarInfo = orderInfo instanceof OrderSonInfo ? new OrderSonCarInfo() : new OrderCarInfo();
        BeanUtils.copyProperties((Object)request, (Object)orderCarInfo);
        orderCarInfo.setOrderNum(orderInfo.getOrderNum());
        String imgFileName = this.fillImage(request.getEnterImage(), parkCode);
        if (orderInfo.getServiceStatus() != 1) {
            orderCarInfo.setExitNo(parkChannel.getInandoutName());
            orderCarInfo.setExitChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setExitImage(imgFileName);
            orderCarInfo.setSmallExitImage(request.getSmallImage());
            orderCarInfo.setExitReliability(request.getReliability());
        }
        if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
            orderCarInfo.setEnterNo(parkChannel.getInandoutName());
            orderCarInfo.setEnterChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setEnterImage(imgFileName);
            orderCarInfo.setSmallEnterImage(request.getSmallImage());
            orderCarInfo.setEnterReliability(request.getReliability());
            orderCarInfo.setEnterWay(request.getInoutEvent());
            orderCarInfo.setEnterOperAccount(request.getOperAccount());
            orderCarInfo.setEnterTerminal(request.getExTerminal());
        }
        return orderCarInfo;
    }

    private String fillImage(String image, String parkCode) {
        if (StringUtils.isNotBlank((CharSequence)image) && !image.contains("/image/")) {
            String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
            String[] ymd = date.split("-");
            image = parkCode + "/image/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/" + image;
        }
        return image;
    }

    protected void saveOrderAfter(Long parkId, String orderNum, String parkCode, String plateNum, EnterRequest enterRequest, OrderCarInfo carInfo) {
        this.autopayService.enterNotify(parkId, orderNum, parkCode, plateNum, enterRequest.getEnterTime(), enterRequest.getType());
        this.sendWebsocketMessage(enterRequest, parkCode, carInfo);
        ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(parkId, plateNum, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (parkVisit != null) {
            ObjectResponse discountObj;
            parkVisit.setVisitStatus(Integer.valueOf(2));
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(Integer.valueOf(0));
            }
            parkVisit.setOrderNum(orderNum);
            parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(enterRequest.getEnterTime())));
            if (parkVisit.getSendFlag() != null && parkVisit.getSendFlag() == 0 && parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() == 1 && ObjectResponse.isSuccess((Response)(discountObj = this.merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId().intValue()))))) {
                MerchantDiscountDto merchantDiscountDto = (MerchantDiscountDto)discountObj.getData();
                BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO : merchantDiscountDto.getDeductMoney();
                OrderDiscount addOrderDis = new OrderDiscount();
                addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId().intValue()));
                addOrderDis.setDiscountNo(CodeTools.GenerateDiscountNo());
                addOrderDis.setParkId(enterRequest.getParkId());
                addOrderDis.setType(Integer.valueOf(merchantDiscountDto.getType()));
                addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                addOrderDis.setAmount(merchantDiscountDto.getAmount());
                addOrderDis.setFrom(Integer.valueOf(1));
                addOrderDis.setOrderNum(orderNum);
                addOrderDis.setPlateNum(plateNum);
                addOrderDis.setDiscountName(merchantDiscountDto.getName());
                addOrderDis.setDeductMoney(Double.valueOf(merchantDiscountDto.getDeductMoney().doubleValue()));
                addOrderDis.setSendTime(new Date());
                addOrderDis.setStatus(Integer.valueOf(0));
                addOrderDis.setUseTime(new Date());
                ObjectResponse addDiscount = this.orderDiscountService.addDiscount(addOrderDis);
                if (ObjectResponse.isSuccess((Response)addDiscount)) {
                    parkVisit.setSendFlag(Integer.valueOf(1));
                    log.info("[\u7aef\u7f51\u4e91\u8bbf\u5ba2\u8f66\u4f18\u60e0]\u6dfb\u52a0\u6210\u529f,\u8fd4\u56de\u7684id:{}", addDiscount.getData());
                }
                this.merchantUserService.subMerchantMoney(Integer.valueOf(merchantDiscountDto.getMerchantId()), deductMoney);
            }
            this.parkVisitDao.updateVisit(parkVisit);
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u66f4\u65b0\u8bbf\u5ba2\u9884\u7ea6\u8868\u5b8c\u6210\uff0corderNum\uff1a{},parkVisit:{}", (Object)orderNum, (Object)parkVisit);
        }
        if (enterRequest.getChannelId() != null) {
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(enterRequest.getChannelId());
            channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
            this.channelAlarmDao.update(channelAlarm);
        }
    }

    private void sendWebsocketMessage(EnterRequest enterRequest, String parkCode, OrderCarInfo carInfo) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(1));
        websocketPushData.setEnterTime(Integer.valueOf(enterRequest.getEnterTime().intValue()));
        websocketPushData.setType(enterRequest.getType());
        websocketPushData.setCarType(enterRequest.getCarType());
        websocketPushData.setChannelId(enterRequest.getChannelId());
        websocketPushData.setEnterNo(carInfo.getEnterNo());
        websocketPushData.setParkCode(parkCode);
        websocketPushData.setPlateNum(enterRequest.getPlateNum());
        websocketPushData.setPlateColor(carInfo.getPlateColor());
        websocketPushData.setOrderNum(carInfo.getOrderNum());
        String data = JsonUtils.toString((Object)websocketPushData);
        log.info("sendWebsocketMessage redis\u6d88\u606f\u8ba2\u9605\u5185\u5bb9 {}", (Object)data);
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)data);
    }

    private void checkSamePlate(String plateNum, String parkCode, Long parkId, EnterRequest enterRequest) {
        if (plateNum.equals("\u672a\u8bc6\u522b")) {
            return;
        }
        if (plateNum.equals("\u65e0\u724c\u8f66")) {
            return;
        }
        String part = plateNum.substring(1);
        OrderInfo orderInfo_res = this.orderInfoDao.fuzzyInParkPlate2(parkId, part);
        if (orderInfo_res != null) {
            boolean moreThan5Minutes;
            ObjectResponse objectResponse;
            boolean notFreeVip;
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u91cd\u590d\u5165\u573a\uff0c\u5f53\u524d\u8f66\u724c\u53f7\uff1a{}\uff0c\u5df2\u5728\u573a\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum, (Object)orderInfo_res.getPlateNum());
            OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo_res.getOrderNum());
            if (orderCarInfo != null && Integer.valueOf(5).equals(orderCarInfo.getEnterWay())) {
                return;
            }
            OrderInfoUpdate orderInfoUpdate = new OrderInfoUpdate();
            OrderInfo orderInfoNeo = new OrderInfo();
            orderInfoNeo.setServiceStatus(Integer.valueOf(4));
            orderInfoNeo.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
            orderInfoNeo.setExitTime(orderInfo_res.getEnterTime());
            orderInfoUpdate.setNeo(orderInfoNeo);
            OrderInfo orderInfoOld = new OrderInfo();
            orderInfoOld.setServiceStatus(Integer.valueOf(1));
            orderInfoOld.setParkId(parkId);
            orderInfoOld.setPlateNum(orderInfo_res.getPlateNum());
            orderInfoUpdate.setOld(orderInfoOld);
            this.orderInfoDao.updateStatus(orderInfoUpdate);
            boolean notMonthCar = !PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(enterRequest.getType());
            boolean bl = notFreeVip = !PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(enterRequest.getType());
            if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(enterRequest.getType()) && ObjectResponse.isSuccess((Response)(objectResponse = this.vipCarService.getRecentVipCar(parkId, plateNum, null))) && !Integer.valueOf(1).equals(((VipType)objectResponse.getData()).getType())) {
                notFreeVip = true;
            }
            boolean bl2 = moreThan5Minutes = (enterRequest.getEnterTime() - orderInfo_res.getEnterTime()) / 60L >= 5L;
            if (notMonthCar && notFreeVip && moreThan5Minutes && 2 != NumberUtils.toPrimitive((Integer)enterRequest.getInoutEvent())) {
                ParkConfig config;
                ReenterRecord reenterRecord = ReenterRecord.builder().orderNum(orderInfo_res.getOrderNum()).parkId(parkId).plateNum(orderInfo_res.getPlateNum()).carType(orderInfo_res.getCarType()).enterTime(orderInfo_res.getEnterTime()).exitTime(orderInfo_res.getEnterTime()).build();
                this.reenterRecordService.addReenterRecord(reenterRecord);
                ObjectResponse configObj = this.parkService.getParkConfig(parkCode);
                if (ObjectResponse.isSuccess((Response)configObj) && Objects.nonNull(configObj.getData()) && NumberUtils.toPrimitive((Integer)(config = (ParkConfig)configObj.getData()).getEnableReenterBlack()) == 1 && config.getReenterBlackTime() != null && config.getReenterBlackTime() > 0) {
                    this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                        try {
                            RLock lock = this.redissonDistributedLock.getLock("lock:blacklist:" + parkId + ":" + plateNum);
                            if (!lock.tryLock(0L, 2L, TimeUnit.SECONDS)) {
                                log.info("\u7aef\u7f51\u4e91\u9ed1\u540d\u5355\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u5904\u7406|{}|{}", (Object)parkId, (Object)plateNum);
                                return;
                            }
                            this.asyncBlackListHandle(reenterRecord, parkId, plateNum, config.getReenterBlackTime());
                        }
                        catch (Exception e) {
                            log.error("\u7aef\u7f51\u4e91\u9ed1\u540d\u5355\u5904\u7406\u5931\u8d25, plateNum[{}]", (Object)plateNum);
                        }
                    }));
                }
            } else {
                log.info("[\u7aef\u7f51\u4e91\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u91cd\u590d\u5165\u573a\u4e0d\u7b26\u5408\u52a0\u5165\u9ed1\u540d\u5355\u6761\u4ef6,  \u4e0d\u662f\u9065\u63a7\u5668[{}], \u8d85\u8fc75\u5206\u949f[{}]", (Object)enterRequest.getInoutEvent(), (Object)moreThan5Minutes);
            }
            if (Integer.valueOf(1).equals(orderInfo_res.getHasSon())) {
                this.orderSonInfoDao.setException(orderInfo_res.getOrderNum(), orderInfoNeo.getExitTime(), OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
            }
            orderInfo_res.setServiceStatus(Integer.valueOf(4));
            orderInfo_res.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
            orderInfo_res.setExitTime(orderInfo_res.getEnterTime());
            this.pushService.pushOrderExit(orderInfo_res);
            orderInfo_res.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.autopayService.exitNotify(orderInfo_res, parkCode)));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void asyncBlackListHandle(ReenterRecord record, Long parkId, String plateNum, Integer reenterBlackTime) {
        int count = this.reenterRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReenterRecord.class).eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0)).ne(ReenterRecord::getOrderNum, (Object)record.getOrderNum()));
        if (++count >= reenterBlackTime) {
            ObjectResponse blackListObj = this.blacklistService.getValidByPlate(parkId, plateNum);
            if (ObjectResponse.isSuccess((Response)blackListObj)) {
                Blacklist blacklist = (Blacklist)blackListObj.getData();
                Blacklist newBlackList = new Blacklist();
                newBlackList.setId(blacklist.getId());
                newBlackList.setRepeatNumbers(Integer.valueOf(count));
                if (Integer.valueOf(2).equals(blacklist.getOperateType())) {
                    log.info("[\u7aef\u7f51\u4e91\u91cd\u590d\u5165\u573a] \u9ed1\u540d\u5355\u5df2\u6dfb\u52a0, \u76f4\u63a5\u8fd4\u56de, [{}]", (Object)blacklist);
                    return;
                }
                this.blacklistService.updateById((Object)newBlackList);
                ReenterRecord reenterRecord = new ReenterRecord();
                reenterRecord.setBlackId(Long.valueOf(blacklist.getId().longValue()));
                this.reenterRecordService.update((Object)reenterRecord, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0));
            } else {
                Blacklist blacklist = Blacklist.builder().parkId(parkId).plate(plateNum).owner(plateNum).carType(record.getCarType()).type(Integer.valueOf(1)).status(Integer.valueOf(0)).operateType(Integer.valueOf(2)).repeatNumbers(Integer.valueOf(count)).operAccount("system").build();
                ObjectResponse response = this.blacklistService.addBlackList(blacklist);
                if (ObjectResponse.isSuccess((Response)response)) {
                    ReenterRecord reenterRecord = new ReenterRecord();
                    reenterRecord.setBlackId(Long.valueOf(blacklist.getId().longValue()));
                    this.reenterRecordService.update((Object)reenterRecord, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0));
                    SendInfo sendInfo = new SendInfo(parkId, reenterRecord.getBlackId(), DownServiceEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getServiceType());
                    this.sendInfoDao.insert((Object)sendInfo);
                }
            }
        }
    }

    private static class OrderCarInfoWrapper {
        OrderCarInfo orderCarInfo;

        private OrderCarInfoWrapper() {
        }
    }
}

