/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.enter;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.freespace.UpdateRegionFreeSpaceServiceImpl;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.order.impl.enter.CommonEnterImpl;
import com.icetech.park.service.report.ReportParamHolder;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class MasterChannelCarOrderEnterServiceImpl
extends CommonEnterImpl {
    private static final Logger log = LoggerFactory.getLogger(MasterChannelCarOrderEnterServiceImpl.class);
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private UpdateRegionFreeSpaceServiceImpl updateRegionFreeSpaceService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Transactional
    public ObjectResponse<CarEnterResult> enter(final CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        int influenceLines;
        Long parkId;
        block5: {
            parkId = enterRequest.getParkId();
            this.validateCarInfo(enterRequest, enterRequest.getPlateNum(), enterRequest.getParkId());
            influenceLines = 0;
            try {
                influenceLines = this.checkSamePlate(enterRequest.getPlateNum(), enterRequest.getParkId(), enterRequest.getEnterTime(), enterRequest.getEnterWay(), enterRequest.getProperty(), enterRequest.isReplenishOrder(), enterRequest.getType());
            }
            catch (ResponseBodyException e) {
                if (!e.getErrCode().equals("405")) break block5;
                log.warn("\u5904\u7406\u5931\u8d25: {}:{}. enterRequest[{}]", new Object[]{e.getErrCode(), e.getMessage(), enterRequest, e});
                CarEnterResult result = new CarEnterResult();
                result.setOrderNum(enterRequest.getOrderNum());
                return ObjectResponse.success((Object)result);
            }
        }
        this.orderHandle(enterRequest, paramHolder);
        this.saveTrack(enterRequest, paramHolder.getParkChannel().getRegionId());
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (!(influenceLines != 0 || this.isMonthCard(enterRequest, paramHolder) && NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) != 1)) {
            if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                this.updateRegionFreeSpaceService.addFreeSpace(parkId, paramHolder.getParkChannel().getRegionId(), -1);
            } else {
                this.updateRegionFreeSpaceService.syncFreeSpace(parkId, paramHolder.getParkChannel().getRegionId());
            }
            this.mqPushService.pushParkFreeSpace(parkId);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                MasterChannelCarOrderEnterServiceImpl.this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> MasterChannelCarOrderEnterServiceImpl.this.asyncHandle(enterRequest)));
            }
        });
        CarEnterResult result = new CarEnterResult();
        result.setOrderNum(enterRequest.getOrderNum());
        return ObjectResponse.success((Object)result);
    }

    private void orderHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        ParkInoutdevice parkChannel = paramHolder.getParkChannel();
        OrderInfo orderInfo = new OrderInfo();
        BeanUtils.copyProperties((Object)enterRequest, (Object)orderInfo);
        String orderNum = enterRequest.getOrderNum();
        orderInfo.setOrderNum(orderNum);
        orderInfo.setHasSon(Integer.valueOf(0));
        orderInfo.setRegionId(parkChannel.getRegionId());
        if (enterRequest.getNoneEnterFlag()) {
            orderInfo.setNoneEnterFlag(Integer.valueOf(1));
        } else {
            orderInfo.setEnterChannelId(enterRequest.getInandoutCode());
        }
        orderInfo.setServiceStatus(Integer.valueOf(1));
        try {
            this.orderService.addOrderInfo(orderInfo);
        }
        catch (DuplicateKeyException e) {
            orderNum = CodeTools.GenerateOrderNum();
            enterRequest.setOrderNum(orderNum);
            orderInfo.setOrderNum(orderNum);
            this.orderService.addOrderInfo(orderInfo);
        }
        log.info("[\u7aef\u4e91-\u4e3b\u901a\u9053\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
        if (orderCarInfo == null) {
            OrderCarInfo carInfo = new OrderCarInfo();
            BeanUtils.copyProperties((Object)enterRequest, (Object)carInfo);
            carInfo.setOrderNum(orderNum);
            if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
                carInfo.setEnterChannelId(enterRequest.getInandoutCode());
                carInfo.setEnterNo(enterRequest.getInandoutName());
                carInfo.setEnterImage(enterRequest.getMaxImage());
                carInfo.setSmallEnterImage(enterRequest.getSmallImage());
                carInfo.setEnterOperAccount(enterRequest.getOperaUser());
                carInfo.setEnterReliability(enterRequest.getReliability());
            } else {
                carInfo.setEnterWay(null);
            }
            this.delTags(enterRequest, orderNum, parkChannel.getRegionId(), carInfo);
            this.orderCarInfoDao.insert((Object)carInfo);
            log.info("[\u7aef\u4e91-\u4e3b\u901a\u9053\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u8fdb\u51fa\u573a\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        }
        if (enterRequest.isReplenishOrder()) {
            paramHolder.setReplenishOrder(orderInfo);
        }
    }
}

