/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl.enter;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.utils.FuzzyPlateTools;
import com.icetech.city.common.api.BlacklistApi;
import com.icetech.city.common.domain.entity.common.Blacklist;
import com.icetech.city.common.domain.entity.common.BlacklistPark;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.vip.VipInfoDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.domain.entity.ReenterRecord;
import com.icetech.order.service.OrderTagsService;
import com.icetech.order.service.ReenterRecordService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.freespace.UpdateRegionFreeSpaceServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.MqPushService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.annotation.Transactional;

public class CommonEnterImpl
implements CarOrderEnterService {
    private static final Logger log = LoggerFactory.getLogger(CommonEnterImpl.class);
    @Autowired
    protected OrderInfoDao orderInfoDao;
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected UpdateRegionFreeSpaceServiceImpl updateRegionFreeSpaceService;
    @Autowired
    protected MonthCarServiceImpl monthCarService;
    @Autowired
    protected VehiclePlateDao vehiclePlateDao;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected VipCarService vipCarService;
    @Autowired
    protected ParkVisitDao parkVisitDao;
    @Autowired
    protected ParkVisitService parkVisitService;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected MonthInfoDao monthInfoDao;
    @Autowired
    protected VipInfoDao vipInfoDao;
    @Autowired
    protected StoreCardService storeCardService;
    @Autowired
    protected OrderServiceImpl orderService;
    @Autowired
    protected StringRedisTemplate redisTemplate;
    @Autowired
    protected OrderTagsService orderTagsService;
    @Autowired
    protected ThreadPoolExecutor asyncExecutor;
    @Autowired
    protected OrderTrackMapper orderTrackMapper;
    @Autowired
    protected MqPushService mqPushService;
    @Autowired
    protected OrderSonInfoDao orderSonInfoDao;
    @Autowired
    protected MqPushService pushService;
    @Autowired
    protected ReenterRecordService reenterRecordService;
    @Autowired
    protected BlacklistService blacklistService;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private ThirdInfoService thirdInfoService;
    @Resource
    private MoreMonthParkService moreMonthParkService;
    @Resource
    private OrderPayService orderPayService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private BlacklistApi cityBlacklistApi;
    protected static final Long OFFSET = 600L;

    protected void validateCarInfo(CarEnterRequest enterRequest, String plateNum, Long parkId) {
        int isOpenVaguetype;
        Long regionId;
        if ("\u672a\u8bc6\u522b".equals(plateNum)) {
            return;
        }
        String inandoutCode = enterRequest.getInandoutCode();
        ParkInoutdevice parkChannel = null;
        if (inandoutCode != null) {
            parkChannel = (ParkInoutdevice)this.parkService.getInoutDeviceByCode(inandoutCode).getData();
        }
        Long l = regionId = parkChannel != null && parkChannel.getRegionId() != null ? parkChannel.getRegionId() : null;
        if (!enterRequest.isDebug() && enterRequest.getOpenFlag() != null && enterRequest.getOpenFlag() == 1) {
            this.validateType(enterRequest, plateNum, parkId, regionId);
        }
        if (PlateTypeEnum.\u4e34\u65f6\u8f66.getType().equals(enterRequest.getType()) && Objects.nonNull(parkChannel) && (isOpenVaguetype = NumberUtils.toPrimitive((Integer)parkChannel.getIsOpenVaguetype())) == 1) {
            ObjectResponse visitCar;
            Boolean isMonthCard;
            boolean recWrongPlate = false;
            int vaguetype = NumberUtils.toPrimitive((Integer)parkChannel.getVaguetype());
            List partOfPlateList = FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)vaguetype);
            String newPlateNum = this.monthInfoDao.fuzzyValidatePlate(parkId, partOfPlateList);
            if (newPlateNum != null && !newPlateNum.equals(plateNum) && (isMonthCard = this.monthCarService.judgeMonthCar(parkId, newPlateNum, regionId)).booleanValue()) {
                recWrongPlate = true;
                enterRequest.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                log.info("\u6708\u5361\u8f66\u8f86{}", (Object)newPlateNum);
            }
            if (!recWrongPlate && (newPlateNum = this.vipInfoDao.fuzzyValidatePlate(parkId, partOfPlateList)) != null && !newPlateNum.equals(plateNum)) {
                recWrongPlate = true;
                enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
                log.info("VIP\u8f66\u8f86{}", (Object)newPlateNum);
            }
            if (!recWrongPlate && (newPlateNum = this.parkVisitDao.fuzzyValidatePlate(parkId, partOfPlateList)) != null && !newPlateNum.equals(plateNum) && ObjectResponse.isSuccess((Response)(visitCar = this.parkVisitService.checkVisitPlate(parkId, newPlateNum)))) {
                recWrongPlate = true;
                enterRequest.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
                log.info("\u8bbf\u5ba2\u8f66\u8f86{}", (Object)newPlateNum);
            }
            if (recWrongPlate) {
                enterRequest.setPlateNum(newPlateNum);
                log.info("[\u7aef\u4e91-\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u4e0a\u62a5\u8f66\u724c[{}]\uff0c\u6a21\u7cca\u5339\u914d\u8f66\u724c[{}]", (Object)plateNum, (Object)newPlateNum);
            }
        }
    }

    protected void validateType(CarEnterRequest enterRequest, String plateNum, Long parkId, Long regionId) {
        Integer btype;
        if ("\u672a\u8bc6\u522b".equals(plateNum)) {
            return;
        }
        MonthAbDto monthAbDto = this.monthCarService.abMonthCar(parkId, plateNum, regionId);
        if (monthAbDto != null) {
            if (monthAbDto.getMonthCar().booleanValue()) {
                enterRequest.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                log.info("\u6708\u5361\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
                return;
            }
            if (monthAbDto.getAbCar().booleanValue()) {
                ArrayList<TagsDto> tagsDtos = new ArrayList<TagsDto>();
                TagsDto tagsDto = TagsDto.builder().tagId(Integer.valueOf(1)).regionId(regionId).remark(monthAbDto.getPlotCount() + "\u4f4d" + monthAbDto.getPlateNumCount() + "\u8f66\u7b2c" + monthAbDto.getIndex() + "\u8f66").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                log.info("\u591a\u4f4d\u591a\u8f66\u6708\u5361\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
                return;
            }
        }
        if (Blacklist.PLATE_TYPE_WHITE.equals(btype = this.cityBlacklistApi.getPlateType(plateNum, BlacklistPark.PARK_TYPE_PARK, parkId))) {
            enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
            log.info("\u767d\u540d\u5355\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
            return;
        }
        VehiclePlate vehiclePlate = this.vehiclePlateDao.selectVip(enterRequest.getParkId(), enterRequest.getPlateNum());
        if (vehiclePlate != null) {
            enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
            log.info("\u6d4e\u5357VIP\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
        } else {
            ObjectResponse validVipCar = this.vipCarService.getValidVipCar(parkId, plateNum, regionId);
            if (ObjectResponse.isSuccess((Response)validVipCar)) {
                enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
                enterRequest.setCarDesc(((VipType)validVipCar.getData()).getName());
                log.info("VIP\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
            } else {
                ObjectResponse visitCar = this.parkVisitService.checkVisitPlate(parkId, plateNum);
                if (ObjectResponse.isSuccess((Response)visitCar)) {
                    enterRequest.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
                    log.info("\u8bbf\u5ba2\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
                } else {
                    ObjectResponse objectResponse = this.storeCardService.getValidStoreCards(enterRequest.getPlateNum(), parkId);
                    if (objectResponse != null && "200".equals(objectResponse.getCode())) {
                        enterRequest.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
                        log.info("\u50a8\u503c\u5361\u8f66, {}", (Object)enterRequest.getPlateNum());
                    } else {
                        Integer type = enterRequest.getType();
                        if (!PlateTypeEnum.\u7279\u6b8a\u8f66\u8f86.getType().equals(type)) {
                            enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                            log.info("\u4e34\u65f6\u8f66\u8f86, {}", (Object)enterRequest.getPlateNum());
                        }
                    }
                }
            }
        }
    }

    protected void delTags(CarEnterRequest enterRequest, String orderNum, Long regionId, OrderCarInfo carInfo) {
        if (CollectionUtil.isNotEmpty((Collection)enterRequest.getTags())) {
            List tags = enterRequest.getTags();
            String tagIds = tags.stream().map(TagsDto::getTagId).map(String::valueOf).collect(Collectors.joining(","));
            carInfo.setTags(tagIds);
            List orderTags = tags.stream().map(tagsDto -> OrderTags.builder().orderNum(orderNum).parkId(enterRequest.getParkId()).regionId(regionId).tagId(tagsDto.getTagId()).remark(tagsDto.getRemark()).build()).collect(Collectors.toList());
            this.orderTagsService.saveBatch(orderTags);
        }
    }

    protected void asyncHandle(CarEnterRequest enterRequest) {
        Long parkId = enterRequest.getParkId();
        String plateNum = enterRequest.getPlateNum();
        String orderNum = enterRequest.getOrderNum();
        ParkVisit parkVisit = this.parkVisitDao.selectVisitByParkidPlate(parkId, plateNum, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (parkVisit != null) {
            ObjectResponse discountObj;
            parkVisit.setVisitStatus(Integer.valueOf(2));
            Integer inoutMore = parkVisit.getInoutMore();
            if (ParkVisitMoreType.ONE.getType().equals(inoutMore)) {
                parkVisit.setInoutNum(Integer.valueOf(0));
            }
            parkVisit.setOrderNum(orderNum);
            parkVisit.setEnterTime(Integer.valueOf(Math.toIntExact(enterRequest.getEnterTime())));
            if (parkVisit.getSendFlag() != null && parkVisit.getSendFlag() == 0 && parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() == 1 && ObjectResponse.isSuccess((Response)(discountObj = this.merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId().intValue()))))) {
                MerchantDiscountDto merchantDiscountDto = (MerchantDiscountDto)discountObj.getData();
                BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO : merchantDiscountDto.getDeductMoney();
                OrderDiscount addOrderDis = new OrderDiscount();
                addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId().intValue()));
                addOrderDis.setDiscountNo(CodeTools.GenerateDiscountNo());
                addOrderDis.setParkId(enterRequest.getParkId());
                addOrderDis.setType(Integer.valueOf(merchantDiscountDto.getType()));
                addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                addOrderDis.setAmount(merchantDiscountDto.getAmount());
                addOrderDis.setFrom(Integer.valueOf(1));
                addOrderDis.setOrderNum(orderNum);
                addOrderDis.setPlateNum(plateNum);
                addOrderDis.setDiscountName(merchantDiscountDto.getName());
                addOrderDis.setDeductMoney(Double.valueOf(merchantDiscountDto.getDeductMoney().doubleValue()));
                addOrderDis.setSendTime(new Date());
                addOrderDis.setStatus(Integer.valueOf(0));
                addOrderDis.setUseTime(new Date());
                ObjectResponse addDiscount = this.orderDiscountService.addDiscount(addOrderDis);
                if (ObjectResponse.isSuccess((Response)addDiscount)) {
                    parkVisit.setSendFlag(Integer.valueOf(1));
                    log.info("[\u8bbf\u5ba2\u8f66\u4f18\u60e0]\u6dfb\u52a0\u6210\u529f,\u8fd4\u56de\u7684id:{}", addDiscount.getData());
                }
                this.merchantUserService.subMerchantMoney(Integer.valueOf(merchantDiscountDto.getMerchantId()), deductMoney);
            }
            this.parkVisitDao.updateVisit(parkVisit);
            log.info("[\u7aef\u4e91-\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u66f4\u65b0\u8bbf\u5ba2\u9884\u7ea6\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        }
        this.sendWebsocketMessage(enterRequest, 1);
        if (enterRequest.getInandoutCode() != null) {
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(enterRequest.getInandoutCode());
            channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
            this.channelAlarmDao.update(channelAlarm);
        }
        this.haidaMore(parkId, plateNum);
    }

    private void haidaMore(Long parkId, String plateNum) {
        MonthInfo monthInfo;
        if (Objects.nonNull(this.thirdInfoService.selectHaiDaJituan(parkId)) && Objects.nonNull(monthInfo = this.monthInfoDao.selectByPlateNum(parkId, plateNum, Integer.valueOf(1))) && monthInfo.getMoreMonthType() != null && monthInfo.getMoreMonthType() == 1) {
            log.info("[\u6d77\u5927\u5b9a\u5236\u66f4\u65b0\u5176\u4f59\u8f66\u573a\u7684\u5f02\u5e38\u8ba2\u5355\u4e3a\u5f02\u5e38\u79bb\u573a]");
            List<MoreMonthPark> moreMonthParks = this.moreMonthParkService.getMonthParkByMoreMonthId(monthInfo.getMoreMonthId());
            List parkIds = moreMonthParks.stream().map(MoreMonthPark::getParkId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(parkIds)) {
                parkIds = parkIds.stream().filter(item -> !item.equals(parkId)).collect(Collectors.toList());
                List orderInfos = this.orderInfoDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getParkId, parkIds)).eq(OrderInfo::getPlateNum, (Object)plateNum)).eq(OrderInfo::getServiceStatus, (Object)1));
                if (CollectionUtil.isNotEmpty((Collection)orderInfos)) {
                    orderInfos.forEach(item -> {
                        OrderInfoUpdate orderInfoUpdate = new OrderInfoUpdate();
                        OrderInfo orderInfoNeo = new OrderInfo();
                        orderInfoNeo.setServiceStatus(Integer.valueOf(4));
                        orderInfoNeo.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                        orderInfoNeo.setExitTime(item.getEnterTime());
                        orderInfoUpdate.setNeo(orderInfoNeo);
                        OrderInfo orderInfoOld = new OrderInfo();
                        orderInfoOld.setServiceStatus(Integer.valueOf(1));
                        orderInfoOld.setParkId(item.getParkId());
                        orderInfoOld.setPlateNum(item.getPlateNum());
                        orderInfoUpdate.setOld(orderInfoOld);
                        this.orderInfoDao.updateStatus(orderInfoUpdate);
                    });
                }
            }
        }
    }

    public void sendWebsocketMessage(CarEnterRequest enterRequest, Integer allow) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(Integer.valueOf(1));
        websocketPushData.setEnterTime(Integer.valueOf(enterRequest.getEnterTime().intValue()));
        websocketPushData.setType(enterRequest.getType());
        websocketPushData.setCarType(enterRequest.getCarType());
        websocketPushData.setChannelId(enterRequest.getInandoutCode());
        websocketPushData.setEnterNo(enterRequest.getInandoutName());
        websocketPushData.setParkCode(enterRequest.getParkCode());
        websocketPushData.setPlateNum(enterRequest.getPlateNum());
        websocketPushData.setPlateColor(enterRequest.getPlateColor());
        Integer property = enterRequest.getProperty();
        if (property != null && property == 2) {
            websocketPushData.setOpened(Integer.valueOf(1));
        } else {
            websocketPushData.setOpened(Integer.valueOf(0));
        }
        Integer openFlag = enterRequest.getOpenFlag();
        if (openFlag != null && openFlag == 1 || allow == 1) {
            websocketPushData.setOpened(Integer.valueOf(1));
        } else {
            websocketPushData.setOpened(Integer.valueOf(0));
        }
        websocketPushData.setAllow(Integer.valueOf(websocketPushData.getOpened() == 1 ? 1 : allow));
        websocketPushData.setOrderNum(enterRequest.getOrderNum());
        String data = JsonUtils.toString((Object)websocketPushData);
        log.info("sendWebsocketMessage redis\u6d88\u606f\u8ba2\u9605\u5185\u5bb9 {}", (Object)data);
        this.redisTemplate.convertAndSend("parkToWebscoket", (Object)data);
    }

    protected int checkSamePlate(String plateNum, Long parkId, Long currEnterTime, Integer enterWay, Integer property, boolean replenishOrder, Integer type) {
        if (plateNum.equals("\u672a\u8bc6\u522b")) {
            return 0;
        }
        String part = plateNum.substring(1);
        OrderInfo orderInfoRes = this.orderInfoDao.fuzzyInParkPlate2(parkId, part);
        if (orderInfoRes != null) {
            ObjectResponse parkConfigResp;
            ParkConfig parkConfig;
            if (orderInfoRes.getEnterTime() > currEnterTime && orderInfoRes.getEnterTime() < DateTools.unixTimestamp() + OFFSET) {
                log.warn("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u540e\u4e0a\u62a5\u7684\u5165\u573a\u65f6\u95f4\u6bd4\u524d\u6b21\u5c0f[{}]\u79d2\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)(orderInfoRes.getEnterTime() - currEnterTime), (Object)plateNum);
                if (replenishOrder) {
                    return 0;
                }
                throw new ResponseBodyException("405", "\u540e\u4e0a\u62a5\u7684\u5165\u573a\u65f6\u95f4\u6bd4\u524d\u6b21\u5c0f");
            }
            log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u91cd\u590d\u5165\u573a\uff0c\u5f53\u524d\u8f66\u724c\u53f7\uff1a{}\uff0c\u5728\u573a\u8f66\u724c\u53f7[{}]", (Object)plateNum, (Object)orderInfoRes.getPlateNum());
            OrderInfo existsParam = new OrderInfo();
            existsParam.setServiceStatus(Integer.valueOf(1));
            existsParam.setPlateNum(plateNum);
            existsParam.setParkId(parkId);
            List existsOrders = this.orderInfoDao.selectList((Object)existsParam);
            if (CollectionUtils.isEmpty((Collection)existsOrders)) {
                return 0;
            }
            boolean realTime = Integer.valueOf(1).equals(property);
            boolean notRemoteControlOpen = 2 != NumberUtils.toPrimitive((Integer)enterWay);
            ArrayList<OrderInfo> updateOrders = new ArrayList<OrderInfo>(existsOrders.size());
            ArrayList<ReenterRecord> reenterRecords = new ArrayList<ReenterRecord>(existsOrders.size());
            for (OrderInfo existsOrder : existsOrders) {
                boolean moreThan5Minutes;
                ObjectResponse objectResponse;
                boolean notFreeVip;
                OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(existsOrder.getOrderNum());
                if (orderCarInfo != null && orderCarInfo.getEnterWay() != null && !orderCarInfo.getEnterWay().equals(enterWay) && Arrays.asList(orderCarInfo.getEnterWay(), enterWay).contains(5)) continue;
                OrderPayCondition orderPayCondition = new OrderPayCondition();
                orderPayCondition.setParkId(existsOrder.getParkId());
                orderPayCondition.setOrderNum(existsOrder.getOrderNum());
                orderPayCondition.setPayStatus(Integer.valueOf(2));
                ObjectResponse sumPay = this.orderPayService.getSumPay(orderPayCondition);
                OrderInfo updateOrder = new OrderInfo();
                updateOrder.setId(existsOrder.getId());
                updateOrder.setServiceStatus(Integer.valueOf(4));
                updateOrder.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                updateOrder.setExitTime(existsOrder.getEnterTime());
                if (ObjectResponse.isSuccess((Response)sumPay)) {
                    OrderSumFeeDto orderSumFeeDto = (OrderSumFeeDto)sumPay.getData();
                    updateOrder.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    updateOrder.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    updateOrder.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                } else {
                    updateOrder.setTotalPrice("0.00");
                    updateOrder.setPaidPrice("0.00");
                    updateOrder.setDiscountPrice("0.00");
                }
                updateOrders.add(updateOrder);
                boolean notMonthCar = !PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type);
                boolean bl = notFreeVip = !PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(type);
                if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(type) && ObjectResponse.isSuccess((Response)(objectResponse = this.vipCarService.getRecentVipCar(parkId, plateNum, null))) && !Integer.valueOf(1).equals(((VipType)objectResponse.getData()).getType())) {
                    notFreeVip = true;
                }
                boolean bl2 = moreThan5Minutes = (currEnterTime - existsOrder.getEnterTime()) / 60L >= 5L;
                if (notMonthCar && notFreeVip && realTime && notRemoteControlOpen && moreThan5Minutes) {
                    ReenterRecord reenterRecord = ReenterRecord.builder().orderNum(existsOrder.getOrderNum()).parkId(parkId).plateNum(plateNum).carType(existsOrder.getCarType()).enterTime(existsOrder.getEnterTime()).exitTime(existsOrder.getEnterTime()).build();
                    reenterRecords.add(reenterRecord);
                } else {
                    log.info("[\u8f66\u8f86\u5165\u573a\u670d\u52a1] \u91cd\u590d\u5165\u573a\u4e0d\u7b26\u5408\u52a0\u5165\u9ed1\u540d\u5355\u6761\u4ef6, \u4e0d\u662f\u6708\u5361\u8f66[{}], \u4e0d\u662f\u5168\u514dVIP[{}], \u5b9e\u65f6\u6027[{}], \u4e0d\u662f\u9065\u63a7\u5668[{}], \u8d85\u8fc75\u5206\u949f[{}]", new Object[]{notMonthCar, notFreeVip, realTime, notRemoteControlOpen, moreThan5Minutes});
                }
                if (Integer.valueOf(1).equals(existsOrder.getHasSon())) {
                    this.orderSonInfoDao.setException(existsOrder.getOrderNum(), updateOrder.getExitTime(), OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                }
                existsOrder.setServiceStatus(Integer.valueOf(4));
                existsOrder.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                existsOrder.setExitTime(existsOrder.getEnterTime());
                this.pushService.pushOrderExit(existsOrder);
            }
            this.orderService.updateBatchById(updateOrders);
            if (!reenterRecords.isEmpty() && NumberUtils.toPrimitive((Integer)(parkConfig = (ParkConfig)(parkConfigResp = this.parkService.getParkConfig(parkId)).getData()).getEnableReenterBlack()) == 1 && NumberUtils.toPrimitive((Integer)parkConfig.getReenterBlackTime()) > 0) {
                this.reenterRecordService.saveBatch(reenterRecords);
                this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                    try {
                        RLock lock = this.redissonDistributedLock.getLock("lock:blacklist:" + parkId + ":" + plateNum);
                        if (!lock.tryLock(0L, 2L, TimeUnit.SECONDS)) {
                            log.info("\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u5904\u7406|{}|{}", (Object)parkId, (Object)plateNum);
                            return;
                        }
                        this.asyncBlackListHandle(reenterRecords, parkId, plateNum, parkConfig.getReenterBlackTime());
                    }
                    catch (Exception e) {
                        log.error("\u9ed1\u540d\u5355\u5904\u7406\u5931\u8d25, plateNum[{}]", (Object)plateNum, (Object)e);
                    }
                }));
            }
            return updateOrders.size();
        }
        return 0;
    }

    protected void saveTrack(CarEnterRequest carEnterRequest, Long regionId) {
        if (carEnterRequest.getNoneEnterFlag()) {
            return;
        }
        OrderTrack orderTrack = new OrderTrack();
        BeanUtils.copyProperties((Object)carEnterRequest, (Object)orderTrack);
        if (carEnterRequest.getEnterWay() != null) {
            orderTrack.setInoutEvent(carEnterRequest.getEnterWay());
        } else if (carEnterRequest.getPlateNum().startsWith("\u4e34") && carEnterRequest.getOperaUser() == null) {
            orderTrack.setInoutEvent(Integer.valueOf(3));
        } else if (carEnterRequest.getOperaUser() != null) {
            orderTrack.setInoutEvent(Integer.valueOf(4));
        } else {
            orderTrack.setInoutEvent(Integer.valueOf(1));
        }
        orderTrack.setChannelName(carEnterRequest.getInandoutName());
        orderTrack.setRegionId(regionId);
        orderTrack.setRecordType(Integer.valueOf(1));
        orderTrack.setEnexTime(carEnterRequest.getEnterTime());
        orderTrack.setImage(carEnterRequest.getMaxImage());
        orderTrack.setOperAccount(carEnterRequest.getOperaUser());
        orderTrack.setExTerminal(carEnterRequest.getEnterTerminal());
        this.orderTrackMapper.insert((Object)orderTrack);
    }

    @Transactional(rollbackFor={Exception.class})
    public void asyncBlackListHandle(List<ReenterRecord> reenterRecords, Long parkId, String plateNum, int reenterBlackTime) {
        int count = this.reenterRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReenterRecord.class).eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0)).notIn(ReenterRecord::getOrderNum, (Collection)reenterRecords.stream().map(ReenterRecord::getOrderNum).collect(Collectors.toList())));
        int num = reenterRecords.size() + count;
        if (num >= reenterBlackTime) {
            ObjectResponse objectResponse = this.blacklistService.getValidByPlate(parkId, plateNum);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                com.icetech.basics.domain.entity.Blacklist blacklist = (com.icetech.basics.domain.entity.Blacklist)objectResponse.getData();
                com.icetech.basics.domain.entity.Blacklist newBlackList = new com.icetech.basics.domain.entity.Blacklist();
                newBlackList.setId(blacklist.getId());
                newBlackList.setRepeatNumbers(Integer.valueOf(num));
                if (Integer.valueOf(2).equals(blacklist.getOperateType())) {
                    log.info("[\u91cd\u590d\u5165\u573a] \u9ed1\u540d\u5355\u5df2\u6dfb\u52a0, \u76f4\u63a5\u8fd4\u56de, [{}]", (Object)blacklist);
                    return;
                }
                this.blacklistService.updateById((Object)newBlackList);
                ReenterRecord reenterRecord = new ReenterRecord();
                reenterRecord.setBlackId(Long.valueOf(blacklist.getId().longValue()));
                this.reenterRecordService.update((Object)reenterRecord, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0));
            } else {
                com.icetech.basics.domain.entity.Blacklist blacklist = com.icetech.basics.domain.entity.Blacklist.builder().parkId(parkId).plate(plateNum).owner(plateNum).carType(reenterRecords.get(0).getCarType()).type(Integer.valueOf(1)).status(Integer.valueOf(0)).operateType(Integer.valueOf(2)).repeatNumbers(Integer.valueOf(num)).operAccount("system").build();
                ObjectResponse response = this.blacklistService.addBlackList(blacklist);
                if (ObjectResponse.isSuccess((Response)response)) {
                    SendInfo sendInfo = new SendInfo(parkId, Long.valueOf(blacklist.getId().longValue()), DownServiceEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getServiceType());
                    this.sendInfoDao.insert((Object)sendInfo);
                    ReenterRecord reenterRecord = new ReenterRecord();
                    reenterRecord.setBlackId(Long.valueOf(blacklist.getId().longValue()));
                    this.reenterRecordService.update((Object)reenterRecord, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ReenterRecord::getParkId, (Object)parkId)).eq(ReenterRecord::getPlateNum, (Object)plateNum)).eq(ReenterRecord::getBlackId, (Object)0));
                }
            }
        }
    }

    protected boolean isMonthCard(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        return PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(enterRequest.getType()) || MonthDetailDto.MonthType.\u6708\u5361\u8f66.equals((Object)paramHolder.getOtherRegionMonthDetail().getMonthType()) || MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66.equals((Object)paramHolder.getOtherRegionMonthDetail().getMonthType());
    }

    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, Collection<RegionFreeSpaceUpdateVo> vos) {
        block9: {
            ParkConfig parkConfig;
            block8: {
                parkConfig = paramHolder.getParkConfig();
                if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
                    return;
                }
                List typeList = vos.stream().map(RegionFreeSpaceUpdateVo::getType).distinct().collect(Collectors.toList());
                if (typeList.contains(PlateTypeEnum.\u6708\u5361\u8f66.getType()) && NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) != 1) break block8;
                Collection regionIds = vos.stream().map(RegionFreeSpaceUpdateVo::getRegionId).collect(Collectors.toSet());
                if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                    for (RegionFreeSpaceUpdateVo vo : vos) {
                        if (vo.getRegionId() == null) continue;
                        this.parkRegionDao.addFreeSpaceByPark(vo.getRegionId().longValue(), vo.getNum());
                    }
                } else {
                    this.parkRegionDao.updateFreeParkByIds(regionIds);
                }
                this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
                if (paramHolder.getRegionType() != 2) break block9;
                for (Long regionId : regionIds) {
                    this.mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), regionId);
                }
                break block9;
            }
            for (RegionFreeSpaceUpdateVo vo : vos) {
                if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(vo.getType()) && NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) != 1 || vo.getRegionId() != null) continue;
                if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                    this.parkRegionDao.addFreeSpaceByPark(vo.getRegionId().longValue(), vo.getNum());
                } else {
                    this.parkRegionDao.updateFreeParkByIds(Collections.singleton(vo.getRegionId()));
                }
                this.parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
                if (paramHolder.getRegionType() != 2) continue;
                this.mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), vo.getRegionId());
            }
        }
    }
}

