/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.fee.QueryOrderFeeService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.pnc.EtcPayStatusRequest;
import com.icetech.cloudcenter.domain.response.NotPayDetail;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.pnc.EtcPayStatusResponse;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.pnc.impl.EtcPayStatusServiceImpl;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.queryfee.impl.P2cQueryFeeServiceImpl;
import com.icetech.park.service.queryfee.impl.PncQueryFeeServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryOrderFeeService")
public class QueryOrderFeeServiceImpl
implements QueryOrderFeeService {
    private static final Logger log = LoggerFactory.getLogger(QueryOrderFeeServiceImpl.class);
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private P2cQueryFeeServiceImpl p2cQueryFeeService;
    @Autowired
    private PncQueryFeeServiceImpl pncQueryFeeService;
    @Autowired
    protected ParkServiceImpl parkService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected OrderNotpayService orderNotpayService;
    @Autowired
    protected EtcPayStatusServiceImpl etcPayStatusService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    private ParkRecoveryService parkRecoveryService;

    public ObjectResponse<QueryOrderFeeResponse> queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        String parkCode = queryOrderFeeRequest.getParkCode();
        String channelId = queryOrderFeeRequest.getChannelId();
        String plateNum = queryOrderFeeRequest.getPlateNum();
        String orderNum = queryOrderFeeRequest.getOrderNum();
        if (StringUtils.isNotBlank((CharSequence)parkCode) && (StringUtils.isNotBlank((CharSequence)channelId) || StringUtils.isNotBlank((CharSequence)plateNum)) || StringUtils.isNotBlank((CharSequence)orderNum)) {
            try {
                return this.execute(queryOrderFeeRequest);
            }
            catch (ResponseBodyException e) {
                log.warn("\u62c9\u53d6\u8d39\u7528\u9519\u8bef: {}:{}. queryOrderFeeRequest[{}]", new Object[]{e.getErrCode(), e.getMessage(), queryOrderFeeRequest, e});
                return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u8d39\u7528\u9519\u8bef: {}. queryOrderFeeRequest[{}]", new Object[]{e.getMessage(), queryOrderFeeRequest, e});
                return ObjectResponse.failed((String)"3001");
            }
        }
        return ObjectResponse.failed((String)"400");
    }

    public ObjectResponse<QueryOrderFeeResponse> queryOrderFeeWithNotPay(QueryOrderFeeRequest queryOrderFeeRequest) {
        queryOrderFeeRequest.setWithNotPay(Boolean.valueOf(true));
        return this.queryOrderFee(queryOrderFeeRequest);
    }

    public ObjectResponse<EtcPayStatusResponse> etcPayStatus(EtcPayStatusRequest queryOrderFeeRequest, Long parkId, String topic) {
        return this.etcPayStatusService.etcPayStatus(queryOrderFeeRequest, parkId, topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectResponse<QueryOrderFeeResponse> updateAndGetChannelFee(String parkCode, String channelCode, String plateNum, List<String> notPayOrderNums) {
        if (parkCode == null || channelCode == null) {
            throw new ResponseBodyException("400", "\u8f66\u573a\u7f16\u53f7\u6216\u901a\u9053\u7f16\u53f7\u672a\u4f20");
        }
        String key = "channelFee:" + parkCode + ":" + channelCode;
        boolean lock = this.redisUtils.tryLock(key, String.valueOf(notPayOrderNums), 1000L);
        if (!lock) {
            return ObjectResponse.failed((String)"405", (String)"\u64cd\u4f5c\u592a\u5feb\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try {
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(parkCode, channelCode);
            if (channelFee == null) {
                ObjectResponse objectResponse = ObjectResponse.failed((String)"404", (String)"\u8f66\u8f86\u5df2\u79bb\u573a");
                return objectResponse;
            }
            if (!channelFee.getPlateNum().equals(plateNum)) {
                throw new ResponseBodyException("400", "\u5f53\u524d\u901a\u9053\u8f66\u8f86\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
            }
            if (CollectionUtils.isEmpty((Collection)channelFee.getNotPayDetails()) && CollectionUtils.isEmpty(notPayOrderNums)) {
                ObjectResponse objectResponse = ObjectResponse.success((Object)channelFee);
                return objectResponse;
            }
            if (CollectionUtils.isEmpty(notPayOrderNums)) {
                channelFee.setNotPayDetails(null);
                channelFee.setTotalNotPayPrice(String.valueOf(0.0));
                channelFee.setSumPrice(channelFee.getUnpayPrice());
                this.cacheHandle.setChannelFee(parkCode, channelCode, channelFee);
                ObjectResponse objectResponse = ObjectResponse.success((Object)channelFee);
                return objectResponse;
            }
            List orderNotpays = this.orderNotpayService.getListByOrderNums(notPayOrderNums);
            if (CollectionUtils.isEmpty((Collection)orderNotpays)) {
                channelFee.setNotPayDetails(null);
                channelFee.setTotalNotPayPrice(String.valueOf(0.0));
                channelFee.setSumPrice(channelFee.getUnpayPrice());
                this.cacheHandle.setChannelFee(parkCode, channelCode, channelFee);
                ObjectResponse objectResponse = ObjectResponse.success((Object)channelFee);
                return objectResponse;
            }
            ArrayList<NotPayDetail> notPayDetails = new ArrayList<NotPayDetail>();
            BigDecimal totalNotPayPrice = new BigDecimal(0);
            for (OrderNotpay orderNotPay : orderNotpays) {
                if (orderNotPay.getOrderNum().equals(channelFee.getOrderNum())) {
                    log.info("[\u67e5\u8be2\u6b20\u8d39\u8bb0\u5f55] \u5df2\u4f5c\u4e3a\u5f53\u6b21\u8ba2\u5355\u8ba1\u8d39, \u8df3\u8fc7\u6b20\u8d39\u8bb0\u5f55[{}]", (Object)orderNotPay);
                    continue;
                }
                NotPayDetail notPayDetail = NotPayDetail.builder().parkId(orderNotPay.getParkId()).orderNum(orderNotPay.getOrderNum()).enterTime(orderNotPay.getEnterTime()).exitTime(orderNotPay.getExitTime()).totalPrice(orderNotPay.getTotalPrice().toString()).discountPrice(orderNotPay.getDiscountPrice().toString()).unPayPrice(orderNotPay.getTotalPrice().toString()).parkTime(orderNotPay.getEnterTime() == null ? null : Long.valueOf(orderNotPay.getExitTime() - orderNotPay.getEnterTime())).build();
                notPayDetails.add(notPayDetail);
                totalNotPayPrice = totalNotPayPrice.add(orderNotPay.getTotalPrice());
            }
            channelFee.setNotPayDetails(notPayDetails);
            channelFee.setTotalNotPayPrice(totalNotPayPrice.toString());
            BigDecimal sumPrice = new BigDecimal(channelFee.getUnpayPrice()).add(totalNotPayPrice);
            channelFee.setSumPrice(sumPrice.toString());
            this.cacheHandle.setChannelFee(parkCode, channelCode, channelFee);
            ObjectResponse objectResponse = ObjectResponse.success((Object)channelFee);
            return objectResponse;
        }
        finally {
            this.redisUtils.releaseLock(key);
        }
    }

    private ObjectResponse<QueryOrderFeeResponse> execute(QueryOrderFeeRequest queryOrderFeeRequest) {
        Park park;
        if (Boolean.TRUE.equals(queryOrderFeeRequest.getIsOffline())) {
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            if (channelFee == null) {
                return ObjectResponse.failed((String)"3008");
            }
            return ObjectResponse.success((Object)channelFee);
        }
        String orderNum = queryOrderFeeRequest.getOrderNum();
        String parkCode = queryOrderFeeRequest.getParkCode();
        String plateNum = queryOrderFeeRequest.getPlateNum();
        OrderInfo orderInfo = new OrderInfo();
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            orderInfo = this.orderInfoDao.selectByOrderNum(orderNum);
            AssertTools.notNull((Object)orderInfo, (String)"402", (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
            park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
        } else {
            park = (Park)this.parkService.findByParkCode(parkCode).getData();
            AssertTools.notNull((Object)park, (String)"402", (String)"\u8f66\u573a\u672a\u6ce8\u518c");
            if (plateNum != null) {
                orderInfo.setPlateNum(plateNum);
                orderInfo.setParkId(park.getId());
                ObjectResponse infoObjectResponse = this.orderService.findInParkId(plateNum, park.getId());
                orderInfo = (OrderInfo)infoObjectResponse.getData();
            }
        }
        if (orderInfo != null && orderInfo.getServiceStatus() != null && (orderInfo.getServiceStatus().equals(2) || orderInfo.getServiceStatus().equals(3))) {
            orderInfo = null;
        }
        if (orderInfo != null && orderInfo.getOrderNum() != null && this.redisUtils.exists("offline:fee:" + orderInfo.getOrderNum())) {
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            if (channelFee == null) {
                return ObjectResponse.failed((String)"3001", (String)"\u8d39\u7528\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u67e5\u8d39");
            }
            return ObjectResponse.success((Object)channelFee);
        }
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(park.getId().longValue());
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.\u7aef\u7f51\u4e91.getType())) {
            ObjectResponse channelInfo;
            ParkInoutdevice parkInoutdevice;
            if (plateNum != null && parkConfig.getEntryPayFlag() != null && Integer.valueOf("1").equals(parkConfig.getEntryPayFlag()) && queryOrderFeeRequest.getChannelId() != null && (parkInoutdevice = (ParkInoutdevice)(channelInfo = this.parkService.getInOutDeviceByCode(park.getId(), queryOrderFeeRequest.getChannelId())).getData()).getInandoutType() != null && Integer.valueOf("1").equals(parkInoutdevice.getInandoutType())) {
                orderInfo = null;
            }
            ObjectResponse<Void> objectResponse = this.pncQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park);
            ObjectResponse response = new ObjectResponse();
            response.setCode(objectResponse.getCode());
            response.setMsg(objectResponse.getMsg());
            response.setTraceId(objectResponse.getTraceId());
            return response;
        }
        if (Integer.valueOf(1).equals(queryOrderFeeRequest.getExType())) {
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(queryOrderFeeRequest.getParkCode(), queryOrderFeeRequest.getChannelId());
            if (channelFee == null) {
                channelFee = this.queryNotPay(queryOrderFeeRequest, parkConfig, park);
            }
            if (channelFee == null) {
                return ObjectResponse.failed((String)"3008");
            }
            return ObjectResponse.success((Object)channelFee);
        }
        if (orderInfo == null) {
            if (!Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay())) {
                throw new ResponseBodyException("3001", "\u672a\u627e\u5230\u5165\u573a\u4fe1\u606f");
            }
            QueryOrderFeeResponse queryOrderFeeResponse = this.queryNotPay(queryOrderFeeRequest, plateNum, parkConfig, null, park.getParkName());
            if (queryOrderFeeResponse == null) {
                throw new ResponseBodyException("3001", "\u672a\u627e\u5230\u5165\u573a\u4fe1\u606f");
            }
            return ObjectResponse.success((Object)queryOrderFeeResponse);
        }
        ObjectResponse<QueryOrderFeeResponse> objectResponse = this.p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park, parkConfig);
        if (Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay())) {
            QueryOrderFeeResponse queryOrderFeeResponse = this.queryNotPay(queryOrderFeeRequest, plateNum, parkConfig, (QueryOrderFeeResponse)objectResponse.getData(), park.getParkName());
            if (queryOrderFeeResponse == null) {
                return objectResponse;
            }
            return ObjectResponse.success((Object)queryOrderFeeResponse);
        }
        return objectResponse;
    }

    public QueryOrderFeeResponse queryNotPay(QueryOrderFeeRequest queryOrderFeeRequest, ParkConfig parkConfig, Park park) {
        if (queryOrderFeeRequest.getPlateNum() == null) {
            throw new ResponseBodyException("400", "\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.queryNotPay(queryOrderFeeRequest, queryOrderFeeRequest.getPlateNum(), parkConfig, QueryOrderFeeResponse.buildEmptyOrderFee((String)queryOrderFeeRequest.getPlateNum(), (String)park.getParkName(), (Integer)parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), (Integer)queryOrderFeeRequest.getCarType(), (String)queryOrderFeeRequest.getOrderNum()), park.getParkName());
    }

    public QueryOrderFeeResponse queryNotPay(QueryOrderFeeRequest queryOrderFeeRequest, String plateNum, ParkConfig parkConfig, QueryOrderFeeResponse queryOrderFeeResponse, String parkName) {
        List orderNotPays;
        ObjectResponse parkInoutDeviceObjectResponse;
        Long parkId = parkConfig.getParkId();
        ParkRecoveryVo recovery = this.parkRecoveryService.getParkRecoveryByParkId(parkId);
        if (recovery == null || !recovery.isEnableRecovery()) {
            return queryOrderFeeResponse;
        }
        if (plateNum == null) {
            String string = plateNum = queryOrderFeeResponse == null ? null : queryOrderFeeResponse.getPlateNum();
        }
        if (StringUtils.isEmpty((CharSequence)plateNum) || "\u672a\u8bc6\u522b".equals(plateNum) || "\u65e0\u724c\u8f66".equals(plateNum)) {
            return queryOrderFeeResponse;
        }
        if (queryOrderFeeResponse != null && NumberUtils.parseDouble((Object)queryOrderFeeResponse.getTotalNotPayPrice()) > 0.0) {
            return queryOrderFeeResponse;
        }
        if (queryOrderFeeRequest.getParkCode() != null && queryOrderFeeRequest.getChannelId() != null && plateNum == null) {
            return queryOrderFeeResponse;
        }
        if (parkConfig.getEnterpayType() == null && parkConfig.getExitpayType() == null) {
            return queryOrderFeeResponse;
        }
        Integer exType = queryOrderFeeRequest.getExType();
        if (queryOrderFeeRequest.getChannelId() != null && ObjectResponse.isSuccess((Response)(parkInoutDeviceObjectResponse = this.parkService.getInOutDeviceByCode(parkId, queryOrderFeeRequest.getChannelId())))) {
            exType = ((ParkInoutdevice)parkInoutDeviceObjectResponse.getData()).getInandoutType();
        }
        if (CollectionUtils.isEmpty((Collection)(orderNotPays = this.orderNotpayService.queryNotPayFee(parkId, plateNum, exType, parkConfig)))) {
            return queryOrderFeeResponse;
        }
        if (queryOrderFeeResponse == null) {
            queryOrderFeeResponse = QueryOrderFeeResponse.buildEmptyOrderFee((String)plateNum, (String)parkName, (Integer)parkConfig.getIsfreeAfterpay(Integer.valueOf(15)), (Integer)queryOrderFeeRequest.getCarType(), null);
        }
        ArrayList<NotPayDetail> notPayDetails = new ArrayList<NotPayDetail>();
        BigDecimal totalNotPayPrice = new BigDecimal(0);
        for (OrderNotpay orderNotPay : orderNotPays) {
            if (orderNotPay.getOrderNum().equals(queryOrderFeeResponse.getOrderNum())) {
                log.info("[\u67e5\u8be2\u6b20\u8d39\u8bb0\u5f55] \u5df2\u4f5c\u4e3a\u5f53\u6b21\u8ba2\u5355\u8ba1\u8d39, \u8df3\u8fc7\u6b20\u8d39\u8bb0\u5f55[{}]", (Object)orderNotPay);
                continue;
            }
            NotPayDetail notPayDetail = NotPayDetail.builder().parkId(orderNotPay.getParkId()).orderNum(orderNotPay.getOrderNum()).enterTime(orderNotPay.getEnterTime()).exitTime(orderNotPay.getExitTime()).totalPrice(orderNotPay.getTotalPrice().toString()).discountPrice(orderNotPay.getDiscountPrice().toString()).unPayPrice(orderNotPay.getTotalPrice().toString()).parkTime(orderNotPay.getEnterTime() == null ? null : Long.valueOf(orderNotPay.getExitTime() - orderNotPay.getEnterTime())).orderSource(Integer.valueOf(orderNotPay.getOrderSource())).build();
            notPayDetails.add(notPayDetail);
            totalNotPayPrice = totalNotPayPrice.add(orderNotPay.getTotalPrice());
        }
        queryOrderFeeResponse.setNotPayDetails(notPayDetails);
        queryOrderFeeResponse.setTotalNotPayPrice(totalNotPayPrice.toString());
        BigDecimal sumPrice = new BigDecimal(queryOrderFeeResponse.getUnpayPrice()).add(totalNotPayPrice);
        queryOrderFeeResponse.setSumPrice(sumPrice.toString());
        return queryOrderFeeResponse;
    }
}

