/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.basics.utils.FuzzyPlateTools;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.order.ModifyCarDto;
import com.icetech.cloudcenter.domain.order.OrderVO;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.OrderAddRequest;
import com.icetech.cloudcenter.domain.request.OrderQueryRequest;
import com.icetech.cloudcenter.domain.request.PlateModifyCarRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.SearchCarRequest;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.EnterCarDto;
import com.icetech.cloudcenter.domain.response.ExitCarDto;
import com.icetech.cloudcenter.domain.response.InParkNumInfoResponse;
import com.icetech.cloudcenter.domain.response.MonthOrderDto;
import com.icetech.cloudcenter.domain.response.OrderCountDto;
import com.icetech.cloudcenter.domain.response.OrderDto;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.SearchCarResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthOrderDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.order.dao.OrderAfterPayDao;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.dto.OrderInfoDto;
import com.icetech.order.domain.entity.OrderAfterPay;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.OrderTagsService;
import com.icetech.order.service.impl.OrderCarInfoServiceImpl;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.component.SnowFlackIdGenerator;
import com.icetech.park.dao.made.MadePlateDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.MadePlate;
import com.icetech.park.domain.entity.car.CarClean;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.domain.request.OrderStatusParam;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.car.CarCleanService;
import com.icetech.park.service.down.pnc.impl.BatchSetExitServiceImpl;
import com.icetech.park.service.down.pnc.impl.ModifyCarServiceImpl;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.park.service.freespace.UpdateParkFreeSpaceServiceImpl;
import com.icetech.park.service.freespace.UpdateRegionFreeSpaceServiceImpl;
import com.icetech.park.service.impl.QueryThirdFeeServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.order.impl.QueryOrderFeeServiceImpl;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.park.impl.ParkMerchantServiceImpl;
import com.icetech.park.service.queryfee.impl.P2cQueryFeeServiceImpl;
import com.icetech.park.service.queryfee.impl.PncQueryFeeServiceImpl;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.DateRangeUtils;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@RefreshScope
@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderInfoDao, OrderInfo>
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private ParkService parkService;
    @Resource
    private ParkDao parkDao;
    @Autowired
    private QueryOrderFeeServiceImpl queryOrderFeeService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Resource
    private OrderCarInfoServiceImpl orderCarInfoService;
    @Autowired
    private OssService ossService;
    @Autowired
    private P2cQueryFeeServiceImpl p2cQueryFeeService;
    @Autowired
    private PncQueryFeeServiceImpl pncQueryFeeService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private MonthOrderDao monthOrderDao;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkVisitService parkVisitService;
    @Autowired
    private OrderAfterPayDao orderAfterPayDao;
    @Autowired
    private MadePlateDao madePlateDao;
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private QueryThirdFeeServiceImpl queryThirdFeeService;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private CarCleanService carCleanService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Autowired
    private ModifyCarServiceImpl modifyCarService;
    private static final Integer MONTH_CARD = 2;
    private static final Integer NO_NEED_PAY = 1;
    @Value(value="${secondrec.reliability.threshold}")
    public Integer reliabilityThreshold;
    @Autowired
    private StoreCardService storeCardService;
    @Autowired
    private ThirdInfoService thirdInfoService;
    @Resource
    protected MqPushService pushService;
    @Autowired
    private BatchSetExitServiceImpl batchSetExitService;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private ParkMerchantServiceImpl parkMerchantService;
    @Autowired
    private MonthPlateDao monthPlateDao;
    @Autowired
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private SnowFlackIdGenerator idGenerator;
    @Autowired
    private UpdateRegionFreeSpaceServiceImpl updateRegionFreeSpaceService;
    @Autowired
    private UpdateParkFreeSpaceServiceImpl updateParkFreeSpaceService;

    public ObjectResponse<String> addOrderAfterPay(Long parkId, OrderInfo orderInfo, Integer type) {
        String tradeNo = CodeTools.GenerateTradeNo();
        try {
            OrderAfterPay orderAfterPay = new OrderAfterPay();
            orderAfterPay.setOrderNum(orderInfo.getOrderNum());
            orderAfterPay.setPlateNum(orderInfo.getPlateNum());
            orderAfterPay.setTradeNo(tradeNo);
            orderAfterPay.setParkId(Integer.valueOf(parkId.intValue()));
            orderAfterPay.setPaidPrice(orderInfo.getPaidPrice());
            orderAfterPay.setDiscountPrice(orderInfo.getDiscountPrice());
            orderAfterPay.setTotalPrice(String.valueOf(NumberUtils.parseDouble((Object)orderInfo.getPaidPrice()) + NumberUtils.parseDouble((Object)orderInfo.getDiscountPrice())));
            orderAfterPay.setType(Integer.valueOf(Objects.isNull(type) ? 1 : type));
            this.orderAfterPayDao.insert(orderAfterPay);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. parkId[{}], queryOrderFeeResponse[{}]", new Object[]{e.getMessage(), parkId, orderInfo, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success((Object)tradeNo);
    }

    public ObjectResponse<List<OrderAfterPay>> selectAfterPayList(Integer status, Integer type) {
        List orderAuthInfos = this.orderAfterPayDao.selectAfterPay(status, type);
        return ObjectResponse.success((Object)orderAuthInfos);
    }

    public ObjectResponse<List<OrderAfterPay>> selectAfterPayLists(Integer status, Integer type, String time) {
        List orderAuthInfos = this.orderAfterPayDao.selectAfterPays(status, type, time);
        return ObjectResponse.success((Object)orderAuthInfos);
    }

    public ObjectResponse updateAfterPay(OrderAfterPay orderAfterPay) {
        orderAfterPay.setUpdateTime(new Date());
        if (orderAfterPay.getRequestNum() != null && orderAfterPay.getRequestNum() >= 22) {
            orderAfterPay.setStatus(Integer.valueOf(2));
        }
        int update = this.orderAfterPayDao.update(orderAfterPay);
        return ObjectResponse.success((Object)update);
    }

    public ObjectResponse<List<EnterCarDto>> getAlarmPlateList(String parkCode, Date startTime, Date endTime) {
        ArrayList<EnterCarDto> list = new ArrayList<EnterCarDto>();
        try {
            String parkid;
            String[] split;
            if (!TextUtils.isEmpty((CharSequence)parkCode) && null != (split = parkCode.split(",")) && split.length > 0 && !TextUtils.isEmpty((CharSequence)(parkid = this.parkDao.selectByCodes(split)))) {
                String timeString = Objects.isNull(startTime) ? null : DateTools.getFormat((Date)startTime);
                log.info("getAlarmPlateList ====>{}", (Object)timeString);
                List strings = this.orderInfoDao.selectMadeOrders(parkid, timeString);
                for (int i = 0; i < strings.size(); ++i) {
                    EnterCarDto enterCarDto = new EnterCarDto();
                    OrderInfo orderInfo = (OrderInfo)strings.get(i);
                    OrderInfo orderInfo1 = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
                    Park park = (Park)this.parkService.findByParkId(orderInfo1.getParkId()).getData();
                    enterCarDto.setPlateNumber(orderInfo1.getPlateNum());
                    enterCarDto.setParkName(park.getParkName());
                    enterCarDto.setOrderNum(orderInfo1.getOrderNum());
                    list.add(enterCarDto);
                }
            }
            return ObjectResponse.success(list);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. parkCode[{}], startTime[{}], endTime[{}]", new Object[]{e.getMessage(), parkCode, startTime, endTime, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.countExitCarList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countExitCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Date enterStartTime = orderQueryRequest.getEnterStartTime();
            Date enterEndTime = orderQueryRequest.getEnterEndTime();
            List type = orderQueryRequest.getTypes();
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (StringUtils.isNotEmpty((CharSequence)plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            int count = this.orderInfoDao.countExitRecords(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, type, Objects.isNull(enterStartTime) ? null : Long.valueOf(enterStartTime.getTime() / 1000L), Objects.isNull(enterEndTime) ? null : Long.valueOf(enterEndTime.getTime() / 1000L), orderQueryRequest.getTagIds());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u79bb\u573a\u8f66\u8f86\u603b\u6570\u636e\u91cf\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. orderQueryRequest[{}]", new Object[]{e.getMessage(), orderQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    private ObjectResponse<Long> delOrder(String orderNum, String username, boolean syncLocal) {
        OrderInfo orderinfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            orderinfo.setServiceStatus(Integer.valueOf(3));
            int update = this.orderInfoDao.updateByOrderNum(orderinfo);
            if (update > 0) {
                ObjectResponse configResp;
                OrderSonInfo orderSonInfo = null;
                if (Integer.valueOf(1).equals(orderinfo.getHasSon())) {
                    List orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum)).eq(OrderInfo::getServiceStatus, (Object)1));
                    orderSonInfo = CollectionUtils.isEmpty((Collection)orderSonInfos) ? null : (OrderSonInfo)orderSonInfos.get(0);
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setServiceStatus(Integer.valueOf(3));
                    this.orderSonInfoDao.update((Object)orderSonInfoUpdate, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum)).eq(OrderInfo::getServiceStatus, (Object)1));
                }
                OrderModifyRecord orderModifyRecord = new OrderModifyRecord();
                orderModifyRecord.setAction(Integer.valueOf(2));
                orderModifyRecord.setOrderNum(orderNum);
                orderModifyRecord.setParkId(orderinfo.getParkId());
                orderModifyRecord.setModifyTime(DateTools.getFormat((Date)new Date()));
                this.orderModifyRecordDao.insert((Object)orderModifyRecord);
                if (StringUtils.isNotEmpty((CharSequence)username)) {
                    String enterImageUrl = null;
                    OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
                    if (Objects.nonNull(orderCarInfo) && StringUtils.isNotBlank((CharSequence)orderCarInfo.getEnterImage())) {
                        enterImageUrl = orderCarInfo.getEnterImage();
                    }
                    CarClean carClean = CarClean.builder().parkId(orderinfo.getParkId()).batchCode(UUIDTools.getUuid()).orderNum(orderinfo.getOrderNum()).enterTime(this.getEnterTime(orderinfo.getEnterTime(), orderinfo.getCreateTime())).carType(orderinfo.getCarType()).plateNum(orderinfo.getPlateNum()).operator(username).enterImage(enterImageUrl).type(Integer.valueOf(3)).build();
                    this.carCleanService.save(carClean);
                }
                if (syncLocal) {
                    this.sendinfoDao.insert((Object)new SendInfo(orderinfo.getParkId(), orderModifyRecord.getId(), DownServiceEnum.\u8ba2\u5355\u4fee\u6539.getServiceType()));
                }
                if (!ObjectResponse.isSuccess((Response)(configResp = this.parkService.getParkConfig(orderinfo.getParkId())))) {
                    log.warn("\u67e5\u627e\u8ba2\u5355[{}]\u5bf9\u5e94\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4fe1\u606f\u5931\u8d25: {} - {}", new Object[]{orderNum, configResp.getCode(), configResp.getMsg()});
                    return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
                }
                ParkConfig parkConfig = (ParkConfig)configResp.getData();
                if (!(parkConfig.getDelOrderCalcSpaceFlag(Integer.valueOf(0)) != 1 || PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderinfo.getType()) && NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) != 1)) {
                    Long regionId;
                    UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkConfig.getParkId());
                    Long l = regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
                    if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                        updateFreeSpaceService.addFreeSpace(orderinfo.getParkId(), regionId, 1);
                    } else {
                        updateFreeSpaceService.syncFreeSpace(orderinfo.getParkId(), regionId);
                    }
                }
                OrderDiscount param = new OrderDiscount();
                param.setParkId(orderinfo.getParkId());
                param.setOrderNum(orderinfo.getOrderNum());
                param.setStatus(Integer.valueOf(0));
                ObjectResponse list = this.orderDiscountService.findList(param);
                if (!CollectionUtils.isEmpty((Collection)((Collection)list.getData()))) {
                    for (OrderDiscount orderDiscount : (List)list.getData()) {
                        this.parkMerchantService.releasePlace(orderDiscount);
                    }
                }
                return ObjectResponse.success((Object)orderModifyRecord.getId());
            }
        }
        return ObjectResponse.failed((String)"404");
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Long> delOrder(String orderNum, String username) {
        return this.delOrder(orderNum, username, true);
    }

    public Long getEnterTime(Long enterTime, Date createTime) {
        if (enterTime != null) {
            return enterTime;
        }
        return DateUtil.toLocalDateTime((Date)createTime).toEpochSecond(ZoneOffset.of("+8"));
    }

    private boolean isMonthCar(Long parkId, String plateNumber) {
        MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(parkId, plateNumber, Integer.valueOf(1));
        return monthInfo != null;
    }

    private boolean isVipCar(Long parkId, String plateNumber, Long regionId) {
        ObjectResponse validVipCar = this.vipCarService.getValidVipCar(parkId, plateNumber, regionId);
        return ObjectResponse.isSuccess((Response)validVipCar);
    }

    public ObjectResponse checkCar(String orderNum, String plateNumber, Integer carType) {
        OrderInfo order = new OrderInfo();
        order.setOrderNum(orderNum);
        OrderInfo orderinfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            ArrayList<Integer> type = new ArrayList<Integer>();
            type.add(orderinfo.getType());
            List orderInfos = this.orderInfoDao.selectEnterRecords(String.valueOf(orderinfo.getParkId()), null, null, plateNumber, type, null, null, null);
            if (orderInfos.size() == 0) {
                return ObjectResponse.failed((String)"200");
            }
        }
        return ObjectResponse.failed((String)"405");
    }

    @Transactional
    public ObjectResponse modifyCar(String orderNum, String plateNumber, Integer carType) {
        PlateModifyCarRequest plateModifyCarRequest = new PlateModifyCarRequest();
        plateModifyCarRequest.setOrderNum(orderNum);
        plateModifyCarRequest.setNewPlateNum(plateNumber);
        plateModifyCarRequest.setNewCarType(carType);
        return this.modifyCar(plateModifyCarRequest);
    }

    public ObjectResponse<Long> modifyCar(ModifyCarDto dto) {
        String orderNum = dto.getOrderNum();
        if (dto.getAction() == 2) {
            return this.delOrder(orderNum, null, dto.isSyncLocal());
        }
        OrderInfo orderinfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            return this.modifyCar(dto, orderinfo);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Long> modifyCar(PlateModifyCarRequest plateModifyCarRequest) {
        if (StringUtils.isEmpty((CharSequence)plateModifyCarRequest.getOrderNum()) || plateModifyCarRequest.getNewPlateNum() == null && plateModifyCarRequest.getNewCarType() == null) {
            return ObjectResponse.failed((String)"400");
        }
        OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(plateModifyCarRequest.getOrderNum());
        if (Objects.nonNull(plateModifyCarRequest.getParkCodes())) {
            String[] parkIdList;
            String[] split = plateModifyCarRequest.getParkCodes().split(",");
            String parkIds = this.parkDao.selectByCodes(split);
            if (parkIds.endsWith(",")) {
                parkIds = parkIds.substring(0, parkIds.length() - 1);
            }
            if ((parkIdList = parkIds.split(",")).length == 0 || Arrays.stream(parkIdList).noneMatch(str -> str.equals(orderInfo.getParkId().toString()))) {
                return ObjectResponse.failed((String)"404");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)plateModifyCarRequest.getParkIds()) && !plateModifyCarRequest.getParkIds().contains(-1L) && !plateModifyCarRequest.getParkIds().contains(orderInfo.getParkId())) {
            return ObjectResponse.failed((String)"404");
        }
        if (orderInfo != null) {
            ObjectResponse<Long> objectResponse;
            String afterModify;
            String beforeModify;
            ModifyCarDto modifyCarDto = new ModifyCarDto();
            modifyCarDto.setOrderNum(plateModifyCarRequest.getOrderNum());
            modifyCarDto.setOperAccount(plateModifyCarRequest.getOperAccount());
            if (orderInfo.getPlateNum().equals(plateModifyCarRequest.getNewPlateNum()) && orderInfo.getCarType().equals(plateModifyCarRequest.getNewCarType())) {
                return ObjectResponse.failed((String)"405");
            }
            boolean success = true;
            if (!orderInfo.getPlateNum().equals(plateModifyCarRequest.getNewPlateNum())) {
                int correctType = 1;
                beforeModify = orderInfo.getPlateNum();
                afterModify = plateModifyCarRequest.getNewPlateNum();
                modifyCarDto.setModifyType(Integer.valueOf(correctType));
                modifyCarDto.setNewVal(afterModify);
                modifyCarDto.setOldVal(beforeModify);
                objectResponse = this.modifyCar(modifyCarDto);
                success = ObjectResponse.isSuccess(objectResponse);
            } else {
                MadePlate madePlate = new MadePlate();
                madePlate.setNewPlateNum(plateModifyCarRequest.getNewPlateNum());
                madePlate.setOrderNum(plateModifyCarRequest.getOrderNum());
                madePlate.setOperAccount(plateModifyCarRequest.getOperAccount());
                madePlate.setStatus(Integer.valueOf(1));
                this.updateMadePlate(madePlate);
            }
            if (Objects.nonNull(plateModifyCarRequest.getNewCarType()) && !orderInfo.getCarType().equals(plateModifyCarRequest.getNewCarType())) {
                int correctType = 2;
                beforeModify = String.valueOf(orderInfo.getCarType());
                afterModify = String.valueOf(plateModifyCarRequest.getNewCarType());
                modifyCarDto.setModifyType(Integer.valueOf(correctType));
                modifyCarDto.setNewVal(afterModify);
                modifyCarDto.setOldVal(beforeModify);
                objectResponse = this.modifyCar(modifyCarDto);
                success = success && ObjectResponse.isSuccess(objectResponse);
            }
            return success ? ObjectResponse.success() : ObjectResponse.failed((String)"500");
        }
        return ObjectResponse.failed((String)"404");
    }

    private ObjectResponse<Long> modifyCar(ModifyCarDto dto, OrderInfo orderInfo) {
        String orderNum = orderInfo.getOrderNum();
        Integer modifyType = dto.getModifyType();
        String newVal = dto.getNewVal();
        String oldVal = dto.getOldVal();
        String carDesc = dto.getCarDesc();
        int updateRows = 0;
        OrderModifyRecord modifyRecord = new OrderModifyRecord();
        modifyRecord.setAction(dto.getAction());
        modifyRecord.setCorrectType(modifyType);
        modifyRecord.setOrderNum(orderNum);
        modifyRecord.setParkId(orderInfo.getParkId());
        modifyRecord.setBeforeModify(oldVal);
        modifyRecord.setAfterModify(newVal);
        if (modifyType == 1) {
            String plateNumber = newVal;
            List orderInfos = this.orderInfoDao.selectEnterRecords(String.valueOf(orderInfo.getParkId()), null, null, plateNumber, null, null, null, null);
            ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(orderInfo.getParkId()).getData();
            if (orderInfos.size() > 0) {
                OrderInfo orderInfo1 = (OrderInfo)orderInfos.get(0);
                if (orderInfo1.getEnterTime() > orderInfo.getEnterTime()) {
                    orderInfo.setServiceStatus(Integer.valueOf(3));
                    this.orderInfoDao.updateByOrderNum(orderInfo);
                    this.freeSpaceHandle(orderInfo, parkConfig);
                    orderInfo = orderInfo1;
                } else {
                    orderInfo1.setServiceStatus(Integer.valueOf(3));
                    this.orderInfoDao.updateByOrderNum(orderInfo1);
                    this.freeSpaceHandle(orderInfo1, parkConfig);
                }
            }
            if (parkConfig.getDataCollection().equals(1) || parkConfig.getDataCollection().equals(3)) {
                ObjectResponse<PlateTypeDto> plateType = this.getPlateType(orderInfo.getParkId(), plateNumber);
                PlateTypeDto data = (PlateTypeDto)plateType.getData();
                orderInfo.setType(data.getPlateTypeEnum().getType());
            }
            orderInfo.setPlateNum(plateNumber);
            updateRows = this.orderInfoDao.updateByOrderNum(orderInfo);
        } else if (modifyType == 2) {
            String carType = newVal;
            try {
                orderInfo.setCarType(Integer.valueOf(Integer.parseInt(carType)));
            }
            catch (NumberFormatException e) {
                return ObjectResponse.failed((String)"402", (String)"\u8f66\u578b\u4fee\u6539\u65f6\u503c\u7c7b\u578b\u9519\u8bef");
            }
            updateRows = this.orderInfoDao.updateByOrderNum(orderInfo);
        } else if (modifyType == 3) {
            try {
                orderInfo.setType(Integer.valueOf(Integer.parseInt(newVal)));
            }
            catch (NumberFormatException e) {
                return ObjectResponse.failed((String)"402", (String)"\u8f66\u8f86\u7c7b\u578b\u4fee\u6539\u65f6\u503c\u7c7b\u578b\u9519\u8bef");
            }
            if (StringUtils.isNotBlank((CharSequence)carDesc)) {
                orderInfo.setCarDesc(carDesc);
                modifyRecord.setAfterCardesc(carDesc);
                modifyRecord.setBeforeCardesc(orderInfo.getCarDesc());
            }
            updateRows = this.orderInfoDao.updateByOrderNum(orderInfo);
        }
        if (updateRows > 0) {
            modifyRecord.setModifyTime(DateTools.getFormat((Date)new Date()));
            this.orderModifyRecordDao.insert((Object)modifyRecord);
            if (dto.isSyncLocal()) {
                this.sendinfoDao.insert((Object)new SendInfo(orderInfo.getParkId(), modifyRecord.getId(), DownServiceEnum.\u8ba2\u5355\u4fee\u6539.getServiceType()));
            }
            if (modifyType == 1) {
                MadePlate madePlate = new MadePlate();
                madePlate.setNewPlateNum(newVal);
                madePlate.setOrderNum(orderNum);
                madePlate.setOperAccount(dto.getOperAccount());
                madePlate.setStatus(Integer.valueOf(1));
                this.updateMadePlate(madePlate);
            }
            return ObjectResponse.success((Object)modifyRecord.getId());
        }
        return ObjectResponse.failed((String)"500", (String)"\u4fee\u6539\u8f66\u724c\u4fe1\u606f\u5931\u8d25");
    }

    private OrderSonInfo freeSpaceHandle(OrderInfo orderInfo, ParkConfig parkConfig) {
        OrderSonInfo orderSonInfo = null;
        if (Integer.valueOf(1).equals(orderInfo.getHasSon())) {
            orderSonInfo = this.orderSonInfoDao.selectOrderSonInpark(orderInfo.getPlateNum(), orderInfo.getParkId());
            OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
            orderSonInfoUpdate.setServiceStatus(Integer.valueOf(3));
            this.orderSonInfoDao.update((Object)orderSonInfoUpdate, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderInfo::getServiceStatus, (Object)1));
        }
        if (!PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderInfo.getType()) || NumberUtils.toPrimitive((Integer)parkConfig.getIsCardcount()) == 1) {
            Long regionId;
            UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkConfig.getParkId());
            Long l = regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
            if (parkConfig.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                updateFreeSpaceService.addFreeSpace(orderInfo.getParkId(), regionId, 1);
            } else {
                updateFreeSpaceService.syncFreeSpace(orderInfo.getParkId(), regionId);
            }
        }
        log.info("[\u4fee\u6539\u8f66\u724c\u670d\u52a1] \u6709\u91cd\u590d\u8ba2\u5355\uff0c\u589e\u52a0\u7a7a\u8f66\u4f4d\uff0cparkId\uff1a{}", (Object)orderInfo.getParkId());
        return orderSonInfo;
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.selectListByParam", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderInfo>> selectListByParam(Long parkId, Long startTime, Long endTime, String plateNumber) {
        List list = this.orderInfoDao.selectListByParam(parkId, startTime, endTime, plateNumber);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success((Object)list);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<OrderInfo> findByOrderNum(String orderNum) {
        if (StringUtils.isEmpty((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"400");
        }
        OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (orderInfo != null) {
            return ObjectResponse.success((Object)orderInfo);
        }
        log.info("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\uff0c\u672a\u627e\u5230\u7ed3\u679c\uff0c\u53c2\u6570\uff1a{}", (Object)orderNum);
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<OrderInfo> findWithHistoryByOrderNum(String orderNum) {
        if (StringUtils.isEmpty((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"400");
        }
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-365);
        OrderInfo orderInfo = this.orderInfoDao.selectWithHistoryByOrderNum(DateRangeUtils.getYearQuarterRangeTableName((Date)startDate), orderNum);
        if (orderInfo != null) {
            return ObjectResponse.success((Object)orderInfo);
        }
        log.info("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\uff0c\u672a\u627e\u5230\u7ed3\u679c\uff0c\u53c2\u6570\uff1a{}", (Object)orderNum);
        return ObjectResponse.failed((String)"404");
    }

    public List<OrderInfo> findWithHistoryByOrderNums(List<String> orderNums, List<String> tables) {
        if (CollectionUtils.isEmpty(orderNums)) {
            return null;
        }
        return this.orderInfoDao.selectWithHistoryByOrderNumList(tables, orderNums);
    }

    public ObjectResponse<OrderInfo> findInPark(String plateNum, String parkCode) {
        Long parkId = null;
        if (parkCode != null) {
            Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
            if (park == null) {
                return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            parkId = park.getId();
        }
        return this.findInParkId(plateNum, parkId);
    }

    public ObjectResponse<OrderInfo> findInParkId(String plateNum, Long parkId) {
        OrderCarInfo orderCarInfo;
        if (StringUtils.isEmpty((CharSequence)plateNum) || "\u672a\u8bc6\u522b".equals(plateNum) || "\u65e0\u724c\u8f66".equals(plateNum)) {
            return ObjectResponse.failed((String)"400");
        }
        OrderInfo orderInfoPara = new OrderInfo();
        orderInfoPara.setParkId(parkId);
        orderInfoPara.setPlateNum(plateNum);
        orderInfoPara.setServiceStatus(Integer.valueOf(1));
        List orderInfos = this.orderInfoDao.selectListOrderByEnterDesc(orderInfoPara);
        if (!CollectionUtils.isEmpty((Collection)orderInfos)) {
            OrderInfo orderInfo2;
            OrderCarInfo orderCarInfo2;
            OrderInfo orderInfo = (OrderInfo)orderInfos.get(0);
            if (orderInfos.size() == 1) {
                return ObjectResponse.success((Object)orderInfo);
            }
            OrderCarInfo orderCarInfo3 = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            if ((orderCarInfo3 == null || Integer.valueOf(5).equals(orderCarInfo3.getEnterWay())) && (orderCarInfo2 = this.orderCarInfoDao.selectByOrderNum((orderInfo2 = (OrderInfo)orderInfos.get(1)).getOrderNum())) != null && !Integer.valueOf(5).equals(orderCarInfo2.getEnterWay())) {
                orderInfo = orderInfo2;
            }
            return ObjectResponse.success((Object)orderInfo);
        }
        orderInfoPara.setServiceStatus(null);
        OrderInfo orderInfo = this.orderInfoDao.selectLimitOneByIdDesc(orderInfoPara);
        if (orderInfo == null) {
            log.info("\u6839\u636e\u8f66\u573a\u7f16\u53f7\u548c\u8f66\u724c\u53f7\u672a\u67e5\u8be2\u5230\u573a\u5185\u8ba2\u5355, \u53c2\u6570:{}, {}", (Object)plateNum, (Object)parkId);
        } else if (!(!orderInfo.getServiceStatus().equals(4) || orderInfo.getNoneEnterFlag() != null && orderInfo.getNoneEnterFlag() != 0 || (orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum())) == null || Integer.valueOf(5).equals(orderCarInfo.getEnterWay()) || !OrderOddStatusEnum.\u975e\u6b63\u5e38\u51fa\u573a.getVal().equals(orderInfo.getOddStatus()) || orderInfo.getExitTime() != null && orderInfo.getExitTime() <= DateTools.unixTimestamp() - 86400L)) {
            log.info("\u6839\u636e\u8f66\u573a\u7f16\u53f7\u548c\u8f66\u724c\u53f7\u67e5\u8be2\u5230\u4e86\u6700\u540e\u4e00\u6b21\u8ba2\u5355\u662f\u5f02\u5e38\u79bb\u573a, \u53c2\u6570:{}, {}, {}, {}", new Object[]{plateNum, parkId, orderInfo.getId(), orderInfo.getExitTime()});
            return ObjectResponse.success((Object)orderInfo);
        }
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u60a8\u7684\u7231\u8f66\u4e0d\u5728\u573a");
    }

    public ObjectResponse<OrderSonInfo> findOrderSon(String orderNum, Long regionId) {
        if (orderNum == null || regionId == null) {
            return ObjectResponse.failed((String)"400");
        }
        OrderSonInfo param = new OrderSonInfo();
        param.setOrderNum(orderNum);
        param.setRegionId(regionId);
        OrderSonInfo orderSonInfo = this.orderSonInfoDao.selectOneByEntity(param);
        return ObjectResponse.returnNotFoundIfNull((Object)orderSonInfo);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.searchCarInfo", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<SearchCarResponse>> searchCarInfo(PageQuery<SearchCarRequest> pageQuery) {
        SearchCarRequest searchCarRequest = (SearchCarRequest)pageQuery.getParam();
        String parkCode = searchCarRequest.getParkCode();
        String plateNum = searchCarRequest.getPlateNum();
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"402", (String)"\u8f66\u573a\u672a\u6ce8\u518c");
        }
        Long parkId = park.getId();
        List<OrderInfo> orderInfos = this.getOrderInfos(pageQuery, plateNum, parkId);
        if (orderInfos != null && orderInfos.size() > 0) {
            ArrayList<SearchCarResponse> list = new ArrayList<SearchCarResponse>();
            for (OrderInfo orderInfo1 : orderInfos) {
                SearchCarResponse searchCarResponse = this.getSearchCarResponse(parkCode, plateNum, orderInfo1);
                list.add(searchCarResponse);
            }
            return ObjectResponse.success(list);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<OrderInfo> findByOrderInfo(OrderInfo orderInfo) {
        OrderInfo orderInfoRet = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet != null) {
            return ObjectResponse.success((Object)orderInfoRet);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.countEnterCarList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countEnterCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer reliability = orderQueryRequest.getReliability();
            List type = orderQueryRequest.getTypes();
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (StringUtils.isNotEmpty((CharSequence)plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            int count = this.orderInfoDao.countEnterRecords(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, type, reliability);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u5165\u573a\u8f66\u8f86\u603b\u6761\u6570\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. orderQueryRequest[{}]", new Object[]{e.getMessage(), orderQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getEnterCarList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<EnterCarDto>> getEnterCarList(OrderQueryRequest orderQueryRequest) {
        try {
            List records;
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer reliability = orderQueryRequest.getReliability();
            List type = orderQueryRequest.getTypes();
            List tagIds = orderQueryRequest.getTagIds();
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            log.info("getEnterCarList  ==> {} {} {} {} {} {}", new Object[]{parkid, startTime, plateNumber, type, reliability, tagIds});
            PageHelper.startPage((int)orderQueryRequest.getPageNo(), (int)orderQueryRequest.getPageSize());
            if (StringUtils.isNotEmpty((CharSequence)plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            if (CollectionUtils.isEmpty((Collection)(records = this.orderInfoDao.selectEnterRecords(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, type, reliability, tagIds, orderQueryRequest.getChannelCodes())))) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList enterCarDtos = Lists.newArrayList();
            Long currentDate = System.currentTimeMillis() / 1000L;
            List<Long> parkIds = records.stream().map(OrderInfo::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ParkRecoveryVo> recoveryByParkIds = this.parkRecoveryService.getOpenParkRecoveryByParkIds(parkIds);
            HashSet recoveryParkIds = new HashSet();
            if (!CollectionUtils.isEmpty(recoveryByParkIds)) {
                recoveryParkIds.addAll(recoveryByParkIds.stream().map(ParkRecovery::getParkId).filter(Objects::nonNull).collect(Collectors.toSet()));
            }
            records.forEach(orderInfo -> {
                List orderTags;
                EnterCarDto enterCarDto = new EnterCarDto();
                enterCarDto.setId(orderInfo.getId());
                enterCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
                enterCarDto.setPlateNumber(orderInfo.getPlateNum());
                enterCarDto.setType(orderInfo.getType());
                enterCarDto.setOrderNum(orderInfo.getOrderNum());
                long parkTime = currentDate - orderInfo.getEnterTime();
                enterCarDto.setParkTime(Long.valueOf(parkTime));
                Park park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
                enterCarDto.setParkName(park.getParkName());
                enterCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());
                OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                if (carInfo != null) {
                    enterCarDto.setImgUrl(this.ossService.getImageUrl(carInfo.getEnterImage()));
                    enterCarDto.setEnterName(carInfo.getEnterNo());
                }
                if (parkTime >= 60L) {
                    enterCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int)((int)parkTime)));
                } else {
                    enterCarDto.setParkTimeStr(parkTime + "\u79d2");
                }
                enterCarDto.setCarType(orderInfo.getCarType());
                String s = this.orderInfoDao.selectMadeNum(orderInfo.getOrderNum());
                if (!Objects.isNull(s)) {
                    enterCarDto.setReliability(Integer.valueOf(1));
                }
                enterCarDto.setHasSon(orderInfo.getHasSon());
                if (recoveryParkIds.contains(orderInfo.getParkId()) && !CollectionUtils.isEmpty((Collection)(orderTags = this.orderTagsService.getListByOrderNum(orderInfo.getOrderNum(), Integer.valueOf(0))))) {
                    enterCarDto.setOrderTag(orderTags.stream().map(OrderTags::getTagId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                enterCarDtos.add(enterCarDto);
            });
            return ObjectResponse.success((Object)enterCarDtos);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u5165\u573a\u8f66\u8f86\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. orderQueryRequest[{}]", new Object[]{e.getMessage(), orderQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getEnterCarDetail", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<EnterCarDto> getEnterCarDetail(String parkCode, Integer recordId) {
        try {
            OrderInfo orderInfo = (OrderInfo)this.orderInfoDao.selectById((Serializable)recordId);
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            Long currentDate = System.currentTimeMillis() / 1000L;
            EnterCarDto enterCarDto = new EnterCarDto();
            enterCarDto.setId(orderInfo.getId());
            enterCarDto.setRegionId(orderInfo.getRegionId());
            enterCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
            enterCarDto.setPlateNumber(orderInfo.getPlateNum());
            enterCarDto.setType(orderInfo.getType());
            enterCarDto.setCarType(orderInfo.getCarType());
            long parkTime = currentDate - orderInfo.getEnterTime();
            enterCarDto.setParkTime(Long.valueOf(parkTime));
            enterCarDto.setImgUrl(this.ossService.getImageUrl(carInfo.getEnterImage()));
            enterCarDto.setEnterName(carInfo.getEnterNo());
            enterCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int)((int)parkTime)));
            enterCarDto.setHasSon(orderInfo.getHasSon());
            enterCarDto.setRemark(carInfo.getRemark());
            enterCarDto.setEnterWay(carInfo.getEnterWay());
            enterCarDto.setEnterOperAccount(carInfo.getEnterOperAccount());
            enterCarDto.setEnterTerminal(carInfo.getEnterTerminal());
            return ObjectResponse.success((Object)enterCarDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u5165\u573a\u8f66\u8f86\u8be6\u60c5\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. parkCode[{}], recordId[{}]", new Object[]{e.getMessage(), parkCode, recordId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getExitCarList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<ExitCarDto>> getExitCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkid;
            String parkCodes = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            List type = orderQueryRequest.getTypes();
            Date enterStartTime = orderQueryRequest.getEnterStartTime();
            Date enterEndTime = orderQueryRequest.getEnterEndTime();
            String[] split = parkCodes.split(",");
            List tagIds = orderQueryRequest.getTagIds();
            String cardOwner = orderQueryRequest.getCardOwner();
            ArrayList plateNums = new ArrayList();
            String string = parkid = orderQueryRequest.getParkId() == null ? null : orderQueryRequest.getParkId().toString();
            if (parkid == null && (parkid = this.parkDao.selectByCodes(split)).endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            if (StringUtils.isNotBlank((CharSequence)cardOwner)) {
                List monthPlateList;
                List monthInfos;
                Long parkId = NumberUtils.parseLong((Object)parkid.split(",")[0]);
                List monthPlates = this.monthPlateDao.selectByParkIdAndOwner(parkId, cardOwner);
                if (CollectionUtils.isNotEmpty((Collection)monthPlates)) {
                    plateNums.addAll(monthPlates.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)(monthInfos = this.monthInfoDao.selectByParkIdAndOwner(parkId, cardOwner))) && CollectionUtils.isNotEmpty((Collection)(monthPlateList = this.monthPlateDao.selectByMonthIds(monthInfos.stream().map(MonthInfo::getId).collect(Collectors.toList()))))) {
                    plateNums.addAll(monthPlateList.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList()));
                }
            }
            PageHelper.startPage((int)orderQueryRequest.getPageNo(), (int)orderQueryRequest.getPageSize());
            List records = this.orderInfoDao.selectExitRecords(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, type, Objects.isNull(enterStartTime) ? null : Long.valueOf(enterStartTime.getTime() / 1000L), Objects.isNull(enterEndTime) ? null : Long.valueOf(enterEndTime.getTime() / 1000L), orderQueryRequest.getNoplateFee(), orderQueryRequest.getOrderNum(), tagIds, orderQueryRequest.getFreeFlag(), orderQueryRequest.getChannelCodes(), plateNums);
            if (CollectionUtils.isEmpty((Collection)records)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList exitCarDtos = Lists.newArrayList();
            List<Long> parkIds = records.stream().map(OrderInfo::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ParkRecoveryVo> parkRecoveryByParkIds = this.parkRecoveryService.getOpenParkRecoveryByParkIds(parkIds);
            HashSet recoveryParkIds = new HashSet();
            if (!CollectionUtils.isEmpty(parkRecoveryByParkIds)) {
                recoveryParkIds.addAll(parkRecoveryByParkIds.stream().map(ParkRecovery::getParkId).filter(Objects::nonNull).collect(Collectors.toSet()));
            }
            records.forEach(orderInfo -> {
                List orderTags;
                Park park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
                ExitCarDto exitCarDto = new ExitCarDto();
                exitCarDto.setId(orderInfo.getId());
                if (orderInfo.getEnterTime() != null) {
                    exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
                }
                if (orderInfo.getExitTime() != null) {
                    exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000L));
                    long parktime = orderInfo.getExitTime() - orderInfo.getEnterTime();
                    parktime = parktime < 0L ? 0L : parktime;
                    exitCarDto.setParkTime(Long.valueOf(parktime));
                    exitCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int)((int)parktime)));
                }
                exitCarDto.setPlateNumber(orderInfo.getPlateNum());
                exitCarDto.setType(orderInfo.getType().intValue());
                exitCarDto.setPaidPrice(orderInfo.getPaidPrice());
                exitCarDto.setOperAccouont(orderInfo.getOperAccount());
                exitCarDto.setParkName(park.getParkName());
                exitCarDto.setTotalPrice(orderInfo.getTotalPrice());
                exitCarDto.setDiscountPrice(orderInfo.getDiscountPrice());
                exitCarDto.setOrderNo(orderInfo.getOrderNum());
                exitCarDto.setHasSon(orderInfo.getHasSon());
                exitCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());
                OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                if (carInfo != null) {
                    if (StringUtils.isNotBlank((CharSequence)carInfo.getEnterImage())) {
                        exitCarDto.setEnterImg(this.ossService.getImageUrl(carInfo.getEnterImage()));
                    }
                    exitCarDto.setEnterName(carInfo.getEnterNo());
                    if (StringUtils.isNotBlank((CharSequence)carInfo.getExitImage())) {
                        exitCarDto.setExitImg(this.ossService.getImageUrl(carInfo.getExitImage()));
                    }
                }
                if (recoveryParkIds.contains(orderInfo.getParkId()) && !CollectionUtils.isEmpty((Collection)(orderTags = this.orderTagsService.getListByOrderNum(orderInfo.getOrderNum(), Integer.valueOf(0))))) {
                    exitCarDto.setOrderTag(orderTags.stream().map(OrderTags::getTagId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                exitCarDtos.add(exitCarDto);
            });
            return ObjectResponse.success((Object)exitCarDtos);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u79bb\u573a\u8f66\u8f86\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. orderQueryRequest[{}]", new Object[]{e.getMessage(), orderQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.countParkingTime", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<ExitCarDto>> countParkingTime(String parkIds, Integer day, String pointMonth) {
        try {
            Date endTime;
            Date startTime;
            List list;
            SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            if (day == 2) {
                list = DateRangeUtils.getDaysMultiformat((Integer)1, (int)1);
                startTime = sf.parse((String)list.get(0) + " 00:00:00");
                endTime = sf.parse((String)list.get(list.size() - 1) + " 23:59:59");
            } else if (day == 7 || day == 30) {
                list = DateRangeUtils.getDaysMultiformat((Integer)day, (int)1);
                startTime = sf.parse((String)list.get(0) + " 00:00:00");
                endTime = sf.parse((String)list.get(list.size() - 1) + " 23:59:59");
            } else {
                startTime = sf.parse(pointMonth + "/01 00:00:00");
                endTime = sf.parse(pointMonth + "/31 23:59:59");
            }
            List records = this.orderInfoDao.countParkingTime(parkIds, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
            if (CollectionUtils.isEmpty((Collection)records)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList exitCarDtos = Lists.newArrayList();
            records.forEach(orderInfo -> {
                long parktime;
                ExitCarDto exitCarDto = new ExitCarDto();
                if (orderInfo.getEnterTime() != null) {
                    exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
                }
                if (orderInfo.getExitTime() != null) {
                    exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000L));
                }
                exitCarDto.setParkTime(Long.valueOf((parktime = orderInfo.getExitTime() - orderInfo.getEnterTime()) < 0L ? 0L : parktime));
                exitCarDtos.add(exitCarDto);
            });
            return ObjectResponse.success((Object)exitCarDtos);
        }
        catch (Exception e) {
            log.error("[\u8f66\u4e3b\u7aef\u5c0f\u7a0b\u5e8f-\u505c\u8f66\u65f6\u957f\u7edf\u8ba1]\u5904\u7406\u5931\u8d25: {}. parkIds[{}], day[{}], pointMonth[{}]", new Object[]{e.getMessage(), parkIds, day, pointMonth, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getExitCarDetail", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<ExitCarDto> getExitCarDetail(String parkCode, Integer recordId) {
        try {
            OrderInfo orderInfo = (OrderInfo)this.orderInfoDao.selectById((Serializable)recordId);
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            ExitCarDto exitCarDto = new ExitCarDto();
            exitCarDto.setId(carInfo.getId());
            exitCarDto.setOrderNo(carInfo.getOrderNum());
            exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
            exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000L));
            long time = orderInfo.getExitTime() - orderInfo.getEnterTime();
            time = time < 0L ? 0L : time;
            exitCarDto.setParkTime(Long.valueOf(time));
            exitCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int)((int)time)));
            exitCarDto.setPlateNumber(orderInfo.getPlateNum());
            exitCarDto.setType(orderInfo.getType().intValue());
            exitCarDto.setCarType(orderInfo.getCarType().intValue());
            exitCarDto.setTotalPrice(orderInfo.getTotalPrice());
            exitCarDto.setPaidPrice(orderInfo.getPaidPrice());
            exitCarDto.setDiscountPrice(orderInfo.getDiscountPrice());
            exitCarDto.setEnterImg(this.ossService.getImageUrl(carInfo.getEnterImage()));
            exitCarDto.setExitImg(this.ossService.getImageUrl(carInfo.getExitImage()));
            exitCarDto.setEnterName(carInfo.getEnterNo());
            exitCarDto.setOddStatus(orderInfo.getOddStatus());
            exitCarDto.setExitName(carInfo.getExitNo());
            exitCarDto.setHasSon(orderInfo.getHasSon());
            exitCarDto.setExitWay(carInfo.getExitWay());
            exitCarDto.setEnterWay(carInfo.getEnterWay());
            exitCarDto.setExitOperAccount(carInfo.getExitOperAccount());
            exitCarDto.setEnterOperAccount(carInfo.getEnterOperAccount());
            exitCarDto.setExitTerminal(carInfo.getExitTerminal());
            exitCarDto.setEnterTerminal(carInfo.getEnterTerminal());
            exitCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());
            exitCarDto.setEnterRemark(carInfo.getRemark());
            exitCarDto.setExitRemark(carInfo.getExitRemark());
            return ObjectResponse.success((Object)exitCarDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u79bb\u573a\u8f66\u8f86\u8be6\u60c5\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. parkCode[{}], recordId[{}]", new Object[]{e.getMessage(), parkCode, recordId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse addOrderInfo(OrderInfo orderInfo) {
        this.orderInfoDao.insertWithPlateNum2(orderInfo);
        if (orderInfo.getServiceStatus() != null && orderInfo.getServiceStatus() == 1) {
            this.pushService.pushOrderEnter(orderInfo);
        }
        if (orderInfo.getServiceStatus() != null && (orderInfo.getServiceStatus() == 2 || orderInfo.getServiceStatus() == 4)) {
            this.pushService.pushOrderEnter(orderInfo);
            this.pushService.pushOrderExit(orderInfo, Integer.valueOf(5000));
        }
        return ObjectResponse.success();
    }

    public ObjectResponse updateOrderInfo(OrderInfo orderInfo) {
        this.orderInfoDao.updateByOrderNum(orderInfo);
        return ObjectResponse.success();
    }

    public ObjectResponse<Integer> updateOrderWithPush(OrderInfo orderInfo) {
        int result = this.orderInfoDao.updateByOrderNum(orderInfo);
        OrderInfo para = new OrderInfo();
        para.setParkId(orderInfo.getParkId());
        para.setPlateNum(orderInfo.getPlateNum());
        para.setServiceStatus(Integer.valueOf(1));
        OrderInfo orderInfo1 = this.orderInfoDao.selectLimitOneNotOrderByEnterDesc(para, orderInfo.getOrderNum());
        if (orderInfo1 != null && orderInfo1.getEnterTime() < NumberUtils.toPrimitive((Long)orderInfo.getEnterTime())) {
            log.info("\u6709\u5176\u4ed6\u5728\u573a\u8ba2\u5355, \u5220\u9664\u8ba2\u5355{}", (Object)orderInfo1);
            orderInfo1.setServiceStatus(Integer.valueOf(3));
            this.orderInfoDao.updateByOrderNum(orderInfo1);
        }
        if (result > 0 && orderInfo.getServiceStatus() != null && (orderInfo.getServiceStatus() == 2 || orderInfo.getServiceStatus() == 4)) {
            this.pushService.pushOrderExit(orderInfo);
        }
        if (result == 0 && orderInfo.getCreateTime() != null) {
            log.info("\u66f4\u65b0\u8ba2\u5355\u5386\u53f2\u8868, {}", (Object)orderInfo);
            DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
            List yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
            for (String tableName : yearQuarterRangeTableName) {
                int n = this.orderInfoDao.updateHistoryTable(tableName, orderInfo);
                if (n <= 0) continue;
                result = n;
                break;
            }
        }
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig, String channelId) {
        Park park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(park.getParkCode());
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeRequest.setChannelId(channelId);
        queryOrderFeeRequest.setExitTime(orderInfo.getExitTime());
        ThirdInfo payUrlThirdInfo = null;
        try {
            payUrlThirdInfo = this.thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u652f\u4ed8\u5904\u7406\u5931\u8d25: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", new Object[]{e.getMessage(), orderInfo, parkConfig, channelId, e});
        }
        try {
            if (Objects.nonNull(payUrlThirdInfo)) {
                ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
                thirdFeeRequest.setCarType(orderInfo.getCarType());
                thirdFeeRequest.setChannelCode(channelId);
                thirdFeeRequest.setEnterTime(orderInfo.getEnterTime());
                thirdFeeRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
                thirdFeeRequest.setOrderNum(orderInfo.getOrderNum());
                thirdFeeRequest.setParkCode(park.getParkCode());
                thirdFeeRequest.setParkTime(Integer.valueOf(Math.toIntExact(thirdFeeRequest.getExitTime() - orderInfo.getEnterTime())));
                thirdFeeRequest.setPlateNum(orderInfo.getPlateNum());
                return this.queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
            }
            return this.p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park, parkConfig);
        }
        catch (ResponseBodyException re) {
            log.warn("\u5904\u7406\u5931\u8d25: {}:{}. orderInfo[{}], parkConfig[{}], channelId[{}]", new Object[]{re.getErrCode(), re.getMessage(), orderInfo, parkConfig, channelId, re});
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", new Object[]{e.getMessage(), orderInfo, parkConfig, channelId, e});
            return ObjectResponse.failed((String)"500", (String)(CodeConstants.getName((String)"500") + e.getMessage()));
        }
    }

    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig) {
        Park park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(park.getParkCode());
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        try {
            return this.p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park, parkConfig);
        }
        catch (ResponseBodyException re) {
            log.warn("\u5904\u7406\u5931\u8d25: {}:{}. orderInfo[{}], parkConfig[{}]", new Object[]{re.getErrCode(), re.getMessage(), orderInfo, parkConfig, re});
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. orderInfo[{}], parkConfig[{}]", new Object[]{e.getMessage(), orderInfo, parkConfig, e});
            return ObjectResponse.failed((String)"500", (String)(CodeConstants.getName((String)"500") + e.getMessage()));
        }
    }

    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        String orderNum = queryOrderFeeRequest.getOrderNum();
        if (StringUtils.isBlank((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"400", (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String parkCode = queryOrderFeeRequest.getParkCode();
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(park.getId()).getData();
        if (Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay()) && Integer.valueOf(1).equals(queryOrderFeeRequest.getExType())) {
            QueryOrderFeeResponse queryOrderFeeResponse = this.queryOrderFeeService.queryNotPay(queryOrderFeeRequest, queryOrderFeeRequest.getPlateNum(), parkConfig, null, park.getParkName());
            if (queryOrderFeeResponse == null) {
                return ObjectResponse.failed((String)"404", (String)"\u65e0\u6b20\u8d39\u8bb0\u5f55");
            }
            return ObjectResponse.success((Object)queryOrderFeeResponse);
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(park.getId());
        orderInfo.setOrderNum(orderNum);
        OrderInfo orderInfoRet = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (orderInfoRet.getServiceStatus() != null && (orderInfoRet.getServiceStatus().equals(2) || orderInfoRet.getServiceStatus().equals(3))) {
            return ObjectResponse.failed((String)"3004", (String)"\u8f66\u8f86\u5df2\u79bb\u573a");
        }
        ObjectResponse<QueryOrderFeeResponse> objectResponse = this.executeQueryFee(queryOrderFeeRequest, park, orderInfoRet, parkConfig);
        if (!Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay())) {
            return objectResponse;
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.queryOrderFeeService.queryNotPay(queryOrderFeeRequest, orderInfoRet.getPlateNum(), parkConfig, (QueryOrderFeeResponse)objectResponse.getData(), park.getParkName());
        if (queryOrderFeeResponse == null) {
            return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
        }
        return ObjectResponse.success((Object)queryOrderFeeResponse);
    }

    private ObjectResponse<QueryOrderFeeResponse> executeQueryFee(QueryOrderFeeRequest queryOrderFeeRequest, Park park, OrderInfo orderInfoRet, ParkConfig parkConfig) {
        ThirdInfo payUrlThirdInfo = null;
        try {
            payUrlThirdInfo = this.thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        }
        catch (Exception e) {
            log.error("\u4e09\u65b9\u8bf7\u6c42\u652f\u4ed8\u5904\u7406\u5931\u8d25: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", new Object[]{e.getMessage(), orderInfoRet, parkConfig, queryOrderFeeRequest.getChannelId(), e});
        }
        try {
            if (Objects.nonNull(payUrlThirdInfo)) {
                ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
                thirdFeeRequest.setCarType(orderInfoRet.getCarType());
                thirdFeeRequest.setChannelCode(queryOrderFeeRequest.getChannelId());
                thirdFeeRequest.setEnterTime(orderInfoRet.getEnterTime());
                thirdFeeRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
                thirdFeeRequest.setOrderNum(orderInfoRet.getOrderNum());
                thirdFeeRequest.setParkCode(park.getParkCode());
                thirdFeeRequest.setParkTime(Integer.valueOf(Math.toIntExact(thirdFeeRequest.getExitTime() - orderInfoRet.getEnterTime())));
                thirdFeeRequest.setPlateNum(orderInfoRet.getPlateNum());
                return this.queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
            }
            return this.p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfoRet, park, parkConfig);
        }
        catch (ResponseBodyException re) {
            log.error("\u5904\u7406\u5931\u8d25: {}:{}. queryOrderFeeRequest[{}]", new Object[]{re.getErrCode(), re.getMessage(), queryOrderFeeRequest});
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. queryOrderFeeRequest[{}]", new Object[]{e.getMessage(), queryOrderFeeRequest, e});
            return ObjectResponse.failed((String)"500", (String)(CodeConstants.getName((String)"500") + e.getMessage()));
        }
    }

    public ObjectResponse<Void> pncQueryFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        String orderNum = queryOrderFeeRequest.getOrderNum();
        String parkCode = queryOrderFeeRequest.getParkCode();
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(park.getId());
        orderInfo.setOrderNum(orderNum);
        OrderInfo orderInfoRet = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        return this.pncQueryFeeService.queryFee(queryOrderFeeRequest, orderInfoRet, park);
    }

    public ObjectResponse<OrderInfo> fuzzyPlate(Long parkId, String inandoutCode, String plateNum) {
        if (StringUtils.isBlank((CharSequence)plateNum)) {
            return ObjectResponse.failed((String)"404", (String)"\u60a8\u7684\u7231\u8f66\u4e0d\u5728\u573a");
        }
        OrderInfo orderInfo = null;
        ObjectResponse parkChannelResp = this.parkService.getInoutDeviceByCode(inandoutCode);
        if (!ObjectResponse.isSuccess((Response)parkChannelResp)) {
            return ObjectResponse.failed((String)"404");
        }
        ParkInoutdevice parkChannel = (ParkInoutdevice)parkChannelResp.getData();
        int isOpenVaguetype = NumberUtils.toPrimitive((Integer)parkChannel.getIsOpenVaguetype());
        if (isOpenVaguetype == 1) {
            int vaguetype = NumberUtils.toPrimitive((Integer)parkChannel.getVaguetype());
            if (vaguetype == 0) {
                String plateNumPart = plateNum.substring(1);
                orderInfo = this.orderInfoDao.fuzzyInParkPlate2(parkId, plateNumPart);
            } else if (vaguetype == 1) {
                orderInfo = this.fuzzyPlateNum(parkId, plateNum, 1);
            } else if (vaguetype == 2 && (orderInfo = this.fuzzyPlateNum(parkId, plateNum, 1)) == null) {
                orderInfo = this.fuzzyPlateNum(parkId, plateNum, 2);
            }
            if (orderInfo != null) {
                OrderInfo orderInfoRet = this.orderInfoDao.fuzzyByPlateNums(parkId, this.getFuzzyPlateNums(vaguetype, plateNum));
                boolean queryHistory = false;
                if (orderInfoRet != null && orderInfo.getId().equals(orderInfoRet.getId())) {
                    queryHistory = true;
                }
                if (orderInfoRet == null && (DateTools.unixTimestamp() - orderInfo.getEnterTime()) / 3600L / 24L > 30L) {
                    queryHistory = true;
                }
                if (queryHistory) {
                    Date startDate = new Date(orderInfo.getEnterTime() * 1000L);
                    orderInfoRet = this.orderInfoDao.fuzzyRecentHistoryOrder(DateRangeUtils.getYearQuarterRangeTableName((Date)startDate), parkId, this.getFuzzyPlateNums(vaguetype, plateNum));
                }
                if (orderInfoRet != null && !orderInfo.getId().equals(orderInfoRet.getId()) && orderInfo.getEnterTime() <= orderInfoRet.getEnterTime()) {
                    log.info("\u6a21\u7cca\u5339\u914d\u5931\u8d25, \u6a21\u7cca\u5230\u7684\u5165\u573a\u65f6\u95f4\u5728\u5b8c\u6574\u8f66\u724c\u8ba2\u5355\u4e4b\u524d, \u6a21\u7cca\u5339\u914d\u7684\u8ba2\u5355[{}], \u5f53\u524d\u8f66\u724c[{}]", (Object)orderInfo, (Object)plateNum);
                    orderInfo = null;
                }
            }
        }
        if (orderInfo == null) {
            return ObjectResponse.failed((String)"404", (String)"\u60a8\u7684\u7231\u8f66\u4e0d\u5728\u573a");
        }
        return ObjectResponse.success(orderInfo);
    }

    public ObjectResponse<OrderInfo> fuzzyPlate(Long parkId, String plateNum) {
        String plateNumPart = plateNum.substring(1);
        OrderInfo orderInfo = this.orderInfoDao.fuzzyInParkPlate2(parkId, plateNumPart);
        if (orderInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)orderInfo);
    }

    public ObjectResponse<OrderInfo> fuzzyOrderPlate(long parkId, String plateNum, int status, int vagueType) {
        OrderInfo orderInfo = null;
        if (vagueType == 0) {
            orderInfo = this.fuzzyPlateNum(parkId, plateNum, status, 0);
        } else if (vagueType == 1) {
            orderInfo = this.fuzzyPlateNum(parkId, plateNum, status, 1);
        } else if (vagueType == 2 && (orderInfo = this.fuzzyPlateNum(parkId, plateNum, status, 1)) == null) {
            orderInfo = this.fuzzyPlateNum(parkId, plateNum, status, 2);
        }
        return ObjectResponse.returnNotFoundIfNull((Object)orderInfo);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getMpOrderList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderDto>> getMpOrderList(OrderQueryRequest orderQueryRequest) {
        try (Page page = PageHelper.startPage((int)orderQueryRequest.getPageNo(), (int)orderQueryRequest.getPageSize());){
            List orderDtos = Lists.newArrayList();
            String plateNum = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer type = orderQueryRequest.getType();
            Integer mpUserId = orderQueryRequest.getMpUserId();
            if (type == 1) {
                orderDtos = this.orderPayDao.selectMpOrderListByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
            }
            if (type == 2) {
                orderDtos = this.monthOrderDao.selectMpOrderByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
            }
            if (type == 3) {
                orderDtos = this.orderPayDao.selectMpOrderList(mpUserId, plateNum, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
            }
            if (CollectionUtils.isEmpty((Collection)orderDtos)) {
                ObjectResponse objectResponse = ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
                return objectResponse;
            }
            ObjectResponse objectResponse = ObjectResponse.success((Object)orderDtos);
            return objectResponse;
        }
    }

    public ObjectResponse<List<OrderInfoDto>> getMpOrders(OrderQueryRequest orderQueryRequest) {
        try (Page page = PageHelper.startPage((int)orderQueryRequest.getPageNo(), (int)orderQueryRequest.getPageSize(), (boolean)orderQueryRequest.isCount());){
            List orderInfoDtos = this.orderInfoDao.selectMpOrderInfos(orderQueryRequest);
            ObjectResponse objectResponse = CollectionUtils.isEmpty((Collection)orderInfoDtos) ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)orderInfoDtos);
            return objectResponse;
        }
    }

    public ObjectResponse<OrderCountDto> countMpOrderList(OrderQueryRequest orderQueryRequest) {
        String plateNum = orderQueryRequest.getPlateNumber();
        Date startTime = orderQueryRequest.getStartTime();
        Date endTime = orderQueryRequest.getEndTime();
        Integer mpUserId = orderQueryRequest.getMpUserId();
        OrderCountDto orderCount = this.orderPayDao.countMpOrderByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
        return ObjectResponse.success((Object)orderCount);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse batchAddLiveCar(List<OrderAddRequest> result, Boolean flag, Park park, String userName, List<ParkRegion> parkRegions) {
        Long parkId = park.getId();
        List<String> plateNums = result.stream().map(OrderAddRequest::getPlateNum).filter(Objects::nonNull).collect(Collectors.toList());
        List<OrderInfo> liveOrders = this.getLiveOrderListsByPlateNums(plateNums, parkId);
        if (CollectionUtils.isNotEmpty(liveOrders) && CollectionUtils.isNotEmpty(liveOrders)) {
            List orderInfos = liveOrders.stream().map(order -> {
                OrderInfo update = new OrderInfo();
                update.setId(order.getId());
                update.setServiceStatus(Integer.valueOf(4));
                update.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                update.setOperAccount(userName);
                update.setExitTime(order.getEnterTime());
                return update;
            }).collect(Collectors.toList());
            this.updateBatchById(orderInfos);
            List orderNums = liveOrders.stream().map(OrderInfo::getOrderNum).collect(Collectors.toList());
            LambdaQueryWrapper orderSonQuery = Wrappers.lambdaQuery(OrderSonInfo.class);
            orderSonQuery.in(OrderInfo::getOrderNum, orderNums);
            orderSonQuery.eq(OrderInfo::getServiceStatus, (Object)1);
            List sonInfos = this.orderSonInfoService.list((Wrapper)orderSonQuery);
            if (CollectionUtils.isNotEmpty((Collection)sonInfos)) {
                List updateOrderSons = sonInfos.stream().map(order -> {
                    OrderSonInfo update = new OrderSonInfo();
                    update.setId(order.getId());
                    update.setServiceStatus(Integer.valueOf(4));
                    update.setOddStatus(OrderOddStatusEnum.\u91cd\u590d\u5165\u573a.getVal());
                    update.setOperAccount(userName);
                    update.setExitTime(order.getEnterTime());
                    return update;
                }).collect(Collectors.toList());
                this.orderSonInfoService.updateBatchById(updateOrderSons);
            }
        }
        if (flag.booleanValue()) {
            this.addNormalLiveOrder(result, parkId, userName);
            return ObjectResponse.success();
        }
        this.addMorelLiveOrder(result, parkId, userName, parkRegions);
        return ObjectResponse.success();
    }

    @DS_SLAVE
    public List<OrderInfo> getLiveOrderListsByPlateNums(List<String> plateNums, Long parkId) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).in(OrderInfo::getPlateNum, plateNums)).eq(OrderInfo::getServiceStatus, (Object)1));
    }

    public void addNormalLiveOrder(List<OrderAddRequest> result, Long parkId, String userName) {
        ArrayList<OrderInfo> orderInfos = new ArrayList<OrderInfo>();
        ArrayList<OrderCarInfo> orderCarInfos = new ArrayList<OrderCarInfo>();
        for (OrderAddRequest request : result) {
            OrderInfo orderInfo = OrderInfo.builder().orderNum(this.idGenerator.nextIdAsString()).parkId(parkId).plateNum(request.getPlateNum()).plateNum2(StringUtils.substring((String)request.getPlateNum(), (int)1)).type(request.getType()).hasSon(Integer.valueOf(0)).enterTime(request.getEnterTime()).serviceStatus(Integer.valueOf(1)).operAccount(userName).carType(request.getCarType()).build();
            orderInfos.add(orderInfo);
            OrderCarInfo carInfo = new OrderCarInfo();
            carInfo.setOrderNum(orderInfo.getOrderNum());
            carInfo.setPlateColor(request.getPlateColor());
            carInfo.setEnterWay(Integer.valueOf(4));
            carInfo.setEnterTerminal(Integer.valueOf(6));
            carInfo.setEnterOperAccount(userName);
            orderCarInfos.add(carInfo);
        }
        this.saveBatch(orderInfos);
        this.orderCarInfoService.saveBatch(orderCarInfos);
        this.updateParkFreeSpaceService.resetFreeSpace(parkId);
    }

    public void addMorelLiveOrder(List<OrderAddRequest> result, Long parkId, String userName, List<ParkRegion> parkRegions) {
        Long outRegionId = this.getRegionIdByType(parkRegions, 1);
        Long inRegionId = this.getRegionIdByType(parkRegions, 2);
        ArrayList<OrderInfo> orderInfos = new ArrayList<OrderInfo>();
        ArrayList<OrderCarInfo> orderCarInfos = new ArrayList<OrderCarInfo>();
        ArrayList<OrderSonInfo> outOrderSonInfos = new ArrayList<OrderSonInfo>();
        ArrayList<OrderSonCarInfo> outOrderSonCarInfos = new ArrayList<OrderSonCarInfo>();
        ArrayList<OrderSonInfo> innerOrderSonInfos = new ArrayList<OrderSonInfo>();
        ArrayList<OrderSonCarInfo> innerOrderSonCarInfos = new ArrayList<OrderSonCarInfo>();
        ArrayList<OrderTrack> tracks = new ArrayList<OrderTrack>();
        Map<String, List<OrderAddRequest>> map = result.stream().collect(Collectors.groupingBy(OrderAddRequest::getPlateNum));
        for (Map.Entry<String, List<OrderAddRequest>> entry : map.entrySet()) {
            List<OrderAddRequest> requests = entry.getValue();
            if (requests.size() > 1) {
                this.processMultipleRequests(parkId, userName, inRegionId, outRegionId, orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, entry);
                continue;
            }
            this.processSingleRequest(parkId, userName, outRegionId, inRegionId, orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, requests.get(0));
        }
        this.saveAll(orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, parkId, parkRegions);
    }

    public Long getRegionIdByType(List<ParkRegion> parkRegions, int type) {
        return parkRegions.stream().filter(region -> region.getRegionType() != null && region.getRegionType() == type).map(ParkRegion::getId).findFirst().orElse(null);
    }

    public void processMultipleRequests(Long parkId, String userName, Long inRegionId, Long outRegionId, List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, Map.Entry<String, List<OrderAddRequest>> entry) {
        List<OrderAddRequest> requests = entry.getValue();
        Optional<OrderAddRequest> first = requests.stream().filter(a -> a.getRegionId().equals(outRegionId)).findFirst();
        Optional<OrderAddRequest> second = requests.stream().filter(a -> a.getRegionId().equals(inRegionId)).findFirst();
        OrderAddRequest outRequest = first.get();
        OrderAddRequest inRequest = second.get();
        String plateNum = entry.getKey();
        OrderInfo orderInfo = this.createOrderInfo(parkId, userName, outRegionId, plateNum, outRequest);
        orderInfo.setHasSon(Integer.valueOf(1));
        orderInfos.add(orderInfo);
        orderCarInfos.add(this.createOrderCarInfo(orderInfo, outRequest, userName));
        OrderSonInfo outSonInfo = new OrderSonInfo();
        outSonInfo.setOrderNum(orderInfo.getOrderNum());
        outSonInfo.setParkId(orderInfo.getParkId());
        outSonInfo.setPlateNum(plateNum);
        outSonInfo.setType(outRequest.getType());
        outSonInfo.setRegionId(outRegionId);
        outSonInfo.setHasSon(Integer.valueOf(0));
        outSonInfo.setEnterTime(outRequest.getEnterTime());
        outSonInfo.setPlateNum2(StringUtils.substring((String)plateNum, (int)1));
        outSonInfo.setCarType(outRequest.getCarType());
        outSonInfo.setServiceStatus(Integer.valueOf(2));
        outSonInfo.setOperAccount(userName);
        outOrderSonInfos.add(outSonInfo);
        outOrderSonCarInfos.add(this.createOrderSonCarInfo(orderInfo, outRequest, userName));
        OrderSonInfo inSonInfo = new OrderSonInfo();
        inSonInfo.setOrderNum(orderInfo.getOrderNum());
        inSonInfo.setParkId(orderInfo.getParkId());
        inSonInfo.setPlateNum(plateNum);
        inSonInfo.setType(inRequest.getType());
        inSonInfo.setRegionId(inRegionId);
        inSonInfo.setHasSon(Integer.valueOf(0));
        inSonInfo.setEnterTime(inRequest.getEnterTime());
        inSonInfo.setPlateNum2(StringUtils.substring((String)plateNum, (int)1));
        inSonInfo.setCarType(inRequest.getCarType());
        inSonInfo.setServiceStatus(Integer.valueOf(1));
        inSonInfo.setOperAccount(userName);
        innerOrderSonInfos.add(inSonInfo);
        innerOrderSonCarInfos.add(this.createOrderSonCarInfo(orderInfo, inRequest, userName));
        tracks.add(new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(orderInfo.getParkId()).setRegionId(inRequest.getRegionId()).setOrderNum(orderInfo.getOrderNum()).setPlateNum(orderInfo.getPlateNum()).setEnexTime(inRequest.getEnterTime()).setType(inRequest.getType()).setInoutEvent(Integer.valueOf(4)).setExTerminal(Integer.valueOf(6)));
        tracks.add(new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(orderInfo.getParkId()).setRegionId(outRequest.getRegionId()).setOrderNum(orderInfo.getOrderNum()).setPlateNum(orderInfo.getPlateNum()).setEnexTime(outRequest.getEnterTime()).setType(outRequest.getType()).setInoutEvent(Integer.valueOf(4)).setExTerminal(Integer.valueOf(6)));
    }

    public void processSingleRequest(Long parkId, String userName, Long outRegionId, Long inRegionId, List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, OrderAddRequest request) {
        OrderInfo orderInfo = this.createOrderInfo(parkId, userName, request.getRegionId(), request.getPlateNum(), request);
        orderInfos.add(orderInfo);
        orderCarInfos.add(this.createOrderCarInfo(orderInfo, request, userName));
        if (!outRegionId.equals(request.getRegionId())) {
            orderInfo.setHasSon(Integer.valueOf(1));
            outOrderSonInfos.add(this.createOrderSonInfo(orderInfo, outRegionId, true, null));
            outOrderSonCarInfos.add(this.createOrderSonCarInfo(orderInfo, request, userName));
            innerOrderSonInfos.add(this.createOrderSonInfo(orderInfo, inRegionId, false, null));
            innerOrderSonCarInfos.add(this.createOrderSonCarInfo(orderInfo, request, userName));
        }
        tracks.add(this.createOrderTrack(orderInfo));
    }

    private OrderInfo createOrderInfo(Long parkId, String userName, Long regionId, String plateNum, OrderAddRequest request) {
        return OrderInfo.builder().orderNum(this.idGenerator.nextIdAsString()).parkId(parkId).plateNum(plateNum).plateNum2(StringUtils.substring((String)plateNum, (int)1)).type(request.getType()).carType(request.getCarType()).hasSon(Integer.valueOf(0)).enterTime(request.getEnterTime()).serviceStatus(Integer.valueOf(1)).regionId(regionId).operAccount(userName).build();
    }

    private OrderCarInfo createOrderCarInfo(OrderInfo orderInfo, OrderAddRequest request, String userName) {
        OrderCarInfo carInfo = new OrderCarInfo();
        carInfo.setOrderNum(orderInfo.getOrderNum());
        carInfo.setPlateColor(request.getPlateColor());
        carInfo.setEnterWay(Integer.valueOf(4));
        carInfo.setEnterTerminal(Integer.valueOf(6));
        carInfo.setEnterOperAccount(userName);
        return carInfo;
    }

    private OrderSonInfo createOrderSonInfo(OrderInfo orderInfo, Long regionId, boolean isOuterRegion, Long enterTime) {
        OrderSonInfo sonInfo = new OrderSonInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)sonInfo);
        if (Objects.nonNull(enterTime)) {
            sonInfo.setEnterTime(enterTime);
        }
        sonInfo.setRegionId(regionId);
        if (isOuterRegion) {
            sonInfo.setNoneEnterFlag(Integer.valueOf(1));
            sonInfo.setServiceStatus(Integer.valueOf(2));
        }
        return sonInfo;
    }

    private OrderSonCarInfo createOrderSonCarInfo(OrderInfo orderInfo, OrderAddRequest request, String userName) {
        OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
        sonCarInfo.setOrderNum(orderInfo.getOrderNum());
        sonCarInfo.setPlateColor(request.getPlateColor());
        sonCarInfo.setEnterWay(Integer.valueOf(4));
        sonCarInfo.setEnterTerminal(Integer.valueOf(6));
        sonCarInfo.setEnterOperAccount(userName);
        return sonCarInfo;
    }

    private OrderTrack createOrderTrack(OrderInfo orderInfo) {
        return new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(orderInfo.getParkId()).setRegionId(orderInfo.getRegionId()).setOrderNum(orderInfo.getOrderNum()).setPlateNum(orderInfo.getPlateNum()).setEnexTime(orderInfo.getEnterTime()).setType(orderInfo.getType()).setInoutEvent(Integer.valueOf(4)).setExTerminal(Integer.valueOf(6));
    }

    public void saveAll(List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, Long parkId, List<ParkRegion> parkRegions) {
        this.saveBatch(orderInfos);
        this.orderCarInfoService.saveBatch(orderCarInfos);
        if (this.orderSonInfoService.saveBatch(outOrderSonInfos)) {
            this.saveOrderSonCarInfos(outOrderSonInfos, outOrderSonCarInfos);
        }
        if (this.orderSonInfoService.saveBatch(innerOrderSonInfos)) {
            this.saveOrderSonCarInfos(innerOrderSonInfos, innerOrderSonCarInfos);
        }
        this.updateRegionFreeSpaceService.resetFreeSpace(parkId);
        if (CollectionUtils.isNotEmpty(tracks)) {
            this.orderTrackService.saveBatch(tracks);
        }
    }

    public void saveOrderSonCarInfos(List<OrderSonInfo> orderSonInfos, List<OrderSonCarInfo> orderSonCarInfos) {
        Map<String, Long> orderSonInfoMap = orderSonInfos.stream().collect(Collectors.toMap(OrderInfo::getOrderNum, OrderInfo::getId, (a, b) -> a));
        List collect = orderSonCarInfos.stream().peek(outOrderSonInfo -> {
            Long orderSonId = (Long)orderSonInfoMap.get(outOrderSonInfo.getOrderNum());
            if (Objects.nonNull(orderSonId)) {
                outOrderSonInfo.setOrderSonId(orderSonId);
            }
        }).collect(Collectors.toList());
        this.orderSonCarInfoDao.batchSave(collect);
    }

    public OrderInfo getByLocalOrderNumWithHistory(Long parkId, String localOrderNum) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(localOrderNum);
        orderInfo.setParkId(parkId);
        OrderInfo existsOrder = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (existsOrder != null) {
            return existsOrder;
        }
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-90);
        List yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
        return this.orderInfoDao.selectByLocalOrderNumWithHistory(parkId, yearQuarterRangeTableName, localOrderNum);
    }

    public Integer getChargeLiveCount(Long parkId) {
        return this.orderInfoDao.selectChargeLiveCount(parkId);
    }

    public Integer getOilLiveCount(Long parkId) {
        return this.orderInfoDao.selectOilLiveCount(parkId);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getMpOrderDetail", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse getMpOrderDetail(Integer type, Long id) {
        if (type == 1) {
            ObjectResponse orderPayDto = this.orderPayService.getOrderPayDetail(null, Integer.valueOf(Math.toIntExact(id)), null);
            return orderPayDto;
        }
        MonthOrderDto monthOrderDto = this.monthOrderDao.getMonthOrderDetail(id);
        if (Objects.isNull(monthOrderDto)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthOrderDto);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.countEnterCar", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Integer> countEnterCar(Long parkId) {
        Integer count = this.orderInfoDao.countEnterCar(parkId);
        return ObjectResponse.success((Object)count);
    }

    public ObjectResponse<OrderInfo> fuzzyOutPlate(Long parkId, String plateNum) {
        String plateNumPart = plateNum.substring(1);
        OrderInfo orderInfo = this.orderInfoDao.fuzzyOutParkPlate(parkId, plateNumPart);
        if (orderInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)orderInfo);
    }

    public ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum) {
        PlateTypeDto plateTypeDto = new PlateTypeDto();
        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u4e34\u65f6\u8f66);
        Boolean isMonthCard = this.monthCarService.judgeMonthCar(parkId, plateNum);
        return this.getPlateTypeDto(parkId, plateNum, plateTypeDto, isMonthCard, null);
    }

    public ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum, Long regionId) {
        PlateTypeDto plateTypeDto = new PlateTypeDto();
        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u4e34\u65f6\u8f66);
        Boolean isMonthCard = this.monthCarService.judgeMonthCar(parkId, plateNum, regionId);
        return this.getPlateTypeDto(parkId, plateNum, plateTypeDto, isMonthCard, regionId);
    }

    private ObjectResponse<PlateTypeDto> getPlateTypeDto(Long parkId, String plateNum, PlateTypeDto plateTypeDto, Boolean isMonthCard, Long regionId) {
        Integer freeOfficialCars;
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess((Response)configObjectResponse) && NumberUtils.toPrimitive((Integer)(freeOfficialCars = ((ParkConfig)configObjectResponse.getData()).getFreeOfficialCars())) == 1 && PlateTypeDto.officialCar((String)plateNum)) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u7279\u6b8a\u8f66\u8f86);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        if (isMonthCard.booleanValue()) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u6708\u5361\u8f66);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        VehiclePlate vehiclePlate = this.vehiclePlateDao.selectVip(parkId, plateNum);
        if (vehiclePlate != null) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.VIP\u8f66\u8f86);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        ObjectResponse validVipCar = this.vipCarService.getValidVipCar(parkId, plateNum, regionId);
        if (ObjectResponse.isSuccess((Response)validVipCar)) {
            VipType vipType = (VipType)validVipCar.getData();
            plateTypeDto.setCarDesc(vipType.getName());
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.VIP\u8f66\u8f86);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        ObjectResponse visitCar = this.parkVisitService.checkVisitPlate(parkId, plateNum);
        if (ObjectResponse.isSuccess((Response)visitCar)) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        ObjectResponse validStoreCards = this.storeCardService.getValidStoreCards(plateNum, parkId);
        if (ObjectResponse.isSuccess((Response)validStoreCards)) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u50a8\u503c\u5361\u8f66);
            return ObjectResponse.success((Object)plateTypeDto);
        }
        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.\u4e34\u65f6\u8f66);
        return ObjectResponse.success((Object)plateTypeDto);
    }

    private OrderInfo fuzzyPlateNum(Long parkId, String plateNum, int plot) {
        List plates = FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)plot);
        return this.orderInfoDao.fuzzyInParkPlate(parkId, plates);
    }

    private OrderInfo fuzzyPlateNum(long parkId, String plateNum, int status, int plot) {
        String plate;
        List plates = FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)plot);
        OrderInfo orderInfo = null;
        Iterator iterator = plates.iterator();
        while (iterator.hasNext() && (orderInfo = this.orderInfoDao.fuzzyOrderByPlate(parkId, plate = (String)iterator.next(), status)) == null) {
        }
        return orderInfo;
    }

    private List<String> getFuzzyPlateNums(int vagueType, String plateNum) {
        if (vagueType == 0) {
            String plateNumPart = plateNum.substring(1);
            return Collections.singletonList("_" + plateNumPart);
        }
        if (vagueType == 1) {
            return FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)1);
        }
        if (vagueType == 2) {
            List plates1 = FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)1);
            List plates2 = FuzzyPlateTools.fuzzyCharacter((String)plateNum, (int)2);
            plates1.addAll(plates2);
            return plates1;
        }
        return null;
    }

    private SearchCarResponse getSearchCarResponse(String parkCode, String plateNum, OrderInfo orderInfo1) {
        SearchCarResponse searchCarResponse = new SearchCarResponse();
        searchCarResponse.setOrderNum(orderInfo1.getOrderNum());
        searchCarResponse.setCarType(orderInfo1.getType());
        searchCarResponse.setEnterTime(DateTools.secondTostring((int)orderInfo1.getEnterTime().intValue()));
        searchCarResponse.setPlateNum(orderInfo1.getPlateNum());
        if (MONTH_CARD.equals(orderInfo1.getType())) {
            searchCarResponse.setPayStatus(NO_NEED_PAY);
        } else {
            QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
            queryOrderFeeRequest.setParkCode(parkCode);
            queryOrderFeeRequest.setPlateNum(plateNum);
            ObjectResponse objectResponse = this.queryOrderFeeService.queryOrderFee(queryOrderFeeRequest);
            if ("12002".equals(objectResponse.getCode())) {
                String messageId = objectResponse.getMsg();
                objectResponse = (ObjectResponse)AsyncNotifyInterface.wait((String)messageId, (Long)4000L, () -> {
                    ObjectResponse response = (ObjectResponse)this.redisUtils.get(AsyncNotifyInterface.getMessageKey((String)messageId), (TypeReference)new TypeReference<ObjectResponse<QueryOrderFeeResponse>>(){});
                    if (response != null) {
                        if (ObjectResponse.isSuccess((Response)response)) {
                            QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)JsonUtils.parseObject((String)JsonUtils.toString((Object)response.getData()), QueryOrderFeeResponse.class, (Class[])new Class[0]);
                            return ObjectResponse.success((Object)queryOrderFeeResponse);
                        }
                        return response;
                    }
                    this.alarmService.queryFeeFailHandler(parkCode, orderInfo1.getParkId(), queryOrderFeeRequest.getChannelId());
                    return ObjectResponse.failed((String)"3001");
                });
            }
            if (ObjectResponse.isSuccess(objectResponse)) {
                QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)objectResponse.getData();
                Integer status = queryOrderFeeResponse.getStatus();
                searchCarResponse.setPayStatus(status);
            } else {
                searchCarResponse.setPayStatus(NO_NEED_PAY);
            }
        }
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo1.getOrderNum());
        if (StringUtils.isNotBlank((CharSequence)carInfo.getEnterImage())) {
            searchCarResponse.setEnterImage(this.ossService.getImageUrl(carInfo.getEnterImage()));
        }
        return searchCarResponse;
    }

    private List<OrderInfo> getOrderInfos(PageQuery<SearchCarRequest> pageQuery, String plateNum, Long parkId) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setPlateNum(plateNum);
        orderInfo.setParkId(parkId);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)pageQuery.getCurrent(), (long)pageQuery.getSize());
        return ((com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.orderInfoDao.selectPage((IPage)page, (Wrapper)Wrappers.query((Object)orderInfo))).getRecords();
    }

    public ObjectResponse addMadePlate(MadePlate madePlate) {
        int insertResult = this.madePlateDao.insert(madePlate);
        if (insertResult <= 0) {
            this.updateMadePlate(madePlate);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<MadePlate> findMadePlateByOrderNum(String orderNum) {
        MadePlate madePlate = this.madePlateDao.selectByOrderNum(orderNum);
        return ObjectResponse.success((Object)madePlate);
    }

    public ObjectResponse updateMadePlate(MadePlate madePlate) {
        this.madePlateDao.update(madePlate);
        return ObjectResponse.success();
    }

    public ObjectResponse addOrderModifyReocrd(OrderModifyRecord orderModifyRecord) {
        this.orderModifyRecordDao.insert((Object)orderModifyRecord);
        return ObjectResponse.success();
    }

    public ObjectResponse checkSecRecognition(String orderNum, String newPlateNum, int newReliability, int newCarType) {
        OrderCarInfo orderCarInfo;
        OrderInfo orderInfo;
        if (StringUtils.isEmpty((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"400");
        }
        MadePlate madePlate = new MadePlate();
        madePlate.setOrderNum(orderNum);
        madePlate.setPlateReliability(Integer.valueOf(newReliability));
        if (newReliability < this.reliabilityThreshold) {
            orderInfo = this.orderInfoDao.selectByOrderNum(orderNum);
            if (orderInfo == null) {
                return ObjectResponse.failed((String)"404", (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderNum);
            if (orderCarInfo == null) {
                return ObjectResponse.failed((String)"404", (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        } else {
            ObjectResponse objectResponse = this.modifyCar(orderNum, newPlateNum, newCarType);
            return objectResponse;
        }
        madePlate.setParkId(orderInfo.getParkId());
        madePlate.setEnterTime(orderInfo.getEnterTime());
        madePlate.setOrderNum(orderNum);
        madePlate.setPlateNum(orderInfo.getPlateNum());
        madePlate.setImage(orderCarInfo.getEnterImage());
        madePlate.setCreateTime(DateTools.getFormat((Date)new Date()));
        madePlate.setStatus(Integer.valueOf(0));
        this.addMadePlate(madePlate);
        return ObjectResponse.success();
    }

    public ObjectResponse<StoreCard> chargeStoreCardComplete(QueryOrderFeeResponse queryOrderFeeResponse, String orderNum, Long parkId, String channelCode) {
        ObjectResponse objectResponse = this.storeCardService.chargeStoreCard(queryOrderFeeResponse, parkId);
        if (null != objectResponse && "200".equals(objectResponse.getCode())) {
            StoreCard storeCard = (StoreCard)objectResponse.getData();
            OrderPay orderPay = new OrderPay();
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(Integer.valueOf(2));
            orderPay.setParkId(parkId);
            orderPay.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
            orderPay.setCardNum(storeCard.getCardsNum());
            orderPay.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            orderPay.setPaidPrice("0");
            orderPay.setOrderTime(queryOrderFeeResponse.getQueryTime());
            orderPay.setPayTime(queryOrderFeeResponse.getQueryTime());
            orderPay.setTotalPrice(NumberUtils.decimalAdd((Object)queryOrderFeeResponse.getUnpayPrice(), (Object[])new Object[]{queryOrderFeeResponse.getDiscountPrice()}).toString());
            orderPay.setTradeNo(CodeTools.GenerateTradeNo());
            orderPay.setIsSync(Integer.valueOf(0));
            orderPay.setChannelId(channelCode);
            this.orderPayService.addOrderPay(orderPay);
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            ObjectResponse<OrderInfo> orderInfoObjectResponse = this.findByOrderInfo(orderInfo);
            orderInfo.setPaidPrice("0");
            orderInfo.setExitTime(queryOrderFeeResponse.getQueryTime());
            orderInfo.setCarType(queryOrderFeeResponse.getCarType());
            orderInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
            if (orderInfoObjectResponse.getData() != null && ((OrderInfo)orderInfoObjectResponse.getData()).getBalancePrice() != null) {
                orderInfo.setBalancePrice(((OrderInfo)orderInfoObjectResponse.getData()).getBalancePrice().add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice())));
            } else {
                orderInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            }
            orderInfo.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
            if ("200".equals(orderInfoObjectResponse.getCode())) {
                this.orderInfoDao.updateByOrderNum(orderInfo);
            } else {
                orderInfo.setParkId(parkId);
                orderInfo.setPlateNum(queryOrderFeeResponse.getPlateNum());
                orderInfo.setEnterTime(queryOrderFeeResponse.getEnterTime());
                orderInfo.setServiceStatus(Integer.valueOf(1));
                try {
                    this.addOrderInfo(orderInfo);
                }
                catch (DuplicateKeyException e) {
                    orderNum = CodeTools.GenerateOrderNum();
                    orderInfo.setOrderNum(orderNum);
                    this.addOrderInfo(orderInfo);
                }
            }
        }
        return objectResponse;
    }

    public ObjectResponse<OrderModifyRecord> selectModifyRecordById(Long id) {
        OrderModifyRecord orderModifyRecord = this.orderModifyRecordDao.selectOneById(id);
        if (orderModifyRecord == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)orderModifyRecord);
    }

    @Transactional
    @SentinelResource(value="OrderService.batchExitOrder", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse batchExitOrder(List<String> orderNums, Integer oddStatus, String username) {
        List list2;
        List orderSonInfos;
        if (CollectionUtil.isEmpty(orderNums)) {
            return ObjectResponse.failed((String)"400", (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderInfos = this.orderInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getOrderNum, orderNums)).orderByAsc(OrderInfo::getId));
        if (CollectionUtils.isEmpty((Collection)orderInfos)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        HashSet<Long> orderParkSet = new HashSet<Long>(orderInfos.size());
        ArrayList<OrderPay> feeParams = new ArrayList<OrderPay>(orderInfos.size());
        for (OrderInfo orderInfo : orderInfos) {
            OrderPay pay = new OrderPay();
            pay.setParkId(orderInfo.getParkId());
            pay.setOrderNum(orderInfo.getOrderNum());
            feeParams.add(pay);
            orderParkSet.add(orderInfo.getParkId());
        }
        List orderSumFeeDtos = this.orderPayDao.sumFees(feeParams);
        Map feeMap = orderSumFeeDtos.stream().collect(Collectors.toMap(OrderSumFeeDto::getOrderNum, Function.identity(), (older, newer) -> newer));
        ObjectResponse configResp = this.parkService.getParkConfigs(orderParkSet);
        Map configMap = ObjectResponse.isSuccess((Response)configResp) ? (Map)configResp.getData() : Collections.emptyMap();
        HashMap<String, Integer> addSpaceParkMap = new HashMap<String, Integer>(orderParkSet.size());
        HashSet<Long> syncSpaceParkSet = new HashSet<Long>(orderParkSet.size());
        ArrayList<OrderInfo> updateOrders = new ArrayList<OrderInfo>(orderInfos.size());
        List updateSonOrders = orderInfos.stream().filter(Objects::nonNull).filter(od -> Integer.valueOf(1).equals(od.getHasSon())).map(OrderInfo::getOrderNum).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> sonOrderMap = new HashMap(orderInfos.size());
        if (CollectionUtils.isNotEmpty(updateSonOrders) && CollectionUtils.isNotEmpty((Collection)(orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).in(OrderInfo::getOrderNum, updateSonOrders)).in(OrderInfo::getServiceStatus, new Object[]{1}))))) {
            sonOrderMap = orderSonInfos.stream().collect(Collectors.groupingBy(OrderInfo::getOrderNum, Collectors.collectingAndThen(Collectors.toList(), list -> (OrderSonInfo)list.get(0))));
        }
        HashMap<Long, List> downOrderNumMap = new HashMap<Long, List>(configMap.size());
        for (OrderInfo orderInfo : orderInfos) {
            OrderSumFeeDto orderSumFeeDto;
            OrderInfo update = new OrderInfo();
            update.setId(orderInfo.getId());
            update.setServiceStatus(Integer.valueOf(4));
            update.setExitTime(Long.valueOf(DateUtil.currentSeconds()));
            update.setOddStatus(Objects.isNull(oddStatus) ? OrderOddStatusEnum.\u624b\u52a8\u51fa\u573a.getVal() : oddStatus);
            update.setOperAccount(username);
            if (Objects.nonNull(oddStatus) && OrderOddStatusEnum.\u8f66\u8f86\u76d8\u70b9.getVal().equals(oddStatus)) {
                update.setServiceStatus(Integer.valueOf(3));
                update.setOddStatus(null);
            }
            if ((orderSumFeeDto = (OrderSumFeeDto)feeMap.get(orderInfo.getOrderNum())) == null) {
                update.setPaidPrice("0.00");
                update.setDiscountPrice("0.00");
                update.setTotalPrice("0.00");
            } else {
                update.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                update.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                update.setTotalPrice("0.00");
            }
            updateOrders.add(update);
            ParkConfig config = (ParkConfig)configMap.get(orderInfo.getParkId());
            if (config == null) continue;
            if (!(config.getDelOrderCalcSpaceFlag(Integer.valueOf(0)) != 1 || PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(orderInfo.getType()) && NumberUtils.toPrimitive((Integer)config.getIsCardcount()) != 1)) {
                if (config.getCalcSpaceMethod(Integer.valueOf(1)) == 1) {
                    OrderSonInfo orderSonInfo = (OrderSonInfo)sonOrderMap.get(orderInfo.getOrderNum());
                    Long regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
                    int count = addSpaceParkMap.computeIfAbsent(orderInfo.getParkId() + "," + regionId, key -> 0);
                    addSpaceParkMap.put(orderInfo.getParkId() + "," + regionId, count + 1);
                } else {
                    syncSpaceParkSet.add(orderInfo.getParkId());
                }
            }
            if (!DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(config.getDataCollection())) continue;
            List downOrderNums = downOrderNumMap.computeIfAbsent(orderInfo.getParkId(), key -> new ArrayList());
            downOrderNums.add(orderInfo.getLocalOrderNum());
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            this.updateBatchById(updateOrders);
        }
        if (!CollectionUtils.isEmpty(updateSonOrders)) {
            int serviceStatus = 4;
            if (OrderOddStatusEnum.\u8f66\u8f86\u76d8\u70b9.getVal().equals(oddStatus)) {
                serviceStatus = 3;
            }
            this.orderSonInfoService.updateServiceStatusByOrderNums(updateSonOrders, Integer.valueOf(serviceStatus));
        }
        if (oddStatus == null || OrderOddStatusEnum.\u624b\u52a8\u51fa\u573a.getVal().equals(oddStatus)) {
            Iterator orderCarInfoList = new ArrayList();
            List orderCarInfos = this.orderCarInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderCarInfo.class).in(OrderCarInfo::getOrderNum, orderNums)).orderByAsc(OrderCarInfo::getId));
            orderCarInfos.forEach(orderCarInfo -> {
                OrderCarInfo orderCarInfoUpdate = new OrderCarInfo();
                orderCarInfoUpdate.setId(orderCarInfo.getId());
                orderCarInfoUpdate.setExitWay(Integer.valueOf(4));
                orderCarInfoUpdate.setExitOperAccount(username);
                orderCarInfoList.add(orderCarInfoUpdate);
            });
            if (!CollectionUtils.isEmpty((Collection)orderCarInfos)) {
                this.orderCarInfoService.updateBatchById(orderCarInfoList);
            }
        }
        if (Objects.isNull(oddStatus)) {
            if (!addSpaceParkMap.isEmpty()) {
                addSpaceParkMap.forEach((parkIdRegionId, v) -> {
                    String[] parkIdRegionIdArr = parkIdRegionId.split(",");
                    Long parkId = Long.valueOf(parkIdRegionIdArr[0]);
                    Long regionId = StrUtil.isBlankOrUndefined((CharSequence)parkIdRegionIdArr[1]) ? null : Long.valueOf(parkIdRegionIdArr[1]);
                    UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                    updateFreeSpaceService.addFreeSpace(parkId, regionId, v.intValue());
                });
            }
            if (!syncSpaceParkSet.isEmpty()) {
                syncSpaceParkSet.stream().distinct().forEach(parkId -> {
                    UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                    updateFreeSpaceService.resetFreeSpace(parkId);
                });
            }
        } else if (OrderOddStatusEnum.\u8f66\u8f86\u76d8\u70b9.getVal().equals(oddStatus)) {
            orderInfos.stream().map(OrderInfo::getParkId).filter(Objects::nonNull).findFirst().ifPresent(parkId -> {
                UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                updateFreeSpaceService.resetFreeSpace(parkId);
            });
        }
        if (!downOrderNumMap.isEmpty()) {
            if (Objects.nonNull(oddStatus) && OrderOddStatusEnum.\u8f66\u8f86\u76d8\u70b9.getVal().equals(oddStatus)) {
                for (Map.Entry downEntry : downOrderNumMap.entrySet()) {
                    this.batchSetExitService.batchSend((Long)downEntry.getKey(), (List)downEntry.getValue(), 1);
                }
            } else {
                for (Map.Entry downEntry : downOrderNumMap.entrySet()) {
                    this.batchSetExitService.batchSend((Long)downEntry.getKey(), (List)downEntry.getValue(), 0);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(list2 = this.orderDiscountService.findDiscountByOrderNum(orderNums, Integer.valueOf(0))))) {
            for (OrderDiscount orderDiscount : list2) {
                this.parkMerchantService.releasePlace(orderDiscount);
            }
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Integer> findTheMaxIdByDate(Long parkId, String startTime, String endTime) {
        Integer orderId = this.orderInfoDao.findTheMaxIdByDate(parkId, startTime, endTime);
        return ObjectUtils.isEmpty((Object)orderId) ? ObjectResponse.failed((String)"404") : ObjectResponse.success();
    }

    public List<OrderInfo> selectListByOrderNums(Collection<String> orderNumList) {
        return this.orderInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getOrderNum, orderNumList)).orderByAsc(OrderInfo::getId));
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderInfo>> getOrderInfoList(Long parkId, BaseQueryRequest request, Integer orderType) {
        return this.getOrderInfoList(parkId, null, request, orderType);
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderInfo>> getOrderInfoList(Long parkId, String plateNum, BaseQueryRequest request, Integer orderType) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page orderInfoPage = orderType == 1 ? this.orderInfoDao.selectPage((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(plateNum != null, OrderInfo::getPlateNum, (Object)plateNum)).in(OrderInfo::getServiceStatus, new Object[]{1})).gt(OrderInfo::getEnterTime, (Object)(request.getStartTime().getTime() / 1000L))).lt(OrderInfo::getEnterTime, (Object)(request.getEndTime().getTime() / 1000L))).orderByDesc(OrderInfo::getEnterTime), (long)request.getPageNo().intValue(), (long)request.getPageSize().intValue()) : this.orderInfoDao.selectPage((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(plateNum != null, OrderInfo::getPlateNum, (Object)plateNum)).in(OrderInfo::getServiceStatus, new Object[]{2, 4})).gt(OrderInfo::getExitTime, (Object)(request.getStartTime().getTime() / 1000L))).lt(OrderInfo::getExitTime, (Object)(request.getEndTime().getTime() / 1000L))).orderByDesc(OrderInfo::getExitTime), (long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)Math.toIntExact(orderInfoPage.getPages()), (long)orderInfoPage.getTotal(), (List)orderInfoPage.getRecords()));
    }

    @DS_SLAVE
    public ObjectResponse<OrderInfo> getOneOrderInfo(Long parkId, String plateNum) {
        OrderInfo orderInfo = (OrderInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getPlateNum, (Object)plateNum)).orderByDesc(OrderInfo::getEnterTime));
        if (orderInfo == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)orderInfo);
    }

    @DS_SLAVE
    public com.icetech.common.domain.Page<OrderInfo> getOrderPageBy(Long parkId, String plateNum, Integer pageNo, Integer pageSize) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        IPage result = this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getServiceStatus, (Object)1)).likeRight(OrderInfo::getPlateNum, (Object)plateNum));
        return com.icetech.common.domain.Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords());
    }

    @DS_SLAVE
    @SentinelResource(value="OrderService.getEnterCars", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderInfo>> getEnterCars(Long parkId, List<String> plateNums) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(OrderInfo.class);
        queryWrapper.eq(OrderInfo::getParkId, (Object)parkId);
        queryWrapper.eq(OrderInfo::getServiceStatus, (Object)1);
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.like(OrderInfo::getPlateNum, plateNums.get(0))).or()).like(OrderInfo::getPlateNum, plateNums.get(1))).or()).like(OrderInfo::getPlateNum, plateNums.get(2));
        });
        queryWrapper.orderByDesc(OrderInfo::getId);
        queryWrapper.last(" limit 30");
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)list);
    }

    @DS_SLAVE
    public ObjectResponse<Integer> getCountBy(Long parkId, String createTime) {
        return ObjectResponse.success((Object)this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).gt(OrderInfo::getCreateTime, (Object)createTime)));
    }

    @DS_SLAVE
    public ObjectResponse<Integer> getSurplusCount(Long parkId, String createTime) {
        return ObjectResponse.success((Object)this.orderInfoDao.selectSurplusCount(parkId, createTime));
    }

    @DS_SLAVE
    public ObjectResponse<List<OrderVO>> getSurplusList(Long parkId, String createTime) {
        List orders = this.orderInfoDao.selectSurplusList(parkId, createTime);
        return CollectionUtils.isEmpty((Collection)orders) ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)orders);
    }

    @DS_SLAVE
    public ObjectResponse<Integer> getLiveCountBy(Long parkId, String crateTime) {
        return ObjectResponse.success((Object)this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getParkId, (Object)parkId)).lt(OrderInfo::getCreateTime, (Object)crateTime)));
    }

    @DS_SLAVE
    public ObjectResponse<InParkNumInfoResponse> getInParkNum(Long parkId) {
        InParkNumInfoResponse inParkNumInfoResponse = new InParkNumInfoResponse();
        Integer inParkNum = this.orderInfoDao.countEnterCar(parkId);
        FlowRequest flowRequest = new FlowRequest();
        flowRequest.setParkIdList(parkId.toString());
        flowRequest.setStartTime(Long.valueOf(DateUtil.beginOfDay((Date)DateUtil.date()).getTime() / 1000L));
        long totalParkNum = this.orderInfoDao.enterInparkCount(flowRequest);
        ObjectResponse spaceByPark = this.parkFreeSpaceService.getSpaceByPark(parkId.longValue());
        ParkFreespace data = (ParkFreespace)spaceByPark.getData();
        Integer freeSpace = data == null ? 0 : data.getFreeSpace();
        inParkNumInfoResponse.setParkSpaceNum(freeSpace);
        inParkNumInfoResponse.setInParkNum(inParkNum);
        inParkNumInfoResponse.setTotalParkNum(Integer.valueOf(Math.toIntExact(totalParkNum)));
        return ObjectResponse.success((Object)inParkNumInfoResponse);
    }

    public ObjectResponse<OrderAfterPay> getOrderAfterPayByTradeNo(String tradeNo, Integer status) {
        OrderAfterPay orderAfterPay = this.orderAfterPayDao.selectOrderAfterPayByTradeNo(tradeNo, status);
        return orderAfterPay == null ? ObjectResponse.failed((String)"404") : ObjectResponse.success((Object)orderAfterPay);
    }

    public ObjectResponse<Integer> getExitCarNums(Long startTime, Long endTime) {
        return ObjectResponse.success((Object)this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).ge(OrderInfo::getExitTime, (Object)startTime)).lt(OrderInfo::getExitTime, (Object)endTime)));
    }

    public ObjectResponse<List<OrderInfo>> selectExitOrderBy(Long parkId, Long startTime, Long endTime) {
        List orderInfos = this.orderInfoDao.selectExitOrderBy(parkId, startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)orderInfos)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)orderInfos);
    }

    public ObjectResponse<Boolean> updateOrderType(List<String> orderNums, Integer type) {
        return ObjectResponse.success((Object)this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderInfo.class).set(OrderInfo::getType, (Object)type)).in(OrderInfo::getOrderNum, orderNums)));
    }

    public List<String> getLiveCarPlateNums(Long parkId, Integer limitNum) {
        List plateNums = this.orderInfoDao.selectLivePlateNum(parkId, limitNum);
        if (CollectionUtils.isEmpty((Collection)plateNums)) {
            return Collections.emptyList();
        }
        return plateNums.stream().filter(plateNum -> plateNum != null && !"\u672a\u8bc6\u522b".equals(plateNum)).collect(Collectors.toList());
    }

    public ObjectResponse<Object> orderExit(OrderStatusParam statusParam) {
        OrderInfo info = this.orderInfoDao.selectByOrderNum(statusParam.getOrderNum());
        if (info == null) {
            return ObjectResponse.failed((String)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (info.getServiceStatus() != 1) {
            return ObjectResponse.failed((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5728\u573a\u72b6\u6001\uff0c\u79bb\u573a\u5931\u8d25\uff01");
        }
        BigDecimal paidPrice = BigDecimal.ZERO;
        BigDecimal totalPrice = BigDecimal.ZERO;
        List pays = this.orderPayDao.selectByOrderNum(statusParam.getOrderNum());
        if (CollectionUtils.isNotEmpty((Collection)pays)) {
            totalPrice = pays.stream().map(pay -> this.strToBig(pay.getTotalPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            paidPrice = pays.stream().map(pay -> this.strToBig(pay.getPaidPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        info.setServiceStatus(Integer.valueOf(2));
        info.setExitTime(Long.valueOf(statusParam.getExitTime().getTime() / 1000L));
        info.setErrorCauses(statusParam.getErrorCauses());
        info.setPaidPrice(paidPrice.toString());
        info.setDiscountPrice("0.00");
        info.setTotalPrice(totalPrice.toString());
        long newVal = statusParam.getExitTime().getTime() / 1000L;
        this.orderInfoDao.updateByOrderNum(info);
        OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(statusParam.getOrderNum());
        carInfo.setExitWay(Integer.valueOf(4));
        carInfo.setExitOperAccount(statusParam.getUserName());
        this.orderCarInfoDao.updateByOrderNum(carInfo);
        OrderModifyRecord record = new OrderModifyRecord();
        record.setAction(Integer.valueOf(1));
        record.setCorrectType(Integer.valueOf(6));
        record.setOrderNum(info.getOrderNum());
        record.setParkId(info.getParkId());
        record.setBeforeModify(null);
        record.setAfterModify(String.valueOf(newVal));
        record.setAfterCardesc(statusParam.getErrorCauses());
        record.setModifyTime(DateTools.getFormat((Date)new Date()));
        record.setOperAccount(statusParam.getUserName());
        record.setCreateTime(DateTools.getFormat((Date)new Date()));
        this.orderModifyRecordDao.insert((Object)record);
        ParkConfig config = (ParkConfig)this.parkService.getParkConfig(info.getParkId()).getData();
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(config.getDataCollection())) {
            SendRequest request = new SendRequest();
            request.setParkId(info.getParkId());
            request.setServiceId(record.getId());
            this.modifyCarService.send(request);
            this.batchSetExitService.batchSend(info.getParkId(), Collections.singletonList(info.getLocalOrderNum()), 1);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Object> modifyEnter(OrderStatusParam statusParam) {
        OrderModifyRecord record2;
        OrderInfo info = this.orderInfoDao.selectByOrderNum(statusParam.getOrderNum());
        if (info == null) {
            return ObjectResponse.failed((String)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (info.getServiceStatus() != 1) {
            return ObjectResponse.failed((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5728\u573a\u72b6\u6001\uff0c\u4fee\u6539\u5931\u8d25\uff01");
        }
        long oldEnterTime = info.getEnterTime();
        long newEnterTime = statusParam.getEnterTime().getTime() / 1000L;
        String oldPlateNum = info.getPlateNum();
        String newPlateNUm = statusParam.getPlateNum();
        int oldCarType = info.getCarType();
        int newCarType = statusParam.getCarType();
        ParkConfig config = (ParkConfig)this.parkService.getParkConfig(info.getParkId()).getData();
        info.setEnterTime(Long.valueOf(newEnterTime));
        info.setPlateNum(newPlateNUm);
        info.setCarType(Integer.valueOf(newCarType));
        info.setOperAccount(statusParam.getUserName());
        this.orderInfoDao.updateByOrderNum(info);
        ArrayList<OrderModifyRecord> records = new ArrayList<OrderModifyRecord>();
        if (oldEnterTime != newEnterTime) {
            record2 = this.saveOrderRecord(info, String.valueOf(oldEnterTime), String.valueOf(newEnterTime), 5, statusParam.getUserName());
            records.add(record2);
        }
        if (!oldPlateNum.equals(newPlateNUm)) {
            record2 = this.saveOrderRecord(info, oldPlateNum, newPlateNUm, 1, statusParam.getUserName());
            records.add(record2);
        }
        if (oldCarType != newCarType) {
            record2 = this.saveOrderRecord(info, String.valueOf(oldCarType), String.valueOf(newCarType), 2, statusParam.getUserName());
            records.add(record2);
        }
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(config.getDataCollection())) {
            records.forEach(record -> {
                SendRequest request = new SendRequest();
                request.setParkId(info.getParkId());
                request.setServiceId(record.getId());
                this.modifyCarService.send(request);
            });
        }
        return ObjectResponse.success();
    }

    private OrderModifyRecord saveOrderRecord(OrderInfo info, String oldVal, String newVal, Integer correctType, String userName) {
        OrderModifyRecord record = new OrderModifyRecord();
        record.setAction(Integer.valueOf(1));
        record.setCorrectType(correctType);
        record.setOrderNum(info.getOrderNum());
        record.setParkId(info.getParkId());
        record.setBeforeModify(String.valueOf(oldVal));
        record.setAfterModify(String.valueOf(newVal));
        record.setParkId(info.getParkId());
        record.setModifyTime(DateTools.getFormat((Date)new Date()));
        record.setOperAccount(userName);
        record.setCreateTime(DateTools.getFormat((Date)new Date()));
        this.orderModifyRecordDao.insert((Object)record);
        return record;
    }

    public BigDecimal strToBig(String value) {
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }
}

