/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderRefundService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderRefundDao;
import com.icetech.order.dao.OrderRefundRecordMapper;
import com.icetech.order.domain.dto.OrderRefundRecordDTO;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderRefund;
import com.icetech.order.domain.entity.OrderRefundRecord;
import com.icetech.park.domain.request.OrderRefundParam;
import com.icetech.park.domain.request.RefundParam;
import com.icetech.park.domain.request.RefundRecordParam;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.normalpay.request.RefundRequest;
import com.icetech.paycenter.domain.normalpay.response.RefundResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderRefundServiceImpl
implements OrderRefundService {
    private static final Logger log = LoggerFactory.getLogger(OrderRefundServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderRefundDao orderRefundDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private OrderRefundRecordMapper orderRefundRecordMapper;

    public ObjectResponse<Object> orderRefund(OrderRefundParam param) {
        log.info("\u8ba2\u5355\uff1a\u3010{}\u3011\u5f00\u59cb\u9000\u6b3e", (Object)param.getOrderNum());
        try {
            OrderRefund refund = (OrderRefund)this.orderRefundDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderRefund.class).eq(OrderRefund::getOrderNum, (Object)param.getOrderNum())).in(OrderRefund::getRefundStatus, Arrays.asList(0, 1, 2, 4))).last("LIMIT 1"));
            if (refund != null) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)"\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u672a\u9000\u6b3e\u5ba1\u6838\uff0c\u8bf7\u5148\u5b8c\u6210\u9000\u6b3e\u5ba1\u6838\uff01");
            }
            OrderInfo order = this.getOrderByOrderNum(param.getOrderNum());
            OrderCarInfo carInfo = this.getOrderCarInfoByOrderNum(param.getOrderNum());
            List<OrderPay> orderPays = this.getOrderPayByOrderNum(param.getOrderNum());
            this.checkOrderAmount(orderPays, order, param);
            this.executeRefund(orderPays, order, carInfo, param);
            return ObjectResponse.success();
        }
        catch (IllegalArgumentException e) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u5904\u7406\u5931\u8d25 | orderNum:{}", (Object)param.getOrderNum(), (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Map<String, Object>> getOrderRefundList(RefundParam param, List<Long> parkIds) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        Page refundPage = this.orderRefundDao.getOrderRefundList(page, param);
        Map sumRefundPrice = this.orderRefundDao.sumRefundPrice(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", refundPage.getTotal());
        map.put("orderRefunds", refundPage.getRecords());
        map.put("sumRefundPrice", sumRefundPrice.get("sumRefundPrice"));
        map.put("sumActualRefundPrice", sumRefundPrice.get("sumActualRefundPrice"));
        return ObjectResponse.success(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Object> orderRefundAudit(OrderRefundParam param) {
        OrderRefund refund = (OrderRefund)this.orderRefundDao.selectById((Serializable)param.getId());
        if (refund == null) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)"\u672a\u627e\u5230\u9000\u6b3e\u8bb0\u5f55");
        }
        try {
            OrderInfo order = this.getOrderByOrderNum(refund.getOrderNum());
            ObjectResponse<Object> response = this.checkRefund(order, refund, param);
            if (!ObjectResponse.isSuccess(response)) {
                return response;
            }
            OrderPay pay = (OrderPay)this.orderPayDao.selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderPay.class).eq(OrderPay::getId, (Object)refund.getPayId()));
            if (param.getRefundStatus() != null && param.getRefundStatus() == -1) {
                refund.setRefundStatus(param.getRefundStatus());
                refund.setUpdateTime(new Date());
                refund.setRefundReason(param.getRefundReason());
                this.orderRefundDao.updateById((Object)refund);
                return ObjectResponse.success();
            }
            return this.processSingleRefundAsync(order, pay, refund, param);
        }
        catch (Exception e) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)e.getMessage());
        }
    }

    public ObjectResponse<Page<OrderRefundRecordDTO>> orderRefundRecord(RefundRecordParam param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        Page refundPage = this.orderRefundRecordMapper.getOrderRefundRecordList(page, param);
        return ObjectResponse.success((Object)refundPage);
    }

    private void executeRefund(List<OrderPay> orderPays, OrderInfo order, OrderCarInfo carInfo, OrderRefundParam param) {
        Map<String, BigDecimal> refundAllocations = this.allocateRefundAmounts(orderPays, param.getRefundPrice());
        Map payMap = orderPays.stream().collect(Collectors.toMap(OrderPay::getTradeNo, Function.identity()));
        refundAllocations.forEach((k, v) -> {
            OrderPay pay = (OrderPay)payMap.get(k);
            this.saveRefund(pay, order, carInfo, (BigDecimal)v, param);
        });
    }

    private ObjectResponse<Object> processSingleRefundAsync(OrderInfo order, OrderPay pay, OrderRefund refund, OrderRefundParam param) {
        BasePark park = (BasePark)this.parkService.getById((Serializable)pay.getParkId());
        String newTradeNo = "R" + CodeTools.GenerateTradeNo();
        try {
            log.info("\u5f00\u59cb\u5904\u7406\u5355\u7b14\u9000\u6b3e | orderNum:{} | tradeNo:{} | refundPrice:{}", new Object[]{order.getOrderNum(), newTradeNo, param.getRefundPrice()});
            ObjectResponse<RefundResponse> response = this.callRefundApi(park.getParkCode(), pay, newTradeNo, param.getRefundPrice(), param.getReason());
            log.info("\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1a{}", response);
            refund.setActualRefundPrice(param.getRefundPrice());
            if (!ObjectResponse.isSuccess(response) || response.getData() == null) {
                String msg = response.getData() == null ? "\u9000\u6b3e\u5931\u8d25" : response.getMsg();
                return this.handleValidationFailureAndUpdate(order, pay, param, refund, msg, 4, 1);
            }
            String msg = response.getMsg();
            int refundStatus = 0;
            if (((RefundResponse)response.getData()).getRefundStatus() == 4) {
                refundStatus = 4;
            }
            if (((RefundResponse)response.getData()).getRefundStatus() == 3) {
                refund.setTraceNo(park.getParkCode() + newTradeNo);
                refundStatus = 3;
                this.updateOrderAndPay(order, pay, param);
            }
            return this.handleValidationFailureAndUpdate(order, pay, param, refund, msg, refundStatus, 0);
        }
        catch (Exception e) {
            return ObjectResponse.failed((String)"\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    private ObjectResponse<RefundResponse> callRefundApi(String parkCode, OrderPay orderPay, String tradeNo, BigDecimal refundPrice, String reason) {
        RefundRequest request = new RefundRequest();
        request.setParkCode(parkCode);
        request.setTradeNo(orderPay.getTradeNo());
        request.setOutTradeNo(orderPay.getThirdTradeNo());
        request.setRefundTradeNo(tradeNo);
        request.setPrice(String.valueOf(MoneyTool.fromYuanToFen((String)String.valueOf(refundPrice))));
        request.setOrderNote(reason);
        return this.payCenterService.refund(request);
    }

    private Map<String, BigDecimal> allocateRefundAmounts(List<OrderPay> orderPays, BigDecimal totalRefundPrice) {
        HashMap<String, BigDecimal> allocations = new HashMap<String, BigDecimal>();
        BigDecimal remaining = totalRefundPrice;
        for (OrderPay orderPay : orderPays) {
            BigDecimal available = this.strToBig(orderPay.getPaidPrice()).subtract(OrderRefundServiceImpl.nullToZero(orderPay.getRefundPrice()));
            if (available.compareTo(BigDecimal.ZERO) <= 0 || remaining.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal refundPrice = remaining.min(available);
            allocations.put(orderPay.getTradeNo(), refundPrice);
            remaining = remaining.subtract(refundPrice);
        }
        return allocations;
    }

    private void updateOrderAndPay(OrderInfo order, OrderPay pay, OrderRefundParam param) {
        pay.setRefundPrice(OrderRefundServiceImpl.nullToZero(pay.getRefundPrice()).add(param.getRefundPrice()));
        pay.setPayStatus(Integer.valueOf(2));
        pay.setUpdateUser(param.getUserName());
        this.orderPayService.modifyOrderPay(pay);
        order.setRefundPrice(OrderRefundServiceImpl.nullToZero(order.getRefundPrice()).add(param.getRefundPrice()));
        this.orderService.updateOrderInfo(order);
        log.info("\u9000\u6b3e\u5b8c\u6210 | orderNum:{} | totalRefunded:{}", (Object)order.getOrderNum(), (Object)param.getRefundPrice());
    }

    private BigDecimal calculateRemainAmount(List<OrderPay> orderPays) {
        return orderPays.stream().map(pay -> this.strToBig(pay.getPaidPrice()).subtract(OrderRefundServiceImpl.nullToZero(pay.getRefundPrice()))).filter(amount -> amount.compareTo(BigDecimal.ZERO) > 0).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private OrderInfo getOrderByOrderNum(String orderNum) {
        ObjectResponse info = this.orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess((Response)info)) {
            throw new IllegalArgumentException("\u672a\u67e5\u5230\u8ba2\u5355");
        }
        return (OrderInfo)info.getData();
    }

    private OrderCarInfo getOrderCarInfoByOrderNum(String orderNum) {
        return this.orderCarInfoService.getByOrderNum(orderNum);
    }

    private List<OrderPay> getOrderPayByOrderNum(String orderNum) {
        ObjectResponse pay = this.orderPayService.selectByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess((Response)pay)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u652f\u4ed8\u4fe1\u606f\uff01");
        }
        List pays = (List)pay.getData();
        if (CollectionUtils.isEmpty((Collection)pays)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u652f\u4ed8\u4fe1\u606f\uff01");
        }
        List<OrderPay> filterPays = pays.stream().filter(this::isValidPayCondition).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterPays)) {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u9000\u6b3e\uff01");
        }
        return filterPays;
    }

    private void checkOrderAmount(List<OrderPay> orderPays, OrderInfo order, OrderRefundParam param) {
        if (Objects.isNull(order)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5f53\u524d\u8ba2\u5355");
        }
        if (orderPays.isEmpty()) {
            throw new IllegalArgumentException("\u672a\u67e5\u5230\u652f\u4ed8\u660e\u7ec6");
        }
        if (param.getRefundPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        BigDecimal remainAmount = this.calculateRemainAmount(orderPays);
        if (remainAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("\u5df2\u7f34\u91d1\u989d\u5df2\u9000\u8fd8");
        }
        if (remainAmount.compareTo(param.getRefundPrice()) < 0) {
            throw new IllegalArgumentException("\u8ba2\u5355\u5269\u4f59\u53ef\u9000\u6b3e\u91d1\u989d\u4e0d\u8db3");
        }
    }

    private ObjectResponse<Object> checkRefund(OrderInfo order, OrderRefund refund, OrderRefundParam param) {
        BigDecimal totalRefundedAmount;
        if (Objects.isNull(refund)) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u9000\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728 | refundId:{}", (Object)param.getId());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)"\u9000\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (refund.getRefundStatus() == -1 || refund.getRefundStatus() == 3) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u9000\u6b3e\u8bb0\u5f55\u72b6\u6001\u4e0d\u53ef\u64cd\u4f5c | refundId:{} | status:{}", (Object)param.getId(), (Object)refund.getRefundStatus());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)"\u5df2\u53d6\u6d88\u6216\u9000\u6b3e\u6210\u529f\u4e0d\u53ef\u64cd\u4f5c");
        }
        List pays = this.orderPayDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderPay.class).eq(OrderPay::getOrderNum, (Object)refund.getOrderNum())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(OrderPay::getPayChannel, Arrays.asList(2, 9))).or()).eq(OrderPay::getPayChannel, (Object)1)).in(OrderPay::getPayWay, Arrays.asList(2, 3));
        }));
        Map payMap = pays.stream().collect(Collectors.toMap(OrderPay::getId, Function.identity()));
        OrderPay pay = (OrderPay)payMap.get(refund.getPayId());
        if (Objects.isNull(pay)) {
            log.error("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u672a\u627e\u5230\u5f53\u524d\u9000\u6b3e\u8bb0\u5f55\u5bf9\u5e94\u7684\u652f\u4ed8\u660e\u7ec6 | refundId:{} | payId:{}", (Object)param.getId(), (Object)refund.getPayId());
            return this.handleValidationFailureAndUpdate(order, null, param, refund, "\u652f\u4ed8\u8bb0\u5f55\u4e0d\u5b58\u5728", -1, 1);
        }
        List successfulRefunds = this.orderRefundDao.selectList(refund.getOrderNum());
        BigDecimal totalPaidAmount = pays.stream().map(orderPay -> this.strToBig(orderPay.getPaidPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal orderRemainAmount = totalPaidAmount.subtract(totalRefundedAmount = successfulRefunds.stream().map(r -> OrderRefundServiceImpl.nullToZero(r.getActualRefundPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
        if (orderRemainAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u8ba2\u5355\u5df2\u5168\u989d\u9000\u6b3e | orderNum:{} | remain:{}", (Object)refund.getOrderNum(), (Object)orderRemainAmount);
            return this.handleValidationFailureAndUpdate(order, pay, param, refund, "\u8ba2\u5355\u5df2\u5168\u989d\u9000\u6b3e", -1, 1);
        }
        if (param.getRefundPrice().compareTo(orderRemainAmount) > 0) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u8ba2\u5355\u5269\u4f59\u53ef\u9000\u91d1\u989d | orderNum:{} | apply:{} | remain:{}", new Object[]{refund.getOrderNum(), param.getRefundPrice(), orderRemainAmount});
            return this.handleValidationFailureAndUpdate(order, pay, param, refund, "\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u8ba2\u5355\u5269\u4f59\u53ef\u9000\u91d1\u989d", -1, 1);
        }
        BigDecimal payRemainAmount = this.strToBig(pay.getPaidPrice()).subtract(OrderRefundServiceImpl.nullToZero(pay.getRefundPrice()));
        if (payRemainAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u6b64\u7b14\u652f\u4ed8\u660e\u7ec6\u5df2\u5168\u989d\u9000\u6b3e | payId:{} | remain:{}", (Object)pay.getId(), (Object)payRemainAmount);
            return this.handleValidationFailureAndUpdate(order, pay, param, refund, "\u6b64\u7b14\u652f\u4ed8\u660e\u7ec6\u5df2\u5168\u989d\u9000\u6b3e", -1, 1);
        }
        if (param.getRefundPrice().compareTo(payRemainAmount) > 0) {
            log.warn("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff1a\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u6b64\u7b14\u652f\u4ed8\u660e\u7ec6\u5269\u4f59\u53ef\u9000\u91d1\u989d | payId:{} | apply:{} | remain:{}", new Object[]{pay.getId(), param.getRefundPrice(), payRemainAmount});
            return this.handleValidationFailureAndUpdate(order, pay, param, refund, "\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u6b64\u7b14\u652f\u4ed8\u660e\u7ec6\u5269\u4f59\u53ef\u9000\u91d1\u989d", -1, 1);
        }
        log.info("\u9000\u6b3e\u6821\u9a8c\u6210\u529f | refundId:{} | orderNum:{} | applyPrice:{}", new Object[]{param.getId(), refund.getOrderNum(), param.getRefundPrice()});
        return ObjectResponse.success();
    }

    private ObjectResponse<Object> handleValidationFailureAndUpdate(OrderInfo order, OrderPay pay, OrderRefundParam param, OrderRefund refund, String message, Integer refundStatus, int type) {
        if (type == 1) {
            refund.setActualRefundPrice(BigDecimal.ZERO);
        }
        refund.setRefundStatus(refundStatus);
        refund.setRefundFailMsg(message);
        this.orderRefundDao.updateById((Object)refund);
        if (pay != null) {
            this.saveOrderRefundRecord(order, pay, refund, param);
        }
        if (type == 1) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)message);
        }
        return ObjectResponse.success();
    }

    private void saveOrderRefundRecord(OrderInfo order, OrderPay pay, OrderRefund refund, OrderRefundParam param) {
        OrderRefundRecord refundRecord = new OrderRefundRecord();
        refundRecord.setParkId(Integer.valueOf(order.getParkId().intValue()));
        refundRecord.setOrderNum(order.getOrderNum());
        refundRecord.setTradeNo(pay.getTradeNo());
        refundRecord.setPlateNo(order.getPlateNum());
        refundRecord.setAmount(param.getRefundPrice());
        refundRecord.setPayWay(pay.getPayWay());
        refundRecord.setPayTime((Date)DateUtil.date((long)(pay.getPayTime() * 1000L)));
        refundRecord.setRefundStatus(refund.getRefundStatus());
        refundRecord.setRefundReason(refund.getRefundReason());
        refundRecord.setRefundTime(refund.getCreateTime());
        refundRecord.setOptionName(param.getUserName());
        refundRecord.setOptionTime(new Date());
        refundRecord.setCreateTime(new Date());
        refundRecord.setRefundFailMsg(refund.getRefundFailMsg());
        this.orderRefundRecordMapper.insert((Object)refundRecord);
    }

    private void saveRefund(OrderPay pay, OrderInfo order, OrderCarInfo carInfo, BigDecimal refundPrice, OrderRefundParam param) {
        Date date = new Date();
        OrderRefund refund = new OrderRefund();
        refund.setParkId(pay.getParkId());
        refund.setPayId(pay.getId());
        refund.setOrderNum(order.getOrderNum());
        refund.setCarType(order.getType());
        refund.setPlateNum(order.getPlateNum());
        refund.setPlateColor(carInfo.getPlateColor());
        refund.setEnterTime(order.getEnterTime());
        refund.setExitTime(order.getExitTime());
        refund.setRefundPrice(refundPrice);
        refund.setRefundStatus(Integer.valueOf(0));
        refund.setRefundReason(param.getReason());
        refund.setCreateTime(date);
        refund.setUpdateTime(date);
        refund.setDeleted(Integer.valueOf(0));
        refund.setPayChannel(pay.getPayChannel());
        this.orderRefundDao.insert(refund);
    }

    private boolean isValidPayCondition(OrderPay p) {
        return p.getPayChannel() == 2 || p.getPayChannel() == 9 || p.getPayChannel() == 1 && (p.getPayWay() == 2 || p.getPayWay() == 3);
    }

    public static BigDecimal nullToZero(BigDecimal value) {
        return value != null ? value : BigDecimal.ZERO;
    }

    public BigDecimal strToBig(String value) {
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }
}

