/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.basics.utils.ForEachUtils;
import com.icetech.city.road.api.NotifyPayApi;
import com.icetech.city.road.app.undefined.dto.PayToItem;
import com.icetech.city.road.domain.constant.PayAisleConstant;
import com.icetech.city.road.domain.constant.PayChannelConstant;
import com.icetech.city.road.domain.constant.PayWayConstant;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.order.OrderPayWayDto;
import com.icetech.cloudcenter.domain.order.SumOrderDatePayDto;
import com.icetech.cloudcenter.domain.order.SumOrderPayDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.query.OrderPayQuery;
import com.icetech.cloudcenter.domain.pay.MiniOrdersDTO;
import com.icetech.cloudcenter.domain.pay.PayTo;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.request.BossOrderPayRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.InvoiceQueryRequest;
import com.icetech.cloudcenter.domain.request.InvoiceRequest;
import com.icetech.cloudcenter.domain.request.OrderPayQueryRequest;
import com.icetech.cloudcenter.domain.request.ParkIncomeTopRequest;
import com.icetech.cloudcenter.domain.request.PaywayTopRequest;
import com.icetech.cloudcenter.domain.request.SumOrderPayRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.IncomeCountDto;
import com.icetech.cloudcenter.domain.response.IncomeCountHourDto;
import com.icetech.cloudcenter.domain.response.IncomeDetailDto;
import com.icetech.cloudcenter.domain.response.InvoiceQueryResponse;
import com.icetech.cloudcenter.domain.response.InvoiceResponse;
import com.icetech.cloudcenter.domain.response.OrderPayDto;
import com.icetech.cloudcenter.domain.response.ParkIncomeTopDto;
import com.icetech.cloudcenter.domain.response.PayCashNotPay;
import com.icetech.cloudcenter.domain.response.PayWayCountDto;
import com.icetech.cloudcenter.domain.response.PaywayTopDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.StoreCardCountDto;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PayAisleEnum;
import com.icetech.common.constants.PayWayContants;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.merchant.MerchantDiscountDao;
import com.icetech.fee.dao.merchant.ParkMerchantDao;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.fee.domain.entity.merchant.MerchantDiscount;
import com.icetech.fee.domain.entity.merchant.ParkMerchant;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDetail;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.impl.OrderPayDetailServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.dao.invoice.InvoiceMerchantParkDao;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.park.domain.entity.invoice.InvoiceMerchantPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.impl.DownSendServiceImpl;
import com.icetech.park.service.report.p2c.impl.enter.CarEnterHandler;
import com.icetech.partner.api.TeldService;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.report.domain.vo.ParkPayReportVo;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.DateRangeUtils;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderPayService")
public class OrderPayServiceImpl
extends BaseServiceImpl<OrderPayDao, OrderPay>
implements OrderPayService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayServiceImpl.class);
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private MerchantDiscountDao merchantDiscountDao;
    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDao parkDao;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OssService ossService;
    @Autowired
    private InvoiceMerchantParkDao invoiceMerchantParkDao;
    @Autowired
    private ParkMerchantDao parkMerchantDao;
    @Autowired
    private StoreCardDao storeCardDao;
    @Resource
    private MqPushService pushService;
    @Resource
    private TeldService teldService;
    @Autowired
    private OrderPayDetailServiceImpl orderPayDetailService;
    @Resource
    private CacheHandle cacheHandle;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private DownSendServiceImpl downSendService;
    @Autowired
    private ThreadPoolExecutor asyncMethodExecutor;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;
    @Autowired
    private CarEnterHandler carEnterHandler;
    @Autowired
    private DownShowSayHandle downShowSayHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private NotifyPayApi roadNotifyPayApi;

    public ObjectResponse selectOrderPayByOnum(String ordeNum) {
        OrderPay orderPay = this.orderPayDao.selectByOrdernum(ordeNum, Integer.valueOf(5));
        if (orderPay != null) {
            return ObjectResponse.success((Object)orderPay);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<OrderPay>> selectByOrderNum(String orderNum) {
        List payList = this.orderPayDao.selectByOrderNum(orderNum);
        if (!CollectionUtils.isEmpty((Collection)payList)) {
            return ObjectResponse.success((Object)payList);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Long> addOrderPay(OrderPay orderPay) {
        String orderNum = orderPay.getOrderNum();
        if (com.icetech.common.utils.StringUtils.isBlank((CharSequence)orderNum)) {
            return ObjectResponse.failed((String)"400");
        }
        if (orderPay.getParkId() == null) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(orderPay.getParkId());
            orderInfo.setOrderNum(orderNum);
            orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
            orderPay.setParkId(orderInfo.getParkId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderPay.getOrderPayDetails())) {
            orderPay.setIsSonOrderpay(Integer.valueOf(1));
            this.orderPayDetailService.saveBatch((Collection)orderPay.getOrderPayDetails());
        }
        this.orderPayDao.insert((Object)orderPay);
        if (orderPay.getId() == null) {
            return ObjectResponse.failed((String)"500");
        }
        if (orderPay.getPayStatus() != null && orderPay.getPayStatus() == 2) {
            this.lockAfterPay(orderPay.getParkId(), orderNum, orderPay.getTradeNo());
            this.pushService.pushOrderPay(orderPay);
            this.pushService.pushOrderPaySync(orderPay);
        }
        return ObjectResponse.success((Object)orderPay.getId());
    }

    private void lockAfterPay(Long parkId, String orderNum, String tradeNo) {
        ObjectResponse objectResponse = this.parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            long afterPayFreeTime = NumberUtils.toPrimitive((Integer)((ParkConfig)objectResponse.getData()).getIsfreeAfterpay(Integer.valueOf(15)));
            if (afterPayFreeTime > 15L) {
                afterPayFreeTime = 15L;
            } else if (afterPayFreeTime < 3L) {
                afterPayFreeTime = 3L;
            }
            this.redisUtils.set("lock:pay:after:" + orderNum, (Object)tradeNo, afterPayFreeTime - 2L, TimeUnit.MINUTES);
        }
    }

    public ObjectResponse<OrderPay> findOne(OrderPay orderPay) {
        OrderPay orderPay_res = (OrderPay)this.orderPayDao.selectLimitOne((Object)orderPay);
        if (orderPay_res != null) {
            return ObjectResponse.success((Object)orderPay_res);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Integer> modifyOrderPay(OrderPay orderPay) {
        int n = this.orderPayDao.updateByEntity(orderPay);
        if (orderPay.getPayStatus() != null && NumberUtils.toPrimitive((Integer)orderPay.getIsSonOrderpay()) == 1) {
            OrderPayDetail updateDetail = new OrderPayDetail();
            updateDetail.setPayStatus(orderPay.getPayStatus());
            OrderPayDetail detailParam = new OrderPayDetail();
            detailParam.setParkId(orderPay.getParkId());
            detailParam.setTradeNo(orderPay.getTradeNo());
            this.orderPayDetailService.update((Object)updateDetail, (Wrapper)Wrappers.lambdaQuery((Object)detailParam));
        }
        if (n > 0) {
            log.info("[\u4ea4\u6613\u8bb0\u5f55\u670d\u52a1] \u66f4\u65b0\u4ea4\u6613\u8bb0\u5f55\u6210\u529f\uff0c\u53c2\u6570\uff1a{}", (Object)orderPay);
            return ObjectResponse.success((Object)n);
        }
        log.info("[\u4ea4\u6613\u8bb0\u5f55\u670d\u52a1] \u66f4\u65b0\u4ea4\u6613\u8bb0\u5f55\u5f71\u54cd\u884c\u6570\uff1a{}\u884c\uff0c\u53c2\u6570\uff1a{}", (Object)n, (Object)orderPay);
        return ObjectResponse.failed((String)"402");
    }

    @Transactional
    public ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay) {
        String tradeNo = orderPay.getTradeNo();
        String orderNum = orderPay.getOrderNum();
        if (tradeNo == null || orderNum == null) {
            log.info("[\u5b8c\u6210\u652f\u4ed8] \u53c2\u6570\u7f3a\u5931\uff0ctradeNo:{}, orderNum:{}", (Object)tradeNo, (Object)orderNum);
            return ObjectResponse.failed((String)"400");
        }
        orderPay.setTradeNo(tradeNo);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        ObjectResponse<Integer> result = this.updateOrderPayWithPush(orderPay);
        log.info("[\u5b8c\u6210\u652f\u4ed8] \u66f4\u65b0\u4ea4\u6613\u8bb0\u5f55\u72b6\u6001\u6210\u529f\uff0c\u5f71\u54cd\u884c\u6570\uff1a{}\u884c\uff0c\u53c2\u6570\uff1a{}", result.getData(), (Object)orderPay);
        return result;
    }

    public ObjectResponse<Integer> updateOrderPayWithPush(OrderPay orderPay) {
        ObjectResponse<Integer> result = this.modifyOrderPay(orderPay);
        if (ObjectResponse.isSuccess(result) && orderPay.getPayStatus() != null && orderPay.getId() != null && orderPay.getPayStatus() == 2) {
            this.lockAfterPay(orderPay.getParkId(), orderPay.getOrderNum(), orderPay.getTradeNo());
            this.pushService.pushOrderPay(orderPay);
            this.pushService.pushOrderPaySync(orderPay);
        }
        return result;
    }

    public ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay, String parkCode, String channelCode) {
        String orderNum;
        QueryOrderFeeResponse channelFee;
        ObjectResponse<Integer> objectResponse = this.finishPayAndDiscount(orderPay);
        if (parkCode != null && channelCode != null && (channelFee = this.cacheHandle.getChannelFee(parkCode, channelCode)) != null && (orderNum = channelFee.getOrderNum()) != null && orderNum.equals(orderPay.getOrderNum())) {
            this.cacheHandle.removeChannelFee(parkCode, channelCode);
        }
        return objectResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> finishPayNotPay(MiniOrdersDTO dto, String bankOrderId) {
        Map tradeNoMap = dto.getTradeNoMap();
        List tradeNos = tradeNoMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] orderNums: {},tradeNos:{}", (Object)dto.getOrderNums(), tradeNos);
        List orderPays = this.orderPayDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderPay.class).in(OrderPay::getTradeNo, tradeNos)).eq(OrderPay::getPayStatus, (Object)1));
        if (CollectionUtils.isEmpty((Collection)orderPays)) {
            log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] \u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728, [{}]", tradeNos);
            return ObjectResponse.success();
        }
        Long current = DateUtil.currentSeconds();
        orderPays.forEach(orderPay -> {
            orderPay.setPayTime(current);
            orderPay.setThirdTradeNo(dto.getOutTradeNo());
            orderPay.setPayStatus(Integer.valueOf(2));
            orderPay.setBankOrderId(bankOrderId);
            this.finishPayAndDiscount((OrderPay)orderPay);
        });
        List notPays = this.orderNotpayService.getListByOrderNums(dto.getOrderNums());
        if (CollectionUtils.isNotEmpty((Collection)notPays)) {
            List notPayDetailVos = notPays.stream().map(p -> {
                NotPayDetailVo notPayDetailVo = new NotPayDetailVo();
                BeanUtils.copyProperties((Object)p, (Object)notPayDetailVo);
                notPayDetailVo.setUnPayPrice(p.getTotalPrice().toString());
                return notPayDetailVo;
            }).collect(Collectors.toList());
            this.orderNotpayService.updatePaidByOrderNums(notPayDetailVos, null, null);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> finishPayNotPay(PayTo payTo) {
        log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] payTo {}", (Object)payTo);
        List notPayDetails = payTo.getNotPayDetails();
        List orderPays = this.orderPayDao.selectListByTradeNos(notPayDetails.stream().filter(NotPayDetailVo::isParkOrder).map(NotPayDetailVo::getTradeNo).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)orderPays)) {
            log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] \u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728, payTo[{}]", (Object)payTo);
            return ObjectResponse.success();
        }
        if (Integer.valueOf(2).equals(((OrderPay)orderPays.get(0)).getPayStatus())) {
            log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] \u652f\u4ed8\u7ed3\u679c\u91cd\u590d\u901a\u77e5[{}]", (Object)((OrderPay)orderPays.get(0)).getTradeNo());
            return ObjectResponse.success();
        }
        this.orderNotpayService.updatePaidByOrderNums(notPayDetails, payTo.getChannelId(), null);
        Long current = DateUtil.currentSeconds();
        orderPays.forEach(orderPay -> {
            orderPay.setPayTime(current);
            orderPay.setThirdTradeNo(payTo.getOutTradeNo());
            orderPay.setBankOrderId(payTo.getBankOrderId());
            this.finishPayAndDiscount((OrderPay)orderPay);
        });
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(payTo.getParkCode());
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
            orderPays.forEach(orderPay -> {
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(orderPay.getParkId());
                sendRequest.setServiceId(orderPay.getId());
                sendRequest.setServiceType(DownServiceEnum.\u9884\u7f34\u8d39.getServiceType());
                sendRequest.setTopic(AsyncNotifyInterface.getTopic());
                this.downSendService.send(sendRequest);
            });
        } else if (com.icetech.common.utils.StringUtils.isNotBlank((CharSequence)payTo.getChannelId())) {
            this.asyncMethodExecutor.execute(ThreadUtils.wrapTrace(() -> {
                ParkInoutdevice parkInoutdevice = this.parkService.getChannelByCodeAndParkId(parkConfig.getParkId(), payTo.getChannelId());
                if (Integer.valueOf(2).equals(parkInoutdevice.getInandoutType())) {
                    return;
                }
                if (payTo.getPlateNum().startsWith("\u4e34")) {
                    ApplyNoPlateEnterRequest applyNoPlateEnterRequest = new ApplyNoPlateEnterRequest();
                    applyNoPlateEnterRequest.setParkCode(payTo.getParkCode());
                    applyNoPlateEnterRequest.setChannelCode(payTo.getChannelId());
                    applyNoPlateEnterRequest.setPlateNum(payTo.getPlateNum());
                    applyNoPlateEnterRequest.setUnionId(payTo.getUnionId());
                    applyNoPlateEnterRequest.setOrderNum(payTo.getOrderNum());
                    applyNoPlateEnterRequest.setParkId(parkConfig.getParkId());
                    this.manageService.applyNoPlateEnter(applyNoPlateEnterRequest);
                    return;
                }
                CarEnterRequest entrance = this.cacheHandle.getEntrance(payTo.getParkCode(), payTo.getChannelId());
                if (entrance != null && !entrance.getPlateNum().equals(payTo.getPlateNum())) {
                    log.warn("[\u5165\u53e3\u8865\u7f34] \u5f53\u524d\u8f66\u8f86\u5df2\u4e0d\u5728\u8be5\u901a\u9053[{}], \u539f\u8f66\u724c\u53f7[{}], \u5f53\u524d\u901a\u9053\u8f66\u724c[{}]", new Object[]{payTo.getChannelId(), payTo.getPlateNum(), entrance.getPlateNum()});
                    return;
                }
                ObjectResponse listObjectResponse = this.parkDeviceService.getDeviceByChannel(parkConfig.getParkId(), payTo.getChannelId(), Integer.valueOf(1));
                if (!ObjectResponse.isSuccess((Response)listObjectResponse)) {
                    log.warn("[\u5165\u53e3\u8865\u7f34] \u5f53\u524d\u901a\u9053[{}]\u6ca1\u6709\u8bc6\u522b\u76f8\u673a", (Object)payTo.getChannelId());
                    return;
                }
                ParkDevice parkDevice = (ParkDevice)((List)listObjectResponse.getData()).get(0);
                if (entrance == null) {
                    this.downShowSayHandle.fixShowSayExec(parkConfig.getParkId(), payTo.getParkCode(), parkDevice.getChannelId().longValue(), payTo.getPlateNum(), "\u505c\u7559\u65f6\u95f4\u8fc7\u957f/\u8bf7\u91cd\u65b0\u8bc6\u522b", "\u8bf7\u91cd\u65b0\u8bc6\u522b", null, parkDevice.getSerialNumber(), false);
                } else {
                    entrance.setTriggerType(TriggerTypeEnum.\u89c6\u9891.getVal());
                    entrance.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
                    CarEnexResponse carEnexResponse = this.carEnterHandler.execute(entrance, parkDevice.getSerialNumber(), parkDevice.getProtocolVer());
                    HintRequest hintRequest = new HintRequest();
                    BeanUtils.copyProperties((Object)carEnexResponse, (Object)hintRequest);
                    if (Integer.valueOf(1).equals(carEnexResponse.getOpenFlag())) {
                        this.deviceDownServiceFactory.buildRemoteOperaService(payTo.getParkCode()).open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkConfig.getParkId(), payTo.getParkCode(), parkDevice.getSerialNumber(), payTo.getPlateNum());
                    }
                    this.deviceDownServiceFactory.buildExHintService(payTo.getParkCode()).showAndSay(parkConfig.getParkId(), payTo.getParkCode(), parkDevice.getSerialNumber(), hintRequest);
                }
            }));
        }
        List roadNotPayDetails = notPayDetails.stream().filter(NotPayDetailVo::isRoadOrder).collect(Collectors.toList());
        OrderPay currentPay = null;
        if (CollectionUtils.isNotEmpty(roadNotPayDetails)) {
            currentPay = (OrderPay)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(OrderPay::getOrderNum, (Object)payTo.getOrderNum())).eq(OrderPay::getTradeNo, (Object)payTo.getTradeNo())).one();
        }
        if (currentPay == null) {
            log.warn("\u6b20\u8d39\u8ffd\u7f34\u8def\u5185\u8ba2\u5355\u5904\u7406|\u65e0\u6cd5\u627e\u5230\u573a\u5e93\u4e3b\u8ba2\u5355\u652f\u4ed8\u8bb0\u5f55|{}|{}", (Object)payTo.getOrderNum(), (Object)payTo.getTradeNo());
        } else {
            BigDecimal roadTotalPaid = roadNotPayDetails.stream().map(detail -> new BigDecimal(detail.getUnPayPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            com.icetech.city.road.app.undefined.dto.PayTo roadPay = new com.icetech.city.road.app.undefined.dto.PayTo();
            roadPay.setOutTradeNo(payTo.getOutTradeNo());
            roadPay.setOrderTime(currentPay.getOrderTime());
            roadPay.setPayWay(Integer.valueOf(this.convertRoadPayWay(currentPay.getPayWay())));
            roadPay.setPayChannel(Integer.valueOf(this.convertRoadPayChannel(currentPay.getPayChannel())));
            roadPay.setPayAisle(Integer.valueOf(this.convertRoadPayAlias(currentPay.getPayAisle())));
            roadPay.setPaidPrice(roadTotalPaid);
            roadPay.setBankOrderId(currentPay.getBankOrderId());
            List roadPayItems = roadNotPayDetails.stream().map(detail -> {
                PayToItem item = new PayToItem();
                item.setOrderNum(detail.getOrderNum());
                item.setTradeNo(payTo.getTradeNo());
                item.setTotalPrice(new BigDecimal(detail.getUnPayPrice()));
                item.setDiscountPrice(BigDecimal.ZERO);
                item.setPaidPrice(new BigDecimal(detail.getUnPayPrice()));
                return item;
            }).collect(Collectors.toList());
            roadPay.setPayToItems(roadPayItems);
            com.icetech.city.road.component.bean.ObjectResponse roadResp = this.roadNotifyPayApi.notifyPayTo(roadPay);
            log.info("\u6b20\u8d39\u8ffd\u7f34\u8def\u5185\u901a\u77e5\u5904\u7406\u7ed3\u679c|{}", (Object)roadResp);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> finishPayNotPay(PayCashNotPay payCashNotPay, Integer payChannel) {
        log.info("[\u6b20\u8d39\u8ffd\u7f34\u8865\u7f34\u8ba2\u5355] payCashNotPay {}", (Object)payCashNotPay);
        ArrayList orderPays = Lists.newArrayList();
        if (Objects.nonNull(payCashNotPay)) {
            ArrayList vos = Lists.newArrayList();
            for (String orderNum : payCashNotPay.getOrderNums()) {
                OrderNotpay orderNotpay = this.orderNotpayService.getOrderNotpayByOrderNum(orderNum);
                if (!Objects.nonNull(orderNotpay)) continue;
                OrderPay orderPay2 = new OrderPay();
                orderPay2.setParkId(orderNotpay.getParkId());
                orderPay2.setPayStatus(Integer.valueOf(2));
                orderPay2.setOrderNum(orderNotpay.getOrderNum());
                orderPay2.setChannelId(payCashNotPay.getChannelCode());
                orderPay2.setPayWay(payCashNotPay.getPayWay());
                orderPay2.setTradeNo(CodeTools.GenerateTradeNo());
                orderPay2.setLastPayTime(orderNotpay.getLastPayTime());
                orderPay2.setTotalPrice(orderNotpay.getTotalPrice().setScale(2, RoundingMode.HALF_UP).toString());
                orderPay2.setDiscountPrice(orderNotpay.getDiscountPrice().setScale(2, RoundingMode.HALF_UP).toString());
                orderPay2.setPaidPrice(orderNotpay.getTotalPrice().subtract(orderNotpay.getDiscountPrice()).setScale(2, RoundingMode.HALF_UP).toString());
                orderPay2.setOrderTime(Long.valueOf(DateUtil.currentSeconds()));
                orderPay2.setPayTime(Long.valueOf(DateUtil.currentSeconds()));
                orderPay2.setPayChannel(payChannel);
                orderPay2.setUserAccount(payCashNotPay.getAccountName());
                orderPay2.setPayType(Integer.valueOf(1));
                orderPay2.setPayTerminal(payCashNotPay.getChannelCode());
                this.addOrderPay(orderPay2);
                orderPays.add(orderPay2);
                vos.add(NotPayDetailVo.builder().orderNum(orderPay2.getOrderNum()).unPayPrice(orderPay2.getPaidPrice()).build());
            }
            this.orderNotpayService.updatePaidByOrderNums((List)vos, payCashNotPay.getChannelCode(), payCashNotPay.getAccountName());
            orderPays.forEach(orderPay -> {
                ObjectResponse<Integer> objectResponse = this.finishPayAndDiscount((OrderPay)orderPay);
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(orderPay.getParkId());
                sendRequest.setServiceId(orderPay.getId());
                sendRequest.setServiceType(DownServiceEnum.\u9884\u7f34\u8d39.getServiceType());
                ObjectResponse<?> send = this.downSendService.send(sendRequest);
            });
        }
        return ObjectResponse.success();
    }

    public boolean useDiscount(OrderPay orderPay) {
        String orderNum = orderPay.getOrderNum();
        List orderDiscounts = this.orderDiscountDao.selectByOrderNum(orderNum, Integer.valueOf(0));
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            for (OrderDiscount orderDiscount : orderDiscounts) {
                if (this.useDiscount(Double.parseDouble(orderPay.getDiscountPrice()), orderPay.getParkId(), orderPay.getTradeNo(), orderPay.getPayTime(), orderNum, orderDiscount)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean useDiscount(Long parkId, String orderNum, Double discountPrice, String tradeNo, Long payTime, List<String> discountNos, OrderPay orderPay) {
        if (discountPrice == null || discountPrice == 0.0) {
            return false;
        }
        try {
            if (orderPay == null) {
                orderPay = this.orderPayDao.selectByTradeNo(tradeNo);
            }
            if (Objects.nonNull(orderPay)) {
                List orderDiscounts = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)parkId)).eq(OrderDiscount::getDelFlag, (Object)0)).in(OrderDiscount::getDiscountNo, discountNos));
                Set discountNames = orderDiscounts.stream().map(s -> com.icetech.common.utils.StringUtils.isNotBlank((CharSequence)s.getDiscountName()) ? s.getDiscountName() : "").collect(Collectors.toSet());
                String join = StrUtil.join((CharSequence)"-", discountNames);
                if (join.length() < 512) {
                    orderPay.setRemark(join);
                }
                if (NumberUtils.toDouble((String)orderPay.getPaidPrice()) == 0.0 && NumberUtils.toDouble((String)orderPay.getTotalPrice()) > 0.0) {
                    orderPay.setPayWay(Integer.valueOf(10));
                }
                this.orderPayDao.updateById((Object)orderPay);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4f18\u60e0\u62b5\u6263\u5931\u8d25 tradeNo {}", (Object)tradeNo, (Object)e);
        }
        try {
            return (Boolean)this.redissonDistributedLock.locked(() -> {
                List orderDiscounts;
                List disDayList;
                List orderDiscountsThirdList = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getOrderNum, (Object)orderNum)).eq(OrderDiscount::getFrom, (Object)2));
                if (CollectionUtil.isNotEmpty((Collection)orderDiscountsThirdList)) {
                    List discountThirdNos = orderDiscountsThirdList.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList());
                    CollectionUtil.addAll((Collection)discountNos, discountThirdNos);
                    CollectionUtil.distinct((Collection)discountNos);
                }
                if (CollectionUtils.isNotEmpty(disDayList = (orderDiscounts = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)parkId)).eq(OrderDiscount::getDelFlag, (Object)0)).in(OrderDiscount::getDiscountNo, (Collection)discountNos))).stream().filter(orderDiscount -> Integer.valueOf(5).equals(orderDiscount.getType())).collect(Collectors.toList()))) {
                    Optional<OrderDiscount> first = disDayList.stream().filter(orderDiscount -> orderDiscount.getOrderNum().equals(orderNum)).filter(orderDiscount -> orderDiscount.getStatus() == 0 || orderDiscount.getStatus() == 3).findFirst();
                    if (first.isPresent()) {
                        this.updateDiscountUsed(discountPrice, tradeNo, payTime, 0, first.get());
                    } else {
                        OrderDiscount orderDiscount2 = (OrderDiscount)disDayList.get(0);
                        orderDiscount2.setId(null);
                        orderDiscount2.setOrderNum(orderNum);
                        orderDiscount2.setTradeNo(tradeNo);
                        orderDiscount2.setAmount(String.valueOf(discountPrice));
                        orderDiscount2.setStatus(Integer.valueOf(1));
                        orderDiscount2.setGetAmount(discountPrice);
                        orderDiscount2.setUseTime(new Date());
                        orderDiscount2.setCarStatus(Integer.valueOf(2));
                        orderDiscount2.setDeductMoney(null);
                        orderDiscount2.setReduceBalance(null);
                        this.orderDiscountDao.insert((Object)orderDiscount2);
                    }
                }
                if (disDayList.size() == orderDiscounts.size()) {
                    return true;
                }
                ForEachUtils.forEach((int)0, (Iterable)orderDiscounts, (index, orderDiscount) -> {
                    if (orderDiscount.getStatus() == 0 || orderDiscount.getStatus() == 3) {
                        Long merchantDisId;
                        MerchantDiscount merchantDiscount;
                        if ((orderDiscount.getType() == 1 || orderDiscount.getType() == 4) && Objects.nonNull(orderDiscount.getMerchantDisId()) && (merchantDiscount = this.merchantDiscountDao.findById(merchantDisId = orderDiscount.getMerchantDisId())) != null && merchantDiscount.getDeductType() == 1) {
                            ObjectResponse objectResponse;
                            orderDiscount.setDeductMoney(discountPrice);
                            orderDiscount.setGetAmount(discountPrice);
                            BigDecimal mchDeductAmount = new BigDecimal(discountPrice);
                            if (merchantDiscount.getType() == 1 && merchantDiscount.getDisDeductValue() != null && merchantDiscount.getDisDeductValue() > 0 && merchantDiscount.getDisDeductValue() < 10) {
                                mchDeductAmount = mchDeductAmount.multiply(BigDecimal.valueOf(merchantDiscount.getDisDeductValue().intValue(), 1));
                            }
                            if (!"200".equals((objectResponse = this.merchantUserService.subMerchantMoney(Integer.valueOf(orderDiscount.getMerchantId().intValue()), mchDeductAmount)).getCode())) {
                                log.error("[\u7d27\u6025\u9519\u8bef]\u4f18\u60e0\u5ef6\u8fdf\u6263\u9664\u5546\u6237\u4f59\u989d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406,orderNum\uff1a{}\uff0cdiscountNo\uff1a{}", (Object)orderDiscount.getOrderNum(), (Object)orderDiscount.getDiscountNo());
                                return;
                            }
                        }
                        this.updateDiscountUsed(discountPrice, tradeNo, payTime, (Integer)index, (OrderDiscount)orderDiscount);
                    }
                });
                return true;
            }, "LOCK:DISCOUNT:" + tradeNo);
        }
        catch (Exception e) {
            log.error("[\u5206\u5e03\u5f0f\u9501\u6267\u884c\u5f02\u5e38], {}", (Object)"\u53c2\u6570\u4fe1\u606f", (Object)e);
            return false;
        }
    }

    private void updateDiscountUsed(Double discountPrice, String tradeNo, Long payTime, Integer index, OrderDiscount orderDiscount) {
        orderDiscount.setTradeNo(tradeNo);
        orderDiscount.setStatus(Integer.valueOf(1));
        if (index == 0) {
            orderDiscount.setGetAmount(discountPrice);
        } else {
            orderDiscount.setGetAmount(Double.valueOf(BigDecimal.ZERO.doubleValue()));
        }
        orderDiscount.setUseTime(new Date(payTime * 1000L));
        int n2 = this.orderDiscountDao.updateById((Object)orderDiscount);
        log.info("[\u4ea4\u6613\u8bb0\u5f55\u670d\u52a1] \u4fee\u6539\u4f18\u60e0\u5df2\u4f7f\u7528\u72b6\u6001\uff0c\u5f71\u54cd{}\u6761\u8bb0\u5f55\uff0corderNum\uff1a{}, from: {}", new Object[]{n2, orderDiscount.getOrderNum(), orderDiscount.getFrom()});
        this.addDiscountSpaceNum(orderDiscount);
        if ("\u7279\u6765\u7535\u4e92\u8054\u4e92\u901a\u505c\u8f66\u7968".equals(orderDiscount.getDiscountName())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.teldService.consumed(orderDiscount.getId().longValue())));
        }
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderPay>> getOrderPayList(Long parkId, BaseQueryRequest request) {
        Page orderPayPage = PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize()).doSelectPage(() -> this.orderPayDao.getOrderPayList(Long.valueOf(request.getStartTime().getTime() / 1000L), Long.valueOf(request.getEndTime().getTime() / 1000L), parkId));
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)orderPayPage.getPages(), (long)orderPayPage.getTotal(), (List)orderPayPage.getResult()));
    }

    public ObjectResponse<BigDecimal> getTempPayAmount(Long parkId, Long startTime, Long endTime, List<Integer> payType, String plateNumber, Integer paymentType) {
        return ObjectResponse.success((Object)this.orderPayDao.selectTempPayAmount(parkId, startTime, endTime, payType, plateNumber, paymentType));
    }

    public ObjectResponse<Integer> getPayAisle(Long startTime, Long endTime) {
        return ObjectResponse.success((Object)this.orderPayDao.selectPayAisleCount(startTime, endTime));
    }

    @DS_SLAVE
    public ObjectResponse<List<ParkPayReportVo>> getMonthPayList(String startTime, String endTime) {
        List lists = this.orderPayDao.selectMonthPayList(startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)lists)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)lists);
    }

    @DS_SLAVE
    public ObjectResponse<List<ParkPayReportVo>> getYearPayList(String startTime, String endTime) {
        List lists = this.orderPayDao.selectYearPayList(startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)lists)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)lists);
    }

    public boolean useDiscount(Double discountPrice, Long parkId, String tradeNo, Long payTime, String orderNum, OrderDiscount orderDiscount) {
        Long merchantDisId;
        MerchantDiscount merchantDiscount;
        OrderDiscount orderDiscountUpdate = new OrderDiscount();
        if ((orderDiscount.getType() == 1 || orderDiscount.getType() == 4) && (merchantDiscount = this.merchantDiscountDao.findById(merchantDisId = orderDiscount.getMerchantDisId())) != null && merchantDiscount.getDeductType() == 1) {
            ObjectResponse objectResponse;
            orderDiscountUpdate.setDeductMoney(discountPrice);
            orderDiscountUpdate.setGetAmount(discountPrice);
            BigDecimal mchDeductAmount = new BigDecimal(discountPrice);
            if (merchantDiscount.getType() == 1 && merchantDiscount.getDisDeductValue() != null && merchantDiscount.getDisDeductValue() > 0 && merchantDiscount.getDisDeductValue() < 10) {
                mchDeductAmount = mchDeductAmount.multiply(BigDecimal.valueOf(merchantDiscount.getDisDeductValue().intValue(), 1));
            }
            if (!"200".equals((objectResponse = this.merchantUserService.subMerchantMoney(Integer.valueOf(orderDiscount.getMerchantId().intValue()), mchDeductAmount)).getCode())) {
                log.error("[\u7d27\u6025\u9519\u8bef]\u4f18\u60e0\u5ef6\u8fdf\u6263\u9664\u5546\u6237\u4f59\u989d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406,orderNum\uff1a{}\uff0cdiscountNo\uff1a{}", (Object)orderNum, (Object)orderDiscount.getDiscountNo());
                return false;
            }
        }
        orderDiscountUpdate.setId(orderDiscount.getId());
        orderDiscountUpdate.setParkId(parkId);
        orderDiscountUpdate.setOrderNum(orderNum);
        orderDiscountUpdate.setDiscountNo(orderDiscount.getDiscountNo());
        orderDiscountUpdate.setGetAmount(discountPrice);
        orderDiscountUpdate.setTradeNo(tradeNo);
        orderDiscountUpdate.setStatus(Integer.valueOf(1));
        orderDiscountUpdate.setUseTime(new Date(payTime * 1000L));
        int n2 = this.orderDiscountDao.updateById((Object)orderDiscountUpdate);
        log.info("[\u4ea4\u6613\u8bb0\u5f55\u670d\u52a1] \u4fee\u6539\u4f18\u60e0\u5df2\u4f7f\u7528\u72b6\u6001\uff0c\u5f71\u54cd{}\u6761\u8bb0\u5f55\uff0corderNum\uff1a{}, from: {}", new Object[]{n2, orderNum, orderDiscount.getFrom()});
        this.addDiscountSpaceNum(orderDiscount);
        if ("\u7279\u6765\u7535\u4e92\u8054\u4e92\u901a\u505c\u8f66\u7968".equals(orderDiscount.getDiscountName())) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.teldService.consumed(orderDiscount.getId().longValue())));
        }
        return true;
    }

    public ObjectResponse<List<OrderPay>> findList(PageQuery<OrderPay> payPageQuery) {
        if (payPageQuery.getParam() == null) {
            return ObjectResponse.failed((String)"400");
        }
        List orderPays = this.orderPayDao.selectListByPage(payPageQuery);
        return ObjectResponse.success((Object)orderPays);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.incomeCount", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<IncomeCountDto> incomeCount(FlowRequest flowRequest) {
        IncomeCountDto incomeCountDto = this.orderPayDao.incomeCount(flowRequest);
        if (incomeCountDto != null) {
            return ObjectResponse.success((Object)incomeCountDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.incomeDetail", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<IncomeDetailDto>> incomeDetail(FlowRequest flowRequest) {
        List incomeDetailDtos = this.orderPayDao.incomeDetail(flowRequest);
        if (incomeDetailDtos != null) {
            return ObjectResponse.success((Object)incomeDetailDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.payWayCount", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest) {
        return this.payWayCount(flowRequest, 3, null);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.payWayCount2", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest, int day, String month) {
        try {
            IncomeCountDto incomeCountDto;
            flowRequest.setStartTime(Long.valueOf((long)DateTools.phpCurrentDate((Date)new Date()) * 1L));
            if (day == 2) {
                flowRequest.setStartTime(DateRangeUtils.getYesterdayHourTime((int)(24 + DateRangeUtils.getHour((Date)new Date()))));
                flowRequest.setEndTime(Long.valueOf(DateRangeUtils.getYesterdayHourTime((int)DateRangeUtils.getHour((Date)new Date())) - 1L));
            }
            if (day == 7 || day == 30) {
                flowRequest.setStartTime(DateRangeUtils.getDayTime((Integer)day));
                flowRequest.setEndTime(Long.valueOf(DateRangeUtils.getTodayTime() - 1L));
            }
            if (day == 0) {
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date st = f.parse(month + "-01 00:00:00");
                Date en = f.parse(month + "-31 23:59:59");
                flowRequest.setStartTime(Long.valueOf(st.getTime() / 1000L));
                flowRequest.setEndTime(Long.valueOf(en.getTime() / 1000L));
            }
            if ((incomeCountDto = this.orderPayDao.incomeCount(flowRequest)) == null || incomeCountDto.getTotalIncome() == 0.0) {
                return ObjectResponse.failed((String)"404");
            }
            DecimalFormat df = new DecimalFormat("###0.00");
            List<PayWayCountDto> list = this.orderPayDao.payWayCount(flowRequest);
            Double totalIncome = incomeCountDto.getTotalIncome();
            for (PayWayCountDto payWayCountDto : list) {
                payWayCountDto.setRatio(df.format(payWayCountDto.getTotalPayCount() / totalIncome * 100.0) + "%");
            }
            if (list.size() > 0) {
                list = OrderPayServiceImpl.sort(list);
            }
            return ObjectResponse.success((Object)list);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. flowRequest[{}], day[{}], month[{}]", new Object[]{e.getMessage(), flowRequest, day, month, e});
            return ObjectResponse.success();
        }
    }

    private static List<PayWayCountDto> sort(List<PayWayCountDto> list) {
        ArrayList<PayWayCountDto> reulst = new ArrayList<PayWayCountDto>();
        for (int i = 0; i < list.size(); ++i) {
            PayWayCountDto payWayCountDto = list.get(i);
            if (payWayCountDto.getPayWayName().contains("\u652f\u4ed8\u5b9d")) {
                payWayCountDto.setOrder(Integer.valueOf(0));
            } else if (payWayCountDto.getPayWayName().contains("\u5fae\u4fe1")) {
                payWayCountDto.setOrder(Integer.valueOf(1));
            } else {
                payWayCountDto.setOrder(Integer.valueOf(i + 2));
            }
            reulst.add(payWayCountDto);
        }
        Collections.sort(reulst);
        return reulst;
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.countReportPay", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> countReportPay(String parkIds, String startTime, String endTime) {
        try {
            List payWayCountDtos = this.orderPayDao.countReportPay(parkIds, startTime, endTime);
            return ObjectResponse.success((Object)payWayCountDtos);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. parkIds[{}], startTime[{}], endTime[{}]", new Object[]{e.getMessage(), parkIds, startTime, endTime, e});
            return null;
        }
    }

    public ObjectResponse<StoreCardCountDto> countStoreCardReport(List<Long> parkIds, String startTime, String endTime) {
        StoreCardCountDto storeCardCountDto = this.storeCardDao.countStoreCarReport(parkIds, startTime, endTime);
        storeCardCountDto.setStoreCardTotalCount(Double.valueOf(storeCardCountDto.getRenewstoreCardMoney() + storeCardCountDto.getAddstoreCardMoney()));
        return ObjectResponse.success((Object)storeCardCountDto);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.parkIncomeTop", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<ParkIncomeTopDto>> parkIncomeTop(ParkIncomeTopRequest parkIncomeTopRequest) {
        List list = this.orderPayDao.parkIncomeTop(parkIncomeTopRequest);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success((Object)list);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.paywayTop", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<PaywayTopDto>> paywayTop(PaywayTopRequest paywayTopRequest) {
        List list = this.orderPayDao.paywayTop(paywayTopRequest);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success((Object)list);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.countTodayIncome", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<IncomeCountHourDto>> countTodayIncome(String parkIdList) {
        List incomeCountHourDtos = this.orderPayDao.countTodayIncome(parkIdList, DateRangeUtils.getTodayTime());
        List currentHours = DateRangeUtils.getCurrentHours();
        ArrayList resDtos = Lists.newArrayList();
        currentHours.forEach(s -> {
            IncomeCountHourDto resDto = new IncomeCountHourDto();
            resDto.setTimeRange(s + ":00-" + (s + 1) + ":00");
            if (CollectionUtils.isEmpty((Collection)incomeCountHourDtos)) {
                resDto.setTotalPaidPrice(BigDecimal.ZERO);
            } else {
                IncomeCountHourDto findDto = incomeCountHourDtos.stream().filter(incomeCountHourDto -> Integer.valueOf(incomeCountHourDto.getTimeRange()).equals(s)).findFirst().orElse(null);
                if (Objects.nonNull(findDto)) {
                    resDto.setTotalPaidPrice(findDto.getTotalPaidPrice());
                } else {
                    resDto.setTotalPaidPrice(BigDecimal.ZERO);
                }
            }
            resDtos.add(resDto);
        });
        return ObjectResponse.success((Object)resDtos);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.count24HoursIncome", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<IncomeCountHourDto>> count24HoursIncome(String parkIdList) {
        List incomeCountHourDtos = this.orderPayDao.countTodayIncome(parkIdList, DateRangeUtils.get24HourTime());
        List hours = DateRangeUtils.get24Hours();
        ArrayList resDtos = Lists.newArrayList();
        hours.forEach(s -> {
            IncomeCountHourDto resDto = new IncomeCountHourDto();
            resDto.setTimeRange(s + ":00-" + (s + 1) + ":00");
            if (CollectionUtils.isEmpty((Collection)incomeCountHourDtos)) {
                resDto.setTotalPaidPrice(BigDecimal.ZERO);
            } else {
                IncomeCountHourDto findDto = incomeCountHourDtos.stream().filter(incomeCountHourDto -> Integer.valueOf(incomeCountHourDto.getTimeRange()).equals(s)).findFirst().orElse(null);
                if (Objects.nonNull(findDto)) {
                    resDto.setTotalPaidPrice(findDto.getTotalPaidPrice());
                } else {
                    resDto.setTotalPaidPrice(BigDecimal.ZERO);
                }
            }
            resDtos.add(resDto);
        });
        return ObjectResponse.success((Object)resDtos);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.countTemPayType", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderPayWayDto>> countTemPayType(String parkIds, Integer day, String pointMonth) {
        ArrayList<OrderPayWayDto> list = new ArrayList<OrderPayWayDto>();
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date startTime = new Date();
            Date endTime = new Date();
            if (day != 0) {
                List<String> daysMultiformat = new ArrayList();
                if (day == 2) {
                    daysMultiformat = DateRangeUtils.getDaysMultiformat((Integer)1, (int)1);
                    startTime = sf.parse((String)daysMultiformat.get(0) + " 00:00:00");
                    endTime = sf.parse((String)daysMultiformat.get(daysMultiformat.size() - 1) + " 23:59:59");
                } else if (day == 3) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                    String format = simpleDateFormat.format(new Date());
                    daysMultiformat.add(format);
                    startTime = sf.parse(format + " 00:00:00");
                } else {
                    daysMultiformat = DateRangeUtils.getDaysMultiformat((Integer)day, (int)1);
                    startTime = sf.parse((String)daysMultiformat.get(0) + " 00:00:00");
                    endTime = sf.parse((String)daysMultiformat.get(daysMultiformat.size() - 1) + " 23:59:59");
                }
                for (int i = 0; i < daysMultiformat.size(); ++i) {
                    String date = (String)daysMultiformat.get(i);
                    OrderPayWayDto orderPayWayDto = new OrderPayWayDto();
                    orderPayWayDto.setPayTime(date);
                    list.add(orderPayWayDto);
                }
            } else {
                String month = pointMonth;
                String[] split = pointMonth.split("-");
                int integer = Integer.valueOf(split[1]);
                Calendar cal = Calendar.getInstance();
                int nowmonth = cal.get(2) + 1;
                int days = cal.get(5);
                if (integer != nowmonth) {
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    days = DateRangeUtils.getDaysOfMonth((Date)sdf1.parse(month + "-01"));
                }
                for (int i = 1; i < days; ++i) {
                    OrderPayWayDto orderPayWayDto = new OrderPayWayDto();
                    if (i < 10) {
                        orderPayWayDto.setPayTime(split[0] + "/" + split[1] + "/0" + i);
                    } else {
                        orderPayWayDto.setPayTime(split[0] + "/" + split[1] + "/" + i);
                    }
                    list.add(orderPayWayDto);
                }
                startTime = sf.parse(split[0] + "/" + split[1] + "/01 00:00:00");
                endTime = sf.parse(split[0] + "/" + split[1] + "/31 23:59:59");
            }
            ArrayList<Integer> type = new ArrayList<Integer>();
            type.add(1);
            List orderPayDtos = this.orderPayDao.selectOrderPayList(parkIds, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), null, null, null, null, type, null, null);
            orderPayDtos.forEach(orderPayDto -> {
                Date payTime = orderPayDto.getPayTime();
                Integer payWay = orderPayDto.getPayWay();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                String format = sdf.format(payTime);
                DecimalFormat df = new DecimalFormat("#.00");
                for (int i = 0; i < list.size(); ++i) {
                    OrderPayWayDto orderPayWayDto = (OrderPayWayDto)list.get(i);
                    if (!orderPayWayDto.getPayTime().equals(format)) continue;
                    if (payWay == 1) {
                        orderPayWayDto.setCashPrice(NumberUtils.decimalAdd((Object)orderPayWayDto.getCashPrice(), (Object[])new Object[]{orderPayDto.getPaidPrice()}).doubleValue());
                        continue;
                    }
                    if (payWay == 2) {
                        orderPayWayDto.setWxPrice(NumberUtils.decimalAdd((Object)orderPayWayDto.getWxPrice(), (Object[])new Object[]{orderPayDto.getPaidPrice()}).doubleValue());
                        continue;
                    }
                    if (payWay == 3) {
                        orderPayWayDto.setAliPrice(NumberUtils.decimalAdd((Object)orderPayWayDto.getAliPrice(), (Object[])new Object[]{orderPayDto.getPaidPrice()}).doubleValue());
                        continue;
                    }
                    if (payWay == 4) {
                        orderPayWayDto.setBankPrice(NumberUtils.decimalAdd((Object)orderPayWayDto.getBankPrice(), (Object[])new Object[]{orderPayDto.getPaidPrice()}).doubleValue());
                        continue;
                    }
                    orderPayWayDto.setOtherPrice(NumberUtils.decimalAdd((Object)orderPayWayDto.getOtherPrice(), (Object[])new Object[]{orderPayDto.getPaidPrice()}).doubleValue());
                }
            });
            return ObjectResponse.success(list);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. parkIds[{}], day[{}], pointMonth[{}]", new Object[]{e.getMessage(), parkIds, day, pointMonth, e});
            return null;
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getOrderPayList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<OrderPayDto>> getOrderPayList(OrderPayQueryRequest orderPayQueryRequest) {
        try {
            String parkCode = orderPayQueryRequest.getParkCode();
            Date startTime = orderPayQueryRequest.getStartTime();
            Date endTime = orderPayQueryRequest.getEndTime();
            String plateNumber = orderPayQueryRequest.getPlateNumber();
            List payWay = orderPayQueryRequest.getPayWay();
            String userName = orderPayQueryRequest.getUserName();
            List payChannel = orderPayQueryRequest.getPayChannel();
            List type = orderPayQueryRequest.getType();
            String orderNum = orderPayQueryRequest.getOrderNum();
            Integer payType = orderPayQueryRequest.getPayType();
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            PageHelper.startPage((int)orderPayQueryRequest.getPageNo(), (int)orderPayQueryRequest.getPageSize());
            List records = this.orderPayDao.selectOrderPayList(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, payWay, userName, payChannel, type, orderNum, payType);
            if (CollectionUtils.isEmpty((Collection)records)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            records.forEach(orderPayDto -> {
                if (orderPayDto.getEnterTimeLong() != null && orderPayDto.getPayTime() != null) {
                    long payTime = orderPayDto.getPayTime().getTime() / 1000L;
                    long parkTime = orderPayDto.getLastPayTime() != null ? payTime - orderPayDto.getLastPayTime() : (Integer.valueOf(1).equals(orderPayDto.getPayType()) ? orderPayDto.getExitTimeLong() - orderPayDto.getEnterTimeLong() : payTime - orderPayDto.getEnterTimeLong());
                    orderPayDto.setParkTime(Long.valueOf(parkTime));
                    orderPayDto.setParkTimeStr(DateTools.secondToSecondsTime((int)((int)parkTime)));
                }
            });
            List orderNums = records.stream().map(OrderPayDto::getOrderNum).collect(Collectors.toList());
            List carInfos = this.orderCarInfoDao.selectList((Wrapper)Wrappers.lambdaQuery(OrderCarInfo.class).select(new SFunction[]{OrderCarInfo::getOrderNum, OrderCarInfo::getEnterImage, OrderCarInfo::getEnterNo}).in(OrderCarInfo::getOrderNum, orderNums));
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)carInfos)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            Map orderCarInfoMap = carInfos.stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum, Function.identity()));
            records.forEach(record -> {
                OrderCarInfo orderCarInfo = (OrderCarInfo)orderCarInfoMap.get(record.getOrderNum());
                if (orderCarInfo != null) {
                    if (com.icetech.common.utils.StringUtils.isNotBlank((CharSequence)orderCarInfo.getEnterImage())) {
                        record.setImgUrl(this.ossService.getImageUrl(orderCarInfo.getEnterImage()));
                    }
                    record.setEnterName(orderCarInfo.getEnterNo());
                }
            });
            return ObjectResponse.success((Object)records);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u8ba2\u5355\u63a5\u53e3]\u5904\u7406\u5931\u8d25: {}. orderPayQueryRequest[{}]", new Object[]{e.getMessage(), orderPayQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.countOrderPayList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countOrderPayList(OrderPayQueryRequest orderPayQueryRequest) {
        try {
            String parkCode = orderPayQueryRequest.getParkCode();
            Date startTime = orderPayQueryRequest.getStartTime();
            Date endTime = orderPayQueryRequest.getEndTime();
            String plateNumber = orderPayQueryRequest.getPlateNumber();
            List payWay = orderPayQueryRequest.getPayWay();
            String userName = orderPayQueryRequest.getUserName();
            List payChannel = orderPayQueryRequest.getPayChannel();
            List type = orderPayQueryRequest.getType();
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            int records = this.orderPayDao.countOrderPayList(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, payWay, userName, type, payChannel, orderPayQueryRequest.getPayType());
            BigDecimal paidPrice = this.orderPayDao.sumOrderPayList(parkid, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L), plateNumber, payWay, userName, type, payChannel, orderPayQueryRequest.getPayType());
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("count", records);
            map.put("paidPrice", paidPrice);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u8ba2\u5355]\u5904\u7406\u5931\u8d25: {}. parkCode[{}]", new Object[]{e.getMessage(), orderPayQueryRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<OrderPayDto> getOrderPayDetail(String parkCode, Integer recordId, String tradeNo) {
        try {
            if (recordId == null && com.icetech.common.utils.StringUtils.isBlank((CharSequence)tradeNo)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
            }
            OrderPay orderPay = new OrderPay();
            orderPay.setId(recordId == null ? null : Long.valueOf(recordId.intValue()));
            orderPay.setTradeNo(com.icetech.common.utils.StringUtils.isBlank((CharSequence)tradeNo) ? null : tradeNo);
            orderPay = (OrderPay)this.orderPayDao.selectLimitOne((Object)orderPay);
            OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(orderPay.getOrderNum());
            if (orderInfo == null) {
                return ObjectResponse.failed((String)"404", (String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355");
            }
            OrderPayDto orderPayDto = new OrderPayDto();
            orderPayDto.setId(Integer.valueOf(Math.toIntExact(orderPay.getId())));
            orderPayDto.setPlateNumber(orderInfo.getPlateNum());
            orderPayDto.setType(orderInfo.getType());
            orderPayDto.setCarType(orderInfo.getCarType());
            orderPayDto.setPayTime(new Date(orderPay.getPayTime() * 1000L));
            orderPayDto.setOrderNum(orderPay.getOrderNum());
            orderPayDto.setTradeNo(orderPay.getTradeNo());
            orderPayDto.setPayWay(orderPay.getPayWay());
            orderPayDto.setPayChannel(orderPay.getPayChannel());
            orderPayDto.setTotalPrice(orderPay.getTotalPrice());
            orderPayDto.setPaidPrice(orderPay.getPaidPrice());
            orderPayDto.setDiscountPrice(orderPay.getDiscountPrice());
            orderPayDto.setUserAccount(orderPay.getUserAccount());
            orderPayDto.setPayTerminal(orderPay.getPayTerminal());
            orderPayDto.setRedPackage(Double.valueOf(orderPay.getRedpackRet()));
            orderPayDto.setPayType(orderPay.getPayType());
            if (Objects.nonNull(orderPay.getBalancePrice())) {
                orderPayDto.setStoreCardPrice(Double.valueOf(orderPay.getBalancePrice().doubleValue()));
            }
            orderPayDto.setEnterTime(DateTools.getFormat((long)(orderInfo.getEnterTime() * 1000L)));
            if (orderInfo.getExitTime() != null) {
                orderPayDto.setExitTime(DateTools.getFormat((long)(orderInfo.getExitTime() * 1000L)));
            }
            Long parkTime = 0L;
            if (orderPayDto.getPayType() != null && orderPay.getPayType() == 1) {
                parkTime = orderInfo.getExitTime() - orderInfo.getEnterTime();
            } else if (Objects.nonNull(orderPay.getPayTime()) && Objects.nonNull(orderInfo.getEnterTime())) {
                Long payTime = orderPay.getPayTime();
                parkTime = Objects.nonNull(orderPay.getLastPayTime()) ? Long.valueOf(payTime - orderPay.getLastPayTime()) : Long.valueOf(payTime - orderInfo.getEnterTime());
            }
            orderPayDto.setParkTime(parkTime);
            orderPayDto.setParkTimeStr(DateTools.secondToSecondsTime((int)Math.toIntExact(parkTime)));
            Park park = (Park)this.parkService.findByParkId(orderInfo.getParkId()).getData();
            orderPayDto.setParkName(park.getParkName());
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            if (carInfo != null) {
                orderPayDto.setEnterName(carInfo.getEnterNo());
                orderPayDto.setExitName(carInfo.getExitNo());
                orderPayDto.setImgUrl(this.ossService.getImageUrl(carInfo.getEnterImage()));
            }
            return ObjectResponse.success((Object)orderPayDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5]\u5904\u7406\u5931\u8d25: {}. parkCode[{}], recordId[{}], tradeNo[{}]", new Object[]{e.getMessage(), parkCode, recordId, tradeNo, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<OrderSumFeeDto> getSumFee(String parkCode, String orderNum) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderNum);
        orderPay.setParkId(park.getId());
        OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
        if (Objects.isNull(orderSumFeeDto)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)orderSumFeeDto);
    }

    public ObjectResponse<OrderSumFeeDto> getSumPay(OrderPayCondition orderPayCondition) {
        OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumPay(orderPayCondition);
        if (orderSumFeeDto != null) {
            return ObjectResponse.success((Object)orderSumFeeDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.sumOrderPay", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<SumOrderPayDto> sumOrderPay(SumOrderPayRequest sumOrderPayRequest) {
        SumOrderPayDto sumOrderPayDto = this.orderPayDao.sumOrderPay(sumOrderPayRequest);
        if (sumOrderPayDto != null) {
            return ObjectResponse.success((Object)sumOrderPayDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.summaryReportPay", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<SumOrderPayDto> summaryReportPay(String parkIds, String startTime, String endTime) {
        SumOrderPayDto sumOrderPayDto = this.orderPayDao.summaryReportPay(parkIds, startTime, endTime);
        if (sumOrderPayDto != null) {
            BigDecimal totalPrice = sumOrderPayDto.getPaidPrice().add(sumOrderPayDto.getDiscountPrice());
            sumOrderPayDto.setTotalPrice(totalPrice);
            return ObjectResponse.success((Object)sumOrderPayDto);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.sumOrderPayMtype", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<SumOrderDatePayDto>> sumOrderPayMtype(BossOrderPayRequest bossOrderPayRequest) {
        ArrayList<SumOrderDatePayDto> list = new ArrayList<SumOrderDatePayDto>();
        try {
            if (bossOrderPayRequest.getDay() != 0) {
                List daysMultiformat = DateRangeUtils.getDaysMultiformat((Integer)bossOrderPayRequest.getDay(), (int)1);
                for (int i = 0; i < daysMultiformat.size(); ++i) {
                    String date = (String)daysMultiformat.get(i);
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    sumOrderDatePayDto.setPayTime(date);
                    list.add(sumOrderDatePayDto);
                }
                SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                bossOrderPayRequest.setPayTimeStart(((SumOrderDatePayDto)list.get(0)).getPayTime());
                bossOrderPayRequest.setPayTimeEnd(((SumOrderDatePayDto)list.get(list.size() - 1)).getPayTime());
            } else if (!Objects.isNull(bossOrderPayRequest.getStartYear())) {
                int i;
                Integer startYear = bossOrderPayRequest.getStartYear();
                Integer endYear = bossOrderPayRequest.getEndYear();
                ArrayList year = new ArrayList();
                for (i = startYear.intValue(); i <= endYear; ++i) {
                    List months = DateRangeUtils.getMonths((int)i);
                    year.addAll(months);
                }
                for (i = 0; i < year.size(); ++i) {
                    String date = (String)year.get(i);
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    sumOrderDatePayDto.setPayTime(date);
                    list.add(sumOrderDatePayDto);
                }
                bossOrderPayRequest.setPayTimeStart(((SumOrderDatePayDto)list.get(0)).getPayTime() + "/01");
                bossOrderPayRequest.setPayTimeEnd(((SumOrderDatePayDto)list.get(list.size() - 1)).getPayTime() + "/31");
            } else {
                String month = bossOrderPayRequest.getMonth();
                String[] split = month.split("-");
                int integer = Integer.valueOf(split[1]);
                Calendar cal = Calendar.getInstance();
                int nowmonth = cal.get(2) + 1;
                int day = cal.get(5);
                if (integer != nowmonth) {
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    day = DateRangeUtils.getDaysOfMonth((Date)sdf1.parse(month + "-01"));
                }
                for (int i = 1; i < day; ++i) {
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    if (i < 10) {
                        sumOrderDatePayDto.setPayTime(split[0] + "/" + split[1] + "/0" + i);
                    } else {
                        sumOrderDatePayDto.setPayTime(split[0] + "/" + split[1] + "/" + i);
                    }
                    list.add(sumOrderDatePayDto);
                }
                bossOrderPayRequest.setPayTimeStart(((SumOrderDatePayDto)list.get(0)).getPayTime());
                bossOrderPayRequest.setPayTimeEnd(((SumOrderDatePayDto)list.get(list.size() - 1)).getPayTime());
                bossOrderPayRequest.setDay(Integer.valueOf(1));
            }
            List sumOrderDatePayDtos = this.orderPayDao.sumOrderPayListCount(bossOrderPayRequest);
            for (int i = 0; i < list.size(); ++i) {
                SumOrderDatePayDto sumOrderDatePayDto = (SumOrderDatePayDto)list.get(i);
                String time = sumOrderDatePayDto.getPayTime();
                for (int j = 0; j < sumOrderDatePayDtos.size(); ++j) {
                    SumOrderDatePayDto sumOrderDatePayDto1 = (SumOrderDatePayDto)sumOrderDatePayDtos.get(j);
                    String time1 = sumOrderDatePayDto1.getPayTime();
                    if (!time1.equals(time)) continue;
                    sumOrderDatePayDto.setTotalPrice(sumOrderDatePayDto1.getTotalPrice());
                    sumOrderDatePayDto.setPaidPrice(sumOrderDatePayDto1.getPaidPrice());
                    sumOrderDatePayDto.setDiscountPrice(sumOrderDatePayDto1.getDiscountPrice());
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. bossOrderPayRequest[{}]", new Object[]{e.getMessage(), bossOrderPayRequest, e});
        }
        return ObjectResponse.success(list);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getInvoiceList(InvoiceRequest invoiceRequest) {
        if (invoiceRequest.getParkCode() == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8f66\u573a\u7f16\u53f7\u5fc5\u4f20");
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(invoiceRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            return ObjectResponse.failed((String)"400");
        }
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(invoiceRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)parkConfigObjectResponse)) {
            return ObjectResponse.failed((String)"400");
        }
        PageHelper.startPage((int)invoiceRequest.getPageNo(), (int)invoiceRequest.getPageSize());
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        Integer parkingInvoiceDays = parkConfig.getParkingInvoiceDays();
        if (parkingInvoiceDays == null) {
            parkingInvoiceDays = 365;
        }
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-parkingInvoiceDays.intValue()));
        Long startTime = startDate.getTime() / 1000L;
        Long endTime = DateTools.unixTimestamp();
        List responseList = this.orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName((Date)startDate), invoiceRequest.getPlateNums(), null, ((Park)parkObjectResponse.getData()).getId(), null, startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)responseList)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u6682\u65f6\u672a\u627e\u5230\u5f00\u7968\u8bb0\u5f55");
        }
        return ObjectResponse.success((Object)responseList);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getMpInvoiceList(InvoiceRequest invoiceRequest) {
        List<InvoiceMerchantPark> invoiceMerchantParks = this.invoiceMerchantParkDao.selectAll();
        if (CollectionUtils.isEmpty(invoiceMerchantParks)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u5f53\u524d\u6ca1\u6709\u53ef\u4ee5\u5f00\u53d1\u7968\u7684\u8f66\u573a");
        }
        Set parkIds = invoiceMerchantParks.stream().map(merchantPark -> (long)merchantPark.getParkId()).collect(Collectors.toSet());
        try (Page page = PageHelper.startPage((int)invoiceRequest.getPageNo(), (int)invoiceRequest.getPageSize());){
            DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-365);
            Long startTime = startDate.getTime() / 1000L;
            Long endTime = DateTools.unixTimestamp();
            List responseList = this.orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName((Date)startDate), invoiceRequest.getPlateNums(), null, null, parkIds, startTime, endTime);
            if (CollectionUtils.isEmpty((Collection)responseList)) {
                ObjectResponse objectResponse = ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u6682\u65f6\u672a\u627e\u5230\u5f00\u7968\u8bb0\u5f55");
                return objectResponse;
            }
            ObjectResponse objectResponse = ObjectResponse.success((Object)responseList);
            return objectResponse;
        }
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getInvoiceListV2(InvoiceRequest invoiceRequest) {
        Long parkId = null;
        if (StringUtils.isNotEmpty((CharSequence)invoiceRequest.getParkCode())) {
            parkId = ((Park)this.parkService.findByParkCode(invoiceRequest.getParkCode()).getData()).getId();
        }
        PageHelper.startPage((int)invoiceRequest.getPageNo(), (int)invoiceRequest.getPageSize());
        List responseList = this.orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName((Date)invoiceRequest.getStartTime()), null, invoiceRequest.getAccountId(), parkId, null, Long.valueOf(DateUtil.beginOfDay((Date)invoiceRequest.getStartTime()).getTime() / 1000L), Long.valueOf(DateUtil.beginOfDay((Date)invoiceRequest.getEndTime()).getTime() / 1000L));
        if (CollectionUtil.isNotEmpty((Collection)responseList)) {
            responseList.forEach(item -> {
                ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(item.getParkId()).getData();
                if (parkConfig.getIsInvoice() == 2) {
                    item.setInvoice(Boolean.FALSE);
                    item.setReason("\u8f66\u573a\u7ba1\u7406\u65b9\u672a\u5f00\u901a\u7ebf\u4e0a\u5f00\u7968\u670d\u52a1\uff0c\u65e0\u6cd5\u5f00\u7968");
                } else {
                    Integer parkingInvoiceDays = parkConfig.getParkingInvoiceDays();
                    if (parkingInvoiceDays != null) {
                        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-parkingInvoiceDays.intValue()));
                        if (item.getPayTime() < startDate.getTime() / 1000L) {
                            item.setInvoice(Boolean.FALSE);
                            item.setReason(String.format("\u8be5\u8f66\u573a\u7ba1\u7406\u8bbe\u7f6e\u4e86\uff0c\u4e34\u505c\u652f\u4ed8\u652f\u6301\u5f00\u5177%s\u5929\u5185\u7684\u652f\u4ed8\u8bb0\u5f55", parkingInvoiceDays));
                        }
                    }
                }
            });
        }
        return ObjectResponse.success((Object)responseList);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceParkList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<InvoiceParksDto>> getInvoiceParkList(InvoiceRequest invoiceRequest) {
        List responseList;
        List<InvoiceMerchantPark> invoiceMerchantParks = this.invoiceMerchantParkDao.selectAll();
        if (CollectionUtils.isEmpty(invoiceMerchantParks)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u5f53\u524d\u6ca1\u6709\u53ef\u4ee5\u5f00\u53d1\u7968\u7684\u8f66\u573a");
        }
        List parkIds = invoiceMerchantParks.stream().map(InvoiceMerchantPark::getParkId).collect(Collectors.toList());
        Long startTime = null;
        Long endTime = null;
        if (Objects.nonNull(invoiceRequest.getStartTime())) {
            startTime = invoiceRequest.getStartTime().getTime() / 1000L;
        }
        if (Objects.nonNull(invoiceRequest.getEndTime())) {
            endTime = invoiceRequest.getEndTime().getTime() / 1000L;
        }
        if (CollectionUtils.isEmpty((Collection)(responseList = this.orderPayDao.selectNoInvoiceParkListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName((Date)invoiceRequest.getStartTime()), invoiceRequest.getPlateNums(), invoiceRequest.getAccountId(), null, parkIds, startTime, endTime)))) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u6682\u65f6\u672a\u627e\u5230\u53ef\u5f00\u7968\u8f66\u573a");
        }
        return ObjectResponse.success((Object)responseList);
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceParkList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<List<InvoiceParksDto>> getInvoiceParkListV2(InvoiceRequest invoiceRequest) {
        List responseList;
        Long startTime = null;
        Long endTime = null;
        if (Objects.nonNull(invoiceRequest.getStartTime())) {
            startTime = invoiceRequest.getStartTime().getTime() / 1000L;
        }
        if (Objects.nonNull(invoiceRequest.getEndTime())) {
            endTime = invoiceRequest.getEndTime().getTime() / 1000L;
        }
        if (CollectionUtils.isEmpty((Collection)(responseList = this.orderPayDao.selectNoInvoiceParkListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName((Date)invoiceRequest.getStartTime()), null, invoiceRequest.getAccountId(), null, Collections.emptyList(), startTime, endTime)))) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u6682\u65f6\u672a\u627e\u5230\u53ef\u5f00\u7968\u8f66\u573a");
        }
        return ObjectResponse.success((Object)responseList);
    }

    public ObjectResponse<OrderPay> getByTradeNo(String tradeNo) {
        OrderPay orderPay = (OrderPay)this.orderPayDao.selectLimitOne((LambdaQueryWrapper)this.getLambdaQueryWrapper().eq(OrderPay::getTradeNo, (Object)tradeNo));
        return ObjectResponse.returnNotFoundIfNull((Object)orderPay);
    }

    public ObjectResponse<List<OrderPay>> getListByTradeNos(List<String> tradeNos) {
        List payList = this.orderPayDao.selectListByTradeNos(tradeNos);
        return ObjectResponse.success((Object)payList);
    }

    public ObjectResponse<List<OrderPay>> getListWithHistoryByTradeNos(List<String> tradeNos) {
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-365);
        List payList = this.orderPayDao.selectListWithHistoryByTradeNos(DateRangeUtils.getYearQuarterRangeTableName((Date)startDate), tradeNos);
        return ObjectResponse.returnNotFoundIfEmpty((Collection)payList);
    }

    public ObjectResponse<Void> batchUpdateInvoiceStatus(List<String> tradeNos) {
        block1: {
            String table;
            int count = this.orderPayDao.updateInvoiceStatus(tradeNos);
            if (tradeNos.size() == count) break block1;
            log.info("\u51c6\u5907\u66f4\u65b0\u5386\u53f2\u8868\u5f00\u7968\u72b6\u6001, tradeNos[{}]", tradeNos);
            DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)-365);
            List list = DateRangeUtils.getYearQuarterRangeTableName((Date)startDate);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (count += this.orderPayDao.updateHistoryInvoiceStatus(table = (String)iterator.next(), tradeNos)) < tradeNos.size()) {
            }
        }
        return ObjectResponse.success();
    }

    @DS_SLAVE
    @SentinelResource(value="OrderPayService.getInvoiceList2", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<PageResult<List<InvoiceQueryResponse>>> getInvoiceList(InvoiceQueryRequest invoiceRequest) {
        Page page = PageHelper.startPage((int)invoiceRequest.getPageNo(), (int)invoiceRequest.getPageSize());
        List responseList = this.orderPayDao.selectInvoiceListByPlateNum(Integer.valueOf(3), invoiceRequest.getPlateNum(), invoiceRequest.getStartTime(), invoiceRequest.getEndTime(), invoiceRequest.getTicketStatuses());
        if (CollectionUtils.isEmpty((Collection)responseList)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u6682\u65f6\u672a\u627e\u5230\u5f00\u7968\u8bb0\u5f55");
        }
        return ObjectResponse.success((Object)new PageResult(page, responseList));
    }

    public boolean addDiscountSpaceNum(OrderDiscount orderDiscount) {
        try {
            if (orderDiscount.getMerchantId() == null || orderDiscount.getFrom().equals(2)) {
                return Boolean.TRUE;
            }
            Integer type = orderDiscount.getType();
            if (DiscountTypeEnum.\u6309\u5929\u4f18\u514d.getType().equals(type)) {
                return Boolean.TRUE;
            }
            ParkMerchant parkMerchant = new ParkMerchant();
            parkMerchant.setId(Integer.valueOf(Math.toIntExact(orderDiscount.getMerchantId())));
            parkMerchant = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
            Integer spaceNum = parkMerchant.getSpaceNum();
            if (Objects.isNull(spaceNum)) {
                return true;
            }
            Integer n = spaceNum;
            Integer n2 = spaceNum = Integer.valueOf(spaceNum + 1);
            parkMerchant.setSpaceNum(spaceNum);
            log.info("\u5f53\u524d\u5546\u6237[{}]\u91ca\u653e\u540e\u8f66\u4f4d\u6570[{}]", (Object)parkMerchant.getName(), (Object)parkMerchant.getSpaceNum());
            this.parkMerchantDao.update((Object)parkMerchant);
            return true;
        }
        catch (Exception e) {
            log.error("[\u91ca\u653e\u7a7a\u8f66\u4f4d]\u5904\u7406\u5931\u8d25: {}. orderDiscount[{}]", new Object[]{e.getMessage(), orderDiscount, e});
            return false;
        }
    }

    public ObjectResponse<List<OrderPay>> getOrderPayListBy(Long parkId, List<String> orderNums, Integer payStatus) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(OrderPay.class);
        if (Objects.nonNull(parkId)) {
            queryWrapper.eq(OrderPay::getParkId, (Object)parkId);
        }
        if (CollectionUtils.isNotEmpty(orderNums)) {
            queryWrapper.in(OrderPay::getOrderNum, orderNums);
        }
        if (Objects.nonNull(payStatus)) {
            queryWrapper.eq(OrderPay::getPayStatus, (Object)payStatus);
        } else {
            queryWrapper.eq(OrderPay::getPayStatus, (Object)2);
        }
        List orderPays = this.orderPayDao.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)orderPays)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)orderPays);
    }

    public int updateStatus(OrderPayQuery orderPayQuery) {
        return this.orderPayDao.updateStatus(orderPayQuery);
    }

    private int convertRoadPayWay(Integer parkPayWay) {
        if (PayWayContants.CASH.equals(parkPayWay)) {
            return PayWayConstant.CASH;
        }
        if (PayWayContants.WECHAT.equals(parkPayWay)) {
            return PayWayConstant.WECHAT;
        }
        if (PayWayContants.ALIPAY.equals(parkPayWay)) {
            return PayWayConstant.ALIPAY;
        }
        if (PayWayContants.UNIONPAY.equals(parkPayWay)) {
            return PayWayConstant.UNION_PAY;
        }
        if (PayWayContants.ETC.equals(parkPayWay)) {
            return PayWayConstant.ETC_PAY;
        }
        return PayWayConstant.OTHER;
    }

    private int convertRoadPayChannel(Integer parkPayChannel) {
        if (parkPayChannel == null) {
            return PayChannelConstant.OTHER;
        }
        if (parkPayChannel == 2) {
            return PayChannelConstant.H5_QRCODE;
        }
        if (parkPayChannel == 9) {
            return PayChannelConstant.WECHAT_OFFICIAL_ACCOUNT;
        }
        return PayChannelConstant.OTHER;
    }

    private int convertRoadPayAlias(Integer parkPayAlias) {
        if (PayAisleEnum.WX.getType().equals(parkPayAlias)) {
            return PayAisleConstant.WECHAT;
        }
        if (PayAisleEnum.ALI.getType().equals(parkPayAlias)) {
            return PayAisleConstant.ALIPAY;
        }
        return PayAisleConstant.OTHER;
    }
}

