/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.query.OrderPayQuery;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.response.QueryFeeRegionDetail;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PayChannelConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDetail;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.OrderPayDiscountService;
import com.icetech.order.service.impl.OrderDiscountServiceImpl;
import com.icetech.order.service.impl.OrderPayDetailServiceImpl;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.order.impl.OrderPayServiceImpl;
import com.icetech.paycenter.domain.PlatformPayType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExitPayDealServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ExitPayDealServiceImpl.class);
    @Autowired
    private OrderPayServiceImpl orderPayService;
    @Autowired
    private OrderPayDetailServiceImpl orderPayDetailService;
    @Autowired
    private OrderDiscountServiceImpl orderDiscountService;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private StoreCardService storeCardService;
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private OrderPayDiscountService orderPayDiscountService;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private RabbitSender rabbitSender;
    @Value(value="${aisle.applyCarVideo.time:30}")
    private Integer aisleApplyCarVideoTime;

    public void handleNotPayOrder(ExitCommonRequest exitRequest, OrderInfo orderInfo, ParkInoutdevice channel, String parkCode) {
        boolean otherChannelNotPay;
        ObjectResponse parkObjectResponse;
        if (parkCode == null && (parkObjectResponse = this.parkService.findByParkId(orderInfo.getParkId())).getData() != null) {
            parkCode = ((Park)parkObjectResponse.getData()).getParkCode();
        }
        Integer notPayStatus = exitRequest.getNotPayStatus();
        OrderNotpay orderNotpay = (OrderNotpay)this.orderNotpayService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(OrderNotpay::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderNotpay::getStatus, (Object)1));
        boolean bl = otherChannelNotPay = orderNotpay != null && !channel.getId().equals(orderNotpay.getChannelId());
        if (otherChannelNotPay || Integer.valueOf(1).equals(notPayStatus)) {
            log.info("[\u6b20\u8d39\u8ffd\u7f34]\u8ba2\u5355\u4e0a\u62a5,\u8f66\u724c\u53f7[{}],\u8ba2\u5355\u53f7[{}],\u4e0a\u62a5\u7684\u6b20\u8d39\u8ba2\u5355\u5e94\u6536\u91d1\u989d[{}], \u4e0a\u62a5\u6b20\u8d39\u8ba2\u5355\u4f18\u60e0\u91d1\u989d[{}],\u4e0a\u62a5\u7684\u6b20\u8d39\u8ba2\u5355\u9700\u652f\u4ed8\u91d1\u989d[{}];\u8ba2\u5355\u5e94\u6536\u91d1\u989d[{}],\u8ba2\u5355\u7684\u4f18\u60e0\u91d1\u989d[{}],\u8ba2\u5355\u9700\u652f\u4ed8\u91d1\u989d[{}]", new Object[]{exitRequest.getPlateNum(), orderInfo.getOrderNum(), exitRequest.getNotPayTotalPrice(), exitRequest.getNotPayDiscountPrice(), exitRequest.getNotPayUnpayPrice(), orderInfo.getTotalPrice(), orderInfo.getDiscountPrice(), orderInfo.getPaidPrice()});
            String serialNumber = this.morCacheHandle.getSerialNumber(parkCode, channel.getInandoutCode());
            String videoId = CodeTools.getCharAndNumr((int)16);
            if (serialNumber == null) {
                if (Objects.isNull(orderNotpay)) {
                    List pays;
                    OrderNotpay notPay = new OrderNotpay();
                    notPay.setOrderNum(orderInfo.getOrderNum());
                    notPay.setParkId(exitRequest.getParkId());
                    notPay.setPlateNum(exitRequest.getPlateNum());
                    notPay.setType(exitRequest.getType());
                    notPay.setEnterTime(NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0 ? orderInfo.getEnterTime() : null);
                    notPay.setExitTime(exitRequest.getExitTime());
                    notPay.setCarType(exitRequest.getCarType());
                    notPay.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice())).setScale(2, 4));
                    notPay.setPaidPrice(BigDecimal.ZERO);
                    notPay.setDiscountPrice(BigDecimal.ZERO);
                    notPay.setStatus(Integer.valueOf(1));
                    ObjectResponse<List<OrderPay>> paysObj = this.orderPayService.selectByOrderNum(orderInfo.getOrderNum());
                    if (ObjectResponse.isSuccess(paysObj) && CollectionUtils.isNotEmpty((Collection)(pays = (List)paysObj.getData()))) {
                        Optional<Long> maxPayTime = pays.stream().map(OrderPay::getPayTime).filter(Objects::nonNull).max(Long::compareTo);
                        maxPayTime.ifPresent(arg_0 -> ((OrderNotpay)notPay).setLastPayTime(arg_0));
                    }
                    notPay.setVideoId(videoId);
                    notPay.setChannelId(channel.getId());
                    this.orderNotpayService.largeOrder(notPay);
                    this.orderNotpayService.addOrderNotpay(notPay);
                } else {
                    OrderNotpay updatePay = new OrderNotpay();
                    updatePay.setId(orderNotpay.getId());
                    updatePay.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice())).setScale(2, 4));
                    updatePay.setPaidPrice(BigDecimal.ZERO);
                    updatePay.setDiscountPrice(BigDecimal.ZERO);
                    updatePay.setVideoId(videoId);
                    updatePay.setChannelId(channel.getId());
                    this.orderNotpayService.largeOrder(updatePay);
                    this.orderNotpayService.updateById((Object)updatePay);
                    log.info("[\u7aef\u7f51\u4e91-\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u6b20\u8d39\u8ba2\u5355, \u8ba2\u5355[{}], \u539f\u6b20\u8d39\u91d1\u989d[{}], \u6700\u65b0\u6b20\u8d39[{}]", new Object[]{orderNotpay.getOrderNum(), orderNotpay.getPaidPrice(), exitRequest.getNotPayUnpayPrice()});
                }
            } else {
                ApplyCarVideoVo vo = new ApplyCarVideoVo();
                vo.setVideoType(Integer.valueOf(1));
                vo.setSn(serialNumber);
                vo.setChannelId(channel.getId());
                vo.setOrderNum(orderInfo.getOrderNum());
                vo.setParkId(orderInfo.getParkId());
                vo.setPlateNum(orderInfo.getPlateNum());
                vo.setVideoId(videoId);
                vo.setRecTime(exitRequest.getExitTime());
                vo.setNotPayPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice())).setScale(2, 4));
                vo.setLastPayTime(null);
                vo.setType(exitRequest.getType());
                vo.setCarType(exitRequest.getCarType());
                this.rabbitSender.sendMessage("aisle.delayed.exchange", "apply.car.video.routing", (Object)vo, Long.valueOf((long)this.aisleApplyCarVideoTime.intValue() * 1000L));
                log.info("[\u7aef\u7f51\u4e91-\u51fa\u53e3] \u8bf7\u6c42\u89c6\u9891\u5ef6\u8fdf\u6d88\u606f\u53d1\u9001, [{}]", (Object)vo);
            }
        } else if (Objects.nonNull(orderNotpay)) {
            if (exitRequest.getExceptionReason() != null && 4 == exitRequest.getExceptionReason()) {
                OrderNotpay update = new OrderNotpay();
                update.setId(orderNotpay.getId());
                update.setStatus(Integer.valueOf(3));
                update.setOperAccount(exitRequest.getOperAccount());
                update.setOperTime(new Date());
                this.orderNotpayService.updateById((Object)update);
            } else {
                this.orderNotpayService.deleteByOrderNum(orderInfo.getOrderNum());
            }
        }
    }

    @Transactional
    public OrderInfo exitPayDeal(ExitCommonRequest exitRequest, OrderInfo orderInfo, List<OrderSonInfo> orderSonInfos) {
        int paySize = exitRequest.getPaidInfo().size();
        if (paySize > 0) {
            Long lastPayTime = null;
            if (paySize > 1) {
                exitRequest.getPaidInfo().sort(Comparator.comparingLong(ExitCommonRequest.PaidInfo::getPayTime));
            }
            HashSet<String> tradeNos = new HashSet<String>(exitRequest.getPaidInfo().size());
            HashSet<String> discountNos = new HashSet<String>(exitRequest.getPaidInfo().size());
            HashSet regionCodes = new HashSet(exitRequest.getPaidInfo().size());
            AmountInfo totalAmount = new AmountInfo();
            Map<Long, OrderSonInfo> orderSonInfoMap = null;
            Map<Long, AmountInfo> orderSonAmountMap = null;
            if (CollectionUtils.isEmpty(orderSonInfos)) {
                orderSonInfoMap = Collections.emptyMap();
                orderSonAmountMap = Collections.emptyMap();
            } else {
                orderSonInfoMap = new HashMap(orderSonInfos.size());
                orderSonAmountMap = new HashMap(orderSonInfos.size());
                for (OrderSonInfo orderSonInfo2 : orderSonInfos) {
                    orderSonInfoMap.put(orderSonInfo2.getRegionId(), orderSonInfo2);
                    orderSonAmountMap.put(orderSonInfo2.getRegionId(), new AmountInfo());
                }
            }
            for (ExitCommonRequest.PaidInfo paidInfo : exitRequest.getPaidInfo()) {
                tradeNos.add(paidInfo.getTradeNo());
                if (CollectionUtils.isNotEmpty((Collection)paidInfo.getDiscountInfo())) {
                    for (ExitCommonRequest.DiscountInfo discountInfo : paidInfo.getDiscountInfo()) {
                        discountNos.add(discountInfo.getDiscountNo());
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)paidInfo.getRegionDetails())) continue;
                paidInfo.getRegionDetails().stream().map(QueryFeeRegionDetail::getRegionCode).collect(Collectors.toCollection(() -> regionCodes));
            }
            Map<Object, Object> orderPayDetailMap = Collections.emptyMap();
            if (!regionCodes.isEmpty()) {
                orderPayDetailMap = this.orderPayDetailService.list((Wrapper)((LambdaQueryWrapper)this.orderPayDetailService.getLambdaQueryWrapper().eq(OrderPayDetail::getParkId, (Object)orderInfo.getParkId())).eq(OrderPayDetail::getOrderNum, (Object)orderInfo.getOrderNum())).stream().collect(Collectors.groupingBy(OrderPayDetail::getTradeNo, Collectors.toMap(OrderPayDetail::getRegionId, Function.identity(), (older, newer) -> newer, HashMap::new)));
            }
            List orderPays = this.orderPayService.list((Wrapper)((LambdaQueryWrapper)this.orderPayService.getLambdaQueryWrapper().eq(OrderPay::getParkId, (Object)orderInfo.getParkId())).in(OrderPay::getTradeNo, tradeNos));
            Map orderPayMap = orderPays.stream().collect(Collectors.toMap(OrderPay::getTradeNo, Function.identity(), (older, newer) -> newer, HashMap::new));
            Map orderDiscountMap = discountNos.isEmpty() ? Collections.emptyMap() : (Map)this.orderDiscountService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.orderDiscountService.getLambdaQueryWrapper().eq(OrderDiscount::getParkId, (Object)orderInfo.getParkId())).eq(OrderDiscount::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderDiscount::getDelFlag, (Object)0)).in(OrderDiscount::getDiscountNo, discountNos)).stream().collect(Collectors.toMap(OrderDiscount::getDiscountNo, Function.identity(), (older, newer) -> newer, HashMap::new));
            Map parkRegionMap = regionCodes.isEmpty() ? Collections.emptyMap() : (Map)this.parkRegionDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRegion.class).eq(ParkRegion::getParkId, (Object)orderInfo.getParkId())).in(ParkRegion::getRegionCode, regionCodes)).stream().collect(Collectors.toMap(ParkRegion::getRegionCode, ParkRegion::getId, (older, newer) -> newer, HashMap::new));
            LinkedList<OrderPay> addOrderPays = new LinkedList<OrderPay>();
            LinkedList<OrderPay> updateOrderPays = new LinkedList<OrderPay>();
            LinkedList<OrderPayDetail> addOrderPayDetails = new LinkedList<OrderPayDetail>();
            LinkedList<OrderPayDetail> updateOrderPayDetails = new LinkedList<OrderPayDetail>();
            LinkedList<OrderDiscount> addDiscounts = new LinkedList<OrderDiscount>();
            boolean calcRegionAmount = false;
            ArrayList<NotPayDetailVo> nendPayList = new ArrayList<NotPayDetailVo>();
            for (ExitCommonRequest.PaidInfo paidInfo : exitRequest.getPaidInfo()) {
                String tradeNo = paidInfo.getTradeNo();
                OrderPay existsOrderPay = (OrderPay)orderPayMap.get(tradeNo);
                if (existsOrderPay == null) {
                    List discountInfos = paidInfo.getDiscountInfo();
                    ArrayList discountList = Lists.newArrayList();
                    if (discountInfos != null && discountInfos.size() > 0) {
                        for (ExitCommonRequest.DiscountInfo discountInfo : discountInfos) {
                            OrderDiscount existsDiscount = (OrderDiscount)orderDiscountMap.get(discountInfo.getDiscountNo());
                            if (existsDiscount == null) {
                                OrderDiscount orderDiscount = this.buildOrderDiscount(tradeNo, orderInfo, discountInfo);
                                if (orderDiscount == null) continue;
                                addDiscounts.add(orderDiscount);
                                continue;
                            }
                            if (!existsDiscount.getStatus().equals(0) && !existsDiscount.getStatus().equals(3)) continue;
                            discountList.add(existsDiscount.getDiscountNo());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)discountList)) {
                            BigDecimal discountPrice = NumberUtils.parseDecimal((Object)paidInfo.getDiscountPrice());
                            if (NumberUtils.parseDouble((Object)paidInfo.getVipDiscountPrice()) > 0.0) {
                                discountPrice = discountPrice.subtract(new BigDecimal(paidInfo.getVipDiscountPrice())).setScale(2, 4);
                            }
                            if (Integer.valueOf(9).equals(exitRequest.getExceptionReason()) && NumberUtils.parseDouble((Object)paidInfo.getTollDiscountPrice()) > 0.0) {
                                discountPrice = discountPrice.subtract(new BigDecimal(paidInfo.getTollDiscountPrice())).setScale(2, 4);
                            }
                            this.orderPayService.useDiscount(orderInfo.getParkId(), orderInfo.getOrderNum(), discountPrice.doubleValue(), paidInfo.getTradeNo(), paidInfo.getPayTime(), discountList, null);
                        }
                    }
                    OrderPay orderPay = this.buildOrderPay(tradeNo, orderInfo, paidInfo, discountList);
                    this.addOrderPayDiscount(orderPay, orderInfo, paidInfo, discountList, exitRequest);
                    orderPay.setLastPayTime(lastPayTime);
                    if (NumberUtils.parseDouble((Object)paidInfo.getBalancePrice()) > 0.0) {
                        orderPay.setBalancePrice(BigDecimal.valueOf(paidInfo.getBalancePrice()));
                        ObjectResponse storeCardResp = this.storeCardService.deductStoreCard(exitRequest, paidInfo, orderInfo);
                        if (ObjectResponse.isSuccess((Response)storeCardResp)) {
                            orderPay.setCardNum(((StoreCard)storeCardResp.getData()).getCardsNum());
                        } else {
                            log.warn("\u50a8\u503c\u5361\u4f59\u989d\u6263\u9664\u5931\u8d25: {}, {}", (Object)storeCardResp.getCode(), (Object)storeCardResp.getMsg());
                        }
                    }
                    if (paidInfo.getPayType() != null && paidInfo.getPayType() == 1) {
                        orderPay.setPayType(Integer.valueOf(1));
                        nendPayList.add(NotPayDetailVo.builder().orderNum(orderInfo.getOrderNum()).totalPrice(paidInfo.getTotalPrice()).unPayPrice(paidInfo.getPaidPrice()).discountPrice(paidInfo.getDiscountPrice()).build());
                    }
                    boolean isCityAutoPay = false;
                    if (PayChannelConstants.AUTO_PAY.equals(paidInfo.getPayChannel())) {
                        if (orderInfo instanceof OrderSonInfo) {
                            OrderInfo orderInfoMain = this.orderInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                            if (orderInfoMain != null && Integer.valueOf(1).equals(orderInfoMain.getCityAutopay())) {
                                isCityAutoPay = true;
                            }
                        } else if (Integer.valueOf(1).equals(orderInfo.getCityAutopay())) {
                            isCityAutoPay = true;
                        }
                    }
                    if (!isCityAutoPay) {
                        addOrderPays.add(orderPay);
                    }
                    existsOrderPay = orderPay;
                }
                lastPayTime = paidInfo.getPayTime();
                if (CollectionUtils.isEmpty((Collection)paidInfo.getRegionDetails()) && NumberUtils.toPrimitive((Integer)orderInfo.getHasSon()) == 1 && orderSonInfoMap.size() == 2) {
                    if (paySize == 1) {
                        OrderPay orderPay = existsOrderPay;
                        List virtualRegionDetails = orderSonInfoMap.values().stream().map(orderSonInfo -> {
                            QueryFeeRegionDetail regionDetail = new QueryFeeRegionDetail().setRegionId(orderSonInfo.getRegionId()).setOrderSonId(orderSonInfo.getId()).setEnterTime(orderSonInfo.getEnterTime()).setPlateType(orderSonInfo.getType());
                            if (orderSonInfo.getRegionId().equals(orderInfo.getRegionId())) {
                                regionDetail.setTotalAmount(exitRequest.getTotalAmount()).setDiscountPrice(exitRequest.getDiscountAmount()).setPaidPrice(exitRequest.getPaidAmount());
                            } else {
                                regionDetail.setTotalAmount(NumberUtils.decimalSubtract((Object)orderPay.getTotalPrice(), (Object[])new Object[]{exitRequest.getTotalAmount()}).toString()).setDiscountPrice(NumberUtils.decimalSubtract((Object)orderPay.getDiscountPrice(), (Object[])new Object[]{exitRequest.getDiscountAmount()}).toString()).setPaidPrice(NumberUtils.decimalSubtract((Object)orderPay.getPaidPrice(), (Object[])new Object[]{exitRequest.getPaidAmount()}).toString());
                            }
                            return regionDetail;
                        }).collect(Collectors.toList());
                        paidInfo.setRegionDetails(virtualRegionDetails);
                    } else {
                        calcRegionAmount = true;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)paidInfo.getRegionDetails())) {
                    List<OrderPayDetail> newOrderPayDetails;
                    Map<Long, OrderPayDetail> payDetailMap = (Map<Long, OrderPayDetail>)orderPayDetailMap.get(paidInfo.getTradeNo());
                    if (payDetailMap == null) {
                        payDetailMap = Collections.emptyMap();
                    }
                    if (!(newOrderPayDetails = this.handleOrderPayDetails(existsOrderPay, orderSonInfoMap, parkRegionMap, payDetailMap, paidInfo.getRegionDetails(), orderSonAmountMap, orderInfo, updateOrderPayDetails)).isEmpty()) {
                        if (existsOrderPay.getId() == null) {
                            existsOrderPay.setIsSonOrderpay(Integer.valueOf(1));
                        } else {
                            updateOrderPays.add(new OrderPay().setId(existsOrderPay.getId()).setIsSonOrderpay(Integer.valueOf(1)));
                        }
                    }
                    addOrderPayDetails.addAll(newOrderPayDetails);
                }
                totalAmount.totalPrice = NumberUtils.decimalAdd((Object)totalAmount.totalPrice, (Object[])new Object[]{paidInfo.getTotalPrice()});
                if (!Integer.valueOf(1).equals(orderInfo.getCityAutopay()) || !PayChannelConstants.AUTO_PAY.equals(paidInfo.getPayChannel())) {
                    totalAmount.paidPrice = NumberUtils.decimalAdd((Object)totalAmount.paidPrice, (Object[])new Object[]{paidInfo.getPaidPrice()});
                } else {
                    OrderPayCondition orderPayCondition = new OrderPayCondition();
                    orderPayCondition.setParkId(orderInfo.getParkId());
                    orderPayCondition.setPayStatus(Integer.valueOf(2));
                    orderPayCondition.setOrderNum(orderInfo.getOrderNum());
                    ObjectResponse<OrderSumFeeDto> objectResponse = this.orderPayService.getSumPay(orderPayCondition);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        BigDecimal sumPaidPrice = new BigDecimal(String.valueOf(((OrderSumFeeDto)objectResponse.getData()).getPaidPrice()));
                        log.info("[\u65e0\u611f\u652f\u4ed8]\u5148\u79bb\u573a\u540e\u4ed8\u8d39,\u79bb\u573a\u4e0a\u62a5\u91d1\u989d:{},\u8ba2\u5355\u652f\u4ed8\u91d1\u989d:{}", (Object)exitRequest.getPaidAmount(), (Object)sumPaidPrice);
                        if (new BigDecimal(exitRequest.getPaidAmount()).compareTo(sumPaidPrice) == 0) {
                            totalAmount.paidPrice = NumberUtils.decimalAdd((Object)totalAmount.paidPrice, (Object[])new Object[]{paidInfo.getPaidPrice()});
                            log.info("[\u65e0\u611f\u652f\u4ed8]\u91d1\u989d\u76f8\u540c\u6700\u540e\u91d1\u989d\u4e3a:{}", (Object)totalAmount.paidPrice);
                        }
                    }
                }
                totalAmount.discountPrice = NumberUtils.decimalAdd((Object)totalAmount.discountPrice, (Object[])new Object[]{paidInfo.getDiscountPrice()});
                totalAmount.balancePrice = NumberUtils.decimalAdd((Object)totalAmount.balancePrice, (Object[])new Object[]{paidInfo.getBalancePrice()});
            }
            if (!addOrderPays.isEmpty()) {
                this.orderPayService.saveBatch(addOrderPays);
                log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4ea4\u6613\u8bb0\u5f55\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfo.getOrderNum());
            }
            if (!updateOrderPays.isEmpty()) {
                this.orderPayService.updateBatchById(updateOrderPays);
                log.info("[\u79bb\u573a\u670d\u52a1] \u66f4\u65b0\u8ba2\u5355\u4ea4\u6613\u8bb0\u5f55\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfo.getOrderNum());
            }
            if (!addOrderPayDetails.isEmpty()) {
                this.orderPayDetailService.saveBatch(addOrderPayDetails);
                log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4ea4\u6613\u5206\u8d26\u8bb0\u5f55\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfo.getOrderNum());
            }
            if (!updateOrderPayDetails.isEmpty()) {
                this.orderPayDetailService.updateBatchById(updateOrderPayDetails);
                log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4ea4\u6613\u5206\u8d26\u8bb0\u5f55\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfo.getOrderNum());
            }
            if (!addDiscounts.isEmpty()) {
                this.orderDiscountService.saveBatch(addDiscounts);
                log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4f18\u60e0\u8bb0\u5f55\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfo.getOrderNum());
            }
            if (CollectionUtils.isNotEmpty(nendPayList)) {
                this.orderNotpayService.updatePaidByOrderNums(nendPayList, exitRequest.getPayChannelId(), exitRequest.getOperAccount());
            }
            this.fillAmount(orderInfo, totalAmount);
            if (calcRegionAmount) {
                for (OrderSonInfo orderSonInfo2 : orderSonInfoMap.values()) {
                    AmountInfo amountInfo = (AmountInfo)orderSonAmountMap.get(orderSonInfo2.getRegionId());
                    if (orderSonInfo2.getRegionId().equals(orderInfo.getRegionId())) {
                        amountInfo.totalPrice = NumberUtils.parseDecimal((Object)exitRequest.getTotalAmount());
                        amountInfo.discountPrice = NumberUtils.parseDecimal((Object)exitRequest.getDiscountAmount());
                        amountInfo.paidPrice = NumberUtils.parseDecimal((Object)exitRequest.getPaidAmount());
                        amountInfo.balancePrice = NumberUtils.parseDecimal((Object)exitRequest.getBalancePrice());
                        continue;
                    }
                    amountInfo.totalPrice = NumberUtils.decimalSubtract((Object)totalAmount.totalPrice, (Object[])new Object[]{exitRequest.getTotalAmount()});
                    amountInfo.discountPrice = NumberUtils.decimalSubtract((Object)totalAmount.discountPrice, (Object[])new Object[]{exitRequest.getDiscountAmount()});
                    amountInfo.paidPrice = NumberUtils.decimalSubtract((Object)totalAmount.paidPrice, (Object[])new Object[]{exitRequest.getPaidAmount()});
                    amountInfo.balancePrice = NumberUtils.decimalSubtract((Object)totalAmount.balancePrice, (Object[])new Object[]{exitRequest.getBalancePrice()});
                }
            }
            for (Map.Entry entry : orderSonInfoMap.entrySet()) {
                OrderSonInfo orderSonInfo4 = (OrderSonInfo)entry.getValue();
                AmountInfo amountInfo = (AmountInfo)orderSonAmountMap.get(entry.getKey());
                this.fillAmount((OrderInfo)orderSonInfo4, amountInfo);
            }
        }
        OrderPayQuery orderPayQuery = new OrderPayQuery();
        orderPayQuery.setOrderNum(orderInfo.getOrderNum());
        orderPayQuery.setOldPayStatus(Integer.valueOf(1));
        orderPayQuery.setNewPayStatus(Integer.valueOf(3));
        int i = this.orderPayService.updateStatus(orderPayQuery);
        OrderPayDetail updateDetail = new OrderPayDetail();
        updateDetail.setOrderNum(orderInfo.getOrderNum());
        updateDetail.setPayStatus(Integer.valueOf(3));
        this.orderPayDetailService.update((Object)updateDetail, (Wrapper)((LambdaQueryWrapper)this.orderPayDetailService.getLambdaQueryWrapper().eq(OrderPayDetail::getOrderNum, (Object)orderInfo.getOrderNum())).eq(OrderPayDetail::getPayStatus, (Object)1));
        log.info("[\u79bb\u573a\u670d\u52a1] \u4fee\u6539\u65e0\u6548\u4ea4\u6613\u8bb0\u5f55\u72b6\u6001\uff0c\u5f71\u54cd{}\u6761\u8bb0\u5f55\uff0corderNum\uff1a{}", (Object)i, (Object)orderInfo.getOrderNum());
        return orderInfo;
    }

    private List<OrderPayDetail> handleOrderPayDetails(OrderPay orderPay, Map<Long, OrderSonInfo> orderSonInfoMap, Map<String, Long> parkRegionMap, Map<Long, OrderPayDetail> orderPayDetailMap, List<QueryFeeRegionDetail> regionDetails, Map<Long, AmountInfo> orderSonAmountMap, OrderInfo orderInfo, List<OrderPayDetail> updateOrderPayDetails) {
        LinkedList<OrderPayDetail> addOrderPayDetails = new LinkedList<OrderPayDetail>();
        for (QueryFeeRegionDetail regionDetail : regionDetails) {
            AmountInfo amountInfo;
            Long regionId;
            Long l = regionId = regionDetail.getRegionId() == null ? parkRegionMap.get(regionDetail.getRegionCode()) : regionDetail.getRegionId();
            if (regionId == null) {
                log.info("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u533a\u57df\u4fe1\u606f|{}|{}", (Object)orderPay.getOrderNum(), (Object)regionDetail.getRegionCode());
                continue;
            }
            OrderSonInfo orderSonInfo = orderSonInfoMap.get(regionId);
            if (orderPayDetailMap.containsKey(regionId)) {
                OrderPayDetail orderPayDetail = new OrderPayDetail();
                OrderPayDetail dbDetail = orderPayDetailMap.get(regionId);
                orderPayDetail.setId(dbDetail.getId());
                if (orderSonInfo == null) {
                    orderPayDetail.setExitTime(orderInfo.getExitTime());
                } else {
                    orderPayDetail.setExitTime(orderSonInfo.getExitTime());
                }
                updateOrderPayDetails.add(orderPayDetail);
            } else {
                regionDetail.setRegionId(regionId);
                regionDetail.setPlateNum(orderInfo.getPlateNum());
                if (orderSonInfo == null) {
                    regionDetail.setEnterTime(orderInfo.getEnterTime());
                    regionDetail.setExitTime(orderInfo.getExitTime());
                    regionDetail.setPlateType(orderInfo.getType());
                } else {
                    regionDetail.setOrderSonId(orderSonInfo.getId());
                    regionDetail.setEnterTime(orderSonInfo.getEnterTime());
                    regionDetail.setExitTime(orderSonInfo.getExitTime());
                    regionDetail.setPlateType(orderSonInfo.getType());
                }
                OrderPayDetail detail = this.buildOrderPayDetail(orderPay, regionDetail);
                addOrderPayDetails.add(detail);
            }
            if ((amountInfo = orderSonAmountMap.get(regionId)) == null) continue;
            amountInfo.totalPrice = NumberUtils.decimalAdd((Object)amountInfo.totalPrice, (Object[])new Object[]{regionDetail.getTotalAmount()});
            amountInfo.discountPrice = NumberUtils.decimalAdd((Object)amountInfo.discountPrice, (Object[])new Object[]{regionDetail.getDiscountPrice()});
            amountInfo.paidPrice = NumberUtils.decimalAdd((Object)amountInfo.paidPrice, (Object[])new Object[]{regionDetail.getPaidPrice()});
            amountInfo.balancePrice = NumberUtils.decimalAdd((Object)amountInfo.balancePrice, (Object[])new Object[]{regionDetail.getBalancePrice()});
        }
        return addOrderPayDetails;
    }

    private void fillAmount(OrderInfo orderInfo, AmountInfo amountInfo) {
        if (amountInfo.totalPrice.compareTo(BigDecimal.ZERO) > 0) {
            orderInfo.setTotalPrice(amountInfo.totalPrice.toString());
            orderInfo.setDiscountPrice(amountInfo.discountPrice.toString());
            orderInfo.setPaidPrice(amountInfo.paidPrice.toString());
            orderInfo.setBalancePrice(amountInfo.balancePrice);
            orderInfo.setNeedPrice(NumberUtils.decimalSubtract((Object)amountInfo.totalPrice, (Object[])new Object[]{amountInfo.discountPrice, amountInfo.paidPrice, amountInfo.balancePrice}).toString());
        }
    }

    private OrderPay buildOrderPay(String tradeNo, OrderInfo orderInfo, ExitCommonRequest.PaidInfo paidInfo, List<String> discountList) {
        ObjectResponse response;
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(orderInfo.getParkId());
        orderPay.setOrderNum(orderInfo.getOrderNum());
        orderPay.setTradeNo(tradeNo);
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setPayTime(paidInfo.getPayTime());
        orderPay.setOrderTime(paidInfo.getPayTime());
        orderPay.setTotalPrice(paidInfo.getTotalPrice());
        orderPay.setBankOrderId(paidInfo.getBankOrderId());
        orderPay.setThirdTradeNo(paidInfo.getThirdTradeNo());
        orderPay.setPaidPrice(paidInfo.getPaidPrice());
        orderPay.setDiscountPrice(paidInfo.getDiscountPrice());
        orderPay.setPayChannel(paidInfo.getPayChannel());
        orderPay.setPayWay(paidInfo.getPayWay());
        orderPay.setPayTerminal(paidInfo.getPayTerminal());
        orderPay.setUserAccount(paidInfo.getUserAccount());
        orderPay.setActualCash(paidInfo.getActualCash());
        orderPay.setRedpackRet(paidInfo.getRedpackRet());
        orderPay.setIsSync(Integer.valueOf(0));
        if (orderPay.getPayWay() != 1 && ObjectResponse.isSuccess((Response)(response = this.parkService.selectGroupPayType(((Park)this.parkService.findByParkId(orderInfo.getParkId()).getData()).getParkCode()))) && StringUtils.isNotBlank((CharSequence)((CharSequence)response.getData()))) {
            orderPay.setPayAisle(PlatformPayType.getPayAisle((String)((String)response.getData()), (Integer)paidInfo.getPayWay()));
        }
        if (CollectionUtils.isNotEmpty(discountList)) {
            List orderDiscounts = this.orderDiscountService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)orderInfo.getParkId())).eq(OrderDiscount::getDelFlag, (Object)0)).in(OrderDiscount::getDiscountNo, discountList));
            Set discountNames = orderDiscounts.stream().map(s -> StringUtils.isNotBlank((CharSequence)s.getDiscountName()) ? s.getDiscountName() : "").collect(Collectors.toSet());
            String join = StrUtil.join((CharSequence)"-", discountNames);
            if (join.length() < 512) {
                orderPay.setRemark(join);
            }
            if (NumberUtils.toDouble((String)orderPay.getPaidPrice()) == 0.0 && NumberUtils.toDouble((String)orderPay.getTotalPrice()) > 0.0) {
                orderPay.setPayWay(Integer.valueOf(10));
            }
        }
        return orderPay;
    }

    private void addOrderPayDiscount(OrderPay orderPay, OrderInfo orderInfo, ExitCommonRequest.PaidInfo paidInfo, List<String> discountList, ExitCommonRequest exitRequest) {
        List vipTypeId;
        if (NumberUtils.parseDouble((Object)paidInfo.getDiscountPrice()) == 0.0) {
            return;
        }
        String channelId = exitRequest.getChannelId() == null ? exitRequest.getOutChannelId() : exitRequest.getChannelId();
        Integer exceptionReason = exitRequest.getExceptionReason();
        OrderPayDiscount orderPayDiscount = new OrderPayDiscount();
        BeanUtils.copyProperties((Object)orderPay, (Object)orderPayDiscount);
        orderPayDiscount.setCarType(orderInfo.getCarType());
        orderPayDiscount.setEnterTime(NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 1 ? null : orderInfo.getEnterTime());
        orderPayDiscount.setExitChannelId(channelId);
        orderPayDiscount.setExitTime((Long)(orderInfo.getEnterTime().equals(orderInfo.getExitTime()) && Integer.valueOf(6).equals(orderInfo.getOddStatus()) ? null : orderInfo.getExitTime()));
        orderPayDiscount.setPlateNum(orderInfo.getPlateNum());
        orderPayDiscount.setType(orderInfo.getType());
        orderPayDiscount.setTotalPrice(NumberUtils.parseDecimal((Object)orderPay.getTotalPrice()));
        orderPayDiscount.setDiscountPrice(NumberUtils.parseDecimal((Object)orderPay.getDiscountPrice()));
        orderPayDiscount.setPaidPrice(NumberUtils.parseDecimal((Object)orderPay.getPaidPrice()));
        if (CollectionUtils.isNotEmpty(discountList)) {
            List orderDiscounts = this.orderDiscountService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)orderInfo.getParkId())).eq(OrderDiscount::getDelFlag, (Object)0)).in(OrderDiscount::getDiscountNo, discountList));
            if (NumberUtils.parseDouble((Object)paidInfo.getMerchantDiscountPrice()) > 0.0) {
                OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo = OrderPayDiscount.getMerchantCouponsInfo((List)orderDiscounts, (BigDecimal)NumberUtils.parseDecimal((Object)paidInfo.getMerchantDiscountPrice()));
                orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc()));
                orderPayDiscount.setMerchantDiscountPrice(new BigDecimal(paidInfo.getMerchantDiscountPrice()));
                orderPayDiscount.setMerchantCouponsInfo(JsonUtils.toString((Object)merchantCouponsInfo));
            }
            if (NumberUtils.parseDouble((Object)paidInfo.getThirdDiscountPrice()) > 0.0) {
                OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo = OrderPayDiscount.getThirdCouponsInfo((List)orderDiscounts, (BigDecimal)NumberUtils.parseDecimal((Object)paidInfo.getThirdDiscountPrice()));
                orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc()));
                orderPayDiscount.setThirdDiscountPrice(new BigDecimal(paidInfo.getThirdDiscountPrice()));
                orderPayDiscount.setThirdCouponsInfo(JsonUtils.toString((Object)thirdCouponsInfo));
            }
        }
        if (NumberUtils.parseDouble((Object)paidInfo.getVipDiscountPrice()) > 0.0 && (vipTypeId = paidInfo.getVipTypeId()) != null && vipTypeId.size() > 0) {
            OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
            for (Integer typeId : vipTypeId) {
                VipTypeDto vipTypeDto = this.vipTypeDao.selectById(typeId);
                if (vipTypeDto == null) continue;
                vipCouponsInfo.addTypeId(typeId);
                vipCouponsInfo.addDiscountType(vipTypeDto.getType());
            }
            orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc()));
            vipCouponsInfo.setDiscountPrice(NumberUtils.parseDecimal((Object)paidInfo.getVipDiscountPrice()));
            orderPayDiscount.setVipDiscountPrice(new BigDecimal(paidInfo.getVipDiscountPrice()));
            orderPayDiscount.setVipCouponsInfo(JsonUtils.toString((Object)vipCouponsInfo));
        }
        if (Integer.valueOf(9).equals(exceptionReason) && NumberUtils.parseDouble((Object)paidInfo.getTollDiscountPrice()) > 0.0) {
            OrderPayDiscount.TollCouponsInfo tollCouponsInfo = new OrderPayDiscount.TollCouponsInfo();
            tollCouponsInfo.setDiscountPrice(new BigDecimal(paidInfo.getTollDiscountPrice()));
            tollCouponsInfo.setExitOperaAccount(exitRequest.getOperAccount());
            tollCouponsInfo.setExitTerminal(exitRequest.getExTerminal());
            orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.TOLL_COUPONS.getDesc()));
            orderPayDiscount.setTollDiscountPrice(new BigDecimal(paidInfo.getTollDiscountPrice()));
            orderPayDiscount.setTollCouponsInfo(JsonUtils.toString((Object)tollCouponsInfo));
        }
        if (orderPayDiscount.getTradeNo() != null) {
            log.info("\u8bb0\u5f55\u652f\u4ed8\u660e\u7ec6\u4f18\u60e0\u8bb0\u5f55, {}", (Object)orderPayDiscount);
            this.orderPayDiscountService.addOrderPayDiscount(orderPayDiscount);
        }
    }

    private OrderPayDetail buildOrderPayDetail(OrderPay orderPay, QueryFeeRegionDetail regionDetail) {
        return new OrderPayDetail().setParkId(orderPay.getParkId()).setRegionId(regionDetail.getRegionId()).setOrderSonId(regionDetail.getOrderSonId()).setOrderNum(orderPay.getOrderNum()).setPlateType(regionDetail.getPlateType()).setTradeNo(orderPay.getTradeNo()).setPayStatus(orderPay.getPayStatus()).setRefundStatus(Integer.valueOf(-1)).setPayWay(orderPay.getPayWay()).setEnterTime(regionDetail.getEnterTime()).setExitTime(regionDetail.getExitTime()).setPlateNum(regionDetail.getPlateNum()).setPayTime(orderPay.getPayTime()).setTotalPrice(Double.valueOf(NumberUtils.parseDouble((Object)regionDetail.getTotalAmount()))).setPaidPrice(Double.valueOf(NumberUtils.toDouble((String)regionDetail.getPaidPrice()))).setDiscountPrice(Double.valueOf(NumberUtils.parseDouble((Object)regionDetail.getDiscountPrice())));
    }

    private OrderDiscount buildOrderDiscount(String tradeNo, OrderInfo orderInfo, ExitCommonRequest.DiscountInfo discountInfo) {
        OrderDiscount orderDiscount;
        if (DiscountTypeEnum.\u6309\u5929\u4f18\u514d.getType().equals(discountInfo.getDiscountType()) && (orderDiscount = (OrderDiscount)this.orderDiscountService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.orderDiscountService.getLambdaQueryWrapper().eq(OrderDiscount::getParkId, (Object)orderInfo.getParkId())).eq(OrderDiscount::getDiscountNo, (Object)discountInfo.getDiscountNo())).eq(OrderDiscount::getDelFlag, (Object)0)).orderByAsc(OrderDiscount::getId)).last("limit 1"))) != null) {
            if (!orderInfo.getOrderNum().equals(orderDiscount.getOrderNum())) {
                orderDiscount.setId(null);
                orderDiscount.setOrderNum(orderInfo.getOrderNum());
                orderDiscount.setTradeNo(tradeNo);
                orderDiscount.setAmount(discountInfo.getDiscountNumber());
                orderDiscount.setStatus(Integer.valueOf(1));
                orderDiscount.setGetAmount(Double.valueOf(discountInfo.getDiscountNumber()));
                log.debug("\u4f18\u60e0\u65f6\u95f4[{}]ms", (Object)((long)discountInfo.getDiscountTime().intValue() * 1000L));
                orderDiscount.setUseTime(new Date());
                orderDiscount.setCarStatus(Integer.valueOf(2));
                orderDiscount.setDeductMoney(null);
                orderDiscount.setReduceBalance(null);
                orderDiscount.setUpdateTime(null);
                return orderDiscount;
            }
            log.debug("\u6309\u5929\u4f18\u60e0\u5e73\u53f0\u5df2\u5904\u7406, \u65e0\u9700\u5904\u7406\u672c\u5730\u4f18\u60e0\u7f16\u53f7[{}]", (Object)discountInfo.getDiscountNo());
            return null;
        }
        orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(orderInfo.getParkId());
        orderDiscount.setOrderNum(orderInfo.getOrderNum());
        orderDiscount.setPlateNum(orderInfo.getPlateNum());
        orderDiscount.setTradeNo(tradeNo);
        orderDiscount.setFrom(Integer.valueOf(0));
        orderDiscount.setDiscountNo(discountInfo.getDiscountNo());
        orderDiscount.setType(discountInfo.getDiscountType());
        orderDiscount.setAmount(discountInfo.getDiscountNumber());
        orderDiscount.setStatus(Integer.valueOf(1));
        orderDiscount.setDeductMoney(Double.valueOf(discountInfo.getDiscountNumber()));
        orderDiscount.setGetAmount(Double.valueOf(discountInfo.getDiscountNumber()));
        orderDiscount.setSendTime(new Date(discountInfo.getDiscountTime() * 1000));
        orderDiscount.setUseTime(new Date());
        return orderDiscount;
    }

    private static class AmountInfo {
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal paidPrice = BigDecimal.ZERO;
        BigDecimal discountPrice = BigDecimal.ZERO;
        BigDecimal balancePrice = BigDecimal.ZERO;

        private AmountInfo() {
        }
    }
}

