/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.order.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.order.ComplateOrderService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.ComplateOrderRequest;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.order.impl.ExitPayDealServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service(value="complateOrderService")
public class ComplateOrderServiceImpl
implements ComplateOrderService {
    private static final Logger log = LoggerFactory.getLogger(ComplateOrderServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ExitPayDealServiceImpl exitPayDealServiceImpl;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse complateOrder(ComplateOrderRequest complateOrderRequest) {
        ParkRegion parkRegion;
        ParkInoutdevice[] channels = new ParkInoutdevice[2];
        if (StringUtils.isBlank((CharSequence)complateOrderRequest.getOutChannelId())) {
            return ObjectResponse.failed((String)"400", (String)"\u65e0\u51fa\u53e3\u901a\u9053\u7f16\u53f7");
        }
        ObjectResponse parkChannelResp = this.parkService.getInoutDeviceByCode(complateOrderRequest.getOutChannelId());
        if (!ObjectResponse.isSuccess((Response)parkChannelResp) || parkChannelResp.getData() == null) {
            log.warn("[\u5b8c\u6574\u8ba2\u5355\u4e0a\u62a5\u670d\u52a1] \u51fa\u53e3\u901a\u9053\u7f16\u53f7\u65e0\u6548|{}|{}", (Object)complateOrderRequest.getOutChannelId(), (Object)complateOrderRequest.getOrderId());
            return ObjectResponse.failed((String)"402", (String)"\u51fa\u53e3\u901a\u9053\u7f16\u53f7\u65e0\u6548");
        }
        channels[1] = (ParkInoutdevice)parkChannelResp.getData();
        if (StringUtils.isNotBlank((CharSequence)complateOrderRequest.getInChannelId()) && (!ObjectResponse.isSuccess((Response)(parkChannelResp = this.parkService.getInoutDeviceByCode(complateOrderRequest.getInChannelId()))) || parkChannelResp.getData() == null)) {
            log.warn("[\u5b8c\u6574\u8ba2\u5355\u4e0a\u62a5\u670d\u52a1] \u5165\u53e3\u901a\u9053\u7f16\u53f7\u65e0\u6548|{}|{}", (Object)complateOrderRequest.getInChannelId(), (Object)complateOrderRequest.getOrderId());
            return ObjectResponse.failed((String)"402", (String)"\u5165\u53e3\u901a\u9053\u7f16\u53f7\u65e0\u6548");
        }
        channels[0] = (ParkInoutdevice)parkChannelResp.getData();
        ParkRegion parkRegion2 = parkRegion = NumberUtils.toPrimitive((Long)channels[1].getRegionId()) > 0L ? (ParkRegion)this.parkRegionDao.selectById((Serializable)channels[1].getRegionId()) : null;
        if (parkRegion == null) {
            return this.saveMasterOrder(complateOrderRequest, channels, parkRegion);
        }
        if (NumberUtils.toPrimitive((Long)parkRegion.getFatherRelationId()) == 0L) {
            return this.saveMasterOrder(complateOrderRequest, channels, parkRegion);
        }
        return this.saveSonOrder(complateOrderRequest, channels, parkRegion);
    }

    private ObjectResponse saveSonOrder(ComplateOrderRequest complateOrderRequest, ParkInoutdevice[] channels, ParkRegion parkRegion) {
        ObjectResponse parkResp;
        String version;
        boolean isExceptionExit = complateOrderRequest.getIsExceptionExit() != null && complateOrderRequest.getIsExceptionExit() == 1;
        Long parkId = complateOrderRequest.getParkId();
        String orderId = complateOrderRequest.getOrderId();
        String orderNum = CodeTools.GenerateOrderNum();
        OrderSonInfo orderInfoSearch = new OrderSonInfo();
        orderInfoSearch.setLocalOrderNum(orderId);
        orderInfoSearch.setParkId(parkId);
        orderInfoSearch.setRegionId(parkRegion.getId());
        OrderSonInfo orderSonInfo = this.orderSonInfoDao.selectOneByEntity(orderInfoSearch);
        boolean hasEnter = orderSonInfo != null;
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setLocalOrderNum(orderId);
        OrderInfo mainOrder = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (hasEnter) {
            orderSonInfo.setType(complateOrderRequest.getType());
            orderSonInfo.setCarType(complateOrderRequest.getCarType());
            orderSonInfo.setServiceStatus(Integer.valueOf(isExceptionExit ? 4 : 2));
            orderSonInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderSonInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderSonInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderSonInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            orderSonInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            orderSonInfo.setExitTime(complateOrderRequest.getExitTime());
            if (complateOrderRequest.getBalancePrice() != null) {
                orderSonInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            this.orderSonInfoDao.updateById((Object)orderSonInfo);
        } else {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties((Object)complateOrderRequest, (Object)orderSonInfo);
            orderSonInfo.setLocalOrderNum(orderId);
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setServiceStatus(Integer.valueOf(isExceptionExit ? 4 : 2));
            orderSonInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderSonInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderSonInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderSonInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            orderSonInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            orderSonInfo.setRegionId(parkRegion.getId());
            if (StringUtils.isBlank((CharSequence)complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderSonInfo.setNoneEnterFlag(Integer.valueOf(1));
            }
            if (mainOrder != null) {
                if (mainOrder.getRegionId() == null) {
                    mainOrder.setRegionId(parkRegion.getId());
                }
                mainOrder.setHasSon(Integer.valueOf(1));
                this.orderInfoDao.updateByOrderNum(mainOrder);
                log.info("[\u5b8c\u6574\u8ba2\u5355\u8bb0\u5f55\u4e0a\u62a5\u670d\u52a1--\u5b50\u8ba2\u5355] \u66f4\u65b0\u4e3b\u8ba2\u5355\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
                this.copyMainOrderToSon(mainOrder, null);
                orderSonInfo.setOrderNum(mainOrder.getOrderNum());
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderSonInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            this.orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            log.info("[\u5b8c\u6574\u8ba2\u5355\u8bb0\u5f55\u4e0a\u62a5\u670d\u52a1--\u5b50\u8ba2\u5355] \u63d2\u5165\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        }
        OrderSonCarInfo sonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId().longValue());
        if (sonCarInfo == null) {
            sonCarInfo = new OrderSonCarInfo();
        }
        BeanUtils.copyProperties((Object)complateOrderRequest, (Object)sonCarInfo, (String[])new String[]{"id"});
        if (NumberUtils.toPrimitive((Integer)orderSonInfo.getNoneEnterFlag()) == 0) {
            sonCarInfo.setEnterNo(channels[0].getInandoutName());
            sonCarInfo.setEnterChannelId(StringUtils.isBlank((CharSequence)complateOrderRequest.getInChannelId()) ? channels[0].getInandoutCode() : complateOrderRequest.getInChannelId());
            sonCarInfo.setEnterImage(complateOrderRequest.getEnterImage());
            sonCarInfo.setSmallEnterImage(complateOrderRequest.getEnterSmallImage());
            sonCarInfo.setEnterReliability(complateOrderRequest.getEnterReliability());
        }
        sonCarInfo.setOrderSonId(orderSonInfo.getId());
        sonCarInfo.setOrderNum(orderNum);
        sonCarInfo.setExitNo(channels[1].getInandoutName());
        sonCarInfo.setExitChannelId(complateOrderRequest.getOutChannelId());
        sonCarInfo.setExitImage(complateOrderRequest.getExitImage());
        sonCarInfo.setSmallExitImage(complateOrderRequest.getExitSmallImage());
        sonCarInfo.setExitReliability(complateOrderRequest.getExitReliability());
        if (sonCarInfo.getId() == null) {
            this.orderSonCarInfoDao.insert((Object)sonCarInfo);
            log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u51fa\u5165\u8868\u5165\u573a\u90e8\u5206\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        } else {
            this.orderSonCarInfoDao.updateById((Object)sonCarInfo);
            log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u51fa\u5165\u8868\u79bb\u573a\u90e8\u5206\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderNum);
        }
        if (mainOrder == null) {
            mainOrder = new OrderInfo();
            BeanUtils.copyProperties((Object)orderSonInfo, (Object)mainOrder);
            mainOrder.setId(null).setServiceStatus(Integer.valueOf(1)).setExitTime(null).setOddStatus(null).setNoneEnterFlag(Integer.valueOf(1)).setHasSon(Integer.valueOf(1)).setCreateTime(null);
            ParkRegion parentRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)parkRegion.getFatherRelationId());
            mainOrder.setRegionId(parentRegion.getId());
            this.orderInfoDao.insertWithPlateNum2(mainOrder);
            OrderCarInfo mainCarInfo = new OrderCarInfo();
            BeanUtils.copyProperties((Object)sonCarInfo, (Object)mainCarInfo);
            mainCarInfo.setId(null).setExitChannelId(null).setEnterWay(null).setEnterNo(null).setEnterChannelId(null).setEnterImage(null).setExitNo(null).setExitImage(null).setSmallExitImage(null).setExitReliability(null);
            this.orderCarInfoDao.insert((Object)mainCarInfo);
            this.copyMainOrderToSon(mainOrder, mainCarInfo);
        }
        if (!hasEnter && (version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkId), String.class)) != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex() && ObjectResponse.isSuccess((Response)(parkResp = this.parkService.findByParkId(parkId))) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0) {
            this.orderTrackService.saveBatch(this.buildTrack((OrderInfo)orderSonInfo, (OrderCarInfo)sonCarInfo));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderId", orderId);
        map.put("orderNum", orderNum);
        List paidInfo = complateOrderRequest.getPaidInfo();
        if (paidInfo != null) {
            this.exitPayDealServiceImpl.exitPayDeal((ExitCommonRequest)complateOrderRequest, (OrderInfo)orderSonInfo, null);
        }
        this.exitPayDealServiceImpl.handleNotPayOrder((ExitCommonRequest)complateOrderRequest, (OrderInfo)orderSonInfo, channels[1], null);
        return ObjectResponse.success(map);
    }

    private OrderSonInfo copyMainOrderToSon(OrderInfo mainOrder, OrderCarInfo orderCarInfo) {
        List existsSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)mainOrder.getParkId())).eq(OrderInfo::getOrderNum, (Object)mainOrder.getOrderNum())).eq(OrderInfo::getRegionId, (Object)mainOrder.getRegionId()));
        if (!existsSonInfos.isEmpty()) {
            return (OrderSonInfo)existsSonInfos.get(0);
        }
        OrderSonInfo sonInfo = new OrderSonInfo();
        BeanUtils.copyProperties((Object)mainOrder, (Object)sonInfo);
        sonInfo.setId(null);
        sonInfo.setCreateTime(new Date());
        this.orderSonInfoDao.insertWithPlateNum2(sonInfo);
        if (orderCarInfo == null) {
            orderCarInfo = this.orderCarInfoDao.selectByOrderNum(mainOrder.getOrderNum());
        }
        if (orderCarInfo != null) {
            OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties((Object)orderCarInfo, (Object)sonCarInfo, (String[])new String[]{"id"});
            sonCarInfo.setOrderSonId(sonInfo.getId());
            this.orderSonCarInfoDao.insert((Object)sonCarInfo);
        }
        return sonInfo;
    }

    private List<OrderTrack> buildTrack(OrderInfo orderInfo, OrderCarInfo orderCarInfo) {
        OrderTrack enterTrack = null;
        if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 0) {
            enterTrack = new OrderTrack().setRecordType(Integer.valueOf(1)).setParkId(orderInfo.getParkId()).setRegionId(orderInfo.getRegionId()).setOrderNum(orderInfo.getOrderNum()).setPlateNum(orderInfo.getPlateNum()).setEnexTime(orderInfo.getEnterTime()).setType(orderInfo.getType()).setInoutEvent(Integer.valueOf(0));
        }
        OrderTrack exitTrack = new OrderTrack().setRecordType(Integer.valueOf(2)).setParkId(orderInfo.getParkId()).setRegionId(orderInfo.getRegionId()).setOrderNum(orderInfo.getOrderNum()).setPlateNum(orderInfo.getPlateNum()).setEnexTime(orderInfo.getEnterTime()).setType(orderInfo.getType()).setInoutEvent(Integer.valueOf(0));
        if (orderCarInfo != null) {
            if (enterTrack != null) {
                enterTrack.setImage(orderCarInfo.getEnterImage()).setChannelName(orderCarInfo.getEnterNo());
            }
            exitTrack.setImage(orderCarInfo.getExitImage()).setChannelName(orderCarInfo.getExitNo());
        }
        return enterTrack == null ? Collections.singletonList(exitTrack) : Arrays.asList(enterTrack, exitTrack);
    }

    private ObjectResponse saveMasterOrder(ComplateOrderRequest complateOrderRequest, ParkInoutdevice[] channels, ParkRegion parkRegion) {
        ObjectResponse parkResp;
        boolean isExceptionExit = complateOrderRequest.getIsExceptionExit() != null && complateOrderRequest.getIsExceptionExit() == 1;
        Long parkId = complateOrderRequest.getParkId();
        String orderId = complateOrderRequest.getOrderId();
        OrderInfo orderInfoSearch = new OrderInfo();
        orderInfoSearch.setLocalOrderNum(orderId);
        orderInfoSearch.setParkId(parkId);
        OrderInfo orderInfoResult = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoSearch);
        boolean hasOrder = orderInfoResult != null;
        List orderSonInfos = this.orderSonInfoDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getLocalOrderNum, (Object)orderId)).in(OrderInfo::getServiceStatus, new Object[]{1, 2, 4}));
        if (hasOrder) {
            orderInfoResult.setType(complateOrderRequest.getType());
            orderInfoResult.setCarType(complateOrderRequest.getCarType());
            orderInfoResult.setServiceStatus(Integer.valueOf(isExceptionExit ? 4 : 2));
            orderInfoResult.setOperAccount(complateOrderRequest.getUserAccount());
            orderInfoResult.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderInfoResult.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderInfoResult.setPaidPrice(complateOrderRequest.getPaidAmount());
            orderInfoResult.setOddStatus(complateOrderRequest.getExceptionReason());
            orderInfoResult.setExitTime(complateOrderRequest.getExitTime());
            if (parkRegion != null) {
                orderInfoResult.setRegionId(parkRegion.getId());
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderInfoResult.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            if (StringUtils.isBlank((CharSequence)complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderInfoResult.setNoneEnterFlag(Integer.valueOf(1));
            } else {
                orderInfoResult.setNoneEnterFlag(Integer.valueOf(0));
            }
        } else {
            OrderInfo orderInfo = new OrderInfo();
            BeanUtils.copyProperties((Object)complateOrderRequest, (Object)orderInfo);
            orderInfo.setLocalOrderNum(orderId);
            orderInfo.setOrderNum(CodeTools.GenerateOrderNum());
            orderInfo.setServiceStatus(Integer.valueOf(isExceptionExit ? 4 : 2));
            orderInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            orderInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            if (StringUtils.isBlank((CharSequence)complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderInfo.setNoneEnterFlag(Integer.valueOf(1));
            }
            if (Objects.equals(orderInfo.getEnterTime(), orderInfo.getExitTime())) {
                orderInfo.setNoneEnterFlag(Integer.valueOf(1));
            }
            if (parkRegion != null) {
                orderInfo.setRegionId(parkRegion.getId());
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            orderInfoResult = orderInfo;
        }
        OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderInfoResult.getOrderNum());
        if (orderCarInfo == null) {
            orderCarInfo = new OrderCarInfo();
        }
        BeanUtils.copyProperties((Object)complateOrderRequest, (Object)orderCarInfo, (String[])new String[]{"id"});
        orderCarInfo.setOrderNum(orderInfoResult.getOrderNum());
        orderCarInfo.setExitNo(channels[1].getInandoutName());
        orderCarInfo.setExitChannelId(complateOrderRequest.getOutChannelId());
        orderCarInfo.setExitImage(complateOrderRequest.getExitImage());
        orderCarInfo.setSmallExitImage(complateOrderRequest.getExitSmallImage());
        orderCarInfo.setEnterReliability(complateOrderRequest.getEnterReliability());
        orderCarInfo.setExitReliability(complateOrderRequest.getExitReliability());
        orderCarInfo.setExitOperAccount(complateOrderRequest.getOperAccount());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)complateOrderRequest.getPlateColor())) {
            orderCarInfo.setPlateColor(complateOrderRequest.getPlateColor());
        }
        if (NumberUtils.toPrimitive((Integer)orderInfoResult.getNoneEnterFlag()) == 0) {
            orderCarInfo.setEnterNo(channels[0].getInandoutName());
            orderCarInfo.setEnterChannelId(StringUtils.isBlank((CharSequence)complateOrderRequest.getInChannelId()) ? channels[0].getInandoutCode() : complateOrderRequest.getInChannelId());
            orderCarInfo.setEnterImage(complateOrderRequest.getEnterImage());
            orderCarInfo.setSmallEnterImage(complateOrderRequest.getEnterSmallImage());
            orderInfoResult.setEnterChannelId(orderCarInfo.getEnterChannelId());
        }
        this.handleOrderSon(orderInfoResult, orderCarInfo, orderSonInfos);
        if (orderInfoResult.getId() == null) {
            try {
                this.orderService.addOrderInfo(orderInfoResult);
            }
            catch (DuplicateKeyException e) {
                orderInfoResult.setOrderNum(CodeTools.GenerateOrderNum());
                this.orderService.addOrderInfo(orderInfoResult);
            }
            log.info("[\u5b8c\u6574\u8ba2\u5355\u8bb0\u5f55\u4e0a\u62a5\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u4fe1\u606f\u8868\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfoResult.getOrderNum());
        } else {
            this.orderService.updateOrderWithPush(orderInfoResult);
        }
        if (orderCarInfo.getId() == null) {
            this.orderCarInfoDao.insert((Object)orderCarInfo);
            log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u51fa\u5165\u8868\u5165\u573a\u90e8\u5206\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfoResult.getOrderNum());
        } else {
            this.orderCarInfoDao.updateById((Object)orderCarInfo);
            log.info("[\u79bb\u573a\u670d\u52a1] \u63d2\u5165\u8ba2\u5355\u51fa\u5165\u8868\u79bb\u573a\u90e8\u5206\u5b8c\u6210\uff0corderNum\uff1a{}", (Object)orderInfoResult.getOrderNum());
        }
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkId), String.class);
        if (version != null && PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c7.getIndex() && ObjectResponse.isSuccess((Response)(parkResp = this.parkService.findByParkId(parkId))) && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)((Park)parkResp.getData()).getNestType()) != 0) {
            OrderTrack trackParam = new OrderTrack().setType(Integer.valueOf(2)).setParkId(parkId).setOrderNum(orderInfoResult.getOrderNum()).setRegionId(orderInfoResult.getRegionId());
            int count = this.orderTrackService.count((Wrapper)this.orderTrackService.getLambdaQueryWrapper((Object)trackParam));
            if (!hasOrder || count == 0) {
                this.orderTrackService.saveBatch(this.buildTrack(orderInfoResult, orderCarInfo));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderId", orderId);
        map.put("orderNum", orderInfoResult.getOrderNum());
        List paidInfo = complateOrderRequest.getPaidInfo();
        if (paidInfo != null) {
            this.exitPayDealServiceImpl.exitPayDeal((ExitCommonRequest)complateOrderRequest, orderInfoResult, orderSonInfos);
        }
        this.exitPayDealServiceImpl.handleNotPayOrder((ExitCommonRequest)complateOrderRequest, orderInfoResult, channels[1], null);
        return ObjectResponse.success(map);
    }

    private OrderInfo handleOrderSon(OrderInfo mainOrder, OrderCarInfo mainOrderCarInfo, List<OrderSonInfo> orderSonInfos) {
        if (CollectionUtils.isEmpty(orderSonInfos)) {
            return mainOrder;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal paidAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal balancePrice = BigDecimal.ZERO;
        for (OrderSonInfo orderSonInfo : orderSonInfos) {
            if (orderSonInfo.getRegionId().equals(mainOrder.getRegionId())) {
                BeanUtils.copyProperties((Object)mainOrder, (Object)orderSonInfo, (String[])new String[]{"id"});
                OrderSonCarInfo orderSonCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId().longValue());
                BeanUtils.copyProperties((Object)mainOrderCarInfo, (Object)orderSonCarInfo, (String[])new String[]{"id"});
                this.orderSonInfoDao.updateById((Object)orderSonInfo);
                this.orderSonCarInfoDao.updateById((Object)orderSonCarInfo);
            }
            totalAmount = NumberUtils.decimalAdd((Object)totalAmount, (Object[])new Object[]{orderSonInfo.getTotalPrice()});
            paidAmount = NumberUtils.decimalAdd((Object)paidAmount, (Object[])new Object[]{orderSonInfo.getPaidPrice()});
            discountAmount = NumberUtils.decimalAdd((Object)discountAmount, (Object[])new Object[]{orderSonInfo.getDiscountPrice()});
            balancePrice = NumberUtils.decimalAdd((Object)balancePrice, (Object[])new Object[]{orderSonInfo.getBalancePrice()});
        }
        mainOrder.setHasSon(Integer.valueOf(1)).setTotalPrice(totalAmount.toString()).setPaidPrice(paidAmount.toString()).setDiscountPrice(discountAmount.toString()).setBalancePrice(balancePrice);
        return mainOrder;
    }
}

