/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.monthcar.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthRenewCardDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.open.domain.ApiBaseRequest;
import com.icetech.partner.domain.response.PHPResponse;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PhpOpenCarServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(PhpOpenCarServiceImpl.class);
    @Value(value="${third.php.pid}")
    private String pid;
    @Value(value="${third.php.key}")
    private String key;
    @Value(value="${third.php.url}")
    private String url;
    private static String serviceName = "openMonthCard";

    public ObjectResponse<Object> openAndCheckMonthCard(MonthOpenCardDto dto, Boolean isCheck) {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        if (isCheck.booleanValue()) {
            requestMap.put("monthCheck", 1);
        }
        requestMap.put("parkCode", dto.getParkCode());
        requestMap.put("orderId", dto.getOrderId());
        requestMap.put("productId", dto.getProductId());
        requestMap.put("buyNum", dto.getBuyNum());
        requestMap.put("phone", dto.getPhone());
        requestMap.put("cardProperty", dto.getCardProperty());
        requestMap.put("cardOwner", dto.getCardOwner());
        requestMap.put("startDate", DateUtil.format((Date)dto.getStartDate(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
        requestMap.put("endDate", this.getEndDate(dto));
        requestMap.put("mainAddress", dto.getMainAddress());
        requestMap.put("payMoney", dto.getPayMoney().setScale(2, 5).toString());
        requestMap.put("payMethod", dto.getPayMethod());
        requestMap.put("payChannel", dto.getPayChannel());
        requestMap.put("plateNumData", dto.getPlateNumData());
        requestMap.put("picData", dto.getPicData());
        requestMap.put("operator", StringUtils.isEmpty((CharSequence)dto.getUserName()) ? "\u516c\u4f17\u53f7" : "\u516c\u4f17\u53f7" + dto.getUserName());
        ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
        apiBaseRequest.setPid(this.pid);
        apiBaseRequest.setServiceName(serviceName);
        apiBaseRequest.setTimestamp(Long.valueOf(DateUtil.currentSeconds()));
        apiBaseRequest.setBizContent((Object)requestMap);
        try {
            apiBaseRequest.setSign(SignTools.sign((Object)apiBaseRequest, (String)this.key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String req = JsonUtils.toString((Object)apiBaseRequest);
        String resultString = HttpTools.postJson((String)(this.url + "/month/monthAdd"), (String)req);
        log.info("[php\u5f00\u5361\u63a5\u53e3] uir {} request {} response {}", new Object[]{this.url + "/month/monthAdd", req, resultString});
        PHPResponse resultMap = (PHPResponse)JSON.parseObject((String)resultString, PHPResponse.class);
        return ObjectResponse.instance((String)String.valueOf(resultMap.getCode()), (String)resultMap.getMsg(), (Object)resultMap.getData());
    }

    public ObjectResponse<Object> renewAndCheckMonthCard(MonthRenewCardDto dto, Boolean isCheck) {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        if (isCheck.booleanValue()) {
            requestMap.put("monthCheck", 1);
        }
        requestMap.put("parkCode", dto.getParkCode());
        requestMap.put("productId", dto.getProductId());
        requestMap.put("cardId", dto.getMonthId());
        requestMap.put("plotCount", dto.getPlotCount());
        requestMap.put("startDate", DateUtil.format((Date)dto.getStartDate(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
        requestMap.put("endDate", DateUtil.format((Date)dto.getEndDate(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
        requestMap.put("payMoney", dto.getPayMoney().setScale(2, 5).toString());
        requestMap.put("payMethod", dto.getPayMethod());
        requestMap.put("buyNum", dto.getBuyNum());
        requestMap.put("remark", dto.getRemark());
        requestMap.put("operator", "\u516c\u4f17\u53f7");
        ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
        apiBaseRequest.setPid(this.pid);
        apiBaseRequest.setServiceName(serviceName);
        apiBaseRequest.setTimestamp(Long.valueOf(DateUtil.currentSeconds()));
        apiBaseRequest.setBizContent((Object)requestMap);
        try {
            apiBaseRequest.setSign(SignTools.sign((Object)apiBaseRequest, (String)this.key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String req = JsonUtils.toString((Object)apiBaseRequest);
        String resultString = HttpTools.postJson((String)(this.url + "/month/monthRenew"), (String)req);
        log.info("[php\u7eed\u8d39\u63a5\u53e3] uir {} request {} response {}", new Object[]{this.url + "/month/monthRenew", req, resultString});
        PHPResponse resultMap = (PHPResponse)JSON.parseObject((String)resultString, PHPResponse.class);
        return ObjectResponse.instance((String)String.valueOf(resultMap.getCode()), (String)resultMap.getMsg(), (Object)resultMap.getData());
    }

    private String getEndDate(MonthOpenCardDto dto) {
        try {
            LinkedHashMap requestMap = Maps.newLinkedHashMap();
            requestMap.put("startTime", DateUtil.format((Date)dto.getStartDate(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
            requestMap.put("addDay", dto.getDiftDays());
            requestMap.put("buyNum", dto.getBuyNum());
            requestMap.put("duration", dto.getDuration());
            ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
            apiBaseRequest.setPid(this.pid);
            apiBaseRequest.setServiceName(serviceName);
            apiBaseRequest.setTimestamp(Long.valueOf(DateUtil.currentSeconds()));
            apiBaseRequest.setBizContent((Object)requestMap);
            apiBaseRequest.setSign(SignTools.sign((Object)apiBaseRequest, (String)this.key));
            String req = JsonUtils.toString((Object)apiBaseRequest);
            String resultString = HttpTools.postJson((String)(this.url + "/publicfun/getCardTime"), (String)req);
            log.info("[php\u83b7\u53d6\u65e5\u671f\u63a5\u53e3] uir {} request {} response {}", new Object[]{this.url + "/publicfun/getCardTime", req, resultString});
            PHPResponse resultMap = (PHPResponse)JSON.parseObject((String)resultString, PHPResponse.class);
            if (resultMap.getCode() == 200) {
                JSONObject res = JSONObject.parseObject((String)JSONUtil.toJsonStr((Object)resultMap.getData()));
                return res.getString("date");
            }
        }
        catch (Exception e) {
            log.error("[php\u83b7\u53d6\u65e5\u671f\u63a5\u53e3\u5931\u8d25]", (Throwable)e);
            return DateUtil.formatDate((Date)dto.getEndDate());
        }
        return DateUtil.formatDate((Date)dto.getEndDate());
    }
}

