/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.monthcar.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.dto.ParkRegionDto;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.api.month.MonthProductService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceInfo;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceMsgInfo;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.order.dao.OrderNotpayDao;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.third.anno.DS_SLAVE;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthProductService")
public class MonthProductServiceImpl
implements MonthProductService {
    private static final Logger log = LoggerFactory.getLogger(MonthProductServiceImpl.class);
    @Resource
    private MonthProductDao monthProductDao;
    @Resource
    private MonthInfoDao monthInfoDao;
    @Resource
    private MonthCarServiceImpl monthCarService;
    @Resource
    private ParkService parkService;
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private OrderNotpayDao orderNotpayDao;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkChargeconfigDao parkChargeconfigDao;
    public static final Integer VALID_CARD = 1;

    public MonthProduct selectMonthProductById(Long monthProductId) {
        return this.monthProductDao.selectById(monthProductId.longValue());
    }

    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum) {
        MonthInfo monthInfo = this.monthCarService.getMonthInfo(parkId, plateNum);
        if (monthInfo != null) {
            Long productId = monthInfo.getProductId();
            MonthProduct monthProduct = this.monthProductDao.selectById(productId.longValue());
            return ObjectResponse.success((Object)monthProduct);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = this.monthCarService.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo != null) {
            Long productId = monthInfo.getProductId();
            MonthProduct monthProduct = this.monthProductDao.selectById(productId.longValue());
            return ObjectResponse.success((Object)monthProduct);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode, Long monthInfoId) {
        MonthProduct monthProduct2;
        ObjectResponse parkResp = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)parkResp);
        Park park = (Park)parkResp.getData();
        List monthProducts = this.monthProductDao.selectListByParkId(park.getId());
        ArrayList monthProductDtos = Lists.newArrayList();
        MonthInfo monthInfo = this.monthInfoDao.load((long)Math.toIntExact(monthInfoId));
        Long productId = null;
        if (Objects.nonNull(monthInfo) && Objects.nonNull(monthProduct2 = this.monthProductDao.selectById(monthInfo.getProductId().longValue())) && monthProduct2.getStatus() == 1 && NumberUtils.toDouble((BigDecimal)monthProduct2.getPaymoney()) > 0.0) {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct2.getId());
            monthProductDto.setDuration(monthProduct2.getDuration());
            monthProductDto.setPaymoney(monthProduct2.getPaymoney());
            monthProductDto.setName(monthProduct2.getName());
            productId = monthProduct2.getId();
            monthProductDtos.add(monthProductDto);
        }
        Long finalProductId = productId;
        monthProducts.forEach(monthProduct -> {
            if (finalProductId != null && finalProductId.equals(monthProduct.getId())) {
                log.info("\u5f53\u524d\u6708\u5361\u4ea7\u54c1\u5df2\u7ecf\u5b58\u5728");
            } else if (NumberUtils.toDouble((BigDecimal)monthProduct.getPaymoney()) > 0.0) {
                MonthProductDto monthProductDto = new MonthProductDto();
                monthProductDto.setId(monthProduct.getId());
                monthProductDto.setDuration(monthProduct.getDuration());
                monthProductDto.setPaymoney(monthProduct.getPaymoney());
                monthProductDto.setName(monthProduct.getName());
                monthProductDtos.add(monthProductDto);
            }
        });
        return ObjectResponse.success((Object)monthProductDtos);
    }

    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode) {
        ObjectResponse parkResp = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)parkResp);
        Park park = (Park)parkResp.getData();
        List monthProducts = this.monthProductDao.selectListByParkId(park.getId());
        if (CollectionUtil.isEmpty((Collection)monthProducts)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List monthProductDtos = monthProducts.stream().map(monthProduct -> {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct.getId());
            monthProductDto.setDuration(monthProduct.getDuration());
            monthProductDto.setPaymoney(monthProduct.getPaymoney());
            monthProductDto.setName(monthProduct.getName());
            return monthProductDto;
        }).collect(Collectors.toList());
        return ObjectResponse.success(monthProductDtos);
    }

    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<ParkSpaceMsgInfo>> getParkSpacePage(ParkQuery parkQuery) {
        List parkList = this.parkDao.getParkList(parkQuery);
        if (CollectionUtils.isEmpty((Collection)parkList)) {
            return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)0, (long)0L, Collections.emptyList()));
        }
        Map parkMap = parkList.stream().collect(Collectors.toMap(ParkSpaceInfo::getId, Function.identity()));
        ArrayList<Long> parkIds = new ArrayList<Long>(parkMap.keySet());
        Page productsPage = PageHelper.startPage((int)parkQuery.getPageNo(), (int)parkQuery.getPageSize()).doSelectPage(() -> this.monthProductDao.selectListBy(parkIds, parkQuery.getCardType()));
        List monthProducts = productsPage.getResult();
        if (CollectionUtils.isEmpty((Collection)monthProducts)) {
            return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)productsPage.getPages(), (long)productsPage.getTotal(), Collections.emptyList()));
        }
        List<Long> products = monthProducts.stream().map(MonthProduct::getId).distinct().collect(Collectors.toList());
        Map<Long, Integer> monthInfoMap = this.getMonthPlateNumCount(products);
        List parkChargeconfigs = this.parkChargeconfigDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getDefaultCharge, (Object)1)).eq(ParkChargeconfig::getStatus, (Object)0)).in(ParkChargeconfig::getParkId, parkIds));
        Map<Long, List<ParkChargeconfig>> chargeConfigMap = parkChargeconfigs.stream().collect(Collectors.groupingBy(ParkChargeconfig::getParkId));
        Map regionDtoMap = this.parkRegionDao.getParkRegionListByProductId(products).stream().collect(Collectors.toMap(ParkRegionDto::getProductId, Function.identity()));
        List msgInfos = monthProducts.stream().map(monthProduct -> {
            Long parkId = monthProduct.getParkId();
            ParkSpaceMsgInfo info = new ParkSpaceMsgInfo();
            ParkSpaceInfo park = (ParkSpaceInfo)parkMap.get(parkId);
            if (park != null) {
                info.setId(park.getId());
                info.setParkCode(park.getParkCode());
                info.setParkName(park.getParkName());
                info.setParkProperty(park.getParkProperty());
                info.setLng(park.getLng());
                info.setLat(park.getLat());
                info.setLocation(park.getLocation());
            }
            MonthProductDto productDto = new MonthProductDto();
            BeanUtils.copyProperties((Object)monthProduct, (Object)productDto);
            productDto.setRemainMonthCards(this.calculateRemainMonthCards(monthProduct.getTotalOnlineQuantity(), (Integer)monthInfoMap.get(monthProduct.getId())));
            productDto.setRegionName(this.getRegionName(regionDtoMap, monthProduct.getId()));
            info.setMonthProduct(productDto);
            List parkChargeconfigList = (List)chargeConfigMap.get(parkId);
            if (CollectionUtils.isNotEmpty((Collection)parkChargeconfigList)) {
                info.setSBilltype(((ParkChargeconfig)parkChargeconfigList.get(0)).getBilltype());
            }
            return info;
        }).collect(Collectors.toList());
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)productsPage.getPages(), (long)productsPage.getTotal(), msgInfos));
    }

    public Map<Long, Integer> getMonthPlateNumCount(List<Long> productIds) {
        List monthInfos = this.monthInfoDao.getMonthInfosByProductIds(productIds);
        Map<Long, List<MonthInfo>> listMap = monthInfos.stream().collect(Collectors.groupingBy(MonthInfo::getProductId));
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        listMap.forEach((productId, monthInfoList) -> map.put((Long)productId, monthInfoList.size()));
        return map;
    }

    public Integer getMonthPlateNumCount(Long productId) {
        List monthInfos = this.monthInfoDao.getMonthInfosByProductIds(Collections.singletonList(productId));
        return monthInfos.size();
    }

    public Integer calculateRemainMonthCards(Integer totalOnlineQuantity, Integer presaleQuantity) {
        int remainMonthCards;
        if (totalOnlineQuantity == null) {
            totalOnlineQuantity = 0;
        }
        if (presaleQuantity == null) {
            presaleQuantity = 0;
        }
        if ((remainMonthCards = totalOnlineQuantity - presaleQuantity) < 0) {
            remainMonthCards = 0;
        }
        return remainMonthCards;
    }

    private String getRegionName(Map<Long, ParkRegionDto> regionDtoMap, Long productId) {
        ParkRegionDto regionDto = regionDtoMap.get(productId);
        if (Objects.isNull(regionDto)) {
            return "\u5168\u8f66\u573a";
        }
        if (regionDto.getRegionId() == 0L) {
            return "\u5168\u8f66\u573a";
        }
        return regionDto.getRegionNames();
    }

    public void getMonthStatus(MonthOpenCardDto req) {
        List list;
        if (req.getPlateNumData().isEmpty()) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u8f66\u724c!");
        }
        List monthInfos = this.monthInfoDao.getMonthInfosByProductIdAndPlateNum(((MonthOpenCardDto.PlateNumData)req.getPlateNumData().get(0)).getPlateNum(), req.getProductId());
        if (monthInfos.isEmpty()) {
            return;
        }
        List statusList = monthInfos.stream().map(MonthInfo::getCardStatus).collect(Collectors.toList());
        if (statusList.contains(2)) {
            throw new RuntimeException("\u5f53\u524d\u6709\u4e00\u4e2a\u5f85\u751f\u6548\u7684\u5957\u9910\u4e0d\u5141\u8bb8\u7eed\u8d39");
        }
        if (statusList.contains(1)) {
            if (req.getCardOpertype() == 1) {
                throw new RuntimeException("\u5f53\u524d\u6709\u4e00\u4e2a\u751f\u6548\u4e2d\u7684\u5957\u9910\u4e0d\u5141\u8bb8\u8d2d\u4e70");
            }
            return;
        }
        Integer count = this.getMonthPlateNumCount(req.getProductId().longValue());
        MonthProduct monthProduct = this.monthProductDao.selectById((long)req.getProductId().intValue());
        if (monthProduct.getTotalOnlineQuantity() - count <= 0) {
            throw new RuntimeException("\u6708\u5361\u5df2\u552e\u7f44");
        }
        if (monthProduct.getIsAllowedCardArrears() == 0 && !(list = this.orderNotpayDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderNotpay.class).eq(OrderNotpay::getPlateNum, (Object)((MonthOpenCardDto.PlateNumData)req.getPlateNumData().get(0)).getPlateNum())).in(OrderNotpay::getStatus, Arrays.asList(1, 4)))).isEmpty()) {
            throw new RuntimeException("\u8f66\u8f86\u6709\u6b20\u8d39\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458");
        }
    }

    public ObjectResponse<com.icetech.common.domain.Page<ParkSpaceMsgInfo>> getMonthById(Long productId) {
        MonthProduct monthProduct = this.monthProductDao.selectById(productId.longValue());
        if (Objects.isNull(monthProduct)) {
            return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)0, (long)0L, Collections.emptyList()));
        }
        Park park = this.parkDao.selectParkById(monthProduct.getParkId());
        Map<Long, Integer> monthInfoMap = this.getMonthPlateNumCount(Collections.singletonList(monthProduct.getId()));
        Map<Long, ParkRegionDto> regionDtoMap = this.parkRegionDao.getParkRegionListByProductId(Collections.singletonList(monthProduct.getId())).stream().collect(Collectors.toMap(ParkRegionDto::getProductId, Function.identity()));
        ArrayList<ParkSpaceMsgInfo> msgInfos = new ArrayList<ParkSpaceMsgInfo>();
        ParkSpaceMsgInfo info = new ParkSpaceMsgInfo();
        if (park != null) {
            info.setId(park.getId());
            info.setParkCode(park.getParkCode());
            info.setParkName(park.getParkName());
            info.setParkProperty(park.getParkProperty());
            info.setLng(Double.valueOf(park.getLng()));
            info.setLat(Double.valueOf(park.getLat()));
        }
        MonthProductDto productDto = new MonthProductDto();
        BeanUtils.copyProperties((Object)monthProduct, (Object)productDto);
        productDto.setRemainMonthCards(this.calculateRemainMonthCards(monthProduct.getTotalOnlineQuantity(), monthInfoMap.get(monthProduct.getId())));
        productDto.setRegionName(this.getRegionName(regionDtoMap, monthProduct.getId()));
        info.setMonthProduct(productDto);
        msgInfos.add(info);
        return ObjectResponse.success((Object)com.icetech.common.domain.Page.instance((int)1, (long)1L, msgInfos));
    }
}

