/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.monthcar.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.MonthrenewePubcheckService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthRenewCardDto;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.MonthCarRequest;
import com.icetech.cloudcenter.domain.request.MonthPayRequest;
import com.icetech.cloudcenter.domain.request.MonthReportRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthCardConfigDto;
import com.icetech.cloudcenter.domain.response.MonthCardDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.MonthInfoDto;
import com.icetech.cloudcenter.domain.response.MonthOrderCountDto;
import com.icetech.cloudcenter.domain.response.MonthOrderDto;
import com.icetech.cloudcenter.domain.response.MonthOrderResponseVo;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.cloudcenter.domain.response.MonthReportDto;
import com.icetech.cloudcenter.domain.response.MpMonthInvoiceResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthOrderDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthOrder;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.fee.domain.entity.monthcar.MonthSpace;
import com.icetech.fee.domain.entity.monthcar.MonthrenewePubcheck;
import com.icetech.fee.service.monthcar.MonthProductRegionService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.pnc.impl.IssuedCardServiceImpl;
import com.icetech.park.service.down.pnc.impl.ShowAndSayServiceImpl;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.park.service.monthcar.impl.PhpOpenCarServiceImpl;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="monthCarService")
public class MonthCarServiceImpl
extends MonthCarServiceBase
implements MonthCarService {
    private static final Logger log = LoggerFactory.getLogger(MonthCarServiceImpl.class);
    @Autowired
    private MonthOrderDao monthOrderDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private MonthProductRegionService monthProductRegionService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private MonthrenewePubcheckService monthrenewePubcheckService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private ShowAndSayServiceImpl showAndSayServiceImpl;
    @Autowired
    private IssuedCardServiceImpl issuedCardService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private PhpOpenCarServiceImpl phpOpenCarService;
    @Autowired
    private ParkRegionDao regionDao;
    public static final Integer SOURCE = 2;
    @Autowired
    private MonthPlateDao monthPlateDao;

    public ObjectResponse<MonthReportDto> countMonthCarReport(MonthReportRequest monthReportRequest) {
        try {
            MonthReportDto monthReportDto = this.monthInfoDao.getMonthCardReport(monthReportRequest.getParkIdList(), monthReportRequest.getStartTime(), monthReportRequest.getEndTime());
            if (Objects.isNull(monthReportDto)) {
                MonthReportDto dto = new MonthReportDto();
                dto.setMonthTotalCount(0.0);
                dto.setAddMonthCount(Integer.valueOf(0));
                dto.setAddMonthMoney(0.0);
                dto.setRenewMonthMoney(0.0);
                dto.setRenewMonthCount(Integer.valueOf(0));
                dto.setRefundMoney(0.0);
                return ObjectResponse.success((Object)dto);
            }
            double total = monthReportDto.getAddMonthMoney() + monthReportDto.getRenewMonthMoney() - monthReportDto.getRefundMoney();
            monthReportDto.setMonthTotalCount(total);
            return ObjectResponse.success((Object)monthReportDto);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. monthReportRequest[{}]", new Object[]{e.getMessage(), monthReportRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
    }

    public ObjectResponse<List<MonthInfoDto>> getMonthCarList(String parkCode, String plateNumber, List<Integer> cardStatus, Integer pageNo, Integer pageSize, String startTime, String endTime, String cardOwner, String telephone, String productName, Integer validDays, Integer cardProperty) {
        try {
            List records;
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            if (parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            PageHelper.startPage((int)pageNo, (int)pageSize);
            String validDay = "";
            if (validDays != null) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c = Calendar.getInstance();
                c.add(5, validDays);
                validDay = sf.format(c.getTime());
            }
            if (CollectionUtils.isEmpty((Collection)(records = this.monthInfoDao.selectMonthRecords(parkid, plateNumber, cardStatus, startTime, endTime, cardOwner, telephone, productName, validDay, cardProperty)))) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            return ObjectResponse.success((Object)records);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u6708\u5361\u63a5\u53e3]\u5f02\u5e38: {}. parkCode[{}], plateNumber[{}], cardStatus[{}], pageNo[{}], pageSize[{}], startTime[{}], endTime[{}], cardOwner[{}], telephone[{}], productName[{}], validDays[{}], cardProperty[{}]", new Object[]{e.getMessage(), parkCode, plateNumber, cardStatus, pageNo, pageSize, startTime, endTime, cardOwner, telephone, productName, validDays, cardProperty, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Map<String, Object>> countMonthCarList(String parkCode, String plateNumber, List<Integer> cardStatus, String startTime, String endTime, String cardOwner, String telephone, String productName, Integer validDays, Integer cardProperty) {
        try {
            String[] split = parkCode.split(",");
            String parkid = this.parkDao.selectByCodes(split);
            String validDay = "";
            if (validDays != null) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c = Calendar.getInstance();
                c.add(5, validDays);
                validDay = sf.format(c.getTime());
            }
            int records = this.monthInfoDao.countMonthRecords(parkid, plateNumber, cardStatus, startTime, endTime, cardOwner, telephone, productName, validDay, cardProperty);
            HashMap<String, Integer> retMap = new HashMap<String, Integer>();
            retMap.put("count", records);
            return ObjectResponse.success(retMap);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u6708\u5361\u63a5\u53e3]\u5f02\u5e38: {}. parkCode[{}], plateNumber[{}], cardStatus[{}], startTime[{}], endTime[{}], cardOwner[{}], telephone[{}], productName[{}], validDays[{}], cardProperty[{}]", new Object[]{e.getMessage(), parkCode, plateNumber, cardStatus, startTime, endTime, cardOwner, telephone, productName, validDays, cardProperty, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<MonthInfoDto> getMonthCarDetail(String parkCode, Integer recordId) {
        try {
            Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
            if (Objects.isNull(park)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            MonthInfoDto monthInfoDto = this.monthInfoDao.selectMonthRecord(park.getId(), recordId);
            if (monthInfoDto == null) {
                return ObjectResponse.failed((String)"404", (String)"\u6708\u5361\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            monthInfoDto.setParkName(park.getParkName());
            return ObjectResponse.success((Object)monthInfoDto);
        }
        catch (Exception e) {
            log.error("[\u8f66\u573a\u7ba1\u5bb6\u83b7\u53d6\u6708\u5361\u8be6\u60c5\u63a5\u53e3]\u5f02\u5e38: {}. parkCode[{}], recordId[{}]", new Object[]{e.getMessage(), parkCode, recordId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<MonthRecord> getMonthRecordById(Integer recordId) {
        MonthRecord record = (MonthRecord)this.monthRecordDao.selectById((Serializable)recordId);
        return ObjectResponse.returnNotFoundIfNull((Object)record);
    }

    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum) {
        MonthInfo monthInfo = this.getMonthInfo(parkId, plateNum);
        if (this.judgeMonthCar(parkId, plateNum, null, monthInfo).booleanValue()) {
            return ObjectResponse.success((Object)monthInfo);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, String channelCode) {
        MonthInfo monthInfo;
        ObjectResponse objectResponse;
        Long regionId = null;
        if (StringUtils.isNotBlank((CharSequence)channelCode) && (objectResponse = this.parkService.getInOutDeviceByCode(parkId, channelCode)).getData() != null) {
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)objectResponse.getData();
            regionId = parkInoutdevice.getRegionId();
        }
        if (this.judgeMonthCar(parkId, plateNum, regionId, monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD)).booleanValue()) {
            return ObjectResponse.success((Object)monthInfo);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo != null && this.judgeMonthCar(parkId, plateNum, regionId, monthInfo).booleanValue()) {
            return ObjectResponse.success((Object)monthInfo);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum) {
        MonthInfo monthInfo = this.getMonthInfo(parkId, plateNum);
        if (monthInfo != null) {
            long productId = monthInfo.getProductId();
            MonthProduct monthProduct = this.monthProductDao.selectById(productId);
            return ObjectResponse.success((Object)monthProduct);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo != null) {
            long productId = monthInfo.getProductId();
            MonthProduct monthProduct = this.monthProductDao.selectById(productId);
            return ObjectResponse.success((Object)monthProduct);
        }
        return ObjectResponse.failed((String)"404", (String)CodeConstants.getName((String)"404"));
    }

    public ObjectResponse<MonthInfoDto> getNewestMonthCar(Long parkId, String plateNum, String phone) {
        MonthCarRequest monthCarRequest = new MonthCarRequest();
        monthCarRequest.setParkId(parkId);
        monthCarRequest.setPlateNum(plateNum);
        monthCarRequest.setPhone(phone);
        MonthInfoDto monthInfo = this.monthInfoDao.selectMonthCarExtend(monthCarRequest);
        if (monthInfo != null) {
            return ObjectResponse.success((Object)monthInfo);
        }
        return ObjectResponse.failed((String)"404");
    }

    @DS_SLAVE
    public ObjectResponse<List<MonthInfoDto>> getMonthCarList(String searchKey, List<String> plateNums, Integer pageNo, Integer pageSize) {
        List monthInfoDtos;
        PageHelper.startPage((int)pageNo, (int)pageSize);
        boolean hasChinese = false;
        if (searchKey != null) {
            hasChinese = (searchKey = searchKey.toUpperCase()).length() != searchKey.getBytes().length;
        }
        if (CollectionUtil.isEmpty((Collection)(monthInfoDtos = hasChinese ? this.monthInfoDao.selectMonthCarListByPlateNum(searchKey) : this.monthInfoDao.selectMonthCarList(searchKey)))) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthInfoDtos);
    }

    @DS_SLAVE
    public ObjectResponse<List<MonthInfoDto>> getAppletMonthCarList(String searchKey, List<String> plateNums, Integer pageNo, Integer pageSize) {
        List monthInfoDtos;
        PageHelper.startPage((int)pageNo, (int)pageSize);
        int searchType = 1;
        if (searchKey != null && searchKey.trim().length() == 11) {
            searchType = 2;
        }
        if (CollectionUtil.isEmpty((Collection)(monthInfoDtos = searchType == 1 ? this.monthInfoDao.selectAppletMonthCarListByPlateNum(searchKey, plateNums) : this.monthInfoDao.selectAppletMonthCarListByPhone(searchKey, plateNums)))) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        monthInfoDtos.forEach(monthInfoDto -> {
            Park park = (Park)this.parkService.findByParkId(monthInfoDto.getParkId()).getData();
            ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(monthInfoDto.getParkId()).getData();
            if (Objects.nonNull(parkConfig)) {
                monthInfoDto.setRenewLimitDay(parkConfig.getRenewLimitDay());
            }
            if (Objects.nonNull(park)) {
                monthInfoDto.setParkName(park.getParkName());
                monthInfoDto.setParkCode(park.getParkCode());
            }
        });
        return ObjectResponse.success((Object)monthInfoDtos);
    }

    @DS_SLAVE
    public ObjectResponse<MonthInfoDto> getAppletMonthCarDetail(Long monthId) {
        Set regionIds;
        List parkRegions;
        MonthInfoDto monthInfoDto = new MonthInfoDto();
        MonthInfo monthInfo = this.monthInfoDao.load(monthId.longValue());
        monthInfoDto.setId(Integer.valueOf(Math.toIntExact(monthId)));
        monthInfoDto.setCardOwner(monthInfo.getCardOwner());
        monthInfoDto.setPlotCount(monthInfo.getPlotCount());
        monthInfoDto.setStatus(monthInfo.getCardStatus());
        monthInfoDto.setPhone(monthInfo.getPhone());
        monthInfoDto.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
        List monthRegions = this.monthRegionDao.selectByMonthId(monthId.longValue());
        if (CollectionUtil.isNotEmpty((Collection)monthRegions) && CollectionUtil.isNotEmpty((Collection)(parkRegions = this.parkRegionDao.selectBatchIds(regionIds = monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toSet()))))) {
            monthInfoDto.setRegionName(parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.joining(",")));
        }
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(monthInfo.getParkId().longValue());
        monthInfoDto.setRenewLimitDay(parkConfig.getRenewLimitDay());
        return ObjectResponse.success((Object)monthInfoDto);
    }

    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode, Long monthInfoId) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed((String)"1000", (String)"\u8f66\u573a\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List monthProducts = this.monthProductDao.selectListByParkId(park.getId());
        List<MonthProductDto> results = Lists.newArrayList();
        MonthInfo monthInfo = this.monthInfoDao.load((long)Math.toIntExact(monthInfoId));
        if (monthInfo == null) {
            return ObjectResponse.success((Object)results);
        }
        MonthProduct monthProduct = this.monthProductDao.selectById(monthInfo.getProductId().longValue());
        results = results.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MonthProductDto>(Comparator.comparing(MonthProductDto::getId))), ArrayList::new));
        results.addAll(monthProducts.stream().filter(Objects::nonNull).filter(m -> m.getCheckStatus() == 1).filter(m -> m.getPaymoney().compareTo(BigDecimal.ZERO) > 0).filter(m -> m.getBuyChannel() == 1).filter(m -> m.getRenewAlscope() != null && m.getRenewAlscope() == 0).map(product -> {
            MonthProductDto dto = new MonthProductDto();
            dto.setId(product.getId());
            dto.setDuration(product.getDuration());
            dto.setPaymoney(product.getPaymoney());
            dto.setName(product.getName());
            if (product.getSupportRegion() == 1) {
                dto.setRegionName(this.monthProductRegionService.getRegionName(product.getId()));
            } else {
                String regionName = null;
                if (product.getId().equals(monthProduct.getId())) {
                    List monthRegions = this.monthRegionDao.selectByMonthId(monthInfoId.longValue());
                    if (CollectionUtils.isNotEmpty((Collection)monthRegions)) {
                        List parkRegions = this.parkRegionDao.selectBatchIds((Collection)monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toList()));
                        regionName = StrUtil.join((CharSequence)"/", (Iterable)parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
                    } else {
                        regionName = "\u5168\u8f66\u573a";
                    }
                }
                if (StringUtils.isEmpty(regionName)) {
                    regionName = "\u5168\u8f66\u573a";
                }
                dto.setRegionName(regionName);
            }
            return dto;
        }).collect(Collectors.toList()));
        if (monthProduct != null && monthProduct.getStatus() == 1 && NumberUtils.toDouble((BigDecimal)monthProduct.getPaymoney()) > 0.0 && monthProduct.getRenewAlscope() == 1 && monthProduct.getBuyChannel() == 1) {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct.getId());
            monthProductDto.setDuration(monthProduct.getDuration());
            monthProductDto.setPaymoney(monthProduct.getPaymoney());
            monthProductDto.setName(monthProduct.getName());
            if (monthProduct.getSupportRegion() == 1) {
                monthProductDto.setRegionName(this.monthProductRegionService.getRegionName(monthProduct.getId()));
            } else {
                String regionName;
                List monthRegions = this.monthRegionDao.selectByMonthId(monthInfoId.longValue());
                if (CollectionUtils.isNotEmpty((Collection)monthRegions)) {
                    List parkRegions = this.parkRegionDao.selectBatchIds((Collection)monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toList()));
                    regionName = StrUtil.join((CharSequence)"/", (Iterable)parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
                } else {
                    regionName = "\u5168\u8f66\u573a";
                }
                if (StringUtils.isEmpty((CharSequence)regionName)) {
                    regionName = "\u5168\u8f66\u573a";
                }
                monthProductDto.setRegionName(regionName);
            }
            results.add(monthProductDto);
        }
        return ObjectResponse.success(results);
    }

    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        List monthProducts = this.monthProductDao.selectListByParkId(park.getId());
        ArrayList monthProductDtos = Lists.newArrayList();
        if (CollectionUtil.isEmpty((Collection)monthProducts)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        monthProducts.forEach(monthProduct -> {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct.getId());
            monthProductDto.setDuration(monthProduct.getDuration());
            monthProductDto.setPaymoney(monthProduct.getPaymoney());
            monthProductDto.setName(monthProduct.getName());
            monthProductDtos.add(monthProductDto);
        });
        return ObjectResponse.success((Object)monthProductDtos);
    }

    public ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Integer mpUserId, Date startTime, Date endTime, List<Integer> optionTypes, Integer pageNo, Integer pageSize) {
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List monthOrderDtos = this.monthOrderDao.selectMonthOrderList(mpUserId, optionTypes, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
        if (CollectionUtil.isEmpty((Collection)monthOrderDtos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        monthOrderDtos.forEach(monthOrderDto -> {
            MonthrenewePubcheck monthrenewePubcheck;
            if (Objects.isNull(monthOrderDto.getMonthRecordId()) && Objects.nonNull(monthrenewePubcheck = this.monthrenewePubcheckService.selectByTradeNo(monthOrderDto.getTradeNo()))) {
                monthOrderDto.setStartTime(monthrenewePubcheck.getStartTime());
                monthOrderDto.setEndTime(monthrenewePubcheck.getEndTime());
                monthOrderDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                monthOrderDto.setPhone(monthrenewePubcheck.getPhone());
                monthOrderDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                if (monthrenewePubcheck.getCardOpertype() == 1) {
                    monthOrderDto.setCardStatus(Integer.valueOf(98));
                }
                if (monthrenewePubcheck.getCardOpertype() == 3) {
                    monthOrderDto.setCardStatus(Integer.valueOf(99));
                }
                monthOrderDto.setCardOpertype(monthrenewePubcheck.getCardStatus());
            }
        });
        return ObjectResponse.success((Object)monthOrderDtos);
    }

    public ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Long accountId, String plateNum, Date startTime, Date endTime, Integer bizType, Integer pageNo, Integer pageSize) {
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List monthOrderDtos = this.monthOrderDao.selectMonthOrderListV2(accountId, plateNum, bizType, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
        if (CollectionUtil.isEmpty((Collection)monthOrderDtos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        monthOrderDtos.forEach(monthOrderDto -> {
            MonthrenewePubcheck monthrenewePubcheck;
            if (Objects.isNull(monthOrderDto.getMonthRecordId()) && Objects.nonNull(monthrenewePubcheck = this.monthrenewePubcheckService.selectByTradeNo(monthOrderDto.getTradeNo()))) {
                monthOrderDto.setStartTime(monthrenewePubcheck.getStartTime());
                monthOrderDto.setEndTime(monthrenewePubcheck.getEndTime());
                monthOrderDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                monthOrderDto.setPhone(monthrenewePubcheck.getPhone());
                monthOrderDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                if (monthrenewePubcheck.getCardOpertype() == 1) {
                    monthOrderDto.setCardStatus(Integer.valueOf(98));
                }
                if (monthrenewePubcheck.getCardOpertype() == 3) {
                    monthOrderDto.setCardStatus(Integer.valueOf(99));
                }
                monthOrderDto.setCardOpertype(monthrenewePubcheck.getCardStatus());
            }
        });
        return ObjectResponse.success((Object)monthOrderDtos);
    }

    public ObjectResponse<MonthOrderDto> getMonthOrderDetail(Long monthOrderId) {
        MonthrenewePubcheck monthrenewePubcheck;
        MonthOrderDto monthOrderDetail = this.monthOrderDao.getMonthOrderDetail(monthOrderId);
        if (Objects.isNull(monthOrderDetail)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        if (Objects.isNull(monthOrderDetail.getMonthRecordId()) && Objects.nonNull(monthrenewePubcheck = this.monthrenewePubcheckService.selectByTradeNo(monthOrderDetail.getTradeNo()))) {
            MonthProduct monthProduct = this.monthProductDao.selectById((long)monthrenewePubcheck.getProductId().intValue());
            monthOrderDetail.setId(monthOrderId);
            monthOrderDetail.setParkId(monthOrderDetail.getParkId());
            monthOrderDetail.setParkCode(monthOrderDetail.getParkCode());
            monthOrderDetail.setParkName(monthOrderDetail.getParkName());
            monthOrderDetail.setPlateNumber(monthrenewePubcheck.getPlateNum());
            monthOrderDetail.setCardOwner(monthrenewePubcheck.getCardOwner());
            monthOrderDetail.setProductName(monthProduct.getName());
            monthOrderDetail.setProductId(Integer.valueOf(Math.toIntExact(monthProduct.getId())));
            monthOrderDetail.setPaymoney(monthProduct.getPaymoney().setScale(2, 4).toString());
            monthOrderDetail.setDuration(monthProduct.getDuration());
            monthOrderDetail.setPlotCount(monthrenewePubcheck.getPlotCount().intValue());
            monthOrderDetail.setCount(monthrenewePubcheck.getCount().intValue());
            monthOrderDetail.setStartTime(monthrenewePubcheck.getStartTime());
            monthOrderDetail.setEndTime(monthrenewePubcheck.getEndTime());
            monthOrderDetail.setRemark("\u7eed\u8d39\u65f6\u95f4\uff1a" + DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5", (Date)monthrenewePubcheck.getStartTime()) + "-" + DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5", (Date)monthrenewePubcheck.getEndTime()));
            monthOrderDetail.setPhone(monthrenewePubcheck.getPhone());
            monthOrderDetail.setCardOpertype(monthrenewePubcheck.getCardStatus());
            monthOrderDetail.setOperAccount(monthrenewePubcheck.getOperAccount());
            monthOrderDetail.setOperTime(monthrenewePubcheck.getCreateTime());
            monthOrderDetail.setCardStatus(Integer.valueOf(2));
            monthOrderDetail.setPayChannel(monthOrderDetail.getPayChannel());
            monthOrderDetail.setPayMethod(monthOrderDetail.getPayMethod());
            monthOrderDetail.setPayTime(monthOrderDetail.getPayTime());
            monthOrderDetail.setTotalPrice(monthOrderDetail.getTotalPrice());
        }
        Integer productId = monthOrderDetail.getProductId();
        String regionName = this.monthProductRegionService.getRegionName(Long.valueOf(productId.intValue()));
        monthOrderDetail.setRegionName(regionName);
        return ObjectResponse.success((Object)monthOrderDetail);
    }

    public MonthProduct selectMonthProductById(Integer monthProductId) {
        return this.monthProductDao.selectById((long)monthProductId.intValue());
    }

    public MonthInfo selectMonthInfotById(Integer monthInfoId) {
        return this.monthInfoDao.load((long)monthInfoId.intValue());
    }

    public ObjectResponse<Void> saveMonthOrder(MonthOrder monthOrder) {
        Long parkId = monthOrder.getParkId();
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess((Response)configObjectResponse) && ((ParkConfig)configObjectResponse.getData()).getIsEpayment() == 1) {
            monthOrder.setEpayment(((ParkConfig)configObjectResponse.getData()).getEPayment());
        }
        this.monthOrderDao.insert(monthOrder);
        return ObjectResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public ObjectResponse<Void> finishMonthPay(MonthPayRequest monthPayRequest) {
        boolean result;
        Date startDate = monthPayRequest.getStartTime();
        String tradeNo = monthPayRequest.getTradeNo();
        long productId = monthPayRequest.getProductId().intValue();
        long monthInfoId = monthPayRequest.getMonthInfoId().intValue();
        MonthOrder monthOrder = this.monthOrderDao.selectByTradeNoAndPayStatus(tradeNo, Integer.valueOf(1));
        if (Objects.isNull(monthOrder) || monthOrder.getPayStatus() == 2) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_405);
        }
        MonthInfo monthInfo = this.monthInfoDao.load(monthInfoId);
        if (Objects.isNull(monthInfo)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_710);
        }
        int cardStatus = monthInfo.getCardStatus();
        long id = monthInfo.getId();
        MonthProduct monthProduct = this.monthProductDao.selectById(productId);
        if (Objects.isNull(monthProduct)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_710);
        }
        int diftDay = 0;
        if (monthProduct.getIsDiftDay() == 1) {
            diftDay = monthProduct.getDiftDays();
        }
        List plateNums = this.monthInfoDao.selectPlateNums(monthInfo.getId().longValue());
        log.info("\u8f66\u724c\u53f7[{}]", (Object)plateNums);
        List spaces = this.monthInfoDao.selectSpaces(monthInfo.getId());
        List monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue());
        MonthRecord monthRecord = new MonthRecord();
        ObjectResponse configObject = this.parkService.getParkConfig(monthInfo.getParkId());
        if (!ObjectResponse.isSuccess((Response)configObject) || Objects.isNull(configObject.getData())) {
            throw new ResponseBodyException("1000", "\u8f66\u573a\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ParkConfig parkConfig = (ParkConfig)configObject.getData();
        List regionIds = monthRegions.stream().filter(Objects::nonNull).map(m -> Math.toIntExact(m.getRegionId())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(regionIds)) {
            regionIds = Collections.singletonList(0);
        }
        if (monthProduct.getRenewstatusValid() == 1) {
            log.info("\u6708\u5361\u8fdb\u5165\u4eba\u5de5\u5ba1\u6838,\u4ea4\u6613\u5355\u53f7:[{}] \u6708\u5361\u8ba2\u72b6\u6001[{}]", (Object)tradeNo, (Object)monthOrder.getPayStatus());
            if (monthProduct.getSupportRegion() == 1) {
                regionIds = this.monthProductRegionService.getRegionIds(monthProduct.getId());
            }
            this.addMonthCardRenewRecode(MonthrenewePubcheck.builder().monthId(Integer.valueOf((int)monthInfoId)).productId(Integer.valueOf((int)productId)).parkId(Integer.valueOf(Math.toIntExact(parkConfig.getParkId()))).cardProperty(Integer.valueOf(monthInfo.getCardProperty())).cardOwner(monthInfo.getCardOwner()).plateNum(plateNums.stream().filter(Objects::nonNull).collect(Collectors.joining(","))).spaceNum(spaces.stream().filter(Objects::nonNull).collect(Collectors.joining(","))).regionId(StrUtil.join((CharSequence)",", (Iterable)regionIds)).phone(monthInfo.getPhone()).cardStatus(Integer.valueOf(monthInfo.getProductId() != productId || DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)startDate) > 1 ? 1 : 2)).cardOpertype(Integer.valueOf(1)).plotCount(Integer.valueOf(monthInfo.getPlotCount())).count(monthPayRequest.getProductNum()).payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice()).payMethod(Integer.valueOf(2)).tradeNo(monthOrder.getTradeNo()).refund(BigDecimal.ZERO).startTime(monthPayRequest.getStartTime()).endTime(monthPayRequest.getEndTime()).renewAccount(String.valueOf(monthOrder.getMpUserId())).operAccount(monthPayRequest.getUserName()).addDay(String.valueOf(diftDay)).payChannel(Integer.valueOf(3)).build());
            monthOrder.setPayStatus(2);
            monthOrder.setPayTime(Math.toIntExact(monthPayRequest.getPayTime()));
            this.monthOrderDao.update(monthOrder);
            return ObjectResponse.success();
        }
        if (monthInfo.getProductId() != productId || DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)startDate) > 1) {
            log.info("[\u6708\u5361\u7eed\u8d39]\u65b0\u5361\u5f00\u5904\u7406\u8bf7\u6c42\u53c2\u6570[{}]", (Object)monthPayRequest);
            monthInfo.setProductId(Long.valueOf(productId));
            monthInfo.setStartTime(startDate);
            if (startDate.getTime() > System.currentTimeMillis()) {
                monthInfo.setCardStatus(CardStatusConstants.\u5f85\u751f\u6548.intValue());
            } else {
                monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            }
            monthInfo.setOperAccount(monthPayRequest.getUserName());
            monthInfo.setEndTime(monthPayRequest.getEndTime());
            monthInfo.setCount(monthPayRequest.getProductNum().intValue());
            monthInfo.setPayMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice());
            this.monthInfoDao.insert(monthInfo);
            if (cardStatus == 4) {
                MonthInfo updateEntity = new MonthInfo();
                updateEntity.setId(Long.valueOf(id));
                updateEntity.setDeleteStatus(Integer.valueOf(1));
                updateEntity.setOperAccount("system");
                this.monthInfoDao.updateById(updateEntity);
                log.info("[\u6708\u5361\u7eed\u8d39] \u8fc7\u671f\u6708\u5361\u6309\u65b0\u5f00\u5361, \u66f4\u65b0\u8fc7\u671f\u5361\u4e3a\u5220\u9664, id[{}]", (Object)id);
            }
            plateNums.forEach(s -> {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(s);
                this.monthPlateDao.insert(monthPlate);
            });
            spaces.forEach(s -> {
                MonthSpace monthSpace = new MonthSpace();
                monthSpace.setMonthId(monthInfo.getId());
                monthSpace.setSpaceNum(s);
                this.monthPlateDao.insertSpace(monthSpace);
            });
            log.info("[\u65b0\u5f00\u6708\u5361] monthInfo:{}", (Object)JsonUtils.toString((Object)monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u65b0\u589e.getType());
            regionIds = monthProduct.getSupportRegion() == 1 ? this.monthProductRegionService.getRegionIds(monthProduct.getId()) : Collections.singletonList(0);
            if (CollectionUtils.isNotEmpty((Collection)regionIds)) {
                this.monthRegionDao.deleteByMonthId(Integer.valueOf(Math.toIntExact(monthInfo.getId())));
                regionIds.forEach(regionId -> {
                    MonthRegion monthRegion = new MonthRegion();
                    monthRegion.setMonthId(monthInfo.getId());
                    monthRegion.setRegionId(Long.valueOf(regionId.intValue()));
                    this.monthRegionDao.insert(monthRegion);
                });
            }
        } else {
            monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            monthInfo.setOperAccount(monthPayRequest.getUserName());
            monthInfo.setEndTime(monthPayRequest.getEndTime());
            monthInfo.setCount(monthPayRequest.getProductNum().intValue());
            monthInfo.setUpdateTime((Date)DateUtil.date());
            monthInfo.setPayMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice());
            this.monthInfoDao.update(monthInfo);
            monthRecord.setMonthId(Long.valueOf(monthInfoId));
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u7eed\u8d39.getType());
            monthRecord.setIsOverdue(Integer.valueOf(0));
            if (monthProduct.getSupportRegion() == 1) {
                regionIds = this.monthProductRegionService.getRegionIds(monthProduct.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)regionIds)) {
                this.monthRegionDao.deleteByMonthId(Integer.valueOf(Math.toIntExact(monthInfo.getId())));
                regionIds.forEach(regionId -> {
                    MonthRegion monthRegion = new MonthRegion();
                    monthRegion.setMonthId(monthInfo.getId());
                    monthRegion.setRegionId(Long.valueOf(regionId.intValue()));
                    this.monthRegionDao.insert(monthRegion);
                });
            }
        }
        monthRecord.setProductId(Long.valueOf(productId));
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
        monthRecord.setCount(monthPayRequest.getProductNum());
        monthRecord.setPayMoney(Double.valueOf(monthOrder.getTotalPrice() == null ? 0.0 : monthOrder.getTotalPrice().doubleValue()));
        monthRecord.setPayMethod(MonthRecord.PayMethod.\u5fae\u4fe1.getType());
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark("\u7eed\u8d39\u65f6\u95f4\uff1a" + DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5", (Date)startDate) + "-" + DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5", (Date)monthPayRequest.getEndTime()));
        String pj = String.join((CharSequence)",", plateNums);
        String sj = String.join((CharSequence)",", spaces);
        String rg = StrUtil.join((CharSequence)",", (Iterable)regionIds);
        monthRecord.setPlateNum(pj);
        monthRecord.setSpaceNum(sj);
        monthRecord.setRegionId(rg);
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        monthRecord.setPayChannel(Integer.valueOf(3));
        this.monthRecordDao.insert((Object)monthRecord);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
        this.sendInfoDao.insert((Object)sendInfo);
        log.info("[\u6dfb\u52a0\u6708\u5361\u8bb0\u5f55] monthRecord:{}", (Object)JsonUtils.toString((Object)monthRecord));
        monthOrder.setPayStatus(2);
        monthOrder.setPayTime(Math.toIntExact(monthPayRequest.getPayTime()));
        monthOrder.setMonthRecordId(monthRecord.getId());
        monthOrder.setOutTradeNo(monthPayRequest.getOutTradeNo());
        this.monthOrderDao.update(monthOrder);
        boolean bl = result = Objects.nonNull(monthPayRequest.getSource()) && SOURCE.equals(monthPayRequest.getSource());
        if (result && monthProduct.getRenewstatusValid() == 0 && StringUtils.isNotBlank((CharSequence)monthPayRequest.getOrderNum())) {
            ObjectResponse orderObject = this.orderService.findByOrderNum(monthPayRequest.getOrderNum());
            if (!ObjectResponse.isSuccess((Response)orderObject) || Objects.isNull(orderObject.getData())) {
                throw new ResponseBodyException("1000", "\u51fa\u53e3\u6708\u5361\u7f34\u8d39\u672a\u627e\u5230\u505c\u8f66\u8ba2\u5355");
            }
            OrderInfo order = (OrderInfo)orderObject.getData();
            if (CollectionUtils.isEmpty((Collection)plateNums) || !plateNums.contains(order.getPlateNum())) {
                log.info("\u5f53\u524d\u7eed\u8d39\u8f66\u724c[{}]\u548c\u901a\u9053\u8f66\u724c[{}]\u6ca1\u6709\u5173\u7cfb, \u76f4\u63a5\u8fd4\u56de", (Object)plateNums, (Object)order.getPlateNum());
                return ObjectResponse.success();
            }
            Date exitTime = order.getExitTime() == null ? new Date() : new Date(order.getExitTime() * 1000L);
            Date enterTime = new Date(order.getEnterTime() * 1000L);
            if (DateTools.judge((Date)monthPayRequest.getStartTime(), (Date)monthPayRequest.getEndTime(), (Date)enterTime, (Date)exitTime)) {
                log.info("\u81ea\u52a8\u7eed\u8d39\u5b58\u5728\u4ea4\u96c6\u6708\u5361\u5f00\u59cb\u65f6\u95f4[{}],\u6708\u5361\u7ed3\u675f\u65f6\u95f4[{}],\u5165\u573a\u65f6\u95f4[{}],\u79bb\u573a\u65f6\u95f4[{}]", new Object[]{monthPayRequest.getStartTime(), monthPayRequest.getEndTime(), enterTime, exitTime});
                ObjectResponse parkObjectResponse = this.parkService.findByParkId(monthInfo.getParkId());
                Park park = (Park)parkObjectResponse.getData();
                if (!parkConfig.getDataCollection().equals(DataCollectionEnum.\u7aef\u7f51\u4e91.getType())) {
                    CarExitRequest exit = this.cacheHandle.getExit(park.getParkCode(), monthPayRequest.getChannelCode());
                    if (exit != null) {
                        log.info("\u81ea\u52a8\u7eed\u8d39\u8fdb\u5165\u7aef\u4e91\u4e1a\u52a1\u83b7\u53d6\u7f13\u51b2\u8f66\u9053\u4fe1\u606f[{}]", (Object)exit);
                        ObjectResponse feeObject = this.orderService.p2cQueryFee(order, parkConfig, monthPayRequest.getChannelCode());
                        if (ObjectResponse.isSuccess((Response)feeObject) && feeObject.getData() != null) {
                            QueryOrderFeeResponse fee = (QueryOrderFeeResponse)feeObject.getData();
                            log.info("\u81ea\u52a8\u7eed\u8d39\u8fdb\u5165\u7aef\u4e91\u91cd\u65b0\u8ba1\u8d39[{}]", (Object)fee);
                            BigDecimal payPrice = new BigDecimal(fee.getUnpayPrice());
                            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(park.getParkCode(), monthPayRequest.getChannelCode());
                            if (channelFee != null && exit.getOrderNum() != null && exit.getOrderNum().equals(channelFee.getOrderNum())) {
                                this.cacheHandle.removeChannelFee(park.getParkCode(), monthPayRequest.getChannelCode());
                            }
                            if (BigDecimal.ZERO.compareTo(payPrice) == 0) {
                                DataExitRequest request = new DataExitRequest();
                                request.setParkCode(park.getParkCode());
                                request.setOrderNum(order.getOrderNum());
                                request.setAisleCode(monthPayRequest.getChannelCode());
                                request.setPlateNum(exit.getPlateNum());
                                request.setType(order.getType());
                                request.setCarType(order.getCarType());
                                request.setEnterTime(new Date(fee.getEnterTime() * 1000L));
                                request.setExitTime(new Date(exit.getExitTime() * 1000L));
                                this.manageService.allowExit(request);
                            } else {
                                this.manageService.callVoiceReport(VoiceReportRequest.builder().parkCode(park.getParkCode()).aisleCode(monthPayRequest.getChannelCode()).plateNum(exit.getPlateNum()).orderNum(order.getOrderNum()).fee(fee.getUnpayPrice()).parkTime(fee.getParkTime()).build());
                            }
                        }
                    }
                } else {
                    SendRequest request = new SendRequest();
                    request.setServiceType(DownServiceEnum.\u6708\u5361.getServiceType());
                    request.setParkId(park.getId());
                    request.setServiceId(monthRecord.getId());
                    this.issuedCardService.send(request);
                    this.showAndSayServiceImpl.execute(VoiceReportRequest.builder().parkCode(park.getParkCode()).aisleCode(monthPayRequest.getChannelCode()).plateNum(order.getPlateNum()).fee("").orderNum(order.getOrderNum()).parkTime(Long.valueOf((order.getExitTime() == null ? DateTools.unixTimestamp() : order.getExitTime()) - order.getEnterTime())).build());
                }
            }
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<MonthOrderDto> getMonthOrder(String tradeNo) {
        MonthOrderDto monthOrder = this.monthOrderDao.getMonthOrderDetailByTradeno(tradeNo);
        return ObjectResponse.success((Object)monthOrder);
    }

    public boolean isAbCar(Long parkId, String plateNum, long monthId, int plotCount) {
        List plateNumList = this.monthPlateDao.selectByMonthId(Long.valueOf(monthId));
        return this.isAbCarMonth(plotCount, plateNumList);
    }

    public ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount) {
        return ObjectResponse.success((Object)this.abCar(parkId, plateNum, monthId, plotCount, null));
    }

    public ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount, Long regionId) {
        return ObjectResponse.success((Object)this.abCar(parkId, plateNum, monthId, plotCount, regionId));
    }

    public ObjectResponse<MonthAbDto> groupAbMonthCar(String plateNum, long monthId, int plotCount) {
        return ObjectResponse.success((Object)this.groupAbCar(plateNum, monthId, plotCount));
    }

    public MonthAbDto abMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo;
        ObjectResponse<MonthInfo> monthInfoResp = this.getMonthInfo(parkId, plateNum, MonthCarServiceBase.VALID_CARD, regionId);
        if (ObjectResponse.isSuccess(monthInfoResp)) {
            MonthInfo monthInfo2 = (MonthInfo)monthInfoResp.getData();
            if (monthInfo2.getMoreMonthType() != null && monthInfo2.getMoreMonthType() == 1) {
                log.info("\u8fdb\u5165\u96c6\u56e2\u6708\u5361\u7684\u5904\u7406\u903b\u8f91 {},{}", (Object)monthInfo2, (Object)plateNum);
                return (MonthAbDto)this.groupAbMonthCar(plateNum, monthInfo2.getId(), monthInfo2.getPlotCount()).getData();
            }
            return this.abCar(parkId, plateNum, monthInfo2.getId(), monthInfo2.getPlotCount(), regionId);
        }
        monthInfoResp = this.getMonthInfo(parkId, plateNum, MonthCarServiceBase.TIMEOUT_CARD, regionId);
        if (ObjectResponse.isSuccess(monthInfoResp) && this.byExpireMonth(parkId, monthInfo = (MonthInfo)monthInfoResp.getData()).booleanValue()) {
            return this.abCar(parkId, plateNum, monthInfo.getId(), monthInfo.getPlotCount(), regionId);
        }
        return null;
    }

    public ObjectResponse<MonthInfo> getMonthCar(Long parkId, String plateNum) {
        MonthInfo monthInfo = this.getMonthInfo(parkId, plateNum);
        if (monthInfo == null) {
            monthInfo = this.monthInfoDao.selectByPlateNum(parkId, plateNum, TIMEOUT_CARD);
        }
        if (monthInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)monthInfo);
    }

    public ObjectResponse<MonthInfo> getMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo == null) {
            monthInfo = this.findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD);
        }
        if (monthInfo == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)monthInfo);
    }

    public ObjectResponse<MonthInfo> getMonthInfo(long parkId, String plateNum, int cardStatus, Long regionId) {
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, cardStatus);
        return ObjectResponse.returnNotFoundIfNull((Object)monthInfo);
    }

    public ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum) {
        return ObjectResponse.success((Object)this.getMonthCarDetailDto(parkId, plateNum, null));
    }

    public ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum, Long regionId) {
        return ObjectResponse.success((Object)this.getMonthCarDetailDto(parkId, plateNum, regionId));
    }

    public ObjectResponse<List<MonthCardDto>> getValidByParkId(Long parkId) {
        List monthCardDtos = this.monthInfoDao.selectValidByParkId(parkId);
        if (monthCardDtos != null && monthCardDtos.size() > 0) {
            return ObjectResponse.success((Object)monthCardDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<MonthCardDto>> getValidByIds(List<String> isList) {
        List monthCardDtos = this.monthInfoDao.selectValidByIds(isList);
        if (monthCardDtos != null && monthCardDtos.size() > 0) {
            return ObjectResponse.success((Object)monthCardDtos);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<Void> renewMonthCard(MonthInfo renewMonthInfo, String parkCode, String plateNum, String plotNum) {
        Date currDate = new Date();
        Date startDate = renewMonthInfo.getStartTime();
        Date endData = renewMonthInfo.getEndTime();
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        MonthInfo monthInfo = this.monthInfoDao.load(renewMonthInfo.getId().longValue());
        if (!Objects.isNull(monthInfo)) {
            MonthProduct monthProduct = this.monthProductDao.selectById(renewMonthInfo.getProductId().longValue());
            if (Objects.isNull(monthProduct)) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_710);
            }
            int diftDay = 0;
            if (monthProduct.getIsDiftDay() == 1) {
                diftDay = monthProduct.getDiftDays();
            }
            List<String> plateNums = Arrays.asList(plateNum.split(","));
            List<Object> spaces = plotNum == null ? new ArrayList() : Arrays.asList(plotNum.split(","));
            monthInfo.setCardOwner(renewMonthInfo.getCardOwner());
            monthInfo.setPlotCount(renewMonthInfo.getPlotCount());
            monthInfo.setPhone(renewMonthInfo.getPhone());
            MonthRecord monthRecord = new MonthRecord();
            if (!monthInfo.getProductId().equals(renewMonthInfo.getProductId()) || DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)currDate) > 1 || DateTools.differentDays((Date)currDate, (Date)startDate) > 1) {
                monthInfo.setProductId(renewMonthInfo.getProductId());
                monthInfo.setCardStatus((DateTools.differentDays((Date)startDate, (Date)currDate) > 1 ? CardStatusConstants.\u5f85\u751f\u6548 : CardStatusConstants.\u751f\u6548\u4e2d).intValue());
                monthInfo.setStartTime(startDate);
                monthInfo.setEndTime(DateTools.addMonth((Date)endData, (int)monthProduct.getDuration(), (int)diftDay));
                this.monthInfoDao.insert(monthInfo);
                plateNums.forEach(s -> {
                    MonthPlate monthPlate = new MonthPlate();
                    monthPlate.setMonthId(monthInfo.getId());
                    monthPlate.setParkId(monthInfo.getParkId());
                    monthPlate.setPlateNum(s);
                    this.monthPlateDao.insert(monthPlate);
                });
                spaces.forEach(s -> this.monthInfoDao.insertMonthSpace(monthInfo.getId().longValue(), s));
                log.info("[\u65b0\u5f00\u6708\u5361] monthInfo:{}", (Object)JsonUtils.toString((Object)monthInfo));
                monthRecord.setMonthId(monthInfo.getId());
                monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u65b0\u589e.getType());
            } else {
                monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
                monthInfo.setEndTime(DateTools.addMonth((Date)endData, (int)monthProduct.getDuration(), (int)diftDay));
                this.monthInfoDao.update(monthInfo);
                monthRecord.setMonthId(renewMonthInfo.getId());
                monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u7eed\u8d39.getType());
                monthRecord.setIsOverdue(Integer.valueOf(0));
            }
            monthRecord.setProductId(renewMonthInfo.getProductId());
            monthRecord.setParkId(monthProduct.getParkId());
            monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
            monthRecord.setCardOwner(monthInfo.getCardOwner());
            monthRecord.setPhone(monthInfo.getPhone());
            monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
            monthRecord.setCount(Integer.valueOf(monthInfo.getCount()));
            monthRecord.setOperAccount(monthInfo.getOperAccount());
            monthRecord.setRemark(monthInfo.getRemark());
            String pj = String.join((CharSequence)",", plateNums);
            String sj = String.join((CharSequence)",", spaces);
            List monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue());
            String regions = monthRegions.stream().map(monthRegion -> String.valueOf(monthRegion.getRegionId())).collect(Collectors.joining(","));
            monthRecord.setPlateNum(pj);
            monthRecord.setSpaceNum(sj);
            monthRecord.setRegionId(regions);
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(monthInfo.getEndTime());
            monthRecord.setCreateTime(new Date());
            monthRecord.setUpdateTime(new Date());
            this.monthRecordDao.insert((Object)monthRecord);
            SendInfo sendInfo = new SendInfo(monthProduct.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
            this.sendInfoDao.insert((Object)sendInfo);
            log.info("[\u6dfb\u52a0\u6708\u5361\u8bb0\u5f55] renewMonthRecord:{}", (Object)JsonUtils.toString((Object)monthRecord));
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_710);
    }

    public ObjectResponse<List<MonthInfo>> getMonthCarByPlateNum(Long monthId, Long parkId) {
        List plateNums = this.monthPlateDao.selectByMonthId(monthId);
        if (CollectionUtil.isEmpty((Collection)plateNums)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List monthInfos = this.monthInfoDao.selectMonthCarByPlateNum(plateNums, parkId);
        if (CollectionUtil.isEmpty((Collection)monthInfos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthInfos);
    }

    public ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids) {
        List recordIdListByMonthIds = this.monthRecordDao.getRecordIdListByIds(ids);
        if (recordIdListByMonthIds != null && recordIdListByMonthIds.size() > 0) {
            return ObjectResponse.success((Object)recordIdListByMonthIds);
        }
        return ObjectResponse.failed((String)"404");
    }

    public List<MonthCardDto> getMonthListByParkId(Long parkId) {
        List infos = this.monthInfoDao.selectMonthListByParkId(parkId);
        if (infos == null || infos.isEmpty()) {
            return Collections.emptyList();
        }
        return infos;
    }

    public ObjectResponse<Boolean> addMonthCardRenewRecode(MonthrenewePubcheck monthrenewePubcheck) {
        boolean result;
        MonthrenewePubcheck pubcheck = this.monthrenewePubcheckService.selectByTradeNo(monthrenewePubcheck.getTradeNo());
        if (Objects.isNull(pubcheck)) {
            result = this.monthrenewePubcheckService.save((Object)monthrenewePubcheck);
        } else {
            monthrenewePubcheck.setId(pubcheck.getId());
            result = this.monthrenewePubcheckService.updateById((Object)monthrenewePubcheck);
        }
        return result ? ObjectResponse.success((Object)Boolean.TRUE) : ObjectResponse.failed();
    }

    public List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, List<String> plateNums, Integer pageNo, Integer pageSize) {
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkCode);
        if (!ObjectResponse.isSuccess((Response)configObjectResponse)) {
            return null;
        }
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        Integer monthcardInvoiceDays = parkConfig.getMonthcardInvoiceDays();
        if (monthcardInvoiceDays == null) {
            monthcardInvoiceDays = 365;
        }
        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-monthcardInvoiceDays.intValue()));
        Long startTime = startDate.getTime() / 1000L;
        Long endTime = DateTools.unixTimestamp();
        PageHelper.startPage((int)pageNo, (int)pageSize);
        return this.monthOrderDao.getMonthInvoiceRecords(parkConfig.getParkId(), null, startTime, endTime, null, plateNums);
    }

    public List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, Long accountId, Integer bizType, Long startTime, Long endTime, Integer pageNo, Integer pageSize) {
        Long parkId = null;
        if (StringUtils.isNotEmpty((CharSequence)parkCode)) {
            parkId = ((Park)this.parkService.findByParkCode(parkCode).getData()).getId();
        }
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List monthInvoiceRecords = this.monthOrderDao.getMonthInvoiceRecords(parkId, bizType, startTime, endTime, accountId, null);
        if (CollectionUtil.isNotEmpty((Collection)monthInvoiceRecords)) {
            monthInvoiceRecords.forEach(item -> {
                ParkConfig parkConfig = (ParkConfig)this.parkService.getParkConfig(item.getParkId()).getData();
                if (parkConfig.getIsInvoice() == 2) {
                    item.setInvoice(Boolean.FALSE);
                    item.setReason("\u8f66\u573a\u7ba1\u7406\u65b9\u672a\u5f00\u901a\u7ebf\u4e0a\u5f00\u7968\u670d\u52a1\uff0c\u65e0\u6cd5\u5f00\u7968");
                } else {
                    Integer monthcardInvoiceDays = parkConfig.getMonthcardInvoiceDays();
                    if (monthcardInvoiceDays != null) {
                        DateTime startDate = DateUtil.offsetDay((Date)DateUtil.date(), (int)(-monthcardInvoiceDays.intValue()));
                        if (item.getPayTime() < startDate.getTime() / 1000L) {
                            item.setInvoice(Boolean.FALSE);
                            item.setReason(String.format("\u8be5\u8f66\u573a\u7ba1\u7406\u8bbe\u7f6e\u4e86\uff0c\u529e\u7406\u6708\u5361\u548c\u7eed\u79df\u4ec5\u652f\u6301\u5f00\u5177%s\u5929\u5185\u7684\u652f\u4ed8\u8bb0\u5f55", monthcardInvoiceDays));
                        }
                    }
                }
            });
        }
        return monthInvoiceRecords;
    }

    public List<InvoiceParksDto> getMonthInvoiceParks(List<String> plateNums, Long startTime, Long endTime) {
        return this.monthOrderDao.getMonthInvoiceParks(null, null, startTime, endTime, plateNums);
    }

    public List<InvoiceParksDto> getMonthInvoiceParks(Long accountId, Integer bizType, Long startTime, Long endTime) {
        return this.monthOrderDao.getMonthInvoiceParks(accountId, bizType, startTime, endTime, null);
    }

    public List<MonthRecord> getMonthRecordByIds(List<Long> recordIds) {
        return this.monthRecordDao.selectBatchIds(recordIds);
    }

    public List<MonthOrder> getMonthMonthOrderByTradeNos(List<String> tradeNos) {
        return this.monthOrderDao.getMonthMonthOrderByTradeNos(tradeNos);
    }

    public void batchUpdateInvoiceStatus(List<String> tradeNos) {
        this.monthOrderDao.batchUpdateInvoiceStatus(tradeNos);
    }

    public ObjectResponse<Object> openCard(MonthOpenCardDto monthOpenCardDto, Boolean isCheck) {
        try {
            if (isCheck.booleanValue()) {
                return this.phpOpenCarService.openAndCheckMonthCard(monthOpenCardDto, Boolean.TRUE);
            }
            MonthOrder monthOrder = this.monthOrderDao.selectByTradeNoAndPayStatus(monthOpenCardDto.getTradeNo(), Integer.valueOf(1));
            if (Objects.isNull(monthOrder)) {
                return ObjectResponse.success();
            }
            MonthProduct monthProduct = this.monthProductDao.selectById((long)monthOpenCardDto.getProductId().intValue());
            if (monthProduct.getAddstatusValid() == 1) {
                List regionIds = Lists.newArrayList();
                if (monthProduct.getSupportRegion() == 1) {
                    regionIds = this.monthProductRegionService.getRegionIds(monthProduct.getId());
                }
                this.addMonthCardRenewRecode(MonthrenewePubcheck.builder().productId(monthOpenCardDto.getProductId()).parkId(Integer.valueOf(Math.toIntExact(monthProduct.getParkId()))).cardProperty(monthOpenCardDto.getCardProperty()).cardOwner(monthOpenCardDto.getCardOwner()).plateNum(monthOpenCardDto.getPlateNumData().stream().map(MonthOpenCardDto.PlateNumData::getPlateNum).collect(Collectors.joining(","))).regionId(StrUtil.join((CharSequence)",", (Iterable)regionIds)).phone(monthOpenCardDto.getPhone()).cardStatus(Integer.valueOf(1)).cardOpertype(monthOpenCardDto.getCardProperty()).plotCount(Integer.valueOf(1)).count(Integer.valueOf(1)).remark(monthOpenCardDto.getRemark()).mainAddress(monthOpenCardDto.getMainAddress()).payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice()).payMethod(Integer.valueOf(monthOrder.getPayMethod())).tradeNo(monthOrder.getTradeNo()).attachment(JsonUtils.toString((Object)monthOpenCardDto.getPicData())).refund(BigDecimal.ZERO).startTime(monthOpenCardDto.getStartDate()).endTime(monthOpenCardDto.getEndDate()).renewAccount(monthOpenCardDto.getUserName()).payChannel(Integer.valueOf(monthOrder.getPayChannel())).build());
                monthOrder.setPayStatus(2);
                monthOrder.setPayTime(Math.toIntExact(monthOpenCardDto.getPayTime()));
                monthOrder.setOutTradeNo(monthOpenCardDto.getOutTradeNo());
                monthOrder.setRemark(monthOpenCardDto.getRemark());
                this.monthOrderDao.update(monthOrder);
                return ObjectResponse.success();
            }
            ObjectResponse<Object> objectObjectResponse = this.phpOpenCarService.openAndCheckMonthCard(monthOpenCardDto, Boolean.FALSE);
            if (!ObjectResponse.isSuccess(objectObjectResponse)) {
                log.error("[\u8c03\u7528saas\u6708\u5361\u5f00\u5361\u63a5\u53e3] {}", objectObjectResponse);
            }
            String s = JSONUtil.toJsonStr((Object)objectObjectResponse.getData());
            JSONObject jsonObject = new JSONObject((Object)s);
            String cardIdStr = (String)jsonObject.get((Object)"cardId");
            Integer cardId = Integer.valueOf(cardIdStr);
            MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getMonthId, (Object)cardId)).orderByDesc(MonthRecord::getId)).last("limit 1"));
            monthOrder.setPayStatus(2);
            monthOrder.setPayTime(Math.toIntExact(monthOpenCardDto.getPayTime()));
            monthOrder.setOutTradeNo(monthOpenCardDto.getOutTradeNo());
            monthOrder.setMonthRecordId(Objects.nonNull(monthRecord) ? monthRecord.getId() : null);
            monthOrder.setRemark(monthOpenCardDto.getRemark());
            this.monthOrderDao.update(monthOrder);
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u6708\u5361\u5f00\u901a\u5f02\u5e38] monthOpenCardDto {}", (Object)monthOpenCardDto, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Object> renewCard(MonthRenewCardDto monthRenewCardDto, Boolean isCheck) {
        try {
            if (isCheck.booleanValue()) {
                return this.phpOpenCarService.renewAndCheckMonthCard(monthRenewCardDto, Boolean.TRUE);
            }
            MonthOrder monthOrder = this.monthOrderDao.selectByTradeNoAndPayStatus(monthRenewCardDto.getTradeNo(), Integer.valueOf(1));
            if (Objects.isNull(monthOrder)) {
                return ObjectResponse.success();
            }
            MonthProduct monthProduct = this.monthProductDao.selectById((long)monthRenewCardDto.getProductId().intValue());
            int diftDay = 0;
            if (monthProduct.getIsDiftDay() == 1) {
                diftDay = monthProduct.getDiftDays();
            }
            MonthInfo monthInfo = this.monthInfoDao.load((long)monthRenewCardDto.getMonthId().intValue());
            List plateNums = this.monthInfoDao.selectPlateNums(monthInfo.getId().longValue());
            log.info("\u8f66\u724c\u53f7[{}]", (Object)plateNums);
            List spaces = this.monthInfoDao.selectSpaces(monthInfo.getId());
            if (monthProduct.getAddstatusValid() == 1) {
                List regionIds = Lists.newArrayList();
                if (monthProduct.getSupportRegion() == 1) {
                    regionIds = this.monthProductRegionService.getRegionIds(monthProduct.getId());
                }
                this.addMonthCardRenewRecode(MonthrenewePubcheck.builder().monthId(monthRenewCardDto.getMonthId()).productId(monthRenewCardDto.getProductId()).parkId(Integer.valueOf(Math.toIntExact(monthProduct.getParkId()))).cardProperty(Integer.valueOf(monthInfo.getCardProperty())).cardOwner(monthInfo.getCardOwner()).plateNum(plateNums.stream().filter(Objects::nonNull).collect(Collectors.joining(","))).spaceNum(spaces.stream().filter(Objects::nonNull).collect(Collectors.joining(","))).regionId(StrUtil.join((CharSequence)",", (Iterable)regionIds)).phone(monthInfo.getPhone()).cardStatus(Integer.valueOf(Math.toIntExact(monthInfo.getProductId()) != monthRenewCardDto.getProductId() || DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)monthRenewCardDto.getStartDate()) > 1 ? 1 : 2)).cardOpertype(Integer.valueOf(1)).plotCount(Integer.valueOf(monthInfo.getPlotCount())).count(monthRenewCardDto.getBuyNum()).payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice()).payMethod(Integer.valueOf(2)).tradeNo(monthOrder.getTradeNo()).refund(BigDecimal.ZERO).startTime(monthRenewCardDto.getStartDate()).endTime(monthRenewCardDto.getEndDate()).renewAccount(String.valueOf(monthOrder.getMpUserId())).operAccount("\u516c\u4f17\u53f7").addDay(String.valueOf(diftDay)).payChannel(Integer.valueOf(3)).build());
                monthOrder.setPayStatus(2);
                monthOrder.setPayTime(Math.toIntExact(monthRenewCardDto.getPayTime()));
                monthOrder.setOutTradeNo(monthRenewCardDto.getOutTradeNo());
                monthOrder.setRemark(monthRenewCardDto.getRemark());
                this.monthOrderDao.update(monthOrder);
                return ObjectResponse.success();
            }
            ObjectResponse<Object> objectObjectResponse = this.phpOpenCarService.renewAndCheckMonthCard(monthRenewCardDto, Boolean.FALSE);
            if (!ObjectResponse.isSuccess(objectObjectResponse)) {
                log.error("[\u8c03\u7528saas\u6708\u5361\u5f00\u5361\u63a5\u53e3] {}", objectObjectResponse);
            }
            String s = JSONUtil.toJsonStr((Object)objectObjectResponse.getData());
            JSONObject jsonObject = new JSONObject((Object)s);
            String cardIdStr = (String)jsonObject.get((Object)"cardId");
            Integer cardId = Integer.valueOf(cardIdStr);
            MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getMonthId, (Object)cardId)).orderByDesc(MonthRecord::getId)).last("limit 1"));
            monthOrder.setPayStatus(2);
            monthOrder.setPayTime(Math.toIntExact(monthRenewCardDto.getPayTime()));
            monthOrder.setOutTradeNo(monthRenewCardDto.getOutTradeNo());
            monthOrder.setMonthRecordId(Objects.nonNull(monthRecord) ? monthRecord.getId() : null);
            monthOrder.setRemark(monthRenewCardDto.getRemark());
            this.monthOrderDao.update(monthOrder);
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u6708\u5361\u5f00\u901a\u5f02\u5e38] monthOpenCardDto {}", (Object)monthRenewCardDto, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<MonthProductDto> getMonthProduct(String parkCode, Integer productId) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        MonthProduct monthProduct = this.monthProductDao.selectById((long)productId.intValue());
        String regionName = this.monthProductRegionService.getRegionName(monthProduct.getId());
        MonthProductDto monthProductDto = new MonthProductDto();
        monthProductDto.setId(monthProduct.getId());
        monthProductDto.setParkName(park.getParkName());
        monthProductDto.setParkCode(park.getParkCode());
        monthProductDto.setName(monthProduct.getName());
        monthProductDto.setDuration(monthProduct.getDuration());
        monthProductDto.setCardType(monthProduct.getCardType());
        monthProductDto.setPaymoney(monthProduct.getPaymoney());
        monthProductDto.setRegionName(regionName);
        monthProductDto.setRenewstatusValid(monthProduct.getRenewstatusValid());
        monthProductDto.setAddstatusValid(monthProduct.getAddstatusValid());
        monthProductDto.setStartDate((Date)DateUtil.date());
        monthProductDto.setEndDate((Date)DateUtil.offsetDay((Date)DateUtil.offsetMonth((Date)DateUtil.date(), (int)monthProduct.getDuration()), (int)-1));
        monthProductDto.setStartTime(monthProduct.getStartTime());
        monthProductDto.setEndTime(monthProduct.getEndTime());
        monthProductDto.setTelphone(park.getTelphone());
        monthProductDto.setTagContent(monthProduct.getTagContent());
        monthProductDto.setUserChareg(monthProduct.getUserChareg());
        return ObjectResponse.success((Object)monthProductDto);
    }

    public ObjectResponse<List<MonthInfoDto>> getMpUserMonthInfo(Integer mpUserId) {
        List monthInfoDtos = this.monthInfoDao.getMpUserMonthInfo(mpUserId);
        List monthInfoDtoList = this.monthrenewePubcheckService.selectMonthInfo(mpUserId);
        if (CollectionUtils.isEmpty((Collection)monthInfoDtos)) {
            monthInfoDtos = Lists.newArrayList();
        }
        monthInfoDtos.addAll(monthInfoDtoList);
        return ObjectResponse.success((Object)monthInfoDtos);
    }

    public ParkRegion findMonthCardOtherRegion(Long parkId, String plateNum, String channelCode) {
        Optional<MonthRegion> any;
        List monthRegions;
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        if (park.getIsInterior() == null || park.getIsInterior() == 0 || channelCode == null) {
            return null;
        }
        ObjectResponse inoutDeviceByCode = this.parkService.getInoutDeviceByCode(channelCode);
        if (!ObjectResponse.isSuccess((Response)inoutDeviceByCode) || Integer.valueOf(0).equals(((ParkInoutdevice)inoutDeviceByCode.getData()).getIsMaster())) {
            return null;
        }
        MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(parkId, plateNum, VALID_CARD);
        if (monthInfo != null && !CollectionUtils.isEmpty((Collection)(monthRegions = this.monthRegionDao.selectByMonthId(monthInfo.getId().longValue()))) && (any = monthRegions.stream().filter(region -> 0L != region.getRegionId() && !region.getRegionId().equals(((ParkInoutdevice)inoutDeviceByCode.getData()).getRegionId())).findAny()).isPresent()) {
            return (ParkRegion)this.regionDao.selectById((Serializable)any.get().getRegionId());
        }
        return null;
    }

    public MonthInfo findMonthInfo(Long parkId, String plateNum, Long regionId, Integer cardStatus) {
        if (regionId == null) {
            return this.monthInfoDao.selectByRegionPlateNum(parkId, plateNum, null, cardStatus);
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        if (NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 1) {
            return this.monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, cardStatus);
        }
        return this.monthInfoDao.selectByRegionPlateNum(parkId, plateNum, null, cardStatus);
    }

    public ObjectResponse<MonthCardConfigDto> limitConfig(Long monthInfoId) {
        MonthInfo monthInfo = this.monthInfoDao.load(monthInfoId.longValue());
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(monthInfo.getParkId().longValue());
        MonthCardConfigDto monthCardConfigDto = new MonthCardConfigDto();
        if (Objects.nonNull(parkConfig.getRenewLimitDay())) {
            if (parkConfig.getRenewLimitDay() == -1) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)"\u8f66\u573a\u4e0d\u652f\u6301\u6708\u5361\u7ebf\u4e0a\u7eed\u8d39");
            }
            if (parkConfig.getRenewLimitDay() != 0) {
                LocalDate nowDate = LocalDate.now();
                LocalDate monthEndDate = DateUtils.toLocalDate((Date)monthInfo.getEndTime());
                long betweenDay = nowDate.toEpochDay() - monthEndDate.toEpochDay();
                if (betweenDay > (long)parkConfig.getRenewLimitDay().intValue()) {
                    return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_402.getCode(), (String)("\u6708\u5361\u8fc7\u671f\u8d85\u8fc7" + parkConfig.getRenewLimitDay() + "\u5929\uff0c\u8f66\u4e3b\u4e0d\u53ef\u5728\u516c\u4f17\u53f7\u7eed\u8d39\uff0c\u8bf7\u8054\u7cfb\u8f66\u573a\u7ba1\u7406\u65b9\u8fdb\u884c\u7ebf\u4e0b\u5904\u7406\u3002"));
                }
            }
        }
        monthCardConfigDto.setRenewCardLimitDays(parkConfig.getRenewLimitDay());
        monthCardConfigDto.setCardLimitMonths(parkConfig.getCardLimitMonth());
        monthCardConfigDto.setRenewCardStarttimeType(parkConfig.getRenewStarttimeType());
        if (Objects.isNull(parkConfig.getRenewLimitDay()) || parkConfig.getRenewLimitDay() == 0) {
            monthCardConfigDto.setRenewCardLimitDays(Integer.valueOf(-1));
        }
        if (Objects.isNull(parkConfig.getCardLimitMonth()) || parkConfig.getCardLimitMonth() == 0) {
            monthCardConfigDto.setCardLimitMonths(Integer.valueOf(-1));
        }
        return ObjectResponse.success((Object)monthCardConfigDto);
    }

    public ObjectResponse<MonthOrderCountDto> countMonthOrderList(Long accountId, String plateNum, Date startTime, Date endTime, Integer bizType) {
        MonthOrderCountDto monthOrderCountDto = this.monthOrderDao.countMonthOrder(accountId, plateNum, bizType, Objects.isNull(startTime) ? null : Long.valueOf(startTime.getTime() / 1000L), Objects.isNull(endTime) ? null : Long.valueOf(endTime.getTime() / 1000L));
        return ObjectResponse.success((Object)monthOrderCountDto);
    }

    public ObjectResponse<List<MonthOrderResponseVo>> getMonthOrderListBy(Integer cardType, List<String> plateNums) {
        List monthPlates = this.monthPlateDao.selectMonthIdByPlateNums(plateNums);
        if (CollectionUtils.isEmpty((Collection)monthPlates)) {
            return ObjectResponse.success();
        }
        Map groupedByMonthId = monthPlates.stream().collect(Collectors.groupingBy(MonthPlate::getMonthId, Collectors.mapping(MonthPlate::getPlateNum, Collectors.toList())));
        List parkIds = monthPlates.stream().map(MonthPlate::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List parks = this.parkService.findByParkIds(parkIds);
        Map<Object, Object> parkMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)parks)) {
            parkMap = parks.stream().collect(Collectors.toMap(BasePark::getId, BasePark::getParkName, (a, b) -> b));
        }
        LocalDateTime twoYear = LocalDateTime.now().minusYears(2L);
        Date date = Date.from(twoYear.atZone(ZoneId.systemDefault()).toInstant());
        List monthIds = monthPlates.stream().map(MonthPlate::getMonthId).filter(Objects::nonNull).collect(Collectors.toList());
        List monthInfos = this.monthInfoDao.getMonthInfoBy(monthIds, cardType, date);
        if (CollectionUtils.isEmpty((Collection)monthInfos)) {
            return ObjectResponse.success();
        }
        List productIds = monthInfos.stream().map(MonthInfo::getProductId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List products = this.monthProductDao.selectByIds(productIds);
        Map productMap = products.stream().collect(Collectors.toMap(MonthProduct::getId, Function.identity()));
        Map<Object, Object> finalParkMap = parkMap;
        List responseVos = monthInfos.stream().filter(info -> NumberUtils.toPrimitive((Integer)info.getPayMethod()) != 0).map(info -> {
            MonthOrderResponseVo vo = new MonthOrderResponseVo();
            MonthProduct monthProduct = (MonthProduct)productMap.get(info.getProductId());
            if (monthProduct != null) {
                vo.setProductName(monthProduct.getName());
                vo.setUserChareg(monthProduct.getUserChareg());
                vo.setProductId(monthProduct.getId());
                vo.setDeposit(monthProduct.getDeposit());
                vo.setIsHaveDeposit(monthProduct.getIsHaveDeposit());
            }
            vo.setPlateNum(String.join((CharSequence)",", (Iterable)groupedByMonthId.get(info.getId())));
            vo.setUseBeginDate(info.getStartTime());
            vo.setUseEndDate(info.getEndTime());
            vo.setParkName((String)finalParkMap.get(info.getParkId()));
            vo.setPayTime(info.getCreateTime());
            vo.setCardStatus(Integer.valueOf(info.getCardStatus()));
            vo.setPayChannel(Integer.valueOf(info.getPayMethod()));
            vo.setPayAmount(info.getPayMoney());
            return vo;
        }).collect(Collectors.toList());
        return ObjectResponse.success(responseVos);
    }

    public ObjectResponse<List<MonthInfo>> getMonthInfos(Long parkId, Date date) {
        List monthInfos = this.monthInfoDao.selectMonthInfos(parkId, date);
        if (CollectionUtils.isEmpty((Collection)monthInfos)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthInfos);
    }

    public ObjectResponse<List<MonthOrder>> getMonthOrders(Long parkId, Date date) {
        List monthOrders = this.monthOrderDao.selectMonthOrderListBy(parkId, date);
        if (CollectionUtils.isEmpty((Collection)monthOrders)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthOrders);
    }

    public String getTime(Date time, int type) {
        String format = DateUtil.format((Date)time, (String)"yyyyMMdd");
        if (type == 1) {
            format = format + "000000";
            return format;
        }
        return format + "235959";
    }

    public boolean addMonthCarInfo(MonthInfo monthInfo) {
        int insert = this.monthInfoDao.insert(monthInfo);
        return insert > 0;
    }

    public MonthDetailDto getMonthCarDetailDto(Long parkId, String plateNum, Long regionId) {
        MonthDetailDto monthDetailDto = new MonthDetailDto();
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo == null) {
            MonthInfo monthInfoTimeout = this.findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD);
            if (monthInfoTimeout == null) {
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u975e\u6708\u5361\u8f66);
            } else {
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66);
                monthDetailDto.setMonthInfo(monthInfoTimeout);
                ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
                ObjectResponse.notError((Response)configObjectResponse);
                ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
                int expireMcDays = NumberUtils.toPrimitive((Integer)parkConfig.getExpireMcDays());
                int expireDaysMonth = NumberUtils.toPrimitive((Integer)parkConfig.getIsExpireMc());
                int differentDays = DateTools.differentDays((Date)monthInfoTimeout.getEndTime(), (Date)new Date());
                if (expireDaysMonth == 1) {
                    MonthProduct monthProduct = this.monthProductDao.selectById(monthInfoTimeout.getProductId().longValue());
                    int cardType = monthProduct.getCardType();
                    if (cardType == 1) {
                        monthDetailDto.setCardType(MonthDetailDto.CardType.\u5168\u5929\u5361);
                    } else {
                        monthDetailDto.setCardType(MonthDetailDto.CardType.\u9519\u65f6\u5361);
                    }
                    if (differentDays <= expireMcDays) {
                        int plotCount;
                        long monthId = monthInfoTimeout.getId();
                        boolean isMonth = this.isAbCarMonth(parkId, plateNum, monthId, plotCount = monthInfoTimeout.getPlotCount(), regionId);
                        if (isMonth) {
                            monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66);
                        } else {
                            monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
                        }
                    }
                }
            }
        } else {
            monthDetailDto.setMonthInfo(monthInfo);
            MonthProduct monthProduct = this.monthProductDao.selectById(monthInfo.getProductId().longValue());
            int cardType = monthProduct.getCardType();
            if (cardType == 1) {
                monthDetailDto.setCardType(MonthDetailDto.CardType.\u5168\u5929\u5361);
            } else {
                monthDetailDto.setCardType(MonthDetailDto.CardType.\u9519\u65f6\u5361);
            }
            monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u6708\u5361\u8f66);
            long monthId = monthInfo.getId();
            int plotCount = monthInfo.getPlotCount();
            boolean isMonth = this.isAbCarMonth(parkId, plateNum, monthId, plotCount, regionId);
            if (!isMonth) {
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528);
            }
        }
        return monthDetailDto;
    }

    public Boolean judgeMonthCar(Long parkId, String plateNum) {
        MonthInfo monthInfo = this.getMonthInfo(parkId, plateNum);
        return this.judgeMonthCar(parkId, plateNum, null, monthInfo);
    }

    public Boolean judgeMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = this.findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        return this.judgeMonthCar(parkId, plateNum, regionId, monthInfo);
    }

    public Boolean judgeMonthCar(Long parkId, String plateNum, Long regionId, MonthInfo monthInfo) {
        if (!(monthInfo != null || (monthInfo = this.findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD)) != null && this.byExpireMonth(parkId, monthInfo).booleanValue())) {
            return false;
        }
        long monthId = monthInfo.getId();
        int plotCount = monthInfo.getPlotCount();
        return this.isAbCarMonth(parkId, plateNum, monthId, plotCount, regionId);
    }

    public void innerAreaExitAbMonthDeal(Long parkId, String plateNum, Long exitTime, Long regionId) {
        List plateNumList;
        if (regionId == null || regionId == 0L) {
            this.exitAbMonthDeal(parkId, plateNum, exitTime);
            return;
        }
        log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u8fdb\u5165\uff0cplateNum\uff1a{}\uff0cexitTime\uff1a{}\uff0cregionId\uff1a{}", new Object[]{plateNum, exitTime, regionId});
        MonthInfo monthInfoDto = this.monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfoDto == null) {
            return;
        }
        Long monthId = monthInfoDto.getId();
        List monthRegions = this.monthRegionDao.selectByMonthId(monthId.longValue());
        if (CollectionUtils.isEmpty((Collection)monthRegions)) {
            log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u672a\u5173\u8054\u5230\u533a\u57df\u4fe1\u606f, plateNum[{}], regionId[{}]", (Object)plateNum, (Object)regionId);
            return;
        }
        Optional<MonthRegion> optional = monthRegions.stream().filter(monthRegion -> regionId.equals(monthRegion.getRegionId())).findAny();
        if (!optional.isPresent()) {
            log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4e0d\u662f\u5185\u533a\u6708\u5361, plateNum[{}], regionId[{}]", (Object)plateNum, (Object)regionId);
            return;
        }
        int plotCount = monthInfoDto.getPlotCount();
        if (!this.isAbCarMonth(plotCount, plateNumList = this.monthPlateDao.selectByMonthId(monthId))) {
            return;
        }
        log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u662fAB\u8f66\uff0cplateNum\uff1a{}", (Object)plateNum);
        plateNumList.remove(plateNum);
        OrderInfo recentOne = this.getMultipleAreaRecentOrder(parkId, regionId, plateNumList);
        if (recentOne == null) {
            log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5728\u573a\u8f66\u8f86\u4e2d\u4e0d\u5b58\u5728\u4e0e[{}]\u540c\u4e00\u7528\u6237\u7684\u4e34\u65f6\u8f66", (Object)plateNum);
            return;
        }
        log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u6700\u8fd1\u5165\u573a\u7684\u573a\u5185\u8f66\u8f86\uff1a{}", (Object)recentOne);
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        long intervalTime = exitTime - recentOne.getEnterTime();
        log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5f53\u524d\u8f66\u724c\u79bb\u573a\u65f6\u95f4\u5230\u4e0a\u4e2a\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u95f4\u9694\u662f\uff1a{}\uff0cplateNum\uff1a{}", (Object)intervalTime, (Object)plateNum);
        if (intervalTime <= (long)(parkConfig.getSwitchTm() * 60)) {
            if (recentOne instanceof OrderSonInfo) {
                OrderSonInfo orderInfoUpdate = new OrderSonInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfoUpdate.setRegionId(regionId);
                this.orderSonInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
            } else {
                OrderInfo orderInfo = new OrderInfo();
                orderInfo.setOrderNum(recentOne.getOrderNum());
                orderInfo.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfo.setRegionId(regionId);
                this.orderInfoDao.updateByOrderNumAndRegionId(orderInfo);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderInfoUpdate = new OrderSonInfo();
                    orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    orderInfoUpdate.setRegionId(regionId);
                    this.orderSonInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                }
            }
            log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u672a\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66", (Object)plateNum);
        } else if (parkConfig.getSwitchType() == 1) {
            if (recentOne instanceof OrderSonInfo) {
                OrderSonInfo orderSonInfo = new OrderSonInfo();
                orderSonInfo.setOrderNum(recentOne.getOrderNum());
                orderSonInfo.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderSonInfo.setSwitchTime(exitTime);
                orderSonInfo.setRegionId(regionId);
                this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
            } else {
                OrderInfo orderInfo = new OrderInfo();
                orderInfo.setOrderNum(recentOne.getOrderNum());
                orderInfo.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfo.setSwitchTime(exitTime);
                orderInfo.setRegionId(regionId);
                this.orderInfoDao.updateByOrderNumAndRegionId(orderInfo);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfo = new OrderSonInfo();
                    orderSonInfo.setOrderNum(recentOne.getOrderNum());
                    orderSonInfo.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    orderSonInfo.setSwitchTime(exitTime);
                    orderSonInfo.setRegionId(regionId);
                    this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
                }
            }
            log.info("[\u5185\u533a\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u5df2\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66\uff0c\u8f66\u8f86\u5207\u6362\u65f6\u95f4\u66f4\u65b0\u4e3a\u5f53\u524d\u8f66\u8f86\u7684\u51fa\u573a\u65f6\u95f4[{}]", (Object)recentOne.getPlateNum(), (Object)exitTime);
        }
    }

    public void masterAreaExitAbMonthDeal(Long parkId, String plateNum, Long exitTime, Long regionId) {
        OrderInfo recentOne;
        MonthRegion monthRegion;
        List plateNumList;
        MonthInfo monthInfoDto = this.monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfoDto == null) {
            return;
        }
        long monthId = monthInfoDto.getId();
        int plotCount = monthInfoDto.getPlotCount();
        if (!this.isAbCarMonth(plotCount, plateNumList = this.monthPlateDao.selectByMonthId(Long.valueOf(monthId)))) {
            return;
        }
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] plateNum[{}]\u662fAB\u8f66", (Object)plateNum);
        plateNumList.remove(plateNum);
        int bizType = 1;
        List monthRegions = this.monthRegionDao.selectByMonthId(monthId);
        if (CollectionUtils.isNotEmpty((Collection)monthRegions) && (monthRegion = (MonthRegion)monthRegions.stream().filter(mr -> NumberUtils.toPrimitive((Long)mr.getRegionId()) != 0L).findFirst().orElse(null)) != null) {
            bizType = 2;
            if (!monthRegion.getRegionId().equals(regionId)) {
                log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u79bb\u573a\u533a\u57df\u4e0d\u662f\u5f53\u524d\u6708\u5361\u751f\u6548\u533a\u57df, plateNum[{}], regionId[{}]", (Object)plateNum, (Object)regionId);
                return;
            }
        }
        if (bizType == 1) {
            List<OrderInfo> orderInfoList = this.getInParkOrderInfos(parkId, plateNumList, null);
            recentOne = orderInfoList.get(0);
        } else {
            recentOne = this.getMultipleAreaRecentOrder(parkId, regionId, plateNumList);
        }
        if (recentOne == null) {
            log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5728\u573a\u8f66\u8f86\u4e2d\u4e0d\u5b58\u5728\u4e0e[{}]\u540c\u4e00\u7528\u6237\u7684\u4e34\u65f6\u8f66", (Object)plateNum);
            return;
        }
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u6700\u8fd1\u5165\u573a\u7684\u573a\u5185\u8f66\u8f86\uff1a{}", (Object)recentOne);
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        long intervalTime = exitTime - recentOne.getEnterTime();
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5f53\u524d\u8f66\u724c\u79bb\u573a\u65f6\u95f4\u5230\u4e0a\u4e2a\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u95f4\u9694\u662f\uff1a{}\uff0cplateNum\uff1a{}", (Object)intervalTime, (Object)plateNum);
        if (intervalTime <= (long)(parkConfig.getSwitchTm() * 60)) {
            if (bizType == 1) {
                OrderInfo orderInfoUpdate = new OrderInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                this.orderInfoDao.updateByOrderNum(orderInfoUpdate);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    this.orderSonInfoDao.updateByOrderNum(orderSonInfoUpdate);
                }
            } else if (recentOne instanceof OrderSonInfo) {
                OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderSonInfoUpdate.setRegionId(regionId);
                this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
            } else {
                OrderInfo orderInfoUpdate = new OrderInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfoUpdate.setRegionId(regionId);
                this.orderInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    orderSonInfoUpdate.setRegionId(regionId);
                    this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                }
            }
            log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u672a\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66", (Object)plateNum);
        } else if (parkConfig.getSwitchType() == 1) {
            if (bizType == 1) {
                OrderInfo orderInfoUpdate = new OrderInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfoUpdate.setSwitchTime(exitTime);
                this.orderInfoDao.updateByOrderNum(orderInfoUpdate);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    orderSonInfoUpdate.setSwitchTime(exitTime);
                    this.orderSonInfoDao.updateByOrderNum(orderSonInfoUpdate);
                }
            } else if (recentOne instanceof OrderSonInfo) {
                OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderSonInfoUpdate.setRegionId(regionId);
                orderSonInfoUpdate.setSwitchTime(exitTime);
                this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
            } else {
                OrderInfo orderInfoUpdate = new OrderInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                orderInfoUpdate.setRegionId(regionId);
                orderInfoUpdate.setSwitchTime(exitTime);
                this.orderInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                    orderSonInfoUpdate.setRegionId(regionId);
                    orderSonInfoUpdate.setSwitchTime(exitTime);
                    this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                }
            }
            log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u5df2\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66\uff0c\u8f66\u8f86\u5207\u6362\u65f6\u95f4\u66f4\u65b0\u4e3a\u5f53\u524d\u8f66\u8f86\u7684\u51fa\u573a\u65f6\u95f4[{}]", (Object)recentOne.getPlateNum(), (Object)exitTime);
        }
    }

    private OrderInfo getMultipleAreaRecentOrder(Long parkId, Long regionId, List<String> plateNumList) {
        OrderSonInfo recentOrderSon;
        List<OrderInfo> orderInfoList = this.getInParkOrderInfos(parkId, plateNumList, regionId);
        List<OrderSonInfo> orderSonInfoList = this.getInParkOrderSonInfos(parkId, plateNumList, regionId);
        OrderInfo recentOrder = CollectionUtils.isEmpty(orderInfoList) ? null : orderInfoList.get(0);
        OrderSonInfo orderSonInfo = recentOrderSon = CollectionUtils.isEmpty(orderSonInfoList) ? null : orderSonInfoList.get(0);
        Object recentOne = recentOrder != null && recentOrderSon != null && !recentOrder.getOrderNum().equals(recentOrderSon.getOrderNum()) ? (recentOrder.getEnterTime() < recentOrderSon.getEnterTime() ? recentOrder : recentOrderSon) : (recentOrder == null ? recentOrderSon : recentOrder);
        return recentOne;
    }

    public ObjectResponse<List<MonthRecord>> getMonthRecordList(List<Long> ids) {
        List monthRecords = this.monthRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)monthRecords)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthRecords);
    }

    public ObjectResponse<List<MonthPlate>> getMonthPlatesByMonthId(Long monthId) {
        List monthPlates = this.monthPlateDao.selectAllByMonthId(monthId);
        if (CollectionUtils.isEmpty((Collection)monthPlates)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)monthPlates);
    }
}

