/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.monthcar;

import cn.hutool.core.collection.CollectionUtil;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRegionDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.more.MoreMonthPlateService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MonthCarServiceBase {
    private static final Logger log = LoggerFactory.getLogger(MonthCarServiceBase.class);
    @Autowired
    protected MonthInfoDao monthInfoDao;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected ParkDao parkDao;
    @Autowired
    protected MonthPlateDao monthPlateDao;
    @Autowired
    protected MonthProductDao monthProductDao;
    @Autowired
    protected OrderInfoDao orderInfoDao;
    @Autowired
    protected ParkConfigDao parkConfigDao;
    @Autowired
    protected LcdService lcdService;
    @Autowired
    protected OrderSonInfoDao orderSonInfoDao;
    @Autowired
    protected ParkRegionDao regionDao;
    @Autowired
    protected MonthRegionDao monthRegionDao;
    @Autowired
    protected MoreMonthPlateService moreMonthPlateService;
    @Autowired
    private MoreMonthParkService moreMonthParkService;
    public static final Integer VALID_CARD = 1;
    public static final Integer TIMEOUT_CARD = 4;

    public Boolean byExpireMonth(Long parkId, MonthInfo monthInfo) {
        int differentDays;
        Integer expireMcDays = 0;
        Integer expireDaysMonth = 0;
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(parkId.longValue());
        if (parkConfig != null) {
            expireMcDays = parkConfig.getExpireMcDays();
            expireDaysMonth = parkConfig.getIsExpireMc();
        }
        if (expireMcDays != null && expireMcDays > 0 && (differentDays = DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)new Date())) <= expireMcDays) {
            return expireDaysMonth != null && expireDaysMonth == 1;
        }
        return false;
    }

    protected Boolean isAbCarMonth(Long parkId, String plateNum, long monthId, int plotCount, Long regionId) {
        MonthAbDto monthAbDto = this.abCar(parkId, plateNum, monthId, plotCount, regionId);
        return monthAbDto.getMonthCar();
    }

    protected MonthAbDto groupAbCar(String plateNum, long monthId, int plotCount) {
        List monthPlates = this.monthPlateDao.selectAllByMonthId(Long.valueOf(monthId));
        MonthInfo monthInfo = this.monthInfoDao.load(monthId);
        List<String> plateNumList = monthPlates.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList());
        List<MoreMonthPark> moreMonthPlateByPlateNum = this.moreMonthParkService.getMonthParkByMoreMonthId(monthInfo.getMoreMonthId());
        List parkIds = moreMonthPlateByPlateNum.stream().map(MoreMonthPark::getParkId).collect(Collectors.toList());
        MonthAbDto monthAbDto = MonthAbDto.builder().plotCount(Integer.valueOf(plotCount)).plateNumCount(Integer.valueOf(plateNumList.size())).build();
        if (this.isAbCarMonth(plotCount, plateNumList)) {
            monthAbDto.setAbCar(Boolean.valueOf(true));
            log.info("[\u662f\u5426\u6708\u5361\u8f66\u5224\u65ad] \u8f66\u724c\u53f7[{}]\u5c5e\u4e8e\u96c6\u56e2\u591a\u4f4d\u591a\u8f66", (Object)plateNum);
            List collect = plateNumList.stream().filter(pn -> !plateNum.equals(pn)).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                monthAbDto.setMonthCar(Boolean.valueOf(true));
                monthAbDto.setIndex(Integer.valueOf(1));
                return monthAbDto;
            }
            int inParkMonthCardCount = this.orderInfoDao.countInMoreParkMonthCardByPlateNums(parkIds, collect);
            monthAbDto.setIndex(Integer.valueOf(inParkMonthCardCount + 1));
            if (inParkMonthCardCount >= plotCount) {
                monthAbDto.setMonthCar(Boolean.valueOf(false));
                log.info("[\u662f\u5426\u6708\u5361\u8f66\u5224\u65ad] monthId[{}]\u6709[{}]\u4e2a\u6708\u5361\u8f66\u5728\u573a,\u8f66\u724c\u53f7[{}]\u4e0d\u80fd\u6309\u6708\u5361\u8f66\u5904\u7406", new Object[]{monthId, inParkMonthCardCount, plateNum});
                return monthAbDto;
            }
            monthAbDto.setMonthCar(Boolean.valueOf(true));
            return monthAbDto;
        }
        monthAbDto.setAbCar(Boolean.valueOf(false));
        monthAbDto.setMonthCar(Boolean.valueOf(true));
        monthAbDto.setIndex(Integer.valueOf(1));
        return monthAbDto;
    }

    protected MonthAbDto abCar(Long parkId, String plateNum, long monthId, int plotCount, Long regionId) {
        MonthInfo monthInfo = this.monthInfoDao.load(monthId);
        if (monthInfo.getMoreMonthType() != null && monthInfo.getMoreMonthType() == 1) {
            log.info("\u96c6\u56e2\u6708\u5361\u591a\u4f4d\u591a\u8f66\u7684\u5224\u65ad {} {}", (Object)monthInfo, (Object)plateNum);
            return this.groupAbCar(plateNum, monthId, plotCount);
        }
        List plateNumList = this.monthPlateDao.selectByMonthId(Long.valueOf(monthId));
        MonthAbDto monthAbDto = MonthAbDto.builder().plotCount(Integer.valueOf(plotCount)).plateNumCount(Integer.valueOf(plateNumList.size())).build();
        if (this.isAbCarMonth(plotCount, plateNumList)) {
            int inParkMonthCardCount;
            monthAbDto.setAbCar(Boolean.valueOf(true));
            log.info("[\u662f\u5426\u6708\u5361\u8f66\u5224\u65ad] \u8f66\u724c\u53f7[{}]\u5c5e\u4e8e\u591a\u4f4d\u591a\u8f66", (Object)plateNum);
            List collect = plateNumList.stream().filter(pn -> !plateNum.equals(pn)).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                monthAbDto.setMonthCar(Boolean.valueOf(true));
                monthAbDto.setIndex(Integer.valueOf(1));
                return monthAbDto;
            }
            if (regionId != null) {
                ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
                ObjectResponse.notError((Response)parkObjectResponse);
                Park park = (Park)parkObjectResponse.getData();
                if (park != null && Integer.valueOf(1).equals(park.getIsInterior())) {
                    List monthRegions = this.monthRegionDao.selectByMonthId(monthId);
                    if (CollectionUtils.isNotEmpty((Collection)monthRegions)) {
                        MonthRegion parkRegion = monthRegions.stream().filter(mr -> NumberUtils.toPrimitive((Long)mr.getRegionId()) == 0L).findFirst().orElse(null);
                        if (parkRegion == null) {
                            List inParkPlates = this.orderSonInfoDao.selectInParkMonthCardByPlateNums(parkId, collect, regionId);
                            log.info("\u5360\u7528\u8f66\u724c\u53f7[{}]", (Object)inParkPlates);
                            inParkMonthCardCount = inParkPlates.size();
                        } else {
                            inParkMonthCardCount = this.orderInfoDao.countInParkMonthCardByPlateNums(parkId, collect);
                        }
                    } else {
                        inParkMonthCardCount = this.orderInfoDao.countInParkMonthCardByPlateNums(parkId, collect);
                    }
                } else {
                    inParkMonthCardCount = this.orderInfoDao.countInParkMonthCardByPlateNums(parkId, collect);
                }
            } else {
                inParkMonthCardCount = this.orderInfoDao.countInParkMonthCardByPlateNums(parkId, collect);
            }
            monthAbDto.setIndex(Integer.valueOf(inParkMonthCardCount + 1));
            if (inParkMonthCardCount >= plotCount) {
                monthAbDto.setMonthCar(Boolean.valueOf(false));
                log.info("[\u662f\u5426\u6708\u5361\u8f66\u5224\u65ad] monthId[{}]\u6709[{}]\u4e2a\u6708\u5361\u8f66\u5728\u573a,\u8f66\u724c\u53f7[{}]\u4e0d\u80fd\u6309\u6708\u5361\u8f66\u5904\u7406", new Object[]{monthId, inParkMonthCardCount, plateNum});
                return monthAbDto;
            }
            monthAbDto.setMonthCar(Boolean.valueOf(true));
            return monthAbDto;
        }
        monthAbDto.setAbCar(Boolean.valueOf(false));
        monthAbDto.setMonthCar(Boolean.valueOf(true));
        monthAbDto.setIndex(Integer.valueOf(1));
        return monthAbDto;
    }

    public MonthInfo getMonthInfo(Long parkId, String plateNum) {
        return this.monthInfoDao.selectByPlateNum(parkId, plateNum, VALID_CARD);
    }

    public void exitAbMonthDeal(Long parkId, String plateNum, Long exitTime) {
        OrderInfo recentOne;
        List plateNumList;
        MonthInfo monthInfoDto = this.getMonthInfo(parkId, plateNum);
        if (monthInfoDto == null) {
            return;
        }
        long monthId = monthInfoDto.getId();
        int plotCount = monthInfoDto.getPlotCount();
        if (!this.isAbCarMonth(plotCount, plateNumList = this.monthPlateDao.selectByMonthId(Long.valueOf(monthId)))) {
            return;
        }
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] plateNum[{}]\u662fAB\u8f66", (Object)plateNum);
        plateNumList.remove(plateNum);
        if (monthInfoDto.getMoreMonthType() != null && monthInfoDto.getMoreMonthType() == 1) {
            List<String> groupPlateNums;
            List monthPlates = this.monthPlateDao.selectAllByMonthId(Long.valueOf(monthId));
            List<MoreMonthPark> moreMonthPlateByPlateNum = this.moreMonthParkService.getMonthParkByMoreMonthId(monthInfoDto.getMoreMonthId());
            List<Long> parkIds = moreMonthPlateByPlateNum.stream().map(MoreMonthPark::getParkId).collect(Collectors.toList());
            List<OrderInfo> orderInfoList = this.getGroupInParkOrderInfos(parkIds, groupPlateNums = monthPlates.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList()), null);
            OrderInfo orderInfo = recentOne = CollectionUtils.isEmpty(orderInfoList) ? null : orderInfoList.get(0);
            if (recentOne == null) {
                log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5728\u573a\u8f66\u8f86\u4e2d\u4e0d\u5b58\u5728\u4e0e[{}]\u540c\u4e00\u7528\u6237\u7684\u4e34\u65f6\u8f66", (Object)plateNum);
                return;
            }
        } else {
            List<OrderInfo> orderInfoList = this.getInParkOrderInfos(parkId, plateNumList, null);
            OrderInfo orderInfo = recentOne = CollectionUtils.isEmpty(orderInfoList) ? null : orderInfoList.get(0);
            if (recentOne == null) {
                log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5728\u573a\u8f66\u8f86\u4e2d\u4e0d\u5b58\u5728\u4e0e[{}]\u540c\u4e00\u7528\u6237\u7684\u4e34\u65f6\u8f66", (Object)plateNum);
                return;
            }
        }
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u6700\u8fd1\u5165\u573a\u7684\u573a\u5185\u8f66\u8f86\uff1a{}", (Object)recentOne);
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        long intervalTime = exitTime - recentOne.getEnterTime();
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u5f53\u524d\u8f66\u724c\u79bb\u573a\u65f6\u95f4\u5230\u4e0a\u4e2a\u8ba2\u5355\u7684\u5165\u573a\u65f6\u95f4\u95f4\u9694\u662f\uff1a{}\uff0cplateNum\uff1a{}", (Object)intervalTime, (Object)plateNum);
        if (intervalTime <= (long)(parkConfig.getSwitchTm() * 60)) {
            OrderInfo orderInfoUpdate = new OrderInfo();
            orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
            orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
            this.orderInfoDao.updateByOrderNum(orderInfoUpdate);
            if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                Long regionId = recentOne.getRegionId();
                ParkRegion parkRegion = (ParkRegion)this.regionDao.selectById((Serializable)regionId);
                if (parkRegion != null && !Long.valueOf(0L).equals(parkRegion.getFatherRelationId())) {
                    regionId = parkRegion.getFatherRelationId();
                }
                orderSonInfoUpdate.setRegionId(regionId);
                this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
            }
            log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u672a\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66", (Object)plateNum);
        } else if (parkConfig.getSwitchType() == 1) {
            this.abCarSwitchTimeout(exitTime, recentOne);
        }
    }

    protected void abCarSwitchTimeout(Long exitTime, OrderInfo recentOne) {
        OrderInfo orderInfoUpdate = new OrderInfo();
        orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
        orderInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
        orderInfoUpdate.setSwitchTime(exitTime);
        this.orderInfoDao.updateByOrderNum(orderInfoUpdate);
        if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
            OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
            orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
            orderSonInfoUpdate.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
            orderSonInfoUpdate.setSwitchTime(exitTime);
            Long regionId = recentOne.getRegionId();
            ParkRegion parkRegion = (ParkRegion)this.regionDao.selectById((Serializable)regionId);
            if (parkRegion != null && !Long.valueOf(0L).equals(parkRegion.getFatherRelationId())) {
                regionId = parkRegion.getFatherRelationId();
            }
            orderSonInfoUpdate.setRegionId(regionId);
            this.orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
        }
        log.info("[\u591a\u4f4d\u591a\u8f66\u79bb\u573a\u5904\u7406] \u4ece\u5728\u573a\u8bb0\u5f55\u4e2d\u67e5\u627e\u5230[{}]\u6700\u8fd1\u5165\u573a\u5e76\u4e14\u662f\u4e34\u65f6\u8f66\uff0c\u5df2\u8d85\u8fc7\u5207\u6362\u65f6\u95f4\uff0c\u8f66\u8f86\u7c7b\u578b\u66f4\u65b0\u4e3a\u6708\u5361\u8f66\uff0c\u8f66\u8f86\u5207\u6362\u65f6\u95f4\u66f4\u65b0\u4e3a\u5f53\u524d\u8f66\u8f86\u7684\u51fa\u573a\u65f6\u95f4[{}]", (Object)recentOne.getPlateNum(), (Object)exitTime);
    }

    protected List<OrderInfo> getInParkOrderInfos(Long parkId, List<String> plates, Long regionId) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setRegionId(regionId);
        orderInfo.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
        orderInfo.setServiceStatus(Integer.valueOf(1));
        return this.orderInfoDao.selectListByPlates(orderInfo, plates);
    }

    protected List<OrderInfo> getGroupInParkOrderInfos(List<Long> parkIds, List<String> plates, Long regionId) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setRegionId(regionId);
        orderInfo.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
        orderInfo.setServiceStatus(Integer.valueOf(1));
        return this.orderInfoDao.selectListByPlates(orderInfo, parkIds, plates);
    }

    protected List<OrderSonInfo> getInParkOrderSonInfos(Long parkId, List<String> plates, Long regionId) {
        OrderSonInfo orderInfo = new OrderSonInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setRegionId(regionId);
        orderInfo.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
        orderInfo.setServiceStatus(Integer.valueOf(1));
        return this.orderSonInfoDao.selectListByPlates(orderInfo, plates);
    }

    protected boolean isAbCarMonth(int plotCount, List<String> plateNumList) {
        if (plateNumList == null) {
            return false;
        }
        int plateCount = plateNumList.size();
        return plateCount > plotCount;
    }
}

