/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.month;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthOrderDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthOrder;
import com.icetech.park.dao.month.MonthDepositOperateRecordDao;
import com.icetech.park.dao.month.MonthDepositRecordDao;
import com.icetech.park.domain.dto.month.MonthDepositOperateRecordDTO;
import com.icetech.park.domain.dto.month.MonthDepositRecordDTO;
import com.icetech.park.domain.entity.month.MonthDepositOperateRecord;
import com.icetech.park.domain.entity.month.MonthDepositRecord;
import com.icetech.park.domain.request.month.DepositOperateParam;
import com.icetech.park.domain.request.month.DepositParam;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.normalpay.request.RefundRequest;
import com.icetech.paycenter.domain.normalpay.response.RefundResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MonthService {
    private static final Logger log = LoggerFactory.getLogger(MonthService.class);
    @Resource
    private MonthDepositRecordDao monthDepositRecordDao;
    @Resource
    private MonthDepositOperateRecordDao monthDepositOperateRecordDao;
    @Resource
    private ParkServiceImpl parkService;
    @Resource
    private IPayCenterService payCenterService;
    @Resource
    private MonthOrderDao monthOrderDao;
    @Resource
    private MonthInfoDao monthInfoDao;

    public ObjectResponse<?> monthDepositRecordList(DepositParam param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        Page<MonthDepositRecordDTO> monthDepositPage = this.monthDepositRecordDao.getPage((Page<MonthDepositRecordDTO>)page, param);
        return ObjectResponse.success(monthDepositPage);
    }

    public ObjectResponse<?> monthDepositOperateRecordList(DepositParam param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        Page<MonthDepositOperateRecordDTO> monthDepositPage = this.monthDepositOperateRecordDao.getPage((Page<MonthDepositOperateRecordDTO>)page, param);
        return ObjectResponse.success(monthDepositPage);
    }

    @Transactional(rollbackFor={Exception.class, RuntimeException.class})
    public ObjectResponse<?> monthDepositAddRecord(Integer id) {
        try {
            MonthDepositRecord record = (MonthDepositRecord)this.monthDepositRecordDao.selectById(id);
            if (record == null) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6708\u5361\u8bb0\u5f55");
            }
            this.checkMonthRecord(record);
            this.saveDepositOperateRecord(record);
            return ObjectResponse.success();
        }
        catch (RuntimeException e) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getDesc(), (String)e.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class, RuntimeException.class})
    public ObjectResponse<?> monthDepositAuditOperate(DepositOperateParam param) {
        try {
            MonthDepositOperateRecord operateRecord = (MonthDepositOperateRecord)this.monthDepositOperateRecordDao.selectById(param.getId());
            if (operateRecord == null) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6708\u5361\u9000\u5361\u8bb0\u5f55");
            }
            MonthDepositRecord record = (MonthDepositRecord)this.monthDepositRecordDao.selectById(operateRecord.getDepositId());
            if (record == null) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6708\u5361\u8bb0\u5f55");
            }
            if (param.getAuditResult() == 0) {
                this.updateDepositOperateRecord(operateRecord, 0, param.getAuditReason(), 0, null);
                return ObjectResponse.success();
            }
            if (record.getPayMethod() == 0) {
                this.updateDepositRecord(record, 1);
                this.updateDepositOperateRecord(operateRecord, 1, null, param.getAuditResult(), null);
                return ObjectResponse.success();
            }
            return this.monthRefund(record, operateRecord);
        }
        catch (RuntimeException e) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getDesc(), (String)e.getMessage());
        }
    }

    private void checkMonthRecord(MonthDepositRecord record) {
        if (record.getDepositStatus() == 1) {
            throw new RuntimeException("\u62bc\u91d1\u5df2\u9000\u8fd8");
        }
        MonthInfo monthInfo = this.monthInfoDao.load((long)record.getMonthId().intValue());
        log.info("\u6708\u5361\u4fe1\u606f\uff1a{}", (Object)monthInfo);
        if (monthInfo == null) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6708\u5361\u4fe1\u606f");
        }
        if (monthInfo.getCardStatus() == 1) {
            throw new RuntimeException("\u6708\u5361\u751f\u6548\u4e2d\uff0c\u6682\u4e0d\u652f\u6301\u9000\u8d39\uff01");
        }
        if (monthInfo.getCardStatus() == 2) {
            throw new RuntimeException("\u6708\u5361\u5f85\u751f\u6548\uff0c\u6682\u4e0d\u652f\u6301\u9000\u8d39\uff01");
        }
        if (monthInfo.getCardStatus() == 5) {
            throw new RuntimeException("\u6708\u5361\u51bb\u7ed3\uff0c\u6682\u4e0d\u652f\u6301\u9000\u8d39\uff01");
        }
        MonthDepositOperateRecord operateRecord = (MonthDepositOperateRecord)this.monthDepositOperateRecordDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MonthDepositOperateRecord.class).eq(MonthDepositOperateRecord::getDepositId, (Object)record.getId())).eq(MonthDepositOperateRecord::getAuditResult, (Object)2)).last("LIMIT 1"));
        if (operateRecord != null) {
            throw new RuntimeException("\u5df2\u5b58\u5728\u5f85\u5ba1\u6838\u62bc\u91d1\u9000\u8fd4\u8bb0\u5f55");
        }
    }

    private void saveDepositOperateRecord(MonthDepositRecord record) {
        MonthDepositOperateRecord operateRecord = new MonthDepositOperateRecord();
        operateRecord.setDepositId(record.getId());
        operateRecord.setCardOpertype(record.getCardOpertype());
        operateRecord.setDepositStatus(Integer.valueOf(2));
        operateRecord.setAuditResult(Integer.valueOf(2));
        operateRecord.setCreateTime(new Date());
        operateRecord.setPayChannel(record.getPayChannel());
        this.monthDepositOperateRecordDao.insert(operateRecord);
    }

    private void updateDepositRecord(MonthDepositRecord record, Integer depositStatus) {
        record.setDepositStatus(depositStatus);
        record.setDepositTime(new Date());
        this.monthDepositRecordDao.updateById(record);
    }

    private void updateDepositOperateRecord(MonthDepositOperateRecord operateRecord, Integer depositStatus, String auditReason, Integer auditResult, String remark) {
        operateRecord.setDepositStatus(depositStatus);
        operateRecord.setAuditReason(auditReason);
        operateRecord.setAuditResult(auditResult);
        operateRecord.setUpdateTime(new Date());
        operateRecord.setRemark(remark);
        this.monthDepositOperateRecordDao.updateById(operateRecord);
    }

    private ObjectResponse<?> monthRefund(MonthDepositRecord record, MonthDepositOperateRecord operateRecord) {
        BasePark park = (BasePark)this.parkService.getById((Serializable)record.getParkId());
        String newTradeNo = "R" + CodeTools.GenerateTradeNo();
        MonthOrder order = this.monthOrderDao.load(record.getOrderId().intValue());
        log.info("\u5f00\u59cb\u5904\u7406\u5355\u7b14\u9000\u6b3e | tradeNo:{} | newTradeNo:{} | refundPrice:{}", new Object[]{order.getTradeNo(), newTradeNo, record.getDeposit()});
        ObjectResponse<RefundResponse> response = this.callMonthRefundApi(park.getParkCode(), order, newTradeNo, record.getDeposit());
        log.info("\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1a{}", response);
        if (!ObjectResponse.isSuccess(response) || response.getData() == null) {
            String msg = response.getData() == null ? "\u9000\u6b3e\u5931\u8d25" : response.getMsg();
            this.updateDepositRecord(record, 2);
            this.updateDepositOperateRecord(operateRecord, 0, null, 1, msg);
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getDesc(), (String)msg);
        }
        if (((RefundResponse)response.getData()).getRefundStatus() == 4) {
            this.updateDepositRecord(record, 2);
            this.updateDepositOperateRecord(operateRecord, 0, null, 1, response.getMsg());
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getDesc(), (String)response.getMsg());
        }
        if (((RefundResponse)response.getData()).getRefundStatus() == 3) {
            this.updateDepositRecord(record, 1);
            this.updateDepositOperateRecord(operateRecord, 1, null, 1, response.getMsg());
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getDesc(), (String)"\u9000\u6b3e\u5931\u8d25\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    private ObjectResponse<RefundResponse> callMonthRefundApi(String parkCode, MonthOrder order, String tradeNo, BigDecimal refundPrice) {
        RefundRequest request = new RefundRequest();
        request.setParkCode(parkCode);
        request.setOutTradeNo(order.getOutTradeNo());
        request.setTradeNo(order.getTradeNo());
        request.setRefundTradeNo(tradeNo);
        request.setPrice(String.valueOf(MoneyTool.fromYuanToFen((String)String.valueOf(refundPrice))));
        request.setOrderNote("\u6708\u5361\u62bc\u91d1\u9000\u8fd8");
        return this.payCenterService.refund(request);
    }
}

