/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.makeup;

import com.icetech.common.thread.ScheduleUtils;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.makeup.IRepeatTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsRepeatPush {
    private static final Logger log = LoggerFactory.getLogger(WsRepeatPush.class);
    private static final int OFF_SET_TIME = 60000;
    private static final int PRE_TIME = 500;
    private static final int INTERVAL_TIME = 500;
    private P2cDownHandle p2cDownHandle;
    private String parkCode;
    private String serialNumber;

    public WsRepeatPush(P2cDownHandle p2cDownHandle, String parkCode, String serialNumber) {
        this.p2cDownHandle = p2cDownHandle;
        this.parkCode = parkCode;
        this.serialNumber = serialNumber;
    }

    public void push(ScheduledThreadPoolExecutor scheduler, IRepeatTask repeatTask) {
        this.p2cDownHandle.closeAllOld(this.parkCode + "_" + this.serialNumber);
        this.p2cDownHandle.closeAll(this.serialNumber);
        long maxTimeMillis = System.currentTimeMillis() + 60000L;
        ScheduleUtils.scheduleFixTimesWithFixDelay((ScheduledExecutorService)scheduler, index -> {
            if (repeatTask.run()) {
                log.info("[{}_{}]\u7b2c{}\u6b21\u91cd\u53d1\u6210\u529f", new Object[]{this.parkCode, this.serialNumber, index});
                return true;
            }
            if (System.currentTimeMillis() > maxTimeMillis) {
                log.info("[{}_{}]\u7b2c{}\u6b21\u91cd\u53d1\u8fbe\u5230\u6700\u5927\u65f6\u95f4", new Object[]{this.parkCode, this.serialNumber, index});
                return false;
            }
            log.info("[{}_{}]\u7b2c{}\u6b21\u91cd\u53d1\u5931\u8d25", new Object[]{this.parkCode, this.serialNumber, index});
            return null;
        }, (int)100, (long)500L, (long)500L);
    }
}

