/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.ledsound;

import com.icetech.basics.config.GrayProperties;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.dao.ledsound.LedConfigDao;
import com.icetech.park.dao.ledsound.LedShowDao;
import com.icetech.park.dao.ledsound.LedSoundDao;
import com.icetech.park.dao.ledsound.LedTipsDao;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.redis.handle.RedisHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LedServiceImpl
implements LedService {
    private static final Logger log = LoggerFactory.getLogger(LedServiceImpl.class);
    @Autowired
    private LedShowDao ledShowDao;
    @Autowired
    private LedSoundDao ledSoundDao;
    @Autowired
    private LedConfigDao ledConfigDao;
    @Autowired
    private LedTipsDao ledTipsDao;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private GrayProperties grayProperties;

    public ObjectResponse<List<LedShowDto>> getLedShowDtoByChannel(Long channelId) {
        Map<String, List<LedShow>> configMap = this.getLedShowMapByChannel(channelId);
        Map<String, List<LedShow>> defaultMap = this.getLedShowMapByChannel(null);
        ArrayList<LedShowDto> ledShowDtoList = new ArrayList<LedShowDto>(LedShow.DisplayTypeEnum.values().length);
        for (LedShow.DisplayTypeEnum typeEnum : LedShow.DisplayTypeEnum.values()) {
            List<LedShow> ledShows = configMap.get(String.valueOf(typeEnum.type));
            if (CollectionUtils.isEmpty(ledShows)) {
                ledShows = defaultMap.get(String.valueOf(typeEnum.type));
            }
            if (!CollectionUtils.isNotEmpty(ledShows)) continue;
            LedShowDto ledShowDto = this.mergeLedContent(ledShows, typeEnum.type);
            ledShowDtoList.add(ledShowDto);
        }
        return ObjectResponse.success(ledShowDtoList);
    }

    public ObjectResponse<LedShowDto> getLedShowByType(Long channelId, int type) {
        List<LedShow> ledShows = this.selectLedConfigByType(channelId, type);
        if (ledShows == null || ledShows.size() == 0) {
            ledShows = this.selectLedConfigByType(null, type);
        }
        LedShowDto ledShowDto = this.mergeLedContent(ledShows, type);
        return ObjectResponse.success((Object)ledShowDto);
    }

    public Map<Integer, LedShowDto> getLedShowDtoMapByChannel(Long channelId) {
        Map<String, List<LedShow>> typeMap = this.getLedShowMapByChannel(channelId);
        if (typeMap == Collections.EMPTY_MAP) {
            typeMap = new LinkedHashMap<String, List<LedShow>>();
        }
        Map<String, List<LedShow>> defaultTypeMap = this.getLedShowMapByChannel(null);
        HashMap<Integer, LedShowDto> dtoMap = new HashMap<Integer, LedShowDto>(defaultTypeMap.size());
        for (Map.Entry<String, List<LedShow>> defaultTypeEntry : defaultTypeMap.entrySet()) {
            List<LedShow> ledShows = typeMap.get(defaultTypeEntry.getKey());
            if (CollectionUtils.isEmpty(ledShows)) {
                ledShows = defaultTypeEntry.getValue();
            }
            if (!CollectionUtils.isNotEmpty(ledShows)) continue;
            int type = Integer.parseInt(defaultTypeEntry.getKey());
            dtoMap.put(type, this.mergeLedContent(ledShows, type));
        }
        return dtoMap;
    }

    public ObjectResponse<List<LedSoundDto>> getLedSoundDtoByChannel(Long channelId) {
        Map<Integer, LedSoundDto> soundDtoMap = this.getLedSoundDtoMapByChannel(channelId);
        List ledSoundDtoList = Stream.of(LedSound.SoundTypeEnum.values()).map(typeEnum -> (LedSoundDto)soundDtoMap.get(typeEnum.type)).collect(Collectors.toList());
        return ObjectResponse.success(ledSoundDtoList);
    }

    public ObjectResponse<LedSoundDto> getLedSoundDtoByType(Long channelId, int type) {
        LedSound ledSound = this.selectLedSoundByType(channelId, type);
        if (ledSound == null) {
            ledSound = this.selectLedSoundByType(null, type);
        }
        LedSoundDto ledSoundDto = this.mergeSoundContent(ledSound, type);
        return ObjectResponse.success((Object)ledSoundDto);
    }

    public Map<Integer, LedSoundDto> getLedSoundDtoMapByChannel(Long channelId) {
        Map<String, LedSound> typeMap = this.getLedSoundMapByChannel(channelId);
        Map<String, LedSound> defaultTypeMap = this.getLedSoundMapByChannel(null);
        HashMap<Integer, LedSoundDto> dtoMap = new HashMap<Integer, LedSoundDto>(defaultTypeMap.size());
        for (Map.Entry<String, LedSound> defaultSoundEntry : defaultTypeMap.entrySet()) {
            LedSound sound = typeMap.get(defaultSoundEntry.getKey());
            if (sound == null) {
                sound = defaultSoundEntry.getValue();
            }
            int type = Integer.parseInt(defaultSoundEntry.getKey());
            LedSoundDto dto = this.mergeSoundContent(sound, type);
            dtoMap.put(type, dto);
        }
        return dtoMap;
    }

    public ObjectResponse<LedConfig> getLedConfigByChannel(Long channelId) {
        LedConfig ledConfig = this.selectLedConfig(channelId);
        if (ledConfig == null) {
            ledConfig = this.selectLedConfig(null);
        }
        if (ledConfig != null) {
            return ObjectResponse.success((Object)ledConfig);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<LedTips> getLedTipsByChannel(Long channelId) {
        LedTips ledTips = this.cacheLedTipsByChannel(channelId);
        if (ledTips == null) {
            ledTips = this.cacheLedTipsByChannel(null);
        }
        if (ledTips != null) {
            return ObjectResponse.success((Object)ledTips);
        }
        return ObjectResponse.failed((String)"404");
    }

    private LedTips cacheLedTipsByChannel(Long channelId) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:tips:park:default" : "led:tips:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return (LedTips)this.redisHandle.cacheObject(cacheKey, LedTips.class, () -> {
            if (channelId == null) {
                return this.ledTipsDao.selectDefault();
            }
            return this.ledTipsDao.selectByChannelId(channelId);
        }, 604800000L);
    }

    public LedShowDto mergeLedContent(List<LedShow> ledShows, int type) {
        LedShowDto ledShowDto = new LedShowDto();
        ledShowDto.setDisplayType(Integer.valueOf(type));
        int lines = ledShows.size();
        String[] lineContentArr = new String[lines];
        if (!ledShows.isEmpty()) {
            String content = "";
            String ledColor = "";
            for (int l = 0; l < lines; ++l) {
                String lineContent;
                LedShow ledShow = ledShows.get(l);
                ledColor = ledColor + "/" + ledShow.getLedColor();
                lineContentArr[l] = lineContent = this.transferFormat(ledShow.getCustomContent(), ledShow.getDynamicContent());
            }
            for (String lc : lineContentArr) {
                content = content + "/" + (StringUtils.isNotBlank((CharSequence)lc) ? lc : "");
            }
            if (content.startsWith("/")) {
                ledShowDto.setContent(content.substring(1));
            } else {
                ledShowDto.setContent(content);
            }
            ledShowDto.setLedColor(ledColor.substring(1));
        }
        return ledShowDto;
    }

    public LedSoundDto mergeSoundContent(LedSound ledSound, int type) {
        LedSoundDto ledSoundDto = new LedSoundDto();
        ledSoundDto.setSoundType(Integer.valueOf(type));
        if (ledSound == null) {
            ledSoundDto.setContent("");
            return ledSoundDto;
        }
        String lineContent = this.transferFormat(ledSound.getCustomContent(), ledSound.getDynamicContent());
        ledSoundDto.setContent(lineContent.trim());
        return ledSoundDto;
    }

    public List<LedShow> selectLedConfigByType(@Nullable Long channelId, int type) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:show:park:default" : "led:show:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return this.redisHandle.getListFromMap(cacheKey, String.valueOf(type), LedShow.class, this.cacheLedShowMap(channelId), 604800000L);
    }

    public Map<String, List<LedShow>> getLedShowMapByChannel(@Nullable Long channelId) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:show:park:default" : "led:show:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return this.redisHandle.cacheListMap(cacheKey, LedShow.class, this.cacheLedShowMap(channelId), 604800000L);
    }

    private Supplier<Map<String, List<LedShow>>> cacheLedShowMap(@Nullable Long channelId) {
        return () -> {
            List<LedShow> ledShows = null;
            if (channelId != null) {
                ledShows = this.ledShowDao.selectByChannelId(channelId);
            }
            if (CollectionUtils.isEmpty(ledShows)) {
                ledShows = this.ledShowDao.selectParkDefault();
            }
            Map<String, List<LedShow>> typeMap = ledShows.stream().collect(Collectors.groupingBy(led -> led.getDisplayType().toString()));
            for (LedShow.DisplayTypeEnum type : LedShow.DisplayTypeEnum.values()) {
                typeMap.putIfAbsent(String.valueOf(type.type), null);
            }
            return typeMap;
        };
    }

    public LedConfig selectLedConfig(@Nullable Long channelId) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:config:park:default" : "led:config:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return (LedConfig)this.redisHandle.cacheObject(cacheKey, LedConfig.class, () -> {
            if (channelId == null) {
                return this.ledConfigDao.selectDefault();
            }
            return this.ledConfigDao.selectByChannelId(channelId);
        }, 604800000L);
    }

    public LedSound selectLedSoundByType(@Nullable Long channelId, int type) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:sound:park:default" : "led:sound:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return (LedSound)this.redisHandle.getObjectFromMap(cacheKey, String.valueOf(type), LedSound.class, this.cacheChannelSoundMap(channelId), 604800000L);
    }

    public Map<String, LedSound> getLedSoundMapByChannel(@Nullable Long channelId) {
        String cacheKey;
        String string = cacheKey = channelId == null ? "led:sound:park:default" : "led:sound:channel:" + channelId;
        if (this.grayProperties.isCacheEnable()) {
            cacheKey = "gray:" + cacheKey;
        }
        return this.redisHandle.cacheObjectMap(cacheKey, LedSound.class, this.cacheChannelSoundMap(channelId), 604800000L);
    }

    private Supplier<Map<String, LedSound>> cacheChannelSoundMap(@Nullable Long channelId) {
        return () -> {
            List<LedSound> ledSounds = null;
            if (channelId != null) {
                ledSounds = this.ledSoundDao.selectByChannelId(channelId);
            }
            if (CollectionUtils.isEmpty(ledSounds)) {
                ledSounds = this.ledSoundDao.selectParkDefault();
            }
            Map typeMap = ledSounds.stream().collect(Collectors.toMap(sound -> sound.getSoundType().toString(), Function.identity(), (old, newer) -> newer));
            for (LedSound.SoundTypeEnum type : LedSound.SoundTypeEnum.values()) {
                typeMap.putIfAbsent(String.valueOf(type.type), null);
            }
            return typeMap;
        };
    }

    private String transferFormat(String customContent, String dynamicContent) {
        int p2;
        String p1;
        String[] partArr;
        String part;
        int i;
        String[] split1Arr;
        customContent = customContent == null ? "" : customContent.trim();
        String string = dynamicContent = dynamicContent == null ? "" : dynamicContent.trim();
        if ((customContent + dynamicContent).length() == 0) {
            return "";
        }
        int modulesLength = (customContent.length() == 0 ? dynamicContent : customContent + "+" + dynamicContent).split("\\+").length;
        String[] lineModulesArr = new String[modulesLength];
        if (StringUtils.isNotBlank((CharSequence)customContent)) {
            split1Arr = customContent.split("\\+");
            for (i = 0; i < split1Arr.length; ++i) {
                part = split1Arr[i];
                partArr = part.split("\\_");
                p1 = partArr[0];
                p2 = Integer.parseInt(partArr[1]);
                lineModulesArr[p2 - 1] = p1;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicContent)) {
            split1Arr = dynamicContent.split("\\+");
            for (i = 0; i < split1Arr.length; ++i) {
                part = split1Arr[i];
                partArr = part.split("\\_");
                p1 = partArr[0];
                p2 = Integer.parseInt(partArr[1]);
                lineModulesArr[p2 - 1] = "{" + p1 + "}";
            }
        }
        String content = "";
        for (String lineModules : lineModulesArr) {
            content = content + lineModules + " ";
        }
        return content.trim();
    }
}

