/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.lcd;

import cn.hutool.core.collection.CollectionUtil;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.domain.response.LcdDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.dao.lcd.LcdBrightnessDao;
import com.icetech.park.dao.lcd.LcdConfigDao;
import com.icetech.park.dao.lcd.LcdShowDao;
import com.icetech.park.dao.lcd.LcdSoundDao;
import com.icetech.park.dao.lcd.LcdSoundcodeDao;
import com.icetech.park.dao.lcd.LcdTipsDao;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.domain.entity.lcd.LcdSoundcode;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.redis.handle.RedisHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LcdServiceImpl
implements LcdService {
    private static final Logger log = LoggerFactory.getLogger(LcdServiceImpl.class);
    @Autowired
    private LcdShowDao lcdShowDao;
    @Autowired
    private LcdSoundDao lcdSoundDao;
    @Autowired
    private LcdConfigDao lcdConfigDao;
    @Autowired
    private LcdTipsDao lcdTipsDao;
    @Autowired
    private LcdBrightnessDao lcdBrightnessDao;
    @Autowired
    private LcdSoundcodeDao lcdSoundcodeDao;
    @Resource
    private RedisHandle redisHandle;

    public ObjectResponse<List<LcdDto>> getLcdShowByChannel(Long channelId) {
        List lcdDtoList = Stream.of(LcdShow.DisplayTypeEnum.values()).map(type -> (LcdDto)this.getLcdShowByType(channelId, type.type).getData()).collect(Collectors.toList());
        return ObjectResponse.success(lcdDtoList);
    }

    public ObjectResponse<LcdDto> getLcdShowByType(Long channelId, int type) {
        List<LcdShow> lcds = this.selectLcdShowByType(channelId, type);
        if (lcds == null || lcds.size() == 0) {
            lcds = this.selectLcdShowByType(null, type);
        }
        LcdDto LcdDto2 = this.mergeLedContent(lcds, type);
        return ObjectResponse.success((Object)LcdDto2);
    }

    public Map<Integer, LcdDto> getLcdShowDtoMapByChannel(Long channelId) {
        Map<String, List<LcdShow>> typeMap = this.getLcdShowMapByChannel(channelId);
        if (typeMap == Collections.EMPTY_MAP) {
            typeMap = new LinkedHashMap<String, List<LcdShow>>();
        }
        Map<String, List<LcdShow>> defaultTypeMap = this.getLcdShowMapByChannel(null);
        HashMap<Integer, LcdDto> dtoMap = new HashMap<Integer, LcdDto>(defaultTypeMap.size());
        for (Map.Entry<String, List<LcdShow>> defaultTypeEntry : defaultTypeMap.entrySet()) {
            List<LcdShow> lcdShows = typeMap.get(defaultTypeEntry.getKey());
            if (CollectionUtils.isEmpty(lcdShows)) {
                lcdShows = defaultTypeEntry.getValue();
            }
            if (!CollectionUtils.isNotEmpty(lcdShows)) continue;
            int type = Integer.parseInt(defaultTypeEntry.getKey());
            dtoMap.put(type, this.mergeLedContent(lcdShows, type));
        }
        return dtoMap;
    }

    public List<LcdShow> selectLcdShowByType(@Nullable Long channelId, int type) {
        String cacheKey = channelId == null ? "lcd:show:park:default" : "lcd:show:channel:" + channelId;
        return this.redisHandle.getListFromMap(cacheKey, String.valueOf(type), LcdShow.class, this.cacheLcdShowMap(channelId), 604800000L);
    }

    public Map<String, List<LcdShow>> getLcdShowMapByChannel(@Nullable Long channelId) {
        String cacheKey = channelId == null ? "lcd:show:park:default" : "lcd:show:channel:" + channelId;
        return this.redisHandle.cacheListMap(cacheKey, LcdShow.class, this.cacheLcdShowMap(channelId), 604800000L);
    }

    private Supplier<Map<String, List<LcdShow>>> cacheLcdShowMap(@Nullable Long channelId) {
        return () -> {
            List<LcdShow> lcdShows = null;
            if (channelId != null) {
                lcdShows = this.lcdShowDao.selectByChannelId(channelId);
            }
            if (CollectionUtils.isEmpty(lcdShows)) {
                lcdShows = this.lcdShowDao.selectParkDefault();
            }
            Map<String, List<LcdShow>> typeMap = lcdShows.stream().collect(Collectors.groupingBy(show -> show.getDisplayType().toString()));
            for (LcdShow.DisplayTypeEnum type : LcdShow.DisplayTypeEnum.values()) {
                typeMap.putIfAbsent(String.valueOf(type.type), null);
            }
            return typeMap;
        };
    }

    public ObjectResponse<List<LedSoundDto>> getSoundConfigByChannel(Long channelId) {
        List<LcdSound> soundList = this.getLcdSoundsByChannel(channelId);
        if (soundList == null || soundList.size() == 0) {
            soundList = this.getLcdSoundsByChannel(null);
        }
        List ledSoundDtoList = soundList.stream().map(sound -> {
            LedSoundDto ledSoundDto = new LedSoundDto();
            ledSoundDto.setSoundType(sound.getSoundType());
            ledSoundDto.setContent(sound.getContentPattern().replaceAll("\\+", " "));
            return ledSoundDto;
        }).collect(Collectors.toList());
        return ObjectResponse.success(ledSoundDtoList);
    }

    public ObjectResponse<LedSoundDto> getSoundConfigByType(Long channelId, int type) {
        List<LcdSound> sounds = this.selectLcdSoundByType(channelId, type);
        if (CollectionUtils.isEmpty(sounds)) {
            sounds = this.selectLcdSoundByType(null, type);
        }
        if (CollectionUtils.isEmpty(sounds)) {
            LedSoundDto ledSoundDto = new LedSoundDto();
            ledSoundDto.setSoundType(Integer.valueOf(type));
            ledSoundDto.setContent("");
            return ObjectResponse.success((Object)ledSoundDto);
        }
        LcdSound sound = sounds.get(0);
        LedSoundDto ledSoundDto = new LedSoundDto();
        ledSoundDto.setSoundType(sound.getSoundType());
        ledSoundDto.setContent(sound.getContentPattern().replaceAll("\\+", " "));
        return ObjectResponse.success((Object)ledSoundDto);
    }

    public Map<Integer, LedSoundDto> getSoundDtoMapByChannel(Long channelId) {
        Map<String, List<LcdSound>> typeMap = this.getLcdSoundMapByChannel(channelId);
        Map<String, List<LcdSound>> defaultTypeMap = this.getLcdSoundMapByChannel(null);
        HashMap<Integer, LedSoundDto> dtoMap = new HashMap<Integer, LedSoundDto>(defaultTypeMap.size());
        for (Map.Entry<String, List<LcdSound>> defaultSoundEntry : defaultTypeMap.entrySet()) {
            LcdSound sound;
            List<LcdSound> sounds = typeMap.get(defaultSoundEntry.getKey());
            if (CollectionUtils.isEmpty(sounds)) {
                sounds = defaultSoundEntry.getValue();
            }
            if ((sound = (LcdSound)CollectionUtil.get(sounds, (int)0)) == null) continue;
            LedSoundDto ledSoundDto = new LedSoundDto();
            ledSoundDto.setSoundType(sound.getSoundType());
            ledSoundDto.setContent(sound.getContentPattern().replaceAll("\\+", " "));
            int type = Integer.parseInt(defaultSoundEntry.getKey());
            dtoMap.put(type, ledSoundDto);
        }
        return dtoMap;
    }

    public ObjectResponse<LcdConfig> getLcdConfigByChannel(Long channelId) {
        LcdConfig lcdConfig = this.selectChannelLcdConfig(channelId);
        if (lcdConfig == null) {
            lcdConfig = this.selectChannelLcdConfig(null);
        }
        if (lcdConfig == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)lcdConfig);
    }

    public ObjectResponse<LcdTips> getLcdTipsByChannel(Long channelId) {
        LcdTips lcdTips = this.cacheLcdTipsByChannel(channelId);
        if (lcdTips == null) {
            lcdTips = this.cacheLcdTipsByChannel(null);
        }
        if (lcdTips != null) {
            return ObjectResponse.success((Object)lcdTips);
        }
        return ObjectResponse.failed((String)"404");
    }

    private LcdTips cacheLcdTipsByChannel(Long channelId) {
        String cacheKey = channelId == null ? "lcd:tips:park:default" : "lcd:tips:channel:" + channelId;
        return (LcdTips)this.redisHandle.cacheObject(cacheKey, LcdTips.class, () -> {
            if (channelId == null) {
                return this.lcdTipsDao.selectDefault();
            }
            return this.lcdTipsDao.selectByChannelId(channelId);
        }, 604800000L);
    }

    public ObjectResponse<LcdSoundcode> getLcdSoundCode(String soundCode) {
        Map<String, LcdSoundcode> lcdSoundCodeMap = this.cacheLcdSoundCodeMap();
        LcdSoundcode lcdSoundcode = lcdSoundCodeMap.get(soundCode);
        return ObjectResponse.returnNotFoundIfNull((Object)lcdSoundcode);
    }

    public ObjectResponse<List<LcdSoundcode>> getAllLcdSoundCodes() {
        Map<String, LcdSoundcode> lcdSoundCodeMap = this.cacheLcdSoundCodeMap();
        if (lcdSoundCodeMap.isEmpty()) {
            return ObjectResponse.failed((String)"404");
        }
        ArrayList<LcdSoundcode> codes = new ArrayList<LcdSoundcode>(lcdSoundCodeMap.values());
        return ObjectResponse.success(codes);
    }

    private Map<String, LcdSoundcode> cacheLcdSoundCodeMap() {
        String cacheKey = "lcd:sound:code:default";
        return this.redisHandle.cacheObjectMap(cacheKey, LcdSoundcode.class, () -> this.lcdSoundcodeDao.selectAll().stream().collect(Collectors.toMap(LcdSoundcode::getSoundCode, Function.identity(), (older, newer) -> newer)), 604800000L);
    }

    public List<LcdSound> selectLcdSoundByType(@Nullable Long channelId, int type) {
        String cacheKey = channelId == null ? "lcd:sound:park:default" : "lcd:sound:channel:" + channelId;
        return this.redisHandle.getListFromMap(cacheKey, String.valueOf(type), LcdSound.class, this.cacheLcdSoundMap(channelId), 604800000L);
    }

    public List<LcdSound> getLcdSoundsByChannel(@Nullable Long channelId) {
        Map<String, List<LcdSound>> cacheMap = this.getLcdSoundMapByChannel(channelId);
        return cacheMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, List<LcdSound>> getLcdSoundMapByChannel(@Nullable Long channelId) {
        String cacheKey = channelId == null ? "lcd:sound:park:default" : "lcd:sound:channel:" + channelId;
        return this.redisHandle.cacheListMap(cacheKey, LcdSound.class, this.cacheLcdSoundMap(channelId), 604800000L);
    }

    private Supplier<Map<String, List<LcdSound>>> cacheLcdSoundMap(@Nullable Long channelId) {
        return () -> {
            List<LcdSound> sounds = null;
            if (channelId != null) {
                sounds = this.lcdSoundDao.selectByChannelId(channelId);
            }
            if (CollectionUtils.isEmpty(sounds)) {
                sounds = this.lcdSoundDao.selectParkDefault();
            }
            Map<String, List<LcdSound>> typeMap = sounds.stream().collect(Collectors.groupingBy(sound -> sound.getSoundType().toString()));
            for (LcdSound.SoundTypeEnum type : LcdSound.SoundTypeEnum.values()) {
                typeMap.putIfAbsent(String.valueOf(type.type), null);
            }
            return typeMap;
        };
    }

    public LcdConfig selectChannelLcdConfig(Long channelId) {
        String cacheKey = channelId == null ? "lcd:config:park:default" : "lcd:config:channel:" + channelId;
        return (LcdConfig)this.redisHandle.cacheObject(cacheKey, LcdConfig.class, () -> {
            LcdConfig lcdConfig;
            LcdConfig lcdConfig2 = lcdConfig = channelId == null ? this.lcdConfigDao.selectDefault() : this.lcdConfigDao.selectByChannelId(channelId);
            if (lcdConfig != null) {
                List<LcdBrightness> lcdBrightnesses = this.lcdBrightnessDao.findByLcdId(lcdConfig.getId());
                if (lcdBrightnesses == null || lcdBrightnesses.size() == 0) {
                    LcdBrightness lcdBrightness = new LcdBrightness();
                    lcdBrightness.setStartTimePoint("00:00");
                    lcdBrightness.setEndTimePoint("23:59");
                    lcdBrightness.setBrightnessVal(Integer.valueOf(5));
                    lcdBrightnesses = new ArrayList<LcdBrightness>();
                    lcdBrightnesses.add(lcdBrightness);
                }
                lcdConfig.setLcdBrightnessList(lcdBrightnesses);
            }
            return lcdConfig;
        }, 604800000L);
    }

    public LcdDto mergeLedContent(List<LcdShow> lcds, int type) {
        LcdDto lcdDto = new LcdDto();
        lcdDto.setDisplayType(Integer.valueOf(type));
        int lines = lcds.size();
        String[] lineContentArr = new String[lines];
        if (lcds != null && lcds.size() > 0) {
            String content = "";
            String lcdColor = "";
            for (int l = 0; l < lines; ++l) {
                String lineContent;
                LcdShow lcdShow = lcds.get(l);
                lcdColor = lcdColor + "/" + lcdShow.getRowColor();
                lineContentArr[l] = lineContent = this.transferFormat(lcdShow.getCustomContent(), lcdShow.getDynamicContent());
            }
            for (String lc : lineContentArr) {
                content = content + "/" + (StringUtils.isNotBlank((CharSequence)lc) ? lc : "");
            }
            if (content.startsWith("/")) {
                lcdDto.setContent(content.substring(1, content.length()));
            } else {
                lcdDto.setContent(content);
            }
            lcdDto.setLedColor(lcdColor.substring(1, lcdColor.length()));
        }
        return lcdDto;
    }

    private String transferFormat(String customContent, String dynamicContent) {
        int p2;
        String p1;
        String[] partArr;
        String part;
        int i;
        String[] split1Arr;
        customContent = customContent == null ? "" : customContent;
        dynamicContent = dynamicContent == null ? "" : dynamicContent;
        int modulesLength = (customContent.length() == 0 ? dynamicContent : customContent + "+" + dynamicContent).split("\\+").length;
        String[] lineModulesArr = new String[modulesLength];
        if (StringUtils.isNotBlank((CharSequence)customContent)) {
            split1Arr = customContent.split("\\+");
            for (i = 0; i < split1Arr.length; ++i) {
                part = split1Arr[i];
                partArr = part.split("\\_");
                p1 = partArr[0];
                p2 = Integer.parseInt(partArr[1]);
                lineModulesArr[p2 - 1] = p1;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicContent)) {
            split1Arr = dynamicContent.split("\\+");
            for (i = 0; i < split1Arr.length; ++i) {
                part = split1Arr[i];
                partArr = part.split("\\_");
                p1 = partArr[0];
                p2 = Integer.parseInt(partArr[1]);
                lineModulesArr[p2 - 1] = "{" + p1 + "}";
            }
        }
        String content = "";
        for (String lineModules : lineModulesArr) {
            content = content + lineModules + " ";
        }
        return content.trim();
    }
}

