/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.jindi.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.JinDiService;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.JinDiParkRequest;
import com.icetech.cloudcenter.domain.response.CheckOrderResponse;
import com.icetech.cloudcenter.domain.response.CheckStatusResponse;
import com.icetech.cloudcenter.domain.response.EnterRecordsResponse;
import com.icetech.cloudcenter.domain.response.ExitRecordsResponse;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class JinDiServiceImpl
implements JinDiService {
    private static final Logger log = LoggerFactory.getLogger(JinDiServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private MonthPlateDao monthPlateDao;
    @Autowired
    private OssService ossService;
    @Autowired
    private SendinfoDao sendInfoDao;

    public ObjectResponse<List<CheckStatusResponse>> batchCheckStatus(List<String> carNums, String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        ArrayList list = Lists.newArrayList();
        carNums.forEach(s -> {
            CheckStatusResponse checkStatusResponse = this.getCheckStatusResponse((String)s, park);
            list.add(checkStatusResponse);
        });
        return ObjectResponse.success((Object)list);
    }

    @Transactional
    public ObjectResponse parkingCars(JinDiParkRequest jinDiParkRequest) {
        Park park = (Park)this.parkService.findByParkCode(jinDiParkRequest.getParkCode()).getData();
        Date startTime = jinDiParkRequest.getStartTime();
        Date endTime = jinDiParkRequest.getEndTime();
        List carNum = jinDiParkRequest.getCars();
        ArrayList carNums = Lists.newArrayList();
        carNum.forEach(map -> {
            String num = (String)map.get("car_num");
            carNums.add(num);
        });
        MonthProduct monthProduct = this.monthProductDao.selectOneByParkId(park.getId());
        MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(park.getId(), jinDiParkRequest.getMainCar(), null);
        if (Objects.nonNull(monthInfo) && monthInfo.getCardStatus() == 1) {
            Date oldEndTime = monthInfo.getEndTime();
            if (startTime.getTime() < oldEndTime.getTime()) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_402);
            }
        }
        if (Objects.isNull(monthProduct)) {
            monthProduct = new MonthProduct();
            monthProduct.setName("\u81ea\u5b9a\u4e49\u6708\u5361\u4ea7\u54c1");
            monthProduct.setParkId(park.getId());
            monthProduct.setDuration(0);
            monthProduct.setCardType(1);
            monthProduct.setPaymoney(BigDecimal.ZERO);
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProduct.setCheckStatus(1);
            monthProduct.setBuyChannel(1);
            monthProduct.setStatus(1);
            this.monthProductDao.insert(monthProduct);
        } else {
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            this.monthProductDao.update(monthProduct);
        }
        MonthRecord monthRecord = new MonthRecord();
        if (monthInfo == null || DateTools.differentDays((Date)monthInfo.getEndTime(), (Date)startTime) > 1) {
            monthInfo = new MonthInfo();
            monthInfo.setParkId(park.getId());
            monthInfo.setCardProperty(1);
            monthInfo.setCardOwner("");
            monthInfo.setProductId(monthProduct.getId());
            monthInfo.setPlotCount(jinDiParkRequest.getCount().intValue());
            monthInfo.setCount(jinDiParkRequest.getCount().intValue());
            monthInfo.setMainPlate(jinDiParkRequest.getMainCar());
            monthInfo.setSaleMoney(jinDiParkRequest.getTotalPrice() == null ? new BigDecimal(0) : BigDecimal.valueOf(jinDiParkRequest.getTotalPrice()));
            monthInfo.setPayMoney(jinDiParkRequest.getTotalPrice() == null ? new BigDecimal(0) : BigDecimal.valueOf(jinDiParkRequest.getTotalPrice()));
            monthInfo.setPayMethod(JinDiParkRequest.convertJinDiPayMethod((Integer)jinDiParkRequest.getPaymentMethod()).intValue());
            monthInfo.setStartTime(startTime);
            monthInfo.setEndTime(endTime);
            monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            this.monthInfoDao.insert(monthInfo);
            for (String num : carNums) {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(num);
                this.monthPlateDao.insert(monthPlate);
            }
            log.info("[\u91d1\u5730\u65b0\u5f00\u6708\u5361] monthInfo:{}", (Object)JsonUtils.toString((Object)monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u65b0\u589e.getType());
        } else {
            monthInfo.setCardStatus(CardStatusConstants.\u751f\u6548\u4e2d.intValue());
            monthInfo.setEndTime(endTime);
            monthInfo.setCount(jinDiParkRequest.getCount().intValue());
            monthInfo.setMainPlate(jinDiParkRequest.getMainCar());
            monthInfo.setPlotCount(jinDiParkRequest.getCount().intValue());
            this.monthInfoDao.update(monthInfo);
            this.monthInfoDao.deleteMonthPlate(monthInfo.getId().longValue());
            for (String num : carNums) {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(num);
                this.monthPlateDao.insert(monthPlate);
            }
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u7eed\u8d39.getType());
            monthRecord.setIsOverdue(Integer.valueOf(0));
        }
        monthRecord.setProductId(monthProduct.getId());
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
        monthRecord.setCount(Integer.valueOf(monthInfo.getCount()));
        monthRecord.setPayMoney(jinDiParkRequest.getTotalPrice());
        monthRecord.setPayMethod(JinDiParkRequest.convertJinDiPayMethod((Integer)jinDiParkRequest.getPaymentMethod()));
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark(monthInfo.getRemark());
        StringJoiner pj = new StringJoiner(",");
        carNums.forEach(s -> pj.add((CharSequence)s));
        monthRecord.setPlateNum(pj.toString());
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        this.monthRecordDao.insert((Object)monthRecord);
        SendInfo sendInfo = new SendInfo(monthProduct.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
        this.sendInfoDao.insert((Object)sendInfo);
        return ObjectResponse.success();
    }

    @Transactional
    public ObjectResponse cancelParking(String parkCode, String carNum) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        MonthInfo monthInfo = this.monthInfoDao.selectByMainPlateNum(park.getId(), carNum);
        if (monthInfo == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        if (monthInfo.getCardStatus() == 3) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_405);
        }
        List monthRecords = this.monthRecordDao.selectByMonthId(monthInfo.getId().longValue());
        Boolean flag = Boolean.FALSE;
        Date endTime = null;
        if (!CollectionUtils.isEmpty((Collection)monthRecords) && monthRecords.size() > 1) {
            MonthRecord last = (MonthRecord)monthRecords.get(monthRecords.size() - 1);
            MonthRecord second = (MonthRecord)monthRecords.get(monthRecords.size() - 2);
            if (MonthRecord.CardOpertype.\u7eed\u8d39.getType().equals(last.getCardOpertype()) && second != null) {
                flag = Boolean.TRUE;
                endTime = second.getEndTime();
            }
        }
        MonthRecord monthRecord = new MonthRecord();
        if (flag.booleanValue()) {
            monthInfo.setEndTime(endTime);
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u4fee\u6539.getType());
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(endTime);
        } else {
            monthInfo.setCardStatus(CardStatusConstants.\u5df2\u9000\u8d39.intValue());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u9000\u5361.getType());
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(monthInfo.getEndTime());
        }
        List carNums = this.monthInfoDao.selectPlateNums(monthInfo.getId().longValue());
        this.monthInfoDao.update(monthInfo);
        monthRecord.setMonthId(monthInfo.getId());
        monthRecord.setProductId(monthInfo.getProductId());
        monthRecord.setParkId(park.getId());
        monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
        monthRecord.setCount(Integer.valueOf(monthInfo.getCount()));
        monthRecord.setPayMoney(Double.valueOf(monthInfo.getPayMoney() == null ? 0.0 : monthInfo.getPayMoney().doubleValue()));
        monthRecord.setPayMethod(JinDiParkRequest.convertJinDiPayMethod((Integer)monthInfo.getPayMethod()));
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        StringJoiner pj = new StringJoiner(",");
        carNums.forEach(s -> pj.add((CharSequence)s));
        monthRecord.setIsOverdue(Integer.valueOf(0));
        monthRecord.setPlateNum(pj.toString());
        monthRecord.setRemark(monthInfo.getRemark());
        this.monthRecordDao.insert((Object)monthRecord);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
        this.sendInfoDao.insert((Object)sendInfo);
        return ObjectResponse.success();
    }

    @Transactional
    public ObjectResponse updateCarsInfo(List<Map> carNums, String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        carNums.forEach(map -> {
            String current_num = (String)map.get("current_num");
            String changed_num = (String)map.get("changed_num");
            MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(park.getId(), current_num, null);
            MonthPlate monthPlate = this.monthPlateDao.selectByMonthIdAndPlate(monthInfo.getId().longValue(), current_num);
            monthPlate.setPlateNum(changed_num);
            monthPlate.setParkId(monthInfo.getParkId());
            this.monthPlateDao.update(monthPlate);
            List carNum = this.monthInfoDao.selectPlateNums(monthInfo.getId().longValue());
            MonthRecord monthRecord = new MonthRecord();
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.\u4fee\u6539.getType());
            monthRecord.setIsOverdue(Integer.valueOf(0));
            monthRecord.setProductId(monthInfo.getProductId());
            monthRecord.setParkId(park.getId());
            monthRecord.setCardProperty(Integer.valueOf(monthInfo.getCardProperty()));
            monthRecord.setCardOwner(monthInfo.getCardOwner());
            monthRecord.setPhone(monthInfo.getPhone());
            monthRecord.setPlotCount(Integer.valueOf(monthInfo.getPlotCount()));
            monthRecord.setCount(Integer.valueOf(monthInfo.getCount()));
            monthRecord.setPayMoney(Double.valueOf(monthInfo.getPayMoney() == null ? 0.0 : monthInfo.getPayMoney().doubleValue()));
            monthRecord.setPayMethod(JinDiParkRequest.convertJinDiPayMethod((Integer)monthInfo.getPayMethod()));
            monthRecord.setOperAccount(monthInfo.getOperAccount());
            monthRecord.setRemark(monthInfo.getRemark());
            StringJoiner pj = new StringJoiner(",");
            carNum.forEach(s -> pj.add((CharSequence)s));
            monthRecord.setPlateNum(pj.toString());
            monthRecord.setCreateTime(new Date());
            monthRecord.setUpdateTime(new Date());
            this.monthRecordDao.insert((Object)monthRecord);
            SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.\u6708\u5361.getServiceType());
            this.sendInfoDao.insert((Object)sendInfo);
        });
        return ObjectResponse.success();
    }

    public ObjectResponse<CheckOrderResponse> checkStatus(String carNum, String parkCode) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        CheckOrderResponse checkStatusResponse = this.getCheckOrderResponse(carNum, park);
        return ObjectResponse.success((Object)checkStatusResponse);
    }

    @DS_SLAVE
    @SentinelResource(value="JinDiService.getEnterList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Page<EnterRecordsResponse>> getEnterList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        com.baomidou.mybatisplus.extension.plugins.pagination.Page orderInfoPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)pageNum.intValue(), (long)pageSize.intValue());
        OrderInfo orderInfoParam = new OrderInfo();
        orderInfoParam.setParkId(park.getId());
        orderInfoParam.setServiceStatus(Integer.valueOf(1));
        orderInfoParam.setEnterTime(startDate == null ? null : Long.valueOf(startDate.getTime() / 1000L));
        orderInfoParam.setExitTime(endDate == null ? null : Long.valueOf(endDate.getTime() / 1000L));
        orderInfoPage = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.orderInfoDao.selectPage((IPage)orderInfoPage, (Wrapper)Wrappers.query((Object)orderInfoParam));
        List orderInfos = orderInfoPage.getRecords();
        PageInfo pageInfo = new PageInfo(orderInfos);
        List enterRecordsResponses = orderInfos.stream().map(orderInfo -> {
            EnterRecordsResponse enterRecordsResponse = new EnterRecordsResponse();
            enterRecordsResponse.setRecordId(String.valueOf(orderInfo.getId()));
            enterRecordsResponse.setCarNum(orderInfo.getPlateNum());
            enterRecordsResponse.setEnterTime(DateTools.getFormat((long)(orderInfo.getEnterTime() * 1000L)));
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            enterRecordsResponse.setEnterUrl(StringUtils.isEmpty((CharSequence)carInfo.getEnterImage()) ? "" : this.ossService.getImageUrl(carInfo.getEnterImage()));
            enterRecordsResponse.setCarType(ExitRecordsResponse.convertLocalCarType((Integer)orderInfo.getCarType()));
            return enterRecordsResponse;
        }).collect(Collectors.toList());
        return ObjectResponse.success((Object)Page.instance((int)pageInfo.getPages(), (long)pageInfo.getTotal(), enterRecordsResponses));
    }

    @DS_SLAVE
    @SentinelResource(value="JinDiService.getExitList", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public ObjectResponse<Page<ExitRecordsResponse>> getExitList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate) {
        Park park = (Park)this.parkService.findByParkCode(parkCode).getData();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List orderInfos = this.orderInfoDao.selectExitRecords(park.getId().toString(), Long.valueOf(startDate.getTime() / 1000L), Long.valueOf(endDate.getTime() / 1000L), null, null, null, null, null, null, null, null, null, null);
        PageInfo pageInfo = new PageInfo(orderInfos);
        List exitRecordsResponses = orderInfos.stream().map(orderInfo -> {
            List orderPays = this.orderPayDao.selectByOrderNum(orderInfo.getOrderNum());
            OrderCarInfo carInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            ExitRecordsResponse exitRecordsResponse = new ExitRecordsResponse();
            exitRecordsResponse.setRecordId(String.valueOf(orderInfo.getId()));
            exitRecordsResponse.setCarNum(orderInfo.getPlateNum());
            exitRecordsResponse.setEnterTime(DateTools.getFormat((long)(orderInfo.getEnterTime() * 1000L)));
            exitRecordsResponse.setLeaveTime(DateTools.getFormat((long)(orderInfo.getExitTime() * 1000L)));
            exitRecordsResponse.setCarType(ExitRecordsResponse.convertLocalCarType((Integer)orderInfo.getType()));
            if (carInfo != null) {
                if (StringUtils.isNotBlank((CharSequence)carInfo.getEnterImage())) {
                    exitRecordsResponse.setEnterUrl(this.ossService.getImageUrl(carInfo.getEnterImage()));
                }
                if (StringUtils.isNotBlank((CharSequence)carInfo.getExitImage())) {
                    exitRecordsResponse.setLeaveUrl(this.ossService.getImageUrl(carInfo.getExitImage()));
                }
            }
            exitRecordsResponse.setPayableAmount(orderInfo.getTotalPrice());
            exitRecordsResponse.setPaidAmount(orderInfo.getPaidPrice());
            if (!CollectionUtils.isEmpty((Collection)orderPays)) {
                OrderPay orderPay = (OrderPay)orderPays.get(0);
                exitRecordsResponse.setPayMethod(Integer.valueOf(Objects.nonNull(orderPay) ? ExitRecordsResponse.convertLocalPayMethod((Integer)orderPay.getPayWay()) : 10));
            }
            return exitRecordsResponse;
        }).collect(Collectors.toList());
        return ObjectResponse.success((Object)Page.instance((int)pageInfo.getPages(), (long)pageInfo.getTotal(), exitRecordsResponses));
    }

    private CheckStatusResponse getCheckStatusResponse(String carNum, Park park) {
        CheckStatusResponse checkStatusResponse = new CheckStatusResponse();
        MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(park.getId(), carNum, null);
        if (Objects.isNull(monthInfo)) {
            checkStatusResponse.setStatus(Integer.valueOf(1));
            checkStatusResponse.setCarNum(carNum);
        } else if (monthInfo.getCardStatus() == 1) {
            checkStatusResponse.setStatus(Integer.valueOf(2));
            checkStatusResponse.setCarNum(carNum);
            checkStatusResponse.setStartTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getStartTime()));
            checkStatusResponse.setEndTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getEndTime()));
        } else {
            checkStatusResponse.setStatus(Integer.valueOf(3));
            checkStatusResponse.setCarNum(carNum);
            checkStatusResponse.setStartTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getStartTime()));
            checkStatusResponse.setEndTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getEndTime()));
        }
        return checkStatusResponse;
    }

    private CheckOrderResponse getCheckOrderResponse(String carNum, Park park) {
        CheckOrderResponse checkOrderResponse = new CheckOrderResponse();
        MonthInfo monthInfo = this.monthInfoDao.selectByPlateNum(park.getId(), carNum, null);
        if (Objects.nonNull(monthInfo)) {
            ArrayList list = new ArrayList();
            List plateNums = this.monthInfoDao.selectPlateNums(monthInfo.getId().longValue());
            plateNums.forEach(plateNum -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("car_num", (String)plateNum);
                list.add(map);
            });
            checkOrderResponse.setCars(list);
            checkOrderResponse.setCount(Integer.valueOf(monthInfo.getCount()));
        }
        if (Objects.isNull(monthInfo) || monthInfo.getCardStatus() == 3) {
            checkOrderResponse.setStatus(Integer.valueOf(1));
            checkOrderResponse.setCount(Integer.valueOf(0));
            checkOrderResponse.setMainCar(carNum);
        } else if (monthInfo.getCardStatus() == 1) {
            checkOrderResponse.setStatus(Integer.valueOf(2));
            checkOrderResponse.setMainCar(StringUtils.isEmpty((CharSequence)monthInfo.getMainPlate()) ? carNum : monthInfo.getMainPlate());
            checkOrderResponse.setStartTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getStartTime()));
            checkOrderResponse.setEndTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getEndTime()));
        } else {
            checkOrderResponse.setStatus(Integer.valueOf(3));
            checkOrderResponse.setMainCar(carNum);
            checkOrderResponse.setStartTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getStartTime()));
            checkOrderResponse.setEndTime(DateTools.getFormat((String)"yyyy-MM-dd", (Date)monthInfo.getEndTime()));
        }
        return checkOrderResponse;
    }
}

