/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.invoice;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.icetech.cloudcenter.api.invoice.InvoiceBlueService;
import com.icetech.cloudcenter.api.invoice.InvoiceMerchantService;
import com.icetech.cloudcenter.api.invoice.InvoiceTradeService;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.dao.invoice.InvoiceMerchantDao;
import com.icetech.park.domain.entity.invoice.InvoiceMerchant;
import com.icetech.park.domain.entity.invoice.InvoiceTrade;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceMerchantServiceImpl
implements InvoiceMerchantService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceMerchantServiceImpl.class);
    @Autowired
    private InvoiceMerchantDao invoiceMerchantDao;
    @Autowired
    private InvoiceBlueService invoiceBlueService;
    @Autowired
    private InvoiceTradeService invoiceTradeService;

    public int deleteByPrimaryKey(Integer id) {
        return this.invoiceMerchantDao.deleteByPrimaryKey(id);
    }

    public InvoiceMerchant insert(InvoiceMerchant record) {
        int insert = this.invoiceMerchantDao.insert(record);
        return record;
    }

    public InvoiceMerchant selectByPrimaryKey(Integer id) {
        return this.invoiceMerchantDao.selectByPrimaryKey(id);
    }

    public InvoiceMerchant selectByParkId(Long parkId) {
        return this.invoiceMerchantDao.selectByParkId(parkId);
    }

    public int updateByTaxpayerInfo(InvoiceMerchant record) {
        return this.invoiceMerchantDao.updateByTaxpayerInfo(record);
    }

    public InvoiceMerchant selectByTaxnum(String taxpayerNum) {
        return this.invoiceMerchantDao.selectByTaxnum(taxpayerNum);
    }

    public ObjectResponse<List<InvoiceRecordResponse>> getInvoiceRecords(Integer mpUserId, BaseQueryRequest baseQueryRequest, Integer source) {
        try (Page page = PageHelper.startPage((int)baseQueryRequest.getPageNo(), (int)baseQueryRequest.getPageSize(), (boolean)baseQueryRequest.isCount());){
            List invoiceBlues = this.invoiceBlueService.selectByMpUserId(mpUserId, baseQueryRequest.getStartTime(), baseQueryRequest.getEndTime(), source);
            ObjectResponse objectResponse = ObjectResponse.success((Object)invoiceBlues);
            return objectResponse;
        }
    }

    public ObjectResponse<InvoiceDetailResponse> getInvoiceDetail(String orderId) {
        InvoiceDetailResponse invoiceDetailResponse = this.invoiceBlueService.selectInvoiceDetailByOrderId(orderId);
        if (Objects.isNull(invoiceDetailResponse)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        List invoiceTrades = this.invoiceTradeService.selectByOrderId(invoiceDetailResponse.getOrderId());
        List strings = invoiceTrades.stream().map(InvoiceTrade::getTradeNo).collect(Collectors.toList());
        String join = StringUtils.join(strings, (String)",");
        invoiceDetailResponse.setTradeNo(join);
        return ObjectResponse.success((Object)invoiceDetailResponse);
    }
}

