/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl.manage;

import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.QueryFeeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.vo.UpdateFeeVo;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.pnc.impl.ChannelDataServiceImpl;
import com.icetech.park.service.down.pnc.impl.ModifyFeeServiceImpl;
import com.icetech.park.service.down.pnc.impl.PncNoplateExitServiceImpl;
import com.icetech.park.service.down.pnc.impl.PncRemoteSwitchServiceImpl;
import com.icetech.park.service.down.pnc.impl.ReqEnterServiceImpl;
import com.icetech.park.service.down.pnc.impl.ShowAndSayServiceImpl;
import com.icetech.park.service.impl.base.ManageServiceBase;
import com.icetech.park.service.impl.manage.CloudManageService;
import com.icetech.park.service.impl.manage.P2CloudManageImpl;
import com.icetech.third.utils.RedisUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PnCloudManageImpl
extends ManageServiceBase
implements CloudManageService {
    private static final Logger log = LoggerFactory.getLogger(PnCloudManageImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private PncNoplateExitServiceImpl pncNoplateExitService;
    @Autowired
    private ModifyFeeServiceImpl modifyFeeServiceImpl;
    @Autowired
    private PncRemoteSwitchServiceImpl pncRemoteSwitchService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private P2CloudManageImpl p2CloudManage;
    @Autowired
    private ShowAndSayServiceImpl showAndSayService;
    @Autowired
    private ChannelDataServiceImpl channelDataService;
    @Autowired
    private ReqEnterServiceImpl reqEnterService;

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromRedis(String parkCode, String aisleCode, Integer type, String topic) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse deviceByChannel = this.parkDeviceService.getDeviceByChannel(park.getId(), aisleCode, Integer.valueOf(1));
        if (!ObjectResponse.isSuccess((Response)deviceByChannel)) {
            return ObjectResponse.failed((String)"3003", (String)"\u8be5\u901a\u9053\u5c1a\u672a\u6dfb\u52a0\u8bc6\u522b\u76f8\u673a");
        }
        ObjectResponse<Void> objectResponse = this.channelDataService.execute(aisleCode, parkCode, park.getKey(), park.getId(), 1, topic, type);
        return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
    }

    @Override
    public ObjectResponse<EnterCarInfoResponse> getCarEnterTraceFromRedis(String parkCode, String aisleCode) {
        CarEnterRequest enterTrace = this.cacheHandle.getEntrance(parkCode, aisleCode);
        if (Objects.isNull(enterTrace)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)this.getEntranceCarInfoResponse(enterTrace));
    }

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromCamera(String parkCode, String aisleCode, Integer type, String topic) {
        log.info("[\u8f6f\u89e6\u53d1\u8c03\u7528] parkcode[{}], aisleCode[{}]", (Object)parkCode, (Object)aisleCode);
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse<Void> objectResponse = this.channelDataService.execute(aisleCode, parkCode, park.getKey(), park.getId(), 2, topic, type);
        return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
    }

    @Override
    public ObjectResponse<String> getCarInfoFromCameraAsync(String parkCode, String version, String sn, String aisleCode, Integer type) {
        log.info("[\u8f6f\u89e6\u53d1\u8c03\u7528] parkcode[{}], aisleCode[{}]", (Object)parkCode, (Object)aisleCode);
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse<Void> objectResponse = this.channelDataService.execute(aisleCode, parkCode, park.getKey(), park.getId(), 2, AsyncNotifyInterface.getTopic(), type);
        if (objectResponse.getCode().equals("12002")) {
            return ObjectResponse.success((Object)objectResponse.getMsg());
        }
        return ObjectResponse.failed();
    }

    @Override
    public ObjectResponse<Object> getCarExitInfoFromCacheByOrderNum(String parkCode, String orderNum) {
        ObjectResponse infoObjectResponse = this.orderService.findByOrderNum(orderNum);
        ObjectResponse.notError((Response)infoObjectResponse);
        String key = "PNC_EXIT_ORDER_PAY_" + ((OrderInfo)infoObjectResponse.getData()).getParkId() + "_" + ((OrderInfo)infoObjectResponse.getData()).getLocalOrderNum();
        ExitPayCautionRequest exitPayCautionRequest = (ExitPayCautionRequest)this.redisUtils.get(key, ExitPayCautionRequest.class);
        return exitPayCautionRequest == null ? ObjectResponse.failed((String)"404") : ObjectResponse.success((Object)exitPayCautionRequest);
    }

    @Override
    public ObjectResponse<Void> allowEnter(DataEnterRequest enterRequest) {
        return this.reqEnterService.execute(enterRequest);
    }

    @Override
    public ObjectResponse<Void> allowExit(DataExitRequest exitRequest) {
        String parkCode = exitRequest.getParkCode();
        NoplateExitRequest noplateExitRequest = new NoplateExitRequest();
        noplateExitRequest.setPlateNum(exitRequest.getPlateNum());
        noplateExitRequest.setExitTime(Long.valueOf(exitRequest.getExitTime().getTime() / 1000L));
        noplateExitRequest.setChannelId(exitRequest.getAisleCode());
        noplateExitRequest.setParkCode(parkCode);
        noplateExitRequest.setCarType(exitRequest.getCarType());
        noplateExitRequest.setCarDesc(exitRequest.getSpecialCar());
        noplateExitRequest.setTopic(exitRequest.getTopic());
        noplateExitRequest.setExitWay(exitRequest.getExitWay());
        noplateExitRequest.setOperAccount(exitRequest.getOperAccount());
        noplateExitRequest.setExitTerminal(exitRequest.getExitTerminal());
        return this.pncNoplateExitService.noplateExit(noplateExitRequest);
    }

    @Override
    public ObjectResponse<PullfeeResponse> pullFee(PullfeeRequest pullfeeRequest) {
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(pullfeeRequest.getOrderNum());
        queryOrderFeeRequest.setPlateNum(pullfeeRequest.getPlateNum());
        queryOrderFeeRequest.setParkCode(pullfeeRequest.getParkCode());
        queryOrderFeeRequest.setChannelId(pullfeeRequest.getAisleCode());
        queryOrderFeeRequest.setCarType(pullfeeRequest.getCarType());
        queryOrderFeeRequest.setTopic(pullfeeRequest.getTopic());
        queryOrderFeeRequest.setExtraInfo(QueryFeeRequest.ExtraInfoEnum.PULL_FEE.val);
        queryOrderFeeRequest.setWithNotPay(Boolean.valueOf(true));
        String parkCode = pullfeeRequest.getParkCode();
        String channelId = pullfeeRequest.getAisleCode();
        if (NumberUtils.toPrimitive((Integer)pullfeeRequest.getSource()) == 1) {
            return this.p2CloudManage.p2cPullFee(pullfeeRequest, queryOrderFeeRequest, parkCode, channelId);
        }
        ObjectResponse objectResponse = this.orderService.pncQueryFee(queryOrderFeeRequest);
        ObjectResponse response = new ObjectResponse();
        response.setCode(objectResponse.getCode());
        response.setMsg(objectResponse.getMsg());
        response.setTraceId(objectResponse.getTraceId());
        return response;
    }

    @Override
    public ObjectResponse<Void> callVoiceReport(VoiceReportRequest voiceReportRequest) {
        return this.showAndSayService.execute(voiceReportRequest);
    }

    @Override
    public ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest openBrakeRequest) {
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setParkCode(openBrakeRequest.getParkCode());
        remoteSwitchRequest.setChannelId(openBrakeRequest.getAisleCode());
        remoteSwitchRequest.setSwitchType(Integer.valueOf(1));
        remoteSwitchRequest.setSequenceId(UUIDTools.getUuid());
        remoteSwitchRequest.setInoutEvent(openBrakeRequest.getExitWay());
        remoteSwitchRequest.setOperAccount(openBrakeRequest.getOperAccount());
        remoteSwitchRequest.setExTerminal(openBrakeRequest.getExitTerminal());
        remoteSwitchRequest.setPlateNum(openBrakeRequest.getPlateNum());
        remoteSwitchRequest.setReasonType(openBrakeRequest.getReasonType());
        remoteSwitchRequest.setRemark(openBrakeRequest.getRemark());
        return this.pncRemoteSwitchService.remoteSwitch(remoteSwitchRequest, openBrakeRequest.getTopic(), RemoteSwitchRequest.ExtraInfo.builder().biz(RemoteSwitchRequest.ExtraInfoEnum.OPEN.val).requestVO((Object)openBrakeRequest).build());
    }

    @Override
    public ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest closeBrakeRequest) {
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setParkCode(closeBrakeRequest.getParkCode());
        remoteSwitchRequest.setChannelId(closeBrakeRequest.getAisleCode());
        remoteSwitchRequest.setSwitchType(Integer.valueOf(2));
        remoteSwitchRequest.setSequenceId(UUIDTools.getUuid());
        return this.pncRemoteSwitchService.remoteSwitch(remoteSwitchRequest, closeBrakeRequest.getTopic(), RemoteSwitchRequest.ExtraInfo.builder().biz(RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val).requestVO((Object)closeBrakeRequest).build());
    }

    @Override
    public ObjectResponse<Void> modifyCacheFee(ModifyFeeRequest modifyFeeRequest) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(modifyFeeRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u7f16\u53f7\u6709\u8bef");
        }
        UpdateFeeVo updateFeeVo = new UpdateFeeVo();
        updateFeeVo.setParkId(((Park)byParkCode.getData()).getId());
        updateFeeVo.setChannelId(modifyFeeRequest.getAisleCode());
        updateFeeVo.setOrderNum(modifyFeeRequest.getOrderNum());
        updateFeeVo.setPlateNum(modifyFeeRequest.getPlateNum());
        updateFeeVo.setNewUnpayPrice(modifyFeeRequest.getUpFee());
        updateFeeVo.setTopic(modifyFeeRequest.getTopic());
        return this.modifyFeeServiceImpl.execute(updateFeeVo);
    }

    @Override
    public ObjectResponse<Void> applyNoPlateEnter(ApplyNoPlateEnterRequest applyNoPlateEnterRequest) {
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> fleetMode(String parkCode, Long parkId, String sn, Integer enable) {
        return ObjectResponse.failed((String)"1000", (String)"\u7aef\u7f51\u4e91\u6a21\u5f0f\u4e0d\u652f\u6301\u8f66\u961f\u6a21\u5f0f");
    }
}

