/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl.manage;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.fee.QueryOrderFeeService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.pay.NoplateRecordStatus;
import com.icetech.cloudcenter.domain.pay.NoplateRecordType;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.QueryFeeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.p2c.FleetModeRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.catched.NoplateRecordDao;
import com.icetech.park.domain.entity.catched.NoplateRecord;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.FleetModeServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.impl.manage.CloudManageCommon;
import com.icetech.park.service.impl.manage.CloudManageService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class P2CloudManageImpl
extends CloudManageCommon
implements CloudManageService {
    private static final Logger log = LoggerFactory.getLogger(P2CloudManageImpl.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private QueryOrderFeeService queryOrderFeeService;
    @Autowired
    private NoplateRecordDao noplateRecordDao;
    @Autowired
    private FleetModeServiceImpl fleetModeService;

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromRedis(String parkCode, String aisleCode, Integer type, String topic) {
        EnterCarInfoResponse enexCarInfoBaseResponse;
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        ObjectResponse deviceByChannel = this.parkDeviceService.getDeviceByChannel(parkId, aisleCode, Integer.valueOf(1));
        if (!ObjectResponse.isSuccess((Response)deviceByChannel)) {
            return ObjectResponse.failed((String)"3003", (String)"\u8be5\u901a\u9053\u5c1a\u672a\u6dfb\u52a0\u8bc6\u522b\u76f8\u673a");
        }
        if (type.equals(EnexTypeEnum.\u5165\u573a.getType())) {
            CarEnterRequest entrance = this.cacheHandle.getEntrance(parkCode, aisleCode);
            if (entrance == null) {
                ParkDevice parkDevice = (ParkDevice)((List)deviceByChannel.getData()).get(0);
                ObjectResponse<Void> objectResponse = this.getCurrChannelInfo(parkCode, aisleCode, parkDevice.getSerialNumber(), parkDevice.getProtocolVer(), type, topic, parkId);
                return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
            }
            enexCarInfoBaseResponse = this.getEntranceCarInfoResponse(entrance);
        } else {
            CarExitRequest exit = this.cacheHandle.getExit(parkCode, aisleCode);
            if (exit == null) {
                ParkDevice parkDevice = (ParkDevice)((List)deviceByChannel.getData()).get(0);
                ObjectResponse<Void> objectResponse = this.getCurrChannelInfo(parkCode, aisleCode, parkDevice.getSerialNumber(), parkDevice.getProtocolVer(), type, topic, parkId);
                return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
            }
            enexCarInfoBaseResponse = this.getExitCarInfoResponse(parkId, parkCode, exit);
        }
        enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.\u7aef\u4e91.getType());
        return ObjectResponse.success((Object)enexCarInfoBaseResponse);
    }

    @Override
    public ObjectResponse<EnterCarInfoResponse> getCarEnterTraceFromRedis(String parkCode, String aisleCode) {
        CarEnterRequest enterTrace = this.cacheHandle.getEntrance(parkCode, aisleCode);
        if (Objects.isNull(enterTrace)) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)this.getEntranceCarInfoResponse(enterTrace));
    }

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromCamera(String parkCode, String aisleCode, Integer type, String topic) {
        log.info("[\u8f6f\u89e6\u53d1\u8c03\u7528] parkCode[{}], aisleCode[{}]", (Object)parkCode, (Object)aisleCode);
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        ObjectResponse deviceByChannel = this.parkDeviceService.getDeviceByChannel(parkId, aisleCode, Integer.valueOf(1));
        if (!ObjectResponse.isSuccess((Response)deviceByChannel)) {
            return ObjectResponse.failed((String)"3003", (String)"\u8be5\u901a\u9053\u5c1a\u672a\u6dfb\u52a0\u8bc6\u522b\u76f8\u673a");
        }
        ParkDevice parkDevice = (ParkDevice)((List)deviceByChannel.getData()).get(0);
        ObjectResponse<Void> objectResponse = this.getCurrChannelInfo(parkCode, aisleCode, parkDevice.getSerialNumber(), parkDevice.getProtocolVer(), type, topic, parkId);
        return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
    }

    @Override
    public ObjectResponse<String> getCarInfoFromCameraAsync(String parkCode, String version, String sn, String aisleCode, Integer type) {
        ObjectResponse<String> objectResponse;
        log.info("[\u8f6f\u89e6\u53d1\u8c03\u7528] parkCode[{}], aisleCode[{}]", (Object)parkCode, (Object)aisleCode);
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        if (StringUtils.isNotEmpty((CharSequence)version) && P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c13.getIndex() && this.cacheHandle.judgeTakePicturePrivilege(sn)) {
            log.info("[\u8c03\u7528\u65b0\u7248\u672c\u7684\u56fe\u7247\u6293\u62cd\u63a5\u53e3] {},{},{},{}", new Object[]{parkCode, version, sn, aisleCode});
            objectResponse = this.takePicturesService.execute(parkId, parkCode, sn);
        } else {
            objectResponse = this.softTriggerService.executeAsync(parkId, parkCode, aisleCode);
        }
        return objectResponse;
    }

    @Override
    public ObjectResponse<Object> getCarExitInfoFromCacheByOrderNum(String parkCode, String orderNum) {
        CarExitRequest exitRequest = this.cacheHandle.getExitByOrderNum(parkCode, orderNum);
        return exitRequest == null ? ObjectResponse.failed((String)"404") : ObjectResponse.success((Object)exitRequest);
    }

    @Override
    public ObjectResponse<Void> allowEnter(DataEnterRequest enterRequest) {
        return this.allowEnter(this.remoteSwitchService, enterRequest);
    }

    @Override
    public ObjectResponse<Void> allowExit(DataExitRequest exitRequest) {
        String serialNumber;
        String parkCode = exitRequest.getParkCode();
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        String aisleCode = exitRequest.getAisleCode();
        String plateNum = exitRequest.getPlateNum();
        if (exitRequest.isOffLine()) {
            return this.exit(this.softTriggerService, exitRequest, parkCode, aisleCode, parkId, plateNum, exitRequest.getTopic());
        }
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, aisleCode);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"3003");
        }
        String finalSerialNumber = serialNumber;
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            ObjectResponse<RemoteSwitchResponse> objectResponse = this.remoteSwitchService.execute(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, exitRequest.getParkCode(), finalSerialNumber, exitRequest.getPlateNum());
            if (ObjectResponse.isSuccess(objectResponse) && ((RemoteSwitchResponse)objectResponse.getData()).getResult() != 1) {
                log.info("[\u4e8c\u6b21\u4e0b\u53d1\u5f00\u95f8] \u53c2\u6570[{}]", (Object)exitRequest);
                RemoteSwitchRequest request = new RemoteSwitchRequest();
                request.setSwitchType(SwitchTypeEnum.\u5f00\u95f8.getType());
                request.setSequenceId(Integer.valueOf(RandomUtils.nextInt((int)100000, (int)1000000)));
                request.setPlateNum(exitRequest.getPlateNum());
                long executeTime = DateTools.unixTimestamp();
                Long cameraExecuteTime = ((RemoteSwitchResponse)objectResponse.getData()).getExecuteTime();
                if (cameraExecuteTime != null) {
                    executeTime = cameraExecuteTime.toString().length() >= 13 ? cameraExecuteTime / 1000L + 1L : cameraExecuteTime + 1L;
                }
                request.setTime(Long.valueOf(executeTime));
                this.remoteSwitchService.secondOpen(request, parkId, exitRequest.getParkCode(), finalSerialNumber);
            }
        }));
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("parkTime", (exitRequest.getExitTime().getTime() - exitRequest.getEnterTime().getTime()) / 1000L);
        paraMap.put("orderNum", exitRequest.getOrderNum());
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, aisleCode);
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        this.downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, exitRequest.getType(), FlowCondition.ResultCode.\u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5, paraMap, serialNumber, 2, aisleCode, false);
        return this.exit(this.softTriggerService, exitRequest, parkCode, aisleCode, parkId, plateNum, exitRequest.getTopic());
    }

    @Override
    public ObjectResponse<PullfeeResponse> pullFee(PullfeeRequest pullfeeRequest) {
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(pullfeeRequest.getOrderNum());
        queryOrderFeeRequest.setPlateNum(pullfeeRequest.getPlateNum());
        queryOrderFeeRequest.setParkCode(pullfeeRequest.getParkCode());
        queryOrderFeeRequest.setChannelId(pullfeeRequest.getAisleCode());
        queryOrderFeeRequest.setCarType(pullfeeRequest.getCarType());
        queryOrderFeeRequest.setTopic(pullfeeRequest.getTopic());
        queryOrderFeeRequest.setExtraInfo(QueryFeeRequest.ExtraInfoEnum.PULL_FEE.val);
        queryOrderFeeRequest.setWithNotPay(Boolean.valueOf(true));
        String parkCode = pullfeeRequest.getParkCode();
        String channelId = pullfeeRequest.getAisleCode();
        return this.p2cPullFee(pullfeeRequest, queryOrderFeeRequest, parkCode, channelId);
    }

    @Override
    public ObjectResponse<Void> callVoiceReport(VoiceReportRequest voiceReportRequest) {
        ObjectResponse objectResponse = this.queryOrderFeeService.updateAndGetChannelFee(voiceReportRequest.getParkCode(), voiceReportRequest.getAisleCode(), voiceReportRequest.getPlateNum(), voiceReportRequest.getOrderNums());
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
        }
        return this.callVoiceReport(this.softTriggerService, voiceReportRequest);
    }

    @Override
    public ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest openBrakeRequest) {
        String deviceNo;
        String parkCode = openBrakeRequest.getParkCode();
        try {
            deviceNo = this.cacheHandle.getSerialNumber(parkCode, openBrakeRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            log.info(e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        return this.remoteSwitchService.execute(SwitchTypeEnum.\u5f00\u95f8.getType(), parkCode, deviceNo, openBrakeRequest.getPlateNum(), openBrakeRequest.getTopic(), RemoteSwitchRequest.ExtraInfo.builder().biz(RemoteSwitchRequest.ExtraInfoEnum.OPEN.val).requestVO((Object)openBrakeRequest).build());
    }

    @Override
    public ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest closeBrakeRequest) {
        String deviceNo;
        String parkCode = closeBrakeRequest.getParkCode();
        try {
            deviceNo = this.cacheHandle.getSerialNumber(parkCode, closeBrakeRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            log.info(e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        return this.remoteSwitchService.execute(SwitchTypeEnum.\u5173\u95f8.getType(), parkCode, deviceNo, closeBrakeRequest.getPlateNum(), closeBrakeRequest.getTopic(), RemoteSwitchRequest.ExtraInfo.builder().biz(RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val).requestVO((Object)closeBrakeRequest).build());
    }

    @Override
    public ObjectResponse<Void> modifyCacheFee(ModifyFeeRequest modifyFeeRequest) {
        QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(modifyFeeRequest.getParkCode(), modifyFeeRequest.getAisleCode());
        if (channelFee == null) {
            return ObjectResponse.failed((String)"404");
        }
        String totalAmount = channelFee.getTotalAmount();
        String unPayPrice = channelFee.getUnpayPrice();
        BigDecimal subtract = new BigDecimal(unPayPrice).subtract(new BigDecimal(modifyFeeRequest.getUpFee()));
        channelFee.setTotalAmount(new BigDecimal(totalAmount).subtract(subtract).toString());
        channelFee.setUnpayPrice(modifyFeeRequest.getUpFee());
        channelFee.setSumPrice(null);
        this.cacheHandle.setChannelFee(modifyFeeRequest.getParkCode(), modifyFeeRequest.getAisleCode(), channelFee);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> applyNoPlateEnter(ApplyNoPlateEnterRequest applyNoPlateEnterRequest) {
        String parkCode = applyNoPlateEnterRequest.getParkCode();
        String plateNum = applyNoPlateEnterRequest.getPlateNum();
        String channelCode = applyNoPlateEnterRequest.getChannelCode();
        String unionId = applyNoPlateEnterRequest.getUnionId();
        Integer isMaster = 1;
        ObjectResponse channelInfo = this.parkService.getInOutDeviceByCode(applyNoPlateEnterRequest.getParkId(), channelCode);
        if (ObjectResponse.isSuccess((Response)channelInfo)) {
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)channelInfo.getData();
            isMaster = parkInoutdevice.getIsMaster();
        }
        DataEnterRequest enterRequest = new DataEnterRequest();
        BeanUtils.copyProperties((Object)applyNoPlateEnterRequest, (Object)enterRequest);
        enterRequest.setAisleCode(channelCode);
        enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
        enterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        enterRequest.setTopic(AsyncNotifyInterface.getTopic());
        enterRequest.setEnterWay(Integer.valueOf(3));
        ObjectResponse<Void> objectResponse = this.allowEnter(this.remoteSwitchService, enterRequest);
        if (ObjectResponse.isSuccess(objectResponse)) {
            NoplateRecord noplateRecord = new NoplateRecord();
            noplateRecord.setUnionId(unionId);
            noplateRecord.setType(NoplateRecordType.\u65e0\u724c\u8f66.getType());
            noplateRecord.setStatus(NoplateRecordStatus.\u5df2\u5165\u573a.getStatus());
            noplateRecord.setParkCode(parkCode);
            noplateRecord.setPlateNum(plateNum);
            noplateRecord.setEnterChannelId(channelCode);
            noplateRecord.setCreateTime(new Date());
            noplateRecord.setIsMaster(isMaster);
            this.noplateRecordDao.insert(noplateRecord);
        }
        return objectResponse;
    }

    @Override
    public ObjectResponse<Void> fleetMode(String parkCode, Long parkId, String sn, Integer enable) {
        return this.fleetModeService.send(FleetModeRequest.builder().enable(enable).build(), sn, parkId);
    }

    private ObjectResponse<Void> getCurrChannelInfo(String parkCode, String aisleCode, String sn, String version, Integer type, String topic, Long parkId) {
        ObjectResponse<Void> objectResponse;
        if (StringUtils.isNotEmpty((CharSequence)version) && P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c13.getIndex() && this.cacheHandle.judgeTakePicturePrivilege(sn)) {
            log.info("[\u8c03\u7528\u65b0\u7248\u672c\u7684\u56fe\u7247\u6293\u62cd\u63a5\u53e3] {},{},{},{}", new Object[]{parkCode, version, sn, aisleCode});
            objectResponse = this.takePicturesService.executeAsync(parkId, parkCode, sn, aisleCode, type, topic);
        } else {
            objectResponse = this.softTriggerService.execute(parkId, parkCode, aisleCode, topic, (SoftTriggerRequest)SoftTriggerRequest.GetCarInfo.builder().biz(SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val).type(type).channelCode(aisleCode).build());
        }
        return objectResponse;
    }
}

