/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl.manage;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2c.impl.TakePicturesServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.handle.showsay.LedSayHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.impl.base.ManageServiceBase;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudManageCommon
extends ManageServiceBase {
    private static final Logger log = LoggerFactory.getLogger(CloudManageCommon.class);
    @Autowired
    protected SoftTriggerServiceImpl softTriggerService;
    @Autowired
    protected TakePicturesServiceImpl takePicturesService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Autowired
    protected HintServiceImpl hintService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected LedShowHandle ledShowHandle;
    @Autowired
    protected LedSayHandle ledSayHandle;
    @Autowired
    protected DownShowSayHandle downShowSayHandle;
    @Autowired
    protected PublicHandle publicHandle;
    @Autowired
    protected RedisUtils redisUtils;

    protected ObjectResponse<Void> noConExit(DataExitRequest exitRequest, Long parkId, String plateNum) {
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setParkCode(exitRequest.getParkCode());
        carExitRequest.setParkId(parkId);
        carExitRequest.setOrderNum(exitRequest.getOrderNum());
        carExitRequest.setType(exitRequest.getType());
        carExitRequest.setCarType(exitRequest.getCarType());
        carExitRequest.setExitTime(Long.valueOf(exitRequest.getExitTime() == null ? DateTools.unixTimestamp() : exitRequest.getExitTime().getTime() / 1000L));
        carExitRequest.setPlateNum(plateNum);
        carExitRequest.setTriggerType(Integer.valueOf(2));
        carExitRequest.setParkCode(exitRequest.getParkCode());
        carExitRequest.setInandoutCode(exitRequest.getAisleCode());
        if (exitRequest.getAisleCode() != null) {
            ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(parkId, exitRequest.getAisleCode());
            ObjectResponse.notError((Response)objectResponse, (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
            carExitRequest.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
        }
        carExitRequest.setExitWay(exitRequest.getExitWay());
        carExitRequest.setOperAccount(exitRequest.getOperAccount());
        carExitRequest.setExitTerminal(exitRequest.getExitTerminal());
        ObjectResponse enterObjectResponse = this.carOrderExitService.exit(carExitRequest);
        if (ObjectResponse.isSuccess((Response)enterObjectResponse)) {
            return ObjectResponse.success();
        }
        log.info("[\u5e73\u53f0\u79bb\u573a] \u65e0\u724c\u8f66\u79bb\u573a\u5931\u8d25\uff0c\u8fd4\u56de\uff1a{}", (Object)enterObjectResponse);
        return ObjectResponse.failed((String)enterObjectResponse.getCode(), (String)enterObjectResponse.getMsg());
    }

    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest) {
        return this.getExitCarInfoResponse(parkId, parkCode, carExitRequest, null);
    }

    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest, String localOrderNum) {
        ObjectResponse byOrderInfo;
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        } else {
            String plateNum = carExitRequest.getPlateNum();
            byOrderInfo = this.orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null) {
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        } else {
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null) {
            exitCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }
        if (exitCarInfoResponse.getOrderNum() == null && localOrderNum != null) {
            exitCarInfoResponse.setLocalOrderNum(localOrderNum);
            exitCarInfoResponse.setNoneEnterFlag(Integer.valueOf(1));
        }
        return exitCarInfoResponse;
    }

    protected void exceptionExit(CaptureService captureService, OpenBrakeRequest openBrakeRequest, String parkCode, String plateNum, String topic) {
        ObjectResponse inPark = this.orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess((Response)inPark)) {
            ObjectResponse exceptionExit;
            OrderInfo orderInfo = (OrderInfo)inPark.getData();
            CarExitRequest exit = this.cacheHandle.getExit(parkCode, openBrakeRequest.getAisleCode());
            if (exit == null) {
                ObjectResponse<Void> objectResponse = captureService.execute(orderInfo.getParkId(), parkCode, openBrakeRequest.getAisleCode(), topic, (SoftTriggerRequest)SoftTriggerRequest.ExceptionExit.builder().biz(SoftTriggerRequest.ExtraInfoEnum.EXCEPTION_EXIT.val).type(Integer.valueOf(2)).plateNum(plateNum).orderNum(orderInfo.getOrderNum()).operAccount(openBrakeRequest.getOperAccount()).exitTerminal(openBrakeRequest.getExitTerminal()).reasonType(openBrakeRequest.getReasonType()).build());
                if ("12002".equals(objectResponse.getCode())) {
                    return;
                }
                exit = new CarExitRequest();
            } else if (!exit.getPlateNum().equals(plateNum)) {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u79bb\u573a\u901a\u9053\u7f13\u5b58\u7684\u5f53\u524d\u8f66\u724c\u53f7\uff1a{} \u4e0e\u5f00\u95f8\u8bf7\u6c42\u7684\u8f66\u724c\u53f7\uff1a{} \u4e0d\u540c", (Object)exit.getPlateNum(), (Object)plateNum);
            }
            exit.setPlateNum(plateNum);
            exit.setOrderNum(orderInfo.getOrderNum());
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(parkCode, openBrakeRequest.getAisleCode());
            if (channelFee != null) {
                exit.setTotalAmount(channelFee.getTotalAmount());
                exit.setPaidAmount(channelFee.getPaidAmount());
                exit.setDiscountAmount(channelFee.getDiscountAmount());
            }
            exit.setExitWay(Integer.valueOf(4));
            if (openBrakeRequest.getOperAccount() != null) {
                exit.setOperAccount(openBrakeRequest.getOperAccount());
            }
            if (openBrakeRequest.getExitTerminal() != null) {
                exit.setExitTerminal(openBrakeRequest.getExitTerminal());
            }
            if (!ObjectResponse.isSuccess((Response)(exceptionExit = this.carOrderExitService.exceptionExit(exit, openBrakeRequest.getReasonType())))) {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u5f02\u5e38\u79bb\u573a\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            } else {
                log.info("[\u624b\u52a8\u5f00\u95f8] \u5f02\u5e38\u79bb\u573a\u6210\u529f\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            }
        }
    }

    protected Long getParkId(String parkCode) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        return park.getId();
    }

    protected ObjectResponse<Void> callVoiceReport(CaptureService captureService, VoiceReportRequest voiceReportRequest) {
        String serialNumber;
        String parkCode = voiceReportRequest.getParkCode();
        String aisleCode = voiceReportRequest.getAisleCode();
        String fee = voiceReportRequest.getFee();
        if (NumberUtils.parseDouble((Object)fee) <= 0.0) {
            log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] 0\u5143\u8d39\u7528\u65e0\u9700\u4e0b\u53d1\u5c4f\u663e\u8bed\u97f3, {}", (Object)voiceReportRequest);
            return ObjectResponse.success();
        }
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, aisleCode);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"3003");
        }
        String plateNum = voiceReportRequest.getPlateNum();
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(park.getId(), aisleCode);
        ObjectResponse.notError((Response)channelResp, (String)"\u901a\u9053\u53f7\u4e0d\u5b58\u5728");
        Integer exType = ((ParkInoutdevice)channelResp.getData()).getInandoutType();
        String orderNum = voiceReportRequest.getOrderNum();
        int type = 1;
        CarExitRequest exit = null;
        CarEnterRequest enterRequest = null;
        if (exType == 2) {
            ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
            ObjectResponse.notError((Response)orderInfoObjectResponse, (String)"\u5f53\u524d\u8f66\u8f86\u4e0d\u5728\u573a\u5185");
            type = ((OrderInfo)orderInfoObjectResponse.getData()).getType();
            exit = this.cacheHandle.getExit(parkCode, aisleCode);
        } else {
            enterRequest = this.cacheHandle.getEntrance(parkCode, aisleCode);
            if (enterRequest != null) {
                type = enterRequest.getType();
            }
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("fee", voiceReportRequest.getFee());
        para.put("parkTime", voiceReportRequest.getParkTime());
        para.put("orderNum", voiceReportRequest.getOrderNum());
        ObjectResponse objectResponse = this.downShowSayHandle.showSayExec(park.getId(), parkCode, ((ParkInoutdevice)channelResp.getData()).getId(), plateNum, type, voiceReportRequest.isHasNotPay() ? FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34 : FlowCondition.ResultCode.\u9700\u7f34\u8d39, para, serialNumber, exType, aisleCode, true);
        if (exType == 2) {
            if (exit == null) {
                log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] \u7591\u4f3c\u51fa\u53e3\u76f8\u673a\u8bc6\u522b\u6210\u4e86\u65e0\u724c\u8f66\uff0c\u53c2\u6570\uff1a{},{}", (Object)parkCode, (Object)aisleCode);
                ObjectResponse<Void> objectResponse2 = captureService.execute(park.getId(), parkCode, aisleCode, voiceReportRequest.getTopic(), (SoftTriggerRequest)SoftTriggerRequest.CallVoiceReport.builder().biz(SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val).plateNum(plateNum).type(exType).orderNum(voiceReportRequest.getOrderNum()).code(objectResponse.getCode()).msg(objectResponse.getMsg()).build());
                if ("12002".equals(objectResponse2.getCode())) {
                    return objectResponse2;
                }
                exit = new CarExitRequest();
                exit.setParkCode(parkCode);
                exit.setParkId(park.getId());
                exit.setInandoutCode(voiceReportRequest.getAisleCode());
                log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] \u8f6f\u89e6\u53d1\u672a\u83b7\u53d6\u5230\u7ed3\u679c\uff0c\u4f1a\u5f71\u54cd\u5230\u79bb\u573a\uff0c\u53c2\u6570\uff1a{},{}", (Object)parkCode, (Object)aisleCode);
            }
            exit.setPlateNum(plateNum);
            exit.setOrderNum(voiceReportRequest.getOrderNum());
            this.cacheHandle.setExit(parkCode, aisleCode, exit);
        } else {
            if (enterRequest == null) {
                log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] \u7591\u4f3c\u5165\u53e3\u76f8\u673a\u8bc6\u522b\u6210\u4e86\u65e0\u724c\u8f66\uff0c\u53c2\u6570\uff1a{},{}", (Object)parkCode, (Object)aisleCode);
                ObjectResponse<Void> objectResponse2 = captureService.execute(park.getId(), parkCode, aisleCode, voiceReportRequest.getTopic(), (SoftTriggerRequest)SoftTriggerRequest.CallVoiceReport.builder().biz(SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val).plateNum(plateNum).type(exType).orderNum(voiceReportRequest.getOrderNum()).code(objectResponse.getCode()).msg(objectResponse.getMsg()).build());
                if ("12002".equals(objectResponse2.getCode())) {
                    return objectResponse2;
                }
                enterRequest = new CarEnterRequest();
                enterRequest.setParkCode(parkCode);
                enterRequest.setParkId(park.getId());
                enterRequest.setInandoutCode(voiceReportRequest.getAisleCode());
                log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] \u8f6f\u89e6\u53d1\u672a\u83b7\u53d6\u5230\u7ed3\u679c\uff0c\u4f1a\u5f71\u54cd\u5230\u79bb\u573a\uff0c\u53c2\u6570\uff1a{},{}", (Object)parkCode, (Object)aisleCode);
            }
            enterRequest.setPlateNum(plateNum);
            enterRequest.setOrderNum(voiceReportRequest.getOrderNum());
            this.cacheHandle.setEntrance(parkCode, aisleCode, enterRequest);
        }
        if (objectResponse != null && objectResponse.getCode().equals("200")) {
            return ObjectResponse.success();
        }
        log.info("[\u7aef\u4e91-\u8bed\u97f3\u64ad\u62a5] \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
        return ObjectResponse.failed((String)"3003");
    }

    protected ObjectResponse<Void> allowEnter(RemoteOperaService remoteOperaService, DataEnterRequest enterRequest) {
        String serialNumber;
        String parkCode = enterRequest.getParkCode();
        Long parkId = this.getParkId(parkCode);
        String plateNum = enterRequest.getPlateNum();
        if (enterRequest.isOffLine()) {
            return this.p2cEnter(enterRequest, plateNum, parkId, parkCode);
        }
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, enterRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"3003");
        }
        String msgId = remoteOperaService.open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, enterRequest.getParkCode(), serialNumber, enterRequest.getPlateNum());
        if (msgId == null) {
            log.info("[\u5e73\u53f0\u5165\u573a] \u5f00\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
            return ObjectResponse.failed((String)"3002");
        }
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, enterRequest.getAisleCode());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        if (channel == null) {
            return ObjectResponse.failed((String)"500", (String)"\u65e0\u6548\u7684\u901a\u9053\u7f16\u53f7");
        }
        this.downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterRequest.getType(), null, serialNumber, 1, enterRequest.getAisleCode(), false);
        return this.enter(enterRequest, parkCode, enterRequest.getAisleCode(), parkId, plateNum, enterRequest.getTopic());
    }

    private ObjectResponse<Void> p2cEnter(DataEnterRequest enterRequest, String plateNum, Long parkId, String parkCode) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(Integer.valueOf(1));
        carEnterRequest.setEnterTime(enterRequest.getEnterTime());
        carEnterRequest.setCarType(Integer.valueOf(1));
        carEnterRequest.setInandoutCode(enterRequest.getAisleCode());
        ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(parkId, enterRequest.getAisleCode());
        ObjectResponse.notError((Response)objectResponse);
        carEnterRequest.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
        carEnterRequest.setOpenFlag(Integer.valueOf(0));
        carEnterRequest.setTriggerType(Integer.valueOf(2));
        carEnterRequest.setProperty(Integer.valueOf(2));
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(Integer.valueOf(enterRequest.getEnterWay() != null ? enterRequest.getEnterWay() : 4));
        carEnterRequest.setNoneEnterFlag(false);
        carEnterRequest.setRemark(enterRequest.getRemark());
        carEnterRequest.setEnterTerminal(enterRequest.getEnterTerminal());
        carEnterRequest.setOperaUser(enterRequest.getOperaUser());
        ObjectResponse resp = this.carOrderEnterService.enter(carEnterRequest);
        return ObjectResponse.instance((Response)resp);
    }

    protected ObjectResponse<Void> exit(CaptureService captureService, DataExitRequest exitRequest, String parkCode, String aisleCode, Long parkId, String plateNum, String topic) {
        ObjectResponse objectResponse;
        OrderInfo orderInfo;
        Long enterTime;
        String orderNum;
        ObjectResponse orderInfoObjectResponse;
        if (exitRequest.isOffLine()) {
            log.debug("isOffLine:{}", (Object)exitRequest.isOffLine());
            return this.noConExit(exitRequest, parkId, plateNum);
        }
        CarExitRequest exit = this.cacheHandle.getExit(parkCode, aisleCode);
        if (exit == null) {
            ObjectResponse<Void> objectResponse2 = captureService.execute(parkId, parkCode, aisleCode, topic, (SoftTriggerRequest)SoftTriggerRequest.AllowExit.builder().biz(SoftTriggerRequest.ExtraInfoEnum.ALLOW_EXIT.val).type(Integer.valueOf(2)).requestVO((Object)exitRequest).build());
            if (objectResponse2.getCode().equals("12002")) {
                return objectResponse2;
            }
            return this.noConExit(exitRequest, parkId, plateNum);
        }
        String cacheOrderNum = exit.getOrderNum();
        if (cacheOrderNum != null && !exitRequest.getOrderNum().equals(cacheOrderNum)) {
            log.warn("[\u5e73\u53f0\u79bb\u573a] \u8ba2\u5355\u4e0e\u7f13\u5b58\u4e2d\u7684\u5f02\u5e38\u8ba2\u5355\u4e0d\u5339\u914d\uff0c\u7f13\u5b58\u6570\u636e\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)exit, (Object)exitRequest);
        }
        if (ObjectResponse.isSuccess((Response)(orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum = exitRequest.getOrderNum()))) && (enterTime = (orderInfo = (OrderInfo)orderInfoObjectResponse.getData()).getEnterTime()) > exitRequest.getExitTime().getTime() / 1000L) {
            exitRequest.setExitTime(new Date());
        }
        exit.setType(exitRequest.getType());
        exit.setInandoutCode(aisleCode);
        if (exit.getInandoutName() == null && aisleCode != null) {
            objectResponse = this.parkService.getInOutDeviceByCode(parkId, aisleCode);
            ObjectResponse.notError((Response)objectResponse, (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
            exit.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
        }
        exit.setCarType(exitRequest.getCarType() != null ? exitRequest.getCarType() : exit.getCarType());
        exit.setOrderNum(orderNum == null ? cacheOrderNum : orderNum);
        exit.setPlateNum(exitRequest.getPlateNum());
        exit.setExitTime(Long.valueOf(exit.getExitTime() != null ? exit.getExitTime() : exitRequest.getExitTime().getTime() / 1000L));
        if (exitRequest.getOperAccount() != null) {
            exit.setOperAccount(exitRequest.getOperAccount());
        }
        if (exitRequest.getExitWay() != null) {
            exit.setExitWay(exitRequest.getExitWay());
        }
        if (exitRequest.getExitTerminal() != null) {
            exit.setExitTerminal(exitRequest.getExitTerminal());
        }
        if (ObjectResponse.isSuccess((Response)(objectResponse = this.carOrderExitService.exit(exit)))) {
            this.cacheHandle.removeExit(parkCode, aisleCode);
            this.cacheHandle.removeChannelFee(parkCode, aisleCode);
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
    }

    public void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties((Object)openBrakeRequest, (Object)openingDtoRequest);
        openingDtoRequest.setImgUrl(image);
        openingDtoRequest.setExecuteTime(executeTime);
        this.parkService.saveOpeningRecord(openingDtoRequest);
    }

    protected ObjectResponse<PullfeeResponse> p2cPullFee(PullfeeRequest pullfeeRequest, QueryOrderFeeRequest queryOrderFeeRequest, String parkCode, String channelId) {
        PullfeeResponse pullfeeResponse = new PullfeeResponse();
        QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(pullfeeRequest.getParkCode(), pullfeeRequest.getAisleCode());
        ObjectResponse inoutObjectResponse = this.parkService.getInoutDeviceByCode(channelId);
        ObjectResponse.notError((Response)inoutObjectResponse, (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
        queryOrderFeeRequest.setExType(((ParkInoutdevice)inoutObjectResponse.getData()).getInandoutType());
        if (((ParkInoutdevice)inoutObjectResponse.getData()).getInandoutType() == 1) {
            if (channelFee == null || !channelFee.getPlateNum().equals(pullfeeRequest.getPlateNum())) {
                log.warn("[\u5165\u53e3\u67e5\u8d39] \u5f53\u524d\u901a\u9053\u8d39\u7528\u7f13\u5b58\u4e3a\u7a7a\u6216\u8f66\u724c\u53f7\u4e0d\u4e00\u81f4, \u5f53\u524d\u7f13\u5b58[{}], \u53c2\u6570\u8f66\u724c\u53f7[{}]", (Object)channelFee, (Object)pullfeeRequest.getPlateNum());
                ObjectResponse objectResponse = this.orderService.p2cQueryFee(queryOrderFeeRequest);
                if (ObjectResponse.isSuccess((Response)objectResponse)) {
                    this.cacheHandle.setChannelFee(parkCode, channelId, (QueryOrderFeeResponse)objectResponse.getData());
                }
            }
            return ObjectResponse.success();
        }
        if (channelFee == null || !channelFee.getPlateNum().equals(pullfeeRequest.getPlateNum()) || channelFee.getCarType() != null && !channelFee.getCarType().equals(pullfeeRequest.getCarType())) {
            ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse;
            log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u7f13\u5b58\u4e2d\u65e0\u8d39\u7528\u4fe1\u606f\uff0c\u67e5\u8be2\u6700\u65b0\u8d39\u7528\uff0c\u53c2\u6570[{}]", (Object)pullfeeRequest);
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, channelId);
            if (cacheExit != null) {
                log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u4ee5\u7f13\u5b58\u4e2d\u7684\u79bb\u573a\u65f6\u95f4\u4f5c\u4e3a\u8ba1\u8d39\u622a\u6b62\u65f6\u95f4, \u8f66\u724c\u53f7[{}],\u8ba1\u8d39\u622a\u6b62\u65f6\u95f4[{}]", (Object)pullfeeRequest.getPlateNum(), (Object)cacheExit.getExitTime());
                queryOrderFeeRequest.setExitTime(cacheExit.getExitTime());
            }
            if (!ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse = this.queryOrderFee(queryOrderFeeRequest))) {
                ObjectResponse sumFee;
                if ("3004".equals(queryOrderFeeResponseObjectResponse.getCode()) && (sumFee = this.orderPayService.getSumFee(pullfeeRequest.getParkCode(), pullfeeRequest.getOrderNum())) != null && sumFee.getCode().equals("200")) {
                    OrderSumFeeDto orderSumFeeDto = (OrderSumFeeDto)sumFee.getData();
                    pullfeeResponse.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    pullfeeResponse.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                    pullfeeResponse.setCurrentDiscountPrice("0.00");
                    pullfeeResponse.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    pullfeeResponse.setNeedPayPrice("0.00");
                    pullfeeResponse.setOrderNum(orderSumFeeDto.getOrderNum());
                    pullfeeResponse.setQueryTime(orderSumFeeDto.getLastOrderTime());
                    pullfeeResponse.setLastPayTime(orderSumFeeDto.getLastPayTime());
                    return ObjectResponse.success((Object)pullfeeResponse);
                }
                log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u67e5\u8be2\u6700\u65b0\u8d39\u7528\u5931\u8d25\uff0c\u53c2\u6570[{}]", (Object)pullfeeRequest);
                return ObjectResponse.failed((String)"3001", (String)queryOrderFeeResponseObjectResponse.getMsg());
            }
            QueryOrderFeeResponse data = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
            String discountPrice = data.getDiscountPrice();
            String unpayPrice = data.getUnpayPrice();
            String discountAmount = data.getDiscountAmount();
            pullfeeResponse.setTotalPrice(data.getTotalAmount());
            pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd((Object)discountPrice, (Object[])new Object[]{discountAmount}).toString());
            pullfeeResponse.setCurrentDiscountPrice(discountPrice);
            pullfeeResponse.setPaidPrice(data.getPaidAmount());
            pullfeeResponse.setNeedPayPrice(unpayPrice);
            pullfeeResponse.setQueryTime(data.getQueryTime());
            pullfeeResponse.setLastPayTime(data.getPayTime());
            pullfeeResponse.setOrderNum(data.getOrderNum());
            if (NumberUtils.toPrimitive((Integer)pullfeeRequest.getSource()) == 1) {
                String tradeNo = CodeTools.GenerateTradeNo();
                pullfeeResponse.setTradeNo(tradeNo);
                data.setTradeNo(tradeNo);
                data.setIsOffline(Boolean.valueOf(true));
            }
            log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u5c06\u8d39\u7528\u4fdd\u5b58\u5230\u7f13\u5b58\uff0c\u8d39\u7528[{}]", (Object)data);
            this.cacheHandle.setChannelFee(parkCode, channelId, data);
            if (cacheExit == null || !data.getOrderNum().equals(cacheExit.getOrderNum())) {
                cacheExit = new CarExitRequest();
                cacheExit.setOpenFlag(Integer.valueOf(0));
                cacheExit.setCarType(pullfeeRequest.getCarType());
                cacheExit.setExitTime(data.getQueryTime());
                cacheExit.setOrderNum(data.getOrderNum());
                cacheExit.setPlateNum(data.getPlateNum());
                cacheExit.setInandoutCode(channelId);
                ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
                ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(((Park)parkObjectResponse.getData()).getId(), channelId);
                if (ObjectResponse.isSuccess((Response)objectResponse)) {
                    cacheExit.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
                }
                cacheExit.setParkId(((Park)parkObjectResponse.getData()).getId());
                cacheExit.setParkCode(parkCode);
                cacheExit.setOperAccount(pullfeeRequest.getOperaAccount());
                cacheExit.setExitTerminal(pullfeeRequest.getExitTerminal());
                cacheExit.setExitWay(Integer.valueOf(4));
                String softImage = (String)this.redisUtils.get("softTrigger:image:" + channelId, String.class);
                cacheExit.setMaxImage(softImage);
                this.cacheHandle.setExit(parkCode, channelId, cacheExit);
            }
        } else {
            ObjectResponse sumFee;
            boolean newPayFlag = false;
            String cacheUnpayPrice = channelFee.getUnpayPrice();
            if (NumberUtils.toFloat((String)cacheUnpayPrice) > 0.0f && (sumFee = this.orderPayService.getSumFee(pullfeeRequest.getParkCode(), pullfeeRequest.getOrderNum())) != null && sumFee.getCode().equals("200")) {
                float unpayPrice = NumberUtils.toFloat((String)channelFee.getUnpayPrice());
                float paidAmount = NumberUtils.toFloat((String)channelFee.getPaidAmount());
                OrderSumFeeDto data = (OrderSumFeeDto)sumFee.getData();
                float paidPrice = data.getPaidPrice();
                if (paidPrice == NumberUtils.decimalAdd((Object)Float.valueOf(paidAmount), (Object[])new Object[]{Float.valueOf(unpayPrice)}).floatValue()) {
                    log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u67e5\u8be2\u5230\u7528\u6237\u5df2\u652f\u4ed8\uff0c\u53c2\u6570[{}]", (Object)pullfeeRequest);
                    newPayFlag = true;
                    pullfeeResponse.setTotalPrice(channelFee.getTotalAmount());
                    pullfeeResponse.setDiscountPrice(String.valueOf(data.getDiscountPrice()));
                    pullfeeResponse.setCurrentDiscountPrice("0.00");
                    pullfeeResponse.setPaidPrice(String.valueOf(paidPrice));
                    pullfeeResponse.setNeedPayPrice("0.00");
                    pullfeeResponse.setTradeNo(channelFee.getTradeNo());
                    pullfeeResponse.setOrderNum(channelFee.getOrderNum());
                    channelFee.setUnpayPrice("0.00");
                    channelFee.setPaidAmount(String.valueOf(paidPrice));
                    channelFee.setDiscountAmount(String.valueOf(data.getDiscountPrice()));
                    channelFee.setDiscountPrice("0.00");
                    channelFee.setPayTime(data.getLastPayTime());
                    if (channelFee.getTradeNo() == null && NumberUtils.toPrimitive((Integer)pullfeeRequest.getSource()) == 1) {
                        String tradeNo = CodeTools.GenerateTradeNo();
                        channelFee.setTradeNo(tradeNo);
                        channelFee.setIsOffline(Boolean.valueOf(true));
                        pullfeeResponse.setTradeNo(tradeNo);
                    }
                    this.cacheHandle.setChannelFee(parkCode, channelId, channelFee);
                    CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, channelId);
                    if (cacheExit == null || !cacheExit.getOrderNum().equals(channelFee.getOrderNum())) {
                        cacheExit = new CarExitRequest();
                        cacheExit.setOpenFlag(Integer.valueOf(0));
                        cacheExit.setCarType(pullfeeRequest.getCarType());
                        cacheExit.setExitTime(channelFee.getQueryTime());
                        cacheExit.setOrderNum(channelFee.getOrderNum());
                        cacheExit.setPlateNum(channelFee.getPlateNum());
                        cacheExit.setInandoutCode(channelId);
                        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
                        ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(((Park)parkObjectResponse.getData()).getId(), channelId);
                        if (ObjectResponse.isSuccess((Response)objectResponse)) {
                            cacheExit.setInandoutName(((ParkInoutdevice)objectResponse.getData()).getInandoutName());
                        }
                        cacheExit.setParkId(((Park)parkObjectResponse.getData()).getId());
                        cacheExit.setParkCode(parkCode);
                        cacheExit.setOperAccount(pullfeeRequest.getOperaAccount());
                        cacheExit.setExitTerminal(pullfeeRequest.getExitTerminal());
                        cacheExit.setExitWay(Integer.valueOf(4));
                        String softImage = (String)this.redisUtils.get("softTrigger:image:" + channelId, String.class);
                        cacheExit.setMaxImage(softImage);
                        this.cacheHandle.setExit(parkCode, channelId, cacheExit);
                    }
                }
            }
            if (!newPayFlag) {
                log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u76f4\u63a5\u4ece\u7f13\u5b58\u4e2d\u52a0\u8f7d\u8d39\u7528\uff0c\u53c2\u6570[{}]", (Object)pullfeeRequest);
                pullfeeResponse.setTotalPrice(channelFee.getTotalAmount());
                float discountAmount = NumberUtils.toFloat((String)channelFee.getDiscountAmount());
                float discountPrice = NumberUtils.toFloat((String)channelFee.getDiscountPrice());
                pullfeeResponse.setDiscountPrice(String.valueOf(discountAmount + discountPrice));
                pullfeeResponse.setCurrentDiscountPrice(String.valueOf(discountPrice));
                pullfeeResponse.setPaidPrice(channelFee.getPaidAmount());
                pullfeeResponse.setNeedPayPrice(channelFee.getUnpayPrice());
                pullfeeResponse.setOrderNum(channelFee.getOrderNum());
                pullfeeResponse.setTradeNo(channelFee.getTradeNo());
            }
            pullfeeResponse.setQueryTime(channelFee.getQueryTime());
            pullfeeResponse.setLastPayTime(channelFee.getPayTime());
            pullfeeResponse.setInsideDetails(channelFee.getInsideDetails());
        }
        return ObjectResponse.success((Object)pullfeeResponse);
    }

    private ObjectResponse<QueryOrderFeeResponse> queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(queryOrderFeeRequest.getParkCode());
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(park.getId());
        ObjectResponse.notError((Response)parkConfigObjectResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)queryOrderFeeRequest.getOrderNum())) {
            if (Integer.valueOf(3).equals(parkConfig.getNoenterHandleType()) || Integer.valueOf(2).equals(parkConfig.getNoenterHandleType()) && Integer.valueOf(1).equals(parkConfig.getIsfixedfees())) {
                float fixedFee = (queryOrderFeeRequest.getCarType() != null && queryOrderFeeRequest.getCarType() == 2 ? parkConfig.getFixedFeeValueBig() : parkConfig.getFixedfeevalue()).intValue();
                ObjectResponse inOutDeviceByCode = this.parkService.getInOutDeviceByCode(park.getId(), queryOrderFeeRequest.getChannelId());
                ObjectResponse.notError((Response)inOutDeviceByCode);
                String orderNum = this.replenishOrder(queryOrderFeeRequest.getPlateNum(), park.getId(), park.getParkCode(), queryOrderFeeRequest.getCarType(), queryOrderFeeRequest.getChannelId(), ((ParkInoutdevice)inOutDeviceByCode.getData()).getInandoutName(), queryOrderFeeRequest.getExitTime() == null ? DateTools.unixTimestamp() : queryOrderFeeRequest.getExitTime());
                queryOrderFeeRequest.setOrderNum(orderNum);
                return this.fixedFeeRet(queryOrderFeeRequest, parkConfig, park, fixedFee);
            }
            throw new ResponseBodyException("500", "\u65e0\u5165\u573a\u8bb0\u5f55");
        }
        if (Integer.valueOf(1).equals(park.getIsInterior()) && queryOrderFeeRequest.getChannelId() != null) {
            ObjectResponse inOutDeviceByCode = this.parkService.getInOutDeviceByCode(park.getId(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError((Response)inOutDeviceByCode);
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inOutDeviceByCode.getData();
            if (Integer.valueOf(0).equals(parkInoutdevice.getIsFee())) {
                return this.fixedFeeRet(queryOrderFeeRequest, parkConfig, park, 0.0f);
            }
        }
        queryOrderFeeRequest.setWithNotPay(Boolean.valueOf(true));
        return this.orderService.p2cQueryFee(queryOrderFeeRequest);
    }

    private ObjectResponse<QueryOrderFeeResponse> fixedFeeRet(QueryOrderFeeRequest queryOrderFeeRequest, ParkConfig parkConfig, Park park, float fixedFee) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(queryOrderFeeRequest.getOrderNum());
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(queryOrderFeeRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        queryOrderFeeResponse.setCarType(queryOrderFeeRequest.getCarType());
        queryOrderFeeResponse.setQueryTime(Long.valueOf(DateTools.unixTimestamp()));
        queryOrderFeeResponse.setParkTime(Long.valueOf(0L));
        queryOrderFeeResponse.setTotalAmount(String.valueOf(fixedFee));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(fixedFee));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(Integer.valueOf(2));
        queryOrderFeeResponse.setFreeTime(Long.valueOf(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)).intValue()));
        return ObjectResponse.success((Object)queryOrderFeeResponse);
    }

    private String replenishOrder(String plateNum, Long parkId, String parkCode, Integer carType, String channelId, String channelName, Long exitTime) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(Integer.valueOf(1));
        carEnterRequest.setEnterTime(exitTime);
        carEnterRequest.setCarType(carType);
        carEnterRequest.setInandoutCode(channelId);
        carEnterRequest.setInandoutName(channelName);
        carEnterRequest.setOpenFlag(Integer.valueOf(1));
        carEnterRequest.setTriggerType(Integer.valueOf(2));
        carEnterRequest.setProperty(Integer.valueOf(2));
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(Integer.valueOf(1));
        carEnterRequest.setNoneEnterFlag(true);
        String orderNum = CodeTools.GenerateOrderNum();
        carEnterRequest.setOrderNum(orderNum);
        ObjectResponse objectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            log.warn("\u8865\u8ba2\u5355\u5931\u8d25, {} {}", (Object)carEnterRequest, (Object)objectResponse);
            return null;
        }
        return orderNum;
    }

    public boolean sendClose(CloseBrakeRequest closeBrakeRequest, String parkCode, Long parkId, String deviceNo, ObjectResponse<RemoteSwitchResponse> objectResponse) {
        RemoteSwitchResponse remoteSwitchResponse2;
        log.info("\u5173\u95f8\u5931\u8d25\uff0c\u5c1d\u8bd5\u4e8c\u6b21\u5173\u95f8\uff1a{}", (Object)closeBrakeRequest);
        ObjectResponse<RemoteSwitchResponse> objectResponse2 = this.remoteSwitchService.execute(SwitchTypeEnum.\u5173\u95f8.getType(), parkId, parkCode, deviceNo, closeBrakeRequest.getPlateNum());
        if (objectResponse2 != null && objectResponse2.getCode().equals("200") && (remoteSwitchResponse2 = (RemoteSwitchResponse)objectResponse.getData()).getResult().equals(1)) {
            this.addOpeningRecord(closeBrakeRequest, remoteSwitchResponse2.getImage(), remoteSwitchResponse2.getExecuteTime());
            return true;
        }
        log.info("\u7b2c\u4e8c\u6b21\u5173\u95f8\u5931\u8d25\uff0c\u8fd4\u56de\uff1a{}", objectResponse2);
        return false;
    }
}

