/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl.batch;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.IBatchSendService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants;
import com.icetech.cloudcenter.domain.request.BatchSendActionRequest;
import com.icetech.cloudcenter.domain.request.BatchSendProgressRequest;
import com.icetech.cloudcenter.domain.request.BatchSendRepeatRequest;
import com.icetech.cloudcenter.domain.response.BatchSendActionResponse;
import com.icetech.cloudcenter.domain.response.BatchSendProgressResponse;
import com.icetech.cloudcenter.domain.response.BatchSendRepeatResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.dao.BatchsendTaskDao;
import com.icetech.park.dao.BatchsendTaskSubDao;
import com.icetech.park.domain.entity.BatchsendTask;
import com.icetech.park.domain.entity.BatchsendTaskSub;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.BlacklistServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChargeRuleServiceImpl;
import com.icetech.park.service.down.p2c.impl.LcdConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.LedsoundConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.MonthCardServiceImpl;
import com.icetech.park.service.down.p2c.impl.OssConfigServiceImpl;
import com.icetech.park.service.down.p2c.impl.VipInfoServiceImpl;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchSendServiceImpl
implements IBatchSendService {
    private static final Logger log = LoggerFactory.getLogger(BatchSendServiceImpl.class);
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private MonthCardServiceImpl monthCardService;
    @Autowired
    private VipInfoServiceImpl vipInfoService;
    @Autowired
    private BlacklistServiceImpl blacklistService;
    @Autowired
    private ChargeRuleServiceImpl chargeRuleService;
    @Autowired
    private LcdConfigServiceImpl lcdConfigService;
    @Autowired
    private LedsoundConfigServiceImpl ledsoundConfigService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private OssConfigServiceImpl ossConfigService;
    @Autowired
    private BatchsendTaskDao batchsendTaskDao;
    @Autowired
    private BatchsendTaskSubDao batchsendTaskSubDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    private int TIMEOUT = 600;

    public ObjectResponse<BatchSendActionResponse> action(BatchSendActionRequest batchSendActionRequest) {
        Object[] configTypes = null;
        Object[] bizTypes = null;
        Long parkId = batchSendActionRequest.getParkId();
        if (StrUtil.isNotBlank((CharSequence)batchSendActionRequest.getConfigTypes())) {
            configTypes = (Integer[])Arrays.stream(batchSendActionRequest.getConfigTypes().split(",")).map(Integer::valueOf).toArray(Integer[]::new);
        }
        if (StrUtil.isNotBlank((CharSequence)batchSendActionRequest.getBizTypes())) {
            bizTypes = (Integer[])Arrays.stream(batchSendActionRequest.getBizTypes().split(",")).map(Integer::valueOf).toArray(Integer[]::new);
        }
        Long[] channelIds = (Long[])Arrays.stream(batchSendActionRequest.getChannelIds().split(",")).map(Long::valueOf).toArray(Long[]::new);
        if (parkId == null) {
            return ObjectResponse.failed((String)"400", (String)"parkId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)parkConfigObjectResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        if ((parkConfig.getDataCollection() == 1 || parkConfig.getDataCollection() == 3) && channelIds.length == 0) {
            return ObjectResponse.failed((String)"400", (String)"channelIds\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(bizTypes != null && bizTypes.length != 0 || configTypes != null && configTypes.length != 0)) {
            return ObjectResponse.failed((String)"400", (String)"bizTypes\u548cconfigTypes\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        BatchsendTask batchsendTask = new BatchsendTask();
        batchsendTask.setParkId(parkId);
        batchsendTask = this.batchsendTaskDao.selectOneByEntity(batchsendTask);
        if (batchsendTask != null) {
            Date operTime = batchsendTask.getUpdateTime() == null ? batchsendTask.getCreateTime() : batchsendTask.getUpdateTime();
            Integer status = batchsendTask.getStatus();
            if (status != 3 && (System.currentTimeMillis() - operTime.getTime()) / 1000L < (long)this.TIMEOUT) {
                return ObjectResponse.failed((String)"405", (String)"\u4e0b\u53d1\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d");
            }
            log.info("[\u6279\u91cf\u4e0b\u53d1] \u4efb\u52a1\u5df2\u7ecf\u8d85\u65f6,\u53ef\u4ee5\u5f00\u59cb\u65b0\u7684\u4e0b\u53d1\u4efb\u52a1,\u53c2\u6570[{}]", (Object)batchSendActionRequest);
        }
        ObjectResponse deviceResponse = this.parkDeviceService.getDevicesByParkChannel(parkId, channelIds, Integer.valueOf(1));
        ObjectResponse inoutResponse = this.parkService.getChannelsByIds(channelIds);
        if (ObjectResponse.isSuccess((Response)deviceResponse) && ObjectResponse.isSuccess((Response)inoutResponse)) {
            List deviceList = (List)deviceResponse.getData();
            List parkInoutdevices = (List)inoutResponse.getData();
            Map<Integer, List<ParkDevice>> channelList = deviceList.stream().collect(Collectors.groupingBy(ParkDevice::getChannelId));
            Integer[] serviceTypes = (Integer[])ArrayUtils.addAll((Object[])configTypes, (Object[])bizTypes);
            String taskId = UUIDTools.getUuid();
            BatchsendTask batchsendTaskNew = new BatchsendTask();
            batchsendTaskNew.setTaskId(taskId);
            batchsendTaskNew.setServiceTypes(Arrays.stream(serviceTypes).map(String::valueOf).collect(Collectors.joining(",")));
            batchsendTaskNew.setChannelIds(Arrays.stream(channelIds).map(String::valueOf).collect(Collectors.joining(",")));
            batchsendTaskNew.setParkId(batchSendActionRequest.getParkId());
            batchsendTaskNew.setStatus(Integer.valueOf(2));
            batchsendTaskNew.setOperAccount(batchSendActionRequest.getOperAccount());
            batchsendTaskNew.setUpdateTime(new Date());
            this.batchsendTaskDao.insert(batchsendTaskNew);
            this.initAndSendSubTask(parkId, park.getParkCode(), serviceTypes, taskId, parkInoutdevices, channelList, parkConfig);
            BatchSendActionResponse batchSendActionResponse = new BatchSendActionResponse();
            batchSendActionResponse.setTaskId(taskId);
            return ObjectResponse.success((Object)batchSendActionResponse);
        }
        return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u6216\u76f8\u673a\u8bbe\u5907\u4e0d\u5b58\u5728");
    }

    private void initAndSendSubTask(Long parkId, String parkCode, Integer[] serviceTypes, String taskId, List<ParkInoutdevice> parkInoutdevices, Map<Integer, List<ParkDevice>> channelIdDeviceListMap, ParkConfig parkConfig) {
        Arrays.stream(serviceTypes).forEach(serviceType -> {
            BatchSendVO batchSendVO = new BatchSendVO();
            batchSendVO.setParkCode(parkCode);
            batchSendVO.setParkId(parkId);
            batchSendVO.setTaskId(taskId);
            ArrayList list = new ArrayList();
            parkInoutdevices.forEach(parkInoutdevice -> {
                Long channelId = parkInoutdevice.getId();
                List deviceList = (List)channelIdDeviceListMap.get(channelId.intValue());
                if (deviceList == null || deviceList.size() == 0) {
                    this.createSubTask(parkId, taskId, (Integer)serviceType, batchSendVO, list, (ParkInoutdevice)parkInoutdevice, null);
                } else {
                    deviceList.forEach(parkDevice -> this.createSubTask(parkId, taskId, (Integer)serviceType, batchSendVO, list, (ParkInoutdevice)parkInoutdevice, (ParkDevice)parkDevice));
                }
            });
            batchSendVO.setSubTaskInfos(list);
            this.redisUtils.expire("batchdown:task:" + taskId, 3600L);
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.down(batchSendVO, (Integer)serviceType, parkConfig)));
        });
    }

    private void createSubTask(Long parkId, String taskId, Integer serviceType, BatchSendVO batchSendVO, List<BatchSendVO.SubTaskInfo> list, ParkInoutdevice parkInoutdevice, ParkDevice parkDevice) {
        BatchSendVO.SubTaskInfo subTaskInfo = new BatchSendVO.SubTaskInfo();
        subTaskInfo.setChannelId(parkInoutdevice.getId());
        String suffixChannelName = "";
        if (parkDevice != null && parkDevice.getIsDualcamera() != null && parkDevice.getIsDualcamera() == 1) {
            suffixChannelName = parkDevice.getIsMaster() != null && parkDevice.getIsMaster() == 1 ? "-\u4e3b\u76f8\u673a" : "-\u8f85\u76f8\u673a";
        }
        subTaskInfo.setChannelName(parkInoutdevice.getInandoutName() + suffixChannelName);
        subTaskInfo.setSn(parkDevice != null ? parkDevice.getSerialNumber() : null);
        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setTaskId(taskId);
        batchsendTaskSub.setParkId(parkId);
        batchsendTaskSub.setChannelId(subTaskInfo.getChannelId());
        batchsendTaskSub.setChannelName(subTaskInfo.getChannelName());
        batchsendTaskSub.setSn(subTaskInfo.getSn());
        batchsendTaskSub.setServiceType(serviceType);
        batchsendTaskSub.setTotalNum(Integer.valueOf(0));
        this.batchsendTaskSubDao.insert(batchsendTaskSub);
        log.info("[\u6570\u636e\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1] \u5199\u5165\u5b50\u4efb\u52a1\u8868\u5b8c\u6210, \u53c2\u6570[{}]", (Object)batchsendTaskSub);
        Integer subTaskId = batchsendTaskSub.getId();
        subTaskInfo.setSubTaskId(subTaskId);
        this.redisUtils.lRightPush("batchdown:task:" + taskId, (Object)subTaskId);
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("taskId", taskId);
        hashMap.put("channelId", subTaskInfo.getChannelId());
        hashMap.put("channelName", subTaskInfo.getChannelName());
        hashMap.put("sn", subTaskInfo.getSn() == null ? "NONE" : subTaskInfo.getSn());
        hashMap.put("serviceType", serviceType);
        hashMap.put("status", 1);
        hashMap.put("totalNum", 0);
        hashMap.put("successNum", 0);
        hashMap.put("failNum", 0);
        hashMap.put("startTime", DateTools.unixTimestamp());
        this.redisUtils.hPutAll(subTaskKey, hashMap);
        this.redisUtils.expire(subTaskKey, 3600L);
        log.info("[\u6570\u636e\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1] \u7f13\u5b58\u5b50\u4efb\u52a1\u8be6\u60c5\u5b8c\u6210, \u53c2\u6570[{}]", (Object)batchsendTaskSub);
        list.add(subTaskInfo);
    }

    public ObjectResponse<BatchSendProgressResponse> progress(BatchSendProgressRequest batchSendProgressRequest) {
        ArrayList list = new ArrayList();
        BatchSendProgressResponse batchSendProgressResponse = new BatchSendProgressResponse();
        BatchsendTask batchsendTask = new BatchsendTask();
        batchsendTask.setTaskId(batchSendProgressRequest.getTaskId());
        batchsendTask = this.batchsendTaskDao.selectOneByEntity(batchsendTask);
        if (batchsendTask != null) {
            Date operTime;
            String taskId = batchsendTask.getTaskId();
            String subTaskIds = batchSendProgressRequest.getSubTaskId();
            if (subTaskIds != null) {
                Arrays.stream(subTaskIds.split(",")).forEach(subTaskId -> this.setSubTaskProgress(list, String.valueOf(subTaskId)));
                long count = list.stream().filter(progress -> progress.getStatus() != 3).count();
                if (count > 0L) {
                    batchSendProgressResponse.setIsFinish(Integer.valueOf(0));
                } else {
                    batchSendProgressResponse.setIsFinish(Integer.valueOf(1));
                }
            } else if (taskId != null) {
                List objects = this.redisUtils.lRange("batchdown:task:" + taskId, 0L, -1L, String.class);
                if (CollectionUtil.isNotEmpty((Collection)objects)) {
                    objects.forEach(subTaskId -> this.setSubTaskProgress(list, (String)subTaskId));
                    long count = list.stream().filter(progress -> progress.getStatus() != 3).count();
                    if (count > 0L) {
                        batchSendProgressResponse.setIsFinish(Integer.valueOf(0));
                    } else {
                        batchSendProgressResponse.setIsFinish(Integer.valueOf(1));
                    }
                } else {
                    log.info("[\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2]redis\u4e2d\u6ca1\u6709\u4e3b\u4efb\u52a1\u6570\u636e,\u4ece\u6570\u636e\u5e93\u67e5\u8be2[{}]", (Object)taskId);
                    List<BatchsendTaskSub> batchsendTaskSubs = this.batchsendTaskSubDao.selectListByTaskId(taskId);
                    if (CollectionUtil.isNotEmpty(batchsendTaskSubs)) {
                        batchsendTaskSubs.forEach(batchsendTaskSub -> {
                            BatchSendProgressResponse.Progress progress = new BatchSendProgressResponse.Progress();
                            BeanUtils.copyProperties((Object)batchsendTaskSub, (Object)progress);
                            progress.setSubTaskId(String.valueOf(batchsendTaskSub.getId()));
                            Integer successNum = batchsendTaskSub.getSuccessNum();
                            Integer totalNum = batchsendTaskSub.getTotalNum();
                            progress.setSuccessRatio(Integer.valueOf(successNum == 0 ? 0 : (int)((double)successNum.intValue() * 1.0 / (double)totalNum.intValue() * 100.0)));
                            list.add(progress);
                        });
                        batchSendProgressResponse.setIsFinish(Integer.valueOf(batchsendTask.getStatus() == 3 ? 1 : 0));
                    } else {
                        log.warn("[\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2]\u6839\u636e\u4efb\u52a1ID\u67e5\u5e93\u672a\u627e\u5230\u8fdb\u5ea6\u60c5\u51b5[{}]", (Object)taskId);
                        return ObjectResponse.failed((String)"402");
                    }
                }
            }
            batchSendProgressResponse.setProgressList(list);
            Date date = operTime = batchsendTask.getUpdateTime() == null ? batchsendTask.getCreateTime() : batchsendTask.getUpdateTime();
            if (batchsendTask.getStatus() != 3 && ((System.currentTimeMillis() - operTime.getTime()) / 1000L > (long)this.TIMEOUT || batchSendProgressResponse.getIsFinish() == 1)) {
                batchSendProgressResponse.setIsFinish(Integer.valueOf(1));
                batchsendTask.setStatus(Integer.valueOf(3));
                this.batchsendTaskDao.updateById(batchsendTask);
                log.info("[\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2]\u4efb\u52a1\u5df2\u7ecf\u8d85\u65f6,\u66f4\u65b0\u6210\u5df2\u5b8c\u6210[{}]", (Object)taskId);
            }
            return ObjectResponse.success((Object)batchSendProgressResponse);
        }
        return ObjectResponse.failed((String)"402");
    }

    public ObjectResponse<BatchSendRepeatResponse> repeat(BatchSendRepeatRequest batchSendRepeatRequest) {
        Integer subTaskId = Integer.parseInt(batchSendRepeatRequest.getSubTaskId());
        BatchsendTaskSub batchsendTaskSub = (BatchsendTaskSub)this.batchsendTaskSubDao.selectById(subTaskId);
        if (batchsendTaskSub == null) {
            return ObjectResponse.failed((String)"402");
        }
        BatchSendRepeatVO batchSendRepeatVO = new BatchSendRepeatVO();
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(batchsendTaskSub.getParkId());
        batchSendRepeatVO.setParkCode(((Park)parkObjectResponse.getData()).getParkCode());
        batchSendRepeatVO.setParkId(batchsendTaskSub.getParkId());
        batchSendRepeatVO.setTaskId(batchsendTaskSub.getTaskId());
        batchSendRepeatVO.setSubTaskId(subTaskId);
        batchSendRepeatVO.setOldTotalNum(batchsendTaskSub.getTotalNum());
        ObjectResponse deviceResponse = this.parkDeviceService.getDeviceBySerialNumber(batchsendTaskSub.getSn());
        ObjectResponse inoutResponse = this.parkService.getInoutDeviceById(batchsendTaskSub.getChannelId());
        if (!ObjectResponse.isSuccess((Response)deviceResponse) || !ObjectResponse.isSuccess((Response)inoutResponse)) {
            return ObjectResponse.failed((String)"400");
        }
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutResponse.getData();
        ParkDevice parkDevice = (ParkDevice)deviceResponse.getData();
        batchSendRepeatVO.setChannelId(parkInoutdevice.getId());
        batchSendRepeatVO.setChannelName(parkInoutdevice.getInandoutName());
        batchSendRepeatVO.setSn(parkDevice.getSerialNumber());
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        if (!this.redisUtils.exists(subTaskKey)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("taskId", batchsendTaskSub.getTaskId());
            hashMap.put("channelId", batchsendTaskSub.getChannelId());
            hashMap.put("channelName", batchsendTaskSub.getChannelName());
            hashMap.put("sn", batchsendTaskSub.getSn());
            hashMap.put("serviceType", batchsendTaskSub.getServiceType());
            hashMap.put("status", 1);
            hashMap.put("totalNum", batchsendTaskSub.getTotalNum());
            hashMap.put("successNum", batchsendTaskSub.getSuccessNum());
            hashMap.put("failNum", batchsendTaskSub.getFailNum());
            hashMap.put("startTime", DateTools.unixTimestamp());
            this.redisUtils.hPutAll(subTaskKey, hashMap);
        } else {
            String failIds = (String)this.redisUtils.hGet(subTaskKey, "failIds", String.class);
            if (StringUtils.isNotBlank((CharSequence)failIds)) {
                batchSendRepeatVO.setFailIds(failIds);
            }
        }
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            this.batchsendTaskDao.updateTime(batchsendTaskSub.getTaskId(), new Date());
            Integer serviceType = batchsendTaskSub.getServiceType();
            this.downRepeat(batchSendRepeatVO, serviceType);
        }));
        return ObjectResponse.success();
    }

    private void down(BatchSendVO batchSendVO, Integer serviceType, ParkConfig parkConfig) {
        if (105 == serviceType) {
            this.channelRulesService.batchSend(batchSendVO);
        }
        if (105 == serviceType) {
            this.ossConfigService.batchSend(batchSendVO);
        }
        if (103 == serviceType) {
            this.chargeRuleService.batchSend(batchSendVO);
        }
        if (104 == serviceType) {
            for (BatchSendVO.SubTaskInfo subTaskInfo : batchSendVO.getSubTaskInfos()) {
                ObjectResponse channelResp = this.parkService.getInoutDeviceById(subTaskInfo.getChannelId());
                ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
                if (channel.getLedLcdSource() == 2) {
                    this.lcdConfigService.batchSend(batchSendVO, subTaskInfo);
                    continue;
                }
                this.ledsoundConfigService.batchSend(batchSendVO, subTaskInfo);
            }
        }
        if (201 == serviceType) {
            this.monthCardService.batchSend(batchSendVO);
        }
        if (203 == serviceType) {
            this.vipInfoService.batchSend(batchSendVO);
        }
        if (202 == serviceType) {
            this.blacklistService.batchSend(batchSendVO);
        }
    }

    private void downRepeat(BatchSendRepeatVO batchSendRepeatVO, Integer serviceType) {
        String configPrefix = "1";
        if (String.valueOf(serviceType).startsWith(configPrefix)) {
            if (101 == serviceType || 102 == serviceType) {
                this.channelRulesService.batchSendRepeat(batchSendRepeatVO);
            }
            if (101 == serviceType) {
                this.ossConfigService.batchSendRepeat(batchSendRepeatVO);
            }
            if (103 == serviceType) {
                this.chargeRuleService.batchSendRepeat(batchSendRepeatVO);
            }
            if (104 == serviceType) {
                ObjectResponse objectResponse = this.parkService.getInoutDeviceById(batchSendRepeatVO.getChannelId());
                if (ObjectResponse.isSuccess((Response)objectResponse)) {
                    Integer ledLcdSource = ((ParkInoutdevice)objectResponse.getData()).getLedLcdSource();
                    if (ledLcdSource == 2) {
                        this.lcdConfigService.batchSendRepeat(batchSendRepeatVO);
                    } else {
                        this.ledsoundConfigService.batchSendRepeat(batchSendRepeatVO);
                    }
                } else {
                    this.ledsoundConfigService.batchSendRepeat(batchSendRepeatVO);
                }
            }
        } else {
            if (201 == serviceType) {
                this.monthCardService.batchSendRepeat(batchSendRepeatVO);
            }
            if (203 == serviceType) {
                this.vipInfoService.batchSendRepeat(batchSendRepeatVO);
            }
            if (202 == serviceType) {
                this.blacklistService.batchSendRepeat(batchSendRepeatVO);
            }
        }
    }

    private void setSubTaskProgress(List<BatchSendProgressResponse.Progress> list, String subTaskId) {
        BatchSendProgressResponse batchSendProgressResponse = new BatchSendProgressResponse();
        BatchSendProgressResponse.Progress progress = new BatchSendProgressResponse.Progress();
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        Map objectMap = this.redisUtils.hGetAll(subTaskKey, Object.class);
        if (CollectionUtil.isNotEmpty((Map)objectMap)) {
            progress.setSubTaskId(subTaskId);
            progress.setChannelId(Long.valueOf(objectMap.get("channelId").toString()));
            progress.setChannelName((String)objectMap.get("channelName"));
            progress.setSn((String)objectMap.get("sn"));
            Integer serviceType = (Integer)objectMap.get("serviceType");
            progress.setServiceType(serviceType);
            Integer status = (Integer)objectMap.get("status");
            progress.setStatus(status);
            Integer successNum = (Integer)objectMap.get("successNum");
            Integer totalNum = (Integer)objectMap.get("totalNum");
            progress.setTotalNum(totalNum);
            progress.setFailNum(Integer.valueOf(totalNum - successNum));
            progress.setSuccessNum(successNum);
            progress.setReason((String)objectMap.get("reason"));
            Integer startTime = (Integer)objectMap.get("startTime");
            String configPrefix = "1";
            if (status != 3) {
                if (String.valueOf(serviceType).startsWith(configPrefix)) {
                    if (DateTools.unixTimestamp() - (long)startTime.intValue() > 30L) {
                        progress.setStatus(Integer.valueOf(3));
                        progress.setReason(BatchDownMsgConstants.DEVICE_TIMEOUT);
                        this.redisUtils.hPut(subTaskKey, "failNum", (Object)1);
                        this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                        this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.DEVICE_TIMEOUT);
                        this.finishErrorTask(1, 0, Integer.valueOf(subTaskId), BatchDownMsgConstants.DEVICE_TIMEOUT);
                    }
                } else if (DateTools.unixTimestamp() - (long)startTime.intValue() > 600L) {
                    progress.setStatus(Integer.valueOf(3));
                    progress.setReason(BatchDownMsgConstants.DEVICE_TIMEOUT);
                    this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                    this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.DEVICE_TIMEOUT);
                    this.finishErrorTask(totalNum, successNum, Integer.valueOf(subTaskId), BatchDownMsgConstants.DEVICE_TIMEOUT);
                }
            }
            progress.setSuccessRatio(Integer.valueOf(successNum == 0 ? 0 : (int)((double)successNum.intValue() * 1.0 / (double)totalNum.intValue() * 100.0)));
        } else {
            BatchsendTaskSub batchsendTaskSub = (BatchsendTaskSub)this.batchsendTaskSubDao.selectById((Serializable)((Object)subTaskId));
            if (batchsendTaskSub == null) {
                log.warn("[\u5c01\u88c5\u5b50\u4efb\u52a1\u8fdb\u5ea6]\u6839\u636e\u5b50\u4efb\u52a1ID\u672a\u627e\u5230\u8fdb\u5ea6\u60c5\u51b5[{}]", (Object)subTaskId);
                return;
            }
            BeanUtils.copyProperties((Object)batchsendTaskSub, (Object)progress);
            progress.setSubTaskId(String.valueOf(batchsendTaskSub.getId()));
            Integer successNum = batchsendTaskSub.getSuccessNum();
            Integer totalNum = batchsendTaskSub.getTotalNum();
            progress.setSuccessRatio(Integer.valueOf(successNum == 0 ? 0 : (int)((double)successNum.intValue() * 1.0 / (double)totalNum.intValue() * 100.0)));
        }
        list.add(progress);
    }

    private void finishErrorTask(Integer totalNum, Integer successNum, Integer subTaskId, String reason) {
        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(Integer.valueOf(3));
        batchsendTaskSub.setTotalNum(totalNum);
        batchsendTaskSub.setFailNum(Integer.valueOf(totalNum - successNum));
        batchsendTaskSub.setSuccessNum(successNum);
        batchsendTaskSub.setReason(reason);
        this.batchsendTaskSubDao.updateById(batchsendTaskSub);
    }
}

