/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl.base;

import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.oss.OssService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManageServiceBase
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(ManageServiceBase.class);
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected OssService ossService;
    @Autowired
    protected CarOrderExitService carOrderExitService;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected DeviceDownServiceFactory deviceDownServiceFactory;

    protected ObjectResponse<Void> enter(DataEnterRequest enterRequest, String parkCode, String channelId, Long parkId, String plateNum, String topic) {
        CarEnterRequest entrance = this.cacheHandle.getEntrance(parkCode, channelId);
        if (entrance == null) {
            ObjectResponse<Void> objectResponse = this.deviceDownServiceFactory.buildCaptureService(parkCode).execute(parkId, enterRequest.getParkCode(), enterRequest.getAisleCode(), topic, (SoftTriggerRequest)SoftTriggerRequest.AllowEnter.builder().biz(SoftTriggerRequest.ExtraInfoEnum.ALLOW_ENTER.val).plateNum(plateNum).type(Integer.valueOf(1)).remark(enterRequest.getRemark()).requestVO((Object)enterRequest).build());
            if (objectResponse.getCode().equals("12002")) {
                return objectResponse;
            }
            return this.noConEnter(enterRequest, parkId, plateNum);
        }
        entrance.setPlateNum(plateNum);
        entrance.setType(enterRequest.getType());
        entrance.setCarType(enterRequest.getCarType());
        entrance.setCarDesc(enterRequest.getSpecialCar());
        entrance.setDebug(enterRequest.isDebug());
        entrance.setEnterTime(Long.valueOf(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime()));
        entrance.setOperaUser(enterRequest.getOperaUser());
        entrance.setRemark(enterRequest.getRemark());
        entrance.setEnterWay(Integer.valueOf(enterRequest.getEnterWay() != null ? enterRequest.getEnterWay() : 4));
        entrance.setEnterTerminal(enterRequest.getEnterTerminal());
        ObjectResponse objectResponse = this.carOrderEnterService.enter(entrance);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            this.cacheHandle.removeEntrace(parkCode, channelId);
            return ObjectResponse.success();
        }
        log.info("[\u5e73\u53f0\u5165\u573a] \u5165\u573a\u5931\u8d25, \u8fd4\u56de:{}", (Object)objectResponse);
        return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
    }

    protected ObjectResponse<Void> noConEnter(DataEnterRequest enterRequest, Long parkId, String plateNum) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setOrderNum(enterRequest.getOrderNum());
        carEnterRequest.setType(enterRequest.getType());
        carEnterRequest.setCarType(enterRequest.getCarType());
        carEnterRequest.setEnterTime(Long.valueOf(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime()));
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setTriggerType(Integer.valueOf(2));
        carEnterRequest.setParkCode(enterRequest.getParkCode());
        carEnterRequest.setInandoutCode(enterRequest.getAisleCode());
        carEnterRequest.setEnterWay(Integer.valueOf(enterRequest.getEnterWay() != null ? enterRequest.getEnterWay() : 4));
        carEnterRequest.setOperaUser(enterRequest.getOperaUser());
        carEnterRequest.setEnterTerminal(enterRequest.getEnterTerminal());
        ObjectResponse enterObjectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess((Response)enterObjectResponse)) {
            return ObjectResponse.success();
        }
        log.info("[\u5e73\u53f0\u5165\u573a] \u65e0\u724c\u8f66\u5165\u573a\u5931\u8d25\uff0c\u8fd4\u56de\uff1a{}", (Object)enterObjectResponse);
        return ObjectResponse.failed((String)enterObjectResponse.getCode(), (String)enterObjectResponse.getMsg());
    }

    protected EnterCarInfoResponse getEntranceCarInfoResponse(CarEnterRequest entrace) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(entrace.getPlateNum());
        enterCarInfoResponse.setCarType(entrace.getCarType());
        enterCarInfoResponse.setType(entrace.getType());
        enterCarInfoResponse.setOrderNum(entrace.getOrderNum());
        String maxImage = entrace.getMaxImage();
        if (maxImage != null) {
            enterCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            enterCarInfoResponse.setImgPath(maxImage);
        }
        return enterCarInfoResponse;
    }
}

