/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskCenterServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TaskCenterServiceImpl.class);
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MonthRecordDao monthRecordDao;

    public String notify(Integer serviceType, Integer serviceId) {
        return this.notify(serviceType, serviceId, null);
    }

    public String notify(Integer serviceType, Integer serviceId, String cause) {
        try {
            ObjectResponse objectResponse = null;
            objectResponse = cause == null ? this.sendInfoService.notifySuccess(serviceType, serviceId) : this.sendInfoService.notifyFail(serviceType, serviceId, ServiceEnum.Data.getType(), cause);
            if (objectResponse != null && objectResponse.getCode().equals("200")) {
                return "200";
            }
            log.info("<\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1> \u8fd4\u56de\u672a\u6210\u529f\uff0cserviceType:{}, serviceId:{}", (Object)serviceType, (Object)serviceId);
            return "500";
        }
        catch (Exception e) {
            log.error("<\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1> \u5f02\u5e38\uff0cserviceType\uff1a{}\uff0cserviceId\uff1a{}\uff0cerrorMsg\uff1a{}", new Object[]{serviceType, serviceId, e.getMessage(), e});
            return "500";
        }
    }

    public String notify(SendInfoRecord record, String cause) {
        if (record.getRecordId() == null) {
            return this.notify(record.getServiceType(), record.getServiceId() == null ? null : Integer.valueOf(record.getServiceId().intValue()), cause);
        }
        NotifyRequest notifyRequest = new NotifyRequest();
        notifyRequest.setTargetService(ServiceEnum.Data.getType());
        notifyRequest.setOne(record.getTarget());
        notifyRequest.setServiceId(record.getServiceId());
        notifyRequest.setServiceType(record.getServiceType());
        notifyRequest.setTaskId(record.getTaskId());
        notifyRequest.setSuccess(cause == null);
        notifyRequest.setCause(cause);
        notifyRequest.setRecordId(record.getRecordId());
        return this.notify(notifyRequest);
    }

    public String notify(NotifyRequest notifyRequest) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            MonthRecord monthRecord;
            int serviceType;
            ObjectResponse objectResponse = this.sendInfoService.notify(notifyRequest);
            if (ObjectResponse.isSuccess((Response)objectResponse) && (serviceType = NumberUtils.toPrimitive((Integer)notifyRequest.getServiceType())) == DownServiceEnum.\u6708\u5361.getServiceType() && Objects.nonNull(monthRecord = (MonthRecord)this.monthRecordDao.selectById((Serializable)notifyRequest.getServiceId()))) {
                monthRecord.setSendStatus(Integer.valueOf(notifyRequest.isSuccess() ? SendInfo.StatusEnum._SUCCESS.getCode() : SendInfo.StatusEnum._FAIL.getCode()));
                this.monthRecordDao.updateById((Object)monthRecord);
            }
        }));
        return "200";
    }
}

