/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.ReconciliationService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.ReconciliationInfoResultEnum;
import com.icetech.cloudcenter.domain.enumeration.ReconciliationResultEnum;
import com.icetech.cloudcenter.domain.order.SumOrderPayDto;
import com.icetech.cloudcenter.domain.request.LocalReconciliationRequest;
import com.icetech.cloudcenter.domain.request.SumOrderPayRequest;
import com.icetech.cloudcenter.domain.vo.common.ReconciliationVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.FileTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.dao.ReconciliationDao;
import com.icetech.park.dao.ReconciliationInfoDao;
import com.icetech.park.domain.entity.Reconciliation;
import com.icetech.park.domain.entity.ReconciliationInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationServiceImpl
extends AbstractService
implements ReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ReconciliationDao reconciliationDao;
    @Autowired
    private ReconciliationInfoDao reconciliationInfoDao;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;

    public ObjectResponse execute(LocalReconciliationRequest localReconciliationRequest) {
        block8: {
            try {
                String parkCode = localReconciliationRequest.getParkCode();
                Date startTime = localReconciliationRequest.getStartTime();
                Date endTime = localReconciliationRequest.getEndTime();
                log.info("<\u5bf9\u8d26\u660e\u7ec6> \u5bf9\u8d26\u8f66\u573a : {}, \u5bf9\u8d26\u65f6\u95f4, startTime : {}, endTime : {}", new Object[]{parkCode, startTime, endTime});
                if (parkCode == null) {
                    ObjectResponse listObjectResponse = this.parkService.parkListByType(2);
                    if (!ObjectResponse.isSuccess((Response)listObjectResponse)) {
                        return ObjectResponse.failed((String)"404");
                    }
                    List parkList = (List)listObjectResponse.getData();
                    for (Park park : parkList) {
                        Long parkId = park.getId();
                        ObjectResponse timeCheck = this.timeCheck(startTime, endTime, parkId, park.getParkCode());
                        if (ObjectResponse.isSuccess((Response)timeCheck)) {
                            log.info("<\u5bf9\u8d26\u660e\u7ec6> \u8f66\u573a {} \u5bf9\u8d26\u6210\u529f\uff0c\u5bf9\u8d26\u65e5\u671f\uff1a{}\u81f3{}", new Object[]{parkId, startTime, endTime});
                            continue;
                        }
                        log.info("<\u5bf9\u8d26\u660e\u7ec6> \u8f66\u573a {} \u5bf9\u8d26\u5931\u8d25\uff0c\u5bf9\u8d26\u65e5\u671f\uff1a{}\u81f3{}", new Object[]{parkId, startTime, endTime});
                    }
                    break block8;
                }
                ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
                if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
                    return ObjectResponse.failed((String)"404");
                }
                Park park = (Park)parkObjectResponse.getData();
                ObjectResponse timeCheck = this.timeCheck(startTime, endTime, park.getId(), park.getParkCode());
                if (ObjectResponse.isSuccess((Response)timeCheck)) {
                    return ObjectResponse.success();
                }
                log.info("<\u5bf9\u8d26\u660e\u7ec6> \u5bf9\u8d26\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)localReconciliationRequest);
                return ObjectResponse.failed((String)"500");
            }
            catch (Exception e) {
                log.info("<\u5bf9\u8d26\u660e\u7ec6> \u5bf9\u8d26\u65f6\u5f02\u5e38: {}", (Throwable)e);
                return ObjectResponse.failed((String)"500");
            }
        }
        return ObjectResponse.success();
    }

    public ObjectResponse timeCheck(Date startTime, Date endTime, Long parkId, String parkCode) {
        int times = 1;
        long startTimeNew = startTime.getTime() / 1000L;
        if (!startTime.equals(endTime)) {
            long endTimeNew = endTime.getTime() / 1000L;
            times = Math.toIntExact(endTimeNew - startTimeNew) / 60 / 60 / 24 + 1;
        }
        ObjectResponse objectResponse = null;
        for (int i = 0; i < times; ++i) {
            objectResponse = this.checkBill(startTimeNew, parkId, parkCode);
            startTimeNew += 86400L;
        }
        return objectResponse;
    }

    public ObjectResponse checkBill(long time, long parkId, String parkCode) {
        try {
            OrderInfo orderInfo;
            ObjectResponse orderInfoObjectResponse;
            long endTime = time + 86400L;
            String startTime = DateTools.secondTostringDate3((int)Math.toIntExact(time));
            int countReconciliationCount = this.reconciliationDao.countReconciliation(parkId, startTime);
            SumOrderPayRequest sumOrderPayRequest = new SumOrderPayRequest();
            sumOrderPayRequest.setParkId(Long.valueOf(parkId));
            sumOrderPayRequest.setPayTimeStart(Long.valueOf(time));
            sumOrderPayRequest.setPayTimeEnd(Long.valueOf(endTime));
            sumOrderPayRequest.setPayStatus(Integer.valueOf(2));
            ObjectResponse sumOrderPayDtoObjectResponse = this.orderPayService.sumOrderPay(sumOrderPayRequest);
            if (!ObjectResponse.isSuccess((Response)sumOrderPayDtoObjectResponse)) {
                log.info("<\u5bf9\u8d26\u63a5\u53e3>\u83b7\u53d6\u5e73\u53f0\u5404\u9879\u603b\u91d1\u989d\u5931\u8d25;\u8bf7\u6c42\u53c2\u6570: {}", (Object)sumOrderPayRequest);
                return ObjectResponse.failed((String)"404");
            }
            SumOrderPayDto sumOrderPayDto = (SumOrderPayDto)sumOrderPayDtoObjectResponse.getData();
            BigDecimal pf_totalPrice = sumOrderPayDto.getTotalPrice();
            BigDecimal pf_paidPrice = sumOrderPayDto.getPaidPrice();
            BigDecimal pf_discountPrice = sumOrderPayDto.getDiscountPrice();
            BigDecimal pf_actualCash = sumOrderPayDto.getActualCash();
            BigDecimal pf_redpackRet = sumOrderPayDto.getRedpackRet();
            Integer pf_totalCount = sumOrderPayDto.getTotalCount();
            Reconciliation reconciliationUpdate = new Reconciliation();
            reconciliationUpdate.setParkId(Long.valueOf(parkId));
            reconciliationUpdate.setReportDate(startTime);
            reconciliationUpdate.setPlatformCount(pf_totalCount);
            reconciliationUpdate.setPlatformPriceTotal(pf_totalPrice);
            reconciliationUpdate.setPlatformPricePaid(pf_paidPrice);
            reconciliationUpdate.setPlatformPriceDiscount(pf_discountPrice);
            reconciliationUpdate.setPlatformActualCash(pf_actualCash);
            reconciliationUpdate.setPlatformRedpackRet(pf_redpackRet);
            if (countReconciliationCount == 0) {
                this.reconciliationDao.insert(reconciliationUpdate);
            }
            List csvList = new ArrayList();
            String csvFilePath = this.generateBillPath(parkCode, startTime);
            log.info("<\u5bf9\u8d26\u63a5\u53e3> \u4e0b\u8f7dOSS\u4e0a\u6587\u4ef6\u7684\u8def\u5f84 csvFilePath : {}", (Object)csvFilePath);
            try {
                String imageUrl = this.ossService.getImageUrl(csvFilePath);
                File oss2File = FileTools.getFileFromUrl((String)imageUrl, (String)this.getFileName(parkCode, startTime));
                try (FileInputStream fis = new FileInputStream(oss2File);
                     InputStreamReader isr = new InputStreamReader(fis);
                     CSVReader reader = new CSVReader((Reader)isr);){
                    csvList = reader.readAll();
                    oss2File.delete();
                }
            }
            catch (Exception e) {
                log.info("<\u5bf9\u8d26\u63a5\u53e3> \u5bf9\u8d26\u6587\u4ef6\u4e0d\u5b58\u5728 {}", (Object)csvFilePath);
                reconciliationUpdate.setResult(ReconciliationResultEnum.\u5bf9\u8d26\u6587\u4ef6\u672a\u4e0a\u62a5.getResult());
                this.reconciliationDao.update(reconciliationUpdate);
                return ObjectResponse.failed((String)"404");
            }
            String[] strings = (String[])csvList.get(0);
            log.info("<\u5bf9\u8d26\u63a5\u53e3> \u83b7\u53d6csv\u6587\u4ef6\u5934: {}\uff0c{}\uff0c{}\uff0c{}", new Object[]{strings[0], strings[1], strings[2], strings[3]});
            double local_price_total = (double)Float.parseFloat(strings[2] == null ? "0" : strings[2]) / 100.0;
            double local_price_paid = (double)Float.parseFloat(strings[3] == null ? "0" : strings[3]) / 100.0;
            double local_price_discount = (double)Float.parseFloat(strings[4] == null ? "0" : strings[4]) / 100.0;
            double local_actual_cash = (double)Float.parseFloat(strings[5] == null ? "0" : strings[5]) / 100.0;
            double local_redpack_ret = (double)Float.parseFloat(strings[6] == null ? "0" : strings[6]) / 100.0;
            reconciliationUpdate.setLocalCount(Integer.valueOf(strings[1] == null ? 0 : Integer.parseInt(strings[1])));
            reconciliationUpdate.setLocalPriceTotal(new BigDecimal(local_price_total).setScale(2, 5));
            reconciliationUpdate.setLocalPricePaid(new BigDecimal(local_price_paid).setScale(2, 5));
            reconciliationUpdate.setLocalPriceDiscount(new BigDecimal(local_price_discount).setScale(2, 5));
            reconciliationUpdate.setLocalActualCash(new BigDecimal(local_actual_cash).setScale(2, 5));
            reconciliationUpdate.setLocalRedpackRet(new BigDecimal(local_redpack_ret).setScale(2, 5));
            log.info("<\u5bf9\u8d26\u63a5\u53e3> \u5f00\u59cb\u5224\u65ad\u5bf9\u8d26\u7ed3\u679c\uff0c\u53c2\u6570: price_total:{},{}, price_paid:{},{}, price_discount:{},{}, count:{},{}", new Object[]{local_price_total, pf_totalPrice, local_price_paid, pf_paidPrice, local_price_discount, pf_discountPrice, reconciliationUpdate.getLocalCount(), pf_totalCount});
            if (local_price_total != NumberUtils.toDouble((BigDecimal)pf_totalPrice) || local_price_paid != NumberUtils.toDouble((BigDecimal)pf_paidPrice) || local_price_discount != NumberUtils.toDouble((BigDecimal)pf_discountPrice) || !ToolsUtil.parseFloat((Object)reconciliationUpdate.getLocalCount()).equals(ToolsUtil.parseFloat((Object)pf_totalCount))) {
                reconciliationUpdate.setResult(ReconciliationResultEnum.\u5bf9\u8d26\u4e0d\u4e00\u81f4.getResult());
            } else {
                reconciliationUpdate.setResult(ReconciliationResultEnum.\u5bf9\u8d26\u4e00\u81f4.getResult());
            }
            this.reconciliationDao.update(reconciliationUpdate);
            this.reconciliationInfoDao.delRepeat(parkId, startTime);
            for (int row = 1; row < csvList.size(); ++row) {
                String[] oneRow = (String[])csvList.get(row);
                ReconciliationInfo reconciliationInfo = new ReconciliationInfo();
                reconciliationInfo.setParkId(Long.valueOf(parkId));
                reconciliationInfo.setReportDate(startTime);
                reconciliationInfo.setTradeNo(oneRow[0]);
                reconciliationInfo.setLocalOrderNum(oneRow[1]);
                reconciliationInfo.setPayChannel(Integer.valueOf(Integer.parseInt(oneRow[2])));
                reconciliationInfo.setPayWay(Integer.valueOf(Integer.parseInt(oneRow[3])));
                BigDecimal default_price = new BigDecimal(0);
                reconciliationInfo.setLocalPriceTotal(oneRow[4] == null ? default_price : new BigDecimal(Double.parseDouble(oneRow[4]) / 100.0).setScale(2, 5));
                reconciliationInfo.setLocalPricePaid(oneRow[5] == null ? default_price : new BigDecimal(Double.parseDouble(oneRow[5]) / 100.0).setScale(2, 5));
                reconciliationInfo.setLocalPriceDiscount(oneRow[6] == null ? default_price : new BigDecimal(Double.parseDouble(oneRow[6]) / 100.0).setScale(2, 5));
                reconciliationInfo.setLocalActualCash(oneRow[7] == null ? default_price : new BigDecimal(Double.parseDouble(oneRow[7]) / 100.0).setScale(2, 5));
                reconciliationInfo.setLocalRedpackRet(oneRow[8] == null ? default_price : new BigDecimal(Double.parseDouble(oneRow[8]) / 100.0).setScale(2, 5));
                reconciliationInfo.setPayTime(oneRow[9] == null ? null : Integer.valueOf(Integer.parseInt(oneRow[9])));
                if (reconciliationInfo.getOrderNum() != null && ObjectResponse.isSuccess((Response)(orderInfoObjectResponse = this.orderService.findByOrderNum(reconciliationInfo.getOrderNum())))) {
                    orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
                    reconciliationInfo.setPlateNum(orderInfo.getPlateNum());
                }
                this.reconciliationInfoDao.insert(reconciliationInfo);
            }
            List<ReconciliationVo> reconciliationVoList = this.reconciliationInfoDao.findBillList(parkId, time, endTime);
            log.info("<\u5bf9\u8d26\u63a5\u53e3> \u5bf9\u8d26\u8be6\u60c5\u67e5\u8be2 \u8bf7\u6c42\u53c2\u6570: {}, {}, {}, \u8fd4\u56de{} \u6761", new Object[]{parkId, time, endTime, reconciliationVoList.size()});
            for (int i = 0; i < reconciliationVoList.size(); ++i) {
                ReconciliationVo reconciliationVo = reconciliationVoList.get(i);
                ReconciliationInfo reconciliationInfo = new ReconciliationInfo();
                BeanUtils.copyProperties((Object)reconciliationVo, (Object)reconciliationInfo);
                reconciliationInfo.setPlatformPriceTotal(reconciliationVo.getTotalPrice());
                reconciliationInfo.setPlatformPricePaid(reconciliationVo.getPaidPrice());
                reconciliationInfo.setPlatformPriceDiscount(reconciliationVo.getDiscountPrice());
                reconciliationInfo.setPlatformActualCash(reconciliationVo.getActualCash());
                reconciliationInfo.setPlatformRedpackRet(reconciliationVo.getRedpackRet());
                if (reconciliationInfo.getPlatformPriceTotal() == null && reconciliationInfo.getPlatformPricePaid() == null && reconciliationInfo.getPlatformPriceDiscount() == null) {
                    reconciliationInfo.setResult(ReconciliationInfoResultEnum.\u672c\u5730\u6709\u5e73\u53f0\u65e0.getResult());
                } else if (reconciliationInfo.getLocalPriceTotal() == null && reconciliationInfo.getLocalPricePaid() == null && reconciliationInfo.getLocalPriceDiscount() == null) {
                    reconciliationInfo.setParkId(Long.valueOf(parkId));
                    reconciliationInfo.setReportDate(startTime);
                    reconciliationInfo.setTradeNo(reconciliationVo.getPfTradeNo());
                    reconciliationInfo.setPayTime(reconciliationVo.getPfPayTime());
                    reconciliationInfo.setPayChannel(reconciliationVo.getPfPayChannel());
                    reconciliationInfo.setPayWay(reconciliationVo.getPfPayWay());
                    reconciliationInfo.setResult(ReconciliationInfoResultEnum.\u5e73\u53f0\u6709\u672c\u5730\u65e0.getResult());
                } else if (!(reconciliationInfo.getLocalPriceTotal().equals(reconciliationInfo.getPlatformPriceTotal()) && reconciliationInfo.getLocalPricePaid().equals(reconciliationInfo.getLocalPricePaid()) && reconciliationInfo.getLocalPriceDiscount().equals(reconciliationInfo.getPlatformPriceDiscount()))) {
                    reconciliationInfo.setResult(ReconciliationInfoResultEnum.\u5bf9\u8d26\u4e0d\u4e00\u81f4.getResult());
                } else {
                    reconciliationInfo.setResult(ReconciliationInfoResultEnum.\u5bf9\u8d26\u4e00\u81f4.getResult());
                }
                if (reconciliationInfo.getOrderNum() != null && reconciliationInfo.getPlateNum() == null && ObjectResponse.isSuccess((Response)(orderInfoObjectResponse = this.orderService.findByOrderNum(reconciliationInfo.getOrderNum())))) {
                    orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
                    reconciliationInfo.setPlateNum(orderInfo.getPlateNum());
                }
                if (reconciliationInfo.getResult().equals(ReconciliationInfoResultEnum.\u5e73\u53f0\u6709\u672c\u5730\u65e0.getResult())) {
                    this.reconciliationInfoDao.insert(reconciliationInfo);
                    continue;
                }
                this.reconciliationInfoDao.update(reconciliationInfo);
            }
        }
        catch (Exception ex) {
            log.info("<\u5bf9\u8d26\u63a5\u53e3> \u5f02\u5e38: {}", (Throwable)ex);
            return ObjectResponse.failed((String)"500");
        }
        return ObjectResponse.success();
    }

    private String generateBillPath(String parkCode, String startTime) {
        String[] strings = startTime.split("-");
        String path = parkCode + "/bill/" + strings[0] + strings[1] + "/" + this.getFileName(parkCode, startTime);
        return path;
    }

    private String getFileName(String parkCode, String startTime) {
        return startTime.replace("-", "") + "_" + parkCode + "_BILL_1_0.csv";
    }
}

