/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.ThirdFeeResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.partner.domain.request.ApiBaseRequest;
import com.icetech.sdk.client.OpenClient;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.request.CommonRequest;
import com.icetech.sdk.response.CommonResponse;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.enums.PushServiceEnum;
import java.text.DecimalFormat;
import java.util.Objects;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryThirdFeeServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryThirdFeeServiceImpl.class);

    public ObjectResponse<QueryOrderFeeResponse> getThirdFeeFromUrl(ThirdInfo thirdInfo, ThirdFeeRequest request) {
        String resultString;
        if (Objects.nonNull(thirdInfo.getCUserId())) {
            resultString = this.sendCommonOpenPlatform(thirdInfo, request);
        } else {
            ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
            apiBaseRequest.setServiceName("queryThirdFee");
            apiBaseRequest.setPid(thirdInfo.getPid());
            apiBaseRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            apiBaseRequest.setBizContent((Object)request);
            try {
                apiBaseRequest.setSign(SignTools.sign((Object)apiBaseRequest, (String)thirdInfo.getSecretKey()));
            }
            catch (Exception e) {
                log.warn("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            }
            String jsonString = JsonUtils.toString((Object)apiBaseRequest);
            resultString = HttpTools.postJson((String)thirdInfo.getPushUrl(), (String)jsonString);
        }
        if (resultString != null && resultString.contains("<html>")) {
            return ObjectResponse.failed((String)"408", (String)"\u7b2c\u4e09\u65b9\u670d\u52a1\u8bbf\u95ee\u5185\u5bb9\u975eJSON");
        }
        ObjectResponse thirdFeeResponse = (ObjectResponse)JSON.parseObject((String)resultString, (TypeReference)new TypeReference<ObjectResponse<ThirdFeeResponse>>(){}, (Feature[])new Feature[0]);
        log.info("[\u4e09\u65b9\u8ba1\u8d39] \u53c2\u6570[{}] \u54cd\u5e94[{}]", (Object)request, (Object)resultString);
        if (thirdFeeResponse == null) {
            throw new ResponseBodyException("3001", "\u7b2c\u4e09\u65b9\u8ba1\u8d39\u5931\u8d25");
        }
        if (ObjectResponse.isSuccess((Response)thirdFeeResponse) && thirdFeeResponse.getData() != null) {
            return ObjectResponse.success((Object)this.transformationQueryOrderFeeResponse((ThirdFeeResponse)thirdFeeResponse.getData(), request));
        }
        return ObjectResponse.failed((String)"3001", (String)("\u7b2c\u4e09\u65b9\u8ba1\u8d39\u5931\u8d25" + thirdFeeResponse.getMsg()));
    }

    private String sendCommonOpenPlatform(ThirdInfo thirdInfo, Object obj) {
        try {
            CommonRequest commonRequest = new CommonRequest(PushServiceEnum.\u4e09\u65b9\u8ba1\u8d39.getMethod(), obj);
            OpenClient client = new OpenClient(thirdInfo.getPushUrl(), thirdInfo.getPid(), thirdInfo.getSecretKey());
            CommonResponse response = (CommonResponse)client.execute((BaseRequest)commonRequest);
            log.info("[\u4e09\u65b9\u8ba1\u8d39] \u8fd4\u56de\u4fe1\u606f[{}]", (Object)response.getBody());
            return response.getBody();
        }
        catch (Exception e) {
            return JsonUtils.toString((Object)ObjectResponse.failed((String)"500"));
        }
    }

    private QueryOrderFeeResponse transformationQueryOrderFeeResponse(ThirdFeeResponse thirdFeeResponse, ThirdFeeRequest thirdFeeRequest) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(thirdFeeRequest.getOrderNum());
        queryOrderFeeResponse.setPlateNum(thirdFeeRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(Long.valueOf(thirdFeeRequest.getEnterTime() == null ? DateTools.unixTimestamp() : thirdFeeRequest.getEnterTime()));
        queryOrderFeeResponse.setCarType(thirdFeeRequest.getCarType());
        queryOrderFeeResponse.setParkTime(Long.valueOf(thirdFeeRequest.getExitTime() - queryOrderFeeResponse.getEnterTime()));
        queryOrderFeeResponse.setTotalAmount(TextUtils.isEmpty((CharSequence)thirdFeeResponse.getTotalPrice()) ? "0.00" : thirdFeeResponse.getTotalPrice());
        queryOrderFeeResponse.setDiscountAmount("0.00");
        queryOrderFeeResponse.setDiscountPrice(TextUtils.isEmpty((CharSequence)thirdFeeResponse.getDiscountPrice()) ? "0.00" : thirdFeeResponse.getDiscountPrice());
        queryOrderFeeResponse.setUnpayPrice("1".equals(thirdFeeResponse.getIsNeedPay()) ? new DecimalFormat("#0.00").format(Double.valueOf(thirdFeeResponse.getNeedPayPrice())) : "0.00");
        queryOrderFeeResponse.setQueryTime(thirdFeeRequest.getExitTime());
        String needPayPrice = thirdFeeResponse.getNeedPayPrice();
        if (StrUtil.isEmpty((CharSequence)needPayPrice) || NumberUtils.toDouble((String)needPayPrice) == 0.0) {
            queryOrderFeeResponse.setStatus(Integer.valueOf(1));
        } else {
            queryOrderFeeResponse.setStatus(Integer.valueOf(2));
        }
        return queryOrderFeeResponse;
    }
}

