/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.QueryExitPlateNumService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.QueryExitPlateNumResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.impl.AlarmServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryExitPlateNumServiceImpl
extends AbstractService
implements QueryExitPlateNumService {
    private static final Logger log = LoggerFactory.getLogger(QueryExitPlateNumServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private AlarmServiceImpl alarmService;
    @Autowired
    private OrderDiscountService orderDiscountService;

    public ObjectResponse<QueryExitPlateNumResponse> query(String parkCode, String channelId) {
        if (StringUtils.isBlank((CharSequence)parkCode) || StringUtils.isBlank((CharSequence)channelId)) {
            return ObjectResponse.failed((String)"400");
        }
        CarExitRequest exit = this.cacheHandle.getExit(parkCode, channelId);
        if (exit == null) {
            return ObjectResponse.failed((String)"3008");
        }
        if (exit.getAllowExit() != null && !exit.getAllowExit().booleanValue()) {
            return ObjectResponse.failed((String)"406", (String)"\u5f53\u524d\u901a\u9053\u7981\u6b62\u4e34\u65f6\u8f66\u51fa\u573a");
        }
        String orderNum = exit.getOrderNum();
        String plateNum = exit.getPlateNum();
        if (DataCommonConstants.isNoPlate((String)plateNum)) {
            log.info("[\u67e5\u8be2\u51fa\u53e3\u5f53\u524d\u8f66\u8f86\u548c\u8d39\u7528\u4fe1\u606f] \u672a\u8bc6\u522b\u8f66\u724c\u8fd4\u56de, parkCode:{}, channelId:{}", (Object)parkCode, (Object)channelId);
            this.alarmService.queryFeeFailHandler(parkCode, exit.getParkId(), channelId);
            return ObjectResponse.failed((String)"3008");
        }
        if (StringUtils.isNotBlank((CharSequence)orderNum) && StringUtils.isNotBlank((CharSequence)plateNum)) {
            QueryExitPlateNumResponse queryExitPlateNumResponse = new QueryExitPlateNumResponse();
            queryExitPlateNumResponse.setPlateNum(plateNum);
            queryExitPlateNumResponse.setOrderNum(orderNum);
            queryExitPlateNumResponse.setExitTime(exit.getExitTime());
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(parkCode, channelId);
            if (channelFee != null && channelFee.getPlateNum().equals(plateNum)) {
                boolean sendDiscountAfterIdentify;
                queryExitPlateNumResponse.setCacheFee(channelFee);
                OrderDiscount orderDiscount = new OrderDiscount();
                orderDiscount.setOrderNum(orderNum);
                orderDiscount.setStatus(Integer.valueOf(0));
                ObjectResponse list = this.orderDiscountService.findList(orderDiscount);
                if (list.getData() != null && (sendDiscountAfterIdentify = ((List)list.getData()).stream().anyMatch(orderDiscount1 -> orderDiscount1.getSendTime() != null && orderDiscount1.getSendTime().getTime() / 1000L > channelFee.getQueryTime()))) {
                    queryExitPlateNumResponse.setCacheFee(null);
                }
            } else if (channelFee != null) {
                log.info("[\u67e5\u8be2\u51fa\u53e3\u5f53\u524d\u8f66\u8f86\u548c\u8d39\u7528\u4fe1\u606f] \u51fa\u53e3\u8f66\u8f86\u4fe1\u606f\u7f13\u5b58\u4e2d\u7684\u8f66\u724c\u548c\u51fa\u53e3\u8d39\u7528\u4fe1\u606f\u7f13\u5b58\u4e2d\u7684\u8f66\u724c\u53f7\u4e0d\u540c\uff0c\u524d\uff1a{}\uff0c\u540e\uff1a{}", (Object)plateNum, (Object)channelFee.getPlateNum());
            }
            return ObjectResponse.success((Object)queryExitPlateNumResponse);
        }
        this.alarmService.queryFeeFailHandler(parkCode, exit.getParkId(), channelId);
        return ObjectResponse.failed((String)"404");
    }
}

