/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.IPncWsOperService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.response.pnc.PncBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.impl.TaskCenterServiceImpl;
import com.icetech.third.dao.send.SendinfoRecordDao;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class PncWsOperServiceImpl
implements IPncWsOperService {
    private static final Logger log = LoggerFactory.getLogger(PncWsOperServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TaskCenterServiceImpl taskCenterService;
    @Autowired
    private SendinfoRecordDao sendinfoRecordDao;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public boolean connection(Map<String, Object> conInfo) {
        String parkCode = (String)conInfo.get("parkCode");
        String timestamp = (String)conInfo.get("timestamp");
        String channelCode = (String)conInfo.get("channelId");
        if (StringUtils.isBlank((CharSequence)parkCode) || StringUtils.isNotBlank((CharSequence)timestamp)) {
            return false;
        }
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return false;
        }
        Park park = (Park)byParkCode.getData();
        try {
            boolean verifyResult = SignTools.verifyMD5Sign(conInfo, (String)park.getKey());
            if (!verifyResult) {
                return false;
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return false;
        }
        ObjectResponse parkConfigResponse = this.parkService.getParkConfig(parkCode);
        if (!ObjectResponse.isSuccess((Response)parkConfigResponse)) {
            return false;
        }
        ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
            if (!"0".equals(channelCode)) {
                ObjectResponse channelInfo = this.parkService.getInOutDeviceByCode(park.getId(), channelCode);
                if (channelInfo != null && channelInfo.getData() != null) {
                    return true;
                }
                log.info("<\u7aef\u7f51\u4e91ws\u534f\u8bae\u8fde\u63a5> \u6839\u636eparkCode:{}\u548cdeviceNo:{}\u672a\u67e5\u8be2\u5230\u8bbe\u5907\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fde\u63a5", (Object)parkCode, (Object)channelCode);
                return false;
            }
            this.redisUtils.set("PNC_HEART_PROFILE_" + parkCode, (Object)System.currentTimeMillis(), 180L);
            return true;
        }
        log.info("<ws\u534f\u8bae\u8fde\u63a5> \u8fde\u63a5\u6a21\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u4e3a\u7aef\u7f51\u4e91\u6a21\u5f0f\uff0cparkCode\uff1a{}", (Object)parkCode);
        return false;
    }

    public String redirect(String clientName, String params) {
        String[] clientNameArr = clientName.split("_");
        PncBaseResponse pncBaseResponse = (PncBaseResponse)JsonUtils.parseObject((String)params, PncBaseResponse.class, (Class[])new Class[0]);
        String serviceName = pncBaseResponse.getServiceName();
        if ("parkStatusWs".equals(serviceName)) {
            pncBaseResponse.setCode(Integer.valueOf(200));
            pncBaseResponse.setSign("");
            this.pushAll(clientName, JsonUtils.toString((Object)pncBaseResponse));
            this.redisUtils.set("PNC_HEART_PROFILE_" + pncBaseResponse.getParkCode(), (Object)System.currentTimeMillis(), 180L);
            log.info("<\u7aef\u7f51\u4e91> \u5ba2\u6237\u7aef:{}\u4e0a\u62a5\u5fc3\u8df3\uff0c\u56de\u590d\uff1a{}", (Object)clientNameArr[0], (Object)JsonUtils.toString((Object)pncBaseResponse));
        } else {
            ObjectResponse objectResponse = new ObjectResponse();
            Object data = pncBaseResponse.getData();
            if (!Objects.isNull(data)) {
                objectResponse.setData((Object)JsonUtils.toString((Object)data));
            }
            objectResponse.setMsg(pncBaseResponse.getMsg());
            objectResponse.setCode(String.valueOf(pncBaseResponse.getCode()));
            this.redisUtils.set("RESP_MSG_" + pncBaseResponse.getMessageId(), (Object)objectResponse);
            log.info("<\u7aef\u7f51\u4e91> \u5ba2\u6237\u7aef:{}\u56de\u590d\u6807\u8bc6\uff1a{},\u5b58\u5165redis\u6210\u529f", (Object)clientNameArr[0], (Object)pncBaseResponse.getMessageId());
            if ("notifyPrepay".equals(serviceName)) {
                log.info("<\u7aef\u7f51\u4e91> \u5ba2\u6237\u7aef:{}\u56de\u590d\u6807\u8bc6\uff1a{},\u5b58\u5165redis\u6210\u529f", (Object)clientNameArr[0], (Object)pncBaseResponse.getMessageId());
                Integer serviceType = DownServiceEnum.getServiceType((String)serviceName);
                SendInfoRecord sendinfoRecord = this.sendinfoRecordDao.selectOneByMsgId(pncBaseResponse.getMessageId(), SendOperTypeEnum.\u8bf7\u6c42.getOperType().intValue());
                Integer serviceId = sendinfoRecord.getServiceId() == null ? null : Integer.valueOf(sendinfoRecord.getServiceId().intValue());
                String notify = this.taskCenterService.notify(serviceType, serviceId);
                log.info("<\u7aef\u7f51\u4e91 ws> \u9884\u7f34\u8d39\u901a\u77e5taskcenter\u7ed3\u679c\uff1a{}", (Object)notify);
            }
        }
        return JsonUtils.toString((Object)pncBaseResponse);
    }

    public void init(String clientName) {
    }

    public boolean pushAll(String clientName, String content) {
        try {
            content = clientName + content;
            this.stringRedisTemplate.convertAndSend("pncwebsocket", (Object)content);
        }
        catch (Exception e) {
            log.error("<redis\u5e7f\u64ad\u53d1\u9001> clientName\uff1a{} \u5e7f\u64ad\u5931\u8d25", (Object)clientName, (Object)e);
            return false;
        }
        return true;
    }
}

