/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.park.ParkSignPlateService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.dao.ParkSignPlateDao;
import com.icetech.park.domain.entity.park.ParkSignPlate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkSignPlateServiceImpl
implements ParkSignPlateService {
    private static final Logger log = LoggerFactory.getLogger(ParkSignPlateServiceImpl.class);
    @Autowired
    private ParkSignPlateDao parkSignPlateDao;

    public ObjectResponse addPlateSign(ParkSignPlate parkSignPlate) {
        try {
            ParkSignPlate parkSignPlate1 = this.parkSignPlateDao.selectByRequestId(parkSignPlate.getRequestId());
            if (Objects.nonNull(parkSignPlate1)) {
                return ObjectResponse.success();
            }
            ParkSignPlate parkSignPlate2 = this.parkSignPlateDao.selectByPalteNum(parkSignPlate.getParkCode(), parkSignPlate.getPlateNum());
            if (Objects.nonNull(parkSignPlate2)) {
                parkSignPlate2.setNoSense(parkSignPlate.getNoSense());
                parkSignPlate2.setDeparturePay(parkSignPlate.getDeparturePay());
                parkSignPlate2.setMoneyLimit(parkSignPlate.getMoneyLimit());
                this.parkSignPlateDao.update(parkSignPlate2);
            } else {
                this.parkSignPlateDao.insert(parkSignPlate);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5931\u8d25: {}. parkSignPlate[{}]", new Object[]{e.getMessage(), parkSignPlate, e});
            return ObjectResponse.failed((String)"500");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<ParkSignPlate> selectPlateSign(String parkCode, String plateNum) {
        ParkSignPlate parkSignPlate = this.parkSignPlateDao.selectByPalteNum(parkCode, plateNum);
        if (Objects.nonNull(parkSignPlate)) {
            return ObjectResponse.success((Object)parkSignPlate);
        }
        return ObjectResponse.failed((String)"404");
    }
}

