/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.ParkRemoteConfigService;
import com.icetech.park.dao.ParkRemoteconfigDao;
import com.icetech.park.domain.entity.park.ParkRemoteConfig;
import com.icetech.redis.handle.RedisHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ParkRemoteConfigServiceImpl
implements ParkRemoteConfigService {
    private static final Logger log = LoggerFactory.getLogger(ParkRemoteConfigServiceImpl.class);
    @Resource
    private ParkRemoteconfigDao parkRemoteConfigDao;
    @Resource
    private RedisHandle redisHandle;

    public List<ParkRemoteConfig> selectByParkId(long parkId, int enexType) {
        String cacheKey = "park:remote_config:park:" + parkId;
        List configs = this.redisHandle.getListFromMap(cacheKey, String.valueOf(enexType), ParkRemoteConfig.class, this.cacheRemoteConfig(parkId), 604800000L);
        return configs;
    }

    public Map<String, List<ParkRemoteConfig>> getRemoteConfigMapByPark(long parkId) {
        String cacheKey = "park:remote_config:park:" + parkId;
        return this.redisHandle.cacheListMap(cacheKey, ParkRemoteConfig.class, this.cacheRemoteConfig(parkId), 604800000L);
    }

    private Supplier<Map<String, List<ParkRemoteConfig>>> cacheRemoteConfig(long parkId) {
        return () -> {
            ParkRemoteConfig param = new ParkRemoteConfig();
            param.setParkId(Long.valueOf(parkId));
            List configs = this.parkRemoteConfigDao.selectList((Wrapper)Wrappers.lambdaQuery((Object)param));
            Map<String, List<ParkRemoteConfig>> typeMap = null;
            if (CollectionUtils.isNotEmpty((Collection)configs)) {
                typeMap = configs.stream().collect(Collectors.groupingBy(config -> config.getEnexType().toString()));
            }
            return typeMap;
        };
    }
}

