/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.github.pagehelper.PageHelper;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.CallLogRequest;
import com.icetech.cloudcenter.domain.request.QueryCallLogRequest;
import com.icetech.cloudcenter.domain.response.ParkCallLogDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.ParkCallLogDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkCallLog;
import com.icetech.park.service.ParkCallLogService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkCallLogServiceImpl
implements ParkCallLogService {
    private static final Logger log = LoggerFactory.getLogger(ParkCallLogServiceImpl.class);
    @Autowired
    private ParkCallLogDao parkCallLogDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDao parkDao;

    @Override
    public ObjectResponse countCallLogList(QueryCallLogRequest queryCallLogRequest) {
        try {
            String[] split = queryCallLogRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = null;
            String endTime = null;
            if (!Objects.isNull(queryCallLogRequest.getStartTime())) {
                startTime = simpleDateFormat.format(queryCallLogRequest.getStartTime());
            }
            if (!Objects.isNull(queryCallLogRequest.getEndTime())) {
                endTime = simpleDateFormat.format(queryCallLogRequest.getEndTime());
            }
            Integer status = queryCallLogRequest.getStatus();
            if (!Objects.isNull(queryCallLogRequest.getStatus()) && queryCallLogRequest.getStatus() == 0) {
                status = null;
            }
            int count = this.parkCallLogDao.countCallLogList(parkid, status, Objects.isNull(startTime) ? null : startTime, Objects.isNull(endTime) ? null : endTime, queryCallLogRequest.getDirection());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25: {}. queryCallLogRequest[{}]", new Object[]{e.getMessage(), queryCallLogRequest, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<List<ParkCallLogDto>> getCallLogList(QueryCallLogRequest queryCallLogRequest) {
        try {
            List<ParkCallLog> parkCallLogs;
            String[] split = queryCallLogRequest.getParkCode().split(",");
            String parkid = this.parkDao.selectByCodes(split);
            PageHelper.startPage((int)queryCallLogRequest.getPageNo(), (int)queryCallLogRequest.getPageSize());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = null;
            String endTime = null;
            if (!Objects.isNull(queryCallLogRequest.getStartTime())) {
                startTime = simpleDateFormat.format(queryCallLogRequest.getStartTime());
            }
            if (!Objects.isNull(queryCallLogRequest.getEndTime())) {
                endTime = simpleDateFormat.format(queryCallLogRequest.getEndTime());
            }
            Integer status = queryCallLogRequest.getStatus();
            if (!Objects.isNull(queryCallLogRequest.getStatus()) && queryCallLogRequest.getStatus() == 0) {
                status = null;
            }
            if (CollectionUtils.isEmpty(parkCallLogs = this.parkCallLogDao.selectCallLogList(parkid, status, Objects.isNull(startTime) ? null : startTime, Objects.isNull(endTime) ? null : endTime, queryCallLogRequest.getDirection()))) {
                return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
            }
            ArrayList<ParkCallLogDto> list = new ArrayList<ParkCallLogDto>(parkCallLogs.size());
            for (int i = 0; i < parkCallLogs.size(); ++i) {
                ParkCallLogDto parkCallLogDto = new ParkCallLogDto();
                ParkCallLog parkCallLog = parkCallLogs.get(i);
                Park park = (Park)this.parkService.findByParkId(parkCallLog.getParkId()).getData();
                parkCallLogDto.setId(parkCallLog.getId());
                parkCallLogDto.setParkName(park.getParkName());
                parkCallLogDto.setCallTime(simpleDateFormat.format(parkCallLog.getCreateTime()));
                ObjectResponse channelResp = this.parkService.getInoutDeviceByCode(parkCallLog.getAisleCode());
                if (ObjectResponse.isSuccess((Response)channelResp)) {
                    parkCallLogDto.setAisleName(((ParkInoutdevice)channelResp.getData()).getInandoutName());
                }
                if (parkCallLog.getDirection() == 1) {
                    parkCallLogDto.setDirection("\u547c\u5165");
                } else {
                    parkCallLogDto.setDirection("\u547c\u51fa");
                }
                int time = parkCallLog.getCallTime().intValue();
                if (time >= 60) {
                    parkCallLogDto.setCallTimeStr(DateTools.secondToSecondsTime((int)time));
                } else {
                    parkCallLogDto.setCallTimeStr(time + "\u79d2");
                }
                parkCallLogDto.setOperAccount(parkCallLog.getOperAccount());
                parkCallLogDto.setStatus(parkCallLog.getStatus());
                list.add(parkCallLogDto);
            }
            return ObjectResponse.success(list);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25: {}. queryCallLogRequest[{}]", new Object[]{e.getMessage(), queryCallLogRequest, e});
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode());
        }
    }

    @Override
    public ObjectResponse addCallLog(CallLogRequest callLogRequest) {
        int result;
        Park park = (Park)this.parkService.findByParkCode(callLogRequest.getParkCode()).getData();
        ParkCallLog hislog = this.parkCallLogDao.selectByCode(callLogRequest.getMessageCode());
        ParkCallLog parkCallLog = new ParkCallLog();
        if (Objects.isNull(hislog)) {
            if (callLogRequest.getDirection() == 2) {
                parkCallLog.setStatus(Integer.valueOf(1));
            } else {
                parkCallLog.setStatus(Integer.valueOf(3));
            }
            parkCallLog.setMessageCode(callLogRequest.getMessageCode());
            parkCallLog.setAisleCode(callLogRequest.getAisleCode());
            parkCallLog.setParkId(park.getId());
            parkCallLog.setCreateTime(new Date());
            parkCallLog.setDeviceNumber(callLogRequest.getDeviceCode());
            parkCallLog.setDirection(callLogRequest.getDirection());
            parkCallLog.setOperAccount(callLogRequest.getOperAccount());
            parkCallLog.setChannelType(callLogRequest.getChannelType());
            result = this.parkCallLogDao.insert(parkCallLog);
        } else {
            if (callLogRequest.getDirection() == 2) {
                hislog.setCallTime(Long.valueOf((System.currentTimeMillis() - hislog.getCreateTime().getTime()) / 1000L));
                hislog.setUpdateTime(new Date());
            } else {
                if (callLogRequest.getAction() == 1) {
                    hislog.setUpdateTime(new Date());
                    hislog.setStatus(Integer.valueOf(2));
                }
                if (callLogRequest.getAction() == 2) {
                    if (Objects.isNull(hislog.getUpdateTime())) {
                        hislog.setCallTime(Long.valueOf(0L));
                    } else {
                        hislog.setCallTime(Long.valueOf((System.currentTimeMillis() - hislog.getUpdateTime().getTime()) / 1000L));
                    }
                }
            }
            result = this.parkCallLogDao.update(hislog);
        }
        if (result > 0) {
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode());
    }

    @Override
    public ObjectResponse<Boolean> saveCallLog(ParkCallLog parkCallLog) {
        return ObjectResponse.success((Object)(this.parkCallLogDao.insert(parkCallLog) == 1 ? 1 : 0));
    }
}

