/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.utils.Spring;
import com.icetech.cloudcenter.api.IP2cWsOperService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ReportCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.p2c.RegisterDeviceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RegisterDeviceResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.handle.P2cOperHandle;
import com.icetech.park.service.impl.DualCameraServiceImpl;
import com.icetech.park.service.report.CallService;
import com.icetech.park.service.report.p2c.impl.RegisterDeviceServiceImpl;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class P2cWsOperServiceImpl
implements IP2cWsOperService {
    private static final Logger log = LoggerFactory.getLogger(P2cWsOperServiceImpl.class);
    @Autowired
    private DualCameraServiceImpl dualCameraService;
    @Autowired
    private P2cOperHandle p2cOperHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    private static String CUSTOM_PARKS = "";

    public boolean checkDevice(String serialNumber) {
        try {
            ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (ObjectResponse.isSuccess((Response)parkDeviceResp) && parkDeviceResp.getData() != null && ((ParkDevice)parkDeviceResp.getData()).getType() == 1) {
                ObjectResponse parkConfigResponse = this.parkService.getParkConfig(Long.valueOf(((ParkDevice)parkDeviceResp.getData()).getParkId()));
                ObjectResponse.notError((Response)parkConfigResponse);
                ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
                if (!DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
                    return true;
                }
                log.info("<ws\u534f\u8bae\u8fde\u63a5> \u8fde\u63a5\u6a21\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u4e3a\u7aef\u7f51\u4e91\u6a21\u5f0f\uff0cparkId\uff1a{}", (Object)((ParkDevice)parkDeviceResp.getData()).getParkId());
                return false;
            }
            log.info("<ws\u534f\u8bae\u8fde\u63a5> \u6839\u636eserialNumber: {}\u672a\u67e5\u8be2\u5230\u8bbe\u5907\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fde\u63a5", (Object)serialNumber);
            return false;
        }
        catch (Exception e) {
            log.error("[ws\u534f\u8bae\u8fde\u63a5]clientName[{}]", (Object)serialNumber, (Object)e);
            return false;
        }
    }

    public String checkAndGetPark(String serialNumber) {
        try {
            ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (ObjectResponse.isSuccess((Response)parkDeviceResp) && parkDeviceResp.getData() != null && ((ParkDevice)parkDeviceResp.getData()).getType() == 1) {
                ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
                ObjectResponse parkConfigResponse = this.parkService.getParkConfig(Long.valueOf(parkDevice.getParkId()));
                ObjectResponse.notError((Response)parkConfigResponse);
                ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
                if (!DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
                    ObjectResponse parkObjectResponse = this.parkService.findByParkId(Long.valueOf(parkDevice.getParkId()));
                    return ((Park)parkObjectResponse.getData()).getParkCode();
                }
                log.info("<ws\u534f\u8bae\u8fde\u63a5> \u8fde\u63a5\u6a21\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u4e3a\u7aef\u7f51\u4e91\u6a21\u5f0f\uff0cparkId\uff1a{}", (Object)((ParkDevice)parkDeviceResp.getData()).getParkId());
                return null;
            }
            log.info("<ws\u534f\u8bae\u8fde\u63a5> \u6839\u636eserialNumber: {}\u672a\u67e5\u8be2\u5230\u8bbe\u5907\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fde\u63a5", (Object)serialNumber);
            return null;
        }
        catch (Exception e) {
            log.error("[ws\u534f\u8bae\u8fde\u63a5]clientName[{}]", (Object)serialNumber, (Object)e);
            return null;
        }
    }

    public String redirect(String clientName, String params) {
        return this.redirect(clientName, params, null);
    }

    public String redirect(String clientName, String params, String versionFromUrl) {
        P2cBaseResponse p2CBaseResponse;
        String cmd;
        JSONObject stringObjectMap;
        if (clientName == null) {
            return JsonUtils.toString((Object)ObjectResponse.failed((String)"400"));
        }
        String[] clientNameArr = clientName.split("_");
        try {
            stringObjectMap = JSONObject.parseObject((String)params);
            cmd = stringObjectMap.getString("cmd");
            if (StringUtils.isBlank((CharSequence)cmd)) {
                return this.unnormalRet((Map<String, Object>)stringObjectMap, cmd, CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
            }
        }
        catch (Exception e) {
            log.info("clientName\uff1a{}\uff0c\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a{}", (Object)clientName, (Object)params);
            JSONObject stringObjectMap2 = new JSONObject();
            return this.unnormalRet((Map<String, Object>)stringObjectMap2, null, CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode());
        }
        cmd = cmd.trim();
        String messageId = stringObjectMap.getString("messageId");
        try {
            if ("register_device".equals(cmd)) {
                RegisterDeviceRequest registerDeviceRequest = (RegisterDeviceRequest)stringObjectMap.toJavaObject(RegisterDeviceRequest.class);
                P2cBaseResponse<RegisterDeviceResponse> p2CBaseResponse2 = ((RegisterDeviceServiceImpl)Spring.getBean(RegisterDeviceServiceImpl.class)).execute(registerDeviceRequest);
                return JsonUtils.toString(p2CBaseResponse2);
            }
            String parkCode = clientNameArr[0];
            String sn = clientNameArr[1];
            TokenDeviceVo deviceToken = this.p2cOperHandle.getAndCacheDevice(sn, TokenDeviceVo.ProtocolTypeEnum.WS);
            if (versionFromUrl == null || P2cVersionEnum.getIndex((String)versionFromUrl) < P2cVersionEnum.\u7248\u672c8.getIndex()) {
                String token = stringObjectMap.getString("token");
                String cloudToken = deviceToken.getToken();
                if (token != null && !token.equals(cloudToken)) {
                    log.info("\u76f8\u673a\u4e0a\u62a5token\u5df2\u8fc7\u671f, cmd: {}, messageId: {}, token: {}", new Object[]{cmd, messageId, token});
                    return this.unnormalRet((Map<String, Object>)stringObjectMap, cmd, CodeEnum.\u8ba4\u8bc1\u5931\u8d25.getCode());
                }
            }
            if (cmd.contains("_resp")) {
                cmd = cmd.substring(0, cmd.indexOf("_resp"));
                ResponseService responseService = SendServiceFactory.getP2cBean(cmd, ResponseService.class);
                P2cBaseResponse baseResponse = (P2cBaseResponse)stringObjectMap.toJavaObject(responseService.getGenericType());
                responseService.dealResponse(baseResponse, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getDeviceNo());
                return null;
            }
            CallService callService = SendServiceFactory.getP2cBean(cmd, CallService.class);
            P2cBaseRequest p2cBaseRequest = (P2cBaseRequest)stringObjectMap.toJavaObject(callService.getGenericType());
            if (DingZhiFuncConstants.DZ003_PARKS.contains(parkCode) && DingZhiFuncConstants.DZ003_DEVICES.contains(clientNameArr[1]) && (ReportCmdEnum.\u5165\u573a\u4e0a\u62a5.getCmd().equals(cmd) || ReportCmdEnum.\u79bb\u573a\u4e0a\u62a5.getCmd().equals(cmd))) {
                return this.unnormalRet((Map<String, Object>)stringObjectMap, cmd, CodeEnum.\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728.getCode());
            }
            boolean isDualCamera = false;
            boolean isMaster = deviceToken.isMaster();
            if (CUSTOM_PARKS.contains(parkCode) && (ReportCmdEnum.\u5165\u573a\u4e0a\u62a5.getCmd().equals(p2cBaseRequest.getCmd()) || ReportCmdEnum.\u79bb\u573a\u4e0a\u62a5.getCmd().equals(p2cBaseRequest.getCmd()))) {
                List<ParkConnectedDeviceVo> connectedList = this.cacheHandle.getConnectedList(parkCode, deviceToken.getInandoutCode());
                JSONObject bizContent = stringObjectMap.getJSONObject("bizContent");
                if (connectedList != null && connectedList.size() > 1 && !TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal().equals(bizContent.getInteger("triggerType"))) {
                    isDualCamera = true;
                }
            }
            if (isDualCamera) {
                DualCameraServiceImpl.ResultCode resultCode = this.dualCameraService.preHandle(p2cBaseRequest, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getDeviceNo(), deviceToken.getInandoutCode(), deviceToken.getInandoutType(), isMaster);
                log.info("\u6d88\u606f[{}]: \u901a\u9053\uff1a{}\uff0c\u53cc\u6444\u76f8\u673a\u4e0a\u62a5\u4e8b\u4ef6\uff0c\u5224\u65ad\u7ed3\u679c\uff1a{}", new Object[]{messageId, deviceToken.getInandoutCode(), resultCode.name()});
                p2CBaseResponse = callService.execute(deviceToken, p2cBaseRequest);
                if (resultCode.equals((Object)DualCameraServiceImpl.ResultCode.\u4ece\u76f8\u673a\u8bc6\u522b_\u4e3b\u76f8\u673a\u5728\u7ebf) || resultCode.equals((Object)DualCameraServiceImpl.ResultCode.\u4e3b\u4ece\u90fd\u8bc6\u522b_\u5df2\u5f00\u95f8)) {
                    p2CBaseResponse = this.dualCameraService.afterHandle(p2CBaseResponse, deviceToken.getParkId(), parkCode, deviceToken.getInandoutCode(), deviceToken.getInandoutType(), p2cBaseRequest, resultCode);
                }
            } else {
                p2CBaseResponse = callService.execute(deviceToken, p2cBaseRequest);
            }
        }
        catch (ResponseBodyException ee) {
            return this.unnormalRet((Map<String, Object>)stringObjectMap, cmd, Integer.parseInt(ee.getErrCode()));
        }
        catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), (Throwable)e);
            return this.unnormalRet((Map<String, Object>)stringObjectMap, cmd, CodeEnum.\u670d\u52a1\u5668\u5f02\u5e38.getCode());
        }
        return JsonUtils.toString(p2CBaseResponse);
    }

    private String unnormalRet(Map<String, Object> paramMap, String cmd, int code) {
        P2cBaseResponse p2CBaseResponse = new P2cBaseResponse();
        p2CBaseResponse.setCmd(cmd + "_resp");
        p2CBaseResponse.setMessageId(MapUtils.getString(paramMap, (Object)"messageId"));
        p2CBaseResponse.setToken(MapUtils.getString(paramMap, (Object)"token"));
        p2CBaseResponse.setCode(Integer.valueOf(code));
        p2CBaseResponse.setMsg(CodeEnum.getMsg((Integer)code));
        return JSONObject.toJSONString((Object)p2CBaseResponse);
    }
}

