/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.DiscountUsedDto;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.OrderDiscountDto;
import com.icetech.cloudcenter.domain.response.RechargeDetailDto;
import com.icetech.cloudcenter.domain.response.RechargeListDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.merchant.DiscountDayDao;
import com.icetech.fee.dao.merchant.MerchantDiscountDao;
import com.icetech.fee.dao.merchant.MerchantRechargeDao;
import com.icetech.fee.dao.merchant.ParkMerchantDao;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.fee.domain.entity.merchant.MerchantDiscount;
import com.icetech.fee.domain.entity.merchant.ParkMerchant;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.vo.FindDiscountVo;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="merchantDiscountService")
public class MerchantDiscountServiceImpl
implements MerchantDiscountService {
    private static final Logger log = LoggerFactory.getLogger(MerchantDiscountServiceImpl.class);
    @Autowired
    private MerchantDiscountDao merchantDiscountDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private ParkMerchantDao parkMerchantDao;
    @Autowired
    private MerchantRechargeDao merchantRechargeDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private DiscountDayDao discountDayDao;
    @Autowired
    private ParkConfigDao parkConfigDao;

    public ObjectResponse<List<MerchantDiscountDto>> getDiscountTemplate(Long merchantId) {
        ArrayList dtos = Lists.newArrayList();
        List discounts = this.merchantDiscountDao.selectByMerchantId(merchantId);
        if (!CollectionUtils.isEmpty((Collection)discounts)) {
            MerchantDiscount merchantDiscount1 = (MerchantDiscount)discounts.get(0);
            long parkId = merchantDiscount1.getParkId();
            ParkConfig parkConfig = this.parkConfigDao.selectByParkId(parkId);
            String units = parkConfig.getMoneyunitType();
            discounts.forEach(merchantDiscount -> {
                MerchantDiscountDto merchantDiscountDto = new MerchantDiscountDto();
                BeanUtils.copyProperties((Object)merchantDiscount, (Object)merchantDiscountDto);
                merchantDiscountDto.setParkName(((Park)this.parkService.findByParkId(merchantDiscountDto.getParkId()).getData()).getParkName());
                merchantDiscountDto.setUnits(units);
                dtos.add(merchantDiscountDto);
            });
        }
        return ObjectResponse.success((Object)dtos);
    }

    public ObjectResponse<MerchantDiscountDto> getDayDiscountTemplate(Long merchantId) {
        MerchantDiscount discount = this.merchantDiscountDao.selectDayDisByMerchantId(merchantId);
        if (Objects.nonNull(discount)) {
            long parkId = discount.getParkId();
            ParkConfig parkConfig = this.parkConfigDao.selectByParkId(parkId);
            MerchantDiscountDto merchantDiscountDto = new MerchantDiscountDto();
            BeanUtils.copyProperties((Object)discount, (Object)merchantDiscountDto);
            merchantDiscountDto.setParkName(((Park)this.parkService.findByParkId(merchantDiscountDto.getParkId()).getData()).getParkName());
            merchantDiscountDto.setUnits(parkConfig.getMoneyunitType());
            merchantDiscountDto.setAmountDay(discount.getAmountday());
            return ObjectResponse.success((Object)merchantDiscountDto);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<MerchantDiscountDto> findMerchantDiscountById(Long disId) {
        MerchantDiscount merchantDiscount = this.merchantDiscountDao.findById(disId);
        if (Objects.isNull(merchantDiscount)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)CodeConstantsEnum.ERROR_404.getDesc());
        }
        MerchantDiscountDto merchantDiscountDto = new MerchantDiscountDto();
        BeanUtils.copyProperties((Object)merchantDiscount, (Object)merchantDiscountDto);
        return ObjectResponse.success((Object)merchantDiscountDto);
    }

    public ObjectResponse<List<OrderDiscountDto>> findDiscountRecords(FindDiscountVo vo) {
        List orderDiscounts;
        log.info("\u67e5\u8be2\u4f18\u60e0\u53c2\u6570[{}]", (Object)vo);
        String from = vo.getFrom();
        String to = vo.getTo();
        PageHelper.startPage((int)NumberUtils.toPrimitive((Integer)vo.getPageNo(), (int)1), (int)NumberUtils.toPrimitive((Integer)vo.getPageSize(), (int)10));
        if (StringUtils.isEmpty((CharSequence)from)) {
            from = LocalDateTime.now().minus(Duration.ofDays(1L)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            vo.setFrom(from);
        }
        if (StringUtils.isEmpty((CharSequence)to)) {
            to = DateTools.getFormat((Date)new Date());
            vo.setTo(to);
        }
        if (CollectionUtils.isEmpty((Collection)(orderDiscounts = this.orderDiscountDao.findDiscountRecords(vo)))) {
            return ObjectResponse.success((Object)Lists.newArrayList());
        }
        OrderDiscountDto orderDiscountDto1 = (OrderDiscountDto)orderDiscounts.get(0);
        Long parkId = orderDiscountDto1.getParkId();
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        String moneyunitType = parkConfig.getMoneyunitType();
        orderDiscounts.forEach(orderDiscountDto -> {
            Integer type = orderDiscountDto.getType();
            String typeName = "";
            switch (type) {
                case 1: {
                    typeName = "\u5168\u514d\u5238";
                    break;
                }
                case 2: {
                    typeName = "\u65f6\u957f\u5238";
                    break;
                }
                case 3: {
                    typeName = "\u4ee3\u91d1\u5238";
                    break;
                }
                case 4: {
                    typeName = "\u6298\u6263\u5238";
                    break;
                }
                case 5: {
                    typeName = "\u6309\u5929\u4f18\u514d\u5238";
                    break;
                }
            }
            orderDiscountDto.setTypeStr(typeName);
            orderDiscountDto.setUnits(moneyunitType);
        });
        return ObjectResponse.success((Object)orderDiscounts);
    }

    public ObjectResponse<DiscountUsedDto> findDiscountUsedRecords(FindDiscountVo vo) {
        DiscountUsedDto discountUsedDto = new DiscountUsedDto();
        discountUsedDto.setTotalDiscountPrice("0.0");
        ObjectResponse<List<OrderDiscountDto>> discountRecords = this.findDiscountRecords(vo);
        if (ObjectResponse.isSuccess(discountRecords)) {
            List data = (List)discountRecords.getData();
            discountUsedDto.setList(data);
            double sum = data.stream().mapToDouble(d -> NumberUtils.parseDouble((Object)d.getGetAmount())).sum();
            discountUsedDto.setTotalDiscountPrice(String.valueOf(sum));
        }
        return ObjectResponse.success((Object)discountUsedDto);
    }

    public ObjectResponse<OrderDiscountDto> findDiscountRecord(Long id) {
        DiscountDay discountDay;
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(id);
        orderDiscount = (OrderDiscount)this.orderDiscountDao.selectLimitOne((Object)orderDiscount);
        if (Objects.isNull(orderDiscount)) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)CodeConstantsEnum.ERROR_404.getDesc());
        }
        OrderDiscountDto orderDiscountDto = new OrderDiscountDto();
        BeanUtils.copyProperties((Object)orderDiscount, (Object)orderDiscountDto);
        orderDiscountDto.setSendTime(DateTools.getFormat((Date)orderDiscount.getSendTime()));
        ParkMerchant parkMerchant = new ParkMerchant();
        parkMerchant.setId(Integer.valueOf(Math.toIntExact(orderDiscount.getMerchantId())));
        parkMerchant = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
        orderDiscountDto.setMerchantName(Objects.isNull(parkMerchant) ? "" : parkMerchant.getName());
        Park park = (Park)this.parkService.findByParkId(orderDiscountDto.getParkId()).getData();
        orderDiscountDto.setParkName(Objects.isNull(park) ? "" : park.getParkName());
        Integer type = orderDiscountDto.getType();
        ParkConfig parkConfig = this.parkConfigDao.selectByParkId(orderDiscountDto.getParkId().longValue());
        String amount = orderDiscountDto.getAmount();
        switch (type) {
            case 2: {
                amount = amount + "\u5206\u949f";
                break;
            }
            case 3: {
                amount = amount + parkConfig.getMoneyunitType();
                break;
            }
            case 4: {
                amount = amount + "\u6298";
                break;
            }
        }
        orderDiscountDto.setAmount(amount);
        if (type == 5 && Objects.nonNull(discountDay = this.discountDayDao.selectDiscountDay(orderDiscount.getDiscountNo(), Long.valueOf(parkMerchant.getParkId())))) {
            orderDiscountDto.setStartTime(DateTools.getFormat((Date)discountDay.getStartTime()));
            orderDiscountDto.setEndTime(DateTools.getFormat((Date)discountDay.getEndTime()));
        }
        return ObjectResponse.success((Object)orderDiscountDto);
    }

    public ObjectResponse<List<RechargeListDto>> findRechargeList(Long merchantId, Integer selectType, String yearMonth, String startDate, String endDate, List<Integer> rechargeTypes, List<Integer> payWays) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("merchantId", merchantId);
        paraMap.put("yearMonth", yearMonth);
        paraMap.put("startDate", startDate);
        paraMap.put("endDate", endDate);
        paraMap.put("rechargeTypes", rechargeTypes);
        paraMap.put("payWays", payWays);
        ParkMerchant parkMerchant = new ParkMerchant();
        parkMerchant.setId(Integer.valueOf(merchantId.intValue()));
        ParkMerchant parkMerchant1 = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
        int parkId = parkMerchant1.getParkId();
        String moneyunitType = this.parkConfigDao.selectByParkId((long)parkId).getMoneyunitType();
        if (selectType == null) {
            List rechargeListDtos = this.merchantRechargeDao.countMonth(paraMap);
            for (RechargeListDto rechargeListDto : rechargeListDtos) {
                String yearMonth2 = rechargeListDto.getYearMonth();
                String newMonth = yearMonth2.replace("\u5e74", "-").replace("\u6708", "");
                paraMap.put("yearMonth", newMonth);
                List details = this.merchantRechargeDao.monthRecharge(paraMap);
                rechargeListDto.setDetails(details);
                rechargeListDto.setUnits(moneyunitType);
            }
            return ObjectResponse.success((Object)rechargeListDtos);
        }
        if (selectType == 1) {
            List rechargeListDtos = this.merchantRechargeDao.countMonth(paraMap);
            if (rechargeListDtos != null && rechargeListDtos.size() > 0) {
                RechargeListDto rechargeListDto = (RechargeListDto)rechargeListDtos.get(0);
                List details = this.merchantRechargeDao.monthRecharge(paraMap);
                rechargeListDto.setDetails(details);
                rechargeListDto.setUnits(moneyunitType);
                return ObjectResponse.success((Object)rechargeListDtos);
            }
            return ObjectResponse.failed((String)"404");
        }
        if (selectType == 2) {
            String total = this.merchantRechargeDao.countScope(merchantId, startDate, endDate);
            if (total == null) {
                return ObjectResponse.failed((String)"404");
            }
            RechargeListDto rechargeListDto = new RechargeListDto();
            rechargeListDto.setYearMonth(startDate + "\u81f3" + endDate);
            rechargeListDto.setMonthRechargeAmount(total);
            List details = this.merchantRechargeDao.monthRecharge(paraMap);
            rechargeListDto.setDetails(details);
            rechargeListDto.setUnits(moneyunitType);
            ArrayList<RechargeListDto> list = new ArrayList<RechargeListDto>();
            list.add(rechargeListDto);
            return ObjectResponse.success(list);
        }
        return ObjectResponse.failed((String)"402");
    }

    public ObjectResponse<RechargeDetailDto> findRechargeDetail(Integer recordId) {
        RechargeDetailDto rechargeDetail = this.merchantRechargeDao.findRechargeDetail(recordId);
        if (rechargeDetail == null) {
            return ObjectResponse.failed((String)"404");
        }
        Long parkId = rechargeDetail.getParkId();
        rechargeDetail.setUnits(this.parkConfigDao.selectByParkId(parkId.longValue()).getMoneyunitType());
        return ObjectResponse.success((Object)rechargeDetail);
    }

    public ObjectResponse<MerchantDiscount> findTemplateInfo(Long disId) {
        MerchantDiscount merchantDiscount = this.merchantDiscountDao.findById(disId);
        if (merchantDiscount == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)merchantDiscount);
    }

    public ObjectResponse saveDiscountPlateNum(DiscountDay discountDay) {
        int i = this.discountDayDao.insertSelective(discountDay);
        return ObjectResponse.success();
    }

    public ObjectResponse<DiscountDay> findValidDiscountDay(String plateNum, Long parkId, String payTime) {
        DiscountDay discountDay = this.discountDayDao.selectValidDiscountDay(plateNum, parkId, payTime);
        if (discountDay == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)discountDay);
    }

    public ObjectResponse<DiscountDay> findDiscountDay(String discountNo, Long parkId) {
        DiscountDay discountDay = this.discountDayDao.selectDiscountDay(discountNo, parkId);
        if (discountDay == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)discountDay);
    }

    public ObjectResponse findValidExistedDisCountDay(String plateNum, Long parkId) {
        DiscountDay discountDay = this.discountDayDao.findValidExistedDisCountDay(parkId, plateNum, new Date());
        if (Objects.isNull(discountDay)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)discountDay);
    }

    public ObjectResponse<DiscountDay> findLastDisDayByPlateAndDisId(String plateNum, Long parkId, Long disId) {
        DiscountDay discountDay = this.discountDayDao.findByPlateAndDisId(parkId, plateNum, disId);
        return ObjectResponse.returnNotFoundIfNull((Object)discountDay);
    }

    public ObjectResponse<DiscountDay> findLastDisDayByPlateAndOnceDay(String plateNum, Long parkId) {
        DiscountDay discountDay = this.discountDayDao.findLastDisDayByPlateAndOnceDay(parkId, plateNum);
        return ObjectResponse.returnNotFoundIfNull((Object)discountDay);
    }

    public ObjectResponse<OrderDiscount> findLastDiscountByPlateAndDisId(String plateNum, Long parkId, Long disId) {
        OrderDiscount orderDiscount = this.orderDiscountDao.findByPlateAndDisId(parkId, plateNum, disId);
        return ObjectResponse.returnNotFoundIfNull((Object)orderDiscount);
    }

    public ObjectResponse<OrderDiscount> findLastDiscountByPlateAndOnceDay(String plateNum, Long parkId) {
        OrderDiscount orderDiscount = this.orderDiscountDao.findLastDiscountByPlateAndOnceDay(parkId, plateNum);
        return ObjectResponse.returnNotFoundIfNull((Object)orderDiscount);
    }

    public ObjectResponse checkSpaceNum(Integer merchantId) {
        try {
            ParkMerchant parkMerchant = new ParkMerchant();
            parkMerchant.setId(merchantId);
            parkMerchant = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
            Integer spaceNum = parkMerchant.getSpaceNum();
            if (Objects.isNull(spaceNum)) {
                return ObjectResponse.success((Object)spaceNum);
            }
            log.info("\u5f53\u524d\u5546\u6237[{}]\u53ef\u4f18\u60e0\u8f66\u4f4d\u6570[{}]", (Object)parkMerchant.getName(), (Object)spaceNum);
            if (spaceNum > 0) {
                return ObjectResponse.success((Object)spaceNum);
            }
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)"\u5f53\u524d\u53ef\u4f18\u60e0\u8f66\u4f4d\u6570\u4e3a0");
        }
        catch (Exception e) {
            log.error("[\u4f18\u60e0\u6821\u9a8c\u8f66\u4f4d\u6570]\u5f02\u5e38: {}. merchantId[{}]", new Object[]{e.getMessage(), merchantId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse subDiscountSpaceNum(Integer merchantId) {
        try {
            ParkMerchant parkMerchant = new ParkMerchant();
            parkMerchant.setId(merchantId);
            parkMerchant = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
            Integer spaceNum = parkMerchant.getSpaceNum();
            if (Objects.isNull(spaceNum)) {
                return ObjectResponse.success();
            }
            if (spaceNum > 0) {
                parkMerchant.setSpaceNum(Integer.valueOf(spaceNum - 1));
                log.info("\u5f53\u524d\u5546\u6237[{}]\u6263\u51cf\u8f66\u4f4d\u6570[{}]", (Object)parkMerchant.getName(), (Object)(spaceNum - 1));
                this.parkMerchantDao.update((Object)parkMerchant);
            }
            return ObjectResponse.success();
        }
        catch (Exception e) {
            log.error("[\u4f18\u60e0\u6263\u51cf\u8f66\u4f4d\u6570]\u5f02\u5e38: {}. merchantId[{}]", new Object[]{e.getMessage(), merchantId, e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse addDiscountDaySpaceNum() {
        List discountDays = this.discountDayDao.selectDiscountDayByRelease(null, Long.valueOf(590L));
        discountDays.forEach(discountDay -> {
            if (discountDay != null && System.currentTimeMillis() >= discountDay.getEndTime().getTime()) {
                Integer merchantDisId = discountDay.getMerchantDisId();
                MerchantDiscount merchantDiscount = new MerchantDiscount();
                merchantDiscount.setId(merchantDisId.intValue());
                merchantDiscount = (MerchantDiscount)this.merchantDiscountDao.selectById((Object)merchantDiscount);
                ParkMerchant parkMerchant = new ParkMerchant();
                parkMerchant.setId(Integer.valueOf(Math.toIntExact(merchantDiscount.getMerchantId())));
                parkMerchant = (ParkMerchant)this.parkMerchantDao.selectById((Object)parkMerchant);
                Integer spaceNum = parkMerchant.getSpaceNum();
                if (spaceNum != null) {
                    spaceNum = spaceNum + 1;
                    parkMerchant.setSpaceNum(spaceNum);
                    if (parkMerchant.getSpaceNum() > 60) {
                        parkMerchant.setSpaceNum(Integer.valueOf(60));
                    }
                    log.info("\u5f53\u524d\u5546\u6237[{}],\u4f18\u60e0\u5238\u7f16\u53f7[{}]\u6309\u5929\u4f18\u514d\u91ca\u653e\u540e\u8f66\u4f4d\u6570[{}]", new Object[]{parkMerchant.getName(), discountDay.getDiscountNo(), parkMerchant.getSpaceNum()});
                    this.parkMerchantDao.update((Object)parkMerchant);
                    discountDay.setIsRelease(Boolean.TRUE);
                    this.discountDayDao.updateByPrimaryKey(discountDay);
                }
            }
        });
        return ObjectResponse.success();
    }

    public ObjectResponse<DiscountDay> selectLastByPlateNum(String plateNum, Long parkId) {
        DiscountDay discountDay = this.discountDayDao.selectLastByPlateNum(plateNum, parkId);
        if (Objects.nonNull(discountDay)) {
            return ObjectResponse.success((Object)discountDay);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse updateDiscountDay(DiscountDay discountDay) {
        this.discountDayDao.updateByPrimaryKey(discountDay);
        return ObjectResponse.success();
    }
}

