/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.ChannelCarInfoRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.request.OfflineEnterRequest;
import com.icetech.cloudcenter.domain.request.OfflineExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.mor.ApplyCarVideoRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.mor.impl.MorApplyCarVideoServiceImpl;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.impl.manage.CloudManageService;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.park.service.record.ExitRecordService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManageServiceImpl
extends AbstractService
implements ManageService {
    private static final Logger log = LoggerFactory.getLogger(ManageServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Autowired
    private EnterRecordService enterRecordService;
    @Autowired
    private ExitRecordService exitRecordService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private MorApplyCarVideoServiceImpl applyCarVideoService;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private Map<String, CloudManageService> manageServiceMap;
    private static final String P2C_BEAN = "p2CloudManageImpl";
    private static final String FC_BEAN = "fullCloudManageImpl";
    private static final String PNC_BEAN = "pnCloudManageImpl";

    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromRedis(String parkCode, String aisleCode, Integer type, String topic) {
        try {
            return this.getBean(parkCode).getCarInfoFromRedis(parkCode, aisleCode, type, topic);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570{}", (Object)aisleCode, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<EnterCarInfoResponse> getCarEnterTraceFromRedis(String parkCode, String aisleCode) {
        try {
            return this.getBean(parkCode).getCarEnterTraceFromRedis(parkCode, aisleCode);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570{}", (Object)aisleCode, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromCamera(String parkCode, String aisleCode, Integer type, String topic) {
        try {
            return this.getBean(parkCode).getCarInfoFromCamera(parkCode, aisleCode, type, topic);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570{}", (Object)aisleCode, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<String> getCarInfoFromCameraAsync(String parkCode, String version, String sn, String aisleCode, Integer type) {
        try {
            return this.getBean(parkCode).getCarInfoFromCameraAsync(parkCode, version, sn, aisleCode, type);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570{}", (Object)aisleCode, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Object> getCarExitInfoFromCacheByOrderNum(String parkCode, String orderNum) {
        try {
            return this.getBean(parkCode).getCarExitInfoFromCacheByOrderNum(parkCode, orderNum);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53c2\u6570{}", (Object)orderNum, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> allowEnter(DataEnterRequest enterRequest) {
        try {
            this.verifyParams(enterRequest);
            return this.getBean(enterRequest.getParkCode()).allowEnter(enterRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("allowEnter\u53c2\u6570[{}]", (Object)enterRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> allowExit(DataExitRequest exitRequest) {
        try {
            this.verifyParams(exitRequest);
            String parkCode = exitRequest.getParkCode();
            return this.getBean(parkCode).allowExit(exitRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("allowExit\u5f02\u5e38[{}]", (Object)exitRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<PullfeeResponse> pullFee(PullfeeRequest pullfeeRequest) {
        try {
            this.verifyParams(pullfeeRequest);
            if (StringUtils.isBlank((CharSequence)pullfeeRequest.getPlateNum())) {
                return ObjectResponse.failed((String)"400", (String)"\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return this.getBean(pullfeeRequest.getParkCode()).pullFee(pullfeeRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u67e5\u8be2\u6700\u65b0\u8d39\u7528\u5f02\u5e38\uff0c\u53c2\u6570[{}]", (Object)pullfeeRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> callVoiceReport(VoiceReportRequest voiceReportRequest) {
        try {
            this.verifyParams(voiceReportRequest);
            return this.getBean(voiceReportRequest.getParkCode()).callVoiceReport(voiceReportRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8bed\u97f3\u64ad\u653e\u5f02\u5e38\uff0c\u53c2\u6570[{}]", (Object)voiceReportRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest openBrakeRequest) {
        try {
            this.verifyParams(openBrakeRequest);
            return this.getBean(openBrakeRequest.getParkCode()).requestOpenBrake(openBrakeRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5f00\u95f8\u5f02\u5e38\uff0c\u53c2\u6570[{}]", (Object)openBrakeRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest closeBrakeRequest) {
        try {
            this.verifyParams(closeBrakeRequest);
            return this.getBean(closeBrakeRequest.getParkCode()).requestCloseBrake(closeBrakeRequest);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> modifyCacheFee(ModifyFeeRequest modifyFeeRequest) {
        try {
            return this.getBean(modifyFeeRequest.getParkCode()).modifyCacheFee(modifyFeeRequest);
        }
        catch (ResponseBodyException e) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38[{}]", (Object)modifyFeeRequest, (Object)e);
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38[{}]", (Object)modifyFeeRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<Void> updateExitChannelInfo(ChannelCarInfoRequest channelCarInfoRequest) {
        CarExitRequest exit = this.cacheHandle.getExit(channelCarInfoRequest.getParkCode(), channelCarInfoRequest.getAisleCode());
        if (exit == null) {
            return ObjectResponse.failed((String)"402", (String)"\u64cd\u4f5c\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u8ba1\u8d39");
        }
        if (!channelCarInfoRequest.getOrderNum().equals(exit.getOrderNum())) {
            return ObjectResponse.failed((String)"402", (String)"\u4e0e\u5f53\u524d\u901a\u9053\u8f66\u8f86\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8bc6\u522b");
        }
        exit.setMaxImage(channelCarInfoRequest.getImage());
        exit.setCarType(channelCarInfoRequest.getCarType());
        exit.setOperAccount(channelCarInfoRequest.getOperaAccount());
        exit.setExitTerminal(channelCarInfoRequest.getExitTerminal());
        exit.setExitWay(Integer.valueOf(4));
        this.cacheHandle.setExit(channelCarInfoRequest.getParkCode(), channelCarInfoRequest.getAisleCode(), exit);
        return ObjectResponse.success();
    }

    public ObjectResponse<Map<String, Object>> offLineEnter(OfflineEnterRequest offlineEnterRequest) {
        this.verifyParams(offlineEnterRequest);
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(offlineEnterRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse inOutObjectResponse = this.parkService.getInOutDeviceByCode(park.getId(), offlineEnterRequest.getAisleCode());
        if (!ObjectResponse.isSuccess((Response)inOutObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(offlineEnterRequest.getPlateNum());
        carEnterRequest.setMaxImage(offlineEnterRequest.getImage());
        ObjectResponse plateType = this.orderService.getPlateType(park.getId(), offlineEnterRequest.getPlateNum(), ((ParkInoutdevice)inOutObjectResponse.getData()).getRegionId());
        if (ObjectResponse.isSuccess((Response)plateType)) {
            carEnterRequest.setType(((PlateTypeDto)plateType.getData()).getPlateTypeEnum().getType());
        } else {
            carEnterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
        }
        carEnterRequest.setCarType(offlineEnterRequest.getCarType());
        carEnterRequest.setCarDesc(offlineEnterRequest.getSpecialCar());
        carEnterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        carEnterRequest.setOperaUser(offlineEnterRequest.getOperaUser());
        carEnterRequest.setParkId(park.getId());
        carEnterRequest.setParkCode(offlineEnterRequest.getParkCode());
        carEnterRequest.setInandoutCode(offlineEnterRequest.getAisleCode());
        carEnterRequest.setInandoutName(((ParkInoutdevice)inOutObjectResponse.getData()).getInandoutName());
        carEnterRequest.setOrderNum(CodeTools.GenerateOrderNum());
        carEnterRequest.setEnterWay(Integer.valueOf(5));
        carEnterRequest.setEnterTerminal(Integer.valueOf(2));
        this.addEnterRecord(carEnterRequest);
        ObjectResponse objectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            this.cacheHandle.removeEntrace(offlineEnterRequest.getParkCode(), offlineEnterRequest.getAisleCode());
            CarEnterResult carEnterResult = (CarEnterResult)objectResponse.getData();
            this.addEntranceOpenRecord(offlineEnterRequest, carEnterResult.getOrderNum(), carEnterRequest.getEnterTime());
            HashMap<String, Integer> ret = new HashMap<String, Integer>(1);
            ret.put("type", carEnterRequest.getType());
            return ObjectResponse.success(ret);
        }
        return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
    }

    public ObjectResponse<Void> offLineExit(OfflineExitRequest offlineExitRequest) {
        this.verifyParams(offlineExitRequest);
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(offlineExitRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse inOutObjectResponse = this.parkService.getInOutDeviceByCode(park.getId(), offlineExitRequest.getAisleCode());
        if (!ObjectResponse.isSuccess((Response)inOutObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u901a\u9053\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        ObjectResponse plateType = this.orderService.getPlateType(park.getId(), offlineExitRequest.getPlateNum(), ((ParkInoutdevice)inOutObjectResponse.getData()).getRegionId());
        Integer type = ObjectResponse.isSuccess((Response)plateType) ? ((PlateTypeDto)plateType.getData()).getPlateTypeEnum().getType() : PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
        CarExitRequest cacheExit = this.cacheHandle.getExit(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
        CarExitRequest carExitRequest = new CarExitRequest();
        if (StringUtils.isNotBlank((CharSequence)offlineExitRequest.getOrderNum())) {
            ObjectResponse objectResponse = this.orderService.findByOrderNum(offlineExitRequest.getOrderNum());
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return ObjectResponse.failed((String)"402", (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            if (!((OrderInfo)objectResponse.getData()).getServiceStatus().equals(1)) {
                return ObjectResponse.failed((String)"405", (String)"\u8f66\u8f86\u5df2\u79bb\u573a");
            }
            if (cacheExit == null) {
                carExitRequest.setPlateNum(offlineExitRequest.getPlateNum());
                carExitRequest.setMaxImage(offlineExitRequest.getImage());
                carExitRequest.setCarType(offlineExitRequest.getCarType());
                carExitRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
                carExitRequest.setParkId(park.getId());
                carExitRequest.setParkCode(offlineExitRequest.getParkCode());
                carExitRequest.setInandoutCode(offlineExitRequest.getAisleCode());
                carExitRequest.setInandoutName(((ParkInoutdevice)inOutObjectResponse.getData()).getInandoutName());
                carExitRequest.setOrderNum(offlineExitRequest.getOrderNum());
            } else {
                String cacheOrderNum = cacheExit.getOrderNum();
                if (cacheOrderNum != null && !offlineExitRequest.getOrderNum().equals(cacheOrderNum)) {
                    log.warn("[\u65ad\u7535\u5e94\u6025\u79bb\u573a] \u8ba2\u5355\u4e0e\u7f13\u5b58\u4e2d\u7684\u5f02\u5e38\u8ba2\u5355\u4e0d\u5339\u914d\uff0c\u7f13\u5b58\u6570\u636e\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)cacheExit, (Object)offlineExitRequest);
                }
                BeanUtils.copyProperties((Object)cacheExit, (Object)carExitRequest);
                carExitRequest.setInandoutCode(offlineExitRequest.getAisleCode());
                carExitRequest.setCarType(offlineExitRequest.getCarType());
                carExitRequest.setOrderNum(offlineExitRequest.getOrderNum());
                carExitRequest.setPlateNum(offlineExitRequest.getPlateNum());
                carExitRequest.setExitTime(cacheExit.getExitTime());
                if (offlineExitRequest.getImage() != null) {
                    carExitRequest.setMaxImage(offlineExitRequest.getImage());
                }
            }
            carExitRequest.setType(type);
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(park.getId());
            orderPay.setOrderNum(offlineExitRequest.getOrderNum());
            OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null) {
                carExitRequest.setTotalAmount(String.valueOf(orderSumFeeDto.getTotalPrice()));
                carExitRequest.setPaidAmount(String.valueOf(orderSumFeeDto.getPaidPrice()));
                carExitRequest.setDiscountAmount(String.valueOf(orderSumFeeDto.getDiscountPrice()));
            }
            this.addExitRecord(carExitRequest);
            carExitRequest.setOpenFlag(Integer.valueOf(0));
            carExitRequest.setExitWay(Integer.valueOf(5));
            carExitRequest.setOperAccount(offlineExitRequest.getOperaUser());
            carExitRequest.setExitTerminal(Integer.valueOf(2));
            this.carOrderExitService.exceptionExit(carExitRequest, Integer.valueOf(7));
        }
        if (cacheExit != null && cacheExit.getOrderNum().equals(offlineExitRequest.getOrderNum())) {
            this.cacheHandle.removeExit(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
            this.cacheHandle.removeChannelFee(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inOutObjectResponse.getData();
            if (Integer.valueOf(1).equals(park.getIsInterior()) && Integer.valueOf(0).equals(parkInoutdevice.getIsMaster())) {
                ObjectResponse objectResponse = this.parkService.getChannelByType(park.getId(), Integer.valueOf(2));
                ObjectResponse.notError((Response)objectResponse, (String)"\u901a\u9053\u5217\u8868\u67e5\u8be2\u5931\u8d25");
                List list = (List)objectResponse.getData();
                list.forEach(inout -> {
                    if (inout.getInandoutCode().equals(offlineExitRequest.getAisleCode())) {
                        return;
                    }
                    CarExitRequest cacheHandleExit = this.cacheHandle.getExit(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                    if (offlineExitRequest.getOrderNum().equals(cacheHandleExit.getOrderNum())) {
                        this.cacheHandle.removeExit(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                        this.cacheHandle.removeChannelFee(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                    }
                });
            }
        }
        this.addExitOpenRecord(offlineExitRequest, offlineExitRequest.getOrderNum(), carExitRequest.getExitTime() == null ? DateTools.unixTimestamp() : carExitRequest.getExitTime());
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> applyNoPlateEnter(ApplyNoPlateEnterRequest applyNoPlateEnterRequest) {
        try {
            this.verifyParams(applyNoPlateEnterRequest);
            String parkCode = applyNoPlateEnterRequest.getParkCode();
            return this.getBean(parkCode).applyNoPlateEnter(applyNoPlateEnterRequest);
        }
        catch (ResponseBodyException e) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38[{}]", (Object)applyNoPlateEnterRequest, (Object)e);
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38[{}]", (Object)applyNoPlateEnterRequest, (Object)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<String> applyCarVideo(ApplyCarVideoVo applyCarVideoVo) {
        ObjectResponse response = this.parkService.getInoutDeviceById(applyCarVideoVo.getChannelId());
        ObjectResponse.notError((Response)response);
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(applyCarVideoVo.getParkId());
        ObjectResponse.notError((Response)parkObjectResponse);
        String inandoutCode = ((ParkInoutdevice)response.getData()).getInandoutCode();
        String serialNumber = this.morCacheHandle.getSerialNumber(((Park)parkObjectResponse.getData()).getParkCode(), inandoutCode);
        if (serialNumber == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ApplyCarVideoRequest applyCarVideoRequest = new ApplyCarVideoRequest();
        applyCarVideoRequest.setPlateNum(applyCarVideoVo.getPlateNum());
        applyCarVideoRequest.setRecTime(applyCarVideoVo.getRecTime());
        applyCarVideoRequest.setVideoType(applyCarVideoVo.getVideoType());
        applyCarVideoRequest.setVideoId(applyCarVideoVo.getVideoId());
        return this.applyCarVideoService.send(serialNumber, applyCarVideoVo.getOrderNum(), applyCarVideoVo.getParkId(), applyCarVideoRequest);
    }

    public ObjectResponse<Void> fleetMode(String parkCode, Long parkId, String sn, Integer enable) {
        try {
            return this.getBean(parkCode).fleetMode(parkCode, parkId, sn, enable);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("fleetMode\u5f02\u5e38", (Throwable)e);
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
    }

    public void addEnterRecord(CarEnterRequest enterRequest) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties((Object)enterRequest, (Object)record);
        record.setChannelId(enterRequest.getInandoutCode());
        record.setEnterNo(enterRequest.getInandoutName());
        record.setImage(enterRequest.getMaxImage());
        this.enterRecordService.saveRecordAsync(record);
    }

    private void addExitRecord(CarExitRequest exitRequest) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties((Object)exitRequest, (Object)record);
        record.setExitNo(exitRequest.getInandoutName());
        record.setImage(exitRequest.getMaxImage());
        record.setSmallImage(exitRequest.getSmallImage());
        this.exitRecordService.saveRecordAsync(record);
    }

    public void addEntranceOpenRecord(OfflineEnterRequest offlineEnterRequest, String orderNum, Long execTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(Integer.valueOf(1));
        openingDtoRequest.setParkCode(offlineEnterRequest.getParkCode());
        openingDtoRequest.setPlateNum(offlineEnterRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(execTime);
        openingDtoRequest.setImgUrl(offlineEnterRequest.getImage());
        openingDtoRequest.setAisleCode(offlineEnterRequest.getAisleCode());
        openingDtoRequest.setReasonType(Integer.valueOf(5));
        openingDtoRequest.setOperAccount(offlineEnterRequest.getOperaUser());
        openingDtoRequest.setSourcegate(Integer.valueOf(3));
        openingDtoRequest.setOrderNum(orderNum);
        this.parkService.saveOpeningRecord(openingDtoRequest);
    }

    public void addExitOpenRecord(OfflineExitRequest offlineExitRequest, String orderNum, Long execTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(Integer.valueOf(2));
        openingDtoRequest.setParkCode(offlineExitRequest.getParkCode());
        openingDtoRequest.setPlateNum(offlineExitRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(execTime);
        openingDtoRequest.setImgUrl(offlineExitRequest.getImage());
        openingDtoRequest.setAisleCode(offlineExitRequest.getAisleCode());
        openingDtoRequest.setReasonType(Integer.valueOf(5));
        openingDtoRequest.setOperAccount(offlineExitRequest.getOperaUser());
        openingDtoRequest.setSourcegate(Integer.valueOf(3));
        openingDtoRequest.setOrderNum(orderNum);
        this.parkService.saveOpeningRecord(openingDtoRequest);
    }

    private CloudManageService getBean(String parkCode) {
        if (DataCollectionEnum.\u7aef\u4e91.getType().equals(this.publicHandle.cloudType(parkCode))) {
            return this.manageServiceMap.get(P2C_BEAN);
        }
        if (DataCollectionEnum.\u7eaf\u4e91.getType().equals(this.publicHandle.cloudType(parkCode))) {
            return this.manageServiceMap.get(FC_BEAN);
        }
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(this.publicHandle.cloudType(parkCode))) {
            return this.manageServiceMap.get(PNC_BEAN);
        }
        return this.manageServiceMap.get(P2C_BEAN);
    }
}

