/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.MadePlateVo;
import com.icetech.cloudcenter.domain.vo.PlateRecheckVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.dao.made.IotPlateMapper;
import com.icetech.park.dao.made.MadePlateDao;
import com.icetech.park.domain.entity.IotPlate;
import com.icetech.park.service.IotPlateService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IotPlateServiceImpl
extends BaseServiceImpl<IotPlateMapper, IotPlate>
implements IotPlateService {
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private MadePlateDao madePlateDao;
    @Autowired
    private IotPlateService iotPlateService;
    @Resource
    private OssService ossService;

    @Override
    public Integer selectPlateCount(ManagerInOutRequest managerInOutRequest, String parkIds) {
        return ((IotPlateMapper)this.baseMapper).selectPlateCount(managerInOutRequest, parkIds);
    }

    @Override
    public List<PlateRecheckVo> selectRecheckVo(ManagerInOutRequest request, String parkIds) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        page.setSearchCount(false);
        return ((IotPlateMapper)this.baseMapper).selectRecheckVo(page, request, parkIds);
    }

    @Override
    public List<IotPlate> selectIotPlateByOrderNum(String orderNum) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(IotPlate::getOrderNum, (Object)orderNum);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public ObjectResponse<Integer> getPlateRecheckCount(ManagerInOutRequest managerInOutRequest) {
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = this.parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty((CharSequence)parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        return ObjectResponse.success((Object)this.iotPlateService.selectPlateCount(managerInOutRequest, parkIds));
    }

    @Override
    public ObjectResponse<List<PlateRecheckVo>> getRecheckList(ManagerInOutRequest managerInOutRequest) {
        List<Object> plateRecheckVos;
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = this.parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty((CharSequence)parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        if (CollectionUtils.isNotEmpty(plateRecheckVos = this.iotPlateService.selectRecheckVo(managerInOutRequest, parkIds))) {
            plateRecheckVos = plateRecheckVos.stream().peek(t -> {
                if (StringUtils.isNotEmpty((CharSequence)t.getImage())) {
                    t.setImage(this.ossService.getImageUrl(t.getImage()));
                }
                if (StringUtils.isNotEmpty((CharSequence)t.getSmallEnterImage())) {
                    t.setSmallEnterImage(this.ossService.getImageUrl(t.getSmallEnterImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(plateRecheckVos);
    }

    @Override
    public ObjectResponse<List<MadePlateVo>> getMadePlateList(ManagerInOutRequest managerInOutRequest) {
        List<Object> madePlateVos;
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = this.parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty((CharSequence)parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        if (CollectionUtils.isNotEmpty(madePlateVos = this.madePlateDao.selectMadePlateVo(new Page((long)managerInOutRequest.getPageNo().intValue(), (long)managerInOutRequest.getPageSize().intValue()), managerInOutRequest, parkIds))) {
            madePlateVos = madePlateVos.stream().peek(t -> {
                if (StringUtils.isNotEmpty((CharSequence)t.getImage())) {
                    t.setImage(this.ossService.getImageUrl(t.getImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(madePlateVos);
    }
}

