/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.dao.device.HeartbeatDao;
import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.Heartbeat;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.HeartbeatHandleService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeartbeatHandleV1ServiceImpl
implements HeartbeatHandleService {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatHandleV1ServiceImpl.class);
    @Autowired
    private HeartbeatDao heartbeatDao;
    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse execute(String param) {
        List heartbeats = this.heartbeatDao.getOffline(180);
        log.info("<\u5fc3\u8df3\u5305\u5b9a\u65f6\u5904\u7406> \u5fc3\u8df3\u5305\u65ad\u5f00\u8bbe\u5907\u4e2a\u6570\uff1a{}", (Object)(heartbeats == null ? 0 : heartbeats.size()));
        for (int i = 0; heartbeats != null && i < heartbeats.size(); ++i) {
            ObjectResponse objectResponse;
            Heartbeat heartbeat = (Heartbeat)heartbeats.get(i);
            Long parkId = heartbeat.getParkId();
            String deviceNo = heartbeat.getDeviceNo();
            ParkDevice parkDevice = this.parkDeviceDao.getByDeviceNo(parkId.longValue(), deviceNo);
            if (parkDevice == null || parkDevice.getStatus() == 2 || parkDevice.getStatus() != 1) continue;
            Long now = DateTools.unixTimestamp();
            Date endUpdatetime = parkDevice.getEndUpdatetime();
            if (endUpdatetime == null || now - endUpdatetime.getTime() / 1000L < 180L) continue;
            this.parkDeviceService.modifyStatus(parkId, deviceNo, Integer.valueOf(2), "\u65ad\u7f51", heartbeat.getServerTime());
            HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
            heartbeatOffline.setParkId(parkId);
            heartbeatOffline.setLastConnectionTime(heartbeat.getServerTime());
            heartbeatOffline.setDeviceNo(deviceNo);
            this.heartbeatOfflineDao.insert((Object)heartbeatOffline);
            ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
            ObjectResponse.notError((Response)parkObjectResponse);
            Park park = (Park)parkObjectResponse.getData();
            if (parkDevice.getChannelId() == 0 || !ObjectResponse.isSuccess((Response)(objectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().intValue()))))) continue;
            ParkInoutdevice data = (ParkInoutdevice)objectResponse.getData();
            String content = "\u3010\u8bbe\u5907\u79bb\u7ebf\u63d0\u9192\u3011\u8f66\u573a\u540d\u79f0\uff1a" + park.getParkName() + "\uff0c\u51fa\u5165\u53e3\u540d\u79f0\uff1a" + data.getInandoutName() + "\uff0c\u8bbe\u5907\u7f16\u53f7" + parkDevice.getDeviceNo() + "\uff0c\u6700\u540e\u901a\u8baf\u65f6\u95f4\uff1a" + DateTools.getFormat((Date)endUpdatetime);
            this.publicHandle.sendSmgToOpsUser(content, parkId);
            if (parkDevice.getType() == 1) {
                this.cacheHandle.closeForClearCache(parkDevice.getSerialNumber());
                continue;
            }
            if (parkDevice.getType() != 5) continue;
            this.cacheHandle.closeForRobotClearCache(parkDevice.getSerialNumber());
        }
        return ObjectResponse.success();
    }
}

