/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.dto.HeartbeatOfflineDto;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.service.device.HeartbeatOfflineService;
import com.icetech.basics.service.device.impl.ParkDeviceDaoImpl;
import com.icetech.basics.service.device.impl.ParkDeviceServiceImpl;
import com.icetech.cloudcenter.api.HeartbeatHandleService;
import com.icetech.cloudcenter.domain.request.pnc.ChargeStatusRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.park.impl.ParkFreeSpaceServiceImpl;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeartbeatHandleServiceImpl
implements HeartbeatHandleService {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatHandleServiceImpl.class);
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDeviceServiceImpl parkDeviceService;
    @Autowired
    private ParkDeviceDaoImpl parkDeviceDaoImpl;
    @Autowired
    private HeartbeatOfflineService heartbeatOfflineService;
    @Autowired
    private ParkFreeSpaceServiceImpl parkFreeSpaceService;
    @Autowired
    private MqPushService mqPushService;
    private static final int DEVICE_THRESHOLD = 100;
    private static final int PNC_THRESHOLD = 10;
    private static final int batchSize = 500;

    public ObjectResponse execute(String param) {
        long now = DateTools.unixTimestamp();
        Long lastTaskTime = (Long)this.redisUtils.get("heartbeat:task:time", Long.class);
        if (lastTaskTime == null) {
            lastTaskTime = now - 60L;
        }
        long diffSeconds = now - lastTaskTime;
        this.deviceCheckAndUpdate(1, now);
        this.deviceCheckAndUpdate(5, now);
        this.pncCheck(now, lastTaskTime, diffSeconds);
        this.batchUpdateDeviceTime(8);
        this.batchUpdateDeviceTime(9);
        this.redisUtils.set("heartbeat:task:time", (Object)now);
        return ObjectResponse.success();
    }

    private void deviceCheckAndUpdate(int deviceType, long now, Long lastTaskTime, long diffSeconds) {
        List onlineDeviceList;
        List failStatusOnlineList;
        String key = deviceType == 1 ? "p2c:heartbeat:time" : "p2r:heartbeat:time";
        Map listMap = this.redisUtils.hGetAll(key, Long.class);
        Set sns = listMap.keySet();
        long timeEnd = now - 180L;
        List<String> offlineDeviceList = sns.stream().filter(sn -> (Long)listMap.get(sn) <= timeEnd && (Long)listMap.get(sn) > timeEnd - diffSeconds).collect(Collectors.toList());
        if (!offlineDeviceList.isEmpty()) {
            if (offlineDeviceList.size() >= 100) {
                log.warn("[\u76d1\u63a7\u57cb\u70b9] \u4e0a\u6b21\u4efb\u52a1[{}]\u5230\u5f53\u524d\u4efb\u52a1\u7684\u79bb\u7ebf\u8bbe\u5907\u6570\u4e3a[{}], \u8d85\u8fc7\u4e86\u9608\u503c[{}]", new Object[]{DateTools.getFormat((Date)new Date(lastTaskTime * 1000L)), offlineDeviceList.size(), 100});
            }
            this.parkDeviceService.batchModifyStatus(offlineDeviceList, listMap, Integer.valueOf(deviceType), Integer.valueOf(2));
            offlineDeviceList.forEach(sn -> {
                if (deviceType == 1) {
                    this.cacheHandle.closeForClearCache((String)sn);
                } else if (deviceType == 5) {
                    this.cacheHandle.closeForRobotClearCache((String)sn);
                } else if (deviceType == 8) {
                    this.itcCacheHandle.closeForClearCache((String)sn);
                } else if (deviceType == 9) {
                    this.morCacheHandle.closeForClearCache((String)sn);
                }
            });
        }
        if (!(failStatusOnlineList = this.parkDeviceDao.selectFailStatusList(onlineDeviceList = sns.stream().filter(sn -> (Long)listMap.get(sn) >= now - 60L).collect(Collectors.toList()), Integer.valueOf(deviceType), Integer.valueOf(1))).isEmpty()) {
            log.info("[\u8bbe\u5907\u72b6\u6001\u7ea0\u6b63] \u5b9e\u9645\u5728\u7ebf\u7684\u8bbe\u5907[{}]", (Object)failStatusOnlineList);
            this.parkDeviceService.batchModifyStatus(failStatusOnlineList, listMap, Integer.valueOf(deviceType), Integer.valueOf(1));
        }
    }

    private void pncCheck(long now, Long lastTaskTime, long diffSeconds) {
        List onlineDeviceList;
        String key = "pnc:heartbeat:time";
        Map listMap = this.redisUtils.hGetAll(key, Long.class);
        Set parkIds = listMap.keySet();
        long timeEnd = now - 180L;
        List<String> offlineParkList = parkIds.stream().filter(sn -> (Long)listMap.get(sn) <= timeEnd && (Long)listMap.get(sn) > timeEnd - diffSeconds).collect(Collectors.toList());
        if (!offlineParkList.isEmpty()) {
            if (offlineParkList.size() >= 10) {
                log.warn("[\u76d1\u63a7\u57cb\u70b9] \u4e0a\u6b21\u4efb\u52a1[{}]\u5230\u5f53\u524d\u4efb\u52a1\u7684\u79bb\u7ebf\u8bbe\u5907\u6570\u4e3a[{}], \u8d85\u8fc7\u4e86\u9608\u503c[{}]", new Object[]{DateTools.getFormat((Date)new Date(lastTaskTime * 1000L)), offlineParkList.size(), 10});
            }
            List offlineList = offlineParkList.stream().map(parkId -> {
                HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                heartbeatOffline.setParkId(Long.valueOf(parkId));
                heartbeatOffline.setDeviceNo("CENTER");
                heartbeatOffline.setLastConnectionTime((Long)listMap.get(parkId));
                return heartbeatOffline;
            }).collect(Collectors.toList());
            this.heartbeatOfflineService.saveBatch(offlineList);
            this.redisUtils.hDelete("pnc:protocol", offlineParkList.toArray(new String[0]));
            for (HeartbeatOffline offline : offlineList) {
                this.mqPushService.pushPncCenterOffline(offline);
            }
        }
        if (!(onlineDeviceList = parkIds.stream().filter(parkId -> (Long)listMap.get(parkId) >= now - 60L).map(Long::new).collect(Collectors.toList())).isEmpty()) {
            log.info("[\u7aef\u7f51\u4e91\u72b6\u6001\u66f4\u65b0] \u5b9e\u9645\u5728\u7ebf\u7684\u8bbe\u5907[{}]", onlineDeviceList);
            List heartbeatOfflines = this.heartbeatOfflineService.getNoFinishLastByParkId(onlineDeviceList);
            Iterator iterator = heartbeatOfflines.iterator();
            while (iterator.hasNext()) {
                HeartbeatOffline heartbeatOffline = (HeartbeatOffline)iterator.next();
                Long lastHeartbeatTime = (Long)listMap.get(String.valueOf(heartbeatOffline.getParkId()));
                if (lastHeartbeatTime != null) {
                    heartbeatOffline.setReconnectTime(lastHeartbeatTime);
                    heartbeatOffline.setOffTime(Long.valueOf(lastHeartbeatTime - heartbeatOffline.getLastConnectionTime()));
                    continue;
                }
                iterator.remove();
            }
            if (!heartbeatOfflines.isEmpty()) {
                this.heartbeatOfflineService.updateBatchById((Collection)heartbeatOfflines);
            }
        }
        this.checkPncChargeHeartbeat(now, timeEnd, diffSeconds);
    }

    private void checkPncChargeHeartbeat(long now, long timeEnd, long diffSeconds) {
        Set chargeHeartbeatMapKeys;
        if (log.isDebugEnabled()) {
            log.debug("\u8bbe\u5907\u79bb\u7ebf\u68c0\u6d4b|\u7aef\u7f51\u4e91\u8ba1\u8d39\u4e2d\u5fc3\u68c0\u6d4b|\u68c0\u6d4b\u65f6\u95f4|{}|{}|{}", new Object[]{now, timeEnd, diffSeconds});
        }
        if (CollectionUtils.isEmpty((Collection)(chargeHeartbeatMapKeys = this.redisUtils.getStringRedisTemplate().keys((Object)"pnc:heartbeat:charge:*")))) {
            return;
        }
        LinkedList offlineList = new LinkedList();
        LinkedList<HeartbeatOffline> onlineList = new LinkedList<HeartbeatOffline>();
        for (String redisKey : chargeHeartbeatMapKeys) {
            Long parkId = Long.valueOf(redisKey.substring("pnc:heartbeat:charge:".length()));
            Map heartbeatMap = this.redisUtils.hGetAll(redisKey, ChargeStatusRequest.class);
            if (MapUtils.isEmpty((Map)heartbeatMap)) continue;
            heartbeatMap.values().stream().filter(heartbeat -> heartbeat.getTime() <= timeEnd && heartbeat.getTime() > timeEnd - diffSeconds).map(heartbeat -> {
                HeartbeatOfflineDto heartbeatOffline = new HeartbeatOfflineDto();
                heartbeatOffline.setParkId(parkId);
                heartbeatOffline.setDeviceNo(heartbeat.getId().toString());
                heartbeatOffline.setRemark(heartbeat.getName());
                heartbeatOffline.setLastConnectionTime(heartbeat.getTime());
                return heartbeatOffline;
            }).forEach(offlineList::add);
            List onlineChargeIds = heartbeatMap.entrySet().stream().filter(entry -> ((ChargeStatusRequest)entry.getValue()).getTime() >= now - 60L).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedList::new));
            if (!onlineChargeIds.isEmpty()) {
                List offlines = this.heartbeatOfflineService.getNoFinishChargeLastByChargeId(parkId, onlineChargeIds);
                for (HeartbeatOffline offline : offlines) {
                    Long lastHeartbeatTime = ((ChargeStatusRequest)heartbeatMap.get(offline.getDeviceNo())).getTime();
                    if (lastHeartbeatTime == null) continue;
                    offline.setReconnectTime(lastHeartbeatTime);
                    offline.setOffTime(Long.valueOf(lastHeartbeatTime - offline.getLastConnectionTime()));
                    onlineList.add(offline);
                }
            }
            if (!offlineList.isEmpty()) {
                this.heartbeatOfflineService.saveBatch(offlineList);
                for (HeartbeatOffline offline : offlineList) {
                    this.mqPushService.pushPncChargeOffline(offline);
                }
            }
            if (onlineList.isEmpty()) continue;
            this.heartbeatOfflineService.updateBatchById(onlineList);
        }
    }

    private void deviceCheckAndUpdate(int deviceType, long now) {
        String key = "";
        if (deviceType == 1) {
            key = "p2c:heartbeat:time";
        } else if (deviceType == 5) {
            key = "p2r:heartbeat:time";
        } else if (deviceType == 8) {
            key = "itc:heartbeat:time";
        } else if (deviceType == 9) {
            key = "mor:heartbeat:time";
        }
        Map listMap = this.redisUtils.hGetAll(key, Long.class);
        Set sns = listMap.keySet();
        if (CollectionUtils.isEmpty(sns)) {
            return;
        }
        ArrayList allSnList = new ArrayList(sns);
        int offlineCount = 0;
        for (int i = 0; i < allSnList.size(); i += 500) {
            int end = i + 500;
            if (end > allSnList.size()) {
                end = allSnList.size();
            }
            List snList = allSnList.subList(i, end);
            List parkDevices = this.parkDeviceDao.selectListBySns(snList, deviceType);
            List<ParkDevice> updateDeviceList = parkDevices.stream().filter(parkDevice -> {
                Long redisTime = (Long)listMap.get(parkDevice.getSerialNumber());
                return redisTime != null && (parkDevice.getEndUpdatetime() == null || parkDevice.getEndUpdatetime().getTime() / 1000L != redisTime);
            }).collect(Collectors.toList());
            List onlineDeviceList = parkDevices.stream().filter(parkDevice -> listMap.get(parkDevice.getSerialNumber()) != null).filter(parkDevice -> (Long)listMap.get(parkDevice.getSerialNumber()) >= now - 60L).filter(parkDevice -> !Integer.valueOf(1).equals(parkDevice.getStatus())).collect(Collectors.toList());
            List<ParkDevice> offlineDeviceList = parkDevices.stream().filter(parkDevice -> listMap.get(parkDevice.getSerialNumber()) != null).filter(parkDevice -> now - (Long)listMap.get(parkDevice.getSerialNumber()) >= 180L).filter(parkDevice -> !Integer.valueOf(2).equals(parkDevice.getStatus())).collect(Collectors.toList());
            offlineCount += offlineDeviceList.size();
            updateDeviceList.forEach(device -> {
                boolean onlineCondition;
                device.setEndUpdatetime(new Date((Long)listMap.get(device.getSerialNumber()) * 1000L));
                boolean offlineCondition = now - (Long)listMap.get(device.getSerialNumber()) >= 180L;
                boolean bl = onlineCondition = (Long)listMap.get(device.getSerialNumber()) >= now - 60L;
                device.setStatus(Integer.valueOf(offlineCondition ? 2 : (onlineCondition ? 1 : device.getStatus())));
                device.setDelFlag(null);
            });
            offlineDeviceList.forEach(device -> {
                boolean onlineCondition;
                device.setEndUpdatetime(new Date((Long)listMap.get(device.getSerialNumber()) * 1000L));
                boolean offlineCondition = now - (Long)listMap.get(device.getSerialNumber()) >= 180L;
                boolean bl = onlineCondition = (Long)listMap.get(device.getSerialNumber()) >= now - 60L;
                device.setStatus(Integer.valueOf(offlineCondition ? 2 : (onlineCondition ? 1 : device.getStatus())));
                device.setDelFlag(null);
            });
            this.parkDeviceDaoImpl.updateBatchById(updateDeviceList);
            this.parkDeviceDaoImpl.updateBatchById(offlineDeviceList);
            if (!onlineDeviceList.isEmpty()) {
                this.parkDeviceService.batchModifyStatus2(onlineDeviceList, listMap, Integer.valueOf(1));
            }
            if (offlineDeviceList.isEmpty()) continue;
            this.parkDeviceService.batchModifyStatus2(offlineDeviceList, listMap, Integer.valueOf(2));
            offlineDeviceList.forEach(device -> {
                if (deviceType == 1) {
                    this.cacheHandle.closeForClearCache(device.getSerialNumber());
                } else if (deviceType == 5) {
                    this.cacheHandle.closeForRobotClearCache(device.getSerialNumber());
                } else if (deviceType == 8) {
                    this.itcCacheHandle.closeForClearCache(device.getSerialNumber());
                } else if (deviceType == 9) {
                    this.morCacheHandle.closeForClearCache(device.getSerialNumber());
                }
            });
        }
        log.warn("[\u8bbe\u5907\u5fc3\u8df3\u68c0\u6d4b] \u672c\u6b21\u68c0\u6d4b\u5230\u65b0\u589e\u79bb\u7ebf\u8bbe\u5907\u6570\u4e3a[{}]", (Object)offlineCount);
        if (offlineCount >= 100) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] \u672c\u6b21\u68c0\u6d4b\u5230\u65b0\u589e\u79bb\u7ebf\u8bbe\u5907\u6570\u4e3a[{}], \u8d85\u8fc7\u4e86\u9608\u503c[{}]", (Object)offlineCount, (Object)100);
        }
    }

    private void batchUpdateDeviceTime(int deviceType) {
        String key = "";
        if (deviceType == 8) {
            key = "itc:heartbeat:time";
        } else if (deviceType == 9) {
            key = "mor:heartbeat:time";
        }
        Map listMap = this.redisUtils.hGetAll(key, Long.class);
        Set sns = listMap.keySet();
        if (CollectionUtils.isEmpty(sns)) {
            return;
        }
        ArrayList allSnList = new ArrayList(sns);
        int updateCount = 0;
        for (int i = 0; i < allSnList.size(); i += 500) {
            int end = i + 500;
            if (end > allSnList.size()) {
                end = allSnList.size();
            }
            List snList = allSnList.subList(i, end);
            List parkDevices = this.parkDeviceDao.selectListBySns(snList, deviceType);
            List updateDeviceList = parkDevices.stream().filter(parkDevice -> {
                Long redisTime = (Long)listMap.get(parkDevice.getSerialNumber());
                return redisTime != null && (parkDevice.getEndUpdatetime() == null || parkDevice.getEndUpdatetime().getTime() / 1000L != redisTime);
            }).collect(Collectors.toList());
            updateDeviceList = updateDeviceList.stream().map(parkDevice -> {
                ParkDevice parkDevice1 = new ParkDevice();
                parkDevice1.setId(parkDevice.getId());
                parkDevice1.setEndUpdatetime(new Date((Long)listMap.get(parkDevice.getSerialNumber()) * 1000L));
                return parkDevice1;
            }).collect(Collectors.toList());
            this.parkDeviceDaoImpl.updateBatchById(updateDeviceList);
            updateCount += updateDeviceList.size();
        }
        log.warn("[\u66f4\u65b0\u6700\u540e\u8fde\u63a5\u65f6\u95f4] total[{}], update[{}]", sns, (Object)updateCount);
    }

    private void batchUpdateFreeSpace() {
        Map listMap = this.redisUtils.hGetAll("pnc:freespace", Integer.class);
        if (listMap.size() == 0) {
            return;
        }
        ArrayList parkIds = new ArrayList(listMap.keySet());
        for (int i = 0; i < parkIds.size(); i += 500) {
            int end = i + 500;
            if (end > parkIds.size()) {
                end = parkIds.size();
            }
            List parkList = parkIds.subList(i, end);
            List<ParkFreespace> freeSpaceList = parkList.stream().map(parkId -> {
                ParkFreespace parkFreespace = new ParkFreespace();
                parkFreespace.setParkId(Long.valueOf(parkId));
                Integer freeSpace = Math.max(NumberUtils.toPrimitive((Integer)((Integer)listMap.get(parkId))), 0);
                parkFreespace.setFreeSpace(freeSpace);
                parkFreespace.setRealFreeSpace(Integer.valueOf(NumberUtils.toPrimitive((Integer)((Integer)listMap.get(parkId)))));
                return parkFreespace;
            }).collect(Collectors.toList());
            this.parkFreeSpaceService.updateBatchByParkId(freeSpaceList);
        }
    }
}

