/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.ExternalService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.request.DiscountRequest;
import com.icetech.cloudcenter.domain.request.PrepayReportRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalServiceImpl
extends AbstractService
implements ExternalService {
    private static final Logger log = LoggerFactory.getLogger(ExternalServiceImpl.class);
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PublicHandle publicHandle;
    private static final int NEW_STATUS = 1;

    public ObjectResponse prepayReport(PrepayReportRequest prepayReportRequest) {
        String[] discountNoArr;
        log.info("<\u9884\u7f34\u8d39\u4e0a\u62a5> \u53c2\u6570\uff1a{}", (Object)prepayReportRequest);
        OrderPay orderPay = new OrderPay();
        BeanUtils.copyProperties((Object)prepayReportRequest, (Object)orderPay);
        Long parkId = this.getParkId(prepayReportRequest);
        orderPay.setParkId(parkId);
        String orderNum = prepayReportRequest.getOrderNum();
        if (orderNum == null) {
            orderNum = this.publicHandle.convert2OrderNum(parkId, prepayReportRequest.getOrderId());
        }
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        ObjectResponse objectResponse = this.orderPayService.addOrderPay(orderPay);
        ObjectResponse.notError((Response)objectResponse);
        String discountNos = prepayReportRequest.getDiscountNos();
        if (discountNos != null && (discountNoArr = discountNos.split(",")) != null && discountNoArr.length > 0) {
            DiscountRequest discountRequest = new DiscountRequest();
            BeanUtils.copyProperties((Object)orderPay, (Object)discountRequest);
            discountRequest.setOrderNum(orderNum);
            discountRequest.setDiscountNos(discountNoArr);
            discountRequest.setNewStatus(Integer.valueOf(1));
            objectResponse = this.orderDiscountService.modifyDiscount(discountRequest);
            ObjectResponse.notError((Response)objectResponse);
            return ObjectResponse.success();
        }
        return ObjectResponse.success();
    }

    private Long getParkId(PrepayReportRequest prepayReportRequest) {
        if (prepayReportRequest.getParkId() != null) {
            return prepayReportRequest.getParkId();
        }
        ObjectResponse objectResponse_order = this.orderService.findByOrderNum(prepayReportRequest.getOrderNum());
        ObjectResponse.notError((Response)objectResponse_order);
        return ((OrderInfo)objectResponse_order.getData()).getParkId();
    }
}

