/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.LcdHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DualCameraV2ServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DualCameraV2ServiceImpl.class);
    @Resource
    private CacheHandle cacheHandle;
    @Resource
    private P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Resource
    private HintServiceImpl hintService;
    @Resource
    private LcdHintServiceImpl lcdHintService;
    @Resource
    private ParkService parkService;

    @Async
    public void afterHandle(CarEnexResponse carEnexResponse, Long parkId, String parkCode, String channelCode, Integer enexType, String plateNum, Integer openFlagRequest, String serialNumber) {
        String msgId;
        if (carEnexResponse == null) {
            return;
        }
        List<ParkConnectedDeviceVo> connectedList = this.cacheHandle.getConnectedList(parkCode, channelCode);
        if (CollectionUtils.isEmpty(connectedList) || connectedList.size() < 2) {
            return;
        }
        ParkConnectedDeviceVo vo = connectedList.stream().filter(parkConnectedDeviceVo -> enexType.equals(parkConnectedDeviceVo.getInandoutType())).filter(parkConnectedDeviceVo -> !serialNumber.equals(parkConnectedDeviceVo.getDeviceNo())).findFirst().orElse(null);
        if (vo == null) {
            return;
        }
        String anotherSn = vo.getDeviceNo();
        log.info("[\u53cc\u6444\u4e1a\u52a1] \u901a\u9053[{}]\u4e0a\u62a5\u4e86\u8fdb\u51fa\u4e8b\u4ef6, \u53e6\u4e00\u4e2a\u8bbe\u5907SN[{}]", (Object)channelCode, (Object)anotherSn);
        Integer openFlag = carEnexResponse.getOpenFlag();
        Integer showType = carEnexResponse.getShowType();
        String show = carEnexResponse.getShow();
        String say = carEnexResponse.getSay();
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(anotherSn);
        if (deviceInfo == null) {
            log.info("[\u53cc\u6444\u4e1a\u52a1] \u8bbe\u5907\u4e0d\u5728\u7ebf, anotherSn[{}]", (Object)anotherSn);
            return;
        }
        if ((NumberUtils.toPrimitive((Integer)openFlagRequest) == 1 || NumberUtils.toPrimitive((Integer)openFlag) == 1) && (msgId = this.remoteSwitchService.open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, parkCode, anotherSn, plateNum)) == null) {
            log.info("[\u53cc\u6444\u4e1a\u52a1] \u5f00\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25, plateNum[{}]", (Object)plateNum);
        }
        if (StringUtils.isNotBlank((CharSequence)show) || StringUtils.isNotBlank((CharSequence)say)) {
            String msgId2;
            LcdHintRequest hintRequest;
            Integer showDeviceType = carEnexResponse.getShowDeviceType();
            if (showDeviceType == null) {
                ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, channelCode);
                ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
                showDeviceType = channel.getLedLcdSource();
            }
            if (NumberUtils.toPrimitive((Integer)showDeviceType) == 2) {
                hintRequest = new LcdHintRequest();
                hintRequest.setShow(show);
                hintRequest.setSay(say);
                hintRequest.setPlateNum(plateNum);
                hintRequest.setQrCodeUrl(carEnexResponse.getQrCodeUrl());
                msgId2 = this.lcdHintService.showAndSay(parkId, parkCode, anotherSn, hintRequest);
                if (msgId2 == null) {
                    log.info("[\u53cc\u6444\u4e1a\u52a1] \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25, \u53c2\u6570[{}]", (Object)hintRequest);
                }
            } else {
                hintRequest = new HintRequest();
                hintRequest.setShow(show);
                hintRequest.setSay(say);
                hintRequest.setPlateNum(plateNum);
                hintRequest.setShowType(showType);
                hintRequest.setExtendShow(carEnexResponse.getExtendShow());
                msgId2 = this.hintService.showAndSay(parkId, parkCode, anotherSn, (HintRequest)hintRequest);
                if (msgId2 == null) {
                    log.info("[\u53cc\u6444\u4e1a\u52a1] \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25, \u53c2\u6570[{}]", (Object)hintRequest);
                }
            }
        }
    }

    @Async
    public void lcdHint(Long parkId, String parkCode, String channelCode, String serialNumber, LcdHintRequest hintRequest) {
        ParkConnectedDeviceVo vo = this.anotherCamera(parkCode, channelCode, serialNumber);
        if (vo == null) {
            return;
        }
        this.lcdHintService.showAndSay(parkId, parkCode, vo.getDeviceNo(), hintRequest);
    }

    @Async
    public void ledHint(Long parkId, String parkCode, String channelCode, String serialNumber, HintRequest hintRequest) {
        ParkConnectedDeviceVo vo = this.anotherCamera(parkCode, channelCode, serialNumber);
        if (vo == null) {
            return;
        }
        this.hintService.showAndSay(parkId, parkCode, vo.getDeviceNo(), hintRequest);
    }

    @Async
    public void remoteSwitch(Long parkId, String parkCode, String channelCode, String serialNumber, HintRequest hintRequest) {
        ParkConnectedDeviceVo vo = this.anotherCamera(parkCode, channelCode, serialNumber);
        if (vo == null) {
            return;
        }
        this.hintService.showAndSay(parkId, parkCode, vo.getDeviceNo(), hintRequest);
    }

    private ParkConnectedDeviceVo anotherCamera(String parkCode, String channelCode, String serialNumber) {
        List<ParkConnectedDeviceVo> connectedList = this.cacheHandle.getConnectedList(parkCode, channelCode);
        if (CollectionUtils.isEmpty(connectedList) || connectedList.size() < 2) {
            return null;
        }
        return connectedList.stream().filter(parkConnectedDeviceVo -> !serialNumber.equals(parkConnectedDeviceVo.getDeviceNo())).findFirst().orElse(null);
    }
}

