/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ChannelRecentPlateNumsVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.FixSizeLinkedList;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.dao.ChannelDualcameraDao;
import com.icetech.park.domain.entity.ChannelDualcamera;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DualCameraServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DualCameraServiceImpl.class);
    @Autowired
    private ChannelDualcameraDao channelDualcameraDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private ParkService parkService;
    private static final int INTERVAL = 50;

    public ResultCode preHandle(P2cBaseRequest p2CBaseRequest, Long parkId, String parkCode, String deviceNo, String inandoutCode, Integer inandoutType, boolean isMaster) {
        this.saveChannelDualCamera(p2CBaseRequest, parkId, inandoutCode, inandoutType, deviceNo, isMaster);
        ChannelRecentPlateNumsVo channelRecentPlateNumsVo = this.resolveParamAndGetChannelPlateNumByinandoutType(p2CBaseRequest, inandoutType);
        FixSizeLinkedList<ChannelRecentPlateNumsVo> msPlateNums = this.cacheHandle.getMSPlateNums(parkCode, inandoutCode);
        if (msPlateNums != null && msPlateNums.contains((Object)channelRecentPlateNumsVo)) {
            log.info("<\u53cc\u6444\u76f8\u673a\u524d\u7f6e\u5904\u7406> \u8be5\u901a\u9053\u6700\u8fd1\u4e0a\u62a5\u8f66\u724c\u4e2d\u5df2\u5904\u7406\u8fc7\u8be5\u8f66\u724c\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)channelRecentPlateNumsVo.getPlateNum());
            throw new ResponseBodyException("405", "\u6b64\u8f66\u724c\u5df2\u7ecf\u5904\u7406\u8fc7");
        }
        int WAIT_TIME = 500;
        int SHIBIE_BETWEEN_TIME = 2000;
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess((Response)configObjectResponse)) {
            if (((ParkConfig)configObjectResponse.getData()).getDualcameraTime() != null) {
                WAIT_TIME = ((ParkConfig)configObjectResponse.getData()).getDualcameraTime();
            }
            if (((ParkConfig)configObjectResponse.getData()).getDualcameraEnextime() != null) {
                SHIBIE_BETWEEN_TIME = ((ParkConfig)configObjectResponse.getData()).getDualcameraEnextime();
            }
        }
        SHIBIE_BETWEEN_TIME /= 1000;
        String slave_key = "SLAVE_CHANNEL_" + parkCode + inandoutCode;
        String master_key = "MASTER_CHANNEL_" + parkCode + inandoutCode;
        if (!isMaster) {
            this.redisUtils.setExpireMilliSeconds(slave_key, (Object)p2CBaseRequest, Long.valueOf(WAIT_TIME));
            if (this.redisUtils.exists(master_key)) {
                log.info("<\u53cc\u6444\u76f8\u673a\u524d\u7f6e\u5904\u7406> \u4e3b\u76f8\u673a\u5df2\u4e0a\u62a5\uff0c\u4ece\u76f8\u673a\u65e0\u9700\u5904\u7406\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)channelRecentPlateNumsVo.getPlateNum());
                throw new ResponseBodyException("406", "\u4e3b\u76f8\u673a\u5df2\u4e0a\u62a5\uff0c\u4ece\u76f8\u673a\u65e0\u9700\u5904\u7406");
            }
        } else {
            this.redisUtils.setExpireMilliSeconds(master_key, (Object)p2CBaseRequest, Long.valueOf(WAIT_TIME));
        }
        P2cBaseRequest otherCameraData = this.getOtherCameraData(parkCode, inandoutCode, isMaster, WAIT_TIME);
        this.cacheHandle.addMSPlateNums(parkCode, inandoutCode, channelRecentPlateNumsVo);
        if (otherCameraData == null) {
            if (isMaster) {
                return ResultCode.\u4e3b\u76f8\u673a\u8bc6\u522b_\u4ece\u76f8\u673a\u672a\u8bc6\u522b;
            }
            return ResultCode.\u4ece\u76f8\u673a\u8bc6\u522b_\u4e3b\u76f8\u673a\u5728\u7ebf;
        }
        if (!isMaster) {
            throw new ResponseBodyException("406", "\u4e3b\u4ece\u76f8\u673a\u90fd\u4e0a\u62a5\uff0c\u4ece\u76f8\u673a\u65e0\u9700\u5904\u7406");
        }
        ResultCode resultCode = ResultCode.\u4e3b\u4ece\u90fd\u8bc6\u522b_\u672a\u5f00\u95f8;
        if (inandoutType == 1) {
            CarEnterRequest enterRequest = (CarEnterRequest)p2CBaseRequest.getBizContent();
            CarEnterRequest otherEnterRequest = (CarEnterRequest)JsonUtils.convert2bean((Object)otherCameraData.getBizContent(), CarEnterRequest.class);
            if (enterRequest.getOpenFlag() == 1 || otherEnterRequest.getOpenFlag() == 1) {
                resultCode = ResultCode.\u4e3b\u4ece\u90fd\u8bc6\u522b_\u5df2\u5f00\u95f8;
            }
            if (enterRequest.getPlateNum().equals(otherEnterRequest.getPlateNum())) {
                if (enterRequest.getReliability() < otherEnterRequest.getReliability()) {
                    p2CBaseRequest.setBizContent((Object)otherEnterRequest);
                } else if (enterRequest.getReliability().equals(otherEnterRequest.getReliability()) && enterRequest.getEnterTime() < otherEnterRequest.getEnterTime()) {
                    p2CBaseRequest.setBizContent((Object)otherEnterRequest);
                }
            } else if (enterRequest.getCarType().equals(PlateTypeEnum.\u4e34\u65f6\u8f66.getType()) && !otherEnterRequest.getCarType().equals(PlateTypeEnum.\u4e34\u65f6\u8f66.getType())) {
                p2CBaseRequest.setBizContent((Object)otherEnterRequest);
            } else if (Math.abs(enterRequest.getEnterTime() - otherEnterRequest.getEnterTime()) <= (long)SHIBIE_BETWEEN_TIME) {
                if (enterRequest.getReliability() < otherEnterRequest.getReliability()) {
                    p2CBaseRequest.setBizContent((Object)otherEnterRequest);
                } else if (enterRequest.getReliability().equals(otherEnterRequest.getReliability()) && enterRequest.getEnterTime() < otherEnterRequest.getEnterTime()) {
                    p2CBaseRequest.setBizContent((Object)otherEnterRequest);
                }
            } else if (enterRequest.getEnterTime() < otherEnterRequest.getEnterTime()) {
                p2CBaseRequest.setBizContent((Object)otherEnterRequest);
            }
        } else {
            CarExitRequest exitRequest = (CarExitRequest)p2CBaseRequest.getBizContent();
            CarExitRequest otherExitRequest = (CarExitRequest)JsonUtils.convert2bean((Object)otherCameraData.getBizContent(), CarExitRequest.class);
            if (exitRequest.getOpenFlag() == 1 || otherExitRequest.getOpenFlag() == 1) {
                resultCode = ResultCode.\u4e3b\u4ece\u90fd\u8bc6\u522b_\u5df2\u5f00\u95f8;
            }
            if (exitRequest.getPlateNum().equals(otherExitRequest.getPlateNum())) {
                if (exitRequest.getReliability() < otherExitRequest.getReliability()) {
                    p2CBaseRequest.setBizContent((Object)otherExitRequest);
                } else if (exitRequest.getReliability().equals(otherExitRequest.getReliability()) && exitRequest.getExitTime() < otherExitRequest.getExitTime()) {
                    p2CBaseRequest.setBizContent((Object)otherExitRequest);
                }
            } else if (exitRequest.getCarType().equals(PlateTypeEnum.\u4e34\u65f6\u8f66.getType()) && !otherExitRequest.getCarType().equals(PlateTypeEnum.\u4e34\u65f6\u8f66.getType())) {
                p2CBaseRequest.setBizContent((Object)otherExitRequest);
            } else if (Math.abs(exitRequest.getExitTime() - otherExitRequest.getExitTime()) <= (long)SHIBIE_BETWEEN_TIME) {
                if (exitRequest.getReliability() < otherExitRequest.getReliability()) {
                    p2CBaseRequest.setBizContent((Object)otherExitRequest);
                } else if (exitRequest.getReliability().equals(otherExitRequest.getReliability()) && exitRequest.getExitTime() < otherExitRequest.getExitTime()) {
                    p2CBaseRequest.setBizContent((Object)otherExitRequest);
                }
            } else if (exitRequest.getExitTime() < otherExitRequest.getExitTime()) {
                p2CBaseRequest.setBizContent((Object)otherExitRequest);
            }
        }
        return resultCode;
    }

    public P2cBaseResponse afterHandle(P2cBaseResponse p2cBaseResponse, Long parkId, String parkCode, String inandoutCode, Integer inandoutType, P2cBaseRequest p2cBaseRequest, ResultCode resultCode) {
        CarEnexResponse carEnexResponse = (CarEnexResponse)p2cBaseResponse.getData();
        Integer openFlag = carEnexResponse.getOpenFlag();
        Integer showType = carEnexResponse.getShowType();
        String show = carEnexResponse.getShow();
        String say = carEnexResponse.getSay();
        if (resultCode.equals((Object)ResultCode.\u4e3b\u4ece\u90fd\u8bc6\u522b_\u5df2\u5f00\u95f8)) {
            CarEnexResponse response = (CarEnexResponse)p2cBaseResponse.getData();
            response.setOpenFlag(Integer.valueOf(0));
            response.setShow(null);
            response.setSay(null);
            p2cBaseResponse.setData((Object)response);
            return p2cBaseResponse;
        }
        String serialNumber = this.cacheHandle.getSerialNumber(parkCode, inandoutCode);
        String plateNum = null;
        if (inandoutType == 1) {
            CarEnterRequest enterRequest = (CarEnterRequest)JsonUtils.convert2bean((Object)p2cBaseRequest.getBizContent(), CarEnterRequest.class);
            plateNum = enterRequest.getPlateNum();
        } else {
            CarExitRequest exitRequest = (CarExitRequest)JsonUtils.convert2bean((Object)p2cBaseRequest.getBizContent(), CarExitRequest.class);
            plateNum = exitRequest.getPlateNum();
        }
        boolean isMasterDone = false;
        if (openFlag != null && openFlag == 1) {
            String msgId = this.remoteSwitchService.open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, parkCode, serialNumber, plateNum);
            if (msgId == null) {
                log.info("<\u5e73\u53f0\u79bb\u573a> \u5f00\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
            } else {
                isMasterDone = true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)show) || StringUtils.isNotBlank((CharSequence)say)) {
            HintRequest hintRequest = new HintRequest();
            hintRequest.setShow(show);
            hintRequest.setSay(say);
            hintRequest.setPlateNum(plateNum);
            hintRequest.setShowType(showType);
            String msgId = this.hintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
            if (msgId == null) {
                log.info("<\u5e73\u53f0\u79bb\u573a> \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
            } else {
                isMasterDone = true;
            }
        }
        if (isMasterDone) {
            CarEnexResponse response = (CarEnexResponse)p2cBaseResponse.getData();
            response.setOpenFlag(Integer.valueOf(0));
            response.setShow(null);
            response.setSay(null);
            p2cBaseResponse.setData((Object)response);
            return p2cBaseResponse;
        }
        return p2cBaseResponse;
    }

    private void saveChannelDualCamera(P2cBaseRequest p2CBaseRequest, Long parkId, String inandoutCode, int inandoutType, String serialNumber, boolean isMaster) {
        ChannelDualcamera channelDualcamera = new ChannelDualcamera();
        channelDualcamera.setParkId(parkId);
        channelDualcamera.setEnexType(Integer.valueOf(inandoutType));
        channelDualcamera.setChannelCode(inandoutCode);
        channelDualcamera.setMsType(Boolean.valueOf(isMaster));
        channelDualcamera.setSerialNumber(serialNumber);
        channelDualcamera.setParameter(JsonUtils.toString((Object)p2CBaseRequest));
        this.channelDualcameraDao.insert(channelDualcamera);
    }

    private ChannelRecentPlateNumsVo resolveParamAndGetChannelPlateNumByinandoutType(P2cBaseRequest p2CBaseRequest, int inandoutType) {
        ChannelRecentPlateNumsVo channelRecentPlateNumsVo = new ChannelRecentPlateNumsVo();
        if (inandoutType == 1) {
            CarEnterRequest enterRequest = (CarEnterRequest)JsonUtils.convert2bean((Object)p2CBaseRequest.getBizContent(), CarEnterRequest.class);
            channelRecentPlateNumsVo.setEnexType(inandoutType);
            channelRecentPlateNumsVo.setEnexTime(enterRequest.getEnterTime());
            channelRecentPlateNumsVo.setPlateNum(enterRequest.getPlateNum());
            p2CBaseRequest.setBizContent((Object)enterRequest);
        } else {
            CarExitRequest exitRequest = (CarExitRequest)JsonUtils.convert2bean((Object)p2CBaseRequest.getBizContent(), CarExitRequest.class);
            channelRecentPlateNumsVo.setEnexType(inandoutType);
            channelRecentPlateNumsVo.setEnexTime(exitRequest.getExitTime());
            channelRecentPlateNumsVo.setPlateNum(exitRequest.getPlateNum());
            p2CBaseRequest.setBizContent((Object)exitRequest);
        }
        return channelRecentPlateNumsVo;
    }

    public P2cBaseRequest getOtherCameraData(String parkCode, String inandoutCode, boolean isMaster, int WAIT_TIME) {
        String key = null;
        key = isMaster ? "SLAVE_CHANNEL_" + parkCode + inandoutCode : "MASTER_CHANNEL_" + parkCode + inandoutCode;
        Long currentTimeMillis = System.currentTimeMillis();
        Long lastTime = currentTimeMillis + (long)WAIT_TIME;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            if (this.redisUtils.exists(key)) {
                P2cBaseRequest data = (P2cBaseRequest)this.redisUtils.get(key, P2cBaseRequest.class);
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86{}\u76f8\u673a\u7684\u4e0a\u62a5\u4fe1\u606f\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}\uff0c\u901a\u9053\u7f16\u53f7\uff1a{}", new Object[]{n, isMaster ? "\u4e3b" : "\u4ece", parkCode, inandoutCode});
                return data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("{}\u76f8\u673a\u672a\u7b49\u5230\u53e6\u4e00\u76f8\u673a\u7684\u4e0a\u62a5\u4fe1\u606f\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}\uff0c\u901a\u9053\u7f16\u53f7\uff1a{}", new Object[]{isMaster ? "\u4e3b" : "\u4ece", parkCode, inandoutCode});
        return null;
    }

    public static enum ResultCode {
        \u65e0\u9700\u5904\u7406(0),
        \u4e3b\u76f8\u673a\u8bc6\u522b_\u4ece\u76f8\u673a\u672a\u8bc6\u522b(1),
        \u4e3b\u4ece\u90fd\u8bc6\u522b_\u672a\u5f00\u95f8(2),
        \u4e3b\u4ece\u90fd\u8bc6\u522b_\u5df2\u5f00\u95f8(3),
        \u4ece\u76f8\u673a\u8bc6\u522b_\u4e3b\u76f8\u673a\u5728\u7ebf(4),
        \u4ece\u76f8\u673a\u8bc6\u522b_\u4e3b\u76f8\u673a\u4e0d\u5728\u7ebf(5);

        private Integer code;

        private ResultCode(int code) {
            this.code = code;
        }

        public String toString() {
            return "DualCameraServiceImpl.ResultCode." + this.name() + "(code=" + this.code + ")";
        }
    }

    public static class FlowRet {
        private ResultCode resultCode;
        private Object para;

        public void setResultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
        }

        public void setPara(Object para) {
            this.para = para;
        }

        public ResultCode getResultCode() {
            return this.resultCode;
        }

        public Object getPara() {
            return this.para;
        }

        public String toString() {
            return "DualCameraServiceImpl.FlowRet(resultCode=" + (Object)((Object)this.getResultCode()) + ", para=" + this.getPara() + ")";
        }
    }
}

