/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.SendMessage;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.validator.Validator;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.third.utils.JsonUtils;
import com.icetech.third.utils.RedisUtils;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DownSendServiceImpl
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(DownSendServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse<?> send(SendRequest sendRequest) {
        try {
            if (!Validator.validate((Object)sendRequest)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"", (String)"\u4e0b\u53d1\u53c2\u6570\u6821\u9a8c\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"", (String)"\u4e0b\u53d1\u53c2\u6570\u6821\u9a8c\u5931\u8d25"));
        }
        Long parkId = sendRequest.getParkId();
        ObjectResponse parkConfigResponse = this.parkService.getParkConfig(parkId);
        if (!ObjectResponse.isSuccess((Response)parkConfigResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"", (String)"\u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u573a\u914d\u7f6e\u672a\u627e\u5230"));
        }
        ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
        if (parkConfig.getDataCollection() == null) {
            log.warn("<\u4e0b\u53d1\u4e1a\u52a1> \u8f66\u573a\u6570\u636e\u91c7\u96c6\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u53c2\u6570\uff1a{}", (Object)sendRequest);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"", (String)"\u8f66\u573a\u6570\u636e\u91c7\u96c6\u65b9\u5f0f\u672a\u914d\u7f6e"));
        }
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.\u7aef\u4e91.getType())) {
            return this.p2cDown(sendRequest, parkId);
        }
        if (parkConfig.getDataCollection().equals(DataCollectionEnum.\u7eaf\u4e91.getType())) {
            return this.fullCloudDown(sendRequest, parkId);
        }
        return DownSendServiceImpl.pncDown(sendRequest);
    }

    private static ObjectResponse<?> pncDown(SendRequest sendRequest) {
        ObjectResponse response;
        DownSendService downSendService;
        try {
            downSendService = SendServiceFactory.createSendService(sendRequest.getServiceType());
        }
        catch (Exception e) {
            log.warn("\u7aef\u7f51\u4e91\u672a\u627e\u5230\u5177\u4f53\u7684serviceBean\u4fe1\u606f");
            return ObjectResponse.failed((String)"406", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u65e0\u9700\u4e0b\u53d1"));
        }
        try {
            response = downSendService.send(sendRequest);
            if (!"200".equals(response.getCode()) && !"12002".equals(response.getCode())) {
                try {
                    JsonUtils.fromJson((String)response.getMsg(), (TypeReference)new TypeReference<SendMessage>(){});
                    return response;
                }
                catch (Exception e) {
                    SendMessage sendMessage = SendMessage.builder().type(DataCollectionEnum.\u7aef\u7f51\u4e91.getType().toString()).describes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay(response.getMsg()).build())).build();
                    String msg = JsonUtils.toJson((Object)sendMessage);
                    response.setMsg(msg);
                    return response;
                }
            }
        }
        catch (ResponseBodyException e) {
            log.warn("\u7aef\u7f51\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f-{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)TextConstant.getDefaultMessage((String)"2", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        catch (Exception e) {
            log.error("\u7aef\u7f51\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f, e=", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        return response;
    }

    private ObjectResponse<?> fullCloudDown(SendRequest sendRequest, Long parkId) {
        ObjectResponse response;
        DownService sendService;
        ObjectResponse parkResponse = this.parkService.findByParkId(parkId);
        if (!ObjectResponse.isSuccess((Response)parkResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u8f66\u573a\u6570\u636e\u672a\u627e\u5230"));
        }
        Park park = (Park)parkResponse.getData();
        try {
            sendService = SendServiceFactory.createFullCloudSendService(sendRequest.getServiceType());
        }
        catch (Exception e) {
            return ObjectResponse.failed((String)"406", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u65e0\u9700\u4e0b\u53d1"));
        }
        Integer batchServiceType = sendRequest.getServiceType();
        if (this.redisUtils.exists("batchdown:open:" + parkId + ":" + batchServiceType)) {
            return ObjectResponse.failed((String)"406", (String)TextConstant.getDefaultMessage((String)"3", (String)"\u6279\u91cf\u4e0b\u53d1\u4e2d"));
        }
        try {
            response = sendService.send(sendRequest, park.getParkCode());
            if (!"200".equals(response.getCode()) && !"12002".equals(response.getCode())) {
                try {
                    JsonUtils.fromJson((String)response.getMsg(), (TypeReference)new TypeReference<SendMessage>(){});
                    return response;
                }
                catch (Exception e) {
                    SendMessage sendMessage = SendMessage.builder().type(DataCollectionEnum.\u7eaf\u4e91.getType().toString()).describes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay(response.getMsg() == null ? "\u4e0b\u53d1\u5931\u8d25" : response.getMsg()).build())).build();
                    String msg = JsonUtils.toJson((Object)sendMessage);
                    response.setMsg(msg);
                }
            }
        }
        catch (ResponseBodyException e) {
            log.warn("\u7eaf\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f-{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)TextConstant.getDefaultMessage((String)"3", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        catch (Exception e) {
            log.error("\u7eaf\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"3", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        return response;
    }

    private ObjectResponse<?> p2cDown(SendRequest sendRequest, Long parkId) {
        ObjectResponse response;
        DownService sendService;
        ObjectResponse parkResponse = this.parkService.findByParkId(parkId);
        if (!ObjectResponse.isSuccess((Response)parkResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u8f66\u573a\u6570\u636e\u672a\u627e\u5230"));
        }
        Park park = (Park)parkResponse.getData();
        try {
            sendService = SendServiceFactory.createP2cSendService(sendRequest.getServiceType());
        }
        catch (Exception e) {
            return ObjectResponse.failed((String)"406", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u65e0\u9700\u4e0b\u53d1"));
        }
        Integer batchServiceType = sendRequest.getServiceType();
        if (P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType().equals(sendRequest.getServiceType())) {
            batchServiceType = P2cDownCmdEnum.\u8f66\u573a\u6743\u9650\u4e0b\u53d1.getCmdType();
        }
        if (this.redisUtils.exists("batchdown:open:" + parkId + ":" + batchServiceType)) {
            return ObjectResponse.failed((String)"406", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u6279\u91cf\u4e0b\u53d1\u4e2d"));
        }
        try {
            response = sendService.send(sendRequest, park.getParkCode());
            if (!"200".equals(response.getCode()) && !"12002".equals(response.getCode())) {
                try {
                    JsonUtils.fromJson((String)response.getMsg(), (TypeReference)new TypeReference<SendMessage>(){});
                    return response;
                }
                catch (Exception e) {
                    SendMessage sendMessage = SendMessage.builder().type(DataCollectionEnum.\u7aef\u4e91.getType().toString()).describes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay(response.getMsg() == null ? "\u4e0b\u53d1\u5931\u8d25" : response.getMsg()).build())).build();
                    String msg = JsonUtils.toJson((Object)sendMessage);
                    response.setMsg(msg);
                }
            }
        }
        catch (ResponseBodyException e) {
            log.warn("\u7aef\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f-{}", (Object)e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)TextConstant.getDefaultMessage((String)"1", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        catch (Exception e) {
            log.error("\u7aef\u4e91\u4e0b\u53d1\u5931\u8d25\u4fe1\u606f", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)(e.getMessage() == null ? "\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        return response;
    }
}

