/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.icetech.basics.api.DictionaryItemService;
import com.icetech.basics.domain.dto.DictionaryItemDto;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.IDeviceManageService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.BatchUpgradeRequest;
import com.icetech.cloudcenter.domain.request.DeviceUpgradeRequest;
import com.icetech.cloudcenter.domain.request.FirmwareListRequest;
import com.icetech.cloudcenter.domain.request.SaveFirmwareRequest;
import com.icetech.cloudcenter.domain.request.UpgradeLogListRequest;
import com.icetech.cloudcenter.domain.request.p2c.UpgradeRequest;
import com.icetech.cloudcenter.domain.response.BatchUpgradeValidateResponse;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.cloudcenter.domain.response.FirmwareListResponse;
import com.icetech.cloudcenter.domain.response.SupportUpgradeDeviceResponse;
import com.icetech.cloudcenter.domain.response.UpgradeLogListResponse;
import com.icetech.cloudcenter.domain.response.UpgradeProgressResponse;
import com.icetech.cloudcenter.domain.response.ValidateUpgradeResponse;
import com.icetech.cloudcenter.domain.response.ValidateVersionResponse;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.UUIDTools;
import com.icetech.common.validator.Validator;
import com.icetech.park.dao.FileDao;
import com.icetech.park.dao.FirmwareDao;
import com.icetech.park.dao.FirmwareUpgradeDao;
import com.icetech.park.domain.dto.FirmwareDTO;
import com.icetech.park.domain.dto.FirmwareListDTO;
import com.icetech.park.domain.dto.FirmwareUpgradeListDTO;
import com.icetech.park.domain.entity.File;
import com.icetech.park.domain.entity.Firmware;
import com.icetech.park.domain.entity.FirmwareUpgrade;
import com.icetech.park.service.down.p2c.impl.UpgradeServiceImpl;
import com.icetech.park.service.handle.DeviceUpgradeHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceManageServiceImpl
implements IDeviceManageService {
    private static final Logger log = LoggerFactory.getLogger(DeviceManageServiceImpl.class);
    @Autowired
    private UpgradeServiceImpl upgradeService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private FirmwareDao firmwareDao;
    @Autowired
    private FirmwareUpgradeDao firmwareUpgradeDao;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private DictionaryItemService dictionaryItemService;
    @Autowired
    private DeviceUpgradeHandle deviceUpgradeHandle;
    @Autowired
    private FileDao fileDao;
    private int DICTIONARY_TYPEID = 8;

    public ObjectResponse upgrade(DeviceUpgradeRequest deviceUpgradeRequest) {
        FirmwareUpgrade waitTask;
        boolean validator = Validator.validate((Object)deviceUpgradeRequest);
        if (!validator) {
            return ObjectResponse.failed((String)"400");
        }
        ObjectResponse deviceObjectResponse = this.parkDeviceService.getDeviceBySerialNumber(deviceUpgradeRequest.getSn());
        if (!ObjectResponse.isSuccess((Response)deviceObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        ParkDevice parkDevice = (ParkDevice)deviceObjectResponse.getData();
        Long parkId = (long)parkDevice.getParkId();
        ObjectResponse inoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().intValue()));
        if (!ObjectResponse.isSuccess((Response)inoutdeviceObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutdeviceObjectResponse.getData();
        ObjectResponse dictionaryItems = this.dictionaryItemService.findListByTypeId(Integer.valueOf(this.DICTIONARY_TYPEID));
        if (!ObjectResponse.isSuccess((Response)dictionaryItems)) {
            return ObjectResponse.failed((String)"402", (String)"\u8bbe\u5907\u578b\u53f7\u672a\u914d\u7f6e");
        }
        List itemDtos = ((List)dictionaryItems.getData()).stream().filter(item -> item.getText().equals(parkDevice.getProductModel())).collect(Collectors.toList());
        if (itemDtos == null || itemDtos.size() == 0) {
            return ObjectResponse.failed((String)"402", (String)"\u4e0d\u652f\u6301\u5347\u7ea7\u8be5\u578b\u53f7\u8bbe\u5907");
        }
        DictionaryItemDto dictionaryItemDto = (DictionaryItemDto)itemDtos.get(0);
        FirmwareDTO firmwareDTO = this.firmwareDao.selectByModelAndVer(dictionaryItemDto.getValue(), deviceUpgradeRequest.getNewFirmwareVer());
        if (firmwareDTO == null || firmwareDTO.getFilePath() == null) {
            return ObjectResponse.failed((String)"402", (String)"\u4e0d\u5b58\u5728\u8be5\u7248\u672c\u7684\u5347\u7ea7\u5305");
        }
        FirmwareUpgrade runningTask = this.firmwareUpgradeDao.selectTaskBySnAndStatus(deviceUpgradeRequest.getSn(), FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u4e2d.status);
        if (runningTask != null) {
            Date actionTime = runningTask.getActionTime();
            long now = DateTools.unixTimestamp();
            if (now - actionTime.getTime() / 1000L > 600L) {
                runningTask.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u5931\u8d25.status));
                runningTask.setReason("\u8bbe\u5907\u54cd\u5e94\u8d85\u65f6");
                runningTask.setUpdateTime(new Date());
                this.firmwareUpgradeDao.updateById(runningTask);
            } else {
                return ObjectResponse.failed((String)"402", (String)"\u5f53\u524d\u8bbe\u5907\u6b63\u5728\u5347\u7ea7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            }
        }
        if ((waitTask = this.firmwareUpgradeDao.selectTaskBySnAndStatus(deviceUpgradeRequest.getSn(), FirmwareUpgrade.StatusEnum.\u5f85\u5347\u7ea7.status)) != null) {
            waitTask.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u5931\u8d25.status));
            waitTask.setReason("\u88ab\u65b0\u4efb\u52a1\u53d6\u6d88");
            waitTask.setUpdateTime(new Date());
            this.firmwareUpgradeDao.updateById(waitTask);
        }
        DateTime actionTime = DateUtil.parseDateTime((CharSequence)deviceUpgradeRequest.getActionTime());
        long now = System.currentTimeMillis();
        boolean isNowAction = true;
        if (actionTime.getTime() > now) {
            isNowAction = false;
        }
        FirmwareUpgrade firmwareUpgrade = new FirmwareUpgrade();
        firmwareUpgrade.setParkId(parkId);
        firmwareUpgrade.setSn(deviceUpgradeRequest.getSn());
        firmwareUpgrade.setDeviceType(deviceUpgradeRequest.getDeviceType());
        firmwareUpgrade.setChannelName(parkInoutdevice.getInandoutName());
        firmwareUpgrade.setActionTime(isNowAction ? new Date() : actionTime);
        firmwareUpgrade.setOperAccount(deviceUpgradeRequest.getOperAccount());
        firmwareUpgrade.setProductModel(parkDevice.getProductModel());
        firmwareUpgrade.setSourceVer(parkDevice.getFirmwareVersion());
        firmwareUpgrade.setTargetVer(deviceUpgradeRequest.getNewFirmwareVer());
        firmwareUpgrade.setFileId(firmwareDTO.getFileId());
        firmwareUpgrade.setUpgradeChannel(Integer.valueOf(parkDevice.getStatus() == 3 ? 2 : 1));
        String taskId = UUIDTools.generateShortUuid();
        firmwareUpgrade.setTaskId(taskId);
        this.firmwareUpgradeDao.insert(firmwareUpgrade);
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("taskId", taskId);
        if (isNowAction) {
            UpgradeRequest upgradeRequest = new UpgradeRequest();
            upgradeRequest.setNewFirmwareVer(deviceUpgradeRequest.getNewFirmwareVer());
            upgradeRequest.setSendTime(Long.valueOf(DateTools.unixTimestamp()));
            upgradeRequest.setFirmwarePath(firmwareDTO.getFilePath());
            upgradeRequest.setFirmwareSize(String.valueOf(firmwareDTO.getFileSize()));
            upgradeRequest.setTaskId(taskId);
            upgradeRequest.setUpgradeChannel(firmwareUpgrade.getUpgradeChannel());
            this.upgradeService.execute(upgradeRequest, deviceUpgradeRequest.getSn(), parkId);
        }
        return ObjectResponse.success(ret);
    }

    public ObjectResponse batchUpgrade(BatchUpgradeRequest batchUpgradeRequest) {
        boolean validator = Validator.validate((Object)batchUpgradeRequest);
        if (!validator) {
            return ObjectResponse.failed((String)"400");
        }
        String sns = batchUpgradeRequest.getSns();
        ArrayList msgList = new ArrayList();
        Arrays.stream(sns.split(",")).forEach(sn -> {
            DeviceUpgradeRequest deviceUpgradeRequest = new DeviceUpgradeRequest();
            BeanUtil.copyProperties((Object)batchUpgradeRequest, (Object)deviceUpgradeRequest, (String[])new String[0]);
            deviceUpgradeRequest.setSn(sn);
            ObjectResponse objectResponse = this.upgrade(deviceUpgradeRequest);
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                msgList.add(sn + ":" + objectResponse.getMsg());
            }
        });
        if (msgList.size() != 0) {
            String msg = StringUtils.join((Object[])msgList.toArray(), (String)";");
            return ObjectResponse.failed((String)"402", (String)msg);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<BatchUpgradeValidateResponse> batchUpgradeValidate(String sns) {
        if (sns == null) {
            return ObjectResponse.failed((String)"400");
        }
        BatchUpgradeValidateResponse batchUpgradeValidateResponse = new BatchUpgradeValidateResponse();
        int upgradingCount = 0;
        int upgradableCount = 0;
        for (String sn : sns.split(",")) {
            ObjectResponse<ValidateUpgradeResponse> objectResponse = this.validateUpgrade(sn);
            if (ObjectResponse.isSuccess(objectResponse)) {
                ++upgradableCount;
                continue;
            }
            ++upgradingCount;
        }
        batchUpgradeValidateResponse.setUpgradableCount(Integer.valueOf(upgradableCount));
        batchUpgradeValidateResponse.setUpgradingCount(Integer.valueOf(upgradingCount));
        return ObjectResponse.success((Object)batchUpgradeValidateResponse);
    }

    public ObjectResponse<Page<FirmwareListResponse>> firmwareList(FirmwareListRequest firmwareListRequest) {
        PageHelper.startPage((int)firmwareListRequest.getPageNo(), (int)firmwareListRequest.getPageSize());
        List<FirmwareListDTO> firmwareListDTOS = this.firmwareDao.selectListByParam(firmwareListRequest.getProductModelId(), firmwareListRequest.getFirmwareVersion(), firmwareListRequest.getStartTime(), firmwareListRequest.getEndTime());
        if (CollectionUtil.isEmpty(firmwareListDTOS)) {
            return ObjectResponse.failed((String)"404");
        }
        PageInfo pageInfo = new PageInfo(firmwareListDTOS);
        Page page = new Page();
        ArrayList respList = new ArrayList();
        firmwareListDTOS.forEach(dto -> {
            FirmwareListResponse firmwareListResponse = new FirmwareListResponse();
            BeanUtil.copyProperties((Object)dto, (Object)firmwareListResponse, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
            respList.add(firmwareListResponse);
        });
        page.setRows(respList);
        page.setTotal(Long.valueOf(pageInfo.getTotal()));
        page.setTotalPage(Integer.valueOf(pageInfo.getPages()));
        return ObjectResponse.success((Object)page);
    }

    public ObjectResponse saveFirmware(SaveFirmwareRequest saveFirmwareRequest) {
        boolean validator = Validator.validate((Object)saveFirmwareRequest);
        if (!validator) {
            return ObjectResponse.failed((String)"400");
        }
        Integer firmwareId = saveFirmwareRequest.getFirmwareId();
        Firmware firmware = new Firmware();
        firmware.setId(saveFirmwareRequest.getFirmwareId());
        firmware.setFirmwareVersion(saveFirmwareRequest.getFirmwareVersion());
        firmware.setProductModelId(saveFirmwareRequest.getProductModelId());
        firmware.setFileId(saveFirmwareRequest.getFileId());
        firmware.setOperAccount(saveFirmwareRequest.getOperAccount());
        if (firmwareId != null) {
            this.firmwareDao.updateById(firmware);
        } else {
            this.firmwareDao.insert(firmware);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<List<String>> findByProductModelId(Integer productModelId) {
        List<Firmware> firmwares = this.firmwareDao.selectListByProductModelId(productModelId);
        if (CollectionUtil.isEmpty(firmwares)) {
            return ObjectResponse.failed((String)"404");
        }
        ArrayList firmwareVersionList = new ArrayList();
        firmwares.forEach(firmware -> firmwareVersionList.add(firmware.getFirmwareVersion()));
        return ObjectResponse.success(firmwareVersionList);
    }

    public ObjectResponse upgradeProgress(String taskId) {
        UpgradeProgressResponse progress = this.deviceUpgradeHandle.progress(taskId);
        if (progress == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)progress);
    }

    public ObjectResponse<ValidateVersionResponse> validateVersion(Integer productModelId, String firmwareVersion) {
        List<Firmware> firmwares = this.firmwareDao.selectListByVersion(productModelId, firmwareVersion);
        ValidateVersionResponse validateVersionResponse = new ValidateVersionResponse();
        if (CollectionUtil.isEmpty(firmwares)) {
            validateVersionResponse.setIsExist(Integer.valueOf(0));
        } else {
            validateVersionResponse.setIsExist(Integer.valueOf(1));
        }
        return ObjectResponse.success((Object)validateVersionResponse);
    }

    public ObjectResponse<ValidateUpgradeResponse> validateUpgrade(String sn) {
        if (sn == null) {
            return ObjectResponse.failed((String)"400");
        }
        ObjectResponse deviceObjectResponse = this.parkDeviceService.getDeviceBySerialNumber(sn);
        ObjectResponse.notError((Response)deviceObjectResponse);
        ValidateUpgradeResponse validateUpgradeResponse = new ValidateUpgradeResponse();
        validateUpgradeResponse.setIsUpgrade(Integer.valueOf(0));
        ParkDevice parkDevice = (ParkDevice)deviceObjectResponse.getData();
        String protocolVer = parkDevice.getProtocolVer();
        String productModel = parkDevice.getProductModel();
        if (parkDevice.getStatus() != 1 && parkDevice.getStatus() != 3) {
            validateUpgradeResponse.setReason("\u8bbe\u5907\u4e0d\u5728\u7ebf");
            return ObjectResponse.success((Object)validateUpgradeResponse);
        }
        if (protocolVer == null || productModel == null) {
            validateUpgradeResponse.setReason("\u672a\u77e5\u7684\u534f\u8bae\u7248\u672c\u53f7\u6216\u4ea7\u54c1\u578b\u53f7");
            return ObjectResponse.success((Object)validateUpgradeResponse);
        }
        if (P2cVersionEnum.getIndex((String)protocolVer) < P2cVersionEnum.\u7248\u672c7.getIndex()) {
            validateUpgradeResponse.setReason("\u534f\u8bae\u7248\u672c\u53f7\u8fc7\u4f4e");
            return ObjectResponse.success((Object)validateUpgradeResponse);
        }
        ObjectResponse objectResponse = this.dictionaryItemService.findOneItem(Integer.valueOf(8), productModel, null);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            validateUpgradeResponse.setReason("\u8bbe\u5907\u578b\u53f7\u672a\u5b9a\u4e49");
            return ObjectResponse.success((Object)validateUpgradeResponse);
        }
        DictionaryItemDto dictionaryItemDto = (DictionaryItemDto)objectResponse.getData();
        List<Firmware> firmwares = this.firmwareDao.selectListByProductModelId(dictionaryItemDto.getValue());
        if (CollectionUtil.isEmpty(firmwares)) {
            validateUpgradeResponse.setReason("\u8be5\u8bbe\u5907\u578b\u53f7\u7684\u56fa\u4ef6\u5305\u672a\u6dfb\u52a0");
            return ObjectResponse.success((Object)validateUpgradeResponse);
        }
        FirmwareUpgrade runningTask = this.firmwareUpgradeDao.selectTaskBySnAndStatus(sn, FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u4e2d.status);
        if (runningTask != null) {
            Date actionTime = runningTask.getActionTime();
            long now = DateTools.unixTimestamp();
            if (now - actionTime.getTime() / 1000L < 600L) {
                return ObjectResponse.failed((String)"402", (String)"\u5f53\u524d\u8bbe\u5907\u6b63\u5728\u5347\u7ea7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            }
        }
        validateUpgradeResponse.setIsUpgrade(Integer.valueOf(1));
        return ObjectResponse.success((Object)validateUpgradeResponse);
    }

    public ObjectResponse<List<SupportUpgradeDeviceResponse>> supportUpgradeDevice(List<DeviceListDTO> deviceListDTO) {
        ObjectResponse listByTypeId = this.dictionaryItemService.findListByTypeId(Integer.valueOf(8));
        if (!ObjectResponse.isSuccess((Response)listByTypeId)) {
            return ObjectResponse.failed((String)"402", (String)"\u672a\u5b9a\u4e49\u4ea7\u54c1\u578b\u53f7");
        }
        List dictionaryItemDtos = (List)listByTypeId.getData();
        Map<String, Integer> integerMap = dictionaryItemDtos.stream().collect(Collectors.toMap(DictionaryItemDto::getText, DictionaryItemDto::getValue));
        List<Integer> hasFirmwareModels = this.firmwareDao.selectAllProductModel();
        ArrayList list = new ArrayList();
        deviceListDTO.forEach(deviceDTO -> {
            SupportUpgradeDeviceResponse supportUpgradeDeviceResponse = new SupportUpgradeDeviceResponse();
            supportUpgradeDeviceResponse.setDeviceId(deviceDTO.getDeviceId());
            supportUpgradeDeviceResponse.setIsSupportUpgrade(Integer.valueOf(1));
            list.add(supportUpgradeDeviceResponse);
            String protocolVer = deviceDTO.getProtocolVer();
            String productModel = deviceDTO.getProductModel();
            if (deviceDTO.getDeviceStatus() != 1 && deviceDTO.getDeviceStatus() != 3) {
                supportUpgradeDeviceResponse.setIsSupportUpgrade(Integer.valueOf(0));
                supportUpgradeDeviceResponse.setReason("\u8bbe\u5907\u4e0d\u5728\u7ebf");
                return;
            }
            if (protocolVer == null || productModel == null) {
                supportUpgradeDeviceResponse.setIsSupportUpgrade(Integer.valueOf(0));
                supportUpgradeDeviceResponse.setReason("\u672a\u77e5\u7684\u534f\u8bae\u7248\u672c\u53f7\u6216\u4ea7\u54c1\u578b\u53f7");
                return;
            }
            if (P2cVersionEnum.getIndex((String)protocolVer) < P2cVersionEnum.\u7248\u672c7.getIndex()) {
                supportUpgradeDeviceResponse.setIsSupportUpgrade(Integer.valueOf(0));
                supportUpgradeDeviceResponse.setReason("\u534f\u8bae\u7248\u672c\u53f7\u8fc7\u4f4e");
                return;
            }
            if (CollectionUtil.isEmpty((Collection)hasFirmwareModels) || !hasFirmwareModels.contains(integerMap.get(productModel))) {
                supportUpgradeDeviceResponse.setIsSupportUpgrade(Integer.valueOf(0));
                supportUpgradeDeviceResponse.setReason("\u8be5\u8bbe\u5907\u578b\u53f7\u7684\u56fa\u4ef6\u5305\u672a\u6dfb\u52a0");
                return;
            }
        });
        return ObjectResponse.success(list);
    }

    public ObjectResponse reUpgrade(String taskId) {
        FirmwareUpgrade firmwareUpgrade = this.firmwareUpgradeDao.selectByTaskId(taskId);
        if (firmwareUpgrade == null) {
            return ObjectResponse.failed((String)"404");
        }
        UpgradeRequest upgradeRequest = new UpgradeRequest();
        upgradeRequest.setTaskId(taskId);
        upgradeRequest.setNewFirmwareVer(firmwareUpgrade.getTargetVer());
        upgradeRequest.setSendTime(Long.valueOf(DateTools.unixTimestamp()));
        File file = (File)this.fileDao.selectById(firmwareUpgrade.getFileId());
        upgradeRequest.setFirmwarePath(file.getFilePath());
        upgradeRequest.setFirmwareSize(String.valueOf(file.getFileSize()));
        upgradeRequest.setUpgradeChannel(firmwareUpgrade.getUpgradeChannel());
        try {
            this.upgradeService.execute(upgradeRequest, firmwareUpgrade.getSn(), firmwareUpgrade.getParkId());
        }
        catch (ResponseBodyException re) {
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Page<UpgradeLogListResponse>> upgradeLogList(UpgradeLogListRequest upgradeLogListRequest) {
        PageHelper.startPage((int)upgradeLogListRequest.getPageNo(), (int)upgradeLogListRequest.getPageSize());
        List<FirmwareUpgradeListDTO> firmwareUpgradeListDTOS = this.firmwareUpgradeDao.selectListByParam(upgradeLogListRequest.getParkIdList(), upgradeLogListRequest.getSn(), upgradeLogListRequest.getTaskStatus(), upgradeLogListRequest.getStartActionTime(), upgradeLogListRequest.getEndActionTime());
        if (CollectionUtil.isEmpty(firmwareUpgradeListDTOS)) {
            return ObjectResponse.failed((String)"404");
        }
        PageInfo pageInfo = new PageInfo(firmwareUpgradeListDTOS);
        ArrayList list = new ArrayList();
        firmwareUpgradeListDTOS.forEach(dto -> {
            UpgradeLogListResponse upgradeLogListResponse = new UpgradeLogListResponse();
            BeanUtil.copyProperties((Object)dto, (Object)upgradeLogListResponse, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
            list.add(upgradeLogListResponse);
        });
        Page page = new Page();
        page.setTotalPage(Integer.valueOf(pageInfo.getPages()));
        page.setTotal(Long.valueOf(pageInfo.getTotal()));
        page.setRows(list);
        return ObjectResponse.success((Object)page);
    }
}

